package cn.gtmap.landtax.web.sjwh;

import cn.gtmap.landtax.printexcel.access.ExcelBean;

import javax.persistence.Query;
import javax.servlet.http.HttpServletRequest;

import cn.gtmap.landtax.entity.*;
import cn.gtmap.landtax.model.dictionary.*;
import cn.gtmap.landtax.model.query.GdzysQuery;
import cn.gtmap.landtax.model.query.SbZsQuery;
import cn.gtmap.landtax.model.query.SwDjQsQuery;
import cn.gtmap.landtax.model.query.SwDjSyQuery;
import cn.gtmap.landtax.print.XMLBuildHelper;
import cn.gtmap.landtax.service.*;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.support.spring.BaseController;
import cn.gtmap.landtax.util.CommonUtil;
import cn.gtmap.landtax.util.IPlatUtil;
import cn.gtmap.landtax.util.ObjectValueManager;
import cn.gtmap.landtax.util.PlatUtil;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfActivityVo;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.util.*;
import java.util.List;
import java.util.Map;

/**
 * .
 * <p/>
 * 税源修改管理
 *
 * @author yang
 * @version V1.0, 14-5-26
 */
@Controller
@RequestMapping("/syxg")
public class SyxgController {
    @Autowired
    TaxService taxService;
    @Autowired
    SyxgService syxgService;
    @Autowired
    SwdjSyTempService swdjSyTempService;
    @Autowired
    SwdjSyHisService swdjSyHisService;
    @Autowired
    ZdService zdService;
    @Autowired
    SysUserService sysUserService;
    @Autowired
    SwDjQsService swDjQsService;
    @Autowired
    GdzysService gdzysService;
    @Autowired
    DwxxService dwxxService;
    @Autowired
    BaseRepository baseRepository;
    @Autowired
    HcxmService hcxmService;
    @Autowired
    IPlatUtil platUtil;
    @Autowired
    HashMap hcjdConfigMap;
    @Autowired
    ZdhcService zdhcService;

    @RequestMapping("/spb")
    public String spb(Model model,String proid) {
        List<SwDjSyHis> swDjSyHisList = syxgService.getSwDjSyHisListByRwid(proid);
        SwDjSyHis swDjSyHis=null;
        if(CollectionUtils.isNotEmpty(swDjSyHisList)){
            swDjSyHis = swDjSyHisList.get(0);
        }else{
            swDjSyHis = new SwDjSyHis();
        }
        String userId = swDjSyHis.getUserid();
        PfUserVo pfUserVo = sysUserService.getUserVo(userId);
        String username = pfUserVo.getUserName();
        //确认当前流程在哪个节点，限制用户签名
        String taskId = PlatUtil.getTaskIdByProid(proid);
        String activiId = this.platUtil.getPfActivityIdByTaskId(taskId);
        PfActivityVo vo = this.platUtil.getActivityInfo(activiId);
        //获取到proid,到pf_assignment,得到ASSIGNMENT_ID,到PF_ACTIVITY获取到ACTIVITY_ID，再到pf_workflow_instance获取到WORKFLOW_INSTANCE_ID，再到PF_WORKFLOW_DEFINITION表中，获取到WORKFLOW_DEFINITION_ID
//        String sql = "select ACTIVITY_ID from pf_assignment where ASSIGNMENT_ID ='"+proid+"'";
//        String ACTIVITY_ID = String.valueOf(baseRepository.getEntityManager().createNativeQuery(sql).getSingleResult());
//        String sql1 = "select WORKFLOW_INSTANCE_ID from PF_ACTIVITY where ACTIVITY_ID ='"+ACTIVITY_ID+"'";
//        String WORKFLOW_INSTANCE_ID = String.valueOf(baseRepository.getEntityManager().createNativeQuery(sql1).getSingleResult());
        String sql11 = "select WORKFLOW_DEFINITION_ID from pf_workflow_instance where pro_id ='"+proid+"'";
        String WORKFLOW_DEFINITION_ID = String.valueOf(baseRepository.getEntityManager().createNativeQuery(sql11).getSingleResult());
        String[] configArr={};
        String workflowDefinId_SYSJ = AppConfig.getProperty("sysj");
        String workflowDefinId_GDZYSSJ = AppConfig.getProperty("gdzyssj");
        if(workflowDefinId_SYSJ.equals(WORKFLOW_DEFINITION_ID)){
            configArr = (String[]) hcjdConfigMap.get(Hcxmlx.SYSJ.toString());
        }else if(workflowDefinId_GDZYSSJ.equals(WORKFLOW_DEFINITION_ID)){
            configArr = (String[]) hcjdConfigMap.get(Hcxmlx.GDZYSSJ.toString());
        }
        //key：活动定义ID， map：活动定义顺序
        Map<String, Integer> activityDefinitionMap = new HashMap<String, Integer>();
        int i = 0;
        for(String activityDefinitionId : configArr){
            i++;
            activityDefinitionMap.put(activityDefinitionId, i);
        }
        //税管员签名
        model.addAttribute("signdisable1", "true");
        //分局长签名
        model.addAttribute("signdisable2", "true");
        if (vo!=null&&activityDefinitionMap.containsKey(vo.getActivityDefinitionId())) {
            int sequence = activityDefinitionMap.get(vo.getActivityDefinitionId());
            model.addAttribute("signdisable" + sequence, "false");
        }
        model.addAttribute("username",username);
        model.addAttribute("swDjSyHis",swDjSyHis);
        return "landtax/sjwh/syxgSpb";
    }

    @RequestMapping("/spb/save")
    @ResponseBody
    public Object saveSpb(Model model,SwDjSyHis swDjSyHis) {
        ResponseMessage responseMessage = new ResponseMessage();
        try {
            SwDjSyHis oldSwDjSyHis = syxgService.getSwDjSyHis(swDjSyHis.getSyhisId());
            oldSwDjSyHis.setXgyy(swDjSyHis.getXgyy());
            //oldSwDjSyHis.setCzlx(swDjSyHis.getCzlx());
            syxgService.saveSwDjSyHis(oldSwDjSyHis);
            responseMessage.setMsg("保存成功");
        }catch (Exception e){
            e.printStackTrace();
            responseMessage.setMsg("出现异常，保存失败");
        }

        return responseMessage;
    }
    @RequestMapping("printSyxgSpb")
    @ResponseBody
    public void printSyscSpb(Model model,HttpServletRequest request,HttpServletResponse response,String syhisId,String proid) throws  Exception{
        XMLBuildHelper xmlBuildHelper = new XMLBuildHelper();
        StringBuilder xml = new StringBuilder();
        SwDjSyHis swDjSyHis = syxgService.getSwDjSyHis(syhisId);
        if(swDjSyHis==null){
            swDjSyHis = new SwDjSyHis();
        }
        String czlx = swDjSyHis.getCzlx();
        czlx = Czlx.getMcByDm(czlx);
        swDjSyHis.setCzlx(czlx);
        xml.append(xmlBuildHelper.voToXml(swDjSyHis));
//        xml.append("<data name=\"AP_FWZDMJ\" type=\"String\">");
//        xml.append((vo.getAP_LFMJ()==null?0:vo.getAP_LFMJ())+(vo.getAP_PFMJ()==null?0:vo.getAP_PFMJ()));
//        xml.append("</data>");
        HashMap<String, Boolean> keyMap = new HashMap<String, Boolean>();
        keyMap.put("sgsyj", false);
        keyMap.put("fgldyj", false);
        String userId = swDjSyHis.getUserid();
        PfUserVo user = sysUserService.getUserVo(userId);
        String username = "";
        try{
            username = user.getUserName();
        }catch (Exception e){
        }

        xml.append("<data name=\"USERNAME\" type=\"String\">");
        xml.append(username);
        xml.append("</data>");
        xml.append(xmlBuildHelper.getSignToXml(proid, request, keyMap));//根据id，进入平台库，查找相应的信息，组织参数，存入xml中

        String res=xmlBuildHelper.getPrintXml(xml.toString());
        response.setContentType("text/xml; charset=GBK");
        PrintWriter out = response.getWriter();
        out.write(res);
        out.flush();
        out.close();
    }

    @RequestMapping("/syxx")
    public String syxx(Model model,String proid)throws Exception{
        String userId = SessionUtil.getCurrentUserId();
        String remark=sysUserService.getUserVo(userId).getRemark();
        String canXg="";
        if(StringUtils.isNotBlank(remark)&&remark.indexOf("swy")>=0){
            canXg="1";
        }
        model.addAttribute("canXg",canXg);
        String hydm_level = AppConfig.getProperty("HYDM_LEVELS");
        model.addAttribute("hydm_level",hydm_level);
        //加载税源种类
        Map<String,Boolean> taxTypeConf =CommonUtil.getSyTypes();
        model.addAttribute("taxTypeConf",taxTypeConf);
        model.addAttribute(ObjectValueManager.LOAD_FCS,taxTypeConf.get(ObjectValueManager.LOAD_FCS)?"true":"false");

        if(hcxmService.isYbjByProid(proid)){//已办结
            model.addAttribute("isYbj","true");
        }else{
            model.addAttribute("isYbj","false");
        }

        List<SwDjSyTemp> list = swdjSyTempService.getSwDjSyTempListByRwid(proid);
        String hydm=null;
        if(CollectionUtils.isEmpty(list)){//说明是第一次修改
            SwDjSyHis swDjSyHis = syxgService.getSwDjSyHisListByRwid(proid).get(0);
            SwDjSy swDjSy = swDjSyHis.getSwDjSy();
            String tdId = "";
            String fcId = "";
            if(swDjSy.getSwDjTd()!=null){
                tdId = swDjSy.getSwDjTd().getTdId();
            }
            if(swDjSy.getSwDjFc()!=null){
                fcId = swDjSy.getSwDjFc().getFcId();
            }
            SwDjSyQuery syxx = taxService.getSwDjSyById(tdId,fcId);
            String djh = syxx.getDjh();
            if(StringUtils.isNotBlank(djh)){
                List tddjList = taxService.getTddjByDjhLike(djh);
                model.addAttribute("tddjList",tddjList);
            }
            Zd zd = zdService.findZdByDjh(djh);
            model.addAttribute("zd",zd);
            model.addAttribute("syxx",syxx);
            hydm=syxx.getHyDm();
        }else{//说明之前修改过
            SwDjSyTemp swDjSyTemp = list.get(0);
            String djh = swDjSyTemp.getDjh();
            if(StringUtils.isNotBlank(djh)){
                List tddjList = taxService.getTddjByDjhLike(djh);
                model.addAttribute("tddjList",tddjList);
            }
            Zd zd = zdService.findZdByDjh(djh);
            model.addAttribute("zd",zd);
            model.addAttribute("syxx",swDjSyTemp);
            hydm=swDjSyTemp.getHyDm();

        }
        if(StringUtils.isNotEmpty(hydm)){
            List hydl=taxService.getHydl(hydm);
            Object hydmdl=hydl.get(0);
            model.addAttribute("hydl",hydmdl);
            if(hydm.length()>3){
                List hyzl=taxService.getHyzl(hydm);
                Object hydmzl=hyzl.get(0);
                model.addAttribute("hyzl",hydmzl);
            }

        }
        model.addAttribute("proid",proid);

        //税源编辑-纳税人基本信息修改是否打开控制
        String is_open_nsrxx_xg = AppConfig.getProperty("IS_OPEN_NSRXX_XG");
        model.addAttribute("is_open_nsrxx_xg",is_open_nsrxx_xg);

        return "landtax/sjwh/syxgSyxx";
    }

    @RequestMapping("/syxggk")
    public String syxggk(Model model,String proid) throws Exception{
        //历史信息
        List<SwDjSyHis> swDjSyHisList =  swdjSyHisService.getSwDjSyHisByRwid(proid);
        SwDjSyHis swDjSyHis = new SwDjSyHis();
        if(CollectionUtils.isNotEmpty(swDjSyHisList)){
            swDjSyHis = swDjSyHisList.get(0);
            if(StringUtils.isNotBlank(swDjSyHis.getTdSgztDm()) && StringUtils.isBlank(swDjSyHis.getTdSgztMc())){
                swDjSyHis.setTdSgztMc(Sgzt.getMcByDm(swDjSyHis.getTdSgztDm()));
            }
        }
        model.addAttribute("swDjSyHis",swDjSyHis);
        //本次修改信息
        List<SwDjSyTemp> list = swdjSyTempService.getSwDjSyTempListByRwid(proid);
        SwDjSyTemp swDjSyTemp = new SwDjSyTemp();
        String sgztMc = "";
        if(CollectionUtils.isNotEmpty(list)){
            swDjSyTemp = list.get(0);
            String sgztDm = swDjSyTemp.getSgztDm();
            sgztMc = Sgzt.getMcByDm(sgztDm);

        }
        //计算差值
        BigDecimal ynmjCz = (swDjSyTemp.getYnmj()==null?BigDecimal.ZERO:swDjSyTemp.getYnmj()).subtract(swDjSyHis.getTdYnmj()==null?BigDecimal.ZERO:swDjSyHis.getTdYnmj());
        BigDecimal nynseTdCz = (swDjSyTemp.getNynseTd()==null?BigDecimal.ZERO:swDjSyTemp.getNynseTd()).subtract(swDjSyHis.getTdNynse()==null?BigDecimal.ZERO:swDjSyHis.getTdNynse());
        BigDecimal fcyzYsCz = (swDjSyHis.getFcFcyzYs()==null?BigDecimal.ZERO:swDjSyHis.getFcFcyzYs()).subtract(swDjSyTemp.getFcyzYs()==null?BigDecimal.ZERO:swDjSyTemp.getFcyzYs());
        BigDecimal fcynseZyCz = (swDjSyTemp.getYnseZy()==null?BigDecimal.ZERO:swDjSyTemp.getYnseZy()).subtract(swDjSyHis.getFcYnseZy()==null?BigDecimal.ZERO:swDjSyHis.getFcYnseZy());
        BigDecimal nzjCz = (swDjSyTemp.getNzj()==null?BigDecimal.ZERO:swDjSyTemp.getNzj()).subtract(swDjSyHis.getFcNzj()==null?BigDecimal.ZERO:swDjSyHis.getFcNzj());
        BigDecimal fcynseCzCz = (swDjSyTemp.getYnseCz()==null?BigDecimal.ZERO:swDjSyTemp.getYnseCz()).subtract(swDjSyHis.getFcYnseCz()==null?BigDecimal.ZERO:swDjSyHis.getFcYnseCz());
        BigDecimal fcnynseCz = (swDjSyTemp.getNynseFc()==null?BigDecimal.ZERO:swDjSyTemp.getNynseFc()).subtract(swDjSyHis.getFcNynse()==null?BigDecimal.ZERO:swDjSyHis.getFcNynse());
        Map czMap = new HashMap();
        czMap.put("ynmjCz",ynmjCz);
        czMap.put("nynseTdCz",nynseTdCz);
        czMap.put("fcyzYsCz",fcyzYsCz);
        czMap.put("fcynseZyCz",fcynseZyCz);
        czMap.put("nzjCz",nzjCz);
        czMap.put("fcynseCzCz",fcynseCzCz);
        czMap.put("fcnynseCz",fcnynseCz);

        //加载税源种类
        Map<String,Boolean> taxTypeConf = CommonUtil.getSyTypes();
        model.addAttribute("taxTypeConf",taxTypeConf);
        model.addAttribute(ObjectValueManager.LOAD_FCS,taxTypeConf.get(ObjectValueManager.LOAD_FCS)?"true":"false");
        model.addAttribute("czMap", czMap);
        model.addAttribute("xghSgztMc",sgztMc);
        model.addAttribute("swDjSyTemp",swDjSyTemp);
        return "landtax/sjwh/syxggk";
    }

    @RequestMapping("/syxggk_gdzys")
    public String syxggkGdzys(Model model,String proid) {
        //历史信息
        List<SwDjSyHis> swDjSyHisList =  swdjSyHisService.getSwDjSyHisByRwid(proid);
        SwDjSyHis swDjSyHis = new SwDjSyHis();
        if(CollectionUtils.isNotEmpty(swDjSyHisList)){
            swDjSyHis = swDjSyHisList.get(0);
            if(StringUtils.isNotBlank(swDjSyHis.getTdSgztDm()) && StringUtils.isBlank(swDjSyHis.getTdSgztMc())){
                swDjSyHis.setTdSgztMc(Sgzt.getMcByDm(swDjSyHis.getTdSgztDm()));
            }
        }
        model.addAttribute("swDjSyHis",swDjSyHis);
        //本次修改信息
        List<SwDjSyTemp> list = swdjSyTempService.getSwDjSyTempListByRwid(proid);
        SwDjSyTemp swDjSyTemp = new SwDjSyTemp();
        String sgztMc = "";
        if(CollectionUtils.isNotEmpty(list)){
            swDjSyTemp = list.get(0);
            String sgztDm = swDjSyTemp.getSgztDm();
            sgztMc = Sgzt.getMcByDm(sgztDm);

        }
        //计算差值
        BigDecimal ynseCz = (swDjSyTemp.getGdzysYnse()==null?BigDecimal.ZERO:swDjSyTemp.getGdzysYnse()).subtract(swDjSyHis.getGdzysYnse()==null?BigDecimal.ZERO:swDjSyHis.getGdzysYnse());
        BigDecimal yjneCz = (swDjSyTemp.getGdzysYjne()==null?BigDecimal.ZERO:swDjSyTemp.getGdzysYjne()).subtract(swDjSyHis.getGdzysYjne()==null?BigDecimal.ZERO:swDjSyHis.getGdzysYjne());
        BigDecimal jmseCz = (swDjSyTemp.getGdzysJmse()==null?BigDecimal.ZERO:swDjSyTemp.getGdzysJmse()).subtract(swDjSyHis.getGdzysJmse()==null?BigDecimal.ZERO:swDjSyHis.getGdzysJmse());
        BigDecimal xbjseCz = (swDjSyTemp.getGdzysXbjse()==null?BigDecimal.ZERO:swDjSyTemp.getGdzysXbjse()).subtract(swDjSyHis.getGdzysXbjse()==null?BigDecimal.ZERO:swDjSyHis.getGdzysXbjse());
        Map czMap = new HashMap();
        czMap.put("ynseCz",ynseCz);
        czMap.put("yjneCz",yjneCz);
        czMap.put("jmseCz",jmseCz);
        czMap.put("xbjseCz",xbjseCz);
        model.addAttribute("czMap", czMap);
        model.addAttribute("xghSgztMc",sgztMc);
        model.addAttribute("swDjSyTemp",swDjSyTemp);
        return "landtax/sjwh/syxggk_gdzys";
    }

    @RequestMapping("/qsxx")
    public String qsxx(Model model,String proid) {
        if(hcxmService.isYbjByProid(proid)){//已办结
            model.addAttribute("isYbj","true");
        }else{
            model.addAttribute("isYbj","false");
        }
        List<SwDjSyTemp> list = swdjSyTempService.getSwDjSyTempListByRwid(proid);

        String xmXzqdm = "";
        if(CollectionUtils.isEmpty(list)){//说明是第一次修改
            SwDjSyHis swDjSyHis = syxgService.getSwDjSyHisListByRwid(proid).get(0);
            SwDjSy swDjSy = swDjSyHis.getSwDjSy();
            String syId = "";
            syId = swDjSy.getSyId();
            SwDjSyQuery qsxx = swDjQsService.getQsBySyId(syId);
            xmXzqdm = qsxx.getXmXzqdm();
            model.addAttribute("qsxx",qsxx);
        }else{//说明之前修改过
            SwDjSyTemp swDjSyTemp = list.get(0);
            SwDjXmxx swDjXmxx = baseRepository.get(SwDjXmxx.class, swDjSyTemp.getGdId());
            SwDjSyQuery qsxx = new SwDjSyQuery();
            BeanUtils.copyProperties(swDjSyTemp, qsxx);
            BeanUtils.copyProperties(swDjXmxx, qsxx);
            xmXzqdm = qsxx.getXmXzqdm();
            model.addAttribute("qsxx",qsxx);
        }
        model.addAttribute("proid",proid);

        //初始化土地等级下拉框
        List tddjList = taxService.getTddjByXzqdm(xmXzqdm);
        model.addAttribute("tddjList",tddjList);

        return "landtax/sjwh/syxgQsxx";
    }

    @RequestMapping("/gdzysxx")
    public String gdzysxx(Model model,String proid) {
        if(hcxmService.isYbjByProid(proid)){//已办结
            model.addAttribute("isYbj","true");
        }else{
            model.addAttribute("isYbj","false");
        }
        List<SwDjSyTemp> list = swdjSyTempService.getSwDjSyTempListByRwid(proid);

        if(CollectionUtils.isEmpty(list)){//说明是第一次修改
            SwDjSyHis swDjSyHis = syxgService.getSwDjSyHisListByRwid(proid).get(0);
            SwDjSy swDjSy = swDjSyHis.getSwDjSy();
            String syId = "";
            syId = swDjSy.getSyId();
            GdzysQuery pcxx = gdzysService.findGdzysqueryBySyId(syId);
            model.addAttribute("pcxx", pcxx);
        }else{//说明之前修改过
            SwDjSyTemp swDjSyTemp = list.get(0);
            SwDjPcxx swDjPcxx = baseRepository.get(SwDjPcxx.class, swDjSyTemp.getBpId());
            SwDjSyQuery pcxx = new SwDjSyQuery();
            BeanUtils.copyProperties(swDjSyTemp, pcxx);
            BeanUtils.copyProperties(swDjPcxx, pcxx);
            model.addAttribute("pcxx", pcxx);
        }
        model.addAttribute("proid",proid);

        return "landtax/sjwh/syxgGdzysxx";
    }

    @RequestMapping("/syxx/save")
    @ResponseBody
    public Object saveSyxx(Model model,SwDjSyTemp swDjSyTemp) {
        ResponseMessage responseMessage = new ResponseMessage();
        try{
            swdjSyTempService.saveSwDjSyTemp(swDjSyTemp);
            responseMessage.setMsg("保存成功");
        }catch (Exception e){
            e.printStackTrace();
            responseMessage.setMsg("出现异常，保存失败");
        }
        return responseMessage;

    }

    /**
     * 工作流办结事件
     * @param model
     * @param proid
     * @return
     * @throws Exception
     */
    @RequestMapping("/syxx/commit")
    @ResponseBody
    public void commitSyxg(Model model,String proid,HttpServletResponse response) throws  Exception {
        List signList = taxService.getUserSign(proid);
        String msg = "";
        if (signList.size() < 1) {
            msg = "尚未签字确认不能办结！";
            response.setContentType("text/html;charset=GBK");
            PrintWriter out = response.getWriter();
            out.println(msg);
        } else {


            List<SwDjSyTemp> list = swdjSyTempService.getSwDjSyTempListByRwid(proid);
            SwDjSyQuery swDjSyQuery = new SwDjSyQuery();
            SwDjSyHis swDjSyHis1 = new SwDjSyHis();
            if (CollectionUtils.isNotEmpty(list)) {
                SwDjSyHis swDjSyHis = syxgService.getSwDjSyHisListByRwid(proid).get(0);
                SwDjSyTemp swDjSyTemp = list.get(0);
                swDjSyHis.setUpdateDate(Calendar.getInstance().getTime());
                swDjSyHis.setSyhisId(UUIDGenerator.generate());
                swDjSyHis.setTdTdzl(swDjSyTemp.getTdzl());
                swDjSyHis.setTdYnmj(swDjSyTemp.getYnmj());
                swDjSyHis.setTdDwse(swDjSyTemp.getDwse());
                swDjSyHis.setTdNynse(swDjSyTemp.getNynseTd());
                swDjSyHis.setTdTddj(swDjSyTemp.getTddj());
                swDjSyHis.setTdTdsyzh(swDjSyTemp.getTdsyzh());
                swDjSyHis.setTdBz(swDjSyTemp.getBz());
                swDjSyHis.setTdCzrmc(swDjSyTemp.getCzrmc());
                swDjSyHis.setTdCzrzjhm(swDjSyTemp.getCzrzjhm());
                swDjSyHis.setTdMsmj(swDjSyTemp.getMsmj());
                swDjSyHis.setTdFzmj(swDjSyTemp.getFzmj());
                swDjSyHis.setTdScmj(swDjSyTemp.getScmj());
                swDjSyHis.setTdTdsyztDm(swDjSyTemp.getTdsyztDm());
                swDjSyHis.setGtzdbyzyy(swDjSyTemp.getGtzdbyzyy());
                swDjSyHis.setTdSgztDm(swDjSyTemp.getSgztDm());
                swDjSyHis.setTdSgztMc(Sgzt.getMcByDm(swDjSyTemp.getSgztDm()));
                swDjSyHis.setTdZdsybz(swDjSyTemp.getZdsybz());
                swDjSyHis.setTdMsbz(swDjSyTemp.getMsbz());

                swDjSyHis.setFcFcyz(swDjSyTemp.getFcyz());
                swDjSyHis.setFcSl(swDjSyTemp.getSl());
                swDjSyHis.setFcNzj(swDjSyTemp.getNzj());
                swDjSyHis.setFcZjSl(swDjSyTemp.getSl());
                swDjSyHis.setFcYnse(swDjSyTemp.getNynseFc());
                swDjSyHis.setFcFcyzMs(swDjSyTemp.getFcyzMs());
                swDjSyHis.setFcNynse(swDjSyTemp.getNynseFc());
                swDjSyHis.setFcFczh(swDjSyTemp.getFczh());
                swDjSyHis.setFcCzrmc(swDjSyTemp.getCzrmc());
                swDjSyHis.setFcCzrzjhm(swDjSyTemp.getCzrzjhm());
                swDjSyHis.setFcFcyzYs(swDjSyTemp.getFcyzYs());
                swDjSyHis.setFcFczl(swDjSyTemp.getFczl());
                swDjSyHis.setFcBz(swDjSyTemp.getBz());
                swDjSyHis.setFcFwjz(swDjSyTemp.getFwjz());
                swDjSyHis.setFcTdjz(swDjSyTemp.getTdjz());
                swDjSyHis.setFcFssbjz(swDjSyTemp.getFssbjz());
                swDjSyHis.setFcFcmj(swDjSyTemp.getFcmj());
                swDjSyHis.setFcYnseZy(swDjSyTemp.getYnseZy());
                swDjSyHis.setFcYnseCz(swDjSyTemp.getYnseCz());
                swDjSyHis.setFcFwxzDm(swDjSyTemp.getFwxzDm());
                swDjSyHis.setFcZyhczDm(swDjSyTemp.getZyhczDm());
                swDjSyHis.setFcSgztDm(swDjSyTemp.getSgztDm());
                swDjSyHis.setFcSgztMc(Sgzt.getMcByDm(swDjSyTemp.getSgztDm()));
                swDjSyHis.setFcZdsybz(swDjSyTemp.getZdsybz());
                swDjSyHis.setFcMsbz(swDjSyTemp.getMsbz());
                BeanUtils.copyProperties(swDjSyHis, swDjSyHis1);
                BeanUtils.copyProperties(list.get(0), swDjSyQuery);

            } else {//说明只是创建了修改流程，但是并没有修改，保存，直接转发下去
                SwDjSyHis swDjSyHis = syxgService.getSwDjSyHisListByRwid(proid).get(0);
                SwDjSy swDjSy = swDjSyHis.getSwDjSy();
                String tdId = "";
                String fcId = "";
                if (swDjSy.getSwDjTd() != null) {
                    tdId = swDjSy.getSwDjTd().getTdId();
                }
                if (swDjSy.getSwDjFc() != null) {
                    fcId = swDjSy.getSwDjFc().getFcId();
                }
                swDjSyQuery = taxService.getSwDjSyById(tdId, fcId);
                swDjSyHis.setUpdateDate(Calendar.getInstance().getTime());
                swDjSyHis.setSyhisId(UUIDGenerator.generate());
                BeanUtils.copyProperties(swDjSyHis, swDjSyHis1);
            }
            swdjSyHisService.saveSwDjHis(swDjSyHis1);
            taxService.saveSwDjSyQuery(swDjSyQuery, Syzt.ZC.toString());
        }
    }

    @RequestMapping("/syxx/commitQs")
    @ResponseBody
    public String commitSyxgQs(Model model,String proid) throws  Exception{
        List<SwDjSyTemp> list = swdjSyTempService.getSwDjSyTempListByRwid(proid);
        SwDjSyQuery swDjSyQuery = new SwDjSyQuery();
        SwDjSyHis swDjSyHis1=new SwDjSyHis();
        if(CollectionUtils.isNotEmpty(list)){
            SwDjSyHis swDjSyHis = syxgService.getSwDjSyHisListByRwid(proid).get(0);
            SwDjSyTemp swDjSyTemp=list.get(0);
            swDjSyHis.setUpdateDate(Calendar.getInstance().getTime());
            swDjSyHis.setSyhisId(UUIDGenerator.generate());
            swDjSyHis.setQsId(swDjSyTemp.getQsId());
            swDjSyHis.setQsSzly(swDjSyTemp.getQsSzly());
            swDjSyHis.setQsYnse(swDjSyTemp.getQsYnse());
            swDjSyHis.setQsYjne(swDjSyTemp.getQsYjne());
            swDjSyHis.setQsJmxz(swDjSyTemp.getQsJmxz());
            swDjSyHis.setQsJmse(swDjSyTemp.getQsJmse());
            swDjSyHis.setQsJspz(swDjSyTemp.getQsJspz());
            swDjSyHis.setQsXbjse(swDjSyTemp.getQsXbjse());
            swDjSyHis.setQsBz(swDjSyTemp.getQsBz());
            swDjSyHis.setQsLrrq(swDjSyTemp.getQsLrrq());
            swDjSyHis.setQsHclx(swDjSyTemp.getQsHclx());
            BeanUtils.copyProperties(swDjSyHis, swDjSyHis1);
            BeanUtils.copyProperties(list.get(0),swDjSyQuery);
        }else{//说明只是创建了修改流程，但是并没有修改，保存，直接转发下去
            SwDjSyHis swDjSyHis = syxgService.getSwDjSyHisListByRwid(proid).get(0);
            SwDjSy swDjSy = swDjSyHis.getSwDjSy();
            String syId = "";
            syId = swDjSy.getSyId();
            swDjSyQuery = taxService.getSwDjSyBySyId(syId);
            swDjSyHis.setUpdateDate(Calendar.getInstance().getTime());
            swDjSyHis.setSyhisId(UUIDGenerator.generate());
            BeanUtils.copyProperties(swDjSyHis, swDjSyHis1);
        }
        swdjSyHisService.saveSwDjHis(swDjSyHis1);
        swDjSyQuery.setSyzt(Syzt.ZC.toString());
        swDjSyQuery.setXmId(swDjSyQuery.getGdId());
        swDjQsService.SaveQs(swDjSyQuery);
        return "";
    }

    @RequestMapping("/syxx/commitGdzys")
    @ResponseBody
    public String commitSyxgGdzys(Model model,String proid) throws  Exception{
        List<SwDjSyTemp> list = swdjSyTempService.getSwDjSyTempListByRwid(proid);
        SwDjSyQuery swDjSyQuery = new SwDjSyQuery();
        SwDjSyHis swDjSyHis1=new SwDjSyHis();
        if(CollectionUtils.isNotEmpty(list)){
            SwDjSyHis swDjSyHis = syxgService.getSwDjSyHisListByRwid(proid).get(0);
            SwDjSyTemp swDjSyTemp=list.get(0);
            swDjSyHis.setUpdateDate(Calendar.getInstance().getTime());
            swDjSyHis.setSyhisId(UUIDGenerator.generate());
            swDjSyHis.setGdzysId(swDjSyTemp.getGdzysId());
            swDjSyHis.setGdzysSzly(swDjSyTemp.getGdzysSzly());
            swDjSyHis.setGdzysYnse(swDjSyTemp.getGdzysYnse());
            swDjSyHis.setGdzysDwse(swDjSyTemp.getGdzysDwse());
            swDjSyHis.setGdzysJmxz(swDjSyTemp.getGdzysJmxz());
            swDjSyHis.setGdzysJspz(swDjSyTemp.getGdzysJspz());
            swDjSyHis.setGdzysJmse(swDjSyTemp.getGdzysJmse());
            swDjSyHis.setGdzysYjne(swDjSyTemp.getGdzysYjne());
            swDjSyHis.setGdzysXbjse(swDjSyTemp.getGdzysXbjse());
            swDjSyHis.setGdzysBz(swDjSyTemp.getGdzysBz());
            swDjSyHis.setGdzysLrrq(swDjSyTemp.getGdzysLrrq());
            swDjSyHis.setGdzysHclx(swDjSyTemp.getGdzysHclx());
            BeanUtils.copyProperties(swDjSyHis, swDjSyHis1);
            BeanUtils.copyProperties(list.get(0),swDjSyQuery);
        }else{//说明只是创建了修改流程，但是并没有修改，保存，直接转发下去
            SwDjSyHis swDjSyHis = syxgService.getSwDjSyHisListByRwid(proid).get(0);
            SwDjSy swDjSy = swDjSyHis.getSwDjSy();
            String syId = "";
            syId = swDjSy.getSyId();
            swDjSyQuery = taxService.getSwDjSyBySyId(syId);
            swDjSyHis.setUpdateDate(Calendar.getInstance().getTime());
            swDjSyHis.setSyhisId(UUIDGenerator.generate());
            BeanUtils.copyProperties(swDjSyHis, swDjSyHis1);
        }
        swdjSyHisService.saveSwDjHis(swDjSyHis1);
        GdzysQuery gdzysQuery = new GdzysQuery();
        BeanUtils.copyProperties(swDjSyQuery, gdzysQuery);
        gdzysQuery.setSyzt(Syzt.ZC.toString());
        gdzysQuery.setPcId(gdzysQuery.getBpId());
        gdzysService.SaveGdzys(gdzysQuery);
        return "";
    }

    /**
     * 工作流删除事件
     * @param model
     * @param proid
     * @return
     */
    @RequestMapping("/syxx/del")
    @ResponseBody
    public String delSyxg(Model model,String proid) {
        //删除sw_dj_sy_his表数据
        //删除sw_dj_sy_temp表数据
        syxgService.del(proid);
        return "";
    }

    @RequestMapping("/syxx/delQs")
    @ResponseBody
    public String delSyxgQs(Model model,String proid) {
        //删除sw_dj_sy_his表数据
        //删除sw_dj_sy_temp表数据
        syxgService.del(proid);
        return "";
    }

    @RequestMapping("/syxx/delGdzys")
    @ResponseBody
    public String delSyxgGdzys(Model model,String proid) {
        //删除sw_dj_sy_his表数据
        //删除sw_dj_sy_temp表数据
        syxgService.del(proid);
        return "";
    }

    @RequestMapping("/workflow")
    @ResponseBody
    public Object createSyxgWorkflow(Model model,String syId){
        try{
            return syxgService.createSyxgWorkflow(syId);
        }catch (Exception e){
            return null;
        }

    }

    @RequestMapping("/workflowQs")
    @ResponseBody
    public Object createSyxgWorkflowQs(Model model,String syId){
        try{
            return syxgService.createSyxgWorkflowQs(syId);
        }catch (Exception e){
            return null;
        }

    }

    @RequestMapping("/workflowGdzys")
    @ResponseBody
    public Object createSyxgWorkflowGdzys(Model model,String syId,String pcId){
        try{
            return syxgService.createSyxgWorkflowGdzys(syId,pcId);
        }catch (Exception e){
            return null;
        }

    }


    private SwDjSyHis mergeSwDjSyHis(SwDjSyHis newSwDjSyHis,SwDjSyHis oldSwDjSyHis){
        newSwDjSyHis.setDjh(oldSwDjSyHis.getDjh());
        newSwDjSyHis.setDbh(oldSwDjSyHis.getDbh());
        newSwDjSyHis.setSwDjSy(oldSwDjSyHis.getSwDjSy());
        newSwDjSyHis.setXgyy(oldSwDjSyHis.getXgyy());
        newSwDjSyHis.setXgrq(oldSwDjSyHis.getXgrq());
        newSwDjSyHis.setUserid(oldSwDjSyHis.getUserid());
        newSwDjSyHis.setCzlx(oldSwDjSyHis.getCzlx());
        return newSwDjSyHis;
    }


    @RequestMapping("syxgxxList")
    public String syxgxxList(Model model)throws Exception{
        //获取所有区县信息
        List<SDmDwxxCz> allQxList = dwxxService.getAllQxList();
        model.addAttribute("allQxList",allQxList);
        String qxdm = dwxxService.getUserQxDm();
        if (StringUtils.isNotEmpty(qxdm)) {
            model.addAttribute("qxdm",qxdm);
        }
        //加载税源种类
        Map<String,Boolean> taxTypeConf = CommonUtil.getSyTypes();
        model.addAttribute("taxTypeConf",taxTypeConf);
        return "landtax/sjwh/syxgxxList";
    }
    @RequestMapping("syxgxxListJson")
    @ResponseBody
    public Object syxgxxListJson(Model model,Pageable pageable,SwDjSyQuery swDjSyQuery, String sylx) {
        String qxdm = dwxxService.getUserQxDm();
        if (StringUtils.isNotEmpty(qxdm)) {
            swDjSyQuery.setQx(qxdm);
        }
        return syxgService.getSyxgxxLsitJson(swDjSyQuery,pageable, sylx);
    }

    @RequestMapping("/syxggk_qs")
    public String syxggkQs(Model model,String proid) {
        //历史信息
        List<SwDjSyHis> swDjSyHisList =  swdjSyHisService.getSwDjSyHisByRwid(proid);
        SwDjSyHis swDjSyHis = new SwDjSyHis();
        if(CollectionUtils.isNotEmpty(swDjSyHisList)){
            swDjSyHis = swDjSyHisList.get(0);
            if(StringUtils.isNotBlank(swDjSyHis.getTdSgztDm()) && StringUtils.isBlank(swDjSyHis.getTdSgztMc())){
                swDjSyHis.setTdSgztMc(Sgzt.getMcByDm(swDjSyHis.getTdSgztDm()));
            }
        }
        model.addAttribute("swDjSyHis",swDjSyHis);
        //本次修改信息
        List<SwDjSyTemp> list = swdjSyTempService.getSwDjSyTempListByRwid(proid);
        SwDjSyTemp swDjSyTemp = new SwDjSyTemp();
        String sgztMc = "";
        if(CollectionUtils.isNotEmpty(list)){
            swDjSyTemp = list.get(0);
            String sgztDm = swDjSyTemp.getSgztDm();
            sgztMc = Sgzt.getMcByDm(sgztDm);

        }
        //计算差值
        BigDecimal ynmjCz = (swDjSyHis.getTdYnmj()==null?BigDecimal.ZERO:swDjSyHis.getTdYnmj()).subtract(swDjSyTemp.getYnmj()==null?BigDecimal.ZERO:swDjSyTemp.getYnmj());
        BigDecimal nynseTdCz = (swDjSyHis.getTdNynse()==null?BigDecimal.ZERO:swDjSyHis.getTdNynse()).subtract(swDjSyTemp.getNynseTd()==null?BigDecimal.ZERO:swDjSyTemp.getNynseTd());
        BigDecimal fcyzYsCz = (swDjSyHis.getFcFcyzYs()==null?BigDecimal.ZERO:swDjSyHis.getFcFcyzYs()).subtract(swDjSyTemp.getFcyzYs()==null?BigDecimal.ZERO:swDjSyTemp.getFcyzYs());
        BigDecimal fcynseZyCz = (swDjSyHis.getFcYnseZy()==null?BigDecimal.ZERO:swDjSyHis.getFcYnseZy()).subtract(swDjSyTemp.getYnseZy()==null?BigDecimal.ZERO:swDjSyTemp.getYnseZy());
        BigDecimal nzjCz = (swDjSyHis.getFcNzj()==null?BigDecimal.ZERO:swDjSyHis.getFcNzj()).subtract(swDjSyTemp.getNzj()==null?BigDecimal.ZERO:swDjSyTemp.getNzj());
        BigDecimal fcynseCzCz = (swDjSyHis.getFcYnseCz()==null?BigDecimal.ZERO:swDjSyHis.getFcYnseCz()).subtract(swDjSyTemp.getYnseCz()==null?BigDecimal.ZERO:swDjSyTemp.getYnseCz());
        BigDecimal fcnynseCz = (swDjSyHis.getFcNynse()==null?BigDecimal.ZERO:swDjSyHis.getFcNynse()).subtract(swDjSyTemp.getNynseFc()==null?BigDecimal.ZERO:swDjSyTemp.getNynseFc());
        BigDecimal ynseCz = (swDjSyHis.getQsYnse()==null?BigDecimal.ZERO:swDjSyHis.getQsYnse()).subtract(swDjSyTemp.getQsYnse()==null?BigDecimal.ZERO:swDjSyTemp.getQsYnse());
        BigDecimal jmseCz = (swDjSyHis.getQsJmse()==null?BigDecimal.ZERO:swDjSyHis.getQsJmse()).subtract(swDjSyTemp.getQsJmse()==null?BigDecimal.ZERO:swDjSyTemp.getQsJmse());
        BigDecimal yjneCz = (swDjSyHis.getQsYjne()==null?BigDecimal.ZERO:swDjSyHis.getQsYjne()).subtract(swDjSyTemp.getQsYjne()==null?BigDecimal.ZERO:swDjSyTemp.getQsYjne());
        BigDecimal xbjseCz = (swDjSyHis.getQsXbjse()==null?BigDecimal.ZERO:swDjSyHis.getQsXbjse()).subtract(swDjSyTemp.getQsXbjse()==null?BigDecimal.ZERO:swDjSyTemp.getQsXbjse());
        Map czMap = new HashMap();
        czMap.put("ynmjCz",ynmjCz);
        czMap.put("nynseTdCz",nynseTdCz);
        czMap.put("fcyzYsCz",fcyzYsCz);
        czMap.put("fcynseZyCz",fcynseZyCz);
        czMap.put("nzjCz",nzjCz);
        czMap.put("fcynseCzCz",fcynseCzCz);
        czMap.put("ynseCz",ynseCz);
        czMap.put("jmseCz",jmseCz);
        czMap.put("yjneCz",yjneCz);
        czMap.put("xbjseCz",xbjseCz);
        czMap.put("fcnynseCz",fcnynseCz);
        model.addAttribute("czMap", czMap);
        model.addAttribute("xghSgztMc",sgztMc);
        model.addAttribute("swDjSyTemp",swDjSyTemp);
        return "landtax/sjwh/syxggk_qs";
    }


    @RequestMapping("sybhls")
    public String sybhList(Model model) {

        return "landtax/sjwh/sybhlsTj";

    }

    @RequestMapping("zghlr")
    public String ZghInsertList(Model model) {

        return "landtax/sjwh/jszgh";

    }
    @RequestMapping("zghlrSj")
    public String ZghSjInsertList(Model model) {

        return "landtax/sjwh/jszghSj";

    }
    @RequestMapping("jszghJson")
    @ResponseBody
    public Object JsZghTj(Model model, HttpServletRequest request, SwDjSyQuery swDjSyQuery, Pageable pageable) {
        return taxService.findJsZgh(swDjSyQuery, pageable);

    }
    @RequestMapping("jszghSjJson")
    @ResponseBody
    public Object JsZghSjTj(Model model, HttpServletRequest request, SwDjSyQuery swDjSyQuery, Pageable pageable) {
        return taxService.findJsZghSj(swDjSyQuery,pageable);

    }

    @RequestMapping("updateZgh")
    @ResponseBody
    public Object updateZghList(Model model, HttpServletRequest request,String ZGH,String dwdm) {
        ResponseMessage responseMessage = new ResponseMessage();
        try {
            taxService.updateZgh(ZGH, dwdm);
            responseMessage.setMsg("更新成功");
        }catch (Exception e){
            e.printStackTrace();
            responseMessage.setMsg("出现异常，更新失败");
        }
        return responseMessage;
    }


    @RequestMapping("sybhJson")
    @ResponseBody
    public Object getSwdjSy(Model model, Pageable request, SwDjSyQuery swDjSyQuery) {
        return taxService.findSybhls(swDjSyQuery, request);

    }

    @RequestMapping("exportSyBhTz")
    public String exportExcelTz(HttpServletRequest request, SwDjSyQuery swDjSyQuery) throws Exception {

        try {

            List<HashMap<String, Object>> list = taxService.findSybhlsForExp(swDjSyQuery);
            List<String[]> retList = new ArrayList<String[]>();
            for (int i = 0; i < list.size(); i++) {
                String[] tempArr = new String[16];
                for (int j = 0; j < tempArr.length; j++) {
                    tempArr[j] = "";
                }

                tempArr[0] = String.valueOf(i + 1);
                tempArr[1] = String.valueOf(list.get(i).get("DJH"));
                tempArr[2] = String.valueOf(list.get(i).get("GLBM"));
                tempArr[3] = String.valueOf(list.get(i).get("NSRMC"));
                tempArr[4] =String.valueOf(list.get(i).get("SCMJ")) ;
                tempArr[5] = String.valueOf(list.get(i).get("MSMJ"));
                tempArr[6] = String.valueOf(list.get(i).get("YNMJ"));
                tempArr[7] = String.valueOf(list.get(i).get("NYNSE")) ;
                tempArr[8] = String.valueOf(list.get(i).get("FCYZ"));
                tempArr[9] =String.valueOf(list.get(i).get("CZFCYZ")) ;
                tempArr[10] =String.valueOf(list.get(i).get("MSFCYZ")) ;
                tempArr[11] =String.valueOf(list.get(i).get("YSFCYZ")) ;
                tempArr[12] = String.valueOf(list.get(i).get("NZJ"));
                tempArr[13] = String.valueOf(list.get(i).get("FCNYNSE")) ;
                tempArr[14] = String.valueOf(list.get(i).get("ZGKG_MC"));


                retList.add(tempArr);
            }

            String excelTemplate = "sybhtz.xls";
            String excelXml = "sybhtz.xml";


            HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
            ExcelBean eb = new ExcelBean();
            map.put("group1", retList);// 把retList放入group1中
            eb.setGroupMap(map);
            eb.setExcelTemplate(excelTemplate); //
            eb.setExcelXml(excelXml); // 上述两步骤是把xml文件和xls文件有机组合
            eb.printExcel(request);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }


    @RequestMapping("exportJsZghTz")
    public String exportExcelJsZghTz(HttpServletRequest request, SwDjSyQuery swDjSyQuery) throws Exception {

        try {

            List<HashMap<String, Object>> list = taxService.findZghForExp(swDjSyQuery);
            List<String[]> retList = new ArrayList<String[]>();
            for (int i = 0; i < list.size(); i++) {
                String[] tempArr = new String[3];
                for (int j = 0; j < tempArr.length; j++) {
                    tempArr[j] = "";
                }
                tempArr[0] = String.valueOf(i + 1);
                tempArr[1] = list.get(i).get("DWMC").toString();
                if (list.get(i).get("ZGH") == null) {
                    tempArr[2] = "";
                }else {
                    tempArr[2] = list.get(i).get("ZGH").toString();
                }
                retList.add(tempArr);
            }

            String excelTemplate = "jszghTz.xls";
            String excelXml = "jszghTz.xml";
            HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
            ExcelBean eb = new ExcelBean();
            map.put("group1", retList);// 把retList放入group1中
            eb.setGroupMap(map);
            eb.setExcelTemplate(excelTemplate); //
            eb.setExcelXml(excelXml); // 上述两步骤是把xml文件和xls文件有机组合
            eb.printExcel(request);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }
    @RequestMapping("exportJsZghSjTz")
    public String exportExcelJsZghSjTz(HttpServletRequest request, SwDjSyQuery swDjSyQuery) throws Exception {

        try {

            List<HashMap<String, Object>> list = taxService.findZghSjForExp(swDjSyQuery);
            List<String[]> retList = new ArrayList<String[]>();
            for (int i = 0; i < list.size(); i++) {
                String[] tempArr = new String[3];
                for (int j = 0; j < tempArr.length; j++) {
                    tempArr[j] = "";
                }
                tempArr[0] = String.valueOf(i + 1);
                tempArr[1] = list.get(i).get("DWMC").toString();
                if (list.get(i).get("ZGH") == null) {
                    tempArr[2] = "";
                }else {
                    tempArr[2] = list.get(i).get("ZGH").toString();
                }
                retList.add(tempArr);
            }

            String excelTemplate = "jszghTz.xls";
            String excelXml = "jszghTz.xml";
            HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
            ExcelBean eb = new ExcelBean();
            map.put("group1", retList);// 把retList放入group1中
            eb.setGroupMap(map);
            eb.setExcelTemplate(excelTemplate); //
            eb.setExcelXml(excelXml); // 上述两步骤是把xml文件和xls文件有机组合
            eb.printExcel(request);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }


    @RequestMapping("sysjjk")
    public String sysjjk(Model model) {

        return "landtax/sjwh/sysjjk";

    }


    @RequestMapping("syjkJson")
    @ResponseBody
    public Object sysjTj(Model model, HttpServletRequest request, SwDjSyQuery swDjSyQuery) {
        return taxService.sjbhTj(swDjSyQuery);

    }

    @RequestMapping("taxmap")
    public String getSwdjSyXxByMap(Model model, String syId, String syhisId, String djh, String noSave) throws Exception{
        Map<String,Boolean> taxTypeConf = CommonUtil.getSyTypes();
        model.addAttribute("taxTypeConf",taxTypeConf);
        model.addAttribute(ObjectValueManager.LOAD_FCS,taxTypeConf.get(ObjectValueManager.LOAD_FCS)?"true":"false");

        String is_open_nsrxx_xg = AppConfig.getProperty("IS_OPEN_NSRXX_XG");
        model.addAttribute("is_open_nsrxx_xg", is_open_nsrxx_xg);

        if (StringUtils.isNotBlank(djh)) {
            if (StringUtils.isBlank(syhisId)) {
                SwDjSyQuery syxx = taxService.getSwDjSy(syId);
                model.addAttribute("syxx", syxx);
                List tddjList = taxService.getTddjByDjhLike(djh);
                model.addAttribute("tddjList", tddjList);
                Zd zd = zdService.findZdByDjh(djh);
                model.addAttribute("zd", zd);
                return "landtax/map/mapSyxx";
            } else {
                SwDjSyQuery syxx = new SwDjSyQuery();
                SwDjSyHis his = taxService.getSwDjSyHis(syhisId);
                syxx.setSyId(syId);
                syxx.setTdId(null);
                syxx.setJbbId(null);
                syxx.setFcId(null);
                syxx.setGdzysId(null);
                syxx.setQsId(null);
                syxx.setNsrsbh(his.getGlbm());
                syxx.setHyDm(his.getJbbHyDm());
                syxx.setZgkgDm(his.getJbbZgkgDm());
                syxx.setZclxDm(his.getJbbZclxDm());
                syxx.setSgyDm(his.getJbbSgyDm());
                syxx.setLxdh(his.getJbbLxdh());
                syxx.setNsrmc(his.getJbbNsrmc());
                syxx.setZcdz(his.getJbbZcdz());
                syxx.setCzrmc(his.getTdCzrmc());
                syxx.setCzrzjhm(his.getTdCzrzjhm());
                syxx.setSgztDm(his.getTdSgztDm());
                syxx.setTdsyzh(his.getTdTdsyzh());
                syxx.setTdsyytDm(his.getTdsyytDm());
                syxx.setTdqdfsDm(his.getTdqdfsDm());
                syxx.setTdsyytDm(his.getTdsyytDm());
                syxx.setFzmj(his.getTdFzmj());
                syxx.setScmj(his.getTdScmj());
                syxx.setDj(his.getDj());
                syxx.setTddj(his.getTdTddj());
                syxx.setDwse(his.getTdDwse());
                syxx.setQdsyqzfje(his.getQdsyqzfje());
                syxx.setTdkfcb(his.getTdkfcb());
                syxx.setCsqdsj(his.getCsqdsj());
                syxx.setSyqzzsj(his.getSyqzzsj());
                syxx.setYnmj(his.getTdYnmj());
                syxx.setMsmj(his.getTdMsmj());
                syxx.setMsse(his.getTdMsse());
                syxx.setNynseTd(his.getTdNynse());
                syxx.setTdMssjBegin(his.getTdMssjBegin());
                syxx.setTdMssjEnd(his.getTdMssjEnd());
                syxx.setTdjmxzdm(his.getTdjmxzdm());
                syxx.setTdMsyy(his.getTdMsyy());
                syxx.setFczh(his.getFcFczh());
                syxx.setFwxzDm(his.getFcFwxzDm());
                syxx.setFcmj(his.getFcFcmj());
                syxx.setFczlShi(his.getFczlShi());
                syxx.setFczlDong(his.getFczlDong());
                syxx.setFczlDy(his.getFczlDy());
                syxx.setFczlHao(his.getFczlHao());
                syxx.setFczlLou(his.getFczlLou());
                syxx.setFczlLu(his.getFczlLu());
                syxx.setFczlXian(his.getFczlXian());
                syxx.setFczlZhen(his.getFczlZhen());
                syxx.setFczl(his.getFcFczl());
                syxx.setFwjz(his.getFcFwjz());
                syxx.setTdjz(his.getFcTdjz());
                syxx.setFssbjz(his.getFcFssbjz());
                syxx.setFcyz(his.getFcFcyz());
                syxx.setCzfcyz(his.getCzfcyz());
                syxx.setJsbl(his.getJsbl());
                syxx.setFcyzMs(his.getFcFcyzMs());
                syxx.setFcyzYs(his.getFcFcyzYs());
                syxx.setFcjmxzdm(his.getFcjmxzdm());
                syxx.setYnseZy(his.getFcYnseZy());
                syxx.setFcMssjBegin(his.getFcMssjBegin());
                syxx.setFcMssjEnd(his.getFcMssjEnd());
                syxx.setFcMsyy(his.getFcMsyy());
                syxx.setNzj(his.getFcNzj());
                syxx.setYnseCz(his.getFcYnseCz());
                syxx.setNynseFc(his.getFcNynse());
                syxx.setBz(his.getFcBz());
                model.addAttribute("syxx", syxx);
                List tddjList = taxService.getTddjByDjhLike(djh);
                model.addAttribute("tddjList", tddjList);
                Zd zd = zdService.findZdByDjh(djh);
                model.addAttribute("zd", zd);
                return "landtax/map/mapSyxx";
            }
        } else {
            if (StringUtils.isBlank(syhisId)) {
                SwDjSyQuery qsxx = swDjQsService.getQsBySyId(syId);
                model.addAttribute("qsxx", qsxx);

                //初始化土地等级下拉框
                List tddjList = taxService.getTddjByXzqdm(qsxx.getXmXzqdm());
                model.addAttribute("tddjList", tddjList);


                return "landtax/fzjc/xmtzQsxxInput";
            } else {
                SwDjSyQuery syxx = new SwDjSyQuery();
                SwDjSyHis his = taxService.getSwDjSyHis(syhisId);
                SwDjSyQuery qsxx = swDjQsService.getQsBySyId(syId);
                syxx.setSyId(syId);
                syxx.setTdId(null);
                syxx.setJbbId(null);
                syxx.setFcId(null);
                syxx.setGdzysId(null);
                syxx.setQsId(null);
                syxx.setGlbm(his.getGlbm());
                syxx.setHyDm(his.getJbbHyDm());
                syxx.setZgkgDm(his.getJbbZgkgDm());
                syxx.setZclxDm(his.getJbbZclxDm());
                syxx.setSgyDm(his.getJbbSgyDm());
                syxx.setLxdh(his.getJbbLxdh());
                syxx.setNsrmc(his.getJbbNsrmc());
                syxx.setZcdz(his.getJbbZcdz());
                syxx.setCzrmc(his.getTdCzrmc());
                syxx.setCzrzjhm(his.getTdCzrzjhm());
                syxx.setSgztDm(his.getTdSgztDm());
                syxx.setTdsyzh(his.getTdTdsyzh());
                syxx.setTdsyytDm(his.getTdsyytDm());
                syxx.setTdqdfsDm(his.getTdqdfsDm());
                syxx.setTdsyytDm(his.getTdsyytDm());
                syxx.setFzmj(his.getTdFzmj());
                syxx.setScmj(his.getTdScmj());
                syxx.setDj(his.getDj());
                syxx.setTddj(his.getTdTddj());
                syxx.setDwse(his.getTdDwse());
                syxx.setQdsyqzfje(his.getQdsyqzfje());
                syxx.setTdkfcb(his.getTdkfcb());
                syxx.setCsqdsj(his.getCsqdsj());
                syxx.setSyqzzsj(his.getSyqzzsj());
                syxx.setYnmj(his.getTdYnmj());
                syxx.setMsmj(his.getTdMsmj());
                syxx.setMsse(his.getTdMsse());
                syxx.setNynse(his.getTdNynse());
                syxx.setTdMssjBegin(his.getTdMssjBegin());
                syxx.setTdMssjEnd(his.getTdMssjEnd());
                syxx.setTdjmxzdm(his.getTdjmxzdm());
                syxx.setTdMsyy(his.getTdMsyy());
                syxx.setFczh(his.getFcFczh());
                syxx.setFwxzDm(his.getFcFwxzDm());
                syxx.setFcmj(his.getFcFcmj());
                syxx.setFczlShi(his.getFczlShi());
                syxx.setFczlDong(his.getFczlDong());
                syxx.setFczlDy(his.getFczlDy());
                syxx.setFczlHao(his.getFczlHao());
                syxx.setFczlLou(his.getFczlLou());
                syxx.setFczlLu(his.getFczlLu());
                syxx.setFczlXian(his.getFczlXian());
                syxx.setFczlZhen(his.getFczlZhen());
                syxx.setFczl(his.getFcFczl());
                syxx.setFwjz(his.getFcFwjz());
                syxx.setTdjz(his.getFcTdjz());
                syxx.setFssbjz(his.getFcFssbjz());
                syxx.setFcyz(his.getFcFcyz());
                syxx.setCzfcyz(his.getCzfcyz());
                syxx.setJsbl(his.getJsbl());
                syxx.setFcyzMs(his.getFcFcyzMs());
                syxx.setFcyzYs(his.getFcFcyzYs());
                syxx.setFcjmxzdm(his.getFcjmxzdm());
                syxx.setYnseZy(his.getFcYnseZy());
                syxx.setFcMssjBegin(his.getFcMssjBegin());
                syxx.setFcMssjEnd(his.getFcMssjEnd());
                syxx.setFcMsyy(his.getFcMsyy());
                syxx.setNzj(his.getFcNzj());
                syxx.setYnseCz(his.getFcYnseCz());
                syxx.setNynseFc(his.getFcNynse());
                syxx.setBz(his.getFcBz());
                syxx.setQsHclx(his.getQsHclx());
                syxx.setQsBz(his.getQsBz());
                syxx.setQsJmse(his.getQsJmse());
                syxx.setQsJmxz(his.getQsJmxz());
                syxx.setQsJspz(his.getQsJspz());
                syxx.setQsYjne(his.getQsYjne());
                syxx.setQsYnse(his.getQsYnse());
                syxx.setQsXbjse(his.getQsXbjse());
                syxx.setXmmc(qsxx.getXmmc());
                syxx.setGdmj(qsxx.getGdmj());
                syxx.setQdfs(qsxx.getQdfs());
                syxx.setQdjg(qsxx.getQdjg());
                syxx.setGdsj(qsxx.getGdsj());
                syxx.setXmTdyt(qsxx.getXmTdyt());
                syxx.setXmYddw(qsxx.getXmYddw());
                syxx.setXmTdzl(qsxx.getXmTdzl());
                model.addAttribute("qsxx", syxx);

                //初始化土地等级下拉框
                List tddjList = taxService.getTddjByXzqdm(qsxx.getXmXzqdm());
                model.addAttribute("tddjList", tddjList);


                return "landtax/fzjc/xmtzQsxxInput";
            }
        }
    }
    @RequestMapping("/wf/turn")
    @ResponseBody
    public void turnWorkflow(Model model,String proid,HttpServletResponse response ,SwDjSyHis swDjSyHis) throws  Exception{
        List signList=taxService.getUserSign( proid);
        String msg = "";
        if(signList.size()<1){
            msg = "尚未签字确认不能转发！";
        }
        List<SwDjSyHis> swDjSyHisList =  swdjSyHisService.getSwDjSyHisByRwid(proid);
        if(CollectionUtils.isNotEmpty(swDjSyHisList)){
            swDjSyHis = swDjSyHisList.get(0);
        }else{
            swDjSyHis = new SwDjSyHis();
        }
        if(swDjSyHis.getXgyy()== null){
            msg += "尚未填写修改原因不能转发！";
        }
        response.setContentType("text/html;charset=GBK");
        PrintWriter out = response.getWriter();
        out.println(msg);
    }
    @RequestMapping("/djxx/workflow")
    @ResponseBody
    public Object createDjxgWorkflow(Model model,String syId){
        try{
            return syxgService.createDjxgWorkflow(syId);
        }catch (Exception e){
            return null;
        }

    }
    @RequestMapping("syAndDjxx")
    public String   wppProject(Model model,String xzq,String proid){
        String userId = SessionUtil.getCurrentUserId();
        String remark=sysUserService.getUserVo(userId).getRemark();
        String canXg="";
        if(StringUtils.isNotBlank(remark)&&remark.indexOf("swy")>=0){
            canXg="1";
        }
        model.addAttribute("canXg",canXg);

        List<SwDjSyTemp> list = swdjSyTempService.getSwDjSyTempListByRwid(proid);
        if(CollectionUtils.isEmpty(list)){//说明是第一次修改
            SwDjSyHis swDjSyHis = syxgService.getSwDjSyHisListByRwid(proid).get(0);
            SwDjSy swDjSy = swDjSyHis.getSwDjSy();
            String tdId = "";
            String fcId = "";
            if(swDjSy.getSwDjTd()!=null){
                tdId = swDjSy.getSwDjTd().getTdId();
            }
            if(swDjSy.getSwDjFc()!=null){
                fcId = swDjSy.getSwDjFc().getFcId();
            }
            SwDjSyQuery syxx = taxService.getSwDjSyById(tdId,fcId);
            String djh = syxx.getDjh();
            if(StringUtils.isNotBlank(djh)){
                List tddjList = taxService.getTddjByDjhLike(djh);
                model.addAttribute("tddjList",tddjList);
            }
            Zd zd = zdService.findZdByDjh(djh);
            model.addAttribute("zd",zd);
            model.addAttribute("syxx",syxx);
        }else{//说明之前修改过
            SwDjSyTemp swDjSyTemp = list.get(0);
            String djh = swDjSyTemp.getDjh();
            if(StringUtils.isNotBlank(djh)){
                List tddjList = taxService.getTddjByDjhLike(djh);
                model.addAttribute("tddjList",tddjList);
            }
            Zd zd = zdService.findZdByDjh(djh);
            model.addAttribute("zd",zd);
            model.addAttribute("syxx",swDjSyTemp);

        }

        model.addAttribute("proid",proid);
        return "landtax/sjwh/swProject";
    }
    @RequestMapping("saveDjh")
    @ResponseBody
    public Object saveDjh(Model model,String djh,String tdId,String fcId,String dbh,String tdzh,String proid) {
        SwDjSyQuery swDjSyQuery=taxService.getSwDjSyById(tdId, fcId);
        SwDjSyTemp swDjSyTemp=new SwDjSyTemp();
        BeanUtils.copyProperties(swDjSyQuery,swDjSyTemp);
        swDjSyTemp.setDjh(djh);
        swDjSyTemp.setDbh(dbh);
        swDjSyTemp.setTdId(tdId);
        swDjSyTemp.setFcId(fcId);
        swDjSyTemp.setTdsyzh(tdzh);
        swDjSyTemp.setProid(proid);
        ResponseMessage responseMessage = new ResponseMessage();
        try{
            //判断djh是否存在
            Zd zd = zdService.findZdByDjh(djh);
            if(zd==null){
                responseMessage.setMsg("您输入的地籍号不存在，请核查!");
            }else{
                swdjSyTempService.saveSwDjSyTemp(swDjSyTemp);
                responseMessage.setMsg("保存成功");
            }
            ;
        }catch (Exception e){
            e.printStackTrace();
            responseMessage.setMsg("出现异常，保存失败");
        }
        return responseMessage;

    }
    @RequestMapping("/djxx/commit")
    @ResponseBody
    public void commitDjxxxg(Model model,String proid,HttpServletResponse response) throws  Exception {

        List<SwDjSyTemp> list = swdjSyTempService.getSwDjSyTempListByRwid(proid);
        SwDjSyQuery swDjSyQuery = new SwDjSyQuery();
        if (CollectionUtils.isNotEmpty(list)) {
            SwDjSyTemp swDjSyTemp = list.get(0);
            String tdId=swDjSyTemp.getTdId();
            String fcId=swDjSyTemp.getFcId();
            swDjSyQuery = taxService.getSwDjSyById(tdId, fcId);
            swDjSyQuery.setDjh(swDjSyTemp.getDjh());
            swDjSyQuery.setTdsyzh(swDjSyTemp.getTdsyzh());

        } else {//说明只是创建了修改流程，但是并没有修改，保存，直接转发下去
            SwDjSyHis swDjSyHis = syxgService.getSwDjSyHisListByRwid(proid).get(0);
            SwDjSy swDjSy = swDjSyHis.getSwDjSy();
            String tdId = "";
            String fcId = "";
            if (swDjSy.getSwDjTd() != null) {
                tdId = swDjSy.getSwDjTd().getTdId();
            }
            if (swDjSy.getSwDjFc() != null) {
                fcId = swDjSy.getSwDjFc().getFcId();
            }
            swDjSyQuery = taxService.getSwDjSyById(tdId, fcId);
        }
        taxService.saveSwDjSyQuery(swDjSyQuery, Syzt.ZC.toString());

    }
    @RequestMapping("history")
    public String getSwdjSyHistory(Model model,String syId, String sylx)throws Exception{

        Map<String,Boolean> taxTypeConf =CommonUtil.getSyTypes();
        model.addAttribute("taxTypeConf",taxTypeConf);

        if(StringUtils.isNotBlank(syId)){
            String wwid = AppConfig.getProperty("djxg");
            String sql = "select * from sw_dj_sy_his t left join pf_workflow_instance t1 on t1.workflow_instance_id=t.rwid where t1.workflow_definition_id='"+wwid+"' "+" and t.sy_id='"+syId+"'";
            Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
            query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
            List<HashMap<String,Object>> list = query.getResultList();
            model.addAttribute("historyList",list);
        }

        String resultStr = "";
        String tag = "";
        tag = "地籍信息修改历史";

        model.addAttribute("title",tag);
         resultStr = "landtax/fzjc/djxgls";
        return resultStr;
    }
}
