package cn.gtmap.landtax.web.sjwh;

import cn.gtmap.landtax.entity.SwDjSy;
import cn.gtmap.landtax.entity.SwDjSyHis;
import cn.gtmap.landtax.entity.Zd;
import cn.gtmap.landtax.model.dictionary.Czlx;
import cn.gtmap.landtax.model.dictionary.Hcxmlx;
import cn.gtmap.landtax.model.dictionary.ResponseMessage;
import cn.gtmap.landtax.model.dictionary.Syzt;
import cn.gtmap.landtax.model.query.SwDjSyQuery;
import cn.gtmap.landtax.print.XMLBuildHelper;
import cn.gtmap.landtax.service.*;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.CommonUtil;
import cn.gtmap.landtax.util.IPlatUtil;
import cn.gtmap.landtax.util.ObjectValueManager;
import cn.gtmap.landtax.util.PlatUtil;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 税源删除
 * Created by xuchao on 2014/8/22.
 */
@Controller
@RequestMapping("/sysc")
public class SyscController {
    @Autowired
    TaxService taxService;
    @Autowired
    SyscService syscService;
    @Autowired
    SyxgService syxgService;
    @Autowired
    SwdjSyHisService swdjSyHisService;
    @Autowired
    SysUserService sysUserService;
    @Autowired
    ZdService zdService;
    @Autowired
    HashMap hcjdConfigMap;
    @Autowired
    BaseRepository baseRepository;

    @Autowired
    IPlatUtil platUtil;
    @RequestMapping("/workflow")
    @ResponseBody
    public Object createSyscWorkflow(Model model,String syId){
        return syscService.createSyscWorkflow(syId);
    }

    @RequestMapping("/workflowQs")
    @ResponseBody
    public Object createSyscWorkflowQs(Model model,String syId){
        return syscService.createQsSyscWorkflow(syId);
    }

    @RequestMapping("/workflowGdzys")
    @ResponseBody
    public Object createSyscWorkflowGdzys(Model model,String syId,String pcId){
        return syscService.createGdzysSyscWorkflow(syId,pcId);
    }

    @RequestMapping("/spb")
    public String spb(Model model,String proid) {
//        SwDjSyHis swDjSyHis = syxgService.getSwDjSyHisListByRwid(proid).get(0);
        List<SwDjSyHis> list = syxgService.getSwDjSyHisListByRwid(proid);
        SwDjSyHis swDjSyHis = list.get(0);
        model.addAttribute("swDjSyHis",swDjSyHis);

        String userId = swDjSyHis.getUserid();
        PfUserVo pfUserVo = sysUserService.getUserVo(userId);
        String username = pfUserVo.getUserName();
        model.addAttribute("username",username);

        //确认当前流程在哪个节点，限制用户签名
        String taskId = PlatUtil.getTaskIdByProid(proid);
        String activiId = this.platUtil.getPfActivityIdByTaskId(taskId);
        PfActivityVo vo = this.platUtil.getActivityInfo(activiId);

        String sql11 = "select WORKFLOW_DEFINITION_ID from pf_workflow_instance where pro_id ='"+proid+"'";
        String WORKFLOW_DEFINITION_ID = String.valueOf(baseRepository.getEntityManager().createNativeQuery(sql11).getSingleResult());
        String[] configArr={};
        String workflowDefinId_SYSC = AppConfig.getProperty("sysc");
        String workflowDefinId_GDZYSSJ = AppConfig.getProperty("gdzyssj");

        if(workflowDefinId_GDZYSSJ.equals(WORKFLOW_DEFINITION_ID)){
            configArr = (String[]) hcjdConfigMap.get(Hcxmlx.GDZYSSC.toString());
        }else if(workflowDefinId_SYSC.equals(WORKFLOW_DEFINITION_ID)){
            configArr = (String[]) hcjdConfigMap.get(Hcxmlx.SYSC.toString());
        }
        //key：活动定义ID， map：活动定义顺序
        Map<String, Integer> activityDefinitionMap = new HashMap<String, Integer>();
        int i = 0;
        for(String activityDefinitionId : configArr){
            i++;
            activityDefinitionMap.put(activityDefinitionId, i);
        }

        //税管员签名
        model.addAttribute("signdisable1", "true");
        //分局长签名
        model.addAttribute("signdisable2", "true");
        if (vo!=null&&activityDefinitionMap.containsKey(vo.getActivityDefinitionId())) {
            int sequence = activityDefinitionMap.get(vo.getActivityDefinitionId());
            model.addAttribute("signdisable" + sequence, "false");
        }

        return "landtax/sjwh/syscSpb";
    }

    @RequestMapping("/spb/save")
    @ResponseBody
    public Object saveSpb(Model model,SwDjSyHis swDjSyHis) {
        ResponseMessage responseMessage = new ResponseMessage();
        try {
            SwDjSyHis oldSwDjSyHis = syxgService.getSwDjSyHis(swDjSyHis.getSyhisId());
            oldSwDjSyHis.setXgyy(swDjSyHis.getXgyy());
            //oldSwDjSyHis.setCzlx(swDjSyHis.getCzlx());
            syxgService.saveSwDjSyHis(oldSwDjSyHis);
            responseMessage.setMsg("保存成功");
        }catch (Exception e){
            responseMessage.setMsg("保存失败");
        }
        return responseMessage;
    }

    @RequestMapping("/wf/del")
    @ResponseBody
    public String delSyxg(Model model,String proid) {
        syxgService.del(proid);
        return "";
    }

    @RequestMapping("/wf/end")
    @ResponseBody
    public String end(Model model,String proid) {
        syscService.delSwdjSyByHisId(proid);
        return "";
    }

    @RequestMapping("/wf/delQs")
    @ResponseBody
    public String delSyxgQs(Model model,String proid) {
        syxgService.del(proid);
        return "";
    }

    @RequestMapping("/wf/endQs")
    @ResponseBody
    public String endQs(Model model,String proid) {
        syscService.delSwdjSyByHisIdGqs(proid);
        return "";
    }

    @RequestMapping("/wf/delGdzys")
    @ResponseBody
    public String delSyxgGdzys(Model model,String proid) {
        syxgService.del(proid);
        return "";
    }

    @RequestMapping("/wf/endGdzys")
    @ResponseBody
    public String endGdzys(Model model,String proid) {
        syscService.delSwdjSyByHisIdGqs(proid);
        return "";
    }

    @RequestMapping("printSyscSpb")
    @ResponseBody
    public void printSyscSpb(Model model,HttpServletRequest request,HttpServletResponse response,String syhisId,String proid) throws  Exception{
        XMLBuildHelper xmlBuildHelper = new XMLBuildHelper();
        StringBuilder xml = new StringBuilder();
        SwDjSyHis swDjSyHis = syxgService.getSwDjSyHis(syhisId);
        if(swDjSyHis==null){
            swDjSyHis = new SwDjSyHis();
        }
        String czlx = swDjSyHis.getCzlx();
        czlx = Czlx.getMcByDm(czlx);
        swDjSyHis.setCzlx(czlx);
        xml.append(xmlBuildHelper.voToXml(swDjSyHis));
//        xml.append("<data name=\"AP_FWZDMJ\" type=\"String\">");
//        xml.append((vo.getAP_LFMJ()==null?0:vo.getAP_LFMJ())+(vo.getAP_PFMJ()==null?0:vo.getAP_PFMJ()));
//        xml.append("</data>");
        HashMap<String, Boolean> keyMap = new HashMap<String, Boolean>();
        keyMap.put("sgsyj", false);
        keyMap.put("fgldyj", false);
        String userId = swDjSyHis.getUserid();
        PfUserVo user = sysUserService.getUserVo(userId);
        String username = "";
        try{
            username = user.getUserName();
        }catch (Exception e){
        }

        xml.append("<data name=\"USERNAME\" type=\"String\">");
        xml.append(username);
        xml.append("</data>");
        xml.append(xmlBuildHelper.getSignToXml(proid, request, keyMap));//根据id，进入平台库，查找相应的信息，组织参数，存入xml中

        String res=xmlBuildHelper.getPrintXml(xml.toString());
        response.setContentType("text/xml; charset=GBK");
        PrintWriter out = response.getWriter();
        out.write(res);
        out.flush();
        out.close();
    }
    @RequestMapping("/syxx")
    public String syxx(Model model,String proid)throws Exception{
        String hydm_level = AppConfig.getProperty("HYDM_LEVELS");
        model.addAttribute("hydm_level",hydm_level);
        String hydm=null;
        SwDjSyHis swDjSyHis = syxgService.getSwDjSyHisListByRwid(proid).get(0);
        SwDjSy swDjSy = swDjSyHis.getSwDjSy();
        String tdId = "";
        String fcId = "";
        if(swDjSy.getSwDjTd()!=null){
            tdId = swDjSy.getSwDjTd().getTdId();
        }
        if(swDjSy.getSwDjFc()!=null){
            fcId = swDjSy.getSwDjFc().getFcId();
        }
        SwDjSyQuery syxx = taxService.getSwDjSyById(tdId,fcId);
        String djh = syxx.getDjh();
        if(StringUtils.isNotBlank(djh)){
            List tddjList = taxService.getTddjByDjhLike(djh);
            model.addAttribute("tddjList",tddjList);
        }
        Zd zd = zdService.findZdByDjh(djh);
        model.addAttribute("zd",zd);
        model.addAttribute("syxx",syxx);
        hydm=syxx.getHyDm();
        if(StringUtils.isNotEmpty(hydm)){
            List hydl=taxService.getHydl(hydm);
            Object hydmdl=hydl.get(0);
            model.addAttribute("hydl",hydmdl);
            if(hydm.length()>3){
                List hyzl=taxService.getHyzl(hydm);
                Object hydmzl=hyzl.get(0);
                model.addAttribute("hyzl",hydmzl);
            }
        }

        String is_open_nsrxx_xg = AppConfig.getProperty("IS_OPEN_NSRXX_XG");
        model.addAttribute("is_open_nsrxx_xg", is_open_nsrxx_xg);

        model.addAttribute("proid",proid);
        model.addAttribute("noSave","true");
        Map<String,Boolean> taxTypeConf = CommonUtil.getSyTypes();
        model.addAttribute("taxTypeConf",taxTypeConf);
        model.addAttribute(ObjectValueManager.LOAD_FCS,taxTypeConf.get(ObjectValueManager.LOAD_FCS)?"true":"false");
        return "landtax/sjwh/syscSyxx";
    }
    @RequestMapping("/wf/turn")
    @ResponseBody
    public void turnWorkflow(Model model,String proid,HttpServletResponse response) throws  Exception{
        List signList=taxService.getUserSign( proid);
        String msg = "";
        if(signList.size()<1){
            msg = "尚未签字确认不能转发！";
        }
        List<SwDjSyHis> list = syxgService.getSwDjSyHisListByRwid(proid);
        SwDjSyHis swDjSyHis = list.get(0);
        if(swDjSyHis.getXgyy()== null){
            msg += "尚未填写修改原因不能转发！";
        }
        response.setContentType("text/html;charset=GBK");
        PrintWriter out = response.getWriter();
        out.println(msg);
    }
}

