package cn.gtmap.landtax.web.sjjk;

import cn.gtmap.landtax.entity.SDmDwxxCz;
import cn.gtmap.landtax.model.query.SyxxtjbQuery;
import cn.gtmap.landtax.printexcel.access.ExcelBean;
import cn.gtmap.landtax.quartz.SyxxTjbQuartz;
import cn.gtmap.landtax.service.SjjkService;
import com.gtis.web.SessionUtil;
import jxl.Workbook;
import jxl.format.CellFormat;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * Created by Administrator on 2017/4/14.
 */
@Controller
@RequestMapping("/sjjk")
public class SjjkController {

    @Autowired
    SjjkService sjjkService;

    @Autowired
    SyxxTjbQuartz syxxTjbQuartz;

    @RequestMapping("/index")
    public String index(Model model) {
        return "landtax/sjjk/index";
    }

    /**
     * 工作进展通报统计
     * @param model
     * @return
     */
    @RequestMapping("/workProceedTbtj")
    public String workProceedTbtj(Model model) {
        int currentYear = Calendar.getInstance().get(Calendar.YEAR);
        int currentMonth = Calendar.getInstance().get(Calendar.MONTH);
        int quarter = (currentMonth+1)%4==0?(currentMonth+1)/4:(currentMonth+1)/4+1;
        int minYear = 2014;
        List<String> yearList = new ArrayList<String>();
        for(int i = currentYear; i >= minYear; i--){
            yearList.add(i+"");
        }
        List<String> quarterList = new ArrayList<String>();
        for(int i = 1; i <= quarter; i++){
            quarterList.add(i+"");
        }
        model.addAttribute("currentYear", currentYear);
        model.addAttribute("quarter", quarter);
        model.addAttribute("yearList", yearList);
        model.addAttribute("quarterList", quarterList);
        return "landtax/sjjk/workProceedTbtj";
    }

    /**
     * 工作进展通报统计
     * @param model
     * @return
     */
    @RequestMapping("/workProceedTbtjJson")
    @ResponseBody
    public Object workProceedTbtjJson(Model model, String year, String beginQ, String endQ) {
        List<Map<String, Object>> list = sjjkService.workProceedTbtjJson(year, beginQ, endQ);
        return list;
    }

    @RequestMapping("exportWorkProceedTbtjExcel")
    public String exportWorkProceedTbtjExcel(HttpServletRequest request, String year, String beginQ, String endQ){
        try {
            List<Map<String, Object>> list = sjjkService.workProceedTbtjJson(year, beginQ, endQ);
            List<String[]> retList = new ArrayList<String[]>();
            for(int i=0; i<list.size(); i++){
                String[] tempArr = new String[19];

                Map<String, Object> map = (Map<String, Object>) list.get(i);
                tempArr[0] = String.valueOf(map.get("DWMC"));
                tempArr[1] = String.valueOf(map.get("ZGH"));
                tempArr[2] = String.valueOf(map.get("TD_NSH"));
                tempArr[3] = String.valueOf(map.get("TD_DWNSH"));
                tempArr[4] = String.valueOf(map.get("TD_ZHZB"));
                tempArr[5] = String.valueOf(map.get("TD_YS"));
                tempArr[6] = String.valueOf(map.get("FC_NSH"));
                tempArr[7] = String.valueOf(map.get("FC_ZJH"));
                tempArr[8] = String.valueOf(map.get("FC_ZHZB"));
                tempArr[9] = String.valueOf(map.get("FC_YS"));
                tempArr[10] = String.valueOf(map.get("TD_BJGX"));
                tempArr[11] = String.valueOf(map.get("TD_LJGX"));
                tempArr[12] = String.valueOf(map.get("TD_BJZB"));
                tempArr[13] = String.valueOf(map.get("TD_LJZB"));
                tempArr[14] = String.valueOf(map.get("FC_BJGX"));
                tempArr[15] = String.valueOf(map.get("FC_LJGX"));
                tempArr[16] = String.valueOf(map.get("FC_ZJNS"));
                tempArr[17] = String.valueOf(map.get("FC_BJZB"));
                tempArr[18] = String.valueOf(map.get("FC_LJZB"));

                retList.add(tempArr);
            }

            //取出workProceedTbtj.xls文件，然后拼接标题和系统提取时间
            String title = year + "年" + beginQ + "~" + endQ + "季度以地控税工作进展情况通报统计表";
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy年MM月dd日HH点mm分");
            String sysTime = "从系统提取数据时间：" + sdf.format(Calendar.getInstance().getTime());

            //打开文件
            Workbook workbook = Workbook.getWorkbook(new File(request.getRealPath("/" + "static\\excel\\template") + "\\" + "workProceedTbtj.xls"));
            //打开一个文本的副本，并指定数据写回到源文件
            WritableWorkbook writableWorkbook = Workbook.createWorkbook(new File(request.getRealPath("/" + "static\\excel\\template") + "\\" + "workProceedTbtj.xls"), workbook);
            //获取第一张Sheet表
            WritableSheet writableSheet = writableWorkbook.getSheet(0);

            //获取原标题的格式
            WritableCell cellTitle = writableSheet.getWritableCell(1, 0);
            CellFormat cfTitle = cellTitle.getCellFormat();
            //修改标题的内容
            Label labelTitle = new Label(1, 0, title);
            labelTitle.setCellFormat(cfTitle);
            writableSheet.addCell(labelTitle);

            //获取系统时间的格式
            WritableCell cellTime = writableSheet.getWritableCell(1, 1);
            CellFormat cfTime = cellTime.getCellFormat();
            //修改系统时间的内容
            Label labelTime = new Label(1, 1, sysTime);
            labelTime.setCellFormat(cfTime);
            writableSheet.addCell(labelTime);

            writableWorkbook.write();
            writableWorkbook.close();

            HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
            ExcelBean eb = new ExcelBean();
            map.put("group1", retList);// 把retList放入group1中
            eb.setGroupMap(map);
            eb.setExcelTemplate("workProceedTbtj.xls");
            eb.setExcelXml("workProceedTbtj.xml"); // 上述两步骤是把xml文件和xls文件有机组合
            eb.printExcel(request);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }
    /**
     * 工作情况监控统计
     * @param model
     * @return
     */
    @RequestMapping("/jzqktj")
    public String jzqktj(Model model) {
        int currentYear = Calendar.getInstance().get(Calendar.YEAR);
        int currentMonth = Calendar.getInstance().get(Calendar.MONTH);
        int quarter = (currentMonth+1)%4==0?(currentMonth+1)/4:(currentMonth+1)/4+1;
        int minYear = 2014;
        List<String> yearList = new ArrayList<String>();
        for(int i = currentYear; i >= minYear; i--){
            yearList.add(i+"");
        }
        List<String> quarterList = new ArrayList<String>();
        for(int i = 1; i <= quarter; i++){
            quarterList.add(i+"");
        }
        model.addAttribute("currentYear", currentYear);
        model.addAttribute("quarter", quarter);
        model.addAttribute("yearList", yearList);
        model.addAttribute("quarterList", quarterList);
        return "landtax/sjjk/jzqktj";
    }
    /**
     * 工作情况监控统计
     * @param model
     * @return
     */
    @RequestMapping("/jzqktjJson")
    @ResponseBody
    public Object jzqktjJson(Model model, String year, String beginQ, String endQ) {
        List<Map<String, Object>> list = sjjkService.jzqktjJson(year, beginQ, endQ);
        list.add(0, list.get(list.size() - 1));
        list.remove(list.size() - 1);
        return list;
    }
    @RequestMapping("exportJzqktjExcel")
    public String exportJzqktjExcel(HttpServletRequest request, String year, String beginQ, String endQ){
        try {
            List<Map<String, Object>> list = sjjkService.jzqktjJson(year, beginQ, endQ);
            List<String[]> retList = new ArrayList<String[]>();
            list.add(0, list.get(list.size() - 1));
            list.remove(list.size() - 1);
            for(int i=0; i<list.size(); i++){
                String[] tempArr = new String[53];
                Map<String, Object> map = (Map<String, Object>) list.get(i);
                tempArr[0] = String.valueOf(map.get("DWMC"));
                tempArr[1] = String.valueOf(map.get("ZGH"));
                if(map.get("QBRQ")!=null){
                    tempArr[2] = String.valueOf(map.get("QBRQ"));
                }
                tempArr[3] = String.valueOf(map.get("TDSTS"));
                tempArr[4] = String.valueOf(map.get("TDNYNSE"));
                tempArr[5] = String.valueOf(map.get("TD_DWTS"));
                tempArr[6] = String.valueOf(map.get("TD_DWHS"));
                tempArr[7] = String.valueOf(map.get("TD_DWNYNSE"));
                tempArr[8] = String.valueOf(map.get("TD_GTTS"));
                tempArr[9] = String.valueOf(map.get("TD_GTHNYNSE"));
                tempArr[10] = String.valueOf(map.get("TD_GRTS"));
                tempArr[11] = String.valueOf(map.get("TD_GRNYNSE"));
                tempArr[12] = String.valueOf(map.get("FCSTS"));
                tempArr[13] = String.valueOf(map.get("FCNYNSE"));
                tempArr[14] = String.valueOf(map.get("FC_DWTS"));
                tempArr[15] = String.valueOf(map.get("FC_DWHS"));
                tempArr[16] = String.valueOf(map.get("FC_DWNYNSE"));
                tempArr[17] = String.valueOf(map.get("FC_GTTS"));
                tempArr[18] = String.valueOf(map.get("FC_GTHNYNSE"));
                tempArr[19] = String.valueOf(map.get("FC_GRTS"));
                tempArr[20] = String.valueOf(map.get("FC_GRNYNSE"));
                tempArr[21] = String.valueOf(map.get("CZFCSTS"));
                tempArr[22] = String.valueOf(map.get("CZFCNYNSE"));
                tempArr[23] = String.valueOf(map.get("CZFC_DWTS"));
                tempArr[24] = String.valueOf(map.get("CZFC_DWHS"));
                tempArr[25] = String.valueOf(map.get("CZFC_DWNYNSE"));
                tempArr[26] = String.valueOf(map.get("CZFC_GTTS"));
                tempArr[27] = String.valueOf(map.get("CZFC_GTHNYNSE"));
                tempArr[28] = String.valueOf(map.get("CZFC_GRTS"));
                tempArr[29] = String.valueOf(map.get("CZFC_GRNYNSE"));
                tempArr[30] = String.valueOf(map.get("TD_BJGXTS"));
                tempArr[31] = String.valueOf(map.get("TD_BJKGHGXTS"));
                tempArr[32] = String.valueOf(map.get("TD_BJGXZB"));
                tempArr[33] = String.valueOf(map.get("TD_BJMJGX"));
                tempArr[34] = String.valueOf(map.get("TD_BJNYNSEGX"));
                tempArr[35] = String.valueOf(map.get("TD_LJGXTS"));

                tempArr[36] = String.valueOf(map.get("TD_LJKGHGXTS"));
                tempArr[37] = String.valueOf(map.get("TD_LJGXZB"));
                tempArr[38] = String.valueOf(map.get("TD_LJMJGX"));
                tempArr[39] = String.valueOf(map.get("TD_LJNYNSEGX"));
                tempArr[40] = String.valueOf(map.get("FC_BJGXTS"));
                tempArr[41] = String.valueOf(map.get("FC_BJKGHGXTS"));
                tempArr[42] = String.valueOf(map.get("FC_BJGXCZTS"));
                tempArr[43] = String.valueOf(map.get("FC_BJFCYZGX"));
                tempArr[44] = String.valueOf(map.get("FC_BJNZJGX"));
                tempArr[45] = String.valueOf(map.get("FC_BJNYNSEGX"));
                tempArr[46] = String.valueOf(map.get("FC_LJGXTS"));
                tempArr[47] = String.valueOf(map.get("FC_LJKGHGXTS"));
                tempArr[48] = String.valueOf(map.get("FC_LJGXCZTS"));
                tempArr[49] = String.valueOf(map.get("FC_LJFCYZGX"));
                tempArr[50] = String.valueOf(map.get("FC_LJNZJGX"));
                tempArr[51] = String.valueOf(map.get("FC_LJNYNSEGX"));
                tempArr[52] = String.valueOf(map.get("FC_LJGXZB"));

                retList.add(tempArr);
            }

            //取出workProceedTbtj.xls文件，然后拼接标题和系统提取时间
            String title = year + "年" + beginQ + "~" + endQ + "季度以地控税工作进展情况监控统计表";
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy年MM月dd日HH点mm分");
            String sysTime = "从系统提取数据时间：" + sdf.format(Calendar.getInstance().getTime());

            //打开文件
            Workbook workbook = Workbook.getWorkbook(new File(request.getRealPath("/" + "static\\excel\\template") + "\\" + "jzqktj.xls"));
            //打开一个文本的副本，并指定数据写回到源文件
            WritableWorkbook writableWorkbook = Workbook.createWorkbook(new File(request.getRealPath("/" + "static\\excel\\template") + "\\" + "jzqktj.xls"), workbook);
            //获取第一张Sheet表
            WritableSheet writableSheet = writableWorkbook.getSheet(0);

            //获取原标题的格式
            WritableCell cellTitle = writableSheet.getWritableCell(1, 0);
            CellFormat cfTitle = cellTitle.getCellFormat();
            //修改标题的内容
            Label labelTitle = new Label(1, 0, title);
            labelTitle.setCellFormat(cfTitle);
            writableSheet.addCell(labelTitle);

            //获取系统时间的格式
            WritableCell cellTime = writableSheet.getWritableCell(1, 1);
            CellFormat cfTime = cellTime.getCellFormat();
            //修改系统时间的内容
            Label labelTime = new Label(1, 1, sysTime);
            labelTime.setCellFormat(cfTime);
            writableSheet.addCell(labelTime);

            writableWorkbook.write();
            writableWorkbook.close();

            HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
            ExcelBean eb = new ExcelBean();
            map.put("group1", retList);// 把retList放入group1中
            eb.setGroupMap(map);
            eb.setExcelTemplate("jzqktj.xls");
            eb.setExcelXml("jzqktj.xml"); // 上述两步骤是把xml文件和xls文件有机组合
            eb.printExcel(request);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }


    @RequestMapping("/syxxTjbJson")
    @ResponseBody
    public Object syxxTjbJson(String id) {
        List<SyxxtjbQuery> result = sjjkService.syxxTjbJson(id);
        return result;
    }

    @RequestMapping("exportExcel")
    public String exportExcel(HttpServletRequest request) throws Exception {
        try {
            String id = null;
            List<SyxxtjbQuery> syxxtjbQueryList = sjjkService.syxxTjbJson(id);//相当于第一次进入，id为null获取结果

            List<String[]> retList = new ArrayList<String[]>();
            retList= this.recursionToGetSon(syxxtjbQueryList,retList);//递归查询子节点

            HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
            ExcelBean eb = new ExcelBean();
            map.put("group1", retList);// 把retList放入group1中
            eb.setGroupMap(map);
            eb.setExcelTemplate("syxxTjb.xls"); //
            eb.setExcelXml("syxxTjb.xml"); // 上述两步骤是把xml文件和xls文件有机组合
            eb.printExcel(request);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }

    private  List<String[]> recursionToGetSon(List<SyxxtjbQuery> syxxtjbQueryList,List<String[]> retList){

        for(int i=0;i<syxxtjbQueryList.size();i++){
            SyxxtjbQuery syxxtjbQuery = syxxtjbQueryList.get(i);
            retList.add(this.AddOneLineInExcel(syxxtjbQuery));//查询结果插入返回值中
            if(syxxtjbQuery.getState().equals("closed")){//如果列的状态为“closed”，有子节点，再次查询
                List<SyxxtjbQuery> sonOfSyxxtjbQueryList = sjjkService.syxxTjbJson(syxxtjbQuery.getDwdm());
                recursionToGetSon(sonOfSyxxtjbQueryList,retList);//对子节点递归
            }
        }
        return retList;
    }
    private String[] AddOneLineInExcel(SyxxtjbQuery syxxtjbQuery){
        String[] tempArr = new String[18];//18列
        for(int j=0;j<tempArr.length;j++){
            tempArr[j] = "";//数组初始化
        }
        tempArr[0] = syxxtjbQuery.getDwmc();
        tempArr[1] = syxxtjbQuery.getGtzdxx();
        tempArr[2] = syxxtjbQuery.getSyzs();
        tempArr[3] = syxxtjbQuery.getKghsys();
        tempArr[4] = syxxtjbQuery.getLzlghsys();
        tempArr[5] = syxxtjbQuery.getKzhsyhsys();
        tempArr[6] = syxxtjbQuery.getJgdwsys();
        tempArr[7] = syxxtjbQuery.getGrsys();
        tempArr[8] = syxxtjbQuery.getSyhcmj();
        tempArr[9] = syxxtjbQuery.getMsmj();
        tempArr[10] = syxxtjbQuery.getYsmj();
        tempArr[11] = syxxtjbQuery.getTdnynse();
        tempArr[12] = syxxtjbQuery.getFcyz();
        tempArr[13] = syxxtjbQuery.getFcyz_ys();
        tempArr[14] = syxxtjbQuery.getFcyz_ms();
        tempArr[15] = syxxtjbQuery.getYnse_zy();
        tempArr[16] = syxxtjbQuery.getYnse_cz();
        tempArr[17] = syxxtjbQuery.getFcnynse();
        return  tempArr;
    }

    /**
     * 首页大屏展示
     * @param model
     * @return
     */
    @RequestMapping("/portal")
    public String portal(Model model) {
        return "landtax/sjjk/portal";
    }

    /**
     * 刷新数据
     * @param model
     * @return
     */
    @RequestMapping("/updateData")
    @ResponseBody
    public String updateData(Model model) {
        try{
            syxxTjbQuartz.execute();
            return "true";
        }catch (Exception e){
            e.printStackTrace();
            return "false";
        }
    }


    /**
     * 柱状图
     * @return
     */
    @RequestMapping("/barchart")
    @ResponseBody
    public Object barchart() throws Exception{
        //根据regionCode获取图里显示的地名代码列表
        String regionCode = SessionUtil.getCurrentUser().getRegionCode();
        //标题名称
        String title = "";
        String cityName = "";
        if(regionCode.length()==2){
            title = "陕西省各地市";
        }else if(regionCode.length()==4){
            List<SDmDwxxCz> cityList = sjjkService.getCityList();
            for(SDmDwxxCz sDmDwxxCz : cityList){
                if(regionCode.equals(sDmDwxxCz.getDwdm())){
                    cityName = sDmDwxxCz.getDwmc();
                }
            }
            title = cityName + "各县区";
        }
        //取土地税和房产税的核查税额
        List<HashMap<String,Object>> queryList = sjjkService.tdsFxList(regionCode);

        List<String> categoriesList = new ArrayList<String>();

        List series = new ArrayList();
        List tdsData = new ArrayList();
        List fcsData = new ArrayList();

        List tdsList = new ArrayList();
        List fcsList = new ArrayList();


        //解析查询结果
        for(HashMap tempMap : queryList){
            categoriesList.add(String.valueOf(tempMap.get("ORGAN_NAME")));
            tdsData.add(Float.parseFloat(String.valueOf(tempMap.get("TDSNYNSE"))));
            fcsData.add(Float.parseFloat(String.valueOf(tempMap.get("FCSNYNSE"))));
            //组织土地税饼状图数据
            List tdsNameAndData = new ArrayList();
            tdsNameAndData.add(String.valueOf(tempMap.get("ORGAN_NAME")));
            tdsNameAndData.add(Float.parseFloat(String.valueOf(tempMap.get("TDSNYNSEZB"))));
            tdsList.add(tdsNameAndData);

            //组织房产税饼状图数据
            List fcsNameAndData = new ArrayList();
            fcsNameAndData.add(String.valueOf(tempMap.get("ORGAN_NAME")));
            fcsNameAndData.add(Float.parseFloat(String.valueOf(tempMap.get("FCSNYNSEZB"))));
            fcsList.add(fcsNameAndData);
        }

        //组织柱状图数据
        Map tdsMap = new HashMap();
        tdsMap.put("name","城镇土地使用税");
        tdsMap.put("data",tdsData);
        Map fcsMap = new HashMap();
        fcsMap.put("name","房产税");
        fcsMap.put("data",fcsData);
        series.add(tdsMap);
        series.add(fcsMap);

        Map resultMap = new HashMap();
        resultMap.put("categories",categoriesList);
        resultMap.put("series",series);

        resultMap.put("tdsData",tdsList);

        resultMap.put("fcsData",fcsList);

        resultMap.put("title",title);
        return resultMap;
    }
}
