package cn.gtmap.landtax.web.fzjc;

import cn.gtmap.landtax.entity.SDmDwxxCz;
import cn.gtmap.landtax.entity.SwDjFc;
import cn.gtmap.landtax.entity.SwDjTd;
import cn.gtmap.landtax.model.dictionary.ResponseMessage;
import cn.gtmap.landtax.model.dictionary.Sgzt;
import cn.gtmap.landtax.model.query.SwDjSyQuery;
import cn.gtmap.landtax.model.dictionary.Sylx;
import cn.gtmap.landtax.printexcel.access.ExcelBean;
import cn.gtmap.landtax.service.DwxxService;
import cn.gtmap.landtax.service.TaxService;
import cn.gtmap.landtax.service.impl.DicServiceImpl;
import cn.gtmap.landtax.util.CommonUtil;
import cn.gtmap.landtax.util.ObjectValueManager;
//import jxl.Cell;
//import jxl.Sheet;
//import jxl.Workbook;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import cn.gtmap.landtax.util.CommonUtil;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;

//import static jxl.Workbook.*;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

/**
 * 重点税源
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2014/7/5
 */
@Controller
@RequestMapping("/zdsy")
public class ZdsyController {
    @Autowired
    TaxService taxService;
    @Autowired
    DwxxService dwxxService;
    @Autowired
    DicServiceImpl dicServiceImpl;


    @RequestMapping("")
    public String taxSourceList(Model model) throws Exception{
        //计算合计
        SwDjSyQuery swDjSyQuery = new SwDjSyQuery();
        swDjSyQuery.setZdsybz("1");
        HashMap result = taxService.getHj(null,swDjSyQuery);
        model.addAttribute("resultMap",result);
        //加载税源种类
        Map<String,Boolean> taxTypeConf = CommonUtil.getSyTypes();
        model.addAttribute("taxTypeConf",taxTypeConf);
        model.addAttribute(ObjectValueManager.LOAD_FCS,taxTypeConf.get(ObjectValueManager.LOAD_FCS)?"true":"false");
        return "landtax/fzjc/zdsy";
    }


    /**
     * 所有重点税源认定
     * @param model
     * @return
     */
    @RequestMapping("allZdsyIdentify")
    public String allZdsyIdentify(Model model) throws Exception{
        //加载税源种类
        Map<String,Boolean> taxTypeConf =CommonUtil.getSyTypes();
        model.addAttribute("taxTypeConf",taxTypeConf);


        //获取所有区县信息
        List<SDmDwxxCz> allQxList = dwxxService.getAllQxList();
        model.addAttribute("allQxList",allQxList);
        //获取所有主管税务机关
        List zgswjgList = dicServiceImpl.findAllZgswjg();
        model.addAttribute("zgswjgList",zgswjgList);
        return "landtax/fzjc/allZdsyIdentify";
    }

    @RequestMapping("allZdsyJson")
    @ResponseBody
    public Object getAllZdsyJson(Model model,SwDjSyQuery swDjSyQuery,Pageable request,String sidx,String sord,String beginPm,String endPm,String sylx) {
        if(StringUtils.isBlank(sylx)){
            sylx= Sylx.TDSY.toString();
        }

        if(Sylx.TDSY.toString().equals(sylx) ){
            return taxService.findZdsyTd(swDjSyQuery, request, sidx, sord, beginPm, endPm);
        }else if(Sylx.FCSY.toString().equals(sylx) ){
            return taxService.findZdsyFc(swDjSyQuery,request,sidx,sord,beginPm,endPm);
        }else if(Sylx.GDZYS.toString().equals(sylx)  ){
            return taxService.findZdsyGdzys(swDjSyQuery,request,sidx,sord,beginPm,endPm);
        }else if( Sylx.QS.toString().equals(sylx) ){
            return taxService.findZdsyQs(swDjSyQuery,request,sidx,sord,beginPm,endPm);
        }
        return null;
    }

    /**
     * 土地重点税源台账
     * @param model
     * @return
     */
    @RequestMapping("td")
    public String lzlghTd(Model model) {
        //获取所有区县信息
        List<SDmDwxxCz> allQxList = dwxxService.getAllQxList();
        model.addAttribute("allQxList",allQxList);
        //获取所有主管税务机关
        List zgswjgList = dicServiceImpl.findAllZgswjg();
        model.addAttribute("zgswjgList",zgswjgList);
        return "landtax/fzjc/zdsyTd";
    }

    @RequestMapping("tdJson")
    @ResponseBody
    public Object getZdsyTd(Model model,SwDjSyQuery swDjSyQuery,Pageable request,String sidx,String sord,String beginPm,String endPm) {
        return taxService.findZdsyTd(swDjSyQuery,request,sidx,sord,beginPm,endPm);
    }

    /**
     * 房产重点税源台账
     * @param model
     * @return
     */
    @RequestMapping("fc")
    public String zdsyFc(Model model) {
        //获取所有区县信息
        List<SDmDwxxCz> allQxList = dwxxService.getAllQxList();
        model.addAttribute("allQxList",allQxList);
        //获取所有主管税务机关
        List zgswjgList = dicServiceImpl.findAllZgswjg();
        model.addAttribute("zgswjgList",zgswjgList);
        return "landtax/fzjc/zdsyFc";
    }

    @RequestMapping("fcJson")
    @ResponseBody
    public Object getZdsyFc(Model model,SwDjSyQuery swDjSyQuery,Pageable request,String sidx,String sord,String beginPm,String endPm) {
        return taxService.findZdsyFc(swDjSyQuery,request,sidx,sord,beginPm,endPm);
    }

    @RequestMapping("setZdsy")
    @ResponseBody
    public Object setZdsy(Model model,String sylx,String tdId,String fcId,String gdzysId,String qsId,SwDjSyQuery swDjSyQuery,String beginPm,String endPm) {
        ResponseMessage msg = new ResponseMessage();
        try{
            String zdsybz = swDjSyQuery.getZdsybz().replace(",","").replace("2","");
            swDjSyQuery.setZdsybz(zdsybz);
            taxService.setZdsy(sylx,tdId,fcId,gdzysId,qsId,swDjSyQuery,beginPm,endPm);
            if(StringUtils.isNotBlank(zdsybz)){
                msg.setMsg("已标记为重点税源！");
            }else{
                msg.setMsg("已取消重点税源！");
            }

        }catch (Exception e){
            msg.setMsg("出现异常，标记失败！");
        }
        return msg;
    }

    @RequestMapping("exportExcelTd")
    public String exportExcelTd(SwDjSyQuery swDjSyQuery,String ids,HttpServletRequest request,String beginPm,String endPm) throws Exception {
        try {
            HashMap param = new HashMap();

            // 判断是checkbox导出，还是查询导出
            if (StringUtils.isNotBlank(ids)) {
                // 说明是checkbox导出
                param.put("ids",ids);
            } else {
                param.put("swDjSyQuery",swDjSyQuery);
            }
            param.put("beginPm",beginPm);
            param.put("endPm",endPm);
            String excelBegin = swDjSyQuery.getExcelBegin();
            if(StringUtils.isBlank(excelBegin)){
                excelBegin = "0";
            }else{
                excelBegin = String.valueOf(Integer.parseInt(excelBegin)-1);
            }
            List<Object> zdsyList = taxService.getZdsyTdList(param);
            List<String[]> retList = new ArrayList<String[]>();
            for(int i=(0+Integer.parseInt(excelBegin));i<(zdsyList.size()+Integer.parseInt(excelBegin));i++){
                String[] tempArr = new String[14];
                for(int j=0;j<tempArr.length;j++){
                    tempArr[j] = "";
                }
                Object[] obj = (Object[]) zdsyList.get(i);
                tempArr[0] = String.valueOf(i+1);
                for(int k=1;k<tempArr.length;k++){
                    tempArr[k] = String.valueOf(obj[k-1]);
                }
                retList.add(tempArr);
            }

            HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
            ExcelBean eb = new ExcelBean();
            map.put("group1", retList);// 把retList放入group1中
            eb.setGroupMap(map);
            eb.setExcelTemplate("zdsyTd.xls"); //
            eb.setExcelXml("zdsyTd.xml"); // 上述两步骤是把xml文件和xls文件有机组合
            eb.printExcel(request);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }

    @RequestMapping("exportExcelFc")
    public String exportExcelFc(SwDjSyQuery swDjSyQuery,String ids,HttpServletRequest request,String beginPm,String endPm) throws Exception {
        try {
            HashMap param = new HashMap();
            param.put("beginPm",beginPm);
            param.put("endPm",endPm);
            // 判断是checkbox导出，还是查询导出
            if (StringUtils.isNotBlank(ids)) {
                // 说明是checkbox导出
                param.put("ids",ids);
            } else {
                param.put("swDjSyQuery",swDjSyQuery);
            }
            List<Object> zdsyList = taxService.getZdsyFcList(param);
            List<String[]> retList = new ArrayList<String[]>();
            for(int i=0;i<zdsyList.size();i++){
                String[] tempArr = new String[15];
                for(int j=0;j<tempArr.length;j++){
                    tempArr[j] = "";
                }
                Object[] obj = (Object[]) zdsyList.get(i);
                tempArr[0] = String.valueOf(i+1);
                for(int k=1;k<tempArr.length;k++){
                    tempArr[k] = String.valueOf(obj[k-1]);
                }
                retList.add(tempArr);
            }

            HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
            ExcelBean eb = new ExcelBean();
            map.put("group1", retList);// 把retList放入group1中
            eb.setGroupMap(map);
            eb.setExcelTemplate("zdsyFc.xls"); //
            eb.setExcelXml("zdsyFc.xml"); // 上述两步骤是把xml文件和xls文件有机组合
            eb.printExcel(request);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }

    @RequestMapping("exportExcelGdzys")
    public String exportExcelGdzys(SwDjSyQuery swDjSyQuery,String ids,HttpServletRequest request,String beginPm,String endPm) throws Exception {
        try {
            HashMap param = new HashMap();

            // 判断是checkbox导出，还是查询导出
            if (StringUtils.isNotBlank(ids)) {
                // 说明是checkbox导出
                param.put("ids",ids);
            } else {
                param.put("swDjSyQuery",swDjSyQuery);
            }
            param.put("beginPm",beginPm);
            param.put("endPm",endPm);
            String excelBegin = swDjSyQuery.getExcelBegin();
            if(StringUtils.isBlank(excelBegin)){
                excelBegin = "0";
            }else{
                excelBegin = String.valueOf(Integer.parseInt(excelBegin)-1);
            }
            List<Object> zdsyList = taxService.getZdsyGdzysList(param);
            List<String[]> retList = new ArrayList<String[]>();
            for(int i=(0+Integer.parseInt(excelBegin));i<(zdsyList.size()+Integer.parseInt(excelBegin));i++){
                String[] tempArr = new String[11];
                for(int j=0;j<tempArr.length;j++){
                    tempArr[j] = "";
                }
                Object[] obj = (Object[]) zdsyList.get(i);
                tempArr[0] = String.valueOf(i+1);
                for(int k=1;k<tempArr.length;k++){
                    tempArr[k] = String.valueOf(obj[k-1]);
                }
                retList.add(tempArr);
            }

            HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
            ExcelBean eb = new ExcelBean();
            map.put("group1", retList);// 把retList放入group1中
            eb.setGroupMap(map);
            eb.setExcelTemplate("zdsyGdzys.xls"); //
            eb.setExcelXml("zdsyGdzys.xml"); // 上述两步骤是把xml文件和xls文件有机组合
            eb.printExcel(request);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }

    @RequestMapping("exportExcelQs")
    public String exportExcelQs(SwDjSyQuery swDjSyQuery,String ids,HttpServletRequest request,String beginPm,String endPm) throws Exception {
        try {
            HashMap param = new HashMap();

            // 判断是checkbox导出，还是查询导出
            if (StringUtils.isNotBlank(ids)) {
                // 说明是checkbox导出
                param.put("ids",ids);
            } else {
                param.put("swDjSyQuery",swDjSyQuery);
            }
            param.put("beginPm",beginPm);
            param.put("endPm",endPm);
            String excelBegin = swDjSyQuery.getExcelBegin();
            if(StringUtils.isBlank(excelBegin)){
                excelBegin = "0";
            }else{
                excelBegin = String.valueOf(Integer.parseInt(excelBegin)-1);
            }
            List<Object> zdsyList = taxService.getZdsyQsList(param);
            List<String[]> retList = new ArrayList<String[]>();
            for(int i=(0+Integer.parseInt(excelBegin));i<(zdsyList.size()+Integer.parseInt(excelBegin));i++){
                String[] tempArr = new String[14];
                for(int j=0;j<tempArr.length;j++){
                    tempArr[j] = "";
                }
                Object[] obj = (Object[]) zdsyList.get(i);
                tempArr[0] = String.valueOf(i+1);
                for(int k=1;k<tempArr.length;k++){
                    tempArr[k] = String.valueOf(obj[k-1]);
                }
                retList.add(tempArr);
            }

            HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
            ExcelBean eb = new ExcelBean();
            map.put("group1", retList);// 把retList放入group1中
            eb.setGroupMap(map);
            eb.setExcelTemplate("zdsyQs.xls"); //
            eb.setExcelXml("zdsyQs.xml"); // 上述两步骤是把xml文件和xls文件有机组合
            eb.printExcel(request);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }


    /**
     * 土地应用查询土地重点税源
     * @return
     */
    @RequestMapping("mapTdZdsy")
    @ResponseBody
    public  List mapZdsyTd(String nsrsbh,String djh) {
        List mapTdZdsyList = taxService.getMapTdZdsy(nsrsbh,djh);
        return mapTdZdsyList;
    }

    /**
     * 县级土地重点税源
     * @return
     */
    @RequestMapping("xjzdsysl")
    @ResponseBody
    public  List xjzdsysl(String nsrsbh,String djh) {
        List xjzdsyslList = taxService.getXJTdZdsy(nsrsbh,djh);
        return xjzdsyslList;
    }

    /**
     * 镇级土地重点税源
     * @return
     */
    @RequestMapping("zjzdsysl")
    @ResponseBody
    public  List zjzdsysl(String nsrsbh,String djh) {
        List zjzdsyslList = taxService.getZJTdZdsy(nsrsbh,djh);
        return zjzdsyslList;
    }

    /**
     * 地图应用查询房产重点税源
     * @return
     */
    @RequestMapping("mapFcZdsy")
    @ResponseBody
    public  List mapFcZdsy(String nsrsbh,String djh) {
        List mapFcZdsyList = taxService.getMapFcZdsy(nsrsbh,djh);
        return mapFcZdsyList;
    }
    /**
     * 导入excel
     */
    @RequestMapping("file/upload")
    public  String upload(Model model,HttpSession session,@RequestParam MultipartFile file) throws IllegalStateException ,IOException {

        ResponseMessage msg = new ResponseMessage();
        try{

//                        CommonsMultipartFile cf= (CommonsMultipartFile)file;
//                        DiskFileItem fi = (DiskFileItem)cf.getFileItem();
//                        File f = fi.getStoreLocation();
//
//                         FileInputStream fis = new FileInputStream(f);
//                         StringBuilder sb = new StringBuilder();
            String fileName = file.getOriginalFilename();
            Workbook rwb = null;
            InputStream is = file.getInputStream();
            //根据文件后缀名不同(xls和xlsx)获得不同的Workbook实现类对象
            if(fileName.endsWith("xls")){
                //2003
                rwb = new HSSFWorkbook(is);
            }else if(fileName.endsWith("xlsx")){
                //2007
                rwb = new XSSFWorkbook(is);
            }

            //jxl.Workbook rwb = Workbook.getWorkbook(fis);
                        // Sheet[] sheet = rwb.getSheets();
                        for (int sheetNum = 0;sheetNum < rwb.getNumberOfSheets();sheetNum++) {
                                 Sheet rs = rwb.getSheetAt(sheetNum);
                            //获得当前sheet的开始行
                            int firstRowNum  = rs.getFirstRowNum();
                            //获得当前sheet的结束行
                            int lastRowNum = rs.getLastRowNum();
                            for (int j = firstRowNum+1; j <= lastRowNum; j++) {
                                Row row = rs.getRow(j);
                                if(row == null){
                                    continue;
                                }
                                //获得当前行的开始列
                                int firstCellNum = row.getFirstCellNum();
                                //获得当前行的列数
                                int lastCellNum = row.getPhysicalNumberOfCells();
                                String[] cells = new String[row.getPhysicalNumberOfCells()];
                                String nsrsbh="";
                                for(int cellNum = firstCellNum; cellNum < lastCellNum;cellNum++){
                                    Cell cell = row.getCell(cellNum);
                                    nsrsbh=cell.getStringCellValue();
                                    taxService.setZdsyByNsrsbh(nsrsbh);
                                }

                                 }
                             }
                        rwb.close();
                        msg.setMsg("导入成功！");
                     }catch(Exception e){
                         e.printStackTrace();
                         msg.setMsg("导入失败！");
                     }


        List<SDmDwxxCz> allQxList = dwxxService.getAllQxList();
        model.addAttribute("allQxList",allQxList);
        //获取所有主管税务机关
        List zgswjgList = dicServiceImpl.findAllZgswjg();
        model.addAttribute("zgswjgList",zgswjgList);
        return "landtax/fzjc/zdsyTd";
    }
}
