package cn.gtmap.landtax.web.fzjc;

import cn.gtmap.landtax.entity.SDmDwxxCz;
import cn.gtmap.landtax.model.dictionary.ResponseMessage;
import cn.gtmap.landtax.model.dictionary.Zdlx;
import cn.gtmap.landtax.model.query.GtSwTzQuery;
import cn.gtmap.landtax.model.query.ZdQuery;
import cn.gtmap.landtax.printexcel.access.ExcelBean;
import cn.gtmap.landtax.service.DwxxService;
import cn.gtmap.landtax.service.TaxService;
import cn.gtmap.landtax.service.ZdService;
import cn.gtmap.landtax.util.CommonUtil;
import cn.gtmap.landtax.util.ObjectValueManager;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * .
 * <p/>
 * 宗地
 * @author shenjian
 * @version V1.0, 2014/8/18
 */
@Controller
@RequestMapping("/zd")
public class ZdController {
    @Autowired
    private ZdService zdService;
    @Autowired
    private DwxxService dwxxService;
    @Autowired
    TaxService taxService;

    @RequestMapping("list")
    public String zdList(Model model,String zdlx) throws Exception{
        //获取所有区县信息
        List<SDmDwxxCz> allQxList = dwxxService.getUserQxList();
        model.addAttribute("allQxList",allQxList);
        if (allQxList.size() == 1) {
            model.addAttribute("selQxdm",allQxList.get(0).getDwdm());
            model.addAttribute("hideXzq","true");
        }
        model.addAttribute("zdlx",zdlx);
        //加载税源种类
        Map<String,Boolean> taxTypeConf = CommonUtil.getSyTypes();
        model.addAttribute("taxTypeConf",taxTypeConf);
        model.addAttribute(ObjectValueManager.LOAD_FCS,taxTypeConf.get(ObjectValueManager.LOAD_FCS)?"true":"false");
        return "landtax/fzjc/zdtz";
    }

    @RequestMapping("allQxJson")
    @ResponseBody
    public Object allQxJson(Model model) {
        List<SDmDwxxCz> allQxList = dwxxService.getUserQxList();
        return allQxList;
    }

    @RequestMapping("zdJson")
    @ResponseBody
    public Object getZd(Model model,Pageable request,ZdQuery zdQuery) {

        return zdService.findZd(zdQuery,request);
    }

    @RequestMapping("exportExcelTz")
    public Object exportExcelTz(Model model,ZdQuery zdQuery,HttpServletRequest request) {
        try {

            List<ZdQuery> zdList =  zdService.findZdList(zdQuery);
            List<String[]> retList = new ArrayList<String[]>();
            String excelBegin = zdQuery.getExcelBegin();
            if(StringUtils.isBlank(excelBegin)){
                excelBegin = "0";
            }else{
                excelBegin = String.valueOf(Integer.parseInt(excelBegin)-1);
            }
            for(int i=(0+Integer.parseInt(excelBegin));i<(zdList.size()+Integer.parseInt(excelBegin));i++){
                String[] tempArr = new String[9];
                for(int j=0;j<tempArr.length;j++){
                    tempArr[j] = "";
                }
                ZdQuery zdQueryTemp = zdList.get(i-Integer.parseInt(excelBegin));
                tempArr[0] = String.valueOf(i + 1);
                tempArr[1] = zdQueryTemp.getDjh();
                tempArr[2] = zdQueryTemp.getQlrmc();
                tempArr[3] = zdQueryTemp.getTdzlzd();
                if(zdQuery.getZdlx().equals(Zdlx.ZSZD.toString())){
                    tempArr[4] = zdQueryTemp.getTdytmc();
                }

                retList.add(tempArr);
            }

            HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
            ExcelBean eb = new ExcelBean();
            map.put("group1", retList);// 把retList放入group1中
            eb.setGroupMap(map);
            if(zdQuery.getZdlx().equals(Zdlx.ZSZD.toString())){
                eb.setExcelTemplate("zszdTz.xls"); //
                eb.setExcelXml("zszdTz.xml"); // 上述两步骤是把xml文件和xls文件有机组合
            }else if(zdQuery.getZdlx().equals(Zdlx.XNZD.toString())){
                eb.setExcelTemplate("xnzdTz.xls"); //
                eb.setExcelXml("xnzdTz.xml"); // 上述两步骤是把xml文件和xls文件有机组合
            }

            eb.printExcel(request);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";

    }


    @RequestMapping("getJdByQx")
    @ResponseBody
    public Object getJdByQx(Model model,String qx) {
        List<SDmDwxxCz> jdList = dwxxService.getJdByQx(qx);
        return jdList;
    }

    @RequestMapping("getJfByJd")
    @ResponseBody
    public Object getJfByJd(Model model,String jd) {
        List<SDmDwxxCz> jdList = dwxxService.getJfByJd(jd);
        return jdList;
    }

    @RequestMapping("getSysByDjh")
    @ResponseBody
    public Object getSysByDjh(Model model,String djh) {
        return zdService.getSysByDjhs(djh);
    }


    @RequestMapping("getSwjgByQx")
    @ResponseBody
    public Object getSwjgByQx(Model model,String qx) {
        return taxService.getSwjgByQx(qx);
    }

    @RequestMapping("getTdjbByQxLike")
    @ResponseBody
    public Object getTdjbByQxLike(Model model,String qx) {
        if(StringUtils.isNotBlank(qx))
            return  zdService.getTdjbByQxLike(qx);
        return null;
    }

    //宗地供地挂接
    @RequestMapping("zdGdGj")
    public String  zdGdGj(Model model){
        return "landtax/fzjc/zdGdGj";
    }


    @RequestMapping("doZdGdGj")
    @ResponseBody
    public Object doZdGdGj(Model model,String djh,String xmId) {
        ResponseMessage responseMessage = new ResponseMessage();
        String msg = zdService.doZdGdGj(djh,xmId);
        responseMessage.setMsg(msg);
        return responseMessage;
    }

}
