package cn.gtmap.landtax.web.fzjc;

import cn.gtmap.landtax.model.query.TddjydQuery;
import cn.gtmap.landtax.service.TddjydcxService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;
import java.util.Map;

@Controller
@RequestMapping("/tddjydcx")
public class TddjydcxController {

    @Autowired
    private TddjydcxService tddjydcxService;

    @RequestMapping("/defaultShow")
    public String defaultShow(Model model){
        List tdjbList = tddjydcxService.getTdjbZd();
        model.addAttribute("tdjbList",tdjbList);
        return "landtax/fzjc/tddjydcx";
    }

    @RequestMapping("/getTdjb")
    @ResponseBody
    public  List getTdjb(){
        return tddjydcxService.getTdjbZd();
    }

    @RequestMapping("/findTddjyd")
    @ResponseBody
    public Object findTddjyd(Model model, Pageable pageable, TddjydQuery tddjydQuery){

        return tddjydcxService.selectByCondition(tddjydQuery,pageable);
    }

    @RequestMapping("/shwoHistory")
    public String shwoHistory(Model model,String syuuid){
        model.addAttribute("syuuid",syuuid);
        return "landtax/fzjc/cxzj/ydHistory";
    }

    @RequestMapping("/getHistory")
    @ResponseBody
    public List getHistory(String syuuid){
        return  tddjydcxService.getHistoryBySyuuId(syuuid);
    }




}
