package cn.gtmap.landtax.web.fzjc;

import cn.gtmap.landtax.entity.*;
import cn.gtmap.landtax.model.dictionary.*;
import cn.gtmap.landtax.model.query.*;
import cn.gtmap.landtax.model.query.MjydQuery;
import cn.gtmap.landtax.print.XMLBuildHelper;
import cn.gtmap.landtax.printexcel.access.ExcelBean;
import cn.gtmap.landtax.service.*;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.CommonUtil;
import cn.gtmap.landtax.util.ObjectValueManager;
import com.alibaba.fastjson.JSON;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.persistence.Query;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 税源管理,查询和修改等
 *
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2014/6/27
 */
@Controller
@RequestMapping("/ts")
public class TaxSourceController{
    @Autowired
    TaxService taxService;
    @Autowired
    private ZdService zdService;
    @Autowired
    SysUserService sysUserService;
    @Autowired
    BaseRepository baseRepository;
    @Autowired
    private DwxxService dwxxService;
    @Autowired
    GdzysService gdzysService;
    @Autowired
    private TjService tjService;
    @Autowired
    SwDjQsService swDjQsService;

    @RequestMapping("")
    public String taxSourceList(Model model,String dw,String bj,String ls,String sc,String msrd,String zdsy,String sycx,String gkq, String setj,String djbj,String djls)throws Exception {
        //宗地定位
        model.addAttribute("dw",dw);
        model.addAttribute("bj",bj);
        model.addAttribute("ls",ls);
        model.addAttribute("sc",sc);
        model.addAttribute("msrd",msrd);
        model.addAttribute("zdsy",zdsy);
        model.addAttribute("sycx",sycx);
        model.addAttribute("djbj",djbj);
        model.addAttribute("djls",djls);
        //获取所有区县信息
        List<SDmDwxxCz> allQxList = dwxxService.getAllQxList();
        model.addAttribute("allQxList",allQxList);

        //加载税源种类
        Map<String,Boolean> taxTypeConf =CommonUtil.getSyTypes();
        model.addAttribute("taxTypeConf",taxTypeConf);
        model.addAttribute(ObjectValueManager.LOAD_FCS,taxTypeConf.get(ObjectValueManager.LOAD_FCS)?"true":"false");
        if("true".equals(gkq)){
            //计算合计
            SwDjSyQuery swDjSyQuery = new SwDjSyQuery();
            //工矿区
            swDjSyQuery.setIsGkq("1");
            HashMap result = taxService.getHj(null,swDjSyQuery);
            model.addAttribute("resultMap",result);
            return "landtax/fzjc/sytz_gkq";
        }
        if("true".equals(setj)){
            //计算合计
            SwDjSyQuery swDjSyQuery = new SwDjSyQuery();
            HashMap result = taxService.getHj(null,swDjSyQuery);
            model.addAttribute("resultMap",result);
            return "landtax/fzjc/setj";
        }
        if("true".equals(sycx)){
            //计算合计
            HashMap result = taxService.getHj(null,new SwDjSyQuery());
            model.addAttribute("resultMap",result);
            return "landtax/fzjc/sytz";
        }
        return "landtax/fzjc/sytz_fuc";

    }

//南京需求面积疑点差异
    @RequestMapping("mjydcy")
    public String mjydcy(Model model) throws Exception{
        UserInfo userInfo = SessionUtil.getCurrentUser();
        if(userInfo!=null){
            String regionCode = userInfo.getRegionCode();
            model.addAttribute("regionCode",regionCode);
        }
        //获取所有区县信息
        List<SDmDwxxCz> allQxList = dwxxService.getAllQxList();
        model.addAttribute("allQxList",allQxList);

        //加载税源种类
        Map<String,Boolean> taxTypeConf =CommonUtil.getSyTypes();
        model.addAttribute("taxTypeConf",taxTypeConf);
        model.addAttribute(ObjectValueManager.LOAD_FCS,taxTypeConf.get(ObjectValueManager.LOAD_FCS)?"true":"false");
        HashMap result = taxService.getMjHj(null, new SwDjSyQuery());
        model.addAttribute("resultMap",result);
        return "landtax/fzjc/mjydcy";
    }
    @RequestMapping("czrxx")
    public String czrxx(Model model, String syId, String djh, String cz_type){
        List czr = taxService.findCzrBySyId(syId, cz_type);
        model.addAttribute("czr", czr);
        model.addAttribute("cz_type", cz_type);
        model.addAttribute("djh", djh);
        model.addAttribute("syId", syId);

        String title = "地籍号" + djh + ("TD".equals(cz_type)?"土地":"房产") + "承租人信息";
        model.addAttribute("title", title);
        return "landtax/fzjc/czrxx";
    }

    @RequestMapping("addCzrxx")
    @ResponseBody
    public String addCzrxx(Model model, String nsrsbh, String nsrmc, String syId, String cz_type){
        String flag = taxService.addCzrxx(nsrsbh, nsrmc, syId, cz_type);
        return flag;
    }

    @RequestMapping("deleteCzrxx")
    @ResponseBody
    public String deleteCzrxx(Model model, String nsrsbh, String syId, String cz_type){
        String flag = taxService.deleteCzrxx(nsrsbh, syId, cz_type);
        return flag;
    }

    @RequestMapping("hjJson")
    @ResponseBody
    public Object hjJson(String sylx,SwDjSyQuery swDjSyQuery){
        HashMap result = taxService.getHj(sylx,swDjSyQuery);
        return result;
    }
    @RequestMapping("MjydHjJson")
    @ResponseBody
    public Object mjydHjJson(String sylx,SwDjSyQuery swDjSyQuery){
        HashMap result = taxService.getMjHj(sylx,swDjSyQuery);
        return result;
    }
    @RequestMapping("mjydJson")
    @ResponseBody
    public Object getMjydTd(Model model,MjydQuery mjydQuery,Pageable request) {
        return taxService.findMjydTd(mjydQuery,request);
    }
//导出面积疑点台账
    @RequestMapping("exportMjydTz")
    public String exportExcelTz(HttpServletRequest request, MjydQuery mjydQuery,String ids) throws Exception {

        try {
            HashMap param = new HashMap();
            // 判断是checkbox导出，还是查询导出
            if (StringUtils.isNotBlank(ids)) {
                // 说明是checkbox导出
                param.put("ids",ids);
            } else {
                param.put("mjydQuery",mjydQuery);
            }

            List<HashMap<String, Object>> list = taxService.findMjydTdForExp(param);
            List<String[]> retList = new ArrayList<String[]>();
            for (int i = 0; i < list.size(); i++) {
                String[] tempArr = new String[16];
                for (int j = 0; j < tempArr.length; j++) {
                    tempArr[j] = "";
                }

                tempArr[0] = String.valueOf(i + 1);
                tempArr[1] = String.valueOf(list.get(i).get("DJH"));
                tempArr[2] = String.valueOf(list.get(i).get("NSRSBH"));
                tempArr[3] = String.valueOf(list.get(i).get("NSRMC"));
                tempArr[4] =String.valueOf(list.get(i).get("TDZL")) ;
                tempArr[5] = String.valueOf(list.get(i).get("MJ_ZD"));
                tempArr[6] = String.valueOf(list.get(i).get("MJCE_Q"));
                tempArr[7] = String.valueOf(list.get(i).get("MJCE_Z")) ;
                tempArr[8] = String.valueOf(list.get(i).get("MJ_Q"));
                tempArr[9] =String.valueOf(list.get(i).get("MJ_Z")) ;
                tempArr[10] =String.valueOf(list.get(i).get("SCSJ")) ;
                tempArr[11] =String.valueOf(list.get(i).get("XCSJ")) ;
                tempArr[12] = String.valueOf(list.get(i).get("BGSJ"));
                tempArr[13] = String.valueOf(list.get(i).get("ZGSWJMC")) ;
                tempArr[14] = String.valueOf(list.get(i).get("ZT"));


                retList.add(tempArr);
            }

            String excelTemplate = "mjydTz.xls";
            String excelXml = "mjydTz.xml";


            HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
            ExcelBean eb = new ExcelBean();
            map.put("group1", retList);// 把retList放入group1中
            eb.setGroupMap(map);
            eb.setExcelTemplate(excelTemplate); //
            eb.setExcelXml(excelXml); // 上述两步骤是把xml文件和xls文件有机组合
            eb.printExcel(request);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }

    @RequestMapping("syJson_gkq")
    @ResponseBody
    public Object getSwdjSy_gkq(Model model,Pageable request,String sylx,SwDjSyQuery swDjSyQuery) {
        if(StringUtils.isBlank(sylx)){
            sylx=Sylx.TDSY.toString();
        }
        swDjSyQuery.setIsGkq("1");
        if(Sylx.TDSY.toString().equals(sylx) ){
            return taxService.findSwdjTdMap(swDjSyQuery, request);
        }else if(Sylx.FCSY.toString().equals(sylx) ){
            return taxService.findSwdjFcMap(swDjSyQuery,request);
        }
        return null;
    }

    @RequestMapping("syJson")
    @ResponseBody
    public Object getSwdjSy(Model model,Pageable request,String sylx,SwDjSyQuery swDjSyQuery,GdzysQuery gdzysQuery,SwDjQsQuery swDjQsQuery,String isGkq) {
        if(StringUtils.isBlank(sylx)){
            sylx=Sylx.TDSY.toString();
        }
        if(Sylx.TDSY.toString().equals(sylx) ){
            //工矿区
            if("1".equals(isGkq)){
                swDjSyQuery.setIsGkq("1");
            }
            return taxService.findSwdjTdMap(swDjSyQuery, request);
        }else if(Sylx.FCSY.toString().equals(sylx) ){
            return taxService.findSwdjFcMap(swDjSyQuery,request);
        }else if(Sylx.GDZYS.toString().equals(sylx)  ){
            /*String xzqdm = dwxxService.getUserQxDm();
            if (StringUtils.isNotBlank(xzqdm) && StringUtils.isBlank(gdzysQuery.getPcXzqdm())){
                gdzysQuery.setPcXzqdm(xzqdm);
            }*/
            Object oo = gdzysService.findGdzystz(gdzysQuery, request);
            return oo;
        }

        else if(StringUtils.isBlank(sylx)|| Sylx.QS.toString().equals(sylx) ){
            String xzqdm = dwxxService.getUserQxDm();
            if (StringUtils.isNotBlank(xzqdm) && StringUtils.isBlank(swDjQsQuery.getXmXzqdm())){
                swDjQsQuery.setXmXzqdm(xzqdm);
            }
            Object obj =  swDjQsService.findQstz(swDjQsQuery, request);
            return obj;
        }

        return null;
    }


    @RequestMapping("syJsonInfo")
    @ResponseBody
    public Object getSwdjSyInfo(Model model,Pageable request,String sylx,SwDjSyQuery swDjSyQuery,GdzysQuery gdzysQuery,SwDjQsQuery swDjQsQuery,String isGkq) {
        if(StringUtils.isBlank(sylx)){
            sylx=Sylx.TDSY.toString();
        }
        if(Sylx.TDSY.toString().equals(sylx) ){
            //工矿区
            if("1".equals(isGkq)){
                swDjSyQuery.setIsGkq("1");
            }
            return taxService.findSwdjTdMapInfo(swDjSyQuery, request);
        }else if(Sylx.FCSY.toString().equals(sylx) ){
            return taxService.findSwdjFcMap(swDjSyQuery,request);
        }else if(Sylx.GDZYS.toString().equals(sylx)  ){
            /*String xzqdm = dwxxService.getUserQxDm();
            if (StringUtils.isNotBlank(xzqdm) && StringUtils.isBlank(gdzysQuery.getPcXzqdm())){
                gdzysQuery.setPcXzqdm(xzqdm);
            }*/
            Object oo = gdzysService.findGdzystz(gdzysQuery, request);
            return oo;
        }

        else if(StringUtils.isBlank(sylx)|| Sylx.QS.toString().equals(sylx) ){
            String xzqdm = dwxxService.getUserQxDm();
            if (StringUtils.isNotBlank(xzqdm) && StringUtils.isBlank(swDjQsQuery.getXmXzqdm())){
                swDjQsQuery.setXmXzqdm(xzqdm);
            }
            Object obj =  swDjQsService.findQstz(swDjQsQuery, request);
            return obj;
        }

        return null;
    }


    @RequestMapping("exportExcelTz")
    public String exportExcelTz(String sylx,SwDjSyQuery swDjSyQuery,String ids,HttpServletRequest request,String isGkq) throws Exception {
        if("1".equals(isGkq)){
            swDjSyQuery.setIsGkq("1");
        }
        try {
            HashMap param = new HashMap();
            param.put("sylx",sylx);
            // 判断是checkbox导出，还是查询导出
            if (StringUtils.isNotBlank(ids)) {
                // 说明是checkbox导出
                param.put("ids",ids);
            } else {
                param.put("swDjSyQuery",swDjSyQuery);
            }
            String excelBegin = swDjSyQuery.getExcelBegin();
            if(StringUtils.isBlank(excelBegin)){
                excelBegin = "0";
            }else{
                excelBegin = String.valueOf(Integer.parseInt(excelBegin)-1);
            }
            List<SwDjSyQuery> swdjTzList = taxService.getSwdjTzList(param);
            List<String[]> retList = new ArrayList<String[]>();
            for(int i=(0+Integer.parseInt(excelBegin));i<(swdjTzList.size()+Integer.parseInt(excelBegin));i++){
                String[] tempArr = new String[20];
                for(int j=0;j<tempArr.length;j++){
                    tempArr[j] = "";
                }
                SwDjSyQuery temp = swdjTzList.get(i-Integer.parseInt(excelBegin));
                if(sylx.equals(Sylx.TDSY.toString())) {
                    tempArr[0] = String.valueOf(i + 1 - Integer.parseInt(excelBegin));
                    tempArr[1] = temp.getDjh();
                    tempArr[2] = temp.getNsrsbh();
                    tempArr[3] = temp.getNsrmc();
                    tempArr[4] = temp.getTdzl();
                    tempArr[5] = String.valueOf(temp.getScmjZd());

                    tempArr[6] = String.valueOf(temp.getScmj());
                    tempArr[7] = String.valueOf(temp.getMsmj());
                    tempArr[8] = String.valueOf(temp.getYnmj());
                    tempArr[9] = String.valueOf(temp.getDwse());
                    tempArr[10] = String.valueOf(temp.getMsse());
                    tempArr[11] = String.valueOf(temp.getNynseTd());

                    tempArr[12] = temp.getZgkgMc();
                    tempArr[13] = temp.getSgyMc();
                    String sgztDm = temp.getSgztDm();
                    tempArr[14] = Sgzt.getMcByDm(sgztDm);
                    String tdyt = temp.getTdsyytDm();
                    tempArr[15] = Tdyt.getMcByDm(tdyt);
                } else if(sylx.equals(Sylx.FCSY.toString())) {
                    tempArr[0] = String.valueOf(i + 1);
                    tempArr[1] = temp.getDjh();
                    tempArr[2] = temp.getNsrsbh();
                    tempArr[3] = temp.getNsrmc();
                    tempArr[4] = temp.getFczl();

                    tempArr[5] = String.valueOf(temp.getFcyz());
                    tempArr[6] = String.valueOf(temp.getFcyzYs());
                    tempArr[7] = String.valueOf(temp.getFcyzMs());
                    tempArr[8] = String.valueOf(temp.getYnseZy());
                    tempArr[9] = String.valueOf(temp.getNzj());
                    tempArr[10] = String.valueOf(temp.getSl());
                    tempArr[11] = String.valueOf(temp.getYnseCz());
                    tempArr[12] = String.valueOf(temp.getNynseFc());

                    tempArr[13] = temp.getZgkgMc();
                    tempArr[14] = temp.getSgyMc();
                    String sgztDm = temp.getSgztDm();
                    tempArr[15] = Sgzt.getMcByDm(sgztDm);
                    String fcyt = temp.getFwxzDm();
                    tempArr[16] = Fwxz.getMcByDm(fcyt);
                } else if(sylx.equals(Sylx.GDZYS.toString())) {
                    tempArr[0] = String.valueOf(i + 1);
                    tempArr[1] = temp.getNsrsbh();
                    tempArr[2] = temp.getNsrmc();
                    tempArr[3] = temp.getZgkgMc();
                    tempArr[4] = temp.getPcmc();
                    tempArr[5] = temp.getPwh();
                    tempArr[6] = temp.getPzmj()==null?"":String.valueOf(temp.getPzmj().setScale(2,BigDecimal.ROUND_HALF_UP));
                    tempArr[7] = temp.getNydmj()==null?"":String.valueOf(temp.getNydmj().setScale(2, BigDecimal.ROUND_HALF_UP));
                    tempArr[8] = temp.getPzsj()==null?"":new SimpleDateFormat("yyyy-MM-dd").format(temp.getPzsj());
                    tempArr[9] = temp.getPcYddw();
                    tempArr[10] = temp.getGdzysYnse()==null?"":String.valueOf(temp.getGdzysYnse().setScale(2,BigDecimal.ROUND_HALF_UP));
                    tempArr[11] = temp.getGdzysDwse()==null?"":String.valueOf(temp.getGdzysDwse().setScale(2,BigDecimal.ROUND_HALF_UP));
                    tempArr[12] = temp.getGdzysJspz();
                    tempArr[13] = temp.getGdzysYjne()==null?"":String.valueOf(temp.getGdzysYjne().setScale(2,BigDecimal.ROUND_HALF_UP));
                    tempArr[14] = temp.getGdzysXbjse()==null?"":String.valueOf(temp.getGdzysXbjse().setScale(2,BigDecimal.ROUND_HALF_UP));
                    tempArr[15] = temp.getGdzysBz();

                } else if(sylx.equals(Sylx.QS.toString())) {
                    tempArr[0] = String.valueOf(i + 1);
                    tempArr[1] = temp.getNsrsbh();
                    tempArr[2] = temp.getNsrmc();
                    tempArr[3] = temp.getZgkgMc();
                    tempArr[4] = temp.getXmmc();
                    tempArr[5] = temp.getXmYddw();
                    tempArr[6] = temp.getGdmj()==null?"":String.valueOf(temp.getGdmj().setScale(2,BigDecimal.ROUND_HALF_UP));
                    tempArr[7] = Tdqdfs.getMcByDm(temp.getQdfs());
                    tempArr[8] = temp.getQdjg()==null?"":String.valueOf(temp.getQdjg().setScale(2,BigDecimal.ROUND_HALF_UP));
                    tempArr[9] = temp.getGdsj()==null?"":new SimpleDateFormat("yyyy-MM-dd").format(temp.getGdsj());
                    tempArr[10] = temp.getQsYnse()==null?"":String.valueOf(temp.getQsYnse().setScale(2,BigDecimal.ROUND_HALF_UP));
                    tempArr[11] = temp.getQsYjne()==null?"":String.valueOf(temp.getQsYjne().setScale(2,BigDecimal.ROUND_HALF_UP));
                    tempArr[12] = temp.getQsJspz();
                    tempArr[13] = temp.getQsXbjse()==null?"":String.valueOf(temp.getQsXbjse().setScale(2,BigDecimal.ROUND_HALF_UP));
                    tempArr[14] = temp.getQsBz();
                }
                retList.add(tempArr);
            }

            String excelTemplate = "";
            String excelXml = "";
            if(sylx.equals(Sylx.TDSY.toString())) {
                excelTemplate = "sybjTz_td.xls";
                excelXml = "sybjTz_td.xml";
            } else if(sylx.equals(Sylx.FCSY.toString())) {
                excelTemplate = "sybjTz_fc.xls";
                excelXml = "sybjTz_fc.xml";
            } else if(sylx.equals(Sylx.GDZYS.toString())) {
                excelTemplate = "sybjTz_gdzys.xls";
                excelXml = "sybjTz_gdzysQs.xml";
            } else if(sylx.equals(Sylx.QS.toString())) {
                excelTemplate = "sybjTz_qs.xls";
                excelXml = "sybjTz_Qs.xml";
            }

            HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
            ExcelBean eb = new ExcelBean();
            map.put("group1", retList);// 把retList放入group1中
            eb.setGroupMap(map);
            eb.setExcelTemplate(excelTemplate); //
            eb.setExcelXml(excelXml); // 上述两步骤是把xml文件和xls文件有机组合
            eb.printExcel(request);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }
    @RequestMapping("exportExcelTzHcjg")
    public String exportExcelTzHcjg(String sylx,SwDjSyQuery swDjSyQuery,String ids,HttpServletRequest request,String isGkq) throws Exception {
        if("1".equals(isGkq)){
            swDjSyQuery.setIsGkq("1");
        }
        try {
            HashMap param = new HashMap();
            param.put("sylx",sylx);
            // 判断是checkbox导出，还是查询导出
            if (StringUtils.isNotBlank(ids)) {
                // 说明是checkbox导出
                param.put("ids",ids);
            } else {
                param.put("swDjSyQuery",swDjSyQuery);
            }
            String excelBegin = swDjSyQuery.getExcelBegin();
            if(StringUtils.isBlank(excelBegin)){
                excelBegin = "0";
            }else{
                excelBegin = String.valueOf(Integer.parseInt(excelBegin)-1);
            }
            List<SwDjSyQuery> swdjTzList = taxService.getSwdjTzList(param);
            List<String[]> retList = new ArrayList<String[]>();
            for(int i=(0+Integer.parseInt(excelBegin));i<(swdjTzList.size()+Integer.parseInt(excelBegin));i++){
                String[] tempArr = new String[20];
                for(int j=0;j<tempArr.length;j++){
                    tempArr[j] = "";
                }
                SwDjSyQuery temp = swdjTzList.get(i-Integer.parseInt(excelBegin));
                if(sylx.equals(Sylx.TDSY.toString())) {
                    tempArr[0] = String.valueOf(i + 1 - Integer.parseInt(excelBegin));
                    tempArr[1] = temp.getDjh();
                 //   tempArr[2] = temp.getNsrsbh();
                    tempArr[2] = temp.getNsrmc();
                    tempArr[3] = temp.getTdzl();
                    tempArr[4] = String.valueOf(temp.getScmjZd());
                    tempArr[5] = temp.getGtzdbyzyy();
                    tempArr[6] = String.valueOf(temp.getScmj());

                 //   tempArr[7] = String.valueOf(temp.getMsmj());
                 //   tempArr[8] = String.valueOf(temp.getYnmj());
               //     tempArr[9] = String.valueOf(temp.getDwse());
                //    tempArr[10] = String.valueOf(temp.getMsse());
               //     tempArr[11] = String.valueOf(temp.getNynseTd());

                    tempArr[7] = temp.getZgkgMc();
                 //   tempArr[13] = temp.getSgyMc();
                 //   String sgztDm = temp.getSgztDm();
                 //   tempArr[14] = Sgzt.getMcByDm(sgztDm);
                //    String tdyt = temp.getTdsyytDm();
                //    tempArr[15] = Tdyt.getMcByDm(tdyt);
                } else if(sylx.equals(Sylx.FCSY.toString())) {
                    tempArr[0] = String.valueOf(i + 1);
                    tempArr[1] = temp.getDjh();
                    tempArr[2] = temp.getNsrsbh();
                    tempArr[3] = temp.getNsrmc();
                    tempArr[4] = temp.getFczl();

                    tempArr[5] = String.valueOf(temp.getFcyz());
                    tempArr[6] = String.valueOf(temp.getFcyzYs());
                    tempArr[7] = String.valueOf(temp.getFcyzMs());
                    tempArr[8] = String.valueOf(temp.getYnseZy());
                    tempArr[9] = String.valueOf(temp.getNzj());
                    tempArr[10] = String.valueOf(temp.getSl());
                    tempArr[11] = String.valueOf(temp.getYnseCz());
                    tempArr[12] = String.valueOf(temp.getNynseFc());

                    tempArr[13] = temp.getZgkgMc();
                    tempArr[14] = temp.getSgyMc();
                    String sgztDm = temp.getSgztDm();
                    tempArr[15] = Sgzt.getMcByDm(sgztDm);
                    String fcyt = temp.getFwxzDm();
                    tempArr[16] = Fwxz.getMcByDm(fcyt);
                } else if(sylx.equals(Sylx.GDZYS.toString())) {
                    tempArr[0] = String.valueOf(i + 1);
                    tempArr[1] = temp.getNsrsbh();
                    tempArr[2] = temp.getNsrmc();
                    tempArr[3] = temp.getZgkgMc();
                    tempArr[4] = temp.getPcmc();
                    tempArr[5] = temp.getPwh();
                    tempArr[6] = temp.getPzmj()==null?"":String.valueOf(temp.getPzmj().setScale(2,BigDecimal.ROUND_HALF_UP));
                    tempArr[7] = temp.getNydmj()==null?"":String.valueOf(temp.getNydmj().setScale(2, BigDecimal.ROUND_HALF_UP));
                    tempArr[8] = temp.getPzsj()==null?"":new SimpleDateFormat("yyyy-MM-dd").format(temp.getPzsj());
                    tempArr[9] = temp.getPcYddw();
                    tempArr[10] = temp.getGdzysYnse()==null?"":String.valueOf(temp.getGdzysYnse().setScale(2,BigDecimal.ROUND_HALF_UP));
                    tempArr[11] = temp.getGdzysDwse()==null?"":String.valueOf(temp.getGdzysDwse().setScale(2,BigDecimal.ROUND_HALF_UP));
                    tempArr[12] = temp.getGdzysJspz();
                    tempArr[13] = temp.getGdzysYjne()==null?"":String.valueOf(temp.getGdzysYjne().setScale(2,BigDecimal.ROUND_HALF_UP));
                    tempArr[14] = temp.getGdzysXbjse()==null?"":String.valueOf(temp.getGdzysXbjse().setScale(2,BigDecimal.ROUND_HALF_UP));
                    tempArr[15] = temp.getGdzysBz();

                } else if(sylx.equals(Sylx.QS.toString())) {
                    tempArr[0] = String.valueOf(i + 1);
                    tempArr[1] = temp.getNsrsbh();
                    tempArr[2] = temp.getNsrmc();
                    tempArr[3] = temp.getZgkgMc();
                    tempArr[4] = temp.getXmmc();
                    tempArr[5] = temp.getXmYddw();
                    tempArr[6] = temp.getGdmj()==null?"":String.valueOf(temp.getGdmj().setScale(2,BigDecimal.ROUND_HALF_UP));
                    tempArr[7] = Tdqdfs.getMcByDm(temp.getQdfs());
                    tempArr[8] = temp.getQdjg()==null?"":String.valueOf(temp.getQdjg().setScale(2,BigDecimal.ROUND_HALF_UP));
                    tempArr[9] = temp.getGdsj()==null?"":new SimpleDateFormat("yyyy-MM-dd").format(temp.getGdsj());
                    tempArr[10] = temp.getQsYnse()==null?"":String.valueOf(temp.getQsYnse().setScale(2,BigDecimal.ROUND_HALF_UP));
                    tempArr[11] = temp.getQsYjne()==null?"":String.valueOf(temp.getQsYjne().setScale(2,BigDecimal.ROUND_HALF_UP));
                    tempArr[12] = temp.getQsJspz();
                    tempArr[13] = temp.getQsXbjse()==null?"":String.valueOf(temp.getQsXbjse().setScale(2,BigDecimal.ROUND_HALF_UP));
                    tempArr[14] = temp.getQsBz();
                }
                retList.add(tempArr);
            }

            String excelTemplate = "";
            String excelXml = "";
            if(sylx.equals(Sylx.TDSY.toString())) {
                excelTemplate = "sybjTz_td.xls";
                excelXml = "sybjTz_td.xml";
            } else if(sylx.equals(Sylx.FCSY.toString())) {
                excelTemplate = "sybjTz_fc.xls";
                excelXml = "sybjTz_fc.xml";
            } else if(sylx.equals(Sylx.GDZYS.toString())) {
                excelTemplate = "sybjTz_gdzys.xls";
                excelXml = "sybjTz_gdzysQs.xml";
            } else if(sylx.equals(Sylx.QS.toString())) {
                excelTemplate = "sybjTz_qs.xls";
                excelXml = "sybjTz_Qs.xml";
            }

            HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
            ExcelBean eb = new ExcelBean();
            map.put("group1", retList);// 把retList放入group1中
            eb.setGroupMap(map);
            eb.setExcelTemplate(excelTemplate); //
            eb.setExcelXml(excelXml); // 上述两步骤是把xml文件和xls文件有机组合
            eb.printExcel(request);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }

    @RequestMapping("exportExcelMsTz")
    public String exportExcelMsTz(String sylx,SwDjSyQuery swDjSyQuery,String ids,HttpServletRequest request) throws Exception {
        try {
            HashMap param = new HashMap();
            param.put("sylx",sylx);
            // 判断是checkbox导出，还是查询导出
            if (StringUtils.isNotBlank(ids)) {
                // 说明是checkbox导出
                param.put("ids",ids);
            } else {
                swDjSyQuery.setIsMsTz(true);
                param.put("swDjSyQuery",swDjSyQuery);
            }
            String excelBegin = swDjSyQuery.getExcelBegin();
            if(StringUtils.isBlank(excelBegin)){
                excelBegin = "0";
            }else{
                excelBegin = String.valueOf(Integer.parseInt(excelBegin)-1);
            }
            List<SwDjSyQuery> swdjTzList = taxService.getSwdjTzList(param);
            List<String[]> retList = new ArrayList<String[]>();
            for(int i=(0+Integer.parseInt(excelBegin));i<(swdjTzList.size()+Integer.parseInt(excelBegin));i++){
                String[] tempArr = new String[11];
                for(int j=0;j<tempArr.length;j++){
                    tempArr[j] = "";
                }
                SwDjSyQuery temp = swdjTzList.get(i);
                tempArr[0] = String.valueOf(i+1);
                tempArr[1] = temp.getDjh();
                if(sylx.equals(Sylx.TDSY.toString())){
                    tempArr[2] = String.valueOf(temp.getMsmj());
                }else if(sylx.equals(Sylx.FCSY.toString())){
                    tempArr[2] = String.valueOf(temp.getFcyzMs());
                }
                if(sylx.equals(Sylx.TDSY.toString())){
                    tempArr[3] = String.valueOf(temp.getTdzl());
                }else if(sylx.equals(Sylx.FCSY.toString())){
                    tempArr[3] = String.valueOf(temp.getFczl());
                }
                String tdyt = temp.getTdyt();
                tempArr[4] = Dldm.getMcByDm(tdyt);
                tempArr[5] = temp.getNsrsbh();
                tempArr[6] = temp.getDbh();
                tempArr[7] = temp.getNsrmc();
                tempArr[8] = temp.getQlrmc();
                if(sylx.equals(Sylx.TDSY.toString())){
                    tempArr[9] = String.valueOf(temp.getScmj());
                }else if(sylx.equals(Sylx.FCSY.toString())){
                    tempArr[9] = String.valueOf(temp.getFczl());
                }
                tempArr[9] = String.valueOf(temp.getScmj());
                retList.add(tempArr);
            }

            HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
            ExcelBean eb = new ExcelBean();
            map.put("group1", retList);// 把retList放入group1中
            eb.setGroupMap(map);
            if(sylx.equals(Sylx.TDSY.toString())){
                eb.setExcelTemplate("tdmsTz.xls"); //
            }else if(sylx.equals(Sylx.FCSY.toString())){
                eb.setExcelTemplate("fcmsTz.xls"); //
            }

            eb.setExcelXml("mssyTz.xml"); // 上述两步骤是把xml文件和xls文件有机组合
            eb.printExcel(request);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }
    //重点税源台帐导出
    @RequestMapping("exportExcelZdSyTz")
    public String exportExcelZdSyTz(String sylx,SwDjSyQuery swDjSyQuery,String ids,HttpServletRequest request) throws Exception {
        try {
            HashMap param = new HashMap();
            param.put("sylx",sylx);
            // 判断是checkbox导出，还是查询导出
            if (StringUtils.isNotBlank(ids)) {
                // 说明是checkbox导出
                param.put("ids",ids);
            } else {
                swDjSyQuery.setZdsybz("1");
                param.put("swDjSyQuery",swDjSyQuery);
            }
            String excelBegin = swDjSyQuery.getExcelBegin();
            if(StringUtils.isBlank(excelBegin)){
                excelBegin = "0";
            }else{
                excelBegin = String.valueOf(Integer.parseInt(excelBegin)-1);
            }
            List<SwDjSyQuery> zdsyList = new ArrayList<SwDjSyQuery>();
            List<String[]> retList = new ArrayList<String[]>();
            if(sylx!=null&&"2".equals(sylx)){
                zdsyList = taxService.getzdsyfcList(param);
                for(int i=0;i<zdsyList.size();i++){
                    String[] tempArr = new String[19];
                    for(int j=0;j<tempArr.length;j++){
                        tempArr[j] = "";
                    }
                    SwDjSyQuery tempVo = (SwDjSyQuery)zdsyList.get(i);
                    tempArr[0] = String.valueOf(i+1);
                    tempArr[1] = tempVo.getDjh();
                    tempArr[2] = tempVo.getDbh();
                    tempArr[3] = tempVo.getNsrsbh();
                    tempArr[4] = tempVo.getNsrmc();
                    tempArr[5] = tempVo.getTdzl();
                    tempArr[6] = tempVo.getFcyz()==null?"":tempVo.getFcyz().setScale(2, BigDecimal.ROUND_HALF_UP).toString();
                    tempArr[7] = tempVo.getFcyzYs()==null?"":tempVo.getFcyzYs().setScale(2, BigDecimal.ROUND_HALF_UP).toString();
                    tempArr[8] = tempVo.getFcyzMs()==null?"":tempVo.getFcyzMs().setScale(2, BigDecimal.ROUND_HALF_UP).toString();
                    tempArr[9] = tempVo.getYnseZy()==null?"":tempVo.getYnseZy().setScale(2, BigDecimal.ROUND_HALF_UP).toString();
                    tempArr[10] = tempVo.getNzj()==null?"":tempVo.getNzj().setScale(2, BigDecimal.ROUND_HALF_UP).toString();
                    tempArr[11] = tempVo.getSl()==null?"":tempVo.getSl().setScale(2, BigDecimal.ROUND_HALF_UP).toString();
                    tempArr[12] = tempVo.getYnseCz()==null?"":tempVo.getYnseCz().setScale(2, BigDecimal.ROUND_HALF_UP).toString();
                    tempArr[13] = tempVo.getNynseFc()==null?"":tempVo.getNynseFc().setScale(2, BigDecimal.ROUND_HALF_UP).toString();
                    tempArr[14] = tempVo.getZgkgMc();
                    tempArr[15] = tempVo.getSgyMc();
                    tempArr[16] = tempVo.getSgztMc();
                    String sjly="";
                    if(tempVo.getSjly()!=null){
                        if("1".equals(tempVo.getSjly())){
                            sjly = "自动匹配";
                        }else if("2".equals(tempVo.getSjly())){
                            sjly = "人工匹配";
                        }else if("3".equals(tempVo.getSjly())){
                            sjly = "税源核查";
                        }else if("4".equals(tempVo.getSjly())){
                            sjly = "按图匹配";
                        }
                    }
                    tempArr[17] = sjly;
                    tempArr[18] = Dldm.getMcByDm(tempVo.getTdyt());
                    retList.add(tempArr);
                }
            }else if(sylx!=null&&"1".equals(sylx)){
                zdsyList = taxService.getzdsytdList(param);
                for(int i=(0+Integer.parseInt(excelBegin));i<(zdsyList.size()+Integer.parseInt(excelBegin));i++){
                    String[] tempArr = new String[18];
                    for(int j=0;j<tempArr.length;j++){
                        tempArr[j] = "";
                    }
                    SwDjSyQuery tempVo = (SwDjSyQuery)zdsyList.get(i);
                    tempArr[0] = String.valueOf(i+1);
                    tempArr[1] = tempVo.getDjh();
                    tempArr[2] = tempVo.getDbh();
                    tempArr[3] = tempVo.getNsrsbh();
                    tempArr[4] = tempVo.getNsrmc();
                    tempArr[5] = tempVo.getTdzl();
                    tempArr[6] = tempVo.getScmjZd()==null?"":tempVo.getScmjZd().setScale(2, BigDecimal.ROUND_HALF_UP).toString();
                    tempArr[7] = tempVo.getScmj()==null?"":tempVo.getScmj().setScale(2,BigDecimal.ROUND_HALF_UP).toString();
                    tempArr[8] = tempVo.getMsmj()==null?"":tempVo.getMsmj().setScale(2, BigDecimal.ROUND_HALF_UP).toString();
                    tempArr[9] = tempVo.getYnmj()==null?"":tempVo.getYnmj().setScale(2, BigDecimal.ROUND_HALF_UP).toString();
                    tempArr[10] = tempVo.getDwse()==null?"":tempVo.getDwse().setScale(2, BigDecimal.ROUND_HALF_UP).toString();
                    tempArr[11] = tempVo.getMsse()==null?"":tempVo.getMsse().setScale(2, BigDecimal.ROUND_HALF_UP).toString();
                    tempArr[12] = tempVo.getNynseTd()==null?"":tempVo.getNynseTd().setScale(2, BigDecimal.ROUND_HALF_UP).toString();
                    tempArr[13] = tempVo.getZgkgMc();
                    tempArr[14] = tempVo.getSgyMc();
                    tempArr[15] = tempVo.getSgztMc();
                    String sjly="";
                    if(tempVo.getSjly()!=null){
                        if("1".equals(tempVo.getSjly())){
                            sjly = "自动匹配";
                        }else if("2".equals(tempVo.getSjly())){
                            sjly = "人工匹配";
                        }else if("3".equals(tempVo.getSjly())){
                            sjly = "税源核查";
                        }else if("4".equals(tempVo.getSjly())){
                            sjly = "按图匹配";
                        }
                    }
                    tempArr[16] = sjly;
                    tempArr[17] = Dldm.getMcByDm(tempVo.getTdyt());
                    retList.add(tempArr);
                }
            }else if(sylx!=null&&"3".equals(sylx)){
                zdsyList = taxService.getSwdjTzList(param);
                for(int i=(0+Integer.parseInt(excelBegin));i<(zdsyList.size()+Integer.parseInt(excelBegin));i++){
                    String[] tempArr = new String[18];
                    for(int j=0;j<tempArr.length;j++){
                        tempArr[j] = "";
                    }
                    SwDjSyQuery temp = (SwDjSyQuery)zdsyList.get(i);
                    tempArr[0] = String.valueOf(i + 1);
                    tempArr[1] = temp.getGlbm();
                    tempArr[2] = temp.getNsrmc();
                    tempArr[3] = temp.getZgkgMc();
                    tempArr[4] = temp.getPcmc();
                    tempArr[5] = temp.getPwh();
                    tempArr[6] = temp.getPzmj() ==null?"":String.valueOf(temp.getPzmj().setScale(2, BigDecimal.ROUND_HALF_UP));
                    tempArr[7] = temp.getNydmj() ==null?"":String.valueOf(temp.getNydmj().setScale(2, BigDecimal.ROUND_HALF_UP));
                    tempArr[8] = temp.getPzsj() ==null?"":new SimpleDateFormat("yyyy-MM-dd").format(temp.getPzsj());
                    tempArr[9] = temp.getPcYddw();
                    tempArr[10] = temp.getGdzysYnse() ==null?"":String.valueOf(temp.getGdzysYnse().setScale(2, BigDecimal.ROUND_HALF_UP));
                    tempArr[11] = temp.getGdzysDwse() ==null?"":String.valueOf(temp.getGdzysDwse().setScale(2, BigDecimal.ROUND_HALF_UP));
                    tempArr[12] = temp.getGdzysJspz();
                    tempArr[13] = temp.getGdzysYjne()==null?"":String.valueOf(temp.getGdzysYjne().setScale(2,BigDecimal.ROUND_HALF_UP));
                    tempArr[14] = temp.getGdzysXbjse()==null?"":String.valueOf(temp.getGdzysXbjse().setScale(2,BigDecimal.ROUND_HALF_UP));
                    tempArr[15] = temp.getGdzysBz();
                    retList.add(tempArr);
                }
            }else if(sylx!=null&&"4".equals(sylx)){
                zdsyList = taxService.getSwdjTzList(param);
                for(int i=(0+Integer.parseInt(excelBegin));i<(zdsyList.size()+Integer.parseInt(excelBegin));i++){
                    String[] tempArr = new String[18];
                    for(int j=0;j<tempArr.length;j++){
                        tempArr[j] = "";
                    }
                    SwDjSyQuery temp = (SwDjSyQuery)zdsyList.get(i);
                    tempArr[0] = String.valueOf(i + 1);
                    tempArr[1] = temp.getGlbm();
                    tempArr[2] = temp.getNsrmc();
                    tempArr[3] = temp.getZgkgMc();
                    tempArr[4] = temp.getXmmc();
                    tempArr[5] = temp.getXmYddw();
                    tempArr[6] = temp.getGdmj()==null?"":String.valueOf(temp.getGdmj().setScale(2, BigDecimal.ROUND_HALF_UP));
                    tempArr[7] = Tdqdfs.getMcByDm(temp.getQdfs());
                    tempArr[8] = temp.getQdjg()==null?"":String.valueOf(temp.getQdjg().setScale(2, BigDecimal.ROUND_HALF_UP));
                    tempArr[9] = temp.getGdsj()==null?"":new SimpleDateFormat("yyyy-MM-dd").format(temp.getGdsj());
                    tempArr[10] = temp.getQsYnse()==null?"":String.valueOf(temp.getQsYnse().setScale(2, BigDecimal.ROUND_HALF_UP));
                    tempArr[11] = temp.getQsYjne()==null?"":String.valueOf(temp.getQsYjne().setScale(2, BigDecimal.ROUND_HALF_UP));
                    tempArr[12] = temp.getQsJspz();
                    tempArr[13] = temp.getQsXbjse()==null?"":String.valueOf(temp.getQsXbjse().setScale(2,BigDecimal.ROUND_HALF_UP));
                    tempArr[14] = temp.getQsBz();
                    retList.add(tempArr);
                }
            }

            HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
            ExcelBean eb = new ExcelBean();
            map.put("group1", retList);// 把retList放入group1中
            eb.setGroupMap(map);
            if(sylx.equals(Sylx.TDSY.toString())){
                eb.setExcelTemplate("zdsycxtd.xls"); //
                eb.setExcelXml("zdsycxtd.xml");
            }else if(sylx.equals(Sylx.FCSY.toString())){
                eb.setExcelTemplate("zdsycxfc.xls"); //
                eb.setExcelXml("zdsycxfc.xml");
            }else if(sylx.equals(Sylx.GDZYS.toString())){
                eb.setExcelTemplate("sybjTz_gdzys_zdsy.xls"); //
                eb.setExcelXml("sybjTz_gdzysQs.xml");
            }else if(sylx.equals(Sylx.QS.toString())){
                eb.setExcelTemplate("sybjTz_qs_zdsy.xls"); //
                eb.setExcelXml("sybjTz_Qs.xml");
            }
             // 上述两步骤是把xml文件和xls文件有机组合
            eb.printExcel(request);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }
    @RequestMapping("info")
    public String getSwdjSyXx(Model model,String tdId,String fcId,String djh){
        SwDjSyQuery syxx = taxService.getSwDjSyById(tdId,fcId);
        if(StringUtils.isNotBlank(djh)){
            List tddjList = taxService.getTddjByDjhLike(djh);
            model.addAttribute("tddjList",tddjList);
        }
        model.addAttribute("syxx",syxx);
        Zd zd = zdService.findZdByDjh(djh);
        model.addAttribute("zd",zd);

        String is_open_nsrxx_xg = AppConfig.getProperty("IS_OPEN_NSRXX_XG");
        model.addAttribute("is_open_nsrxx_xg", is_open_nsrxx_xg);

        return "landtax/fzjc/sytzSyxx";
    }

    @RequestMapping("taxMap")
    public String getSwdjSyXxByMap(Model model,String tdId,String fcId,String djh,String noSave,String mjyd)throws Exception{
        String userIdInfo = SessionUtil.getCurrentUserId();
        String remark=sysUserService.getUserVo(userIdInfo).getRemark();
        String canXg="";
        if(StringUtils.isNotBlank(remark)&&remark.indexOf("swy")>=0){
            canXg="1";
        }
        model.addAttribute("canXg",canXg);
        String hydm_level =AppConfig.getProperty("HYDM_LEVELS");
        model.addAttribute("hydm_level",hydm_level);
        SwDjSyQuery syxx = taxService.getSwDjSyById(tdId,fcId);
        model.addAttribute("syxx",syxx);
        String hydm=syxx.getHyDm();
        if(StringUtils.isNotEmpty(hydm)){
            List hydl=taxService.getHydl(hydm);
            if(hydl!=null && hydl.size() > 0){
                Object hydmdl=hydl.get(0);
                model.addAttribute("hydl",hydmdl);
                if(hydm.length()>3){
                    List hyzl=taxService.getHyzl(hydm);
                    Object hydmzl=hyzl.get(0);
                    model.addAttribute("hyzl",hydmzl);
                }
            }

        }
        model.addAttribute("noSave",noSave);
        Map<String,Boolean> taxTypeConf =CommonUtil.getSyTypes();
        model.addAttribute("taxTypeConf",taxTypeConf);
        model.addAttribute(ObjectValueManager.LOAD_FCS,taxTypeConf.get(ObjectValueManager.LOAD_FCS)?"true":"false");
        if(StringUtils.isNotBlank(djh)){
            List tddjList = taxService.getTddjByDjhLike(djh);
            model.addAttribute("tddjList",tddjList);
        }

        String is_open_nsrxx_xg = AppConfig.getProperty("IS_OPEN_NSRXX_XG");
        model.addAttribute("is_open_nsrxx_xg",is_open_nsrxx_xg);

        if(StringUtils.isBlank(djh)){
            djh=syxx.getDjh();
            List tddjList = taxService.getTddjByDjhLike(djh);
            model.addAttribute("tddjList",tddjList);
            Zd zd = zdService.findZdByDjh(djh);
            model.addAttribute("zd",zd);
            return "landtax/map/mapSyxx";
        }else if(StringUtils.isNotBlank(mjyd)){
            Zd zd = zdService.findZdByDjh(djh);
            model.addAttribute("zd",zd);
            return "landtax/map/mapSyxx";
        }
        else if(StringUtils.isNotBlank(noSave)){
            Zd zd = zdService.findZdByDjh(djh);
            model.addAttribute("zd",zd);
            return "landtax/map/mapSyxx";
        }else{
            Zd zd = zdService.findZdByDjh(djh);
            model.addAttribute("zd",zd);
            return "landtax/fzjc/zdtzSyxx";
        }

    }

    @RequestMapping("history")
    public String getSwdjSyHistory(Model model,String syId, String sylx)throws Exception{

        Map<String,Boolean> taxTypeConf =CommonUtil.getSyTypes();
        model.addAttribute("taxTypeConf",taxTypeConf);

        if(StringUtils.isNotBlank(syId)){
            SwDjSy swDjSy = taxService.getSwDjSyById(syId);
           // model.addAttribute("historyList",swDjSy.getSwDjSyHisSet());
            Set<SwDjSyHis> swDjSyHisSet=swDjSy.getSwDjSyHisSet();
            for(SwDjSyHis obj:swDjSyHisSet){
                String userId=obj.getUserid();
                String xgr=taxService.getCreateUser(userId);
                if(StringUtils.isBlank(obj.getXgr()))
                    obj.setXgr(xgr);
            }
            model.addAttribute("historyList",swDjSyHisSet);
        }

        String resultStr = "";
        String tag = "";
        if(sylx.equals("1")){
            tag = "土地税源修改历史";
        }else if(sylx.equals("2")){
            tag = "房产税源修改历史";
        }else if(sylx.equals("3")){
            tag = "耕地占用税修改历史";
        }else if(sylx.equals("4")){
            tag = "契税修改历史";
        }else if (sylx.equals("5")){
            tag = "地籍信息修改历史";
        }
        model.addAttribute("title",tag);
        if (sylx.equals("1") || sylx.equals("2")) {
            resultStr = "landtax/fzjc/tdsyxgls";
        } else if (sylx.equals("3")) {
            resultStr = "landtax/fzjc/gdzyssyxgls";
        } else if (sylx.equals("4")) {
            resultStr = "landtax/fzjc/qssyxgls";
        }else if (sylx.equals("5")){
            resultStr = "landtax/fzjc/djxgls";
        }
        return resultStr;
    }

    @RequestMapping("historyTimeAxis")
    public String getSwdjSyHistoryTimeAxis(Model model,String TD_ID)throws Exception{
        model.addAttribute("TD_ID",TD_ID);
        return "landtax/fzjc/TimeAxis";
    }
    @RequestMapping("getHistory")
    @ResponseBody
    public List getHistoryTimeAxis(Model model,String TD_ID)throws Exception{

        return taxService.getHistoryByTd_Id(TD_ID);
    }


    @RequestMapping("djh")
    @ResponseBody
    public Object getSwdjSyXxByDjh(Model model,String djh) {
        List<SwDjSyQuery> syxx = taxService.getSwDjSyByDjh(djh);
        return syxx;
    }

    @RequestMapping("addInput")
    public String getZdByDjh(Model model,String djh) {
        Zd zd = zdService.findZdByDjh(djh);
        model.addAttribute("zd",zd);
        //自动生成土地使用号
        String dbh = taxService.createDbhByDjh(djh);

        String sgyMc = SessionUtil.getCurrentUser().getUsername();
        String regionCode = SessionUtil.getCurrentUser().getRegionCode();
        String zgkgDm = taxService.findZgkgDmByRegionCode(regionCode);
        SwDjSyQuery swDjSyQuery = new SwDjSyQuery();
        if(StringUtils.isNotBlank(zgkgDm)){
            swDjSyQuery.setZgkgDm(zgkgDm);
        }
        swDjSyQuery.setDbh(dbh);
        swDjSyQuery.setSgyMc(sgyMc);
        BigDecimal jsbl = new BigDecimal(AppConfig.getProperty("jsbl"));
        swDjSyQuery.setJsbl(jsbl);

        String dwseStr = taxService.getDwseByTddj(zd.getTddj());
        swDjSyQuery.setTddj(zd.getTddj());
        if(StringUtils.isNotBlank(dwseStr)){
            swDjSyQuery.setDwse(new BigDecimal(dwseStr));
        }
        //获取房产坐落县，镇
        String xian = dwxxService.getDwxxByDwdm(djh.substring(0,6)).getDwmc();
        String zhen = dwxxService.getDwxxByDwdm(djh.substring(0,9)).getDwmc();
        swDjSyQuery.setFczlXian(xian);
        swDjSyQuery.setFczlZhen(zhen);
        model.addAttribute("syxx",swDjSyQuery);

        String is_open_nsrxx_xg = AppConfig.getProperty("IS_OPEN_NSRXX_XG");
        model.addAttribute("is_open_nsrxx_xg", is_open_nsrxx_xg);

        //初始化土地等级下拉框
        List tddjList = taxService.getTddjByDjhLike(djh);
        model.addAttribute("tddjList",tddjList);
        return "landtax/fzjc/zdtzSyxx";
    }

    @RequestMapping("updateInput")
    public String getSwDjSyxx(Model model,@RequestParam String syId){
        SwDjSy swDjSy = taxService.getSwDjSyById(syId);
        Zd zd = swDjSy.getZd();
        model.addAttribute("zd",zd);
        model.addAttribute("swDjSy",swDjSy);

        String is_open_nsrxx_xg = AppConfig.getProperty("IS_OPEN_NSRXX_XG");
        model.addAttribute("is_open_nsrxx_xg", is_open_nsrxx_xg);

        return "landtax/fzjc/zdtzSyxx";
    }

    @RequestMapping("save")
    @ResponseBody
    public Object save(Model model,SwDjSyQuery swDjSyQuery){
        String msg="";
        try{
            String syzt = Syzt.ZC.toString();
            taxService.saveSwDjSyQuery(swDjSyQuery,syzt);
            msg = "保存成功";
        }catch(Exception e){
            e.printStackTrace();
            msg = "保存失败";
        }
        ResponseMessage vo = new ResponseMessage();
        vo.setMsg(msg);
        return vo;
    }

    @RequestMapping("getTddjByQx")
    @ResponseBody
    public Object getTddjByQx(Model model,String qx){
        return taxService.getTddjByQx(qx);
    }

    @RequestMapping("getTdytByQx")
    @ResponseBody
    public Object getTdytByQx(Model model,String qx){
        return taxService.getTdytByQx(qx);
    }



    @RequestMapping("findJbbByGlbm")
    @ResponseBody
    public Object findJbbByGlbm(Model model,String query){
        List<SwDjJbbQuery> list = taxService.findJbbByGlbm(query);

        return list;
    }

    @RequestMapping("findAllZdDjh")
    @ResponseBody
    public Object findAllZdDjh(Model model){
        List<ZdQuery> list = zdService.findAllZdDjh();
        return list;
    }

    /**
     * 不走流程的税源删除
     */
    @RequestMapping("delSwDjSyNoWorkflow")
    @ResponseBody
    public Object delSwDjSyNoWorkflow(Model model,String syId){

        String result = "1";
        try{
            taxService.softDelSyDjSy(syId, Syzt.SC.toString());
        }catch (Exception e){
            e.printStackTrace();
            result = "0";
        }
        return result;
    }

    @RequestMapping("parsetdzlBydjh")
    @ResponseBody
    public Object parsetdzlBydjh(Model model,String syId){
        String[] syIds = syId.split(",");
        String[] tdzlMcs = new String[syIds.length];
        for(int i=0;i<syIds.length;i++){

            tdzlMcs[i] = taxService.fandTdzl(syIds[i]);

        }
        return tdzlMcs;
    }

    @RequestMapping("parseJmxz")
    @ResponseBody
    public Object parseJmxz(Model model,String qsJmxzDm){
        String[] qsJmxzDms = qsJmxzDm.split(",");
        String[] tdzlMcs = new String[qsJmxzDms.length];
        for(int i=0;i<qsJmxzDms.length;i++){

            tdzlMcs[i] = Jmxzqs.getMcByDm(qsJmxzDms[i]);

        }
        return tdzlMcs;
    }


    @RequestMapping("parseTdytByDm")
    @ResponseBody
    public Object parseTdytByDm(Model model,String dm){
        String[] dms = dm.split(",");
        String[] tdytmcs = new String[dms.length];
        for(int i=0;i<dms.length;i++){
            String tempTdytmc = Dldm.getMcByDm(dms[i]);
            tdytmcs[i] = tempTdytmc;
        }
        return tdytmcs;
    }

    @RequestMapping("parsefcytMcByDm")
    @ResponseBody
    public Object parsefcytMcByDm(Model model,String dm){
        String[] dms = dm.split(",");
        String[] tdytmcs = new String[dms.length];
        for(int i=0;i<dms.length;i++){
            String tempTdytmc = Fwxz.getMcByDm(dms[i]);
            tdytmcs[i] = tempTdytmc;
        }
        return tdytmcs;
    }

    @RequestMapping("parsetdsyytMcByDm")
    @ResponseBody
    public Object parsetdsyytMcByDm(Model model,String dm){
        String[] dms = dm.split(",");
        String[] tdytmcs = new String[dms.length];
        for(int i=0;i<dms.length;i++){
            String tempTdytmc = Tdyt.getMcByDm(dms[i]);
            tdytmcs[i] = tempTdytmc;
        }
        return tdytmcs;
    }

    @RequestMapping("parseTddjByDm")
    @ResponseBody
    public Object parseTddjByDm(Model model,String dm){
        return taxService.parseTddjByDm(dm);
    }

    @RequestMapping("parseSgztByDm")
    @ResponseBody
    public Object parseSgztByDm(Model model,String dm){
        String[] dms = dm.split(",");
        String[] sgztMcs = new String[dms.length];
        for(int i=0;i<dms.length;i++){
            String tempSgztMc = Sgzt.getMcByDm(dms[i]);
            sgztMcs[i] = tempSgztMc;
        }
        return sgztMcs;
    }

    @RequestMapping("initZgswjgSelect")
    @ResponseBody
    public Object initZgswjgSelect(Model model){
        String userId = SessionUtil.getCurrentUserId();
        String regionCode = sysUserService.getRegionCodeByUserId(userId);
        if(regionCode.length()>6){
            regionCode = regionCode.substring(0,6);
        }
        if(StringUtils.isNotBlank(AppConfig.getProperty(regionCode))){
            regionCode = AppConfig.getProperty(regionCode);
        }
        //根据地区码，获取主管税务机关列表
        String whereClause = "where swbmbm like '2"+regionCode+"%'";
        String sql = "select swbmbm,mc from dm_swbm "+whereClause;
        List list = baseRepository.getEntityManager().createNativeQuery(sql).getResultList();
        return list;
    }

    @RequestMapping("findSwDjJbbByGlbm")
    @ResponseBody
    public Object findSwDjJbbByGlbm(Model model, String nsrsbh){
        SwDjJbb swDjJbb =  taxService.findSwDjJbbByGlbm(nsrsbh);

        SwDjSyQuery swdjSyQuery = new SwDjSyQuery();
        if(swDjJbb!=null){
            BeanUtils.copyProperties(swDjJbb, swdjSyQuery);
        }
        return swdjSyQuery;
    }

    @RequestMapping("printSyxx")
    @ResponseBody
    public void exportSyxx(Model model,HttpServletResponse response,String tdId,String fcId,String djh,String dbh) throws  Exception{
        XMLBuildHelper xmlBuildHelper = new XMLBuildHelper();
        StringBuilder xml = new StringBuilder();
        SwDjSyQuery syxx = taxService.getSwDjSyById(tdId,fcId);
        if(StringUtils.isNotBlank(tdId) && StringUtils.isNotBlank(fcId)){
            //根据下拉框代码获取下拉框名称
            //根据税管代码获取税管状态名称
            String sql1 = "select tdzl from zd where djh ='"+djh+"'";
            String tdzl = String.valueOf(baseRepository.getEntityManager().createNativeQuery(sql1).getSingleResult());
            syxx.setTdzl(tdzl);
            //
            String tdjmxzdm =syxx.getTdjmxzdm();
            String tdjmxzMc = Jmxztd.getMcByDm(tdjmxzdm);
            syxx.setTdjmxzMc(tdjmxzMc);
            String sgztDm = syxx.getSgztDm();
            String sgzdMc = Sgzt.getMcByDm(sgztDm);
            syxx.setSgztMc(sgzdMc);
            //根据土地用途代码获取土地用途名称
            String tdyt = syxx.getTdyt();
            String tdytMc = Dldm.getMcByDm(tdyt);
            syxx.setTdytMc(tdytMc);
            //根据土地使用权类型获取土地使用权类型名称
            String tdsyqlx = syxx.getTdsyqlx();
            String tdsyqlxMc = Tdsyqlx.getMcByDm(tdsyqlx);
            syxx.setTdsyqlxMc(tdsyqlxMc);
            //根据主管控管代码获取主管空管名称
            String zgkgDm = syxx.getZgkgDm();
            String sql = "select mc from dm_swbm where swbmbm="+zgkgDm;
            String zgkgMc = String.valueOf(baseRepository.getEntityManager().createNativeQuery(sql).getSingleResult());
            syxx.setZgkgMc(zgkgMc);
            //根据登记注册类型代码获取登记注册类型名称
            String zclxDm = syxx.getZclxDm();
            String zclxMc = Zclx.getMcByDm(zclxDm);
            syxx.setZclxMc(zclxMc);
            //根据行业代码获取行业名称
            String hyDm = syxx.getHyDm();
            String hyMc="";
            if(StringUtils.isNotEmpty(hyDm)){
                if(hyDm.length()==1){
                     hyMc = Hylx.getMcByDm(hyDm);
                    if(hyDm.length()>1){
                        String sql11 = "select MC from DM_HYDM  where DM='"+hyDm+"'";
                         hyMc = String.valueOf(baseRepository.getEntityManager().createNativeQuery(sql11).getSingleResult());
                    }
                }

            }

            syxx.setHyMc(hyMc);
            //根据土地使用状态代码获取土地使用状态名称
            String tdsyztDm = syxx.getTdsyztDm();
            String tdsyztMc = Tdsyzt.getMcByDm(tdsyztDm);
            syxx.setTdsyztMc(tdsyztMc);
            //根据土地登记代码获取土地登记名称
            String tddj = syxx.getTddj();
            //根据tddj获取名称
            HashMap tddjMap = (HashMap) taxService.getTddjByDm(tddj);
            if(tddjMap != null){
                syxx.setTddjMc(String.valueOf(tddjMap.get("MC")));
            }

            //根据房屋性质代码获取房屋性质名称
            String fwxzDm = syxx.getFwxzDm();
            String fwxzMc = Fwxz.getMcByDm(fwxzDm);
            syxx.setFwxzMc(fwxzMc);
            //根据自用或者租用代码获取名称
            String zyhczDm = syxx.getZyhczDm();
            String zyhczMc = Fwsyzt.getMcByDm(zyhczDm);
            syxx.setZyhczMc(zyhczMc);

            //土地取得方式
            String tdqdfsDm = syxx.getTdqdfsDm();
            String tdqdfsMc = Tdqdfs.getMcByDm(tdqdfsDm);
            syxx.setTdqdfsMc(tdqdfsMc);
            //土地使用用途代码
            String tdsyytDm = syxx.getTdsyytDm();
            String tdsyytMc = Tdyt.getMcByDm(tdsyytDm);
            syxx.setTdsyytMc(tdsyytMc);



        }else{//说明是录入界面打印
            //根据djh获取宗地信息
            Zd zd = baseRepository.get(Zd.class,djh);
            syxx.setDjh(zd.getDjh());
            //syxx.setDbh(dbh);
            syxx.setTdytMc(Dldm.getMcByDm(zd.getTdyt()));
            syxx.setQlrmc(zd.getQlrmc());
            syxx.setScmjZd(zd.getScmjZd()==null?new BigDecimal(0).setScale(2,RoundingMode.HALF_UP):zd.getScmjZd().setScale(2,RoundingMode.HALF_UP));
            syxx.setTdzl(zd.getTdzl());
        }

        xml.append(xmlBuildHelper.voToXml(syxx));
//        xml.append("<data name=\"AP_FWZDMJ\" type=\"String\">");
//        xml.append((vo.getAP_LFMJ()==null?0:vo.getAP_LFMJ())+(vo.getAP_PFMJ()==null?0:vo.getAP_PFMJ()));
//        xml.append("</data>");
        String res=xmlBuildHelper.getPrintXml(xml.toString());
        response.setContentType("text/xml; charset=GBK");
        PrintWriter out = response.getWriter();
        out.write(res);
        out.flush();
        out.close();
    }

    @RequestMapping("getIsYsdlByDm")
    @ResponseBody
    public Object getIsYsdlByDm(Model model,String dm){
        ResponseMessage responseMessage = new ResponseMessage();
        String msg = taxService.getIsYsdlByDm(dm);
        responseMessage.setMsg(msg);
        return responseMessage;
    }

    @RequestMapping("initDwse")
    @ResponseBody
    public Object initDwse(Model model,String tddj){
        ResponseMessage responseMessage = new ResponseMessage();
        String msg = taxService.getDwseByTddj(tddj);
        responseMessage.setMsg(msg);
        return responseMessage;
    }

    @RequestMapping("msTaxList")
    public String msTaxList(Model model)throws Exception{
        //获取所有区县信息
        List<SDmDwxxCz> allQxList = dwxxService.getAllQxList();
        model.addAttribute("allQxList",allQxList);
        SwDjSyQuery swDjSyQuery = new SwDjSyQuery();
        swDjSyQuery.setIsMsTz(true);
        HashMap result = taxService.getHj(null,swDjSyQuery);
        model.addAttribute("resultMap",result);
        //加载税源种类
        Map<String,Boolean> taxTypeConf =CommonUtil.getSyTypes();
        model.addAttribute("taxTypeConf",taxTypeConf);
        model.addAttribute(ObjectValueManager.LOAD_FCS,taxTypeConf.get(ObjectValueManager.LOAD_FCS)?"true":"false");
        return "landtax/fzjc/msTaxList";
    }

    @RequestMapping("MsTaxJson")
    @ResponseBody
    public Object getMsTaxJson(Model model,Pageable request,String sylx,SwDjSyQuery swDjSyQuery) {
        swDjSyQuery.setIsMsTz(true);
  //      if(StringUtils.isBlank(swDjSyQuery.getXzqdm()))
       //     swDjSyQuery.setXzqdm(SessionUtil.getCurrentUser().getRegionCode());
     //   if(StringUtils.isNotBlank(swDjSyQuery.getXzqdm())&&StringUtils.endsWith(swDjSyQuery.getXzqdm(),"00"))
       //     swDjSyQuery.setXzqdm(StringUtils.strip(swDjSyQuery.getXzqdm(),"00"));
        if(StringUtils.isBlank(sylx)|| Sylx.TDSY.toString().equals(sylx))
            return taxService.findSwdjTdMap(swDjSyQuery,request);
        else
            return taxService.findSwdjFcMap(swDjSyQuery,request);
    }

    //定环比统计
    @RequestMapping("dhbTjfx")
    public String dhbTjfx(Model model,SwDjSyQuery swDjSyQuery) {
        if(swDjSyQuery.getSqUpdateDateBegin()==null){
            swDjSyQuery.setSqUpdateDateBegin(new Date());
        }
        if(swDjSyQuery.getSqUpdateDateEnd()==null){
            swDjSyQuery.setSqUpdateDateEnd(new Date());
        }
        if(swDjSyQuery.getBqUpdateDateBegin()==null){
            swDjSyQuery.setBqUpdateDateBegin(new Date());
        }
        if(swDjSyQuery.getBqUpdateDateEnd()==null){
            swDjSyQuery.setBqUpdateDateEnd(new Date());
        }
        model.addAttribute("syxx",swDjSyQuery);
        return "landtax/tj/hz/dhbTjfx";
    }
    @RequestMapping("dhbTjFx/chart")
    @ResponseBody
    public Object dhbFxChart(SwDjSyQuery swDjSyQuery,String tjlx) throws Exception{
        List<HashMap<String,Object>> queryList = new ArrayList<HashMap<String,Object>>();

       queryList = tjService.dhbFxList(swDjSyQuery,null);


        Map resultMap = new HashMap();
        List<String> categoriesList = new ArrayList<String>();
        List series = new ArrayList();
        List sqmjData = new ArrayList();
        List bqmjData = new ArrayList();
        List sqseData = new ArrayList();
        List bqseData = new ArrayList();

        for(HashMap tempMap:queryList){
            categoriesList.add(String.valueOf(tempMap.get("ORGAN_NAME")));
            sqmjData.add(tempMap.get("SQSCMJ"));
            bqmjData.add(tempMap.get("BQSCMJ"));
            sqseData.add(tempMap.get("SQNYNSE"));
            bqseData.add(tempMap.get("BQNYNSE"));


        }
        Map sqmjMap = new HashMap();
        sqmjMap.put("name","上期");
        sqmjMap.put("data",sqmjData);
        Map bqmjMap = new HashMap();
        bqmjMap.put("name","本期");
        bqmjMap.put("data",bqmjData);
        Map sqseMap = new HashMap();
        sqseMap.put("name","上期");
        sqseMap.put("data",sqseData);
        Map bqseMap = new HashMap();
        bqseMap.put("name","本期");
        bqseMap.put("data",bqseData);


        if(tjlx.equals("hcmj")) {
            series.add(sqmjMap);
            series.add(bqmjMap);
        }else{
            series.add(sqseMap);
            series.add(bqseMap);

        }

        resultMap.put("categories",categoriesList);
        resultMap.put("series",series);
        return resultMap;
    }
    @RequestMapping("dhbTjfxIfram")
    public String dhbTjfxIfram(Model model,SwDjSyQuery swDjSyQuery) {
        if(swDjSyQuery.getSqUpdateDateBegin()==null){
            swDjSyQuery.setSqUpdateDateBegin(new Date());
        }
        if(swDjSyQuery.getSqUpdateDateEnd()==null){
            swDjSyQuery.setSqUpdateDateEnd(new Date());
        }
        if(swDjSyQuery.getBqUpdateDateBegin()==null){
            swDjSyQuery.setBqUpdateDateBegin(new Date());
        }
        if(swDjSyQuery.getBqUpdateDateEnd()==null){
            swDjSyQuery.setBqUpdateDateEnd(new Date());
        }
        model.addAttribute("syxx",swDjSyQuery);
        return "landtax/tj/hz/dhbTjfxFram";
    }

    @RequestMapping("dhbTjfxJson")
    @ResponseBody
    public Object dhbTjfxJson(SwDjSyQuery swDjSyQuery) {return tjService.dhbTjfxJson(swDjSyQuery,null,null);
    }


    /**
     * 房产税定环比
     */
    //定环比统计
    @RequestMapping("fcsDhbTjfx")
    public String fcsDhbTjfx(Model model,SwDjSyQuery swDjSyQuery) {
        UserInfo user = SessionUtil.getCurrentUser();
        if(swDjSyQuery.getSqUpdateDateBegin()==null){
            swDjSyQuery.setSqUpdateDateBegin(new Date());
        }
        if(swDjSyQuery.getSqUpdateDateEnd()==null){
            swDjSyQuery.setSqUpdateDateEnd(new Date());
        }
        if(swDjSyQuery.getBqUpdateDateBegin()==null){
            swDjSyQuery.setBqUpdateDateBegin(new Date());
        }
        if(swDjSyQuery.getBqUpdateDateEnd()==null){
            swDjSyQuery.setBqUpdateDateEnd(new Date());
        }
        model.addAttribute("syxx",swDjSyQuery);
        return "landtax/tj/hz/fcsDhbTjfx";
    }

    @RequestMapping("fcsDhbTjfxIfram")
    public String fcsDhbTjfxIfram(Model model,SwDjSyQuery swDjSyQuery) {
        if(swDjSyQuery.getSqUpdateDateBegin()==null){
            swDjSyQuery.setSqUpdateDateBegin(new Date());
        }
        if(swDjSyQuery.getSqUpdateDateEnd()==null){
            swDjSyQuery.setSqUpdateDateEnd(new Date());
        }
        if(swDjSyQuery.getBqUpdateDateBegin()==null){
            swDjSyQuery.setBqUpdateDateBegin(new Date());
        }
        if(swDjSyQuery.getBqUpdateDateEnd()==null){
            swDjSyQuery.setBqUpdateDateEnd(new Date());
        }
        model.addAttribute("syxx",swDjSyQuery);
        return "landtax/tj/hz/fcsDhbTjfxFram";
    }

    @RequestMapping("fcsDhbTjfxJson")
    @ResponseBody
    public Object fcsDhbTjfxJson(SwDjSyQuery swDjSyQuery) {
        return tjService.fcsDhbTjfxJson(swDjSyQuery,null,null);
    }

    @RequestMapping("fcsdhbTjFx/chart")
    @ResponseBody
    public Object fcsdhbFxChart(SwDjSyQuery swDjSyQuery,String tjlx) throws Exception{
        List<HashMap<String,Object>> queryList = new ArrayList<HashMap<String,Object>>();

        queryList = tjService.fcsdhbFxList(swDjSyQuery,null);


        Map resultMap = new HashMap();
        List<String> categoriesList = new ArrayList<String>();
        List series = new ArrayList();
        /*List sqmjData = new ArrayList();
        List bqmjData = new ArrayList();*/
        List sqseData = new ArrayList();
        List bqseData = new ArrayList();

        for(HashMap tempMap:queryList){
            categoriesList.add(String.valueOf(tempMap.get("ORGAN_NAME")));
            /*sqmjData.add(tempMap.get("SQSCMJ"));
            bqmjData.add(tempMap.get("BQSCMJ"));*/
             sqseData.add(tempMap.get("SQNYNSE"));
            bqseData.add(tempMap.get("BQNYNSE"));


        }
        /*Map sqmjMap = new HashMap();
        sqmjMap.put("name","上期");
        sqmjMap.put("data",sqmjData);
        Map bqmjMap = new HashMap();
        bqmjMap.put("name","本期");
        bqmjMap.put("data",bqmjData);*/
        Map sqseMap = new HashMap();
        sqseMap.put("name","上期");
        sqseMap.put("data",sqseData);
        Map bqseMap = new HashMap();
        bqseMap.put("name","本期");
        bqseMap.put("data",bqseData);


        if(tjlx.equals("hcse")) {
            series.add(sqseMap);
            series.add(bqseMap);
        }else{
            series.add(sqseMap);
            series.add(bqseMap);

        }

        resultMap.put("categories",categoriesList);
        resultMap.put("series",series);
        return resultMap;
    }

    //税源分析
    @RequestMapping("tdsFx")
    public String tdsFx(Model model) {
        String regionCode = SessionUtil.getCurrentUser().getRegionCode();
        //获取所有区县信息
        List<SDmDwxxCz> allQxList = dwxxService.getAllQxList();
        List allSwjgList = new ArrayList();
        if(regionCode.length()<=4){//市
            model.addAttribute("issj",true);
        }else if(regionCode.length()>=6){//区县
            model.addAttribute("issj",false);
            allSwjgList = (List) taxService.getSgjgByQx(regionCode);
        }
        model.addAttribute("dwList",allQxList);
        model.addAttribute("swjgList",allSwjgList);
       /* List<SDmDwxxCz> allQxList = dwxxService.getAllQxList();
        model.addAttribute("dwList",allQxList);*/
        return "landtax/tj/hz/tdsFx";
    }
    @RequestMapping("tdsFxJson")
    @ResponseBody
    public Object tdsFxJson() {
        return tjService.tdsFxJson(null, null);
    }
    @RequestMapping("tjlxFx/chart")
    @ResponseBody
    public Object tjlxFxChart(String tjlx) throws Exception{
        List<HashMap<String,Object>> queryList = new ArrayList<HashMap<String,Object>>();
        if(StringUtils.isNotBlank(tjlx)){
            queryList = tjService.tdsFxList(null);
        }else if (StringUtils.isNotBlank(tjlx)){
           /* String[] querySwjg = swjg.split(",");
            queryList = taxService.tjNynseByQx(sylx,querySwjg,nf);*/
        }

        Map resultMap = new HashMap();
        List<String> categoriesList = new ArrayList<String>();
        List series = new ArrayList();
        List hcmjData = new ArrayList();
        List zgmjData = new ArrayList();
        List zjmjData = new ArrayList();
        List hcseData = new ArrayList();
        List zgseData = new ArrayList();
        List zjseData = new ArrayList();
        Map hcmjMap = new HashMap();
        for(HashMap tempMap : queryList){
            //categoriesList.add(String.valueOf(tempMap.get("ORGAN_NAME")));
            Map tjMap=new HashMap();
            tjMap.put("name", String.valueOf(tempMap.get("ORGAN_NAME")));
            if(tjlx.equals("scmjhz")){
                tjMap.put("y",tempMap.get("SCMJHZ"));
                hcmjMap.put("name","税源核查面积");
            }else if(tjlx.equals("zgscmjhz")){
                tjMap.put("y",tempMap.get("ZGSCMJHZ"));
                hcmjMap.put("name","税源征管面积");
            }else if(tjlx.equals("addscmj")){
                tjMap.put("y",tempMap.get("ADDSCMJ"));
                hcmjMap.put("name","税源核查增加面积");
            }else if(tjlx.equals("nynse")){
                tjMap.put("y",tempMap.get("NYNSE"));
                hcmjMap.put("name","税源核查税额");
            }else if(tjlx.equals("zgnynse")){
                tjMap.put("y",tempMap.get("ZGNYNSE"));
                hcmjMap.put("name","税源征管税额");
            }else if(tjlx.equals("zjmjse")){
                tjMap.put("y",tempMap.get("ADDNYNSE"));
                hcmjMap.put("name","税源核查增加税额");
            }

            hcmjData.add(tjMap);

        }

        hcmjMap.put("data",hcmjData);
        series.add(hcmjMap);
        resultMap.put("series",series);
        return resultMap;
    }
    @RequestMapping("sgjgFx/chart")
    @ResponseBody
    public Object sgjgFxChart(String qx,String swjg,String tjlx) throws Exception{
        List<HashMap<String,Object>> queryList = new ArrayList<HashMap<String,Object>>();
        String[] querySwjg=null;
        if(StringUtils.isNotBlank(qx)){
            querySwjg = qx.split(",");
            queryList = tjService.tdsFxList(null);
        }else if (StringUtils.isNotBlank(swjg)){
           querySwjg = swjg.split(",");
            queryList = tjService.tdsFxList(null);
        }

        Map resultMap = new HashMap();
        List<String> categoriesList = new ArrayList<String>();
        List series = new ArrayList();
        List hcmjData = new ArrayList();
        List zgmjData = new ArrayList();
        List zjmjData = new ArrayList();
        List hcseData = new ArrayList();
        List zgseData = new ArrayList();
        List zjseData = new ArrayList();

        for(String qxString:querySwjg){
            for(HashMap tempMap : queryList){
                if(String.valueOf(tempMap.get("REGION_CODE")).equals(qxString)){

                    categoriesList.add(String.valueOf(tempMap.get("ORGAN_NAME")));
                    hcmjData.add(tempMap.get("SCMJHZ"));
                    zgmjData.add(tempMap.get("ZGSCMJHZ"));
                    zjmjData.add(tempMap.get("ADDSCMJ"));
                    hcseData.add(tempMap.get("NYNSE"));
                    zgseData.add(tempMap.get("ZGNYNSE"));
                    zjseData.add(tempMap.get("ADDNYNSE"));
                }
            }

        }
        Map hcmjMap = new HashMap();
        hcmjMap.put("name","税源核查面积");
        hcmjMap.put("data",hcmjData);
        Map zgmjMap = new HashMap();
        zgmjMap.put("name","税源征管面积");
        zgmjMap.put("data",zgmjData);
        Map zjmjMap = new HashMap();
        zjmjMap.put("name","税源核查增加面积");
        zjmjMap.put("data",zjmjData);
        Map hcseMap = new HashMap();
        hcseMap.put("name","税源核查税额");
        hcseMap.put("data",hcseData);
        Map zgseMap = new HashMap();
        zgseMap.put("name","税源征管税额");
        zgseMap.put("data",zgseData);
        Map zjseMap = new HashMap();
        zjseMap.put("name","税源核查增加税额");
        zjseMap.put("data",zjseData);
        if(tjlx.equals("mjtj")) {
            series.add(hcmjMap);
            series.add(zgmjMap);
            series.add(zjmjMap);
        }else{
            series.add(hcseMap);
            series.add(zgseMap);
            series.add(zjseMap);
        }
       /* series.add(zgmjMap);
        series.add(zjmjMap);*/
        resultMap.put("categories",categoriesList);
        resultMap.put("series",series);
        return resultMap;
    }
    @RequestMapping("fcsFx")
    public String fcsFx(Model model) {
        String regionCode = SessionUtil.getCurrentUser().getRegionCode();
        //获取所有区县信息
        List<SDmDwxxCz> allQxList = dwxxService.getAllQxList();
        List allSwjgList = new ArrayList();
        if(regionCode.length()<=4){//市
            model.addAttribute("issj",true);
        }else if(regionCode.length()>=6){//区县
            model.addAttribute("issj",false);
            allSwjgList = (List) taxService.getSgjgByQx(regionCode);
        }
        model.addAttribute("dwList",allQxList);
        model.addAttribute("swjgList",allSwjgList);//更新
        return "landtax/tj/hz/fcsFx";
    }
    @RequestMapping("fctjlxFx/chart")
    @ResponseBody
    public Object fctjlxFxChart(String tjlx) throws Exception{
        List<HashMap<String,Object>> queryList = new ArrayList<HashMap<String,Object>>();
        if(StringUtils.isNotBlank(tjlx)){
            queryList = tjService.fcsFxList(null);
        }else if (StringUtils.isNotBlank(tjlx)){
           /* String[] querySwjg = swjg.split(",");
            queryList = taxService.tjNynseByQx(sylx,querySwjg,nf);*/
        }

        Map resultMap = new HashMap();
        List<String> categoriesList = new ArrayList<String>();
        List series = new ArrayList();
        List hcmjData = new ArrayList();

        Map hcmjMap = new HashMap();
        for(HashMap tempMap : queryList){
            //categoriesList.add(String.valueOf(tempMap.get("ORGAN_NAME")));
            Map tjMap=new HashMap();
            tjMap.put("name", String.valueOf(tempMap.get("ORGAN_NAME")));
             if(tjlx.equals("syhcnynse")){
                tjMap.put("y",tempMap.get("NYNSE"));
                hcmjMap.put("name","税源核查年应纳税额");
            }else if(tjlx.equals("zgnynse")){
                tjMap.put("y",tempMap.get("ZGNYNSE"));
                hcmjMap.put("name","征管系统年应纳税额");
            }else if(tjlx.equals("addnynse")){
                tjMap.put("y",tempMap.get("ADDNYNSE"));
                hcmjMap.put("name","税源核查增长年应纳税额");
            }

            hcmjData.add(tjMap);

        }

        hcmjMap.put("data",hcmjData);
        series.add(hcmjMap);
        resultMap.put("series",series);
        return resultMap;
    }
    @RequestMapping("fcsgjgFx/chart")
    @ResponseBody
    public Object fcsgjgFxChart(String qx,String swjg,String tjlx) throws Exception{
        List<HashMap<String,Object>> queryList = new ArrayList<HashMap<String,Object>>();
        String[] querySwjg=null;
        if(StringUtils.isNotBlank(qx)){
            querySwjg = qx.split(",");
            queryList = tjService.fcsFxList(null);
        }else if (StringUtils.isNotBlank(swjg)){
            querySwjg = swjg.split(",");
            queryList = tjService.fcsFxList(null);
        }

        Map resultMap = new HashMap();
        List<String> categoriesList = new ArrayList<String>();
        List series = new ArrayList();
        List hcmjData = new ArrayList();
        List zgmjData = new ArrayList();
        List zjmjData = new ArrayList();
        List hcseData = new ArrayList();
        List zgseData = new ArrayList();
        List zjseData = new ArrayList();

        for(String qxString:querySwjg){
            for(HashMap tempMap : queryList){
                if(String.valueOf(tempMap.get("REGION_CODE")).equals(qxString)){

                    categoriesList.add(String.valueOf(tempMap.get("ORGAN_NAME")));
                    hcmjData.add(tempMap.get("SCMJHZ"));
                    zgmjData.add(tempMap.get("ZGSCMJHZ"));
                    zjmjData.add(tempMap.get("ADDSCMJ"));
                    hcseData.add(tempMap.get("NYNSE"));
                    zgseData.add(tempMap.get("ZGNYNSE"));
                    zjseData.add(tempMap.get("ADDNYNSE"));
                }
            }

        }
        Map hcmjMap = new HashMap();
        hcmjMap.put("name","税源核查面积");
        hcmjMap.put("data",hcmjData);
        Map zgmjMap = new HashMap();
        zgmjMap.put("name","税源征管面积");
        zgmjMap.put("data",zgmjData);
        Map zjmjMap = new HashMap();
        zjmjMap.put("name","税源核查增加面积");
        zjmjMap.put("data",zjmjData);
        Map hcseMap = new HashMap();
        hcseMap.put("name","税源核查税额");
        hcseMap.put("data",hcseData);
        Map zgseMap = new HashMap();
        zgseMap.put("name","税源征管税额");
        zgseMap.put("data",zgseData);
        Map zjseMap = new HashMap();
        zjseMap.put("name","税源核查增加税额");
        zjseMap.put("data",zjseData);
        if(tjlx.equals("mjtj")) {
            series.add(hcmjMap);
            series.add(zgmjMap);
            series.add(zjmjMap);
        }else{
            series.add(hcseMap);
            series.add(zgseMap);
            series.add(zjseMap);
        }
       /* series.add(zgmjMap);
        series.add(zjmjMap);*/
        resultMap.put("categories",categoriesList);
        resultMap.put("series",series);
        return resultMap;
    }
    @RequestMapping("fcsFxJson")
    @ResponseBody
    public Object fcsFxJson() {
        return tjService.fcsFxJson(null, null);
    }

    @RequestMapping("getSgjgByQx")
    @ResponseBody
    public Object getSgjgByQx(String qx) {
        return taxService.getSgjgByQx(qx);
    }

    @RequestMapping("loginUserInfo")
    @ResponseBody
    public Object loginUserInfo() {
        HashMap loginUserInfo = new HashMap();

        String userName = "";
        String ssfj = "";
        UserInfo userInfo = SessionUtil.getCurrentUser();
        if (userInfo != null) {
            String regionCode = userInfo.getRegionCode();

            userName = userInfo.getUsername();
            if (regionCode.length() == 8) {
                ssfj = "2" + regionCode + "00";
            }
        }

        loginUserInfo.put("userName", userName);
        loginUserInfo.put("ssfj", ssfj);

        return loginUserInfo;
    }

    @RequestMapping("syJsonForGj")
    @ResponseBody
    public Object syJsonForGj(){
        return  null;
    }

    @RequestMapping("getHyNext")
    @ResponseBody
    public List getHyNext(String hydm, String jb) {
        return  taxService.getHylxNext(hydm);
    }
    @RequestMapping("getHylxzl")
    @ResponseBody
    public Object getHylxzl(Model model ,String nsrsbh){
        SwDjJbb swdjjbb =taxService.findSwDjJbbByGlbm(nsrsbh);
        String hydm=swdjjbb.getHyDm();
        String hymc=swdjjbb.getHyMc();
        List list =taxService.getHyzl(hydm);
        Object hydmzl=list.get(0);
        return hydmzl;
    }
    @RequestMapping("getHylxdl")
    @ResponseBody
    public Object getHylxdl(Model model ,String nsrsbh){
        SwDjJbb swdjjbb=taxService.findSwDjJbbByGlbm(nsrsbh);
        String hydm =swdjjbb.getHyDm();
        String hymc =swdjjbb.getHyMc();
        List list =taxService.getHydl(hydm);
        Object hydmdl=list.get(0);
        return hydmdl;
    }

    @RequestMapping("findSyByNsrsbh")
    @ResponseBody
    public Object findSyByNsrsbh(String nsrsbh) {
        return taxService.findSyByNsrsbh(nsrsbh);
    }



    @RequestMapping("/getZdbysy")
    @ResponseBody
    public Object getZdbysy(Model model){
        List<HashMap<String, Object>> list = taxService.getZdbysy();
        return  list;
    }


    @RequestMapping("/dhcx")
    public String dhcx(Model model)throws Exception {
        return "landtax/fzjc/dhcx";
    }

    @RequestMapping("dhcxSyJson")
    @ResponseBody
    public Object getDhcxSy(Model model,SwDjSyQuery swDjSyQuery,Pageable request) {
        return taxService.findDhcxSy(swDjSyQuery,request);
    }


    @RequestMapping("dhcxZdJson")
    @ResponseBody
    public Object getDhcxZd(Model model,SwDjSyQuery swDjSyQuery,Pageable request) {
        return taxService.findDhcxZd(swDjSyQuery,request);
    }

    @RequestMapping("shJson")
    @ResponseBody
    public Object getSh(Model model,Pageable request,SwDjJbbQuery swDjJbbQuery) {

        return taxService.findSh(swDjJbbQuery,request);
    }
}
