package cn.gtmap.landtax.web.fzjc;

import cn.gtmap.landtax.entity.SDmDwxxCz;
import cn.gtmap.landtax.entity.SwDjXmxx;
import cn.gtmap.landtax.model.dictionary.*;
import cn.gtmap.landtax.model.query.SwDjQsQuery;
import cn.gtmap.landtax.model.query.SwDjSyQuery;
import cn.gtmap.landtax.print.XMLBuildHelper;
import cn.gtmap.landtax.printexcel.access.ExcelBean;
import cn.gtmap.landtax.service.DwxxService;
import cn.gtmap.landtax.service.SwDjQsService;
import cn.gtmap.landtax.service.TaxService;
import cn.gtmap.landtax.service.ZdService;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import com.gtis.config.AppConfig;
import com.gtis.web.SessionUtil;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * 税源管理,查询和修改等
 *
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2014/6/27
 */
@Controller
@RequestMapping("/qs")
public class SwDjQsController {
    @Autowired
    SwDjQsService swDjQsService;
    @Autowired
    BaseRepository baseRepository;
    @Autowired
    DwxxService dwxxService;
    @Autowired
    ZdService zdService;
    @Autowired
    TaxService taxService;

    @RequestMapping("xmtz")
    public String xmList(Model model) {
        List<SDmDwxxCz> allQxList = dwxxService.getUserQxList();
        model.addAttribute("allQxList",allQxList);
        if (allQxList.size() == 1) {
            model.addAttribute("hideXzq","true");
        }
        model.addAttribute("showCreBtn",false);
        return "landtax/fzjc/xmtz";
    }

    @RequestMapping("qstz")
    public String gdzystzList(Model model) {
        List<SDmDwxxCz> allQxList = dwxxService.getUserQxList();
        model.addAttribute("allQxList",allQxList);
        if (allQxList.size() == 1) {
            model.addAttribute("hideXzq","true");
        }
        return "landtax/fzjc/qstz";
    }

    @RequestMapping("xmJson")
    @ResponseBody
    public Object xmJson(SwDjQsQuery swDjQsQuery, Pageable pageable){
        String xzqdm = dwxxService.getUserQxDm();
        if (StringUtils.isNotBlank(xzqdm) && StringUtils.isBlank(swDjQsQuery.getXmXzqdm())){
            swDjQsQuery.setXmXzqdm(xzqdm);
        }
        Object obj =  swDjQsService.findXmtz(swDjQsQuery,pageable);
        return obj;
    }

    @RequestMapping("exportExcelXmTz")
    public Object exportExcelXmTz(Model model,SwDjQsQuery swDjQsQuery,HttpServletRequest request) {
        try {

            List<SwDjQsQuery> xmList =  swDjQsService.getXmxxList(swDjQsQuery);
            List<String[]> retList = new ArrayList<String[]>();
            String excelBegin = swDjQsQuery.getExcelBegin();
            if(StringUtils.isBlank(excelBegin)){
                excelBegin = "0";
            }else{
                excelBegin = String.valueOf(Integer.parseInt(excelBegin)-1);
            }
            for(int i=(0+Integer.parseInt(excelBegin));i<(xmList.size()+Integer.parseInt(excelBegin));i++){
                String[] tempArr = new String[9];
                for(int j=0;j<tempArr.length;j++){
                    tempArr[j] = "";
                }
                SwDjQsQuery swDjQsQueryTemp = xmList.get(i-Integer.parseInt(excelBegin));
                tempArr[0] = String.valueOf(i + 1);
                tempArr[1] = swDjQsQueryTemp.getXmmc();
                tempArr[2] = swDjQsQueryTemp.getXmYddw();
                tempArr[3] = swDjQsQueryTemp.getXmTdzl();
                tempArr[4] = swDjQsQueryTemp.getGdmj()==null?"":swDjQsQueryTemp.getGdmj().setScale(2, BigDecimal.ROUND_HALF_UP).toString();
                tempArr[5] = swDjQsQueryTemp.getQdjg()==null?"":swDjQsQueryTemp.getQdjg().setScale(2,BigDecimal.ROUND_HALF_UP).toString();
                tempArr[6] = swDjQsQueryTemp.getGdsj()==null?"":new SimpleDateFormat("yyyy-MM-dd").format(swDjQsQueryTemp.getGdsj());
                retList.add(tempArr);
            }

            HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
            ExcelBean eb = new ExcelBean();
            map.put("group1", retList);// 把retList放入group1中
            eb.setGroupMap(map);
            eb.setExcelTemplate("gdxmxxTz.xls"); //
            eb.setExcelXml("gdxmxxTz.xml"); // 上述两步骤是把xml文件和xls文件有机组合

            eb.printExcel(request);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }

    @RequestMapping("qsJson")
    @ResponseBody
    public Object qsJson(SwDjQsQuery swDjQsQuery, Pageable pageable){
        String xzqdm = dwxxService.getUserQxDm();
        if (StringUtils.isNotBlank(xzqdm) && StringUtils.isBlank(swDjQsQuery.getXmXzqdm())){
            swDjQsQuery.setXmXzqdm(xzqdm);
        }
        Object obj =  swDjQsService.findQstz(swDjQsQuery, pageable);
        return obj;
    }

    @RequestMapping("qsInputByXmId")
    public String qsInputByXmId(Model model,SwDjQsQuery swDjQsQuery) {
        String xmId = swDjQsQuery.getXmId();
        String shxrId = swDjQsQuery.getShxrId();
        SwDjSyQuery qsxx = swDjQsService.getNewQsXX(xmId);
        if(StringUtils.isNotBlank(shxrId)){
            qsxx.setShxrId(shxrId);
        }

        model.addAttribute("qsxx",qsxx);

        //初始化土地等级下拉框
        List tddjList = taxService.getTddjByXzqdm(qsxx.getXmXzqdm());
        model.addAttribute("tddjList",tddjList);
        return "landtax/fzjc/xmtzQsxx";

    }



    @RequestMapping("openQsBySyId")
    public String openQsBySyId(Model model,SwDjQsQuery swDjQsQuery) {
        String syId = swDjQsQuery.getSyId();
        SwDjSyQuery qsxx = swDjQsService.getQsBySyId(syId);
        model.addAttribute("qsxx",qsxx);

        //初始化土地等级下拉框
        List tddjList = taxService.getTddjByXzqdm(qsxx.getXmXzqdm());
        model.addAttribute("tddjList",tddjList);


        return "landtax/fzjc/xmtzQsxxInput";
    }

    @RequestMapping("qsInputBySyId")
    public String qsInputBySyId(Model model,SwDjQsQuery swDjQsQuery, String noSave) {
        String syId = swDjQsQuery.getSyId();
        SwDjSyQuery qsxx = swDjQsService.getQsBySyId(syId);
        model.addAttribute("qsxx",qsxx);

        //初始化土地等级下拉框
        List tddjList = taxService.getTddjByXzqdm(qsxx.getXmXzqdm());
        model.addAttribute("tddjList",tddjList);

        if (StringUtils.isNotBlank(noSave))
            model.addAttribute("noSave","true");

        return "landtax/fzjc/xmtzQsxx";
    }

    @RequestMapping("save")
    @ResponseBody
    public Object save(Model model, SwDjSyQuery swDjSyQuery){
        String msg="";
        try{

            swDjQsService.SaveQs(swDjSyQuery);
            msg = "保存成功";
        }catch(Exception e){
            e.printStackTrace();
            msg = "保存失败";
        }
        ResponseMessage vo = new ResponseMessage();
        vo.setMsg(msg);
        return vo;
    }

    @RequestMapping("delQs")
    @ResponseBody
    public Object delQs(Model model, String syId){
        String msg="";
        try{
            swDjQsService.DelQS(syId);
            msg = "删除成功";
        }catch(Exception e){
            e.printStackTrace();
            msg = "删除失败";
        }
        ResponseMessage vo = new ResponseMessage();
        vo.setMsg(msg);
        return vo;
    }

    @RequestMapping("printQs")
    @ResponseBody
    public void printQs(Model model, HttpServletResponse response, String syId, String xmId) throws  Exception{
        XMLBuildHelper xmlBuildHelper = new XMLBuildHelper();
        StringBuilder xml = new StringBuilder();

        SwDjSyQuery qsxx = SwDjSyQuery.class.newInstance();
        if (!StringUtils.isBlank(syId)) {
            qsxx = swDjQsService.getQsBySyId(syId);
        }
        else if (!StringUtils.isBlank(xmId)) {
            qsxx = swDjQsService.getNewQsXX(xmId);
        }

        //根据下拉框代码获取下拉框名称
        //根据主管科股代码获取主管科股名称
        String zgkgDm = qsxx.getZgkgDm();
        String sql = "select mc from dm_swbm where swbmbm=" + zgkgDm;
        String zgkgMc = "";
        try {
            zgkgMc = String.valueOf(baseRepository.getEntityManager().createNativeQuery(sql).getSingleResult());
        }catch(Exception e) {

        }
        qsxx.setZgkgMc(zgkgMc);
        //根据登记注册类型代码获取登记注册类型名称
        String zclxDm = qsxx.getZclxDm();
        String zclxMc = Zclx.getMcByDm(zclxDm);
        qsxx.setZclxMc(zclxMc);
        //根据行业代码获取行业名称
        String hyDm = qsxx.getHyDm();
        String hyMc = Hylx.getMcByDm(hyDm);
        qsxx.setHyMc(hyMc);
        // 获取核查类型名称
//        String hclxDm = qsxx.getQsHclx();
//        String hclxMc = Hclx.getMcByDm(hclxDm);
//        qsxx.setQsHclx(hclxMc);
        // 获取税管状态名称
        String sgztDm = qsxx.getSgztDm();
        String sgzdMc = Sgzt.getMcByDm(sgztDm);
        qsxx.setSgztMc(sgzdMc);
        //根据土地用途代码获取土地用途名称
        String xmTdyt = qsxx.getXmTdyt();
        String xmTdytMc = Dldm.getMcByDm(xmTdyt);
        qsxx.setXmTdytMc(xmTdytMc);
        //根据土地使用权类型获取土地使用权类型名称
        String tdsyqlx = qsxx.getTdsyqlx();
        String tdsyqlxMc = Tdsyqlx.getMcByDm(tdsyqlx);
        qsxx.setTdsyqlxMc(tdsyqlxMc);
        //根据土地使用状态代码获取土地使用状态名称
        String tdsyztDm = qsxx.getTdsyztDm();
        String tdsyztMc = Tdsyzt.getMcByDm(tdsyztDm);
        qsxx.setTdsyztMc(tdsyztMc);
        //根据土地登记代码获取土地登记名称
        String tddj = qsxx.getTddj();
        String tddjMc = Tdjb.getMcByDm(tddj);
        qsxx.setTddjMc(tddjMc);
        //根据房屋性质代码获取房屋性质名称
        String fwxzDm = qsxx.getFwxzDm();
        String fwxzMc = Fwxz.getMcByDm(fwxzDm);
        qsxx.setFwxzMc(fwxzMc);
        //根据自用或者租用代码获取名称
        String zyhczDm = qsxx.getZyhczDm();
        String zyhczMc = Fwsyzt.getMcByDm(zyhczDm);
        qsxx.setZyhczMc(zyhczMc);
        //土地取得方式
        String tdqdfsDm = qsxx.getTdqdfsDm();
        String tdqdfsMc = Tdqdfs.getMcByDm(tdqdfsDm);
        qsxx.setTdqdfsMc(tdqdfsMc);
        //土地使用用途代码
        String tdsyytDm = qsxx.getTdsyytDm();
        String tdsyytMc = Tdyt.getMcByDm(tdsyytDm);
        qsxx.setTdsyytMc(tdsyytMc);

        xml.append(xmlBuildHelper.voToXml(qsxx));
        String res=xmlBuildHelper.getPrintXml(xml.toString());
        response.setContentType("text/xml; charset=GBK");
        PrintWriter out = response.getWriter();
        out.write(res);
        out.flush();
        out.close();
    }

    @RequestMapping("getSysByGdIds")
    @ResponseBody
    public Object getSysByGdIds(Model model,String gdIds) {
        Object oo = zdService.getSysByGtIds(gdIds, Gtlx.GD.toString());
        return oo;
    }

    @RequestMapping("getQsSyListById")
    public String getQsSyList(Model model,String gdId) {
        List<SwDjSyQuery> syxx = swDjQsService.getSwDjSyByGdId(gdId);
        model.addAttribute("syxx",syxx);

        String sql = "select xmmc from sw_dj_xmxx where xm_id='" + gdId + "'";
        String xmMc = "";
        try {
            xmMc = String.valueOf(baseRepository.getEntityManager().createNativeQuery(sql).getSingleResult());
        }catch(Exception e) {}
        model.addAttribute("xmMc",xmMc);
        String userId = SessionUtil.getCurrentUserId();
        model.addAttribute("userId",userId);
        String flag = AppConfig.getProperty("update_able");
        model.addAttribute("flag",flag);


        return "landtax/fzjc/gdSyxxTz";
    }
    @RequestMapping("parseTdytByDm")
    @ResponseBody
    public Object parseTdytByDm(Model model,String dm){
        String[] dms = dm.split(",");
        String[] tdytmcs = new String[dms.length];
        for(int i=0;i<dms.length;i++){
            String tempTdytmc = Tdyt.getMcByDm(dms[i]);
            tdytmcs[i] = tempTdytmc;
        }
        return tdytmcs;
    }
    @RequestMapping("parseQdfsByDm")
    @ResponseBody
    public Object parseQdfsByDm(Model model,String dm){
        String[] dms = dm.split(",");
        String[] qdfsmcs = new String[dms.length];
        for(int i=0;i<dms.length;i++){
            String tempQdfsmc = Tdqdfs.getMcByDm(dms[i]);
            qdfsmcs[i] = tempQdfsmc;
        }
        return qdfsmcs;
    }
    @RequestMapping("parseXzqByDm")
    @ResponseBody
    public Object parseXzqByDm(Model model,String dm){
        String[] dms = dm.split(",");
        String[] xzqmcs = new String[dms.length];
        for(int i=0;i<dms.length;i++){
            String tempXzqmc = swDjQsService.parseXzqByDm(dms[i]);
            xzqmcs[i] = tempXzqmc;
        }
        return xzqmcs;
    }



}
