package cn.gtmap.landtax.web.fzjc;

import cn.gtmap.landtax.entity.SDmDwxxCz;
import cn.gtmap.landtax.entity.SwMsrdTd;
import cn.gtmap.landtax.model.dictionary.Hcxmlx;
import cn.gtmap.landtax.model.dictionary.ResponseMessage;
import cn.gtmap.landtax.model.dictionary.Sylx;
import cn.gtmap.landtax.model.query.SwDjSyQuery;
import cn.gtmap.landtax.print.XMLBuildHelper;
import cn.gtmap.landtax.service.DwxxService;
import cn.gtmap.landtax.service.MsrdService;
import cn.gtmap.landtax.service.TaxService;
import cn.gtmap.landtax.service.impl.DicServiceImpl;
import cn.gtmap.landtax.util.IPlatUtil;
import cn.gtmap.landtax.util.PlatUtil;
import com.gtis.plat.vo.PfActivityVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 免税认定
 */
@Controller
@RequestMapping("/msrd")
public class MsrdController {
    @Autowired
    MsrdService msrdService;

    @Autowired
    IPlatUtil platUtil;

    @Autowired
    HashMap hcjdConfigMap;
    @Autowired
    TaxService taxService;

    @RequestMapping("/workflow")
    @ResponseBody
    public Object createSyscWorkflow(Model model,String sylx,String tdId,String fcId,String syId ){
        try{
            return msrdService.createMsrdWorkflow(sylx,tdId,fcId,syId );
        }catch(Exception e){
            return null;
        }

    }

    //土地承办单
    @RequestMapping("/tdCbd")
    public String tdCbd(Model model,String proid){
        //根据proid（rwId）获取税源信息
        SwDjSyQuery swDjSyQuery = msrdService.getTdMsrd(proid);
        model.addAttribute("syxx",swDjSyQuery);

        //确认当前流程在哪个节点，限制用户签名
        String taskId = PlatUtil.getTaskIdByProid(proid);
        String activiId = this.platUtil.getPfActivityIdByTaskId(taskId);
        PfActivityVo vo = this.platUtil.getActivityInfo(activiId);

        String[] configArr = (String[]) hcjdConfigMap.get(Hcxmlx.TDMSRD.toString());

        //key：活动定义ID， map：活动定义顺序
        Map<String, Integer> activityDefinitionMap = new HashMap<String, Integer>();
        int i = 0;
        for(String activityDefinitionId : configArr){
            i++;
            activityDefinitionMap.put(activityDefinitionId, i);
        }

        //税管员签名
        model.addAttribute("signdisable1", "true");
        //分局长签名
        model.addAttribute("signdisable2", "true");
        //区县签名
        model.addAttribute("signdisable3", "true");
        //市级备案
        model.addAttribute("signdisable4", "true");

        if (vo!=null&&activityDefinitionMap.containsKey(vo.getActivityDefinitionId())) {
            int sequence = activityDefinitionMap.get(vo.getActivityDefinitionId());
            model.addAttribute("signdisable" + sequence, "false");
        }

        return "landtax/fzjc/tdCbd";
    }

    //房产承办单
    @RequestMapping("/fcCbd")
    public String fcCbd(Model model,String proid){
        //根据proid（rwId）获取税源信息
        SwDjSyQuery swDjSyQuery = msrdService.getfcMsrd(proid);
        model.addAttribute("syxx",swDjSyQuery);

        //确认当前流程在哪个节点，限制用户签名
        String taskId = PlatUtil.getTaskIdByProid(proid);
        String activiId = this.platUtil.getPfActivityIdByTaskId(taskId);
        PfActivityVo vo = this.platUtil.getActivityInfo(activiId);

        String[] configArr = (String[]) hcjdConfigMap.get(Hcxmlx.TDMSRD.toString());

        //key：活动定义ID， map：活动定义顺序
        Map<String, Integer> activityDefinitionMap = new HashMap<String, Integer>();
        int i = 0;
        for(String activityDefinitionId : configArr){
            i++;
            activityDefinitionMap.put(activityDefinitionId, i);
        }

        //税管员签名
        model.addAttribute("signdisable1", "true");
        //分局长签名
        model.addAttribute("signdisable2", "true");
        //区县签名
        model.addAttribute("signdisable3", "true");
        //市级备案
        model.addAttribute("signdisable4", "true");

        if (activityDefinitionMap.containsKey(vo.getActivityDefinitionId())) {
            int sequence = activityDefinitionMap.get(vo.getActivityDefinitionId());
            model.addAttribute("signdisable" + sequence, "false");
        }
        return "landtax/fzjc/fcCbd";
    }

    @RequestMapping("/tdCbdSave")
    @ResponseBody
    public Object tdCbdSave(Model model,SwDjSyQuery swDjSyQuery){
        String msg = "保存成功";
        try{
            msrdService.tdCbdSave(swDjSyQuery);
        }catch (Exception e){
            msg = "保存失败";
        }
        ResponseMessage r = new ResponseMessage();
        r.setMsg(msg);
        return r;

    }

    @RequestMapping("/fcCbdSave")
    @ResponseBody
    public Object fcCbdSave(Model model,SwDjSyQuery swDjSyQuery){
        String msg = "保存成功";
        try{
            msrdService.fcCbdSave(swDjSyQuery);
        }catch (Exception e){
            msg = "保存失败";
        }
        ResponseMessage r = new ResponseMessage();
        r.setMsg(msg);
        return r;

    }

    @RequestMapping("/wf/tdDel")
    @ResponseBody
    public String tdDel(Model model,String proid) {
        msrdService.delMsrdTdByRwId(proid);
        return "";
    }

    @RequestMapping("/wf/tdEnd")
    @ResponseBody
    public String tdEnd(Model model,String proid) {
        msrdService.endMsrdTdByRwId(proid);
        return "";
    }

    @RequestMapping("/wf/fcDel")
    @ResponseBody
    public String fcDel(Model model,String proid) {
        msrdService.delMsrdFcByRwId(proid);
        return "";
    }

    @RequestMapping("/wf/fcEnd")
    @ResponseBody
    public String fcEnd(Model model,String proid) {
        msrdService.endMsrdFcByRwId(proid);
        return "";
    }
    @RequestMapping("printMsrdTdCbd")
    @ResponseBody
    public void printMsrdTdCbd(Model model,HttpServletRequest request,HttpServletResponse response,String proid) throws  Exception{
        XMLBuildHelper xmlBuildHelper = new XMLBuildHelper();
        StringBuilder xml = new StringBuilder();
        SwDjSyQuery swDjSyQuery = msrdService.getTdMsrd(proid);
        xml.append(xmlBuildHelper.voToXml(swDjSyQuery));
        HashMap<String, Boolean> keyMap = new HashMap<String, Boolean>();
        keyMap.put("ssglrysh", false);
        keyMap.put("fjzsh", false);
        keyMap.put("qxgly", false);
        keyMap.put("sjba", false);
        xml.append(xmlBuildHelper.getSignToXml(proid, request, keyMap));//根据id，进入平台库，查找相应的信息，组织参数，存入xml中

        String res=xmlBuildHelper.getPrintXml(xml.toString());
        response.setContentType("text/xml; charset=GBK");
        PrintWriter out = response.getWriter();
        out.write(res);
        out.flush();
        out.close();
    }
    @RequestMapping("/wf/turn")
    @ResponseBody
    public void turnWorkflow(Model model,String proid,HttpServletResponse response) throws  Exception{
        List signList=taxService.getUserSign(proid);
        String msg = "";
        if(signList.size()<1){
            msg = "尚未签字确认不能转发！";
        }
        SwDjSyQuery swDjSyQuery = msrdService.getTdMsrd(proid);

//        if(swDjSyHis.getXgyy()== null){
//            msg += "尚未填写修改原因不能转发！";
//        }
        if(swDjSyQuery.getTdSqMsmj()==null &&swDjSyQuery.getTdMssjBegin()== null &&swDjSyQuery.getTdMssjEnd()==null && swDjSyQuery.getTdRdhNynse()==null &&swDjSyQuery.getTdRdhSyysmj()==null){
            msg += "尚未填写完成城镇土地使用税免税认定承办单不能转发！";
        }
        response.setContentType("text/html;charset=GBK");
        PrintWriter out = response.getWriter();
        out.println(msg);
    }
}
