package cn.gtmap.landtax.web.fzjc;

import cn.gtmap.landtax.entity.SDmDwxxCz;
import cn.gtmap.landtax.model.dictionary.Szdm;
import cn.gtmap.landtax.model.query.MjydQuery;
import cn.gtmap.landtax.model.query.MjydSyList;
import cn.gtmap.landtax.model.query.MjydSyQuery;
import cn.gtmap.landtax.model.query.SwDjSyQuery;
import cn.gtmap.landtax.printexcel.access.ExcelBean;
import cn.gtmap.landtax.service.DwxxService;
import cn.gtmap.landtax.service.MjydcxService;
import cn.gtmap.landtax.service.TaxService;
import cn.gtmap.landtax.service.TddjydcxService;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.CommonUtil;
import cn.gtmap.landtax.util.ObjectValueManager;
import com.gtis.config.AppConfig;
import com.gtis.web.SessionUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.persistence.Query;
import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by XiongWen on 2018/5/5.
 */

@Controller
@RequestMapping("/mjyd")
public class MjydController {

    @Autowired
    private MjydcxService mjydcxService;

    @Autowired
    TaxService taxService;

    @Autowired
    private DwxxService dwxxService;

    @Autowired
    BaseRepository baseRepository;
    @RequestMapping("/taizhou")
    public String defaultShow(Model model){
        List tdjbList = mjydcxService.getTdjbZd();
        List<SDmDwxxCz> allQxList = dwxxService.getAllQxList();
        model.addAttribute("allQxList",allQxList);
        model.addAttribute("tdjbList",tdjbList);
        return "landtax/fzjc/mjydcx";
    }

    @RequestMapping("/getTdjb")
    @ResponseBody
    public  List getTdjb(){
        return mjydcxService.getTdjbZd();
    }

    @RequestMapping("/findTddjyd")
    @ResponseBody
    public Object findMjyd(Model model, Pageable pageable, MjydSyQuery mjydQuery){

        return mjydcxService.selectByCondition(mjydQuery,pageable);
    }


    @RequestMapping("/findSyList")
    public String find(Model model ,String djxh,String nsrsbh) throws Exception{
        List<SwDjSyQuery> syxx = taxService.getSwDjSyByDjxh(djxh, Szdm.CZTDSYS.toString());
        for(SwDjSyQuery sysc:syxx){
            if(sysc.getScmj()!=null&&sysc.getScmjZd()!=null){
                BigDecimal  c =sysc.getScmj().subtract(sysc.getScmjZd()).abs();
                sysc.setMjce(c);
            }

        }
        String nsrmc ="";
        String syzmj ="";
        String zdmj ="";
        String mjce ="";
        List<Object> listJstd =mjydcxService.getDjhByNsrsbh(djxh);
        for(Object objJstd :listJstd){
            Object[] objs = (Object[]) objJstd;
            if(objs[0]==null){
                nsrmc="";
            }else{
                nsrmc =objs[0].toString();
            }
            if(objs[1]==null){
                syzmj="";
            }else{
                syzmj =objs[1].toString();
            }
            if(objs[2]==null){
                zdmj="";
            }else{
                zdmj =objs[2].toString();
            }
            if(objs[3]==null){
                mjce="";
            }else{
                mjce =objs[3].toString();
            }
        }
        List listJs =mjydcxService.getJsByDjxh(djxh);
        model.addAttribute("nsrmc",nsrmc);
        model.addAttribute("syzmj",syzmj);
        model.addAttribute("zdmj",zdmj);
        model.addAttribute("mjce",mjce);
        model.addAttribute("nsrsbh",nsrsbh);
        model.addAttribute("syxx",syxx);
        model.addAttribute("listJs",listJs);
        String userId = SessionUtil.getCurrentUserId();
        model.addAttribute("userId",userId);
        String flag = AppConfig.getProperty("update_able");
        model.addAttribute("flag",flag);
        //加载税源种类
        Map<String,Boolean> taxTypeConf = CommonUtil.getSyTypes();
        model.addAttribute("taxTypeConf",taxTypeConf);
        model.addAttribute(ObjectValueManager.LOAD_FCS,taxTypeConf.get(ObjectValueManager.LOAD_FCS)?"true":"false");

        return "landtax/fzjc/SyxxTz";
    }
    @RequestMapping("/shwoHistory")
    public String shwoHistory(Model model,String syuuid){
        model.addAttribute("syuuid",syuuid);
        return "landtax/fzjc/cxzj/ydHistory";
    }

    @RequestMapping("/getHistory")
    @ResponseBody
    public List getHistory(String syuuid){
        return  mjydcxService.getHistoryBySyuuId(syuuid);
    }
    @RequestMapping("exportMjydTz")
    public String exportExcelTz(HttpServletRequest request, MjydSyQuery mjydSyQuery,String ids) throws Exception {

        try {
            HashMap param = new HashMap();
            // 判断是checkbox导出，还是查询导出
            if (StringUtils.isNotBlank(ids)) {
                // 说明是checkbox导出
                param.put("ids",ids);
            } else {
                param.put("mjydSyQuery",mjydSyQuery);
            }

            List<HashMap<String, Object>> list = mjydcxService.findMjydTdForExp(param);
            List<String[]> retList = new ArrayList<String[]>();
            for (int i = 0; i < list.size(); i++) {
                String[] tempArr = new String[8];
                for (int j = 0; j < tempArr.length; j++) {
                    tempArr[j] = "";
                }
                tempArr[0] = String.valueOf(i + 1);
                tempArr[1] = String.valueOf(list.get(i).get("NSRSBH"));
                tempArr[2] = String.valueOf(list.get(i).get("NSRMC"));
                tempArr[3] = String.valueOf(list.get(i).get("ZGKG_MC"));
                tempArr[4] =String.valueOf(list.get(i).get("JSMJ")) ;
                tempArr[5] = String.valueOf(list.get(i).get("ZYTDMJ"));
                tempArr[6] = String.valueOf(list.get(i).get("MJCE"));
                tempArr[7] = String.valueOf(list.get(i).get("YDZT")) ;
                retList.add(tempArr);
            }

            String excelTemplate = "mjydTzTaiZhou.xls";
            String excelXml = "mjydTzTaiZhou.xml";


            HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
            ExcelBean eb = new ExcelBean();
            map.put("group1", retList);// 把retList放入group1中
            eb.setGroupMap(map);
            eb.setExcelTemplate(excelTemplate); //
            eb.setExcelXml(excelXml); // 上述两步骤是把xml文件和xls文件有机组合
            eb.printExcel(request);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }



}
