package cn.gtmap.landtax.web.fzjc;

import cn.gtmap.landtax.entity.SwDjFc;
import cn.gtmap.landtax.entity.SwDjTd;
import cn.gtmap.landtax.model.dictionary.Sgzt;
import cn.gtmap.landtax.model.dictionary.Sylx;
import cn.gtmap.landtax.model.query.SwDjSyQuery;
import cn.gtmap.landtax.service.TaxService;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * 漏征漏管户
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2014/7/5
 */
@Controller
@RequestMapping("/lzlgh")
public class LzlghController {

    @Autowired
    TaxService taxService;

    @RequestMapping("td")
    public String lzlghTd(Model model) {
        return "landtax/fzjc/lzlghTd";
    }

    @RequestMapping("tdJson")
    @ResponseBody
    public Object getLzlgTd(Model model,SwDjSyQuery swDjSyQuery,Pageable request) {
        return taxService.findLzlghTd(swDjSyQuery, Sgzt.LZLGD,request);
    }

    @RequestMapping("fc")
    public String lzlghFc(Model model) {
        return "landtax/fzjc/lzlghFc";
    }

    @RequestMapping("fcJson")
    @ResponseBody
    public Object getLzlgFc(Model model,SwDjSyQuery swDjSyQuery,Pageable request) {
        return taxService.findLzlghFc(swDjSyQuery,Sgzt.LZLGD,request);
    }
}
