package cn.gtmap.landtax.web.fzjc;

import cn.gtmap.landtax.entity.SDmDwxxCz;
import cn.gtmap.landtax.entity.SwDjPcxx;
import cn.gtmap.landtax.entity.SwDjSyTemp;
import cn.gtmap.landtax.entity.SwHcXmRwRel;
import cn.gtmap.landtax.model.dictionary.Hylx;
import cn.gtmap.landtax.model.dictionary.ResponseMessage;
import cn.gtmap.landtax.model.dictionary.Zclx;
import cn.gtmap.landtax.model.query.GdzysQuery;
import cn.gtmap.landtax.model.query.SwDjQsQuery;
import cn.gtmap.landtax.model.query.SwDjSyQuery;
import cn.gtmap.landtax.print.XMLBuildHelper;
import cn.gtmap.landtax.printexcel.access.ExcelBean;
import cn.gtmap.landtax.service.DwxxService;
import cn.gtmap.landtax.service.GdzysService;
import cn.gtmap.landtax.service.HcxmService;
import cn.gtmap.landtax.service.SwdjSyTempService;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import com.alibaba.fastjson.JSON;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * Created by zhouzhiwei on 2015-03-10.
 * 耕地占用税
 */

@Controller
@RequestMapping("/gdzys")
public class GdzysController {
    @Autowired
    GdzysService gdzysService;

    @Autowired
    BaseRepository baseRepository;

    @Autowired
    DwxxService dwxxService;

    @Autowired
    SwdjSyTempService swdjSyTempService;

    @Autowired
    HcxmService hcxmService;

    @RequestMapping("pctzJson")
    @ResponseBody
    public Object getpcxx(Model model, Pageable request, GdzysQuery gdzysQuery) {
        String xzqdm = dwxxService.getUserQxDm();
        if (StringUtils.isNotBlank(xzqdm) && StringUtils.isBlank(gdzysQuery.getPcXzqdm())){
            gdzysQuery.setPcXzqdm(xzqdm);
        }
        return gdzysService.findPCXX(gdzysQuery, request);
    }

    @RequestMapping("exportExcelPcTz")
    public Object exportExcelPcTz(Model model,GdzysQuery gdzysQuery,HttpServletRequest request) {
        try {

            List<GdzysQuery> pcList =  gdzysService.getPcxxList(gdzysQuery);
            List<String[]> retList = new ArrayList<String[]>();
            String excelBegin = gdzysQuery.getExcelBegin();
            if(StringUtils.isBlank(excelBegin)){
                excelBegin = "0";
            }else{
                excelBegin = String.valueOf(Integer.parseInt(excelBegin)-1);
            }
            for(int i=(0+Integer.parseInt(excelBegin));i<(pcList.size()+Integer.parseInt(excelBegin));i++){
                String[] tempArr = new String[11];
                for(int j=0;j<tempArr.length;j++){
                    tempArr[j] = "";
                }
                GdzysQuery GdzysQueryTemp = pcList.get(i-Integer.parseInt(excelBegin));
                tempArr[0] = String.valueOf(i + 1);
                tempArr[1] = GdzysQueryTemp.getPcmc();
                tempArr[2] = GdzysQueryTemp.getPwh();
                tempArr[3] = GdzysQueryTemp.getPzmj()==null?"":GdzysQueryTemp.getPzmj().setScale(2,BigDecimal.ROUND_HALF_UP).toString();
                tempArr[4] = GdzysQueryTemp.getNydmj()==null?"":GdzysQueryTemp.getNydmj().setScale(2,BigDecimal.ROUND_HALF_UP).toString();
                tempArr[5] = GdzysQueryTemp.getJbntmj()==null?"":GdzysQueryTemp.getJbntmj().setScale(2,BigDecimal.ROUND_HALF_UP).toString();
                tempArr[6] = GdzysQueryTemp.getFgdnydmj()==null?"":GdzysQueryTemp.getFgdnydmj().setScale(2,BigDecimal.ROUND_HALF_UP).toString();
                tempArr[7] = GdzysQueryTemp.getGdmj()==null?"":GdzysQueryTemp.getGdmj().setScale(2,BigDecimal.ROUND_HALF_UP).toString();
                tempArr[8] = GdzysQueryTemp.getPzsj()==null?"":new SimpleDateFormat("yyyy-MM-dd").format(GdzysQueryTemp.getPzsj());
                tempArr[9] = GdzysQueryTemp.getPcYddw();
                retList.add(tempArr);
            }

            HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
            ExcelBean eb = new ExcelBean();
            map.put("group1", retList);// 把retList放入group1中
            eb.setGroupMap(map);
            eb.setExcelTemplate("pcxxTz.xls"); //
            eb.setExcelXml("pcxxTz.xml"); // 上述两步骤是把xml文件和xls文件有机组合

            eb.printExcel(request);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }

    // 耕地占用税台帐
    @RequestMapping("gdzysJson")
    @ResponseBody
    public Object getgdzystz(Model model, Pageable request, GdzysQuery gdzysQuery) {
        String xzqdm = dwxxService.getUserQxDm();
        if (StringUtils.isNotBlank(xzqdm) && StringUtils.isBlank(gdzysQuery.getPcXzqdm())){
            gdzysQuery.setPcXzqdm(xzqdm);
        }
        Object oo = gdzysService.findGdzystz(gdzysQuery, request);
        System.out.println(JSON.toJSONString(oo));
        return oo;
    }

    /**
     * 进去耕地占用税编辑页面
     * @param model
     * @param proid 任务id
     * @return
     */
    @RequestMapping("gdzysInput")
    public String getSwdjPcXx(Model model, String proid){
//        GdzysQuery pcxx = gdzysService.findGdzysqueryByPCID(pcId);
//
//        model.addAttribute("pcxx", pcxx);
//
//        // 检查参数是否非空，非空则参数传到前台
//        if (StringUtils.isNotEmpty(noSave))
//            model.addAttribute("noSave", noSave);
//        if (StringUtils.isNotEmpty(noBack))
//            model.addAttribute("noBack", noBack);


        if(hcxmService.isYbjByProid(proid)){//已办结
            model.addAttribute("isYbj","true");
        }else{
            model.addAttribute("isYbj","false");
        }
        List<SwDjSyTemp> list = swdjSyTempService.getSwDjSyTempListByRwid(proid);

        if(CollectionUtils.isEmpty(list)){//说明是第一次修改
            SwHcXmRwRel swHcXmRwRel = hcxmService.getSwHcXmRwRelByWiid(proid);
            String pcId = "";
            pcId = swHcXmRwRel.getBdId();
            GdzysQuery pcxx = gdzysService.findGdzysqueryByPCID(pcId);
            model.addAttribute("pcxx", pcxx);
        }else{//说明之前修改过
            SwDjSyTemp swDjSyTemp = list.get(0);
            SwDjPcxx swDjPcxx = baseRepository.get(SwDjPcxx.class, swDjSyTemp.getBpId());
            SwDjSyQuery pcxx = new SwDjSyQuery();
            BeanUtils.copyProperties(swDjSyTemp, pcxx);
            BeanUtils.copyProperties(swDjPcxx, pcxx);
            model.addAttribute("pcxx", pcxx);
        }
        model.addAttribute("proid",proid);


        return "landtax/fzjc/gdzys";
    }

    @RequestMapping("initDwse")
    @ResponseBody
    public Object initDwse(Model model,String xzqdm){
        ResponseMessage responseMessage = new ResponseMessage();
        String msg = gdzysService.getDwseByXzqdm(xzqdm);
        responseMessage.setMsg(msg);
        return responseMessage;
    }

    @RequestMapping("list")
    public String pcxxList(Model model) {
        List<SDmDwxxCz> allQxList = dwxxService.getUserQxList();
        model.addAttribute("allQxList",allQxList);
        if (allQxList.size() == 1) {
            model.addAttribute("hideXzq","true");
        }

        return "landtax/fzjc/pctz";
    }

    @RequestMapping("gdzyslist")
    public String gdzystzList(Model model) {
        List<SDmDwxxCz> allQxList = dwxxService.getUserQxList();
        model.addAttribute("allQxList",allQxList);
        if (allQxList.size() == 1) {
            model.addAttribute("hideXzq","true");
        }
        return "landtax/fzjc/gdzystz";
    }

    @RequestMapping("delGdzys")
    @ResponseBody
    public String delGdzys(Model model, String proid){
        try{
            gdzysService.DelGdzys(proid);
        }catch(Exception e){
            e.printStackTrace();
        }
        return "";
    }

//    @RequestMapping("save")
//    @ResponseBody
//    public Object save(Model model,SwDjSyTemp swDjSyTempuery){
//        String msg="";
//        try{
//
//            //gdzysService.SaveGdzys(gdzysQuery);
//            msg = "保存成功";
//        }catch(Exception e){
//            e.printStackTrace();
//            msg = "保存失败";
//        }
//        ResponseMessage vo = new ResponseMessage();
//        vo.setMsg(msg);
//        return vo;
//    }

    @RequestMapping("printGdzys")
    @ResponseBody
    public void exportGdzys(Model model, HttpServletResponse response, String pcid, String proid) throws  Exception{
        XMLBuildHelper xmlBuildHelper = new XMLBuildHelper();
        StringBuilder xml = new StringBuilder();
        GdzysQuery gdzysQuery = null;
        if (proid != null) {
            List<SwDjSyTemp> list = swdjSyTempService.getSwDjSyTempListByRwid(proid);
            if (!CollectionUtils.isEmpty(list)) {
                SwDjSyTemp swDjSyTemp = list.get(0);
                SwDjPcxx swDjPcxx = baseRepository.get(SwDjPcxx.class, swDjSyTemp.getBpId());
                gdzysQuery = new GdzysQuery();
                BeanUtils.copyProperties(swDjSyTemp, gdzysQuery);
                BeanUtils.copyProperties(swDjPcxx, gdzysQuery);
            } else {
                gdzysQuery = gdzysService.findGdzysqueryByPCID(pcid);
            }
        } else {
            gdzysQuery = gdzysService.findGdzysqueryByPCID(pcid);
        }

        //根据下拉框代码获取下拉框名称
        //根据主管科股代码获取主管科股名称
        String zgkgDm = gdzysQuery.getZgkgDm();
        String sql = "select mc from dm_swbm where swbmbm=" + zgkgDm;
        String zgkgMc = "";
        try {
            zgkgMc = String.valueOf(baseRepository.getEntityManager().createNativeQuery(sql).getSingleResult());
        }catch(Exception e) {

        }
        gdzysQuery.setZgkgMc(zgkgMc);
        //根据登记注册类型代码获取登记注册类型名称
        String zclxDm = gdzysQuery.getZclxDm();
        String zclxMc = Zclx.getMcByDm(zclxDm);
        gdzysQuery.setZclxMc(zclxMc);
        //根据行业代码获取行业名称
        String hyDm = gdzysQuery.getHyDm();
        String hyMc = Hylx.getMcByDm(hyDm);
        gdzysQuery.setHyMc(hyMc);
        // 获取核查类型名称
        xml.append(xmlBuildHelper.voToXml(gdzysQuery));
        String res=xmlBuildHelper.getPrintXml(xml.toString());
        response.setContentType("text/xml; charset=GBK");
        PrintWriter out = response.getWriter();
        out.write(res);
        out.flush();
        out.close();
    }


    @RequestMapping("openGdzysBySyId")
    public String openQsBySyId(Model model,String syId) {
        model.addAttribute("isYbj","true");
        GdzysQuery pcxx = gdzysService.findGdzysqueryBySyId(syId);
        model.addAttribute("pcxx", pcxx);

        return "landtax/sjwh/syxgGdzysxx";
    }

    //删除 耕地占用税删除_任务
    @RequestMapping("wf/del/del")
    @ResponseBody
    public String wfDel(Model model,String proid) {
        gdzysService.deleteDelWorkflow(proid);
        return "";
    }
}
