package cn.gtmap.landtax.web;

import cn.gtmap.landtax.entity.SwHcXmRwRel;
import cn.gtmap.landtax.service.DicService;
import cn.gtmap.landtax.service.HcxmService;
import cn.gtmap.landtax.util.PlatUtil;
import cn.gtmap.landtax.util.WorkFlowXml;
import cn.gtmap.landtax.util.WorkFlowXmlUtil;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.gtis.common.http.Utf8PostMethod;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.service.WorkFlowCoreService;
import com.gtis.plat.vo.PfOrganVo;
import com.gtis.plat.vo.PfRoleVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.plat.wf.WorkFlowTransInfo;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.plat.wf.model.PerformerModel;
import com.gtis.plat.wf.model.PerformerTaskModel;
import com.gtis.plat.wf.model.TransitionModel;
import com.gtis.web.SessionUtil;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.dom4j.tree.DefaultText;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.IOException;
import java.util.*;

/**
 * 字典项
 * @author deery
 * @version 1.0, 2014/7/7
 */
@Controller
@RequestMapping("/wf")
public class WorkFlowController {
    @Autowired
    DicService dicService;
    @Autowired
    HcxmService hcxmService;
    @Autowired
    WorkFlowCoreService workFlowService;
    @Autowired
    SysUserService sysUserService;
    @Autowired
    private SysTaskService taskService;

    String activityRelType;
    String activitySendSMS;
    String cooperRootId;

    @RequestMapping("turnuser")
    @ResponseBody
    public Object getTurnUserMap(Model model,String ids) throws Exception {
        String userId = SessionUtil.getCurrentUserId();
        Map dicMap = Maps.newHashMap();
        if(StringUtils.isNotBlank(ids)){
            String[] idArr = StringUtils.split(ids,",");
            for(String bdid:idArr){
                SwHcXmRwRel rel = hcxmService.getSwHcXmRwRelByBdId(bdid);
                if (rel != null){
                    String proid = rel.getRwId();
                    if (StringUtils.isNotBlank(proid)){
                        PerformerTaskModel result=getTurnUserList(userId,proid);
                        //解析人员列表，组成select下拉框
                        LinkedHashMap userMap = new LinkedHashMap();
                        if (result != null && result.getUserList() != null && result.getUserList().size() > 0){
                            for(PfUserVo vo:result.getUserList()){
                                userMap.put(vo.getUserId(),vo.getUserName());
                            }
                        }
                        dicMap.put(bdid,userMap);
                    }
                }
            }
        }
        System.out.println(JSON.toJSONString(dicMap));
        return dicMap;

    }

    @RequestMapping("turntask")
    @ResponseBody
    public HashMap<String,Object> turnTask(Model model,String id,String userId) throws Exception {
        HashMap<String,Object> resultMap = new HashMap<String,Object>();
        boolean result = false;
        String msg = "转发失败！";
        try {
            if (StringUtils.isNotBlank(id)){
                SwHcXmRwRel rel = hcxmService.getSwHcXmRwRelByBdId(id);
                if (rel != null){
                    String proid = rel.getRwId();
                    if (StringUtils.isNotBlank(proid)){
                        String taskid = PlatUtil.getTaskIdByProid(proid);
                        if (StringUtils.isNotBlank(taskid)) {
//                            workFlowService.postWorkFlow(userId, taskid, info);
                            SAXReader reader = new SAXReader();
                            String turnXml = initTurnTaskXml(proid,userId,taskid);
                            System.out.println(turnXml);
                            Document doc = DocumentHelper.parseText(turnXml);
                            workFlowService.turnTask(doc,taskid);
                            result = true;
                            msg = "转发成功！";
                        }
                    }
                }
            }
        }catch (Exception e){
            e.printStackTrace();
        }

        resultMap.put("result",result);
        resultMap.put("msg",msg);
        System.out.println(JSON.toJSONString(resultMap));
        model.addAttribute("result",result);
        return resultMap;
    }

    private PerformerTaskModel getTurnUserList(String userId,String proid) throws  Exception{
        PerformerTaskModel result=new PerformerTaskModel();
        try {
            //获取工作流转发信息
            String taskid = PlatUtil.getTaskIdByProid(proid);
            if (StringUtils.isNotBlank(taskid)){
                WorkFlowInfo info = workFlowService.getWorkFlowTurnInfo(userId, taskid);
                // 活动模型
                WorkFlowXml workXml =WorkFlowXmlUtil.getInstanceModel(info.getWorkFlowIntanceVo());
                String activityDefinitionId = info.getSourceActivity().getActivityDefinitionId();
                ActivityModel activityModel = workXml.getActivity(activityDefinitionId);

                // 定义转发列表
                List<TransitionModel> lstTrans = activityModel.getTransitionsList();
                List<ActivityModel> tranActivitys = new ArrayList<ActivityModel>();
                for (TransitionModel transModel : lstTrans) {
                    String nextActivityDefineId = transModel.getToId();
                    ActivityModel nextModel = workXml.getActivity(nextActivityDefineId);
                    List<PerformerModel> performerList = nextModel.getPerformerList();
                    for (PerformerModel performerModel : performerList) {
                        if (!performerModel.getUserId().equals("")) {// 参与者是人
                            String userid = performerModel.getUserId();
                            PfUserVo userVo = sysUserService.getUserVo(userid);
                            List<PfOrganVo> organs=sysUserService.getOrganListByUser(userVo.getUserId());
                            result.setName(organs.get(0).getOrganName());
                            result.setId("0");
                            result.getUserList().add(userVo);
                            result.setType("User");
                        } else if (!performerModel.getOrganId().equals("")) {// 参与者是部门
                            List<PfUserVo> users = sysUserService.getUserListByOragn(performerModel.getOrganId());
                            PfOrganVo organVo=sysUserService.getOrganVo(performerModel.getOrganId());
                            if (organVo!=null){
                                result.setName(organVo.getOrganName());
                                result.setId(organVo.getOrganId());
                                for(PfUserVo vo:users){
                                    result.getUserList().add(vo);
                                }
                            }
                            result.setType("Organ");
                        } else if (!performerModel.getRoleId().equals("")) {// 参与者是角色
                            List<PfUserVo> users = sysUserService.getUserListByRole(performerModel
                                    .getRoleId());
                            PfRoleVo roleVo = sysUserService.getRoleVo(performerModel
                                    .getRoleId());
                            result.setName(roleVo.getRoleName());
                            result.setId(roleVo.getRoleId());
                            for(PfUserVo vo:users){
                                result.getUserList().add(vo);
                            }
                            result.setType("Role");
                        }
                    }
                }
            }
        }catch (Exception e){
            e.printStackTrace();
        }
        return result;
    }


    private String initTurnTaskXml(String proid,String userId,String taskid)throws Exception{
        WorkFlowInfo info = workFlowService.getWorkFlowTurnInfo(userId, taskid);
        WorkFlowTransInfo transInfo=info.getTransInfo();
        List<ActivityModel> lstTrans = transInfo.getTranActivitys();
        if (lstTrans != null && lstTrans.size() > 0) {
            String nextActivityDefineId = lstTrans.get(0).getDefineId();
            WorkFlowXml workXml =WorkFlowXmlUtil.getInstanceModel(info.getWorkFlowIntanceVo());
            ActivityModel nextModel = workXml.getActivity(nextActivityDefineId);

            List<PerformerModel> performerList = nextModel.getPerformerList();
            if (performerList != null && performerList.size() > 0){
                String roleId = "";
                List<PfRoleVo> roleList = sysUserService.getRoleListByUser(userId);
                for (PerformerModel performerModel : performerList) {
                    if (StringUtils.isNotBlank(performerModel.getRoleId())){
                        boolean isok = false;
                        for (PfRoleVo roleVo : roleList){
                            if (StringUtils.equals(performerModel.getRoleId(),roleVo.getRoleId())){
                                roleId = performerModel.getRoleId();
                                isok = true;
                                break;
                            }
                        }
                        if (isok){
                            break;
                        }
                    }
                }

                if (transInfo.getTransType().equalsIgnoreCase("and"))
                    activityRelType = "and";
                else
                    activityRelType = "or";

                String activitysElement = "<Activitys RelType=\"" + activityRelType + "\"";
                activitysElement += " SendSMS= \"false\"";
                activitysElement += ">";
                String activityElement = "<Activity ";
                activityElement += " Id=\"" + nextActivityDefineId + "\">";
                String userInfoElement = "<UserInfo ";
                userInfoElement += " RoleId=\"" + roleId + "\"";
                userInfoElement += " Id=\"" + userId + "\">";
                userInfoElement += "</UserInfo>";
                activityElement += userInfoElement;
                activityElement += "</Activity>";
                activitysElement += activityElement;

                String remarkElement = "<ReMark>";
                String remarkTextElement = "<text>";
                remarkTextElement += "</text>";
                remarkElement += remarkTextElement + "</ReMark>";
                activitysElement += remarkElement + "</Activitys>";
                return activitysElement;
            }
        }
        return null;
    }
    private Document turnInfo(WorkFlowInfo info,String nextuserId) throws Exception {
        String userId = SessionUtil.getCurrentUserId();
        // 获取工作流实例模型
        WorkFlowXml xmlDao = WorkFlowXmlUtil.getInstanceModel(info.getWorkFlowIntanceVo());
        // 获取当前活动定义
        ActivityModel activityModel = xmlDao.getActivity(info.getSourceActivity().getActivityDefinitionId());

        String filterType = null;
        List<String> filterStr = null;
        if(StringUtils.isNotBlank(activityModel.getFilterInfo())){
            //过滤信息对象
            Document fileDoc = DocumentHelper.parseText(activityModel.getFilterInfo());
            //过滤类型：User,Organ,Role
            String user = fileDoc.getRootElement().valueOf("@type");
            Node corNode = fileDoc.selectSingleNode("//Filter/" + user + "[@Id='" + userId + "']/Correspondence");
            if(corNode != null){
                filterType = corNode.valueOf("@type");
                List<DefaultText> organList = corNode.selectNodes(filterType + "/text()");
                if(organList != null && !organList.isEmpty()){
                    filterStr = new ArrayList<String>();
                    for(DefaultText text : organList){
                        filterStr.add(text.getText());
                    }
                }
            }
        }

        WorkFlowTransInfo transInfo=info.getTransInfo();
        Document doc = org.dom4j.DocumentHelper.createDocument();
        //doc.setXMLEncoding("GBK");
        Element root = doc.addElement("Activitys");
        if (transInfo.getTransType().equalsIgnoreCase("and"))
            root.addAttribute("RelType", "and");
        else
            root.addAttribute("RelType", "or");

        if(activityModel.getIsRequiredOpinion().equalsIgnoreCase("true")){
            root.addAttribute("ReqOpinion", "true");
        }else{
            root.addAttribute("ReqOpinion", "false");
        }
        if(activityModel.getIsSendSMS().equalsIgnoreCase("true")){
            root.addAttribute("SendSMS","true");
        }else{
            root.addAttribute("SendSMS","false");
        }
        if(StringUtils.isNotBlank(activityModel.getCooperRootId())){
            root.addAttribute("cooperRootId",activityModel.getCooperRootId());
        }

        List<ActivityModel> lstTrans = transInfo.getTranActivitys();
        if (lstTrans.size()<2)
            root.addAttribute("RelType", "or");
        for (ActivityModel aModel : lstTrans) {
            Element ActivityEle = root.addElement("Activity");
            ActivityEle.addAttribute("Name", aModel.getActivityDefineName());
            ActivityEle.addAttribute("Id", aModel.getDefineId());
            if (aModel.isMutiSelect())
                ActivityEle.addAttribute("MutiSelect", "true");

            ActivityEle.addAttribute("SelectAll","true");

            if(aModel.getActivityDefineName().equalsIgnoreCase(activityModel.getDefaultSelectName()))
                ActivityEle.addAttribute("DefaultSelected", "true");
            else
                ActivityEle.addAttribute("DefaultSelected", "false");
            String userName=null;
            if(StringUtils.isNotBlank(aModel.getExtendedAttribute("DefaultSelectedUser"))){
                userName=aModel.getExtendedAttribute("DefaultSelectedUser");
            }
            for (PerformerTaskModel userModel : aModel.getPerformerModelList()) {
                if(filterStr != null && userModel.getType().equals(filterType)){
                    if(!filterStr.contains(userModel.getId())){
                        continue;
                    }
                }
                if (StringUtils.equals(nextuserId,userModel.getId())){
                    Element User = ActivityEle.addElement("User");
                    User.addAttribute("Name", userModel.getName());
                    User.addAttribute("Id", userModel.getId());
                    for (PfUserVo vo : userModel.getUserList()) {
                        Element UserInfo = User.addElement("UserInfo");
                        UserInfo.addAttribute("Name", vo.getUserName());
                        UserInfo.addAttribute("Id", vo.getUserId());
                        if (StringUtils.isNotBlank(userName) && vo.getUserName().equalsIgnoreCase(userName)){
                            User.addAttribute("DefaultSelected", "true");
                            UserInfo.addAttribute("DefaultSelected", "true");
                        }
                        if (vo.getUserId().equals(SessionUtil.getCurrentUserId())){
                            User.addAttribute("DefaultSelected", "true");
                            UserInfo.addAttribute("DefaultSelected", "true");
                        }
                    }
                    break;
                }
            }
        }
        // 加入是否可以办结
        if (transInfo.isCanFinish()) {
            Element ActivityEle = root.addElement("Activity");
            ActivityEle.addAttribute("Name", "任务办结");
            ActivityEle.addAttribute("Id", "-1");
        }

        doc = httpFilterXml(doc,activityModel,info);
        activityRelType = root.attributeValue("RelType");
        activitySendSMS = root.attributeValue("SendSMS");
        cooperRootId = root.attributeValue("cooperRootId");
        System.out.println(doc.getRootElement().asXML());
        return doc;
    }
    /**
     * 通过TurnInfo处理url
     * @param doc
     * @return
     */
    private Document httpFilterXml(Document doc,ActivityModel actModel,WorkFlowInfo info){
        if(StringUtils.isNotBlank(actModel.getTurnInfoUrl())){
            String url = actModel.getTurnInfoUrl();
            if(!url.startsWith("http")){
                url = AppConfig.getPlaceholderValue(url);
            }
            HttpClient httpClient = new org.apache.commons.httpclient.HttpClient();
            PostMethod postMethod = new Utf8PostMethod(url);
            NameValuePair[] data = {
                    new NameValuePair("turnInfo",doc.asXML()),
                    new NameValuePair("userId",info.getUserId()),
                    new NameValuePair("proId",(info.getWorkFlowIntanceVo() == null)? "":info.getWorkFlowIntanceVo().getProId())
            };

            postMethod.setRequestBody(data);
            int status = 0;
            try {
                status = httpClient.executeMethod(postMethod);
            } catch (IOException e) {
                e.printStackTrace();
            }
            if (status == HttpStatus.SC_OK){
                try {
                    String xml = postMethod.getResponseBodyAsString();
                    if(StringUtils.isNotBlank(xml)){
                        doc = DocumentHelper.parseText(xml);
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return doc;
    }


}
