package cn.gtmap.landtax.web;

import cn.gtmap.landtax.service.DicService;
import cn.gtmap.landtax.util.WorkFlowXmlUtil;
import com.google.common.collect.Maps;
import com.gtis.config.AppConfig;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * 字典项
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2014/7/7
 */
@Controller
@RequestMapping("/dic")
public class DicController {
    @Autowired
    DicService dicService;

    @RequestMapping("")
    @ResponseBody
    public Object getDicMap(Model model,String name) throws Exception {
        Map dicMap = Maps.newHashMap();
        System.out.print(name);
         if(StringUtils.isNotBlank(name)){
            String[] tmpDicNames = StringUtils.split(name,",");

            for(String tmpDicName:tmpDicNames){
                //国土宗地核查活动定义
                if("gtzdhc_workflow_statue".equals(tmpDicName) || "tdzsyd_workflow_statue".equals(tmpDicName)
                        ||  "fczsyd_workflow_statue".equals(tmpDicName)){
                    //获取国土宗地核查的流程定义ID
                    String workflow_definitionId = "";
                    if("gtzdhc_workflow_statue".equals(tmpDicName)){
                        System.out.print("sszd");
                        workflow_definitionId = AppConfig.getProperty("sszd");

                    }else if("tdzsyd_workflow_statue".equals(tmpDicName)){
                        workflow_definitionId = AppConfig.getProperty("tdzsydqc");
                        System.out.print("tdzsydqc");
                    }else if("fczsyd_workflow_statue".equals(tmpDicName)){
                        workflow_definitionId = AppConfig.getProperty("fczsydqc");
                        System.out.print("fczsydqc");

                    }

                    List<Map> responseList = new ArrayList<Map>();

                    //未下发
                    Map<String, String> wxfStatue = new HashMap<String, String>();
                    wxfStatue.put("activityDefinitionId", "wxf");
                    wxfStatue.put("activityName", "未下发");
                    responseList.add(wxfStatue);

                    //各活动节点
                    List<HashMap> activityList = WorkFlowXmlUtil.getActivityListByWorkDefinId(workflow_definitionId);
                    responseList.addAll(activityList);

                    //已办结
                    Map<String, String> ybjStatue = new HashMap<String, String>();
                    ybjStatue.put("activityDefinitionId", "ybj");
                    ybjStatue.put("activityName", "已办结");
                    responseList.add(ybjStatue);

                    dicMap.put(tmpDicName,responseList);
                }else{
                    dicMap.put(tmpDicName,dicService.buildEnumMap(tmpDicName));
                }
            }
        }
        return dicMap;

    }

    /**
     * 获取application.properties配置
     * @param model
     * @param name
     * @return
     * @throws Exception
     */
    @RequestMapping("getConfig")
    @ResponseBody
    public Object getConfig(Model model,String name) throws Exception {
        String property = AppConfig.getProperty(name);
        return property;

    }
}
