package cn.gtmap.landtax.util;

import cn.gtmap.landtax.entity.Project;
import com.gtis.plat.vo.PfActivityVo;

import java.util.List;

public interface IPlatUtil {
    /**
     * 创建工作流
     *
     * @param project
     * @param userId
     * @return taskId
     */
    public String createWorkFlowInstance(Project project, String userId,String proName);

    public void deleteWorkFlowInstance(String proid) throws Exception;

    /**
     * 获取承诺期限(项目时限)
     *
     * @param wdid
     * @return
     */
    public String getCNQX(String wdid);

    /**
     * 通过projectId 获取工作流定义的remark
     *
     * @param projectId
     * @return
     */
    public String getWfRemarkByProjectId(String projectId);

    /**
     * 通过工作流定义ID(Wdid) 获取工作流定义的remark
     *
     * @param wdid
     * @return
     */
    public String getWfRemarkByWdid(String wdid);

    /**
     * 获取实例时限
     *
     * @param wdid
     * @return
     */
    public String getTimeLimit(String wdid);

    /**
     * 修改实例名称
     *
     * @param projectId
     * @param projectName
     */
    public void editWorkFlowInstanceName(String projectId, String projectName);

    /**
     * 修改实例remark+projectName projectname可以为空
     *
     * @param projectId
     * @param remark
     * @param projectName
     */
    public void editWorkFlowInstance(String projectId, String remark,
                                     String projectName);

    /**
     * 根据taskid获取活动实例名称
     *
     * @param taskId
     * @return activityName
     */
    public String getPfActivityNameByTaskId(String taskId);

    /**
     * 根据taskid获取活动实例Id
     *
     * @param taskId
     * @return activityName
     */
    public String getPfacdfIdByTaskId(String taskId);

    /**
     * 获取活动定义的描述
     *
     * @param
     * @param
     * @return
     */
    public String getActivityDesc(String projectId, String activityId);

    /**
     * 根据taskid获取活动实例Id
     *
     * @param taskId
     * @return activityName
     */
    public String getPfActivityIdByTaskId(String taskId);

    /**
     * zdd 根据项目ID获取项目对应文件中心的文件ID
     *
     * @param projectId
     * @return
     */
    public List<String> getFileId(String projectId);

    /**
     * zdd 根据项目ID于附件的描述获取文件的Id
     *
     * @param projectId
     * @param desc
     * @return
     */
    public List<String> getFileId(String projectId, String desc);

    /**
     * 编辑文件描述和姓名
     *
     * @param fileId
     * @param desc
     * @param projectId
     */
    public void saveNodeDescByProjectId(Integer fileId, String desc, String projectId);

    public void removeFile(Integer fileId);

    public void saveNodeDesc(Integer fileId, String desc);

    /**
     * zdd 获取工作流(WORK_FLOW_STUFF)的token，获取不到就返回万能的token
     *
     * @return
     */
    public String getToken();

    /**
     * zdd 获取工作流附件节点Id
     *
     * @return
     */
    public String getWorkFlowStuffId();

    public String getProjectFileId(String projectId);

    /**
     * zdd 创建目录  并且返回目录的Id
     *
     * @param parentId
     * @param folderNodeName
     * @return
     */
    public Integer createFileFolderByclmc(String parentId, String folderNodeName);

    public void updateFileName(String projectId);

    /**
     * 检查某项目下某一文件名为flodername的文件夹下是否有文件
     * @param projectId
     * @param floderName
     * @return
     */
    public boolean checkFloder(String projectId, String floderName);

    /**
     * 获得某项目下某一文件名为flodername的文件夹下是有几个文件
     * @param projectId
     * @param floderName
     * @return
     */
    public Integer getFilesCounet(String projectId, String floderName);

    public PfActivityVo getActivityInfo(String paramString);
}