package cn.gtmap.landtax.support.jpa;

import org.hibernate.HibernateException;
import org.hibernate.type.StandardBasicTypes;

import java.sql.Types;

/**
 * @author Zenglihuan
 * @version V1.0, 20161109
 */
public class Oracle10gDialect extends org.hibernate.dialect.Oracle10gDialect {

    public Oracle10gDialect() {
        super();
        registerHibernateType(101, StandardBasicTypes.STRING.getName());
        registerHibernateType(Types.NVARCHAR, StandardBasicTypes.STRING.getName());
        registerHibernateType(Types.FLOAT, StandardBasicTypes.STRING.getName());
        registerHibernateType(Types.DECIMAL, StandardBasicTypes.STRING.getName());
    }

    @Override
    public String getTypeName(int code, long length, int precision, int scale) throws HibernateException {
        switch (code) {
            case Types.INTEGER:
                if (precision > 0 && precision < 10) {
                    return "number(" + precision + ",0)";
                }
            case Types.BIGINT:
                if (precision > 0 && precision < 19) {
                    return "number(" + precision + ",0)";
                }
            case Types.DATE:
                return "date";
            case Types.VARCHAR:
                return "varchar2($l char)";
            case Types.DOUBLE:
                return "double precision";
            case Types.BLOB:
                return "blob";
        }
        return super.getTypeName(code, length, precision, scale);
    }
}
