package cn.gtmap.landtax.support.jpa;



import cn.gtmap.landtax.util.QueryCondition;
import com.mysema.query.jpa.JPQLQuery;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Predicate;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaQuery;
import java.util.List;

/**
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2014/6/25
 */
public interface BaseRepository_hl {

    public <T> T get(Class<T> clazz, Object id);

    public <T> void delete(Class<T> clazz, Object id);

    public <T> void delete(Object entity);

    public <T> void delete(Class<T> clazz, Object[] ids);

    public void save(Object entity);

    public void update(Object entity);


    public Object get(JPQLQuery query);
    public Object get(JPQLQuery query, Expression expression);

    public <T> List<T> dslList(EntityPath<T> entityPath);

    public List<Object> dslList(JPQLQuery query, Expression expression);

    public <T> List<T> dslList(EntityPath<T> entityPath, Expression<T> expression);

    public <T> List<T> dslList(EntityPath<T> entityPath, Expression<T> expression, Predicate... predicates);


    public <T> List<T> sql(String sql);

    public <T> List<T> sql(String sql, Class<T> clazz);

    public <T> List<T> find(Class<T> clazz, List<QueryCondition> queryConditions, String orderBy, int currentPage, int pageSize);

    public <T> Page<T> find(Class<T> clazz, List<QueryCondition> queryConditions, String orderBy, Pageable pageable);

    public <T> Page<T> find(EntityPath<T> entityPath, Pageable pageable, Predicate... predicates);

    public <T> Page<T> find(EntityPath entityPath, Pageable pageable, Expression expression, Predicate... predicates);

    public <T> Page<T> find(JPQLQuery jpaQuery, Expression expression, Pageable pageable);

    public <T> Page<T> find(JPQLQuery jpaQuery, Expression expression, Query countQuery, Pageable pageable);

    public <T> Page<T> find(Query query, Query countQuery, Pageable pageable);


    public <T> List<T> list(Class<T> clazz, List<QueryCondition> queryConditions);

    public <T> List<T> list(Class<T> clazz, List<QueryCondition> queryConditions, String orderBy);

    public <T> List<T> list(CriteriaQuery<T> criteriaQuery);

    public Object getSingleResult(Class clazz, List<QueryCondition> queryConditions);

    public long getRecordCount(Class clazz, List<QueryCondition> queryConditions);


    public <T> List<T> getByJpql(String jpql, Object... objects);


    public int executeJpql(String jpql, Object... objects);

    public Object getUniqueResultByJpql(String jpql, Object... objects);

    public EntityManager getEntityManager();

    public void addEntityPath(EntityPath... entityPaths);

}
