package cn.gtmap.landtax.service.impl;


import cn.gtmap.landtax.entity.*;
import cn.gtmap.landtax.model.dictionary.*;
import cn.gtmap.landtax.model.query.SwDjQsQuery;
import cn.gtmap.landtax.service.*;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.*;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.service.WorkFlowCoreService;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.wf.model.PerformerTaskModel;
import com.gtis.web.SessionUtil;
import com.mysema.query.jpa.JPQLQuery;
import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.types.Projections;
import com.mysema.query.types.QBean;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.hibernate.SQLQuery;
import org.hibernate.id.GUIDGenerator;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.Query;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.security.acl.LastOwnerException;
import java.util.*;

@Service
public class gdhcServiceImpl implements GdhcService{
    @Autowired
    BaseRepository baseRepository;
    @Autowired
    HashMap hcjdConfigMap;
    @Autowired
    IPlatUtil platUtil;
    @Autowired
    HcxmService hcxmService;
    @Autowired
    TaxService taxService;
    @Autowired
    SysUserService sysUserService;
    @Autowired
    ZdhcService zdhcService;
    @Autowired
    WorkFlowCoreService workFlowService;
    @Autowired
    DwxxService dwxxService;

    private static final String CREATE_USER_NAME="create_user_name";

    @Transactional(value="oracle_common")
    public void createXmxx(List<Map<String, String>> list) throws Exception {
        Map<String, String> qxMap = dwxxService.getAllQxMapByMc();
        for(Map<String, String> map : list){
            SwDjXmxx swDjXmxx = new SwDjXmxx();
            swDjXmxx.setXmId(UUIDGenerator.generate());
            swDjXmxx.setXmmc(map.get("XMMC"));
            swDjXmxx.setGdmj(GtmapStringUtils.isBlank(map.get("GDMJ")) ? new BigDecimal(0) : new BigDecimal(map.get("GDMJ")));
            swDjXmxx.setQdfs(Tdqdfs.getDmByMc(map.get("GDFS_MC")));
            swDjXmxx.setQdjg(GtmapStringUtils.isBlank(map.get("QDJG")) ? new BigDecimal(0) : new BigDecimal(map.get("GDJG")));
            swDjXmxx.setGdsj(GtmapDateUtils.strToDate(map.get("GDSJ"), GtmapDateUtils.DATE_FORMAT_SHORT));
            swDjXmxx.setXmTdyt(Tdyt.getDmByMc(map.get("TDYT_MC")));
            swDjXmxx.setXmYddw(map.get("YDDW"));
            swDjXmxx.setXmXzqdm(GtmapStringUtils.isBlank(map.get("XZQMC"))?null:qxMap.get(map.get("XZQMC")));
            swDjXmxx.setXmTdzl(map.get("TDZL"));
            if(GtmapStringUtils.isNotBlank(map.get("DJH"))){
                Zd zd = baseRepository.get(Zd.class, map.get("DJH"));
                swDjXmxx.setZd(zd);
            }

            baseRepository.save(swDjXmxx);

            /*String insertSql = "insert into SW_DJ_XMXX(XM_ID, XMMC, GDMJ, QDFS, QDJG, GDSJ, TDYT, YDDW, XZQDM, TDZL, DJH) " +
                    "values(SYS_GUID(), :XMMC, :GDMJ, :QDFS, :QDJG, :GDSJ, :TDYT, :YDDW, :XZQDM, :TDZL, :DJH)";

            Query query = baseRepository.getEntityManager().createNativeQuery(insertSql)
                    .setParameter("XMMC", map.get("XMMC"))
                    .setParameter("GDMJ", GtmapStringUtils.isBlank(map.get("GDMJ"))?new BigDecimal(0):new BigDecimal(map.get("GDMJ")))
                    .setParameter("QDFS", Tdqdfs.getDmByMc(map.get("GDFS_MC")))
                    .setParameter("QDJG", GtmapStringUtils.isBlank(map.get("QDJG"))?new BigDecimal(0):new BigDecimal(map.get("GDJG")))
                    .setParameter("GDSJ", GtmapDateUtils.strToDate(map.get("GDSJ"), GtmapDateUtils.DATE_FORMAT_SHORT))
                    .setParameter("TDYT", Tdyt.getDmByMc(map.get("TDYT_MC")))
                    .setParameter("YDDW", map.get("YDDW"))
                    .setParameter("XZQDM", map.get("XZQMC") == null?null:qxMap.get(map.get("XZQMC")))
                    .setParameter("TDZL", map.get("TDZL"))
                    .setParameter("DJH", map.get("DJH"));
            query.executeUpdate();*/
        }
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public Page<SwDjXmxx> whclbJson(SwDjQsQuery swDjQsQuery,Pageable pageable) {
        String[] configArr = (String[]) hcjdConfigMap.get(Hcxmlx.GDHC.toString());
        String sql = "SELECT t1.*, t6.MC AS QDFS_MC, t5.MC AS TDYT_MC, " +
                "           t3.DWMC AS XZQMC, TO_CHAR(t4.USER_NAME) AS USER_NAME, " +
                    "       DECODE(t2.BLZT, " +
                    "              '1', '6', " +
                    "              DECODE(t4.ACTIVITY_DEFINITION_ID, " +
                    "                     :conf0, '1', " +
                    "                     :conf1, '2', " +
                    "                     :conf2, '3', " +
                    "                     :conf3, '4', " +
                    "                     :conf4, '5', " +
                    "                     '0' " +
                    "                     ) " +
                    "              ) AS STATUE " +
                    "FROM SW_DJ_XMXX t1 " +
                    "     LEFT JOIN (SELECT * FROM SW_HC_XM_RW_REL WHERE HCXM_ID IN (SELECT ID FROM SW_HC_XM WHERE XMLX = :hclx)) t2 on t1.XM_ID = t2.BD_ID " +
                    "     LEFT JOIN S_DM_DWXX_CZ t3 ON t1.XZQDM = t3.DWDM " +
                    "     LEFT JOIN ( " +
                    "         SELECT t4.WORKFLOW_INSTANCE_ID, t4.ACTIVITY_DEFINITION_ID, t6.USER_NAME " +
                    "         FROM ( " +
                    "             SELECT * " +
                    "             FROM PF_ACTIVITY t " +
                    "             WHERE t.ACTIVITY_STATE='1' " +
                    "             ) t4 " +
                    "             LEFT JOIN PF_ASSIGNMENT t5 ON t5.ACTIVITY_ID=t4.ACTIVITY_ID " +
                    "             LEFT JOIN PF_USER t6 ON t5.USER_ID=t6.USER_ID " +
                    "     ) t4 ON t4.WORKFLOW_INSTANCE_ID=t2.RW_ID " +
                    "     LEFT JOIN S_ZD_TDYT t5 ON t1.TDYT = t5.DM " +
                    "     LEFT JOIN S_ZD_TDQDFS t6 ON t1.QDFS = t6.DM " +
                    "WHERE 1=1 ";
        sql = addWhclbWhere(swDjQsQuery,sql,true);

        String statue = swDjQsQuery.getStatue();
        if(StringUtils.isNotBlank(statue)) {
            if (statue.equals("6")) {
                sql = sql + " and t2.BLZT = '1' ";
            } else if (statue.equals("0")) {
                sql = sql + " and NVL(t2.BLZT, '0')='0' and (t4.ACTIVITY_DEFINITION_ID NOT IN (:conf0, :conf1, :conf2, :conf3, :conf4) OR t4.ACTIVITY_DEFINITION_ID IS NULL)";
            } else if (statue.equals("1")) {
                sql = sql + " and NVL(t2.BLZT, '0')='0' and t4.ACTIVITY_DEFINITION_ID = :conf0 ";
            } else if (statue.equals("2")) {
                sql = sql + " and NVL(t2.BLZT, '0')='0' and  t4.ACTIVITY_DEFINITION_ID= :conf1 ";
            } else if (statue.equals("3")) {
                sql = sql + " and NVL(t2.BLZT, '0')='0' and  t4.ACTIVITY_DEFINITION_ID= :conf2 ";
            } else if (statue.equals("4")) {
                sql = sql + " and NVL(t2.BLZT, '0')='0' and  t4.ACTIVITY_DEFINITION_ID= :conf3 ";
            } else if (statue.equals("5")) {
                sql = sql + " and NVL(t2.BLZT, '0')='0' and  t4.ACTIVITY_DEFINITION_ID= :conf4 ";
            }
        }

        Query query = baseRepository.getEntityManager().createNativeQuery(sql)
                .setParameter("hclx", Hcxmlx.GDHC.toString())
                .setParameter("conf0", configArr[0])
                .setParameter("conf1", configArr[1])
                .setParameter("conf2", configArr[2])
                .setParameter("conf3", configArr[3])
                .setParameter("conf4", configArr[4]);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        StringBuffer countSql = new StringBuffer("SELECT COUNT(*) FROM (").append(sql).append(")");
        Query countQuery = baseRepository.getEntityManager().createNativeQuery(countSql.toString())
                .setParameter("hclx", Hcxmlx.GDHC.toString())
                .setParameter("conf0", configArr[0])
                .setParameter("conf1", configArr[1])
                .setParameter("conf2", configArr[2])
                .setParameter("conf3", configArr[3])
                .setParameter("conf4", configArr[4]);
        Page page =  baseRepository.find(query, countQuery, pageable);
        return page;
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public Object getZtByXmId(String xmId) {
        String sql = "select t2.blzt,t4.activity_name,t4.activity_state,t4.activity_definition_id,to_char(t5.user_id)user_id,to_char(t6.user_name)user_name from sw_dj_xmxx t1 " +
                "left join sw_hc_xm_rw_rel t2 on t1.xm_id = t2.bd_id " +
                "left join sw_hc_xm t3 on t3.id=t2.hcxm_id " +
                "left join " +
                "( " +
                "  select * from pf_activity t where t.activity_state='1'   " +
                ") t4  " +
                "on t4.workflow_instance_id=t2.rw_id "+
                "left join pf_assignment t5 on t5.activity_id=t4.activity_id "+
                "left join pf_user t6 on t5.user_id=t6.user_id "+
                "where t3.xmlx='"+Hcxmlx.GDHC.toString()+"' "+
                "and t1.xm_id='"+xmId+"' ";

        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        ResponseMessage responseMessage = new ResponseMessage();
        HashMap resultMap = new HashMap();
        if(CollectionUtils.isNotEmpty(list)){
            HashMap<String,Object> tempMap = list.get(0);
            String activityName = String.valueOf(tempMap.get("ACTIVITY_NAME")==null?"":tempMap.get("ACTIVITY_NAME"));
            String activity_state = String.valueOf(tempMap.get("ACTIVITY_STATE")==null?"":tempMap.get("ACTIVITY_STATE"));
            String activity_definition_id = String.valueOf(tempMap.get("ACTIVITY_DEFINITION_ID")==null?"":tempMap.get("ACTIVITY_DEFINITION_ID"));
            String blzt = String.valueOf(tempMap.get("BLZT")==null?"":tempMap.get("BLZT"));
            String userName = String.valueOf(tempMap.get("USER_NAME")==null?"":tempMap.get("USER_NAME"));
            resultMap.put("userName",StringUtils.isBlank(userName)?"":userName);
            if(StringUtils.isNotBlank(blzt) && "1".equals(blzt)){
                responseMessage.setMsg("6");
            }else if(StringUtils.isBlank(activityName) || "null".equalsIgnoreCase(activityName)){
                responseMessage.setMsg("0");
            }else if("1".equals(activity_state)){
                String[] configArr = (String[]) hcjdConfigMap.get(Hcxmlx.GDHC.toString());
                if(StringUtils.isNotBlank(activity_definition_id)){
                    for(int i=0;i<configArr.length;i++){
                        if(activity_definition_id.equalsIgnoreCase(configArr[i])){
                            responseMessage.setMsg(i+1+"");
                        }
                    }
                }
            }

        }else{
            responseMessage.setMsg("0");
        }
        resultMap.put("statue",responseMessage.getMsg());
        return resultMap;
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public Object getTJrws(SwDjQsQuery swDjQsQuery) throws  Exception{
        String workflowDefinId = AppConfig.getProperty("gdhc");
        List activityList = WorkFlowXmlUtil.getActivityListByWorkDefinId(workflowDefinId);
        String regionCode = SessionUtil.getCurrentUser().getRegionCode();
        Map resultMap = new HashMap();
        String wxf = getWxfSql(swDjQsQuery,activityList,regionCode);
        String sjxf = getSjxfSql(swDjQsQuery,activityList,regionCode);
        String qxxf = getQxxfSql(swDjQsQuery,activityList,regionCode);
        String hczzxf = getHczzxfSql(swDjQsQuery,activityList,regionCode);
        String swryxf = getSwryxfSql(swDjQsQuery,activityList,regionCode);
        String qrrk = getQrrkSql(swDjQsQuery,activityList,regionCode);
        String ybj = getYbjSql(swDjQsQuery,activityList,regionCode);
        resultMap.put("WXF",wxf);
        resultMap.put("SJXF",sjxf);
        resultMap.put("QXXF",qxxf);
        resultMap.put("ZZ",hczzxf);
        resultMap.put("SWRY",swryxf);
        resultMap.put("QRRK",qrrk);
        resultMap.put("YBJ",ybj);
        return resultMap;
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public List<SwDjXmxx> getGdxmListByIds(String[] xmIds) {
        QSwDjXmxx qSwDjXmxx = QSwDjXmxx.swDjXmxx;
        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        jpaQuery.from(qSwDjXmxx).where(qSwDjXmxx.xmId.in(xmIds));
        return (List)baseRepository.dslList(jpaQuery,qSwDjXmxx);
    }

    @Override
    public List<SwDjXmxx> getGdxmListByQuery(SwDjQsQuery swDjQsQuery) {
        QSwDjXmxx qSwDjXmxx = QSwDjXmxx.swDjXmxx;
        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        jpaQuery.from(qSwDjXmxx);
        applyQueryPredicates(swDjQsQuery, qSwDjXmxx, jpaQuery);
        return (List)baseRepository.dslList(jpaQuery,qSwDjXmxx);
    }

    @Override
    @Transactional(value="oracle_common")
    public void createHcxm(SwHcXm swHcXm, List<SwDjXmxx> swDjXmxxList, String userId)throws  Exception{
        baseRepository.save(swHcXm);

        //创建核查任务的工作流项目
        for(SwDjXmxx swDjXmxx:swDjXmxxList){
            Project project = new Project();
            String wiid = UUIDGenerator.generate();
            project.setProjectId(wiid);
            String wwid = AppConfig.getProperty("gdhc");
            project.setWdid(wwid);
            try {
                platUtil.createWorkFlowInstance(project, userId,swDjXmxx.getXmmc());
            }catch (Exception e){
                throw  new Exception();
            }


            SwHcXmRwRel swHcXmRwRel = new SwHcXmRwRel();
            swHcXmRwRel.setShxrId(UUIDGenerator.generate());
            swHcXmRwRel.setRwId(wiid);
            swHcXmRwRel.setSwHcXm(swHcXm);
            swHcXmRwRel.setBdId(swDjXmxx.getXmId());
            swHcXmRwRel.setBlzt("0");
            baseRepository.save(swHcXmRwRel);
        }
    }

    @Override
    @Transactional(value="oracle_common")
    public String createHcxmGdbl(SwHcXm swHcXm, SwDjXmxx swDjXmxx, String userId) throws Exception {
        baseRepository.save(swHcXm);

        String result = "";

        //创建核查任务的工作流项目
        Project project = new Project();
        String wiid = UUIDGenerator.generate();
        project.setProjectId(wiid);
        String wwid = AppConfig.getProperty("gdbl");
        project.setWdid(wwid);
        try {
            result = platUtil.createWorkFlowInstance(project, userId, swDjXmxx.getXmmc());
        }catch (Exception e){
            if (((RuntimeException)e).getMessage().equals("该用户不允许创建该流程")) {
                result = "java.lang:" + ((RuntimeException) e).getMessage().substring(0, ((RuntimeException) e).getMessage().length());
                return result;
            } else {
                throw new RuntimeException();
            }
        }


        SwHcXmRwRel swHcXmRwRel = new SwHcXmRwRel();
        swHcXmRwRel.setShxrId(UUIDGenerator.generate());
        swHcXmRwRel.setRwId(wiid);
        swHcXmRwRel.setSwHcXm(swHcXm);
        swHcXmRwRel.setBdId(swDjXmxx.getXmId());
        swHcXmRwRel.setBlzt("0");
        baseRepository.save(swHcXmRwRel);

        return result;
    }

    @Override
    @Transactional(value="oracle_common")
    public void wfDel(String proid) {
        //1,删除swHcXmRwRel下的所有税源，此时税源状态都是3(零时)
        SwHcXmRwRel swHcXmRwRel = hcxmService.getSwHcXmRwRelByWiid(proid);
        Set<SwDjSy> swDjSySet = swHcXmRwRel.getSwDjSySet();
        if (swDjSySet != null) {
            List<SwDjSy> swDjSyList = new ArrayList<SwDjSy>(swDjSySet);
            for (SwDjSy swDjSy : swDjSyList) {
                //删除税源
                taxService.deleteSwDjSy(swDjSy.getSyId());
            }
        }

        //3,删除SwHcXmRwRel记录
        hcxmService.doSwHcXmRwRel(swHcXmRwRel);

        //4,判断SwHcXm中是否还有swHcXmRwRel
        hcxmService.doSwHcXm(swHcXmRwRel);
    }

    @Override
    @Transactional(value="oracle_common")
    public void wfEnd(String proid) {
        //1,将swDjSy.syzt 设置成1
        SwHcXmRwRel swHcXmRwRel = hcxmService.getSwHcXmRwRelByWiid(proid);
        Set<SwDjSy> swDjSySet = swHcXmRwRel.getSwDjSySet();
        List<SwDjSy> swDjSyList = new ArrayList<SwDjSy>(swDjSySet);
        for(SwDjSy swDjsy : swDjSyList){
            SwDjTd tempTd = swDjsy.getSwDjTd();
            if (tempTd != null) {
                tempTd.setSjly(Sjly.SYHC.toString());
                baseRepository.update(tempTd);
            }
            SwDjFc tempFc = swDjsy.getSwDjFc();
            if (tempFc != null) {
                tempFc.setSjly(Sjly.SYHC.toString());
                baseRepository.update(tempFc);
            }
            taxService.softDelSyDjSy(swDjsy.getSyId(), Syzt.ZC.toString());
        }


        //3,SwHcXmRwRel.blzt 设置为1，表示该任务已办结
        hcxmService.doUpSwHcXmRwRel(swHcXmRwRel);

        //4,判断SwHcXm中是否还有swHcXmRwRel
        hcxmService.doUpSwHcXm(swHcXmRwRel);
    }

    /*@Override
    @Transactional(value="oracle_common",readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public List<SwDjXmxx> getSwDjXmxxList(HashMap param) {
        Object idsObj = param.get("ids");
        SwDjQsQuery swDjQsQuery = (SwDjQsQuery) param.get("swDjQsQuery");
        QSwDjXmxx qSwDjXmxx=QSwDjXmxx.swDjXmxx;
        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());

        QBean qBeanz = Projections.bean(SwDjXmxx.class, qSwDjXmxx.zd.djh, qSwDjXmxx.xmmc, qSwDjXmxx.xmTdzl, qSwDjXmxx.xmYddw,
                qSwDjXmxx.gdmj, qSwDjXmxx.qdjg, qSwDjXmxx.gdsj, qSwDjXmxx.qdfs, qSwDjXmxx.xmTdyt, qSwDjXmxx.xmXzqdm, qSwDjXmxx.xmId);
        String regionCode = SessionUtil.getCurrentUser().getRegionCode();
        if(StringUtils.isNotBlank(regionCode)){
            if(regionCode.length()>6){
                regionCode=regionCode.substring(0,6);
            }
        }else{
            regionCode="";
        }
        jpaQuery.from(qSwDjXmxx);

        if(idsObj!=null){
            String ids = String.valueOf(idsObj);
            List idsList = Arrays.asList(ids.split(","));
            jpaQuery.where(qSwDjXmxx.xmId.in(idsList));
        }else{
            jpaQuery.where(qSwDjXmxx.xmXzqdm.like(regionCode+ QueryCondition.WILDCARDS));
            applyQueryPredicates(swDjQsQuery,qSwDjXmxx,jpaQuery);
        }
        jpaQuery.orderBy(qSwDjXmxx.xmId.desc().nullsLast());
        return (List)baseRepository.dslList(jpaQuery,qBeanz);
    }
*/
    @Override
    @Transactional(value="oracle_common",readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public List<Map<String, Object>> getSwDjXmxxList(HashMap param) {
        Object idsObj = param.get("ids");
        SwDjQsQuery swDjQsQuery = (SwDjQsQuery) param.get("swDjQsQuery");
        String[] configArr = (String[]) hcjdConfigMap.get(Hcxmlx.GDHC.toString());
        String sql = "SELECT t1.*, TO_CHAR(t4.USER_NAME) AS USER_NAME, " +
                "           t3.DWMC AS XZQMC, t5.MC AS TDYT_MC, t6.MC AS QDFS_MC, " +
                "       DECODE(t2.BLZT, " +
                "              '1', '6', " +
                "              DECODE(t4.ACTIVITY_DEFINITION_ID, " +
                "                     :conf0, '1', " +
                "                     :conf1, '2', " +
                "                     :conf2, '3', " +
                "                     :conf3, '4', " +
                "                     :conf4, '5', " +
                "                     '0' " +
                "                     ) " +
                "              ) AS STATUE " +
                "FROM SW_DJ_XMXX t1 " +
                "     LEFT JOIN (SELECT * FROM SW_HC_XM_RW_REL WHERE HCXM_ID IN (SELECT ID FROM SW_HC_XM WHERE XMLX = :hclx)) t2 on t1.XM_ID = t2.BD_ID " +
                "     LEFT JOIN S_DM_DWXX_CZ t3 ON t1.XZQDM = t3.DWDM " +
                "     LEFT JOIN ( " +
                "         SELECT t4.WORKFLOW_INSTANCE_ID, t4.ACTIVITY_DEFINITION_ID, t6.USER_NAME " +
                "         FROM ( " +
                "             SELECT * " +
                "             FROM PF_ACTIVITY t " +
                "             WHERE t.ACTIVITY_STATE='1' " +
                "             ) t4 " +
                "             LEFT JOIN PF_ASSIGNMENT t5 ON t5.ACTIVITY_ID=t4.ACTIVITY_ID " +
                "             LEFT JOIN PF_USER t6 ON t5.USER_ID=t6.USER_ID " +
                "     ) t4 ON t4.WORKFLOW_INSTANCE_ID=t2.RW_ID " +
                "     LEFT JOIN S_ZD_TDYT t5 ON t1.TDYT = t5.DM " +
                "     LEFT JOIN S_ZD_TDQDFS t6 ON t1.QDFS = t6.DM " +
                "WHERE 1=1 ";
        if(idsObj!=null){
            String ids = String.valueOf(idsObj);
            List idsList = Arrays.asList(ids.split(","));
            sql += " and t1.XM_ID IN " + GtmapStringUtils.getInString(idsList);
        }else{
            sql = addWhclbWhere(swDjQsQuery,sql,true);

            String statue = swDjQsQuery.getStatue();
            if(StringUtils.isNotBlank(statue)) {
                if (statue.equals("6")) {
                    sql = sql + " and t2.BLZT = '1' ";
                } else if (statue.equals("0")) {
                    sql = sql + " and NVL(t2.BLZT, '0')='0' and (t4.ACTIVITY_DEFINITION_ID NOT IN (:conf0, :conf1, :conf2, :conf3, :conf4) OR t4.ACTIVITY_DEFINITION_ID IS NULL)";
                } else if (statue.equals("1")) {
                    sql = sql + " and NVL(t2.BLZT, '0')='0' and t4.ACTIVITY_DEFINITION_ID = :conf0 ";
                } else if (statue.equals("2")) {
                    sql = sql + " and NVL(t2.BLZT, '0')='0' and  t4.ACTIVITY_DEFINITION_ID = :conf1 ";
                } else if (statue.equals("3")) {
                    sql = sql + " and NVL(t2.BLZT, '0')='0' and  t4.ACTIVITY_DEFINITION_ID = :conf2 ";
                } else if (statue.equals("4")) {
                    sql = sql + " and NVL(t2.BLZT, '0')='0' and  t4.ACTIVITY_DEFINITION_ID = :conf3 ";
                } else if (statue.equals("5")) {
                    sql = sql + " and NVL(t2.BLZT, '0')='0' and  t4.ACTIVITY_DEFINITION_ID = :conf4 ";
                }
            }

            String regionCode = SessionUtil.getCurrentUser().getRegionCode();
            if(StringUtils.isNotBlank(regionCode)){
                if(regionCode.length() > 6){
                    regionCode=regionCode.substring(0,6);
                }
            }else{
                regionCode="";
            }
            String regionCodeCondition = regionCode+"%";
            sql += " and t1.XZQDM like '" + regionCodeCondition + "' ";
        }

        Query query = baseRepository.getEntityManager().createNativeQuery(sql)
                .setParameter("hclx", Hcxmlx.GDHC.toString())
                .setParameter("conf0", configArr[0])
                .setParameter("conf1", configArr[1])
                .setParameter("conf2", configArr[2])
                .setParameter("conf3", configArr[3])
                .setParameter("conf4", configArr[4]);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        return query.getResultList();
    }

    @Override
    @Transactional(value="oracle_common")
    public void delWorkflow(String xzqdm) {
        //删除pf_assignment
        String delAssignmentSql = "delete from pf_assignment t where t.assignment_id in  " +
                                "( " +
                                "  select t1.assignment_id from pf_assignment t1 " +
                                "  left join pf_activity t2 on t1.activity_id=t2.activity_id " +
                                "  left join pf_workflow_instance t3 on t3.workflow_instance_id=t2.workflow_instance_id " +
                                "  where t3.workflow_instance_id in " +
                                "  (select t1.rw_id from sw_hc_xm_rw_rel t1 left join sw_hc_xm t2 on t1.hcxm_id=t2.id left join sw_dj_xmxx t3 on t3.xm_id=t1.bd_id where t2.xmlx='"+Hcxmlx.GDHC.toString()+"' and t3.xzqdm like '%"+xzqdm+"%') " +
                                ")";
        Query delAssignmentQuery = baseRepository.getEntityManager().createNativeQuery(delAssignmentSql);
        delAssignmentQuery.executeUpdate();
        //3,删除pf_assignmenthistory

        String delAssignmenthistorySql = "delete from pf_assignmenthistory t where t.assignment_id in ( " +
                "       select t1.assignment_id from pf_assignmenthistory t1 " +
                "       left join pf_activity t2 on t1.activity_id=t2.activity_id " +
                "       left join pf_workflow_instance t3 on t3.workflow_instance_id=t2.workflow_instance_id " +
                "       where t3.workflow_instance_id in (select t1.rw_id from sw_hc_xm_rw_rel t1 left join sw_hc_xm t2 on t1.hcxm_id=t2.id left join sw_dj_xmxx t3 on t3.xm_id=t1.bd_id where t2.xmlx='"+Hcxmlx.GDHC.toString()+"' and t3.xzqdm like '%"+xzqdm+"%'))";
        Query delAssignmenthistoryQuery = baseRepository.getEntityManager().createNativeQuery(delAssignmenthistorySql);
        delAssignmenthistoryQuery.executeUpdate();
        //4，删除pf_activity
        //activityId list
        String delActivitySql = "delete from pf_activity t where t.activity_id in(select t1.activity_id from pf_activity t1 " +
                "left join pf_workflow_instance t2 on t1.workflow_instance_id=t2.workflow_instance_id " +
                "where t2.workflow_instance_id in (select t1.rw_id from sw_hc_xm_rw_rel t1 left join sw_hc_xm t2 on t1.hcxm_id=t2.id left join sw_dj_xmxx t3 on t3.xm_id=t1.bd_id where t2.xmlx='"+Hcxmlx.GDHC.toString()+"' and t3.xzqdm like '%"+xzqdm+"%'))";
        Query delActivityQuery = baseRepository.getEntityManager().createNativeQuery(delActivitySql);
        delActivityQuery.executeUpdate();
        //5,删除pf_workflow_instance
        String delWorkflowInstanceSql = "delete from pf_workflow_instance t where t.workflow_instance_id in(select t1.rw_id from sw_hc_xm_rw_rel t1 left join sw_hc_xm t2 on t1.hcxm_id=t2.id left join sw_dj_xmxx t3 on t3.xm_id=t1.bd_id where t2.xmlx='"+Hcxmlx.GDHC.toString()+"' and t3.xzqdm like '%"+xzqdm+"%')";
        Query delWorkflowInstanceQuery = baseRepository.getEntityManager().createNativeQuery(delWorkflowInstanceSql);
        delWorkflowInstanceQuery.executeUpdate();
        //6,删除sw_hc_xm_rw_rel
        String delSwHcXmRwRelSql = "delete from  sw_hc_xm_rw_rel t where t.shxr_id in " +
                "(select t1.shxr_id from sw_hc_xm_rw_rel t1 left join sw_hc_xm t2 on t1.hcxm_id=t2.id left join sw_dj_xmxx t3 on t3.xm_id=t1.bd_id where t2.xmlx='"+Hcxmlx.GDHC.toString()+"' and t3.xzqdm like '%"+xzqdm+"%')";
        Query delSwHcXmRwRelQuery = baseRepository.getEntityManager().createNativeQuery(delSwHcXmRwRelSql);
        delSwHcXmRwRelQuery.executeUpdate();
    }

    @Override
    @Transactional(value="oracle_common")
    public void autoCreateWorkflow(String xzqdm)throws Exception{

        //1,首先删除任务
        delWorkflow(xzqdm);

        //2,自动创建下发
        SwDjQsQuery swDjQsQuery = new SwDjQsQuery();
        swDjQsQuery.setXmXzqdm(xzqdm);
        List<SwDjXmxx> swDjXmxxList = getGdxmListByQuery(swDjQsQuery);
        //创建任务
        if(CollectionUtils.isNotEmpty(swDjXmxxList)){
            //获取市局用户id
            String loginName = AppConfig.getProperty(CREATE_USER_NAME);
            if(StringUtils.isBlank(loginName)){
                //默认自动创建的用户名是市局
                loginName = "070037";
            }
            //根据用户名获取用户
            PfUserVo userVo = sysUserService.getUserByloginName(loginName);

            if(userVo!=null){
                /**
                 *自动创建工作流
                 */
                String userId = userVo.getUserId();
                SwHcXm swHcXm = new SwHcXm();
                swHcXm.setMc("供地核查项目"+ Calendar.getInstance().getTime());
                swHcXm.setXmId(UUIDGenerator.generate());
                swHcXm.setCjrq(Calendar.getInstance().getTime());
                swHcXm.setCjrId(SessionUtil.getCurrentUserId());
                swHcXm.setXmlx(Hcxmlx.GDHC.toString());
                swHcXm.setXmybj("0");
                baseRepository.save(swHcXm);

                //创建核查任务的工作流项目
                for(SwDjXmxx swDjXmxx:swDjXmxxList){
                    Project project = new Project();
                    String wiid = UUIDGenerator.generate();
                    project.setProjectId(wiid);
                    String wwid = AppConfig.getProperty("gdhc");
                    project.setWdid(wwid);
                    try {
                        platUtil.createWorkFlowInstance(project, userId,swDjXmxx.getXmmc());
                    }catch (Exception e){
                        throw  new Exception();
                    }
                    SwHcXmRwRel swHcXmRwRel = new SwHcXmRwRel();
                    swHcXmRwRel.setShxrId(UUIDGenerator.generate());
                    swHcXmRwRel.setRwId(wiid);
                    swHcXmRwRel.setSwHcXm(swHcXm);
                    swHcXmRwRel.setBdId(swDjXmxx.getXmId());
                    swHcXmRwRel.setBlzt("0");
                    baseRepository.save(swHcXmRwRel);

                    //自动转发到区县
                    PerformerTaskModel result=zdhcService.getTurnUserList(userId, wiid);
                    List<PfUserVo> toUserList = result.getUserList();
                    String toUserId = "";
                    if(CollectionUtils.isNotEmpty(toUserList)){
                        for(PfUserVo pfUserVo : toUserList){
                            String regionCode = sysUserService.getRegionCodeByUserId(pfUserVo.getUserId());
                            if(regionCode.length()>6){
                                regionCode = regionCode.substring(0,6);
                            }

                            if(xzqdm.equals(regionCode)){
                                toUserId = pfUserVo.getUserId();
                                break;
                            }
                        }
                    }

                    if(StringUtils.isNotBlank(toUserId)){
                        //任务自动转发
                        String taskid = PlatUtil.getTaskIdByProid(wiid);
                        String turnXml = zdhcService.initTurnTaskXml(wiid, toUserId, taskid);
                        Document doc = DocumentHelper.parseText(turnXml);
                        workFlowService.turnTask(doc,taskid);
                    }
                }

            }else{
                throw new RuntimeException("没有根据用户名"+loginName+"查出对应用户");
            }

        }
    }

    private void applyQueryPredicates(SwDjQsQuery swDjQsQuery, QSwDjXmxx qSwDjXmxx, JPQLQuery jpaQuery) {
        if(StringUtils.isNotBlank(swDjQsQuery.getXmmc()))
            jpaQuery.where(qSwDjXmxx.xmmc.like(QueryCondition.WILDCARDS+swDjQsQuery.getXmmc()+QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(swDjQsQuery.getXmXzqdm()))
            jpaQuery.where(qSwDjXmxx.xmXzqdm.eq(swDjQsQuery.getXmXzqdm()));
        if(StringUtils.isNotBlank(swDjQsQuery.getQdfs()))
            jpaQuery.where(qSwDjXmxx.qdfs.eq(swDjQsQuery.getQdfs()));
        if(StringUtils.isNotBlank(swDjQsQuery.getXmTdyt()))
            jpaQuery.where(qSwDjXmxx.xmTdyt.eq(swDjQsQuery.getXmTdyt()));
        if(StringUtils.isNotBlank(swDjQsQuery.getXmYddw()))
            jpaQuery.where(qSwDjXmxx.xmYddw.like(QueryCondition.WILDCARDS+swDjQsQuery.getXmYddw()+QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(swDjQsQuery.getXmTdzl()))
            jpaQuery.where(qSwDjXmxx.xmTdzl.like(QueryCondition.WILDCARDS+swDjQsQuery.getXmTdzl()+QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(swDjQsQuery.getExcelBegin()) && StringUtils.isNotBlank(swDjQsQuery.getExcelEnd())){
            Integer offset = Integer.parseInt(swDjQsQuery.getExcelBegin())-1;
            Integer limit = Integer.parseInt(swDjQsQuery.getExcelEnd())-offset;
            jpaQuery.offset(offset).limit(limit);
        }
    }

    private String addWhclbWhere(SwDjQsQuery swDjQsQuery,String sql,Boolean isOrderBY){
        String where = "";
        String regionCode = SessionUtil.getCurrentUser().getRegionCode();
        if(StringUtils.isNotBlank(regionCode)){
            if(regionCode.length() >6)
                regionCode = regionCode.substring(0,6);
        }else{
            regionCode = "";
        }


        if(StringUtils.isNotBlank(swDjQsQuery.getXmmc()))
            where = where + "and t1.xmmc like '%"+swDjQsQuery.getXmmc()+"%' ";
        if(StringUtils.isNotBlank(swDjQsQuery.getXmXzqdm()))
            where = where + "and t1.xzqdm = '"+swDjQsQuery.getXmXzqdm()+"' ";
        if(StringUtils.isNotBlank(swDjQsQuery.getQdfs()))
            where = where + "and t1.qdfs = '"+swDjQsQuery.getQdfs()+"' ";
        if(StringUtils.isNotBlank(swDjQsQuery.getXmTdyt()))
            where = where + "and t1.tdyt = '"+swDjQsQuery.getXmTdyt()+"' ";
        if(StringUtils.isNotBlank(swDjQsQuery.getXmYddw()))
            where = where + "and t1.yddw like '%"+swDjQsQuery.getXmYddw()+"%' ";
        if(StringUtils.isNotBlank(swDjQsQuery.getXmTdzl()))
            where = where + "and t1.tdzl like '%"+swDjQsQuery.getXmTdzl()+"%' ";
        if(StringUtils.isNotBlank(regionCode)){
            where = where + "and t1.xzqdm like '"+regionCode+"%' ";
        }
        sql = sql + where;
        if(isOrderBY){
            //sql = sql + "order by t1.xm_id desc ";
        }
        return sql;
    }

    private String getYbjSql(SwDjQsQuery swDjQsQuery,List activityList,String regionCode) {
        String sql = "select count(*) from sw_dj_xmxx t1 " +
                     "left join sw_hc_xm_rw_rel t2 on t1.xm_id=t2.bd_id "+
                     "left join sw_hc_xm t3 on t3.id=t2.hcxm_id "+
                     "where t3.xmlx='"+Hcxmlx.GDHC.toString()+"' and t2.blzt='1' ";
        sql = addWhclbWhere(swDjQsQuery, sql,false);
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        List list = query.getResultList();
        if(CollectionUtils.isNotEmpty(list))
            return String.valueOf(list.get(0));
        return null;
    }

    private String getQrrkSql(SwDjQsQuery swDjQsQuery,List activityList,String regionCode) {
        String sql = "select count(distinct(t1.xm_id)) from sw_dj_xmxx t1  " +
                "left join sw_hc_xm_rw_rel t2 on t1.xm_id=t2.bd_id " +
                "left join sw_hc_xm t3 on t3.id=t2.hcxm_id " +
                "left join (select * from pf_activity t where t.activity_state='1')t4 on t4.workflow_instance_id=t2.rw_id " +
                "where t3.xmlx='"+Hcxmlx.GDHC.toString()+"' and t4.activity_definition_id='"+String.valueOf(((HashMap)activityList.get(4)).get("activityDefinitionId"))+"' ";
        sql = addWhclbWhere(swDjQsQuery, sql,false);
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        List list = query.getResultList();
        if(CollectionUtils.isNotEmpty(list))
            return String.valueOf(list.get(0));
        return null;
    }

    private String getSwryxfSql(SwDjQsQuery swDjQsQuery,List activityList,String regionCode) {
        String sql = "select count(distinct(t1.xm_id)) from sw_dj_xmxx t1  " +
                "left join sw_hc_xm_rw_rel t2 on t1.xm_id=t2.bd_id " +
                "left join sw_hc_xm t3 on t3.id=t2.hcxm_id " +
                "left join (select * from pf_activity t where t.activity_state='1')t4 on t4.workflow_instance_id=t2.rw_id " +
                "where t3.xmlx='"+Hcxmlx.GDHC.toString()+"' and t4.activity_definition_id='"+String.valueOf(((HashMap)activityList.get(3)).get("activityDefinitionId"))+"' ";
        sql = addWhclbWhere(swDjQsQuery, sql,false);
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        List list = query.getResultList();
        if(CollectionUtils.isNotEmpty(list))
            return String.valueOf(list.get(0));
        return null;
    }

    private String getHczzxfSql(SwDjQsQuery swDjQsQuery,List activityList,String regionCode) {
        String sql = "select count(distinct(t1.xm_id)) from sw_dj_xmxx t1   " +
                "left join sw_hc_xm_rw_rel t2 on t1.xm_id=t2.bd_id " +
                "left join sw_hc_xm t3 on t3.id=t2.hcxm_id " +
                "left join (select * from pf_activity t where t.activity_state='1')t4 on t4.workflow_instance_id=t2.rw_id " +
                "where t3.xmlx='"+Hcxmlx.GDHC.toString()+"' and t4.activity_definition_id='"+String.valueOf(((HashMap)activityList.get(2)).get("activityDefinitionId"))+"' ";
        sql = addWhclbWhere(swDjQsQuery, sql,false);
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        List list = query.getResultList();
        if(CollectionUtils.isNotEmpty(list))
            return String.valueOf(list.get(0));
        return null;
    }

    private String getQxxfSql(SwDjQsQuery swDjQsQuery,List activityList,String regionCode) {
        String sql = "select count(distinct(t1.xm_id)) from sw_dj_xmxx t1  " +
                "left join sw_hc_xm_rw_rel t2 on t1.xm_id=t2.bd_id " +
                "left join sw_hc_xm t3 on t3.id=t2.hcxm_id " +
                "left join (select * from pf_activity t where t.activity_state='1')t4 on t4.workflow_instance_id=t2.rw_id " +
                "where t3.xmlx='"+Hcxmlx.GDHC.toString()+"' and t4.activity_definition_id='"+String.valueOf(((HashMap)activityList.get(1)).get("activityDefinitionId"))+"' ";
        sql = addWhclbWhere(swDjQsQuery, sql,false);
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        List list = query.getResultList();
        if(CollectionUtils.isNotEmpty(list))
            return String.valueOf(list.get(0));
        return null;
    }

    private String getSjxfSql(SwDjQsQuery swDjQsQuery,List activityList,String regionCode) {
        String sql = "select count(distinct(t1.xm_id)) from sw_dj_xmxx t1  " +
                "left join sw_hc_xm_rw_rel t2 on t1.xm_id=t2.bd_id " +
                "left join sw_hc_xm t3 on t3.id=t2.hcxm_id " +
                "left join (select * from pf_activity t where t.activity_state='1')t4 on t4.workflow_instance_id=t2.rw_id " +
                "where t3.xmlx='"+Hcxmlx.GDHC.toString()+"' and t4.activity_definition_id='"+String.valueOf(((HashMap)activityList.get(0)).get("activityDefinitionId"))+"' ";
        sql = addWhclbWhere(swDjQsQuery, sql,false);
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        List list = query.getResultList();
        if(CollectionUtils.isNotEmpty(list))
            return String.valueOf(list.get(0));
        return null;
    }

    private String getWxfSql(SwDjQsQuery swDjQsQuery,List activityList,String regionCode) {
        String sql = "select count(*) from sw_dj_xmxx t1 where t1.xm_id not in "+
                     "(" +
                         "select t1.bd_id from sw_hc_xm_rw_rel t1 " +
                         "left join sw_hc_xm t2 on t1.hcxm_id=t2.id " +
                         "where t2.xmlx='"+Hcxmlx.GDHC.toString()+"' " +
                     ")";
        sql = addWhclbWhere(swDjQsQuery, sql,false);
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        List list = query.getResultList();
        if(CollectionUtils.isNotEmpty(list))
            return String.valueOf(list.get(0));
        return null;
    }

}
