package cn.gtmap.landtax.service.impl;

import cn.gtmap.landtax.entity.*;
import cn.gtmap.landtax.model.dictionary.*;
import cn.gtmap.landtax.model.query.SbZsQuery;
import cn.gtmap.landtax.model.query.SwDjSyQuery;
import cn.gtmap.landtax.model.query.ZdQuery;
import cn.gtmap.landtax.quartz.TbSbSjQuartz;
import cn.gtmap.landtax.quartz.TbSbSjQuartzFactory;
import cn.gtmap.landtax.service.*;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.CommonUtil;
import cn.gtmap.landtax.util.WorkFlowXmlUtil;
import com.gtis.config.AppConfig;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;
import com.mysema.query.jpa.JPQLQuery;
import com.mysema.query.jpa.impl.JPAQuery;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.Query;
import java.math.BigDecimal;
import java.util.*;


/**
 * Created by Administrator on 2014/9/2.
 */
@Service
public class YdqcServiceImpl implements YdqcService{
    @Autowired
    BaseRepository baseRepository;
    @Autowired
    SwdjSyTempService swdjSyTempService;
    @Autowired
    HcxmService hcxmService;
    @Autowired
    TaxService taxService;
    @Autowired
    ZdService zdService;
    @Autowired
    HashMap hcjdConfigMap;

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public Page findZdList(ZdQuery zdQuery, Pageable pageable) {

        String sql = "select to_char(t4.djh)djh,to_char(t4.qlrmc)qlrmc,to_char(t4.tdzl)tdzl,to_char(t4.tdytmc)tdytmc,t4.scmj as scmj,t3.td_scmj_sum as djzmj ,(nvl(t4.scmj,0)-nvl(t3.td_scmj_sum,0)) as min from (";
            sql += "select t1.djh, sum(nvl(t2.scmj,0)) as td_scmj_sum  from sw_dj_sy t1 left join sw_dj_td t2 on t2.sy_id=t1.sy_id   where t2.sgzt_dm='01' and (t1.syzt='1' or t1.syzt is null) group by t1.djh ) t3 left join zd t4 on t3.djh=t4.djh LEFT JOIN S_DM_DWXX_CZ t5 ON T4.xzqdm LIKE (T5.DWDM||'%') where t3.td_scMj_sum<t4.scmj and t4.djh not in(select djh from ydqc_rel where djh is not null ) AND T5.DWJB=2 ";
        sql = addParameter(zdQuery,sql);
        sql += " order by min desc";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        String countSql = "select count(*) from (select t1.djh, sum(nvl(t2.scmj,0)) as td_scmj_sum from sw_dj_sy t1 left join sw_dj_td t2 on t2.sy_id=t1.sy_id   where t2.sgzt_dm='01' and (t1.syzt='1' or t1.syzt is null) group by t1.djh ) t3 left join zd t4 on t3.djh=t4.djh   LEFT JOIN S_DM_DWXX_CZ t5 ON T4.xzqdm LIKE (T5.DWDM||'%') where t3.td_scMj_sum<t4.scmj and t4.djh not in(select djh from ydqc_rel where djh is not null ) AND T5.DWJB=2";
        countSql = addParameter(zdQuery,countSql);
        Query countQuery = baseRepository.getEntityManager().createNativeQuery(countSql);
        Page page =  baseRepository.find(query, countQuery, pageable);
        return page;
    }

    @Override
    public List<SwDjSyTemp> findSytzByProid(String proid) {
        String jpql = "from SwDjSyTemp o  where o.rwid=?0";
        return baseRepository.getByJpql(jpql,proid);
    }

    @Override
    @Transactional(value="oracle_common")
    /**
     * 1，把sytemp表数据写入sy主表
     * 2，swHcXmRwRel表设置blzt=1
     * 3，修改hcxm状态（看该项目所有任务是否都已办结，如果都已经办结了，修改状态xmybj=1）
     * 4，表ydqcRel修改blzt=1
     */
    public void zdYdqcWfEnd(String proid) throws  Exception{
        SwHcXmRwRel swHcXmRwRel =  hcxmService.getSwHcXmRwRelByRwid(proid);
        String djh = swHcXmRwRel.getBdId();
        //1，把sytemp表数据写入sy主表
        String jpql = "from SwDjSyTemp o where o.rwid=?0";
        List<SwDjSyTemp> swDjSyTempList = baseRepository.getByJpql(jpql,proid);
        for(SwDjSyTemp swDjSyTemp : swDjSyTempList){
            SwDjSyQuery swDjSyQuery = new SwDjSyQuery();
            BeanUtils.copyProperties(swDjSyTemp, swDjSyQuery);
            taxService.saveSwDjSyQuery(swDjSyQuery, Syzt.ZC.toString());
        }
        //2，swHcXmRwRel表设置blzt=1
        swHcXmRwRel.setBlzt("1");
        baseRepository.update(swHcXmRwRel);
        //3，修改hcxm状态（看该项目所有任务是否都已办结，如果都已经办结了，修改状态xmybj=1）
        SwHcXm swHcXm = swHcXmRwRel.getSwHcXm();
        String xmId = swHcXm.getXmId();
        String jpql2 = "from SwHcXmRwRel o where o.swHcXm.xmId=?0 and o.blzt='0'";
        List<SwHcXmRwRel> swHcXmRwRelList2 = baseRepository.getByJpql(jpql2,xmId);
        if(CollectionUtils.isEmpty(swHcXmRwRelList2)){//说明该项目下的所有任务都已经办理完成
            swHcXm.setXmybj("1");
            baseRepository.update(swHcXm);
        }
        //4，表ydqcRel修改blzt=1
        String jpql3 = "update YdqcRel o set o.blzt='1' where o.djh=?0";
        baseRepository.executeJpql(jpql3,djh);

    }

    @Override
    @Transactional(value="oracle_common")
    /**
     * 1，sytemp表删除该任务所有税源信息
     * 2，syhis表删除该任务所有税源信息
     * 3，swHcXmRwRel表删除该任务
     * 4，修改hcxm状态（1，没有任务，删除项目。2，有任务，并且任务都办结，hcxm修改状态xmybj=1。）
     * 5,删除表ydqcRel,根据djh删除
     */
    public void zdYdqcWfDel(String proid) {
        SwHcXmRwRel swHcXmRwRel =  hcxmService.getSwHcXmRwRelByRwid(proid);
        String djh = swHcXmRwRel.getBdId();
        //1，sytemp表删除该任务所有税源信息
        String jpql = "delete from SwDjSyTemp o where o.rwid=?0";
        baseRepository.executeJpql(jpql,proid);
        //2，syhis表删除该任务所有税源信息
        jpql = "delete from SwDjSyHis o where o.rwid=?0";
        baseRepository.executeJpql(jpql,proid);
        //3,swHcXmRwRel表删除该任务
        baseRepository.delete(swHcXmRwRel);
        //4，修改hcxm状态（1，没有任务，删除项目。2，有任务，并且任务都办结，hcxm修改状态xmybj=1。）
        SwHcXm swHcXm = swHcXmRwRel.getSwHcXm();
        String xmId = swHcXm.getXmId();
        jpql = "from SwHcXmRwRel t where t.swHcXm.xmId=?0";

        List<SwHcXmRwRel> swHcXmRwRelList =  baseRepository.getByJpql(jpql,xmId);
        if(CollectionUtils.isEmpty(swHcXmRwRelList)){//删除项目
            baseRepository.delete(swHcXm);
        }else{
            String jpql2 = "from SwHcXmRwRel o where o.swHcXm.xmId=?0 and o.blzt='0'";
            List<SwHcXmRwRel> swHcXmRwRelList2 = baseRepository.getByJpql(jpql2,xmId);
            if(CollectionUtils.isEmpty(swHcXmRwRelList2)){//说明该项目下的所有任务都已经办理完成
                swHcXm.setXmybj("1");
                baseRepository.update(swHcXm);
            }
        }
        //5,删除表ydqcRel,根据djh删除
        jpql = "delete from YdqcRel o where o.djh=?0";
        baseRepository.executeJpql(jpql,djh);
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public List<Object> getZdydqcTzList(HashMap param) {
        Object obj = param.get("ids");
        ZdQuery zdQuery = (ZdQuery) param.get("zdQuery");

        String sql = "select to_char(t4.djh)djh,to_char(t4.qlrmc)qlrmc,to_char(t4.tdzl)tdzl,to_char(t4.tdytmc)tdytmc,t4.scmj as scmj,t3.td_scmj_sum as djzmj ,(nvl(t4.scmj,0)-nvl(t3.td_scmj_sum,0)) as min from (select t1.djh, sum(nvl(t2.scmj,0)) as td_scmj_sum  from sw_dj_sy t1 left join sw_dj_td t2 on t2.sy_id=t1.sy_id   where t2.sgzt_dm='01' and (t1.syzt='1' or t1.syzt is null) group by t1.djh ) t3 left join zd t4 on t3.djh=t4.djh LEFT JOIN S_DM_DWXX_CZ t5 ON T4.xzqdm LIKE (T5.DWDM||'%') where t3.td_scMj_sum<t4.scmj and t4.djh not in(select djh from ydqc_rel where djh is not null ) AND T5.DWJB=2 ";
        if(obj==null) {//导出全部
            sql = addParameter(zdQuery,sql);
        }else{//checkbox导出
            String resultIds = "";
            String ids = String.valueOf(obj);
            String[] idsArr = ids.split(",");
            for(int i=0;i<idsArr.length;i++){
                if(i==idsArr.length-1){
                    resultIds = resultIds+"'"+idsArr[i]+"'";
                }else{
                    resultIds = resultIds+"'"+idsArr[i]+"'"+",";
                }
            }
            sql = sql + " and t4.djh in("+resultIds+")";
        }
        sql += " order by min desc";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        List<Object> list =  query.getResultList();
        return list;
    }

    private StringBuffer addParameter(SbZsQuery sbZsQuery,StringBuffer sql){
/*        String USER_ID = SessionUtil.getCurrentUser().getId();
        if(StringUtils.isNotBlank(USER_ID)){
            sql.append("and USER_ID ='"+USER_ID+"' ");
        }*/

        if(StringUtils.isNotBlank(sbZsQuery.getGlbm())){
            sql.append("and glbm like '%").append(sbZsQuery.getGlbm()).append("%' ");
        }
        if(StringUtils.isNotBlank(sbZsQuery.getNsrsbh())){
            sql.append("and nsrsbh like '%").append(sbZsQuery.getNsrsbh()).append("%' ");
        }
        if(StringUtils.isNotBlank(sbZsQuery.getNsrmc())){
            sql.append("and nsrmc like '%").append(sbZsQuery.getNsrmc()).append("%' ");
        }
        if(StringUtils.isNotBlank(sbZsQuery.getZclx())){
            if (sbZsQuery.getZclx().equals(SbZsQuery.ZCLX_QY)) {
                sql.append("and zclx_dm not IN ('710', '720') ");
            } else if (sbZsQuery.getZclx().equals(SbZsQuery.ZCLX_GR)) {
                sql.append("and zclx_dm IN ('710', '720') ");
            }
        }
        if(StringUtils.isNotBlank(sbZsQuery.getQxdm())){
            sql.append("and qxdm = '").append(sbZsQuery.getQxdm()).append("' ");
        }
        if(StringUtils.isNotBlank(sbZsQuery.getZgkgDm())){
            sql.append("and zgkg_dm = '").append(sbZsQuery.getZgkgDm()).append("' ");
        }
        return sql;
    }

    private StringBuffer getSbListSql(String szdm, SbZsQuery sbZsQuery){
        String ssnf = sbZsQuery.getYear();
        String sssq = sbZsQuery.getSssq();
        StringBuffer sqlBuffer = null;
        String sql = "";
        String table = "";
        int sqEnd = 4;

        if(szdm.equals(Szdm.CZTDSYS.toString())){
            table = "s_sj_sbydqc_td";
            sqEnd = 4;
        }else if(szdm.equals(Szdm.FCS.toString())){
            table = "s_sj_sbydqc_fc";
            sqEnd = 2;
        }

        if(StringUtils.isBlank(ssnf) || StringUtils.isBlank(sssq)){
            int sq, sqYear;
            sqYear = Calendar.getInstance().get(Calendar.YEAR);
            sq = Integer.parseInt(CommonUtil.getSssqByNow(szdm));
            if (sq == 1) {
                sq = sqEnd;
                sqYear = sqYear - 1;
            } else {
                sq = sq - 1;
            }

            ssnf = String.valueOf(sqYear);
            sssq = String.valueOf(sq);
        }

        sql =   "select t1.*, t2.activity_name, t2.activity_state " +
                "from ( " +
                "       select t1.*, t2.zgkg_mc, t2.zgkg_dm " +
                "       from " + table + " t1 left join sw_dj_jbb t2 on t1.jbb_id=t2.jbb_id " +
                "       where t1.ssnf='" + ssnf + "' and t1.sssq='" + sssq + "' and ydtype='" + Ydtype.HCH.toString()+ "' " +
                "   )t1 left join (" +
                "       select * " +
                "       from ( " +
                "           select t.*,rank() over(partition by workflow_instance_id order by finish_time desc ) xh " +
                "           from pf_activity t) " +
                "       where xh ='1' " +
                "   ) t2 on t1.rwid=t2.workflow_instance_id " +
                "where 1=1 ";

        sqlBuffer = new StringBuffer().append(sql);
        sqlBuffer = addParameter(sbZsQuery,sqlBuffer);
        return sqlBuffer;
    }

    @Override
    @Transactional(value="oracle_common")
    public void saveOrUpdateTdSbXgsqb(TdSbXgsqb tdSbXgsqb) throws  Exception{
        String proid = tdSbXgsqb.getProid();
        TdSbXgsqb old = baseRepository.get(TdSbXgsqb.class,proid);
        if(old!=null){//update
            old.setBz(tdSbXgsqb.getBz());
            old.setXgyy(tdSbXgsqb.getXgyy());
            old.setXgrq(new Date());
            old.setHsqk(tdSbXgsqb.getHsqk());
            baseRepository.update(old);
        }else{//save
            tdSbXgsqb.setXgrq(new Date());
            baseRepository.save(tdSbXgsqb);
        }
    }




    private String addParameter(ZdQuery zdQuery,String sql){
        if(StringUtils.isNotBlank(zdQuery.getDjh())){
            sql = sql + " and t4.djh like '"+zdQuery.getDjh().trim()+"%'";
        }
        if(StringUtils.isNotBlank(zdQuery.getQlrmc())){
            sql = sql + " and t4.qlrmc like '%"+zdQuery.getQlrmc()+"%'";
        }
        if(StringUtils.isNotBlank(zdQuery.getTdzlzd())){
            sql = sql + " and t4.tdzl like '%"+zdQuery.getTdzlzd()+"%'";
        }
        if(StringUtils.isNotBlank(zdQuery.getQx())){
            sql = sql + " and t5.zgswj_dm like '2"+zdQuery.getQx()+"%'";
        }
        if(StringUtils.isNotBlank(zdQuery.getTdyt())){
            sql = sql + " and t4.tdyt = '"+zdQuery.getTdyt()+"'";
        }
        if(StringUtils.isNotBlank(zdQuery.getIsqlrmc())){
            if(zdQuery.getIsqlrmc().equals("0")){
            sql = sql + " and ltrim(t4.qlrmc) is not null ";
            }else {
            sql = sql + " and ltrim(t4.qlrmc) is null ";
            }
        }
        if((StringUtils.isNotBlank(zdQuery.getMjceMin()))&&(StringUtils.isNotBlank(zdQuery.getMjceMax()))){
            sql = sql + " and (nvl(t4.scmj, 0) - nvl(t3.td_scmj_sum, 0))  between "+zdQuery.getMjceMin()+" and "+zdQuery.getMjceMax();
        }
        if((StringUtils.isBlank(zdQuery.getMjceMin()))&&(StringUtils.isNotBlank(zdQuery.getMjceMax()))){
            sql = sql + " and (nvl(t4.scmj, 0) - nvl(t3.td_scmj_sum, 0))  between  0 and "+zdQuery.getMjceMax();
        }
        if((StringUtils.isNotBlank(zdQuery.getMjceMin()))&&(StringUtils.isBlank(zdQuery.getMjceMax()))){
            sql = sql + " and (nvl(t4.scmj, 0) - nvl(t3.td_scmj_sum, 0))  > "+zdQuery.getMjceMin();
        }
        return sql;
    }

    private StringBuffer sbAddParameter(SwDjSyQuery swDjSyQuery,StringBuffer sql){
        if(StringUtils.isNotBlank(swDjSyQuery.getGlbm())){
            sql = sql.append(" and t3.glbm like '%"+swDjSyQuery.getGlbm().trim()+"%' ");
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getNsrsbh())){
            sql = sql.append(" and t3.nsrsbh like '%"+swDjSyQuery.getNsrsbh().trim()+"%' ");
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getNsrmc())){
            sql = sql.append(" and t5.nsrmc like '%"+swDjSyQuery.getNsrmc()+"%' ");
        }
        return sql;
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public List<HashMap<String, Object>> sumNynseByGlbm(String szdm, String nsrsbh) {
        StringBuffer sql = new StringBuffer()
                .append("select sum(nvl(t1.nynse,0))as nynse,nsrsbh ");
        if(szdm.equals(Szdm.CZTDSYS.toString())){
            sql.append("from sw_dj_td t1 ");
        }else if(szdm.equals(Szdm.FCS.toString())){
            sql.append("from sw_dj_fc t1 ");
        }
            sql.append("left join sw_dj_jbb t2 on t1.jbb_id=t2.jbb_id  ")
                .append("group by t2.nsrsbh ")
                .append("having nsrsbh= '").append(nsrsbh).append("' ");
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        return list;
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public Object getZtById(String id,String hcxmlx) {

        StringBuffer sql = new StringBuffer()
                .append("select t1.*,t2.activity_state,t2.activity_name from ");
                if(hcxmlx.equals(Hcxmlx.TDSBJSYDQC.toString())){
                    sql.append("(select t1.* from s_sj_sbydqc_td t1 where t1.tdsbyd_id = '").append(id).append("')t1 ");
                }else if(hcxmlx.equals(Hcxmlx.FCSBJSYDQC.toString())){
                    sql.append("(select t1.* from S_SJ_SBYDQC_FC t1 where t1.fcsbyd_id = '").append(id).append("')t1 ");
                }else if(hcxmlx.equals(Hcxmlx.TDZSYDQC.toString())){
                    sql.append("(select t1.* from S_SJ_ZSYDQC_TD t1 where t1.tdzsyd_id = '").append(id).append("')t1 ");
                }else if(hcxmlx.equals(Hcxmlx.FCZSYDQC.toString())){
                    sql.append("(select t1.* from S_SJ_ZSYDQC_FC t1 where t1.fczsyd_id = '").append(id).append("')t1 ");
                }
                sql.append("left join ")
                .append("(select * from (select t.*,rank() over(partition by workflow_instance_id order by finish_time desc ) xh from pf_activity t )where xh='1')t2 ")
                .append("on t1.rwid=t2.workflow_instance_id ");
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        ResponseMessage responseMessage = new ResponseMessage();
        if(CollectionUtils.isNotEmpty(list)){
            HashMap<String,Object> tempMap = list.get(0);
            String activityName = String.valueOf(tempMap.get("ACTIVITY_NAME"));
            String activity_state = String.valueOf(tempMap.get("ACTIVITY_STATE"));
            if(StringUtils.isBlank(activityName) || "null".equalsIgnoreCase(activityName)){
                responseMessage.setMsg("待下发");
            }else if("1".equals(activity_state)){
                responseMessage.setMsg(activityName);
            }else{
                responseMessage.setMsg("任务已办结");
            }
        }
        return responseMessage;
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public BigDecimal getTotalTdNynseByProid(String proid) {
        String sql = "select sum(nvl(t.nynse_td,0))nynse_td from sw_dj_sy_temp t where t.rwid='"+proid+"' ";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List list = query.getResultList();
        if(CollectionUtils.isNotEmpty(list) && ((HashMap)list.get(0)).get("NYNSE_TD")!=null){
            return new BigDecimal(String.valueOf(((HashMap)list.get(0)).get("NYNSE_TD")));
        }
        return null;

    }

    @Override
    @Transactional(value="oracle_common",readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public BigDecimal getTotalFcNynseByProid(String proid) {
        String sql = "select sum(nvl(t.nynse_fc,0))nynse_fc from sw_dj_sy_temp t where t.rwid='"+proid+"' ";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List list = query.getResultList();
        if(CollectionUtils.isNotEmpty(list)){
            return new BigDecimal(String.valueOf(((HashMap)list.get(0)).get("NYNSE_FC")));
        }
        return null;

    }

    @Override
    public BigDecimal getRkseByProid(String proid, String szdm, String ssnf, String sssq) {
        String sql = "";
        if (szdm.equals(Szdm.CZTDSYS.toString())) {
            sql = "SELECT NVL(SUM(b.NSE), 0) AS RKSE " +
                    "FROM LOCAL_SB_RKSS b " +
                    "WHERE TO_CHAR(b.FSRQ, 'YYYY')='" + ssnf + "' AND ((TO_NUMBER(TO_CHAR(b.FSRQ, 'MM')) - 1) / 3 + 1) <= (MOD((TO_NUMBER(" + sssq + ") - 1), 4) + 1) " +
                    "      AND ((TO_NUMBER(TO_CHAR(b.FSRQ, 'MM')) - 1) / 3 + 1) >= (TRUNC((TO_NUMBER(" + sssq + ") - 1) / 4, 0) + 1) AND b.SZDM='13' " +
                    "      AND b.NSRSBH IN (SELECT NSRSBH FROM S_SJ_ZSYDQC_TD WHERE RWID='" + proid + "')";
        } else {
            sql = "SELECT NVL(SUM(b.NSE), 0) AS RKSE " +
                    "FROM LOCAL_SB_RKSS b " +
                    "WHERE TO_CHAR(b.FSRQ, 'YYYY')='" + ssnf + "' AND ((TO_NUMBER(TO_CHAR(b.FSRQ, 'MM')) - 1) / 6 + 1) <= (MOD((TO_NUMBER(" + sssq + ") - 1), 2) + 1) " +
                    "      AND ((TO_NUMBER(TO_CHAR(b.FSRQ, 'MM')) - 1) / 6 + 1) >= (TRUNC((TO_NUMBER(" + sssq + ") - 1) / 2, 0) + 1) AND b.SZDM='11' " +
                    "      AND b.NSRSBH IN (SELECT NSRSBH FROM S_SJ_ZSYDQC_TD WHERE RWID='" + proid + "')";
        }
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List list = query.getResultList();
        if(CollectionUtils.isNotEmpty(list)){
            return new BigDecimal(String.valueOf(((HashMap)list.get(0)).get("RKSE")));
        }
        return null;
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public List<Zd> findZdListTz(ZdQuery zdQuery) {
        String sql = "select to_char(t4.djh)djh from (";
        sql += "select t1.djh, sum(nvl(t2.scmj,0)) as td_scmj_sum from sw_dj_sy t1 left join sw_dj_td t2 on t2.sy_id=t1.sy_id  where t2.sgzt_dm='01' and (t1.syzt='1' or t1.syzt is null) group by t1.djh ) t3 left join zd t4 on t3.djh=t4.djh  where t3.td_scMj_sum<t4.scmj and t4.djh not in(select djh from ydqc_rel where djh is not null ) ";
        sql = addParameter(zdQuery,sql);
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        List djhsList = query.getResultList();
        String[] djhsArr = (String[]) djhsList.toArray(new String[0]);
        return zdService.getZdsByDjhs(djhsArr);
    }


    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public List<SSjZsydqcTd> getTdZsByIds(List<String> hcxmBdIds) {
        String[] ydids = list2StringArr(hcxmBdIds);
        QSSjZsydqcTd qsSjZsydqcTd = QSSjZsydqcTd.sSjZsydqcTd;
        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        jpaQuery.from(qsSjZsydqcTd).where(qsSjZsydqcTd.tdzsydId.in(ydids));
        return (List)baseRepository.dslList(jpaQuery,qsSjZsydqcTd);
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public List<SSjZsydqcFc> getFcZsByIds(List<String> hcxmBdIds) {
        String[] ydids =  list2StringArr(hcxmBdIds);
        QSSjZsydqcFc qsSjZsydqcFc = QSSjZsydqcFc.sSjZsydqcFc;
        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        jpaQuery.from(qsSjZsydqcFc).where(qsSjZsydqcFc.fczsydId.in(ydids));
        return (List)baseRepository.dslList(jpaQuery,qsSjZsydqcFc);
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public List<String> getzsYearList(String szdm) {
        String  sql = "";
        if(szdm.equals(Szdm.CZTDSYS.toString())){
            sql  = "select distinct ssnf from s_sj_zsydqc_td order by ssnf desc";
        }else if(szdm.equals(Szdm.FCS.toString())) {
            sql = "select distinct ssnf from s_sj_zsydqc_fc order by ssnf desc";
        }
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        return query.getResultList();
    }

    @Override
    @Transactional(value="oracle_common")
    public Object findZsListJson(SbZsQuery sbZsQuery, String szdm, Pageable pageable,String sidx,String sord) {
        // 检查当前属期是否已经生成疑点数据，若没有，则生成
        checkAndCreateZdydData(sbZsQuery.getYear(), sbZsQuery.getSssq(), szdm);

        StringBuffer sql = getZsListSql(szdm, sbZsQuery);
        //sql.append("order by cyje desc");
        if(sidx.equals("NSRSBH")){
            sql.append("order by NSRSBH  "+sord);
        }
        if(sidx.equals("NSRMC")){
            sql.append("order by NSRMC  "+sord);
        }
        if(sidx.equals("ZGKG_MC")){
            sql.append("order by ZGKG_MC  "+sord);
        }
        if(sidx.equals("YJSE")){
            sql.append("order by YJSE  "+sord);
        }
        if(sidx.equals("RKSE")){
            sql.append("order by RKSE  "+sord);
        }
        if(sidx.equals("CYJE")){
            sql.append("order by CYJE  "+sord);
        }
        if(sidx.equals("CYBL")){
            sql.append("order by CYBL  "+sord);
        }
        if(sidx.equals("END_YJSE")){
            sql.append("order by END_YJSE  "+sord);
        }
        if(sidx.equals("END_CYBL")){
            sql.append("order by END_CYBL  "+sord);
        }
        if(sidx.equals("STATUENAME")){
            sql.append("order by STATUE  "+sord);
        }


        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        StringBuffer countSql = new StringBuffer("select count(*) from (").append(sql).append(")");
        Query countQuery = baseRepository.getEntityManager().createNativeQuery(countSql.toString());
        Page page =  baseRepository.find(query, countQuery, pageable);
        String workflowDefinId=null;
        if(StringUtils.isNotBlank(szdm)&&szdm=="13"){
            workflowDefinId = AppConfig.getProperty("tdzsydqc");
        }else {
            workflowDefinId = AppConfig.getProperty("fczsydqc");
        }
        //key: 节点定义ID， value：节点名称
        Map<String, String> activityMap = WorkFlowXmlUtil.getActivityMap(workflowDefinId);

        List list = page.getContent();
        for(Object obj : list){
            Map<String, Object> map = (Map<String, Object>)obj;
            String STATUE = (String)map.get("STATUE");
            String STATUENAME = activityMap.get(STATUE);
            map.put("STATUENAME", STATUENAME);
        }
        return page;
    }

    @Override
    @Transactional(value="oracle_common")
    public void zsYdqcWfEnd(String proid, String szdm) throws  Exception{
        SwHcXmRwRel swHcXmRwRel =  hcxmService.getSwHcXmRwRelByRwid(proid);
        //1，把sytemp表数据写入sy主表
        String jpql = "from SwDjSyTemp o where o.rwid=?0";
        List<SwDjSyTemp> swDjSyTempList = baseRepository.getByJpql(jpql,proid);
        for(SwDjSyTemp swDjSyTemp : swDjSyTempList){
            SwDjSyQuery swDjSyQuery = new SwDjSyQuery();
            BeanUtils.copyProperties(swDjSyTemp, swDjSyQuery);
            taxService.saveSwDjSyQuery(swDjSyQuery, Syzt.ZC.toString());
        }
        //2，swHcXmRwRel表设置blzt=1
        swHcXmRwRel.setBlzt("1");
        baseRepository.update(swHcXmRwRel);
        //3，修改hcxm状态（看该项目所有任务是否都已办结，如果都已经办结了，修改状态xmybj=1）
        SwHcXm swHcXm = swHcXmRwRel.getSwHcXm();
        String xmId = swHcXm.getXmId();
        String jpql2 = "from SwHcXmRwRel o where o.swHcXm.xmId=?0 and o.blzt='0'";
        List<SwHcXmRwRel> swHcXmRwRelList2 = baseRepository.getByJpql(jpql2,xmId);
        if(CollectionUtils.isEmpty(swHcXmRwRelList2)){//说明该项目下的所有任务都已经办理完成
            swHcXm.setXmybj("1");
            baseRepository.update(swHcXm);
        }

        String ydqcId = swHcXmRwRel.getBdId();
        if(szdm.equals(Szdm.CZTDSYS.toString())){
            //更新SSjZsydqcTd
            SSjZsydqcTd sSjZsydqcTd = baseRepository.get(SSjZsydqcTd.class,ydqcId);
            String nsrsbh = sSjZsydqcTd.getNsrsbh();
            String sq = sSjZsydqcTd.getSssq();
            List<HashMap<String,Object>> list = sumNynseByGlbm(szdm,nsrsbh);
            if(CollectionUtils.isNotEmpty(list)){
                HashMap<String,Object> map = list.get(0);
                BigDecimal endYjse = map.get("NYNSE")==null? BigDecimal.ZERO:new BigDecimal(String.valueOf(map.get("NYNSE")));
                endYjse = endYjse.divide(new BigDecimal(4)).multiply(new BigDecimal(sq));
                sSjZsydqcTd.setEndYjse(endYjse);
                //EndSbse,EndCybl在办结后 定时任务中修改信息
                baseRepository.update(sSjZsydqcTd);
            }
        }else if (szdm.equals(Szdm.FCS.toString())){
            //更新SSjZsydqcFc
            SSjZsydqcFc sSjZsydqcFc = baseRepository.get(SSjZsydqcFc.class,ydqcId);
            String nsrsbh = sSjZsydqcFc.getNsrsbh();
            String sq = sSjZsydqcFc.getSssq();
            List<HashMap<String,Object>> list = sumNynseByGlbm(szdm,nsrsbh);
            if(CollectionUtils.isNotEmpty(list)){
                HashMap<String,Object> map = list.get(0);
                BigDecimal endYjse = map.get("NYNSE")==null? BigDecimal.ZERO:new BigDecimal(String.valueOf(map.get("NYNSE")));
                endYjse = endYjse.divide(new BigDecimal(2)).multiply(new BigDecimal(sq));
                sSjZsydqcFc.setEndYjse(endYjse);
                //EndSbse,EndCybl在办结后 定时任务中修改信息
                baseRepository.update(sSjZsydqcFc);
            }
        }
    }

    @Override
    @Transactional(value="oracle_common")
    public void zsYdqcWfDel(String proid, String szdm) {
        SwHcXmRwRel swHcXmRwRel =  hcxmService.getSwHcXmRwRelByRwid(proid);

        //1，sytemp表删除该任务所有税源信息
        String jpql = "delete from SwDjSyTemp o where o.rwid=?0";
        baseRepository.executeJpql(jpql,proid);
        //2，syhis表删除该任务所有税源信息
        jpql = "delete from SwDjSyHis o where o.rwid=?0";
        baseRepository.executeJpql(jpql,proid);

        if (swHcXmRwRel != null) {
            //3,swHcXmRwRel表删除该任务
            baseRepository.delete(swHcXmRwRel);
            //4，修改hcxm状态（1，没有任务，删除项目。2，有任务，并且任务都办结，hcxm修改状态xmybj=1。）
            SwHcXm swHcXm = swHcXmRwRel.getSwHcXm();
            String xmId = swHcXm.getXmId();
            jpql = "from SwHcXmRwRel t where t.swHcXm.xmId=?0";
            List<SwHcXmRwRel> swHcXmRwRelList = baseRepository.getByJpql(jpql, xmId);
            if (CollectionUtils.isEmpty(swHcXmRwRelList)) {//删除项目
                baseRepository.delete(swHcXm);
            } else {
                String jpql2 = "from SwHcXmRwRel o where o.swHcXm.xmId=?0 and o.blzt='0'";
                List<SwHcXmRwRel> swHcXmRwRelList2 = baseRepository.getByJpql(jpql2, xmId);
                if (CollectionUtils.isEmpty(swHcXmRwRelList2)) {//说明该项目下的所有任务都已经办理完成
                    swHcXm.setXmybj("1");
                    baseRepository.update(swHcXm);
                }
            }

            String ydqcId = swHcXmRwRel.getBdId();
            if (szdm.equals(Szdm.CZTDSYS.toString())) {
                SSjZsydqcTd sSjZsydqcTd = baseRepository.get(SSjZsydqcTd.class, ydqcId);
                sSjZsydqcTd.setRwid("");
                sSjZsydqcTd.setHsqk("");
                baseRepository.update(sSjZsydqcTd);
            } else if (szdm.equals(Szdm.FCS.toString())) {
                SSjZsydqcFc sSjZsydqcFc = baseRepository.get(SSjZsydqcFc.class, ydqcId);
                sSjZsydqcFc.setRwid("");
                sSjZsydqcFc.setHsqk("");
                baseRepository.update(sSjZsydqcFc);
            }
        }

        //6删除TdSbXgsqb
        baseRepository.delete(TdSbXgsqb.class,proid);
    }

    @Override
    public StringBuffer getZsListSql(String szdm,SbZsQuery sbZsQuery){
        int tdsqs = new Integer(AppConfig.getProperty("tdsqs"));
        int fcsqs = new Integer(AppConfig.getProperty("fcsqs"));
        String ssnf = sbZsQuery.getYear();
        String sssq = sbZsQuery.getSssq();
        StringBuffer sqlBuffer = null;
        String sql = "";
        String table = "";
        int sqEnd = 4;
        String xmlx = "";

        if(szdm.equals(Szdm.CZTDSYS.toString())){
            table = "s_sj_zsydqc_td";
            sqEnd = tdsqs;
            xmlx = Hcxmlx.TDZSYDQC.toString();
        }else if(szdm.equals(Szdm.FCS.toString())){
            table = "s_sj_zsydqc_fc";
            sqEnd = fcsqs;
            xmlx = Hcxmlx.FCZSYDQC.toString();
        }

        if(StringUtils.isBlank(ssnf) || StringUtils.isBlank(sssq)){
            int sq, sqYear;
            sqYear = Calendar.getInstance().get(Calendar.YEAR);
            sq = Integer.parseInt(CommonUtil.getSssqByNow(szdm));
            if (sq == 1) {
                sq = sqEnd;
                sqYear = sqYear - 1;
            } else {
                sq = sq - 1;
            }

            ssnf = String.valueOf(sqYear);
            sssq = String.valueOf(sq);
        }

        sql = "SELECT distinct t1.*,  " +
                "       DECODE(t2.BLZT, '1', 'ybj', NVL(t4.ACTIVITY_DEFINITION_ID, 'wxf')) AS STATUE " +
                "FROM ( " +
                "         SELECT t1.*, t2.ZGKG_MC, t2.ZGKG_DM, t2.ZCLX_DM " +
                "         FROM " + table + " t1 LEFT JOIN SW_DJ_JBB t2 ON t1.JBB_ID=t2.JBB_ID " +
                "         WHERE t1.SSNF='" + ssnf + "' AND t1.SSSQ='" + sssq + "' AND YDTYPE='" + Ydtype.HCH.toString()+ "' " +
                "     ) t1 " +
                "     LEFT JOIN (SELECT * FROM SW_HC_XM_RW_REL WHERE HCXM_ID IN (SELECT ID FROM SW_HC_XM WHERE XMLX = '" + xmlx + "')) t2 on t1.RWID = t2.RW_ID " +
                "     LEFT JOIN ( " +
                "         SELECT t4.WORKFLOW_INSTANCE_ID, t4.ACTIVITY_DEFINITION_ID, t6.USER_NAME, t4.ACTIVITY_NAME, t6.USER_ID " +
                "         FROM ( " +
                "             SELECT * " +
                "             FROM PF_ACTIVITY t " +
                "             WHERE t.ACTIVITY_STATE='1' " +
                "             ) t4 " +
                "             LEFT JOIN PF_ASSIGNMENT t5 ON t5.ACTIVITY_ID=t4.ACTIVITY_ID " +
                "             LEFT JOIN PF_USER t6 ON t5.USER_ID=t6.USER_ID " +
                "     ) t4 ON t4.WORKFLOW_INSTANCE_ID=t2.RW_ID " +
                "WHERE 1=1 ";

        String statue = sbZsQuery.getJdlx();
        if(StringUtils.isNotBlank(statue)) {
            if (statue.equals("ybj")) {
                sql = sql + " and t2.BLZT = '1' ";
            } else if (statue.equals("wxf")) {
                sql = sql + " and NVL(t2.BLZT, '0')='0' and t4.ACTIVITY_DEFINITION_ID IS NULL ";
            } else{
                sql = sql + " and NVL(t2.BLZT, '0')='0' and t4.ACTIVITY_DEFINITION_ID = '"+statue+"' ";
            }
        }

        sqlBuffer = new StringBuffer().append(sql);
        sqlBuffer = addParameter(sbZsQuery,sqlBuffer);
        return sqlBuffer;
    }

    private String[] list2StringArr(List<String> hcxmBdIds){
        if(CollectionUtils.isNotEmpty(hcxmBdIds)){
            String[] result = new String[hcxmBdIds.size()];
            for(int i=0;i<hcxmBdIds.size();i++){
                result[i] = hcxmBdIds.get(i);
            }
            return result;
        }
        return null;
    }

    // 检查当前属期是否已经生成疑点数据，若没有，则生成
    @Transactional(value="oracle_common")
    private void checkAndCreateZdydData(String ssnf, String sssq, String szdm) {
        int tdsqs = new Integer(AppConfig.getProperty("tdsqs"));
        int fcsqs = new Integer(AppConfig.getProperty("fcsqs"));
        String table = "";
        if(szdm.equals(Szdm.CZTDSYS.toString())){
            table = "s_sj_zsydqc_td";
        }else if(szdm.equals(Szdm.FCS.toString())){
            table = "s_sj_zsydqc_fc";
        }
        String sqlLocal="select * from LOCAL_SB_RKSS";
        Query query1 = baseRepository.getEntityManager().createNativeQuery(sqlLocal.toString());
        query1.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        if (CollectionUtils.isEmpty(query1.getResultList())) {
            String sql = "";
            sql =   "INSERT INTO LOCAL_SB_RKSS (SB_NUM, GLBM, NSRSBH, FSRQ, NSE, SZDM, TAXTERMBEGIN, TAXTERMEND) " +
                    "SELECT t1.SPUUID AS SB_NUM, NULL, t2.NSRSBH, t1.RKRQ AS FSRQ, t1.SJJE AS NSE, DECODE(t1.ZSXM_DM,'10112','13','11')SZDM, t1.SKSSQQ AS TAXTERMBEGIN, t1.SKSSQZ AS TAXTERMEND " +
                    "FROM ZS_JKS t1 " +
                    "INNER JOIN DJ_NSRXX t2 ON t1.DJXH=t2.DJXH " +
                    "LEFT JOIN LOCAL_SB_RKSS t3 ON t1.SPUUID=t3.SB_NUM " +
                    "WHERE t3.SB_NUM IS NULL  AND t1.SJJE > 0 AND t1.RKRQ IS NOT NULL ";
            Query query = baseRepository.getEntityManager().createNativeQuery(sql);
            query.executeUpdate();
        }
        String sql = "SELECT * FROM " + table + " t1 WHERE t1.SSNF='" + ssnf + "' AND t1.SSSQ='" + sssq + "' AND YDTYPE='" + Ydtype.HCH.toString() + "' ";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        if (CollectionUtils.isEmpty(query.getResultList())) {
            // 创建疑点数据
            TbSbSjQuartzFactory factory = new TbSbSjQuartzFactory();
            TbSbSjQuartz tbSbSjQuartz = factory.createInstance();
            if(szdm.equals(Szdm.CZTDSYS.toString())) {
                  sql = tbSbSjQuartz.getTdZsYdqcSql(Integer.valueOf(ssnf), (Integer.valueOf(sssq) - 1) / tdsqs + 1, (Integer.valueOf(sssq) - 1) % tdsqs + 1, Ydtype.HCH.toString());
            } else if(szdm.equals(Szdm.FCS.toString())) {
                  sql = tbSbSjQuartz.getFcZsYdqcSql(Integer.valueOf(ssnf), (Integer.valueOf(sssq) - 1) / fcsqs + 1, (Integer.valueOf(sssq) - 1) % fcsqs + 1, Ydtype.HCH.toString());
            }
            query = baseRepository.getEntityManager().createNativeQuery(sql);
            query.executeUpdate();
        }
    }
    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public String getZdydTzListJson() {
        String hcxmlx = "";
        String[] configArr = (String[]) hcjdConfigMap.get(hcxmlx);

        String dwSql = "SELECT DWDM, DWMC, DWJB, PDM, ROWNUM AS XH " +
                "FROM ( " +
                "        SELECT REGION_CODE AS DWDM, ORGAN_NAME as DWMC, ORGAN_NO AS XH, " +
                "               DECODE(LENGTH(REGION_CODE), 4, '', SUBSTR(REGION_CODE, 1, LENGTH(REGION_CODE)-2)) AS PDM, " +
                "               DECODE(LENGTH(REGION_CODE), 4, 0, 6, 1) AS DWJB " +
                "        FROM PF_ORGAN " +
                "        WHERE REMARK ='tj' AND LENGTH(REGION_CODE) IN (4, 6) " +
                "     ) t " +
                "START WITH DWJB=0 " +
                "CONNECT BY (PDM=PRIOR DWDM AND DWJB - 1 = PRIOR DWJB) " +
                "ORDER SIBLINGS BY t.XH";
        String rwSql = "SELECT DECODE(GROUPING(QXDM), 0, QXDM, SJDM) AS DWDM " +
                "       , SUM(ZS) AS ZS, SUM(YXF) AS YXF, SUM(WXF) AS WXF " +
                "FROM ( " +
                "      SELECT t3.DJH, SUBSTR(t5.zgswj_dm, 2, 6) AS QXDM, SUBSTR(t3.DJH, 1, 4) AS SJDM, " +
                "             1 AS ZS, 0 AS YXF, 1 AS WXF " +
                "      FROM ( " +
                "            SELECT t1.DJH, SUM(NVL(t2.SCMJ,0)) AS TD_SCMJ_SUM " +
                "            FROM SW_DJ_SY t1 " +
                "                 LEFT JOIN SW_DJ_TD t2 ON t2.SY_ID=t1.SY_ID " +
                "            WHERE t2.SGZT_DM='01' AND (t1.SYZT='1' OR t1.SYZT IS NULL) " +
                "            GROUP BY t1.DJH " +
                "           ) t3 " +
                "           LEFT JOIN ZD t4 ON t3.DJH=t4.DJH " +
                "           LEFT JOIN S_DM_DWXX_CZ t5 ON T4.XZQDM LIKE (trim(T5.DWDM)||'%')"+
                "      WHERE t3.TD_SCMJ_SUM<t4.SCMJ " +
                "            AND t4.DJH IS NOT NULL " +
                "            AND t4.DJH NOT IN ( " +
                "                      SELECT DJH " +
                "                      FROM YDQC_REL " +
                "                      WHERE DJH IS NOT NULL " +
                "                  ) " +
                "           AND T5.DWJB=2"+
                "      UNION ALL " +
                "      SELECT t3.DJH, SUBSTR(t5.zgswj_dm, 2, 6) AS QXDM, SUBSTR(t3.DJH, 1, 4) AS SJDM, " +
                "             1 AS ZS, 1 AS YXF, 0 AS WXF " +
                "      FROM ( " +
                "            SELECT t1.DJH, SUM(NVL(t2.SCMJ,0)) AS TD_SCMJ_SUM " +
                "            FROM SW_DJ_SY t1 " +
                "                 LEFT JOIN SW_DJ_TD t2 ON t2.SY_ID=t1.SY_ID " +
                "            GROUP BY t1.DJH " +
                "           ) t3 " +
                "           LEFT JOIN ZD t4 ON t3.DJH=t4.DJH " +
                "           LEFT JOIN S_DM_DWXX_CZ t5 ON T4.XZQDM LIKE (trim(T5.DWDM)||'%')"+
                "      WHERE t4.DJH IS NOT NULL " +
                "            AND t4.DJH IN ( " +
                "                      SELECT DJH " +
                "                      FROM YDQC_REL " +
                "                      WHERE DJH IS NOT NULL " +
                "                  ) " +
                "           AND T5.DWJB=2"+
                "     ) " +
                "GROUP BY ROLLUP(SJDM, QXDM)";
        String sql = "SELECT t1.DWDM, t1.DWMC, t1.DWJB, NVL(t2.YXF,0) AS YXF, NVL(t2.WXF,0) AS WXF, NVL(t2.ZS,0) AS ZS, DECODE(NVL(t2.ZS,0), 0, 0, ROUND(NVL(t2.YXF,0)/NVL(t2.ZS,0)*100,3)) AS XFL " +
                "FROM (" + dwSql + ") t1 " +
                "     LEFT JOIN (" + rwSql + ") t2 ON t2.DWDM = t1.DWDM " +
                "ORDER BY t1.XH";

        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        return zdydTzListToJson(list);
    }

    private String zdydTzListToJson(List list) {
        StringBuffer listToJson = new StringBuffer();
        int firstDwjb = -1;
        int lastDwjb = -1;
        int curDwjb = -1;
        Boolean bFirst = true;
        for(int i=0; i<list.size(); i++){
            HashMap map = (HashMap)list.get(i);

            curDwjb = Integer.valueOf(String.valueOf(map.get("DWJB")));
            if (bFirst) {   // 开始
                bFirst = false;
                firstDwjb = curDwjb;
                lastDwjb = curDwjb;
                listToJson.append("[{");
            } else {
                if (firstDwjb == -1) {  // 记录第一个级别
                    firstDwjb = curDwjb;
                    listToJson.append("[{");
                }

                if (curDwjb < lastDwjb) { // 上一个单位级别结束
                    while (lastDwjb > curDwjb) {
                        listToJson.append("}]");
                        lastDwjb--;
                    }
                    listToJson.append(",");
                    listToJson.append("},{");
                } else if (curDwjb == lastDwjb) { // 继续当前单位级别
                    listToJson.append("},{");
                } else if (curDwjb > lastDwjb) { // 进入下一单位级别
                    listToJson.append(",");
                    listToJson.append("\"children\":[{");
                    lastDwjb = curDwjb;
                }
            }

            listToJson.append("\"name\":"+"\""+map.get("DWMC")+"\",");
            listToJson.append("\"zs\":"+"\""+map.get("ZS")+"\",");
            listToJson.append("\"yxf\":"+"\""+map.get("YXF")+"\",");
            listToJson.append("\"wxf\":"+"\""+map.get("WXF")+"\",");
            listToJson.append("\"xfl\":"+"\""+map.get("XFL")+"\",");
            listToJson.append("\"xzqdm\":"+"\""+map.get("DWDM")+"\"");
        }
        while (curDwjb >= firstDwjb) { //结束
            listToJson.append("}]");
            curDwjb--;
        }
        return listToJson.toString();
    }
    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public Page findZdYxfList(ZdQuery zdQuery, Pageable pageable) {

        String sql = "select to_char(t4.djh)djh, to_char(t4.qlrmc)qlrmc,to_char(t4.tdzl)tdzl,to_char(t4.tdytmc)tdytmc,t4.scmj as scmj,t3.td_scmj_sum as djzmj,(nvl(t4.scmj,0)-nvl(t3.td_scmj_sum,0)) as min from (";
        sql += "select t1.djh, sum(nvl(t2.scmj,0)) as td_scmj_sum  from sw_dj_sy t1 left join sw_dj_td t2 on t2.sy_id=t1.sy_id   where t1.djh is not null group by t1.djh ) t3 left join zd t4 on t3.djh=t4.djh  LEFT JOIN S_DM_DWXX_CZ t5 ON T3.DJH LIKE (T5.DWDM||'%') where t4.djh in(select djh from ydqc_rel where djh is not null ) AND T5.DWJB=2";
        sql = addParameter(zdQuery,sql);
        sql += " order by min desc";

        // 查询已下发任务的proid
        sql = "select t.*, t1.RW_ID AS PROID from (" + sql + ") t left join (SELECT BD_ID, RW_ID FROM SW_HC_XM_RW_REL WHERE HCXM_ID IN (SELECT ID FROM SW_HC_XM WHERE XMLX='" + Hcxmlx.SYZDYDQC.toString() + "')) t1 on t.djh=t1.BD_ID ";

        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        String countSql = "select count(*) from (select t1.djh, sum(nvl(t2.scmj,0)) as td_scmj_sum  from sw_dj_sy t1 left join sw_dj_td t2 on t2.sy_id=t1.sy_id   where t1.djh is not null group by t1.djh ) t3 left join zd t4 on t3.djh=t4.djh LEFT JOIN S_DM_DWXX_CZ t5 ON T3.DJH LIKE (T5.DWDM||'%') where t4.djh in(select djh from ydqc_rel where djh is not null ) AND T5.DWJB=2";
        countSql = addParameter(zdQuery,countSql);
        Query countQuery = baseRepository.getEntityManager().createNativeQuery(countSql);
        Page page =  baseRepository.find(query, countQuery, pageable);
        return page;
    }
    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public List<Object> getZdYxfTzList(HashMap param) {
        Object obj = param.get("ids");
        ZdQuery zdQuery = (ZdQuery) param.get("zdQuery");

        String sql = "select to_char(t4.djh),  to_char(t3.nsrmc) nsrmc, t3.nsrsbh,to_char(t4.qlrmc),to_char(t4.tdzl),to_char(t4.tdytmc),t4.scmj as scmj,t3.td_scmj_sum as djzmj,t3.ynmj as ynmj,t3.msmj as msmj ,(nvl(t4.scmj,0)-nvl(t3.td_scmj_sum,0)) as min  from (";
        sql += "select t1.djh, sum(nvl(t2.scmj,0)) as td_scmj_sum ,t2.ynmj as ynmj,t2.msmj as msmj  ,t5.nsrmc as nsrmc, t5.nsrsbh as nsrsbh from sw_dj_sy t1 left join sw_dj_td t2 on t2.sy_id=t1.sy_id  left join sw_dj_jbb t5 on t2.jbb_id =t5.jbb_id where t1.djh is not null group by t1.djh ,t2.ynmj ,t2.msmj ,t5.nsrmc,t5.nsrsbh) t3 left join zd t4 on t3.djh=t4.djh LEFT JOIN S_DM_DWXX_CZ t5 ON T3.DJH LIKE (T5.DWDM||'%') where t4.djh in(select djh from ydqc_rel  where " +
                "  djh is not null ) AND T5.DWJB=2 ";

        if(obj==null) {//导出全部
            sql = addParameter(zdQuery,sql);
        }else{//checkbox导出
            String resultIds = "";
            String ids = String.valueOf(obj);
            String[] idsArr = ids.split(",");
            for(int i=0;i<idsArr.length;i++){
                if(i==idsArr.length-1){
                    resultIds = resultIds+"'"+idsArr[i]+"'";
                }else{
                    resultIds = resultIds+"'"+idsArr[i]+"'"+",";
                }
            }
            sql = sql + " and t4.djh in("+resultIds+")";
        }
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        List<Object> list =  query.getResultList();
        return list;
    }
    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public String getTddjydTzListJson() {
        String hcxmlx = "";
        String[] configArr = (String[]) hcjdConfigMap.get(hcxmlx);

        String dwSql = "SELECT DWDM, DWMC, DWJB, PDM, ROWNUM AS XH " +
                "FROM ( " +
                "        SELECT REGION_CODE AS DWDM, ORGAN_NAME as DWMC, ORGAN_NO AS XH, " +
                "               DECODE(LENGTH(REGION_CODE), 4, '', SUBSTR(REGION_CODE, 1, LENGTH(REGION_CODE)-2)) AS PDM, " +
                "               DECODE(LENGTH(REGION_CODE), 4, 0, 6, 1) AS DWJB " +
                "        FROM PF_ORGAN " +
                "        WHERE REMARK ='tj' AND LENGTH(REGION_CODE) IN (4, 6) " +
                "     ) t " +
                "START WITH DWJB=0 " +
                "CONNECT BY (PDM=PRIOR DWDM AND DWJB - 1 = PRIOR DWJB) " +
                "ORDER SIBLINGS BY t.XH";
        String rwSql = " SELECT DECODE(GROUPING(QXDM), 0, QXDM, SJDM) AS DWDM  " +
                "                       , SUM(ZS) AS ZS, SUM(YXF) AS YXF, SUM(WXF) AS WXF  " +
                "                FROM (  " +
                "                      SELECT t3.DJH, SUBSTR(t3.ZGKG_DM, 2, 6) AS QXDM, SUBSTR(t3.DJH, 1, 4) AS SJDM,  " +
                "                             1 AS ZS, 0 AS YXF, 1 AS WXF  " +
                "                      FROM (  " +
                "                            SELECT t1.DJH, t2.tddj js_tddj  ,t3.ZGKG_DM" +
                "                            FROM SW_DJ_SY t1  " +
                "                                 LEFT JOIN SW_DJ_TD t2 ON t2.SY_ID=t1.SY_ID  " +
                "                                 LEFT JOIN SW_DJ_JBB t3 ON t2.JBB_ID=t3.JBB_ID" +
                "                            WHERE t2.SGZT_DM='01' AND (t1.SYZT='1' OR t1.SYZT IS NULL) " +
                "                           ) t3  " +
                "                           LEFT JOIN ZD t4 ON t3.DJH=t4.DJH  " +
                "                           " +
                "                      WHERE t3.js_tddj<>t4.tddj  " +
                "                            AND t4.DJH IS NOT NULL  " +
                "                            AND t4.DJH NOT LIKE'%999999%'" +
                "                          " +
                "                      " +
                "                     )  " +
                "                GROUP BY ROLLUP(SJDM, QXDM)";
        String sql = "SELECT t1.DWDM, t1.DWMC, t1.DWJB, NVL(t2.YXF,0) AS YXF, NVL(t2.WXF,0) AS WXF, NVL(t2.ZS,0) AS ZS, DECODE(NVL(t2.ZS,0), 0, 0, ROUND(NVL(t2.YXF,0)/NVL(t2.ZS,0)*100,3)) AS XFL " +
                "FROM (" + dwSql + ") t1 " +
                "     LEFT JOIN (" + rwSql + ") t2 ON t2.DWDM = t1.DWDM " +
                "ORDER BY t1.XH";

        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        return zdydTzListToJson(list);
    }
    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public Page findSyList(SwDjSyQuery swDjSyQuery, Pageable pageable) {

        String sql = "SELECT t3.DJH, t3.nsrsbh,t3.nsrmc,t4.tdzl,t3.zgkg_mc,t4.qlrmc,t3.sytddj sytddj,t5.mc zdtddj" +
                "                      FROM (  " +
                "                            SELECT t1.DJH, t2.tddj js_tddj  ,t4.mc sytddj,t3.ZGKG_DM,t3.ZGKG_MC,t3.nsrsbh,t3.nsrmc" +
                "                            FROM SW_DJ_SY t1  " +
                "                                 LEFT JOIN SW_DJ_TD t2 ON t2.SY_ID=t1.SY_ID  " +
                "                                 LEFT JOIN SW_DJ_JBB t3 ON t2.JBB_ID=t3.JBB_ID" +
                "                                 LEFT JOIN S_ZD_TDJB t4 ON t2.TDDJ=t4.DM" +
                "                            WHERE t2.SGZT_DM='01' AND (t1.SYZT='1' OR t1.SYZT IS NULL) " +
                "                           ) t3  " +
                "                           LEFT JOIN ZD t4 ON t3.DJH=t4.DJH " +
                "                           LEFT JOIN S_ZD_TDJB t5 ON t4.TDDJ=t5.DM " +
                "                      WHERE t3.js_tddj<>t4.tddj  " +
                "                            AND t4.DJH IS NOT NULL  " +
                "                            AND t4.DJH NOT LIKE'%999999%'";

        sql = addParameter(swDjSyQuery,sql);



        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        String countSql = "select count(*) from ("+sql+")";
        Query countQuery = baseRepository.getEntityManager().createNativeQuery(countSql);
        Page page =  baseRepository.find(query, countQuery, pageable);
        return page;
    }
    private String addParameter(SwDjSyQuery swDjSyQuery,String sql){
        if(StringUtils.isNotBlank(swDjSyQuery.getDwdm())){
            sql = sql + " and t3.zgkg_dm like '2"+swDjSyQuery.getDwdm()+"%'";
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getNsrsbh())){
            sql = sql + " and t3.nsrsbh like '%"+swDjSyQuery.getNsrsbh()+"%'";
        }

        return sql;
    }
}
