package cn.gtmap.landtax.service.impl;

import cn.gtmap.landtax.entity.*;
import cn.gtmap.landtax.model.dictionary.Sgzt;
import cn.gtmap.landtax.model.dictionary.Syzt;
import cn.gtmap.landtax.model.dictionary.Szdm;
import cn.gtmap.landtax.model.query.SbZsQuery;
import cn.gtmap.landtax.model.query.SwDjSyQuery;
import cn.gtmap.landtax.service.DwxxService;
import cn.gtmap.landtax.service.TjService;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.GtmapStringUtils;
import cn.gtmap.landtax.util.QueryCondition;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;
import com.mysema.query.jpa.JPQLQuery;
import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.support.Expressions;
import com.mysema.query.types.Projections;
import com.mysema.query.types.QBean;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.Query;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * Created by xuchao on 2014/9/27.
 */
@Service
public class TjServiceImpl implements TjService{
    @Autowired
    BaseRepository baseRepository;
    @Autowired
    DwxxService dwxxService;
    @Autowired
    ArrayList tjBaseParamList;

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public Page<SwDjSyQuery> lzlgTdListJson(SwDjSyQuery swDjSyQuery, Pageable request) {
        QSwDjTd qSwDjTd = QSwDjTd.swDjTd;
        QSwDjJbb qSwDjJbb = QSwDjJbb.swDjJbb;
        QSwDjSy qSwDjSy = QSwDjSy.swDjSy;
        QZd qZd = QZd.zd;
        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        QBean qBean = Projections.bean(SwDjSyQuery.class,qSwDjJbb.glbm,qSwDjJbb.nsrsbh,qSwDjJbb.nsrmc,qZd.djh,qSwDjSy.dbh,qZd.tdzl,qSwDjTd.ynmj,qSwDjTd.msse,qSwDjTd.nynseTd,qSwDjTd.msmj,qSwDjTd.tdId,qSwDjJbb.sgyMc,qSwDjTd.tddj,qSwDjTd.dwse,qSwDjJbb.zgkgMc);
        jpaQuery.from(qSwDjTd).leftJoin(qSwDjTd.swDjSy,qSwDjSy).leftJoin(qSwDjSy.zd,qZd).leftJoin(qSwDjTd.swDjJbb, qSwDjJbb);
        applyLzlgTdPredicates(swDjSyQuery, qZd, qSwDjJbb, qSwDjSy, qSwDjTd, jpaQuery);
        jpaQuery.where(qSwDjSy.syzt.eq(Syzt.ZC.toString()).or(qSwDjSy.syzt.eq("")).or(qSwDjSy.syzt.isNull()));
        jpaQuery.where(qSwDjTd.sgztDm.eq(Sgzt.LZLGD.toString()));

        jpaQuery.where(qSwDjJbb.zgkgDm.like("2" + dwxxService.getUserRegionCode() + QueryCondition.WILDCARDS).or(qSwDjJbb.zgkgDm.isNull()));
        Page<SwDjSyQuery> page = baseRepository.find(jpaQuery,qBean,request);
        return page;
    }



    private void applyLzlgTdPredicates(SwDjSyQuery swDjSyQuery,QZd qZd,QSwDjJbb qSwDjJbb,QSwDjSy qSwDjSy,QSwDjTd qSwDjTd,JPQLQuery jpaQuery){
        if(StringUtils.isNotBlank(swDjSyQuery.getDjh()))
            jpaQuery.where(Expressions.stringPath(qZd, "djh").like(swDjSyQuery.getDjh() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(swDjSyQuery.getDbh()))
            jpaQuery.where(Expressions.stringPath(qSwDjSy, "dbh").like(swDjSyQuery.getDbh() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(swDjSyQuery.getTdzl()))
            jpaQuery.where(Expressions.stringPath(qSwDjTd, "tdzl").like(QueryCondition.WILDCARDS + swDjSyQuery.getTdzl() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(swDjSyQuery.getNsrmc()))
            jpaQuery.where(Expressions.stringPath(qSwDjJbb, "nsrmc").like(QueryCondition.WILDCARDS + swDjSyQuery.getNsrmc() + QueryCondition.WILDCARDS));
    }

    @Override
    @Transactional(value="oracle_common")
    public Object[] lzlgTdHj(SwDjSyQuery swDjSyQuery) {
        String sql = "select sum(nvl(t.ynmj,0)+nvl(t.msmj,0)),sum(nvl(t.ynmj,0)),sum(nvl(t.nynse,0)),sum(nvl(t.msmj,0)),sum(nvl(t.msmj,0)*nvl(t.dwse,0)) " +
                "from sw_dj_td t " +
                "left join sw_dj_sy t2 on t.sy_id=t2.sy_id " +
                "left join sw_dj_jbb t3 on t3.jbb_id=t.jbb_id where (t2.syzt='"+ Syzt.ZC.toString()+"' or t2.syzt is null) and t.sgzt_dm= '"+Sgzt.LZLGD.toString()+"'";

        if(StringUtils.isNotBlank(swDjSyQuery.getDjh()))
            sql += " and t2.djh like '"+swDjSyQuery.getDjh()+"%'";
        if(StringUtils.isNotBlank(swDjSyQuery.getDbh()))
            sql += " and t2.dbh like '"+swDjSyQuery.getDbh()+"%'";
        if(StringUtils.isNotBlank(swDjSyQuery.getTdzl()))
            sql += " and t.tdzl like '%"+swDjSyQuery.getTdzl()+"%'";
        if(StringUtils.isNotBlank(swDjSyQuery.getNsrmc()))
            sql +=" and t3.nsrmc like '%"+swDjSyQuery.getNsrmc()+"%'";

        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        Object[] objArr = (Object[]) query.getSingleResult();
        return objArr;
    }

    @Override
    public Object[] lzlgTdHjByTdIds(String ids) {
        String sql = "select sum(nvl(t.ynmj,0)+nvl(t.msmj,0)),sum(nvl(t.ynmj,0)),sum(nvl(t.nynse,0)),sum(nvl(t.msmj,0)),sum(nvl(t.msmj,0)*nvl(t.dwse,0)) " +
                "from sw_dj_td t " +
                "left join sw_dj_sy t2 on t.sy_id=t2.sy_id " +
                "left join sw_dj_jbb t3 on t3.jbb_id=t.jbb_id where 1=1";
        String resultIds = "";
        if(StringUtils.isNotBlank(ids)){
            String[] idsArr = ids.split(",");
            for(int i=0;i<idsArr.length;i++){
                if(i==ids.split(",").length-1){
                    resultIds = resultIds+"'"+idsArr[i]+"'";
                }else{
                    resultIds = resultIds+"'"+idsArr[i]+"'"+",";
                }
            }
            sql += " and t.td_id in ("+resultIds+")";
        }
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        Object[] objArr = (Object[]) query.getSingleResult();
        return objArr;
    }

    @Override
    public List<SwDjSyQuery> getLzlgTdList(HashMap param) {
        Object obj = param.get("ids");
        SwDjSyQuery swDjSyQuery = (SwDjSyQuery) param.get("swDjSyQuery");
        String regionCode = "";
        try{
            regionCode = SessionUtil.getCurrentUser().getRegionCode();
        }catch (Exception e){}
        QSwDjTd qSwDjTd = QSwDjTd.swDjTd;
        QSwDjJbb qSwDjJbb = QSwDjJbb.swDjJbb;
        QSwDjSy qSwDjSy = QSwDjSy.swDjSy;
        QZd qZd = QZd.zd;
        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        QBean qBean = Projections.bean(SwDjSyQuery.class,qSwDjJbb.glbm,qSwDjJbb.nsrsbh,qSwDjJbb.nsrmc,qZd.djh,qSwDjSy.dbh,qZd.tdzl,qSwDjTd.ynmj,qSwDjTd.nynseTd,qSwDjTd.msmj,qSwDjJbb.sgyMc,qSwDjTd.tddj,qSwDjTd.msse,qSwDjTd.dwse,qSwDjJbb.zgkgMc);
        jpaQuery.from(qSwDjTd).leftJoin(qSwDjTd.swDjSy,qSwDjSy).leftJoin(qSwDjSy.zd,qZd).leftJoin(qSwDjTd.swDjJbb, qSwDjJbb);
        if(StringUtils.isNotBlank(regionCode)){
            jpaQuery.where(qSwDjJbb.zgkgDm.like("2" + regionCode + QueryCondition.WILDCARDS));
        }
        if(obj==null){//导出全部
            applyLzlgTdPredicates(swDjSyQuery,qZd,qSwDjJbb,qSwDjSy,qSwDjTd,jpaQuery);
            jpaQuery.where(qSwDjTd.sgztDm.eq(Sgzt.LZLGD.toString()));
            jpaQuery.where(qSwDjSy.syzt.eq(Syzt.ZC.toString()).or(qSwDjSy.syzt.eq("")).or(qSwDjSy.syzt.isNull()));
            return (List)baseRepository.dslList(jpaQuery,qBean);

        }else{//checkbox导出
            String ids = String.valueOf(obj);
            List idsList = Arrays.asList(ids.split(","));
            jpaQuery.where(Expressions.stringPath(qSwDjTd, "tdId").in(idsList));
            //jpaQuery.where(qSwDjTd.sgztDm.eq(Sgzt.LZLGD.toString()));
            return (List)baseRepository.dslList(jpaQuery,qBean);
        }
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public Object tdExcKzhJson(Pageable request) {
        String sql = getTdExcKzhSql();
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        StringBuffer countSql = new StringBuffer("select count(*) from (").append(sql).append(")");
        Query countQuery = baseRepository.getEntityManager().createNativeQuery(countSql.toString());
        Page page =  baseRepository.find(query, countQuery, request);
        return page;
    }

    @Override
    public List getTdSyhzF(){
        String sql = getTdExcKzhSql();
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List  list = query.getResultList();
        return  list;
    }

    private String getTdExcKzhSql(){
        UserInfo user = SessionUtil.getCurrentUser();
        String regionCode = user.getRegionCode();
        String sjdwdm = regionCode.substring(0, 4);

        String sql = "select t1.hs,t1.zdmj,t1.ysmj,t1.msmj,t1.nynse,t1.msse,case when to_number(to_char(sysdate,'mm'))<10 then round(nvl(t1.nynse,0)*0.5,2) else round(nvl(t1.nynse,0),2) end jzbqynse,'合计'dwmc,(select round(nvl(sum(nvl(t1.nse,0)),0),2) from local_sb_rkss t1 where to_char(t1.fsrq,'yyyy')=to_char(sysdate,'yyyy') and  to_number(to_char(t1.fsrq,'mm'))<=to_number(to_char(sysdate,'mm'))  and t1.szdm='1011200')rkse   " +
                "from ( " +
                "select " +
                "N'" + sjdwdm + "'dwdm,count(*)hs,round(sum(nvl(t1.zdmj,0)),2)zdmj,round(sum(nvl(t1.ynmj,0)),2)ysmj,round(sum(nvl(t1.msmj,0)),2)msmj,round(sum(nvl(t1.nynse,0)),2)nynse,round(sum(nvl(t1.msse,0)),2)msse " +
                "from sw_dj_td t1  " +
                "left join sw_dj_sy t2 on t1.sy_id=t2.sy_id " +
                "where (t2.syzt is null or syzt='1') and t1.sgzt_dm<>'03' and t2.djh like '" + dwxxService.getUserQxDm() + "%' " +
                ")t1 " +
                "union all " +
                "select t.hs,t.zdmj,t.ysmj,t.msmj,t.nynse,t.msse ,case when to_number(to_char(sysdate,'mm'))<10 then round(nvl(t.nynse,0)*0.5,2) else round(nvl(t.nynse,0),2) end jzbqynse ,t3.dwmc, nvl(t2.nse,0) rkse from  " +
                "(select decode(substr(t4.zgkg_dm,1,7),'2610797','2610799',substr(t4.zgkg_dm,1,7))dwdm,count(*)hs,round(sum(nvl(t1.zdmj,0)),2)zdmj,round(sum(nvl(t1.ynmj,0)),2)ysmj,round(sum(nvl(t1.msmj,0)),2)msmj,round(sum(nvl(t1.nynse,0)),2)nynse,round(sum(nvl(t1.msse,0)),2)msse  " +
                "from sw_dj_td t1  " +
                "left join sw_dj_sy t2 on t1.sy_id=t2.sy_id " +
                "left join zd t3 on t2.djh=t3.DJH " +
                "left join sw_dj_jbb t4 on t1.jbb_id = t4.jbb_id " +
                "where (t2.syzt is null or syzt='1') and t1.sgzt_dm<>'03' " +
                "group by decode(substr(t4.zgkg_dm,1,7),'2610797','2610799',substr(t4.zgkg_dm,1,7)))t  " +
                "left join (select decode(substr(t2.zgkg_dm,1,7),'2610797','2610799',substr(t2.zgkg_dm,1,7))dwdm,sum(nvl(t1.nse,0))nse from local_sb_rkss t1 " +
                "left join sw_dj_jbb t2 on t2.nsrsbh = t1.nsrsbh where to_char(t1.fsrq,'yyyy')=to_char(sysdate,'yyyy') and  to_number(to_char(t1.fsrq,'mm'))<=to_number(to_char(sysdate,'mm'))  and t1.szdm='1011200' " +
                "group by decode(substr(t2.zgkg_dm,1,7),'2610797','2610799',substr(t2.zgkg_dm,1,7)))t2 on t.dwdm=t2.dwdm " +
                "left join s_dm_swdwxx t3 on t.dwdm = substr(t3.swdm,1,7) " +
                "where t.dwdm like '2" + dwxxService.getUserQxDm() + "%' and t3.dwjb = '2'";
        return sql;
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public Object tdExcKzhAndLzlgJson(Pageable request) {
        String sql = getTdExcKzhAndLzlgSql();
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        StringBuffer countSql = new StringBuffer("select count(*) from (").append(sql).append(")");
        Query countQuery = baseRepository.getEntityManager().createNativeQuery(countSql.toString());
        Page page =  baseRepository.find(query, countQuery, request);
        return page;
    }

    @Override
    public  List getTdSyhzS(){
        String sql = getTdExcKzhAndLzlgSql();
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List list = query.getResultList();
        return list;
    }

    private String getTdExcKzhAndLzlgSql(){
        UserInfo user = SessionUtil.getCurrentUser();
        String regionCode = user.getRegionCode();
        String sjdwdm = regionCode.substring(0, 4);

        String sql = "select t1.hs,t1.zdmj,t1.ysmj,t1.msmj,t1.nynse,t1.msse,case when to_number(to_char(sysdate,'mm'))<10 then round(nvl(t1.nynse,0)*0.5,2) else round(nvl(t1.nynse,0),2) end jzbqynse,'合计'dwmc,(select round(nvl(sum(nvl(t1.nse,0)),0),2) from local_sb_rkss t1 where to_char(t1.fsrq,'yyyy')=to_char(sysdate,'yyyy') and  to_number(to_char(t1.fsrq,'mm'))<=to_number(to_char(sysdate,'mm'))  and t1.szdm='1011200')rkse   " +
                "from ( " +
                "select " +
                "N'" + sjdwdm + "'dwdm,count(*)hs,round(sum(nvl(t1.scmj,0)),2)zdmj,round(sum(nvl(t1.ynmj,0)),2)ysmj,round(sum(nvl(t1.msmj,0)),2)msmj,round(sum(nvl(t1.nynse,0)),2)nynse,round(sum(nvl(t1.msse,0)),2)msse " +
                "from sw_dj_td t1  " +
                "left join sw_dj_sy t2 on t1.sy_id=t2.sy_id " +
                "where (t2.syzt is null or syzt='1') and t1.sgzt_dm not in ('02','03') and t2.djh like '" + dwxxService.getUserQxDm() + "%' " +
                ")t1 " +
                "union all " +
                "select t.hs,t.zdmj,t.ysmj,t.msmj,t.nynse,t.msse ,case when to_number(to_char(sysdate,'mm'))<10 then round(nvl(t.nynse,0)*0.5,2) else round(nvl(t.nynse,0),2) end jzbqynse ,t3.dwmc, nvl(t2.nse,0) rkse from  " +
                "(select decode(substr(t4.zgkg_dm,1,7),'2610797','2610799',substr(t4.zgkg_dm,1,7))dwdm,count(*)hs,round(sum(nvl(t1.scmj,0)),2)zdmj,round(sum(nvl(t1.ynmj,0)),2)ysmj,round(sum(nvl(t1.msmj,0)),2)msmj,round(sum(nvl(t1.nynse,0)),2)nynse,round(sum(nvl(t1.msse,0)),2)msse  " +
                "from sw_dj_td t1  " +
                "left join sw_dj_sy t2 on t1.sy_id=t2.sy_id " +
                "left join zd t3 on t2.djh=t3.DJH " +
                "left join sw_dj_jbb t4 on t1.jbb_id = t4.jbb_id " +
                "where (t2.syzt is null or syzt='1') and t1.sgzt_dm not in('02','03') " +
                "group by decode(substr(t4.zgkg_dm,1,7),'2610797','2610799',substr(t4.zgkg_dm,1,7)))t  " +
                "left join (select decode(substr(t2.zgkg_dm,1,7),'2610797','2610799',substr(t2.zgkg_dm,1,7))dwdm,sum(nvl(t1.nse,0))nse from local_sb_rkss t1 " +
                "left join sw_dj_jbb t2 on t2.nsrsbh = t1.nsrsbh where to_char(t1.fsrq,'yyyy')=to_char(sysdate,'yyyy') and  to_number(to_char(t1.fsrq,'mm'))<=to_number(to_char(sysdate,'mm'))  and t1.szdm='1011200' " +
                "group by decode(substr(t2.zgkg_dm,1,7),'2610797','2610799',substr(t2.zgkg_dm,1,7)))t2 on t.dwdm=t2.dwdm " +
                "left join s_dm_swdwxx t3 on substr(t.dwdm,2,6) = t3.dwdm " +
                "where t.dwdm like '2" + dwxxService.getUserQxDm() + "%'";
        return sql;
    }


    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public Object fcExcKzhJson(Pageable request) {
        String sql = getFcExcKzhJsonSql();
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        StringBuffer countSql = new StringBuffer("select count(*) from (").append(sql).append(")");
        Query countQuery = baseRepository.getEntityManager().createNativeQuery(countSql.toString());
        Page page =  baseRepository.find(query, countQuery, request);
        return page;
    }

    @Override
    public  List getFcSyhzF(){
        String sql = getFcExcKzhJsonSql();
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List list = query.getResultList();
        return list;
    }
    private String getFcExcKzhJsonSql(){
        UserInfo user = SessionUtil.getCurrentUser();
        String regionCode = user.getRegionCode();
        String sjdwdm = regionCode.substring(0, 4);

        String sql = "select t1.hs,t1.fcyz,t1.fcyz_cz,t1.fcyz_ys,t1.fcyz_ms,t1.nzj,t1.nynse,t1.ynse_zy,t1.ynse_cz,t1.msse,t1.zy_msse,t1.cz_msse,t1.nynse+t1.ynse_cz jzbqynse,'合计'dwmc,(select round(nvl(sum(nvl(t1.nse,0)),0),2) from local_sb_rkss t1 where to_char(t1.fsrq,'yyyy')=to_char(sysdate,'yyyy') and  to_number(to_char(t1.fsrq,'mm'))<=to_number(to_char(sysdate,'mm')) and t1.szdm='1011000')rkse，t1.SL,t1.CZFCYZ  " +
                "from (" +
                "select " +
                "N'" + sjdwdm + "'dwdm,count(*)hs,round(sum(nvl(t1.fcyz,0)),2)fcyz, round(sum(nvl(t1.CZFCYZ,0)),2)fcyz_cz,round(sum(nvl(t1.fcyz_ys,0)),2)fcyz_ys,round(sum(nvl(t1.fcyz_ms,0)),2)fcyz_ms,round(sum(nvl(t1.nzj,0)),2)nzj, round(sum(nvl((t1.fcyz-t1.CZFCYZ-T1.fcyz_ms)*t1.JSBL*t1.SL,0)),2)nynse,round(sum(nvl(t1.ynse_zy,0)),2)ynse_zy,round(sum(nvl(t1.ynse_cz,0)),2)ynse_cz,0 as msse,0 as zy_msse,0 as cz_msse， round(sum(nvl(t1.SL,0)),2)SL,round(sum(nvl(t1.CZFCYZ,0)),2)CZFCYZ " +
                "from sw_dj_fc t1 " +
                "left join sw_dj_sy t2 on t1.sy_id=t2.sy_id " +
                "where (t2.syzt is null or syzt='1') and t1.sgzt_dm<>'03' and t2.djh like '" + dwxxService.getUserQxDm() + "%' " +
                ")t1 " +
                "union all " +
                "select t.hs,t.fcyz,t.fcyz_cz,t.fcyz_ys,t.fcyz_ms,t.nzj,t.nynse,t.ynse_zy,t.ynse_cz,t.msse,t.zy_msse,t.cz_msse,t.nynse+t.ynse_cz jzbqynse ,t3.dwmc, nvl(t2.nse,0) rkse， t.SL,t.CZFCYZ from  " +
                "(select decode(substr(t4.zgkg_dm,1,7),'2610797','2610799',substr(t4.zgkg_dm,1,7))dwdm,count(*)hs,round(sum(nvl(t1.fcyz,0)),2)fcyz, round(sum(nvl(t1.CZFCYZ,0)),2)fcyz_cz,round(sum(nvl(t1.fcyz_ys,0)),2)fcyz_ys,round(sum(nvl(t1.fcyz_ms,0)),2)fcyz_ms,round(sum(nvl(t1.nzj,0)),2)nzj,round(sum(nvl((t1.fcyz-t1.CZFCYZ-T1.fcyz_ms)*t1.JSBL*t1.SL,0)),2)nynse,round(sum(nvl(t1.ynse_zy,0)),2)ynse_zy,round(sum(nvl(t1.ynse_cz,0)),2)ynse_cz,0 as msse,0 as zy_msse,0 as cz_msse，round(sum(nvl(t1.SL,0)),2)SL,round(sum(nvl(t1.CZFCYZ,0)),2)CZFCYZ  " +
                "from sw_dj_fc t1  " +
                "left join sw_dj_sy t2 on t1.sy_id=t2.sy_id " +
                "left join zd t3 on t2.djh=t3.DJH " +
                "left join sw_dj_jbb t4 on t4.jbb_id=t1.jbb_id " +
                "where (t2.syzt is null or syzt='1') and t1.sgzt_dm<>'03' " +
                "group by decode(substr(t4.zgkg_dm,1,7),'2610797','2610799',substr(t4.zgkg_dm,1,7)) )t  " +
                "left join (select decode(substr(t2.zgkg_dm,1,7),'2610797','2610799',substr(t2.zgkg_dm,1,7))dwdm,sum(nvl(t1.nse,0))nse from local_sb_rkss t1 " +
                "left join sw_dj_jbb t2 on t2.nsrsbh=t1.nsrsbh" +
                " where to_char(t1.fsrq,'yyyy')=to_char(sysdate,'yyyy') and  to_number(to_char(t1.fsrq,'mm'))<=to_number(to_char(sysdate,'mm')) and t1.szdm='1011000' " +
                "group by decode(substr(t2.zgkg_dm,1,7),'2610797','2610799',substr(t2.zgkg_dm,1,7)))t2 on t.dwdm=t2.dwdm " +
                "left join s_dm_swdwxx t3 on substr(t.dwdm,2,6) = t3.dwdm " +
                "where t.dwdm like '2" + dwxxService.getUserQxDm() + "%'";
        return sql;
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public Object fcExcKzhAndLzlgJson(Pageable request) {
        String sql = getFcExcKzhAndLzlgSql();
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        StringBuffer countSql = new StringBuffer("select count(*) from (").append(sql).append(")");
        Query countQuery = baseRepository.getEntityManager().createNativeQuery(countSql.toString());
        Page page =  baseRepository.find(query, countQuery, request);
        return page;
    }

    @Override
    public  List getFcSyhzS(){
        String sql = getFcExcKzhAndLzlgSql();
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List list = query.getResultList();
        return list;
    }

    private String getFcExcKzhAndLzlgSql(){
        UserInfo user = SessionUtil.getCurrentUser();
        String regionCode = user.getRegionCode();
        String sjdwdm = regionCode.substring(0, 4);

        String sql = "select t1.hs,t1.fcyz,t1.fcyz_cz,t1.fcyz_ys,t1.fcyz_ms,t1.nzj,t1.nynse,t1.ynse_zy,t1.ynse_cz,t1.msse,t1.zy_msse,t1.cz_msse,t1.nynse+t1.ynse_cz jzbqynse,'合计'dwmc,(select round(nvl(sum(nvl(t1.nse,0)),0),2) from local_sb_rkss t1 where to_char(t1.fsrq,'yyyy')=to_char(sysdate,'yyyy') and  to_number(to_char(t1.fsrq,'mm'))<=to_number(to_char(sysdate,'mm')) and t1.szdm='1011000')rkse，t1.SL,t1.CZFCYZ  " +
                "from (" +
                "select " +
                "N'" + sjdwdm + "'dwdm,count(*)hs,round(sum(nvl(t1.fcyz,0)),2)fcyz, round(sum(nvl(t1.CZFCYZ,0)),2)fcyz_cz,round(sum(nvl(t1.fcyz_ys,0)),2)fcyz_ys,round(sum(nvl(t1.fcyz_ms,0)),2)fcyz_ms,round(sum(nvl(t1.nzj,0)),2)nzj, round(sum(nvl((t1.fcyz-t1.CZFCYZ-T1.fcyz_ms)*t1.JSBL*t1.SL,0)),2)nynse,round(sum(nvl(t1.ynse_zy,0)),2)ynse_zy,round(sum(nvl(t1.ynse_cz,0)),2)ynse_cz,0 as msse,0 as zy_msse,0 as cz_msse， round(sum(nvl(t1.SL,0)),2)SL,round(sum(nvl(t1.CZFCYZ,0)),2)CZFCYZ " +
                "from sw_dj_fc t1 " +
                "left join sw_dj_sy t2 on t1.sy_id=t2.sy_id " +
                "where (t2.syzt is null or syzt='1') and t1.sgzt_dm not in ('02','03') and t2.djh like '" + dwxxService.getUserQxDm() + "%' " +
                ")t1 " +
                "union all " +
                "select t.hs,t.fcyz,t.fcyz_cz,t.fcyz_ys,t.fcyz_ms,t.nzj,t.nynse,t.ynse_zy,t.ynse_cz,t.msse,t.zy_msse,t.cz_msse,t1.nynse+t1.ynse_cz jzbqynse ,t3.dwmc, nvl(t2.nse,0) rkse， t.SL,t.CZFCYZ from  " +
                "(select decode(substr(t4.zgkg_dm,1,7),'2610797','2610799',substr(t4.zgkg_dm,1,7))dwdm,count(*)hs,round(sum(nvl(t1.fcyz,0)),2)fcyz, round(sum(nvl(t1.CZFCYZ,0)),2)fcyz_cz,round(sum(nvl(t1.fcyz_ys,0)),2)fcyz_ys,round(sum(nvl(t1.fcyz_ms,0)),2)fcyz_ms,round(sum(nvl(t1.nzj,0)),2)nzj,round(sum(nvl((t1.fcyz-t1.CZFCYZ-T1.fcyz_ms)*t1.JSBL*t1.SL,0)),2)nynse,round(sum(nvl(t1.ynse_zy,0)),2)ynse_zy,round(sum(nvl(t1.ynse_cz,0)),2)ynse_cz,0 as msse,0 as zy_msse,0 as cz_msse，round(sum(nvl(t1.SL,0)),2)SL,round(sum(nvl(t1.CZFCYZ,0)),2)CZFCYZ  " +
                "from sw_dj_fc t1  " +
                "left join sw_dj_sy t2 on t1.sy_id=t2.sy_id " +
                "left join zd t3 on t2.djh=t3.DJH " +
                "left join sw_dj_jbb t4 on t4.jbb_id=t1.jbb_id " +
                "where (t2.syzt is null or syzt='1') and t1.sgzt_dm not in ('02','03') " +
                "group by decode(substr(t4.zgkg_dm,1,7),'2610797','2610799',substr(t4.zgkg_dm,1,7)) )t  " +
                "left join (select decode(substr(t2.zgkg_dm,1,7),'2610797','2610799',substr(t2.zgkg_dm,1,7))dwdm,sum(nvl(t1.nse,0))nse from local_sb_rkss t1 " +
                "left join sw_dj_jbb t2 on t2.nsrsbh=t1.nsrsbh" +
                " where to_char(t1.fsrq,'yyyy')=to_char(sysdate,'yyyy') and  to_number(to_char(t1.fsrq,'mm'))<=to_number(to_char(sysdate,'mm')) and t1.szdm='1011000' " +
                "group by decode(substr(t2.zgkg_dm,1,7),'2610797','2610799',substr(t2.zgkg_dm,1,7)))t2 on t.dwdm=t2.dwdm " +
                "left join s_dm_swdwxx t3 on substr(t.dwdm,2,6) = t3.dwdm " +
                "where t.dwdm like '2" + dwxxService.getUserQxDm() + "%'";
        return sql;
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public Object dhbTjfxJson(SwDjSyQuery swDjSyQuery,StringBuffer listToJson,String regionCode) {
        if(swDjSyQuery.getSqUpdateDateBegin()==null
                ||swDjSyQuery.getSqUpdateDateEnd()==null
                ||swDjSyQuery.getBqUpdateDateBegin()==null
                ||swDjSyQuery.getBqUpdateDateEnd()==null){
            return null;
        }
        UserInfo user = SessionUtil.getCurrentUser();
        Integer length;
        if(StringUtils.isBlank(regionCode)){
            regionCode = user.getRegionCode();
            length = regionCode.length();
        }else{
            length = regionCode.length( );
            regionCode = StringUtils.removeEnd(regionCode,"##");
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        String sql = "SELECT k.REGION_CODE, k.ORGAN_NAME, k.SQNYNSE, k.BQNYNSE, k.SQSCMJ, k.BQSCMJ, (k.BQNYNSE-k.SQNYNSE)AS ADDNYNSE, (k.BQSCMJ-k.SQSCMJ)AS ADDSCMJ, " +
                    "       DECODE(k.SQNYNSE, 0, '--', ROUND((k.BQNYNSE-k.SQNYNSE)/k.SQNYNSE*100, 2)) AS ZZLNYNSE, " +
                    "       DECODE(k.SQSCMJ, 0, '--', ROUND((k.BQSCMJ-k.SQSCMJ)/k.SQSCMJ*100, 2)) AS ZZLSCMJ " +
                    "FROM ( " +
                    "      SELECT d.REGION_CODE, d.ORGAN_NAME, NVL(t1.SQNYNSE, 0) AS SQNYNSE, NVL(t2.BQNYNSE, 0) AS BQNYNSE, NVL(t1.SQSCMJ, 0) AS SQSCMJ, NVL(t2.BQSCMJ, 0) AS BQSCMJ " +
                    "      FROM (" +
                    "             SELECT t1.REGION_CODE, t1.ORGAN_NAME " +
                    "             FROM ( " +
                    "                    SELECT DWDM AS REGION_CODE, DWMC AS ORGAN_NAME FROM S_DM_DWXX_CZ WHERE DWJB IN (0) " +
                    "                    UNION " +
                    "                    SELECT SUBSTR(SWBMBM, 2, 6), MC FROM DM_SWBM WHERE SUBSTR(SWBMBM, 8, 2)='00' AND SUBSTR(SWBMBM, 6, 2)<='99' AND SUBSTR(SWBMBM, 6, 2)<>'00'  " +
                    "                    UNION " +
                    "                    SELECT SUBSTR(SWBMBM, 2, 8), MC FROM DM_SWBM WHERE SUBSTR(SWBMBM, 8,  4)<>'0000' " +
                    "                  ) t1 " +
                    "             WHERE t1.REGION_CODE LIKE '" + regionCode + "%' AND LENGTH(t1.REGION_CODE)=" + length + " " +
                    "           ) d " +
                    "           LEFT JOIN ( " +
                    "                SELECT DECODE(SUBSTR(t3.ZGKG_DM,2, " + length + "),SUBSTR(26107977000,2, " + length + "),SUBSTR(26107990000,2, " +length + "),SUBSTR(t3.ZGKG_DM,2, " + length + ")) AS DM, SUM(NVL(t1.NYNSE, 0)) AS SQNYNSE, SUM(NVL(t1.SCMJ, 0)) AS SQSCMJ " +
                    "                FROM SW_DJ_TD t1 " +
                    "                     LEFT JOIN SW_DJ_SY t2 ON t1.SY_ID=t2.SY_ID " +
                    "                     LEFT JOIN SW_DJ_JBB t3 ON t1.JBB_ID=t3.JBB_ID " +
                    "                WHERE (t2.SYZT IS NULL OR t2.SYZT=1) AND to_char(t1.update_date,'yyyymmdd')>='" + df.format(swDjSyQuery.getSqUpdateDateBegin()) + "' AND to_char(t1.update_date,'yyyymmdd')<='" + df.format(swDjSyQuery.getSqUpdateDateEnd()) + "' " +
                    "                GROUP BY DECODE(SUBSTR(t3.ZGKG_DM,2, " + length + "),SUBSTR(26107977000,2, " + length + "),SUBSTR(26107990000,2, " + length + "),SUBSTR(t3.ZGKG_DM,2, " + length + ")) " +
                    "           ) t1 ON d.REGION_CODE=t1.DM " +
                    "           LEFT JOIN ( " +
                    "                SELECT DECODE(SUBSTR(t3.ZGKG_DM,2, " + length + "),SUBSTR(26107977000,2, " + length + "),SUBSTR(26107990000,2, " + length + "),SUBSTR(t3.ZGKG_DM,2, " + length + ")) AS DM, SUM(NVL(t1.NYNSE, 0)) AS BQNYNSE, SUM(NVL(t1.SCMJ, 0)) AS BQSCMJ " +
                    "                FROM SW_DJ_TD t1 " +
                    "                     LEFT JOIN SW_DJ_SY t2 ON t1.SY_ID=t2.SY_ID " +
                    "                     LEFT JOIN SW_DJ_JBB t3 ON t1.JBB_ID=t3.JBB_ID " +
                    "                WHERE (t2.SYZT IS NULL OR t2.SYZT=1) AND to_char(t1.update_date,'yyyymmdd')>='" + df.format(swDjSyQuery.getBqUpdateDateBegin()) + "' AND to_char(t1.update_date,'yyyymmdd')<='" + df.format(swDjSyQuery.getBqUpdateDateEnd()) + "' " +
                    "                GROUP BY DECODE(SUBSTR(t3.ZGKG_DM,2, " + length + "),SUBSTR(26107977000,2, " + length + "),SUBSTR(26107990000,2, " + length + "),SUBSTR(t3.ZGKG_DM,2, " + length + ")) " +
                    "           ) t2 ON d.REGION_CODE=t2.DM " +
                    "     ) k";

        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        return listToJson(swDjSyQuery,list,listToJson);

    }
   public List<HashMap<String, Object>> dhbFxList(SwDjSyQuery swDjSyQuery,String regionCode){
        if(swDjSyQuery.getSqUpdateDateBegin()==null
                ||swDjSyQuery.getSqUpdateDateEnd()==null
                ||swDjSyQuery.getBqUpdateDateBegin()==null
                ||swDjSyQuery.getBqUpdateDateEnd()==null){
            return null;
        }
        UserInfo user = SessionUtil.getCurrentUser();
        Integer length;
        if(StringUtils.isBlank(regionCode)){
            regionCode = user.getRegionCode();
            length = regionCode.length()+2;
        }else{
            length = regionCode.length( )+2;
            regionCode = StringUtils.removeEnd(regionCode,"##");
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        String sql = "SELECT k.REGION_CODE, k.ORGAN_NAME, k.SQNYNSE, k.BQNYNSE, k.SQSCMJ, k.BQSCMJ, (k.BQNYNSE-k.SQNYNSE)AS ADDNYNSE, (k.BQSCMJ-k.SQSCMJ)AS ADDSCMJ, " +
                "       DECODE(k.SQNYNSE, 0, '--', ROUND((k.BQNYNSE-k.SQNYNSE)/k.SQNYNSE*100, 2)) AS ZZLNYNSE, " +
                "       DECODE(k.SQSCMJ, 0, '--', ROUND((k.BQSCMJ-k.SQSCMJ)/k.SQSCMJ*100, 2)) AS ZZLSCMJ " +
                "FROM ( " +
                "      SELECT d.REGION_CODE, d.ORGAN_NAME, NVL(t1.SQNYNSE, 0) AS SQNYNSE, NVL(t2.BQNYNSE, 0) AS BQNYNSE, NVL(t1.SQSCMJ, 0) AS SQSCMJ, NVL(t2.BQSCMJ, 0) AS BQSCMJ " +
                "      FROM (" +
                "             SELECT t1.REGION_CODE, t1.ORGAN_NAME " +
                "             FROM ( " +
                "                    SELECT DWDM AS REGION_CODE, DWMC AS ORGAN_NAME FROM S_DM_DWXX_CZ WHERE DWJB IN (0) " +
                "                    UNION " +
                "                    SELECT SUBSTR(SWBMBM, 2, 6), MC FROM DM_SWBM WHERE SUBSTR(SWBMBM, 8, 2)='00' AND SUBSTR(SWBMBM, 6, 2)<='99' AND SUBSTR(SWBMBM, 6, 2)<>'00'  " +
                "                    UNION " +
                "                    SELECT SUBSTR(SWBMBM, 2, 8), MC FROM DM_SWBM WHERE SUBSTR(SWBMBM, 8, 1)<>'0' OR SUBSTR(SWBMBM, 8, 2)='00' " +
                "                  ) t1 " +
                "             WHERE t1.REGION_CODE LIKE '" + regionCode + "%' AND LENGTH(t1.REGION_CODE)=" + length + " " +
                "           ) d " +
                "           LEFT JOIN ( " +
                "                SELECT DECODE(SUBSTR(t3.ZGKG_DM,2, " + length + "),SUBSTR(26107977000,2, " + length + "),SUBSTR(26107990000,2, " +length + "),SUBSTR(t3.ZGKG_DM,2, " + length + ")) AS DM, SUM(NVL(t1.NYNSE, 0)) AS SQNYNSE, SUM(NVL(t1.SCMJ, 0)) AS SQSCMJ " +
                "                FROM SW_DJ_TD t1 " +
                "                     LEFT JOIN SW_DJ_SY t2 ON t1.SY_ID=t2.SY_ID " +
                "                     LEFT JOIN SW_DJ_JBB t3 ON t1.JBB_ID=t3.JBB_ID " +
                "                WHERE (t2.SYZT IS NULL OR t2.SYZT=1) AND to_char(t1.update_date,'yyyymmdd')>='" + df.format(swDjSyQuery.getSqUpdateDateBegin()) + "' AND to_char(t1.update_date,'yyyymmdd')<='" + df.format(swDjSyQuery.getSqUpdateDateEnd()) + "' " +
                "                GROUP BY DECODE(SUBSTR(t3.ZGKG_DM,2, " + length + "),SUBSTR(26107977000,2, " + length + "),SUBSTR(26107990000,2, " + length + "),SUBSTR(t3.ZGKG_DM,2, " + length + ")) " +
                "           ) t1 ON d.REGION_CODE=t1.DM " +
                "           LEFT JOIN ( " +
                "                SELECT DECODE(SUBSTR(t3.ZGKG_DM,2, " + length + "),SUBSTR(26107977000,2, " + length + "),SUBSTR(26107990000,2, " + length + "),SUBSTR(t3.ZGKG_DM,2, " + length + ")) AS DM, SUM(NVL(t1.NYNSE, 0)) AS BQNYNSE, SUM(NVL(t1.SCMJ, 0)) AS BQSCMJ " +
                "                FROM SW_DJ_TD t1 " +
                "                     LEFT JOIN SW_DJ_SY t2 ON t1.SY_ID=t2.SY_ID " +
                "                     LEFT JOIN SW_DJ_JBB t3 ON t1.JBB_ID=t3.JBB_ID " +
                "                WHERE (t2.SYZT IS NULL OR t2.SYZT=1) AND to_char(t1.update_date,'yyyymmdd')>='" + df.format(swDjSyQuery.getBqUpdateDateBegin()) + "' AND to_char(t1.update_date,'yyyymmdd')<='" + df.format(swDjSyQuery.getBqUpdateDateEnd()) + "' " +
                "                GROUP BY DECODE(SUBSTR(t3.ZGKG_DM,2, " + length + "),SUBSTR(26107977000,2, " + length + "),SUBSTR(26107990000,2, " + length + "),SUBSTR(t3.ZGKG_DM,2, " + length + ")) " +
                "           ) t2 ON d.REGION_CODE=t2.DM " +
                "     ) k";

        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        return list;
    }


    public String listToJson(SwDjSyQuery swDjSyQuery,List list,StringBuffer listToJson){

        if(listToJson==null){
            listToJson = new StringBuffer();
        }
        listToJson.append("[") ;
        for(int i=0;i<list.size();i++){
            Object obj = list.get(i);
            if (i>0&&!listToJson.toString().equals("["))
                listToJson.append(",");
            HashMap map = (HashMap)obj;
            String dwdm = String.valueOf(map.get("REGION_CODE"));
            listToJson.append("{");
            listToJson.append("\"dwmc\":"+"\""+map.get("ORGAN_NAME")+"\",");
            listToJson.append("\"sqscmj\":"+"\""+map.get("SQSCMJ")+"\",");
            listToJson.append("\"bqscmj\":"+"\""+map.get("BQSCMJ")+"\",");
            listToJson.append("\"addscmj\":"+"\""+map.get("ADDSCMJ")+"\",");
            listToJson.append("\"zzlscmj\":"+"\""+map.get("ZZLSCMJ")+"\",");
            listToJson.append("\"sqnynse\":"+"\""+map.get("SQNYNSE")+"\",");
            listToJson.append("\"bqnynse\":"+"\""+map.get("BQNYNSE")+"\",");
            listToJson.append("\"addnynse\":"+"\""+map.get("ADDNYNSE")+"\",");
            listToJson.append("\"zzlnynse\":"+"\""+map.get("ZZLNYNSE")+"\"");
            if(dwdm.length()<8){
                listToJson.append(",")  ;
                listToJson.append("\"children\":");
                dhbTjfxJson(swDjSyQuery,listToJson, dwdm + "##");
                listToJson.append("");
            }
            listToJson.append("}");
        }
        listToJson.append("]");
        return listToJson.toString();
    }


    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public Object fcsDhbTjfxJson(SwDjSyQuery swDjSyQuery,StringBuffer listToJson,String regionCode) {
        if(swDjSyQuery.getSqUpdateDateBegin()==null
                ||swDjSyQuery.getSqUpdateDateEnd()==null
                ||swDjSyQuery.getBqUpdateDateBegin()==null
                ||swDjSyQuery.getBqUpdateDateEnd()==null){
            return null;
        }
        UserInfo user = SessionUtil.getCurrentUser();
        Integer length;
        if(StringUtils.isBlank(regionCode)){
            regionCode = user.getRegionCode();
            length = regionCode.length();
        }else{
            length = regionCode.length( );
            regionCode = StringUtils.removeEnd(regionCode,"##");
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        String sql = "SELECT k.REGION_CODE, k.ORGAN_NAME, k.SQNYNSE, k.BQNYNSE, (k.BQNYNSE-k.SQNYNSE)AS ADDNYNSE, " +
                "       DECODE(k.SQNYNSE, 0, '--', ROUND((k.BQNYNSE-k.SQNYNSE)/k.SQNYNSE*100, 2)) AS ZZLNYNSE " +
                "FROM ( " +
                "      SELECT d.REGION_CODE, d.ORGAN_NAME, NVL(t1.SQNYNSE, 0) AS SQNYNSE, NVL(t2.BQNYNSE, 0) AS BQNYNSE " +
                "      FROM (" +
                "             SELECT t1.REGION_CODE, t1.ORGAN_NAME " +
                "             FROM ( " +
                "                    SELECT DWDM AS REGION_CODE, DWMC AS ORGAN_NAME FROM S_DM_DWXX_CZ WHERE DWJB IN (0) " +
                "                    UNION " +
                "                    SELECT SUBSTR(SWBMBM, 2, 6), MC FROM DM_SWBM WHERE SUBSTR(SWBMBM, 8, 2)='00' AND SUBSTR(SWBMBM, 6, 2)<='99' AND SUBSTR(SWBMBM, 6, 2)<>'00' " +
                "                    UNION " +
                "                    SELECT SUBSTR(SWBMBM, 2, 8), MC FROM DM_SWBM WHERE SUBSTR(SWBMBM, 8, 4)<>'0000' " +
                "                  ) t1 " +
                "             WHERE t1.REGION_CODE LIKE '" + regionCode + "%' AND LENGTH(t1.REGION_CODE)=" + length + " " +
                "           ) d " +
                "           LEFT JOIN ( " +
                "                SELECT DECODE(SUBSTR(t3.ZGKG_DM,2, " + length + "),SUBSTR(26107977000,2, " + length + "),SUBSTR(26107990000,2, " + length + "),SUBSTR(t3.ZGKG_DM,2, " + length + ")) AS DM, SUM(NVL(t1.NYNSE, 0)) AS SQNYNSE " +
                "                FROM SW_DJ_FC t1 " +
                "                     LEFT JOIN SW_DJ_SY t2 ON t1.SY_ID=t2.SY_ID " +
                "                     LEFT JOIN SW_DJ_JBB t3 ON t1.JBB_ID=t3.JBB_ID " +
                "                     LEFT JOIN SW_DJ_TD t4 ON t1.SY_ID=t4.SY_ID " +
                "                WHERE (t2.SYZT IS NULL OR t2.SYZT=1) AND to_char(t4.update_date,'yyyymmdd')>='" + df.format(swDjSyQuery.getSqUpdateDateBegin()) + "' AND to_char(t4.update_date,'yyyymmdd')<='" + df.format(swDjSyQuery.getSqUpdateDateEnd()) + "' " +
                "                GROUP BY DECODE(SUBSTR(t3.ZGKG_DM,2, " + length + "),SUBSTR(26107977000,2, " + length + "),SUBSTR(26107990000,2, " + length + "),SUBSTR(t3.ZGKG_DM,2, " + length + ")) " +
                "           ) t1 ON d.REGION_CODE=t1.DM " +
                "           LEFT JOIN ( " +
                "                SELECT DECODE(SUBSTR(t3.ZGKG_DM,2, " + length + "),SUBSTR(26107977000,2, " + length + "),SUBSTR(26107990000,2, " + length + "),SUBSTR(t3.ZGKG_DM,2, " + length + ")) AS DM, SUM(NVL(t1.NYNSE, 0)) AS BQNYNSE " +
                "                FROM SW_DJ_FC t1 " +
                "                     LEFT JOIN SW_DJ_SY t2 ON t1.SY_ID=t2.SY_ID " +
                "                     LEFT JOIN SW_DJ_JBB t3 ON t1.JBB_ID=t3.JBB_ID " +
                "                     LEFT JOIN SW_DJ_TD t4 ON t1.SY_ID=t4.SY_ID " +
                "                WHERE (t2.SYZT IS NULL OR t2.SYZT=1) AND to_char(t4.update_date,'yyyymmdd')>='" + df.format(swDjSyQuery.getBqUpdateDateBegin()) + "' AND to_char(t4.update_date,'yyyymmdd')<='" + df.format(swDjSyQuery.getBqUpdateDateEnd()) + "' " +
                "                GROUP BY DECODE(SUBSTR(t3.ZGKG_DM,2, " + length + "),SUBSTR(26107977000,2, " + length + "),SUBSTR(26107990000,2, " + length + "),SUBSTR(t3.ZGKG_DM,2, " + length + ")) " +
                "           ) t2 ON d.REGION_CODE=t2.DM " +
                "     ) k";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        return fcListToJson(swDjSyQuery,list,listToJson);
    }


    public List<HashMap<String, Object>> fcsdhbFxList(SwDjSyQuery swDjSyQuery,String regionCode){
        if(swDjSyQuery.getSqUpdateDateBegin()==null
                ||swDjSyQuery.getSqUpdateDateEnd()==null
                ||swDjSyQuery.getBqUpdateDateBegin()==null
                ||swDjSyQuery.getBqUpdateDateEnd()==null){
            return null;
        }
        UserInfo user = SessionUtil.getCurrentUser();
        Integer length;
        if(StringUtils.isBlank(regionCode)){
            regionCode = user.getRegionCode();
            length = regionCode.length()+2;
        }else{
            length = regionCode.length( )+2;
            regionCode = StringUtils.removeEnd(regionCode,"##");
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        String sql = "SELECT k.REGION_CODE, k.ORGAN_NAME, k.SQNYNSE, k.BQNYNSE, (k.BQNYNSE-k.SQNYNSE)AS ADDNYNSE, " +
                "       DECODE(k.SQNYNSE, 0, '--', ROUND((k.BQNYNSE-k.SQNYNSE)/k.SQNYNSE*100, 2)) AS ZZLNYNSE " +
                "FROM ( " +
                "      SELECT d.REGION_CODE, d.ORGAN_NAME, NVL(t1.SQNYNSE, 0) AS SQNYNSE, NVL(t2.BQNYNSE, 0) AS BQNYNSE " +
                "      FROM (" +
                "             SELECT t1.REGION_CODE, t1.ORGAN_NAME " +
                "             FROM ( " +
                "                    SELECT DWDM AS REGION_CODE, DWMC AS ORGAN_NAME FROM S_DM_DWXX_CZ WHERE DWJB IN (0) " +
                "                    UNION " +
                "                    SELECT SUBSTR(SWBMBM, 2, 6), MC FROM DM_SWBM WHERE SUBSTR(SWBMBM, 8, 2)='00' AND SUBSTR(SWBMBM, 6, 2)<='99' AND SUBSTR(SWBMBM, 6, 2)<>'00' " +
                "                    UNION " +
                "                    SELECT SUBSTR(SWBMBM, 2, 8), MC FROM DM_SWBM WHERE SUBSTR(SWBMBM, 8, 1)<>'0' OR SUBSTR(SWBMBM, 8, 2)='00' " +
                "                  ) t1 " +
                "             WHERE t1.REGION_CODE LIKE '" + regionCode + "%' AND LENGTH(t1.REGION_CODE)=" + length + " " +
                "           ) d " +
                "           LEFT JOIN ( " +
                "                SELECT DECODE(SUBSTR(t3.ZGKG_DM,2, " + length + "),SUBSTR(26107977000,2, " + length + "),SUBSTR(26107990000,2, " + length + "),SUBSTR(t3.ZGKG_DM,2, " + length + ")) AS DM, SUM(NVL(t1.NYNSE, 0)) AS SQNYNSE " +
                "                FROM SW_DJ_FC t1 " +
                "                     LEFT JOIN SW_DJ_SY t2 ON t1.SY_ID=t2.SY_ID " +
                "                     LEFT JOIN SW_DJ_JBB t3 ON t1.JBB_ID=t3.JBB_ID " +
                "                     LEFT JOIN SW_DJ_TD t4 ON t1.SY_ID=t4.SY_ID " +
                "                WHERE (t2.SYZT IS NULL OR t2.SYZT=1) AND to_char(t4.update_date,'yyyymmdd')>='" + df.format(swDjSyQuery.getSqUpdateDateBegin()) + "' AND to_char(t4.update_date,'yyyymmdd')<='" + df.format(swDjSyQuery.getSqUpdateDateEnd()) + "' " +
                "                GROUP BY DECODE(SUBSTR(t3.ZGKG_DM,2, " + length + "),SUBSTR(26107977000,2, " + length + "),SUBSTR(26107990000,2, " + length + "),SUBSTR(t3.ZGKG_DM,2, " + length + ")) " +
                "           ) t1 ON d.REGION_CODE=t1.DM " +
                "           LEFT JOIN ( " +
                "                SELECT DECODE(SUBSTR(t3.ZGKG_DM,2, " + length + "),SUBSTR(26107977000,2, " + length + "),SUBSTR(26107990000,2, " + length + "),SUBSTR(t3.ZGKG_DM,2, " + length + ")) AS DM, SUM(NVL(t1.NYNSE, 0)) AS BQNYNSE " +
                "                FROM SW_DJ_FC t1 " +
                "                     LEFT JOIN SW_DJ_SY t2 ON t1.SY_ID=t2.SY_ID " +
                "                     LEFT JOIN SW_DJ_JBB t3 ON t1.JBB_ID=t3.JBB_ID " +
                "                     LEFT JOIN SW_DJ_TD t4 ON t1.SY_ID=t4.SY_ID " +
                "                WHERE (t2.SYZT IS NULL OR t2.SYZT=1) AND to_char(t4.update_date,'yyyymmdd')>='" + df.format(swDjSyQuery.getBqUpdateDateBegin()) + "' AND to_char(t4.update_date,'yyyymmdd')<='" + df.format(swDjSyQuery.getBqUpdateDateEnd()) + "' " +
                "                GROUP BY DECODE(SUBSTR(t3.ZGKG_DM,2, " + length + "),SUBSTR(26107977000,2, " + length + "),SUBSTR(26107990000,2, " + length + "),SUBSTR(t3.ZGKG_DM,2, " + length + ")) " +
                "           ) t2 ON d.REGION_CODE=t2.DM " +
                "     ) k";

        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        return list;
    }

    public String fcListToJson(SwDjSyQuery swDjSyQuery,List list,StringBuffer listToJson){

        if(listToJson==null){
            listToJson = new StringBuffer();
        }
        listToJson.append("[") ;
        for(int i=0;i<list.size();i++){
            Object obj = list.get(i);
            if (i>0&&!listToJson.toString().equals("["))
                listToJson.append(",");
            HashMap map = (HashMap)obj;
            String dwdm = String.valueOf(map.get("REGION_CODE"));
            listToJson.append("{");
            listToJson.append("\"dwmc\":"+"\""+map.get("ORGAN_NAME")+"\",");
            listToJson.append("\"sqnynse\":"+"\""+map.get("SQNYNSE")+"\",");
            listToJson.append("\"bqnynse\":"+"\""+map.get("BQNYNSE")+"\",");
            listToJson.append("\"addnynse\":"+"\""+map.get("ADDNYNSE")+"\",");
            listToJson.append("\"zzlnynse\":"+"\""+map.get("ZZLNYNSE")+"\"");
            if(dwdm.length()<8){
                listToJson.append(",")  ;
                listToJson.append("\"children\":");
                fcsDhbTjfxJson(swDjSyQuery,listToJson, dwdm + "##");
                listToJson.append("");
            }
            listToJson.append("}");
        }
        listToJson.append("]");
        return listToJson.toString();
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public Object tdsFxJson(StringBuffer listToJson, String regionCode) {
        UserInfo user = SessionUtil.getCurrentUser();
        Integer length;
        if(StringUtils.isBlank(regionCode)){
            regionCode = user.getRegionCode();
            length = regionCode.length();
        }else{
            length = regionCode.length( );
            regionCode = StringUtils.removeEnd(regionCode,"##");
        }
        String sql = "SELECT k.*, (k.SCMJHZ - k.ZGSCMJHZ) AS ADDSCMJ, (k.NYNSE - k.ZGNYNSE) AS ADDNYNSE, (k.MJSE - k.ZGMJSE) AS ZJMJSE, " +
                "       DECODE(k.ZGSCMJHZ, 0, '--', ROUND((k.SCMJHZ-k.ZGSCMJHZ)/k.ZGSCMJHZ*100, 2)) AS ZZLSCMJ " +
                "FROM ( " +
                "      SELECT d.REGION_CODE, d.ORGAN_NAME, NVL(t1.ZGSCMJHZ, 0) AS ZGSCMJHZ, NVL(t1.ZGNYNSE, 0) AS ZGNYNSE, NVL(t1.ZGMJSE, 0) AS ZGMJSE, " +
                "             NVL(t2.SCMJHZ, 0) AS SCMJHZ, NVL(t2.NYNSE, 0) AS NYNSE, NVL(t2.MJSE, 0) AS MJSE " +
                "      FROM ( " +
                "             SELECT t1.REGION_CODE, t1.ORGAN_NAME " +
                "             FROM (SELECT DWDM AS REGION_CODE, DWMC AS ORGAN_NAME FROM S_DM_DWXX_CZ WHERE DWJB IN (0) " +
                "                   UNION " +
                "                   SELECT SUBSTR(SWBMBM, 2, 6), MC FROM DM_SWBM WHERE SUBSTR(SWBMBM, 8, 2)='00' AND SUBSTR(SWBMBM, 6, 2)<='99' " +
                "                   UNION " +
                "                   SELECT SUBSTR(SWBMBM, 2, 8), MC FROM DM_SWBM WHERE SUBSTR(SWBMBM, 8,  4)<>'0000' AND SUBSTR(SWBMBM, 10, 2)='00') t1 " +
                "             WHERE t1.REGION_CODE LIKE '" + regionCode + "%' AND LENGTH(t1.REGION_CODE)=" + length + " " +
                "           ) d " +
                "           LEFT JOIN ( " +
                "             SELECT DECODE(SUBSTR(t3.ZGKG_DM,2, " + length + "),SUBSTR(26107977000,2, " + length + "),SUBSTR(26107990000,2, " + length + "),SUBSTR(t3.ZGKG_DM,2, " + length + ")) AS DM, SUM(NVL(t1.YNMJ, 0)) AS ZGSCMJHZ, SUM(NVL(t1.NYNSE, 0)) AS ZGNYNSE, SUM(NVL(t1.YNMJ, 0)*NVL(t1.DWSE, 0)) AS ZGMJSE " +
                "             FROM SW_DJ_TD t1 " +
                "                  LEFT JOIN SW_DJ_JBB t3 ON T1.JBB_ID = T3.JBB_ID " +
               // "             WHERE t1.CHOICEFLAG=1 " +
                "             GROUP BY DECODE(SUBSTR(t3.ZGKG_DM,2, " + length + "),SUBSTR(26107977000,2, " + length + "),SUBSTR(26107990000,2, " + length + "),SUBSTR(t3.ZGKG_DM,2, " + length +")) " +
                "           ) t1 ON d.REGION_CODE=t1.DM " +
                "           LEFT JOIN ( " +
                "             SELECT DECODE(SUBSTR(t3.ZGKG_DM,2, " + length + "),SUBSTR(26107977000,2, " + length + "),SUBSTR(26107990000,2, " + length + "),SUBSTR(t3.ZGKG_DM,2, " + length + ")) AS DM, SUM(NVL(t1.SCMJ,0)) AS SCMJHZ, SUM(NVL(t1.NYNSE,0)) AS NYNSE, SUM(NVL(t1.SCMJ,0)*NVL(t1.DWSE,0)) AS MJSE " +
                "             FROM SW_DJ_TD t1 " +
                "                  LEFT JOIN SW_DJ_SY t2 ON t1.SY_ID=t2.SY_ID " +
                "                  LEFT JOIN SW_DJ_JBB t3 ON t1.JBB_ID=t3.JBB_ID " +
                "             WHERE(t2.SYZT IS NULL OR t2.SYZT='1') " +
                "             GROUP BY DECODE(SUBSTR(t3.ZGKG_DM,2, " + length + "),SUBSTR(26107977000,2, " + length + "),SUBSTR(26107990000,2, " + length + "),SUBSTR(t3.ZGKG_DM,2, " + length + ")) " +
                "           ) t2 ON d.REGION_CODE=t2.DM " +
                //"      WHERE t1.DM IS NOT NULL " +
                "     ) K " ;
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        return tdsFxListToJson(list,listToJson);
    }


    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public List<HashMap<String, Object>> tdsFxList(String regionCode){
        UserInfo user = SessionUtil.getCurrentUser();
        Integer length;
        if(StringUtils.isBlank(regionCode)){
            regionCode = user.getRegionCode();
            length = regionCode.length()+2;
        }else{
            length = regionCode.length()+2;
            regionCode = StringUtils.removeEnd(regionCode,"##");
        }
        String sql = "SELECT k.*, (k.SCMJHZ - k.ZGSCMJHZ) AS ADDSCMJ, (k.NYNSE - k.ZGNYNSE) AS ADDNYNSE, (k.MJSE - k.ZGMJSE) AS ZJMJSE, " +
                "       DECODE(k.ZGSCMJHZ, 0, '--', ROUND((k.SCMJHZ-k.ZGSCMJHZ)/k.ZGSCMJHZ*100, 2)) AS ZZLSCMJ " +
                "FROM ( " +
                "      SELECT d.REGION_CODE, d.ORGAN_NAME, NVL(t1.ZGSCMJHZ, 0) AS ZGSCMJHZ, NVL(t1.ZGNYNSE, 0) AS ZGNYNSE, NVL(t1.ZGMJSE, 0) AS ZGMJSE, " +
                "             NVL(t2.SCMJHZ, 0) AS SCMJHZ, NVL(t2.NYNSE, 0) AS NYNSE, NVL(t2.MJSE, 0) AS MJSE " +
                "      FROM ( " +
                "             SELECT t1.REGION_CODE, t1.ORGAN_NAME " +
                "             FROM (SELECT DWDM AS REGION_CODE, DWMC AS ORGAN_NAME FROM S_DM_DWXX_CZ WHERE DWJB IN (0) " +
                "                   UNION " +
                "                   SELECT SUBSTR(SWBMBM, 2, 6), MC FROM DM_SWBM WHERE SUBSTR(SWBMBM, 8, 2)='00' AND SUBSTR(SWBMBM, 6, 2)<='99' " +
                "                   UNION " +
                "                   SELECT SUBSTR(SWBMBM, 2, 8), MC FROM DM_SWBM WHERE SUBSTR(SWBMBM, 8, 1)<>'0' AND SUBSTR(SWBMBM, 10, 2)='00') t1 " +
                "             WHERE t1.REGION_CODE LIKE '" + regionCode + "%' AND LENGTH(t1.REGION_CODE)=" + length + " " +
                "           ) d " +
                "           LEFT JOIN ( " +
                "             SELECT DECODE(SUBSTR(t3.ZGKG_DM,2, " + length + "),SUBSTR(26107977000,2, " + length + "),SUBSTR(26107990000,2, " + length + "),SUBSTR(t3.ZGKG_DM,2, " + length + ")) AS DM, SUM(NVL(t1.YNMJ, 0)) AS ZGSCMJHZ, SUM(NVL(t1.NYNSE, 0)) AS ZGNYNSE, SUM(NVL(t1.YNMJ, 0)*NVL(t1.DWSE, 0)) AS ZGMJSE " +
                "             FROM SW_DJ_TD  t1 " +
                "                  LEFT JOIN SW_DJ_JBB t3 ON  t1.JBB_ID=t3.JBB_ID" +
//                "             WHERE t1.CHOICEFLAG=1 " +
                "             GROUP BY DECODE(SUBSTR(t3.ZGKG_DM,2, " + length + "),SUBSTR(26107977000,2, " + length + "),SUBSTR(26107990000,2, " + length + "),SUBSTR(t3.ZGKG_DM,2, " + length +")) " +
                "           ) t1 ON d.REGION_CODE=t1.DM " +
                "           LEFT JOIN ( " +
                "             SELECT DECODE(SUBSTR(t3.ZGKG_DM,2, " + length + "),SUBSTR(26107977000,2, " + length + "),SUBSTR(26107990000,2, " + length + "),SUBSTR(t3.ZGKG_DM,2, " + length + ")) AS DM, SUM(NVL(t1.SCMJ,0)) AS SCMJHZ, SUM(NVL(t1.NYNSE,0)) AS NYNSE, SUM(NVL(t1.SCMJ,0)*NVL(t1.DWSE,0)) AS MJSE " +
                "             FROM SW_DJ_TD t1 " +
                "                  LEFT JOIN SW_DJ_SY t2 ON t1.SY_ID=t2.SY_ID " +
                "                  LEFT JOIN SW_DJ_JBB t3 ON t1.JBB_ID=t3.JBB_ID " +
                "             WHERE(t2.SYZT IS NULL OR t2.SYZT='1') " +
                "             GROUP BY DECODE(SUBSTR(t3.ZGKG_DM,2, " + length + "),SUBSTR(26107977000,2, " + length + "),SUBSTR(26107990000,2, " + length + "),SUBSTR(t3.ZGKG_DM,2, " + length + ")) " +
                "           ) t2 ON d.REGION_CODE=t2.DM " +
                //"      WHERE t1.DM IS NOT NULL " +
                "     ) K " ;
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        return list;
    }
    public String tdsFxListToJson(List list,StringBuffer listToJson){

        if(listToJson==null){
            listToJson = new StringBuffer();
        }
        listToJson.append("[") ;
        for(int i=0;i<list.size();i++){
            Object obj = list.get(i);
            if (i>0&&!listToJson.toString().equals("["))
                listToJson.append(",");
            HashMap map = (HashMap)obj;
            String dwdm = String.valueOf(map.get("REGION_CODE"));
            listToJson.append("{");
            listToJson.append("\"dwmc\":"+"\""+map.get("ORGAN_NAME")+"\",");
            listToJson.append("\"scmjhz\":"+"\""+map.get("SCMJHZ")+"\",");
            listToJson.append("\"zgscmjhz\":"+"\""+map.get("ZGSCMJHZ")+"\",");
            listToJson.append("\"addscmj\":"+"\""+map.get("ADDSCMJ")+"\",");
            listToJson.append("\"zzlscmj\":"+"\""+map.get("ZZLSCMJ")+"\",");
            listToJson.append("\"zjmjse\":"+"\""+map.get("ZJMJSE")+"\",");
            listToJson.append("\"nynse\":"+"\""+map.get("NYNSE")+"\",");
            listToJson.append("\"zgnynse\":"+"\""+map.get("ZGNYNSE")+"\",");
            listToJson.append("\"addnynse\":"+"\""+map.get("ADDNYNSE")+"\"");
            if(dwdm.length()<8){
                listToJson.append(",")  ;
                listToJson.append("\"children\":");
                tdsFxJson(listToJson, dwdm + "##");
                listToJson.append("");
            }
            listToJson.append("}");
        }
        listToJson.append("]");
        return listToJson.toString();
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public Object fcsFxJson(StringBuffer listToJson, String regionCode) {

        UserInfo user = SessionUtil.getCurrentUser();
        Integer length;
        if(StringUtils.isBlank(regionCode)){
            regionCode = user.getRegionCode();
            length = regionCode.length();
        }else{
            length = regionCode.length( );
            regionCode = StringUtils.removeEnd(regionCode,"##");
        }
        String sql = "SELECT k.*, (k.NYNSE - k.ZGNYNSE) AS ADDNYNSE " +
                "FROM ( " +
                "      SELECT d.REGION_CODE, d.ORGAN_NAME, NVL(t1.ZGNYNSE, 0) AS ZGNYNSE, NVL(t2.NYNSE, 0) AS NYNSE  " +
                "      FROM ( " +
                "             SELECT t1.REGION_CODE, t1.ORGAN_NAME " +
                "             FROM (SELECT DWDM AS REGION_CODE, DWMC AS ORGAN_NAME FROM S_DM_DWXX_CZ WHERE DWJB IN (0) " +
                "                   UNION " +
                "                   SELECT SUBSTR(SWBMBM, 2, 6), MC FROM DM_SWBM WHERE SUBSTR(SWBMBM, 8, 2)='00' AND SUBSTR(SWBMBM, 6, 2)<='99' " +
                "                   UNION " +
                "                   SELECT SUBSTR(SWBMBM, 2, 8), MC FROM DM_SWBM WHERE SUBSTR(SWBMBM, 8, 4)<>'0000') t1 " +
                "             WHERE t1.REGION_CODE LIKE '" + regionCode + "%' AND LENGTH(t1.REGION_CODE)=" + length + " " +
                "           ) d " +
                "           LEFT JOIN ( " +
                "             SELECT DECODE(SUBSTR(t3.ZGKG_DM,2, " + length + "),SUBSTR(26107977000,2, " + length + "),SUBSTR(26107990000,2, " + length + "),SUBSTR(t3.ZGKG_DM,2, " + length + ")) AS DM, SUM(NVL(t1.NYNSE, 0)) AS ZGNYNSE  " +
                "             FROM SW_DJ_FC t1 " +
                "                  LEFT JOIN SW_DJ_JBB t3 ON t1.JBB_ID=t3.JBB_ID " +
                //"             WHERE t1.CHOICEFLAG=1 " +
                "             GROUP BY DECODE(SUBSTR(t3.ZGKG_DM,2, " + length + "),SUBSTR(26107977000,2, " + length + "),SUBSTR(26107990000,2, " + length + "),SUBSTR(t3.ZGKG_DM,2, " + length + ")) " +
                "           ) t1 ON d.REGION_CODE=t1.DM " +
                "           LEFT JOIN ( " +
                "             SELECT DECODE(SUBSTR(t3.ZGKG_DM,2, " + length + "),SUBSTR(26107977000,2, " + length + "),SUBSTR(26107990000,2, " + length + "),SUBSTR(t3.ZGKG_DM,2, " + length + ")) AS DM, SUM(NVL(t1.NYNSE,0)) AS NYNSE  " +
                "             FROM SW_DJ_FC t1 " +
                "                  LEFT JOIN SW_DJ_SY t2 ON t1.SY_ID=t2.SY_ID " +
                "                  LEFT JOIN SW_DJ_JBB t3 ON t1.JBB_ID=t3.JBB_ID " +
                "             WHERE(t2.SYZT IS NULL OR t2.SYZT='1') " +
                "             GROUP BY DECODE(SUBSTR(t3.ZGKG_DM,2, " + length + "),SUBSTR(26107977000,2, " + length + "),SUBSTR(26107990000,2, " + length + "),SUBSTR(t3.ZGKG_DM,2, " + length + ")) " +
                "           ) t2 ON d.REGION_CODE=t2.DM " +
                //"      WHERE t1.DM IS NOT NULL " +
                "     ) K " ;
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        return fcsFxListToJson(list,listToJson);
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public List<HashMap<String, Object>> fcsFxList(String regionCode){
        UserInfo user = SessionUtil.getCurrentUser();
        Integer length;
        if(StringUtils.isBlank(regionCode)){
            regionCode = user.getRegionCode();
            length = regionCode.length()+2;
        }else{
            length = regionCode.length()+2;
            regionCode = StringUtils.removeEnd(regionCode,"##");
        }
        String sql = "SELECT k.*, (k.NYNSE - k.ZGNYNSE) AS ADDNYNSE " +
                "FROM ( " +
                "      SELECT d.REGION_CODE, d.ORGAN_NAME, NVL(t1.ZGNYNSE, 0) AS ZGNYNSE, NVL(t2.NYNSE, 0) AS NYNSE  " +
                "      FROM ( " +
                "             SELECT t1.REGION_CODE, t1.ORGAN_NAME " +
                "             FROM (SELECT DWDM AS REGION_CODE, DWMC AS ORGAN_NAME FROM S_DM_DWXX_CZ WHERE DWJB IN (0) " +
                "                   UNION " +
                "                   SELECT SUBSTR(SWBMBM, 2, 6), MC FROM DM_SWBM WHERE SUBSTR(SWBMBM, 8, 2)='00' AND SUBSTR(SWBMBM, 6, 2)<='99' " +
                "                   UNION " +
                "                   SELECT SUBSTR(SWBMBM, 2, 8), MC FROM DM_SWBM WHERE SUBSTR(SWBMBM, 8, 1)<>'0' OR SUBSTR(SWBMBM, 8, 2)='00') t1 " +
                "             WHERE t1.REGION_CODE LIKE '" + regionCode + "%' AND LENGTH(t1.REGION_CODE)=" + length + " " +
                "           ) d " +
                "           LEFT JOIN ( " +
                "             SELECT DECODE(SUBSTR(t3.ZGKG_DM,2, " + length + "),SUBSTR(26107977000,2, " + length + "),SUBSTR(26107990000,2, " + length + "),SUBSTR(t3.ZGKG_DM,2, " + length + ")) AS DM, SUM(NVL(t1.TAXDUE, 0)) AS ZGNYNSE  " +
                "             FROM SW_DJ_FC t1 " +
                "                  LEFT JOIN SW_DJ_JBB t3 ON t1.JBB_ID=t3.JBB_ID " +
                //"             WHERE t1.CHOICEFLAG=1 " +
                "             GROUP BY DECODE(SUBSTR(t3.ZGKG_DM,2, " + length + "),SUBSTR(26107977000,2, " + length + "),SUBSTR(26107990000,2, " + length + "),SUBSTR(t3.ZGKG_DM,2, " + length + ")) " +
                "           ) t1 ON d.REGION_CODE=t1.DM " +
                "           LEFT JOIN ( " +
                "             SELECT DECODE(SUBSTR(t3.ZGKG_DM,2, " + length + "),SUBSTR(26107977000,2, " + length + "),SUBSTR(26107990000,2, " + length + "),SUBSTR(t3.ZGKG_DM,2, " + length + ")) AS DM, SUM(NVL(t1.NYNSE,0)) AS NYNSE  " +
                "             FROM SW_DJ_FC t1 " +
                "                  LEFT JOIN SW_DJ_SY t2 ON t1.SY_ID=t2.SY_ID " +
                "                  LEFT JOIN SW_DJ_JBB t3 ON t1.JBB_ID=t3.JBB_ID " +
                "             WHERE(t2.SYZT IS NULL OR t2.SYZT='1') " +
                "             GROUP BY DECODE(SUBSTR(t3.ZGKG_DM,2, " + length + "),SUBSTR(26107977000,2, " + length + "),SUBSTR(26107990000,2, " + length + "),SUBSTR(t3.ZGKG_DM,2, " + length + ")) " +
                "           ) t2 ON d.REGION_CODE=t2.DM " +
                //"      WHERE t1.DM IS NOT NULL " +
                "     ) K " ;
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        return list;
    }
    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public Object tdExcZgNsrZsJson(Pageable request) {
        UserInfo user = SessionUtil.getCurrentUser();
        String regionCode = user.getRegionCode();
        if (regionCode.length() > 6) {
            regionCode = regionCode.substring(0, 5);
        }

        String sqlZg = "SELECT TO_CHAR(TAXREGCODE) AS ZGKG_DM, " +
                "       SUM(NVL(TAXFINAL, 0)) AS SNDTDNSE " +
                "FROM TB_LVY_LEVYDATA " +
                "WHERE TAXTYPECODE =13 AND LateFeeFlag <> '1' AND TO_CHAR(DECLAREDATE, 'YYYY')=(TO_CHAR(SYSDATE, 'YYYY') - 1) " +
                "GROUP BY TAXREGCODE";

        String sqlNsr = "SELECT ";
        String sql = "";

        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        StringBuffer countSql = new StringBuffer("select count(*) from (").append(sql).append(")");
        Query countQuery = baseRepository.getEntityManager().createNativeQuery(countSql.toString());
        Page page =  baseRepository.find(query, countQuery, request);
        return page;
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public Object fcExcZgNsrZsJson(Pageable request) {
        return null;
    }

    @Override
    public Object tdfcHcjdTjJson(String id, String beginRq, String endRq) {
        String regionCode = "";
        UserInfo user = SessionUtil.getCurrentUser();
        String userId = user.getId();
        regionCode = user.getRegionCode();
        String dwCode = regionCode;
        if (dwCode.length() > 6) {
            dwCode = dwCode.substring(0, 6);
        }
        Integer length = 6;

        Date dt = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (StringUtils.isBlank(beginRq))
            beginRq = (sdf.format(dt)).substring(0, 4) + "-01-01";
        if (StringUtils.isBlank(endRq))
            endRq = sdf.format(dt);

        beginRq = beginRq.substring(0, 4) + beginRq.substring(5, 7) + beginRq.substring(8, 10);
        endRq = endRq.substring(0, 4) + endRq.substring(5, 7) + endRq.substring(8, 10);
        String zgDateFilter = "(TO_CHAR(t.DECLAREDATE, 'YYYYMMDD') >= " + beginRq + " AND TO_CHAR(t.DECLAREDATE, 'YYYYMMDD') <=" + endRq + ") ";
        String swDateFilter = "(TO_CHAR(t.LRRQ, 'YYYYMMDD') >= " + beginRq + " AND TO_CHAR(t.LRRQ, 'YYYYMMDD') <=" + endRq + ") ";

        String sqlSw = "SELECT jbb.ZGKG_DM, jbb.JBB_ID, MIN(DECODE(td.LRRQ, NULL, td.UPDATE_DATE, td.LRRQ)) AS LRRQ, " +
                "      1 AS HCZHS, SUM(DECODE(td.SGZT_DM, '02', 1, 0)) AS LZLGH, " +
                "       SUM(NVL(td.SCMJ, 0)) AS TDMJ, SUM(NVL(td.YNMJ, 0)) YSTDMJ, SUM(NVL(td.NYNSE, 0)) AS TDYNSE, " +
                "       SUM(NVL(fc.FCYZ, 0)) AS FCYZ, SUM(NVL(fc.NZJ, 0)) ZJSR, SUM(NVL(fc.NYNSE, 0)) AS FCYNSE " +
                "FROM SW_DJ_SY sy " +
                "     LEFT JOIN SW_DJ_TD td ON sy.SY_ID=td.SY_ID " +
                "     LEFT JOIN SW_DJ_FC fc ON sy.SY_ID=fc.SY_ID " +
                "     LEFT JOIN SW_DJ_JBB jbb ON td.JBB_ID=jbb.JBB_ID " +
                "WHERE sy.SYZT = '1' AND td.SGZT_DM IN ('01', '02', '05') AND jbb.ZGKG_DM LIKE '2" +dwCode + "%' " +
                "GROUP BY jbb.ZGKG_DM, jbb.JBB_ID";
        sqlSw = "SELECT t.*, t1.NSRSBH, NVL(zgtd.TAXDUE, 0) AS ZGTDYNSE, NVL(zgfc.TAXDUE, 0) AS ZGFCYNSE " +
                "FROM (" + sqlSw + ") t LEFT JOIN SW_DJ_JBB t1 ON t.JBB_ID=t1.JBB_ID " +
                "     LEFT JOIN (SELECT TO_CHAR(TAXREGCODE) AS NSRSBH, SUM(TAXDUE) AS TAXDUE FROM TB_REG_TOWNUSETAXREGDETAIL WHERE CHOICEFLAG=1 GROUP BY TAXREGCODE) zgtd ON t1.nsrsbh = zgtd.nsrsbh " +
                "     LEFT JOIN (SELECT TO_CHAR(TAXREGCODE) AS NSRSBH, SUM(TAXDUE) AS TAXDUE FROM TB_REG_HOUSEUSETAXITEM WHERE CHOICEFLAG=1 GROUP BY TAXREGCODE) zgfc ON t1.nsrsbh = zgfc.nsrsbh " +
                "WHERE " + swDateFilter;
        String sqlZg = "SELECT TO_CHAR(t.TAXREGCODE) AS nsrsbh, " +
                "       SUM(DECODE(t.TAXTYPECODE, 13, NVL(t.TAXFINAL, 0), 0)) AS TDNSE, " +
                "       SUM(DECODE(t.TAXTYPECODE, 11, NVL(t.TAXFINAL, 0), 0)) AS FCNSE " +
                "FROM TB_LVY_LEVYDATA t " +
                "WHERE t.TAXTYPECODE IN (11, 13) AND t.LateFeeFlag <> '1' AND " + zgDateFilter + " " +
                "GROUP BY t.TAXREGCODE";
        String sql = "SELECT DECODE(GROUPING(DECODE(SUBSTR(sw.ZGKG_DM, 2, " + String.valueOf(length) + "), '610797', '610790', SUBSTR(sw.ZGKG_DM, 2, " + String.valueOf(length) + "))), 0, DECODE(SUBSTR(sw.ZGKG_DM, 2, " + String.valueOf(length) + "), '610797', '610790', SUBSTR(sw.ZGKG_DM, 2, " + String.valueOf(length) + ")), '" + dwCode.substring(0, 4) + "HJ') AS DWDM, " +
                "      SUM(HCZHS) AS TDHCZHS, " +
                "      SUM(LZLGH) AS TDLZLGH, " +
                "      TO_CHAR(SUM(TDMJ), 'FM999,999,999,999,990.00') AS TDMJ, " +
                "      TO_CHAR(SUM(YSTDMJ), 'FM999,999,999,999,990.00') AS YSTDMJ, " +
                "      TO_CHAR(SUM(TDYNSE), 'FM999,999,999,999,990.00') AS TDYNSE, " +
                "      SUM(HCZHS) AS FCHCZHS, " +
                "      SUM(LZLGH) AS FCLZLGH, " +
                "      TO_CHAR(SUM(FCYZ), 'FM999,999,999,999,990.00') AS FCYZ, " +
                "      TO_CHAR(SUM(ZJSR), 'FM999,999,999,999,990.00') AS ZJSR, " +
                "      TO_CHAR(SUM(FCYNSE), 'FM999,999,999,999,990.00') AS FCYNSE, " +
                "      TO_CHAR(SUM(NVL(TDNSE, 0)), 'FM999,999,999,999,990.00') AS TDNSE, " +
                "      TO_CHAR(SUM(NVL(FCNSE, 0)), 'FM999,999,999,999,990.00') AS FCNSE, " +
                "      SUM(DECODE(ZGTDYNSE, NULL, 0, DECODE(SIGN(TDYNSE - ZGTDYNSE), 1, 1, 0))) AS TDSBBSH, " +
                "      SUM(DECODE(ZGFCYNSE, NULL, 0, DECODE(SIGN(FCYNSE - ZGFCYNSE), 1, 1, 0))) AS FCSBBSH " +
                "FROM (" + sqlSw + ") sw LEFT JOIN (" + sqlZg + ") zg ON sw.nsrsbh=zg.nsrsbh " +
                "GROUP BY ROLLUP(DECODE(SUBSTR(sw.ZGKG_DM, 2, " + String.valueOf(length) + "), '610797', '610790', SUBSTR(sw.ZGKG_DM, 2, " + String.valueOf(length) + ")))";
        String sqlDw = "SELECT DWDM, DWMC " +
                "FROM S_DM_DWXX_CZ " +
                "UNION " +
                "SELECT SUBSTR(SWBMBM, 2, 8) AS DWDM, MC AS DWMC " +
                "FROM DM_SWBM " +
                "UNION " +
                "SELECT DWDM||'HJ' AS DWDM, '合计' AS DWMC " +
                "FROM S_DM_DWXX_CZ " +
                "WHERE DWJB=0";
        sql = "SELECT t.*, DECODE(t1.DWMC, NULL, t.DWDM, t1.DWMC) AS DWMC " +
                "FROM (" + sql + ") t LEFT JOIN (" + sqlDw + ") t1 ON t.DWDM=t1.DWDM " +
                "WHERE t.DWDM LIKE '" + dwCode + "%'";

        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        List<HashMap> resultList = new ArrayList<HashMap>();
        if(CollectionUtils.isNotEmpty(list)){
            for(HashMap tempMap : list){
                resultList.add(tempMap);
            }
        }
        return resultList;
    }

    @Override
    public Object getTjJson(Pageable request, String sqlTag, HashMap queryFilter) {
        String sql = getTjSql(sqlTag);
        if (StringUtils.isBlank(sql)) {
            return null;
        }
        sql = addQueryFilter(sql, queryFilter);

        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        String countSql = "select count(*) from (" + sql + ")";
        Query countQuery = baseRepository.getEntityManager().createNativeQuery(countSql);
        Page page =  baseRepository.find(query, countQuery, request);
        return page;
    }

    @Override
    public Object getTjList(String sqlTag, HashMap queryFilter) {
        String sql = getTjSql(sqlTag);
        if (StringUtils.isBlank(sql)) {
            return null;
        }
        sql = addQueryFilter(sql, queryFilter);

        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String, Object>> list = query.getResultList();
        return list;
    }

    @Override
    public TjBaseParamVo getTjBaseParam(String tag) {
        TjBaseParamVo tjBaseParam = null;
        String tagValue;
        if (tjBaseParamList != null) {
            for (int i = 0; i < tjBaseParamList.size(); i++) {
                tagValue = ((TjBaseParamVo)tjBaseParamList.get(i)).getTag();
                if (tagValue.equals(tag)) {
                    tjBaseParam = (TjBaseParamVo)tjBaseParamList.get(i);
                    break;
                }
            }
        }
        return tjBaseParam;
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public Page getTjJson(Pageable request, String sqlTag, List<QueryCondition> queryConditionList) {
        Page page = null;

        String sql = getTjSql(sqlTag);
        if (StringUtils.isNotEmpty(sql)) {
            Query query = createQuery(sql, queryConditionList, null, false);
            query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
            Query countQuery = createQuery(sql, queryConditionList, null, true);
            page =  baseRepository.find(query, countQuery, request);
        } else {
            TjBaseParamVo tjBaseParamVo = getTjBaseParam(sqlTag);
            Class aclass = getTjEntityClass(sqlTag);
            List<QueryCondition> customQueryConditionList = tjBaseParamVo.getQueryConditionList();
            if (CollectionUtils.isNotEmpty(customQueryConditionList))
                queryConditionList.addAll(customQueryConditionList);
            if (aclass != null) {
                page =  baseRepository.find(aclass, queryConditionList, tjBaseParamVo.getOrderBy(), request);
            }
        }

        return page;
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public List getTjList(String sqlTag, List<QueryCondition> queryConditionList) {
        List<HashMap<String, Object>> list = null;
        String sql = getTjSql(sqlTag);
        if (StringUtils.isNotEmpty(sql)) {
            Query query = createQuery(sql, queryConditionList, null, false);
            query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
            list = query.getResultList();
        } else {
            TjBaseParamVo tjBaseParamVo = getTjBaseParam(sqlTag);
            Class aclass = getTjEntityClass(sqlTag);
            List<QueryCondition> customQueryConditionList = tjBaseParamVo.getQueryConditionList();
            if (CollectionUtils.isNotEmpty(customQueryConditionList))
                queryConditionList.addAll(customQueryConditionList);
            if (aclass != null) {
                list =  baseRepository.list(aclass, queryConditionList, tjBaseParamVo.getOrderBy());
            }
        }

        return list;
    }

    @Override
    public String getTjSql(String sqlTag) {
        String sqlBase = "";
        TjBaseParamVo tjBaseParam = getTjBaseParam(sqlTag);
        if (tjBaseParam != null) {
            sqlBase = tjBaseParam.getSql();
        }
        return sqlBase;
    }

    private Class getTjEntityClass(String sqlTag) {
        Class aClass = null;
        TjBaseParamVo tjBaseParam = getTjBaseParam(sqlTag);
        if (tjBaseParam != null) {
            if (StringUtils.isNotEmpty(tjBaseParam.getEntityName())) {
                try {
                    aClass = Class.forName(tjBaseParam.getEntityName());
                } catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
        return aClass;
    }

    private String addQueryFilter(String sqlBase, HashMap queryFilter) {
        if (StringUtils.isBlank(sqlBase)) {
            return null;
        }

        String filter = "";
        if (queryFilter != null) {
            Map map = queryFilter;
            Iterator iter = map.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry) iter.next();
                Object key = entry.getKey();
                Object val = entry.getValue();
                if (val != null && !val.toString().isEmpty()) {
                    filter += " AND " + key.toString() + " LIKE '%" + val.toString() + "%'";
                }
            }
        }

        String regionCode = "";
        UserInfo user = SessionUtil.getCurrentUser();
        regionCode = user.getRegionCode();
        if (regionCode.length() >= 6) {
            filter += " AND XZQDM = '" + regionCode.substring(0, 6) + "'";
        }

        String sqlQuery = "SELECT * FROM (" + sqlBase + ") WHERE 1=1 " + filter;
        return sqlQuery;
    }

    /**
     * 根据sql语句跟查询条件获取Query
     *
     * @param sql
     * @param queryConditions
     * @param orderBy
     * @param isQueryTotal    是否查询记录总数, true 则查询记录总数
     * @return
     */
    @Override
    public Query createQuery(String  sql, List<QueryCondition> queryConditions, String orderBy, boolean isQueryTotal) {
        return createQuery(sql, null, queryConditions, orderBy, isQueryTotal);
    }

    @Override
    public Query createQuery(String  sql, String resultExpression, List<QueryCondition> queryConditions, String orderBy, boolean isQueryTotal) {
        if (StringUtils.isEmpty(resultExpression))
            resultExpression = "*";
        StringBuffer sqlQuery = new StringBuffer("SELECT " + resultExpression + " FROM (" + sql + ") WHERE 1=1");
        if (queryConditions != null && queryConditions.size() > 0) {
            //构造sql语句
            Iterator<QueryCondition> iterator = queryConditions.iterator();
            while (iterator.hasNext()) {
                QueryCondition queryCondition = iterator.next();
                if (queryCondition != null) {
                    if (queryCondition.getOperator().equals(QueryCondition.CUSTOM)) {
                        sqlQuery.append(" AND (").append(queryCondition.getCustomJPQL()).append(")");
                    }
                    if (queryCondition.getValue() != null && !"".equals(queryCondition.getValue())) {
                        //如果占位符名称是*.*格式，则换成*_*格式。且：和名称之间不能有空格
                        String placeholder = queryCondition.getField().indexOf(".") != -1 ? queryCondition.getField().replace(".", "_") : queryCondition.getField();
                        String operator = queryCondition.getOperator();
                        if (operator.equals(QueryCondition.LLK) || operator.equals(QueryCondition.RLK))
                            operator = QueryCondition.LK;
                        sqlQuery.append(" AND ").append(queryCondition.getField().trim())
                                .append(" ").append(operator).append(":").append(placeholder.trim());
                    }
                }

            }
        }
        if (isQueryTotal) {
            sqlQuery.insert(0, "select count(*) from (").append(")");
        } else if (orderBy != null && !"".equals(orderBy)) {
            sqlQuery.append(" ").append(orderBy);
        }

        Query query = baseRepository.getEntityManager().createNativeQuery(sqlQuery.toString());

        if (queryConditions != null && queryConditions.size() > 0) {
            //为参数赋值
            Iterator<QueryCondition> iterator2 = queryConditions.iterator();
            while (iterator2.hasNext()) {
                QueryCondition queryCondition = iterator2.next();
                if (queryCondition != null) {
                    if (queryCondition.getValue() != null && !"".equals(queryCondition.getValue())) {
                        //将占位符中的.替换成_
                        String queryConditionField = queryCondition.getField().indexOf(".") != -1 ? queryCondition.getField().replace(".", "_") : queryCondition.getField();
                        if (queryCondition.getOperator().equals(QueryCondition.LK)) {
                            query.setParameter(queryConditionField, "%" + queryCondition.getValue() + "%");
                        } else if (queryCondition.getOperator().equals(QueryCondition.LLK)) {
                            query.setParameter(queryConditionField, queryCondition.getValue() + "%");
                        } else if (queryCondition.getOperator().equals(QueryCondition.RLK)) {
                            query.setParameter(queryConditionField, "%" + queryCondition.getValue());
                        } else {
                            query.setParameter(queryConditionField, queryCondition.getValue());
                        }
                    }
                }

            }
        }

        return query;
    }

    public String fcsFxListToJson(List list,StringBuffer listToJson){

        if(listToJson==null){
            listToJson = new StringBuffer();
        }
        listToJson.append("[") ;
        for(int i=0;i<list.size();i++){
            Object obj = list.get(i);
            if (i>0&&!listToJson.toString().equals("["))
                listToJson.append(",");
            HashMap map = (HashMap)obj;
            String dwdm = String.valueOf(map.get("REGION_CODE"));
            listToJson.append("{");
            listToJson.append("\"dwmc\":"+"\""+map.get("ORGAN_NAME")+"\",");
            listToJson.append("\"nynse\":"+"\""+map.get("NYNSE")+"\",");
            listToJson.append("\"zgnynse\":"+"\""+map.get("ZGNYNSE")+"\",");
            listToJson.append("\"addnynse\":"+"\""+map.get("ADDNYNSE")+"\"");
            if(dwdm.length()<8){
                listToJson.append(",")  ;
                listToJson.append("\"children\":");
                fcsFxJson(listToJson, dwdm + "##");
                listToJson.append("");
            }
            listToJson.append("}");
        }
        listToJson.append("]");
        return listToJson.toString();
    }

    public Page getSsgxlJson(Pageable request, String nsrsbh, String year) {
        String beginMonth = year + "01";
        String endMonth = year + "12";
        int beginNfsq = Integer.parseInt(year) * 4 + 1;
        int endNfsq = Integer.parseInt(year) * 4 + 4;
        String sql =
                    "SELECT t1.NSRSBH, t1.NSRMC, t1.YNMJ, t2.NSE, DECODE(t1.YNMJ, 0, 0, ROUND(t2.NSE/(t1.YNMJ)/0.0015, 2)) AS GXL, "+year+" AS SSNF " +
                        "FROM " +
                        "  ( " +
                        "    SELECT tt2.NSRSBH, MAX(tt2.NSRMC) AS NSRMC, SUM(tt1.YNMJ) AS YNMJ  " +
                        "    FROM SW_DJ_TD tt1  " +
                        "    INNER JOIN SW_DJ_JBB tt2  " +
                        "    ON tt1.JBB_ID = tt2.JBB_ID  " +
                        "    GROUP BY tt2.NSRSBH  " +
                        "  ) t1  " +
                        "INNER JOIN  " +
                        "  ( " +
                        "       SELECT NSRSBH, " +
                        "              ROUND(SUM(NSE / (ENDNFSQ - STARTNFSQ + 1) * DECODE(SIGN(LEAST(ENDNFSQ, "+endNfsq+") - GREATEST(STARTNFSQ, "+beginNfsq+")), -1, 0,  LEAST(ENDNFSQ, "+endNfsq+") - GREATEST(STARTNFSQ, "+beginNfsq+") + 1)), 2) AS NSE  " +
                        "       FROM ( " +
                        "                SELECT NSRSBH, NSE,  " +
                        "                  (TO_NUMBER(TO_CHAR(t.TAXTERMEND, 'YYYY')) * 4 + TRUNC((TO_NUMBER(TO_CHAR(t.TAXTERMEND, 'MM')) - 1) / 12 * 4) + 1) AS ENDNFSQ,  " +
                        "                  (TO_NUMBER(TO_CHAR(t.TAXTERMBEGIN, 'YYYY')) * 4 + TRUNC((TO_NUMBER(TO_CHAR(t.TAXTERMBEGIN, 'MM')) - 1) / 12 * 4) + 1) AS STARTNFSQ  " +
                        "                FROM LOCAL_SB_RKSS t  " +
                        "                WHERE (TO_CHAR(t.TAXTERMBEGIN, 'YYYYMM') >= '"+beginMonth+"' AND TO_CHAR(t.TAXTERMEND, 'YYYYMM') <= '"+endMonth+"') " +
                        "                OR (TO_CHAR(t.TAXTERMBEGIN, 'YYYYMM') >= '"+beginMonth+"' AND TO_CHAR(t.TAXTERMEND, 'YYYYMM') <= '"+endMonth+"') " +
                        "                OR (TO_CHAR(t.TAXTERMBEGIN, 'YYYYMM') >= '"+beginMonth+"' AND TO_CHAR(t.TAXTERMEND, 'YYYYMM') <= '"+endMonth+"') " +
                        "             ) " +
                        "       GROUP BY NSRSBH " +
                        "  ) t2  " +
                        "ON t1.NSRSBH = t2.NSRSBH ";
        if(StringUtils.isNotBlank(nsrsbh)){
            sql += "WHERE t1.NSRSBH LIKE '%" +nsrsbh+"%'";
        }

        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        String countSql = "select count(*) from (" + sql + ")";
        Query countQuery = baseRepository.getEntityManager().createNativeQuery(countSql);
        Page page =  baseRepository.find(query, countQuery, request);
        return page;
    }

    public List<HashMap<String, Object>> getAllSsgxl(String nsrsbh, String year) {
        String beginMonth = year + "01";
        String endMonth = year + "12";
        int beginNfsq = Integer.parseInt(year) * 4 + 1;
        int endNfsq = Integer.parseInt(year) * 4 + 4;
        String sql =
                "SELECT t1.NSRSBH, t1.NSRMC, t1.YNMJ, t2.NSE, DECODE(t1.YNMJ, 0, 0, ROUND(t2.NSE/t1.YNMJ, 2)) AS GXL, "+year+" AS SSNF " +
                        "FROM " +
                        "  ( " +
                        "    SELECT tt2.NSRSBH, MAX(tt2.NSRMC) AS NSRMC, SUM(tt1.YNMJ) AS YNMJ  " +
                        "    FROM SW_DJ_TD tt1  " +
                        "    INNER JOIN SW_DJ_JBB tt2  " +
                        "    ON tt1.JBB_ID = tt2.JBB_ID  " +
                        "    GROUP BY tt2.NSRSBH  " +
                        "  ) t1  " +
                        "INNER JOIN  " +
                        "  ( " +
                        "       SELECT NSRSBH, " +
                        "              ROUND(SUM(NSE / (ENDNFSQ - STARTNFSQ + 1) * DECODE(SIGN(LEAST(ENDNFSQ, "+endNfsq+") - GREATEST(STARTNFSQ, "+beginNfsq+")), -1, 0,  LEAST(ENDNFSQ, "+endNfsq+") - GREATEST(STARTNFSQ, "+beginNfsq+") + 1)), 2) AS NSE  " +
                        "       FROM ( " +
                        "                SELECT NSRSBH, NSE,  " +
                        "                  (TO_NUMBER(TO_CHAR(t.TAXTERMEND, 'YYYY')) * 4 + TRUNC((TO_NUMBER(TO_CHAR(t.TAXTERMEND, 'MM')) - 1) / 12 * 4) + 1) AS ENDNFSQ,  " +
                        "                  (TO_NUMBER(TO_CHAR(t.TAXTERMBEGIN, 'YYYY')) * 4 + TRUNC((TO_NUMBER(TO_CHAR(t.TAXTERMBEGIN, 'MM')) - 1) / 12 * 4) + 1) AS STARTNFSQ  " +
                        "                FROM LOCAL_SB_RKSS t  " +
                        "                WHERE (TO_CHAR(t.TAXTERMBEGIN, 'YYYYMM') >= '"+beginMonth+"' AND TO_CHAR(t.TAXTERMEND, 'YYYYMM') <= '"+endMonth+"') " +
                        "                OR (TO_CHAR(t.TAXTERMBEGIN, 'YYYYMM') >= '"+beginMonth+"' AND TO_CHAR(t.TAXTERMEND, 'YYYYMM') <= '"+endMonth+"') " +
                        "                OR (TO_CHAR(t.TAXTERMBEGIN, 'YYYYMM') >= '"+beginMonth+"' AND TO_CHAR(t.TAXTERMEND, 'YYYYMM') <= '"+endMonth+"') " +
                        "             ) " +
                        "       GROUP BY NSRSBH " +
                        "  ) t2  " +
                        "ON t1.NSRSBH = t2.NSRSBH ";
        if(StringUtils.isNotBlank(nsrsbh)){
            sql += "WHERE t1.NSRSBH LIKE '%" +nsrsbh+"%'";
        }

        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        return list;
    }

    public List<HashMap<String, Object>> getSsgxlTjJson(String hyDm, String year) {
        String beginMonth = year + "01";
        String endMonth = year + "12";
        int beginNfsq = Integer.parseInt(year) * 4 + 1;
        int endNfsq = Integer.parseInt(year) * 4 + 4;

        String hydmSql = " ";
        if(StringUtils.isNotBlank(hyDm)){
            hydmSql = "AND SUBSTR(tt2.HY_DM, 1, 1) IN" + GtmapStringUtils.getInString(hyDm);
        }

        String sql=
                    "SELECT t1.MC AS HY_MC, t2.HY_DM, t2.YNMJ, t2.NSE, t2.GXL " +
                    "FROM DM_HYDM t1 " +
                    "INNER JOIN  " +
                    "( " +
                    "  SELECT SUM(t1.YNMJ) AS YNMJ, SUM(t2.NSE) AS NSE, t1.HY_DM, DECODE(SUM(YNMJ), 0, 0, ROUND(SUM(t2.NSE)/SUM(t1.YNMJ)/0.0015, 2)) AS GXL  " +
                    "  FROM " +
                    "    ( " +
                    "      SELECT tt2.nsrsbh, SUM(tt1.YNMJ) AS YNMJ, MAX(SUBSTR(tt2.HY_DM, 1, 1)) AS HY_DM  " +
                    "      FROM SW_DJ_TD tt1  " +
                    "      INNER JOIN SW_DJ_JBB tt2  " +
                    "      ON tt1.JBB_ID = tt2.JBB_ID  " +
                    "      WHERE tt2.HY_DM IS NOT NULL " + hydmSql +
                    "      GROUP BY tt2.nsrsbh  " +
                    "    ) t1  " +
                    "  INNER JOIN  " +
                    "    ( " +
                    "       SELECT nsrsbh, " +
                    "              ROUND(SUM(NSE / (ENDNFSQ - STARTNFSQ + 1) * DECODE(SIGN(LEAST(ENDNFSQ, "+endNfsq+") - GREATEST(STARTNFSQ, "+beginNfsq+")), -1, 0,  LEAST(ENDNFSQ, "+endNfsq+") - GREATEST(STARTNFSQ, "+beginNfsq+") + 1)), 2) AS NSE  " +
                    "       FROM ( " +
                    "                SELECT nsrsbh, NSE,  " +
                    "                  (TO_NUMBER(TO_CHAR(t.TAXTERMEND, 'YYYY')) * 4 + TRUNC((TO_NUMBER(TO_CHAR(t.TAXTERMEND, 'MM')) - 1) / 12 * 4) + 1) AS ENDNFSQ,  " +
                    "                  (TO_NUMBER(TO_CHAR(t.TAXTERMBEGIN, 'YYYY')) * 4 + TRUNC((TO_NUMBER(TO_CHAR(t.TAXTERMBEGIN, 'MM')) - 1) / 12 * 4) + 1) AS STARTNFSQ,t.TAXTERMBEGIN,t.TAXTERMEND " +
                    "                FROM LOCAL_SB_RKSS t  " +
                    "                WHERE (TO_CHAR(t.TAXTERMBEGIN, 'YYYYMM') >= '"+beginMonth+"' AND TO_CHAR(t.TAXTERMEND, 'YYYYMM') <= '"+endMonth+"') " +
                    "                OR (TO_CHAR(t.TAXTERMBEGIN, 'YYYYMM') >= '"+beginMonth+"' AND TO_CHAR(t.TAXTERMEND, 'YYYYMM') <= '"+endMonth+"') " +
                    "                OR (TO_CHAR(t.TAXTERMBEGIN, 'YYYYMM') >= '"+beginMonth+"' AND TO_CHAR(t.TAXTERMEND, 'YYYYMM') <= '"+endMonth+"') " +
                    "             )   where  TAXTERMBEGIN <= TAXTERMEND       " +
                    "       GROUP BY nsrsbh " +
                    "    ) t2  " +
                    "  ON t1.nsrsbh = t2.nsrsbh " +
                    "  GROUP BY t1.HY_DM " +
                    ") t2 ON t1.DM = t2.HY_DM ";

        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        return list;
    }
    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public Page getJxJson(SwDjSyQuery swDjSyQuery,Pageable pageable){
        UserInfo user = SessionUtil.getCurrentUser();
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        String organSql="";
        if(StringUtils.isNotBlank(swDjSyQuery.getOrgan())){
            organSql+=" and organ_id='"+swDjSyQuery.getOrgan()+"' ";
        }
        String rqSql="";
        if(swDjSyQuery.getStartRq()!=null){
            rqSql+=" and to_char(t.begin_time,'yyyymmdd')>='"+df.format(swDjSyQuery.getStartRq())+"' ";
        }
        if(swDjSyQuery.getEndRq()!=null){
            rqSql+=" and to_char(t.begin_time,'yyyymmdd')<='"+df.format(swDjSyQuery.getEndRq())+"' ";
        }
        String sql = "SELECT k.*,\n" +
                "       (k.rwzs-k.wbls-k.aqbls) cqbls,ROUND(DECODE(k.rwzs,0,1,k.aqbls/k.rwzs)*100,2)AS aqbll from\n" +
                "  (SELECT t1.organ_name,t1.user_name,t1.user_id,t1.organ_id,NVL(t2.rwzs, 0) rwzs,NVL(t3.wbls, 0) wbls,NVL(t4.aqbls, 0) aqbls from\n" +
                "     (SELECT t2.user_name,t2.user_id,t4.organ_name,t4.organ_id\n" +
                "      FROM pf_user t2\n" +
                "      LEFT JOIN pf_user_organ_rel t3 ON t2.user_id=t3.user_id\n" +
                "      LEFT JOIN pf_organ t4 ON t3.organ_id=t4.organ_id\n" +
                "      WHERE t2.remark='swy')t1\n" +
                "   LEFT JOIN\n" +
                "     (SELECT user_id,count(*) AS rwzs from\n" +
                "        (SELECT t.*\n" +
                "         FROM pf_user t2\n" +
                "         LEFT JOIN\n" +
                "           (SELECT t2.user_name,t1.WORKFLOW_INSTANCE_ID,t1.finish_time, t.*, ROW_NUMBER() OVER(PARTITION BY t1.WORKFLOW_INSTANCE_ID\n" +
                "                                                                                                             ORDER BY t.OVER_TIME DESC) AS PM\n" +
                "            FROM\n" +
                "              (SELECT USER_ID, ACTIVITY_ID, BEGIN_TIME, OVER_TIME\n" +
                "               FROM PF_ASSIGNMENTHISTORY\n" +
                "               UNION ALL SELECT USER_ID, ACTIVITY_ID, BEGIN_TIME, OVER_TIME\n" +
                "               FROM PF_ASSIGNMENT) t\n" +
                "            LEFT JOIN PF_ACTIVITY t1 ON t.ACTIVITY_ID = t1.ACTIVITY_ID\n" +
                "            LEFT JOIN pf_user t2 ON t.user_id=t2.user_id\n" +
                "            \n" +
                "            WHERE t2.remark='swy' ) t ON t.user_id=t2.user_id\n" +
                "         WHERE t.pm=1\n" +
                "          AND t.workflow_instance_id IS NOT NULL "+rqSql+")\n" +
                "      GROUP BY user_id)t2 ON t1.user_id=t2.user_id\n" +
                "   LEFT JOIN\n" +
                "     (SELECT user_id,count(*) AS wbls from\n" +
                "        (SELECT t.*\n" +
                "         FROM pf_user t2\n" +
                "         LEFT JOIN\n" +
                "           (SELECT t2.user_name,t1.WORKFLOW_INSTANCE_ID,t1.activity_state,t1.finish_time, t.*, ROW_NUMBER() OVER(PARTITION BY t1.WORKFLOW_INSTANCE_ID\n" +
                "                                                                                                                               ORDER BY t.OVER_TIME DESC) AS PM\n" +
                "            FROM\n" +
                "              (SELECT USER_ID, ACTIVITY_ID, BEGIN_TIME, OVER_TIME\n" +
                "               FROM PF_ASSIGNMENTHISTORY\n" +
                "               UNION ALL SELECT USER_ID, ACTIVITY_ID, BEGIN_TIME, OVER_TIME\n" +
                "               FROM PF_ASSIGNMENT) t\n" +
                "            LEFT JOIN PF_ACTIVITY t1 ON t.ACTIVITY_ID = t1.ACTIVITY_ID\n" +
                "            LEFT JOIN pf_user t2 ON t.user_id=t2.user_id\n" +
                "            WHERE t2.remark='swy'\n" +
                "              AND t1.activity_state<>'2') t ON t.user_id=t2.user_id\n" +
                "         WHERE t.pm=1\n" +
                "           AND t.workflow_instance_id IS NOT NULL "+rqSql+")\n" +
                "      GROUP BY user_id)t3 ON t1.user_id=t3.user_id\n" +
                "   LEFT JOIN\n" +
                "     (SELECT user_id,count(*) AS aqbls from\n" +
                "        (SELECT t.*\n" +
                "         FROM pf_user t2\n" +
                "         LEFT JOIN\n" +
                "           (SELECT t2.user_name,t1.WORKFLOW_INSTANCE_ID,t1.activity_state,t1.finish_time, t.*, ROW_NUMBER() OVER(PARTITION BY t1.WORKFLOW_INSTANCE_ID\n" +
                "                                                                                                                               ORDER BY t.OVER_TIME DESC) AS PM\n" +
                "            FROM\n" +
                "              (SELECT USER_ID, ACTIVITY_ID, BEGIN_TIME, OVER_TIME\n" +
                "               FROM PF_ASSIGNMENTHISTORY\n" +
                "               UNION ALL SELECT USER_ID, ACTIVITY_ID, BEGIN_TIME, OVER_TIME\n" +
                "               FROM PF_ASSIGNMENT) t\n" +
                "            LEFT JOIN PF_ACTIVITY t1 ON t.ACTIVITY_ID = t1.ACTIVITY_ID\n" +
                "            LEFT JOIN pf_user t2 ON t.user_id=t2.user_id\n" +
                "            WHERE t2.remark='swy'\n" +
                "              AND t1.activity_state='2'\n" +
                "              AND t.over_time>t1.finish_time) t ON t.user_id=t2.user_id\n" +
                "         WHERE t.pm=1\n" +
                "           AND t.workflow_instance_id IS NOT NULL "+rqSql+")\n" +
                "      GROUP BY user_id)t4 ON t1.user_id=t4.user_id)k\n" +" where 1=1 "+organSql+
                "    ORDER BY organ_name" ;
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        String countSql = "select count(*) from (";
        countSql += sql;
        countSql +=")";
        Query countQuery = baseRepository.getEntityManager().createNativeQuery(countSql);
        Page page =  baseRepository.find(query, countQuery, pageable);
        return page;
    }
    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public List<HashMap<String,Object>> getRwList(String userId,SwDjSyQuery swDjSyQuery) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        String rqSql="";
        if(swDjSyQuery.getStartRq()!=null){
            rqSql+=" and to_char(t.begin_time,'yyyymmdd')>='"+df.format(swDjSyQuery.getStartRq())+"' ";
        }
        if(swDjSyQuery.getEndRq()!=null){
            rqSql+=" and to_char(t.begin_time,'yyyymmdd')<='"+df.format(swDjSyQuery.getEndRq())+"' ";
        }
        String sql = "";
        sql =   "SELECT row_number() over(order by t.begin_time) xh," +
                "case when activity_state<>'2' then '未办理' when finish_time-over_time>0 then '超期完成' else '按期完成' end as bz,t.*\n" +
                "         FROM pf_user t2\n" +
                "         LEFT JOIN\n" +
                "           (SELECT t2.user_name,t1.activity_state,t1.WORKFLOW_INSTANCE_ID,t3.workflow_instance_name RWMC,t1.finish_time, t.*, ROW_NUMBER() OVER(PARTITION BY t1.WORKFLOW_INSTANCE_ID\n" +
                "                                                                                                             ORDER BY t.OVER_TIME DESC) AS PM\n" +
                "            FROM\n" +
                "              (SELECT USER_ID, ACTIVITY_ID, BEGIN_TIME, OVER_TIME\n" +
                "               FROM PF_ASSIGNMENTHISTORY\n" +
                "               UNION ALL SELECT USER_ID, ACTIVITY_ID, BEGIN_TIME, OVER_TIME\n" +
                "               FROM PF_ASSIGNMENT) t\n" +
                "            LEFT JOIN PF_ACTIVITY t1 ON t.ACTIVITY_ID = t1.ACTIVITY_ID\n" +
                "            LEFT JOIN pf_user t2 ON t.user_id=t2.user_id\n" +
                "            LEFT JOIN pf_workflow_instance t3 on t1.workflow_instance_id=t3.workflow_instance_id\n"+
                "            \n" +
                "            WHERE t2.remark='swy' ) t ON t.user_id=t2.user_id\n" +
                "         WHERE t.pm=1\n" +
                "           AND t.workflow_instance_id IS NOT NULL and t2.user_id='"+userId+"'"+rqSql;


        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        return query.getResultList();
    }

    /*
    * 获取土地等级代码
    * */
    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public HashMap<String,String> getTdjbList(){
        HashMap<String,String> resultMap =new HashMap<String,String>();
        String sql ="select dm,mc from S_ZD_TDJB t";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        for(HashMap<String , Object> listTemp:list){
            resultMap.put((String)listTemp.get("DM"),(String)listTemp.get("MC"));
        }
        return resultMap;
    };
    /*
* 获取税源综合统计表json
* */
    public List<HashMap<String,Object>> syzhtjbJson(String id){
        String sql = "SELECT :dwdmAndMc " +
                ",nvl(TO_CHAR(t1.SY_HJ, 'FM999,999,999,999,990'),0) AS SY_HJ" +
                ",nvl(TO_CHAR(t1.SY_KGH, 'FM999,999,999,999,990'),0) AS SY_KGH" +
                ",nvl(TO_CHAR(t1.SY_LZLGH, 'FM999,999,999,999,990'),0) AS SY_LZLGH" +
                ",nvl(TO_CHAR(t1.SY_KZH, 'FM999,999,999,999,990'),0) AS SY_KZH" +
                ",nvl(TO_CHAR(t1.SY_JGDW, 'FM999,999,999,999,990'),0) AS SY_JGDW" +
                ",nvl(TO_CHAR(t1.SY_GR, 'FM999,999,999,999,990'),0) AS SY_GR" +
                ",nvl(TO_CHAR(t1.TD_HCMJ, 'FM999,999,999,999,990.00'),0) AS TD_HCMJ" +
                ",nvl(TO_CHAR(t1.TD_MSMJ, 'FM999,999,999,999,990.00'),0) AS TD_MSMJ" +
                ",nvl(TO_CHAR(t1.TD_YSMJ, 'FM999,999,999,999,990.00'),0) AS TD_YSMJ" +
                ",nvl(TO_CHAR(t1.TD_MSSE, 'FM999,999,999,999,990.00'),0) AS TD_MSSE" +
                ",nvl(TO_CHAR(t1.TD_NYNSE, 'FM999,999,999,999,990.00'),0) AS TD_NYNSE" +
                ",nvl(TO_CHAR(t1.FC_FCYZ_YS, 'FM999,999,999,999,990.00'),0) AS FC_FCYZ_YS" +
                ",nvl(TO_CHAR(t1.FC_FCYZ_MS, 'FM999,999,999,999,990.00'),0) AS FC_FCYZ_MS" +
                ",nvl(TO_CHAR(t1.FC_YNSE_CZ, 'FM999,999,999,999,990.00'),0) AS FC_YNSE_CZ" +
                ",nvl(TO_CHAR(t1.FC_YNSE_ZY, 'FM999,999,999,999,990.00'),0) AS FC_YNSE_ZY" +
                ",nvl(TO_CHAR(t1.FC_NYNSE, 'FM999,999,999,999,990.00'),0) AS FC_NYNSE" +
                ",nvl(TO_CHAR(t1.FC_YNSE_ZY, 'FM999,999,999,999,990.00'),0) AS FC_YNSE_ZY_CJJ" +
                ",nvl(TO_CHAR(t1.FC_YNSE_CZ, 'FM999,999,999,999,990.00'),0) AS FC_YNSE_ZY_CZJ" +
                " FROM :table t " +
                " LEFT JOIN (" +
                "SELECT :sdwdm dwdm " +
                ",SUM(1) AS SY_HJ" +
                ",SUM(DECODE(t1.SGZT_DM, '01', 1, 0)) AS SY_KGH" +
                ",SUM(DECODE(t1.SGZT_DM, '02', 1, 0)) AS SY_LZLGH" +
                ",SUM(DECODE(t1.SGZT_DM, '03', 1, 0)) AS SY_KZH" +
                ",SUM(DECODE(t1.SGZT_DM, '04', 1, 0)) AS SY_GR" +
                ",SUM(DECODE(t1.SGZT_DM, '05', 1, 0)) AS SY_JGDW" +
                ",SUM(t1.SCMJ) AS TD_HCMJ" +
                ",SUM(t1.MSMJ) AS TD_MSMJ" +
                ",SUM(t1.YNMJ) AS TD_YSMJ" +
                ",SUM(t1.MSSE) AS TD_MSSE" +
                ",SUM(t1.NYNSE) AS TD_NYNSE" +
                ",SUM(t2.FCYZ) AS FC_FCYZ" +
                ",SUM(t2.FCYZ_YS) AS FC_FCYZ_YS" +
                ",SUM(t2.FCYZ_MS) AS FC_FCYZ_MS" +
                ",SUM(t2.YNSE_ZY) AS FC_YNSE_ZY" +
                ",SUM(t2.YNSE_CZ) AS FC_YNSE_CZ" +
                ",SUM(t2.NYNSE) AS FC_NYNSE" +
                " FROM SW_DJ_SY t" +
                " LEFT JOIN SW_DJ_TD t1 ON t.SY_ID = t1.SY_ID" +
                " LEFT JOIN SW_DJ_FC t2 ON t.SY_ID = t2.SY_ID" +
                " LEFT JOIN SW_DJ_JBB t3 ON t1.JBB_ID = t3.JBB_ID" +
                " WHERE t1.SGZT_DM IS NOT NULL" +
                " AND (" +
                "t.SYZT = '1'" +
                "OR t.SYZT IS NULL" +
                ")" +
                " AND t3.ZGKG_DM IS NOT NULL" +
                " GROUP BY :sdwdm " +
                ") t1 ON t.:dwdm = t1.dwdm" +
                " WHERE 1=1 :dwjb";

        if(id==null){
            //第一次加载树，查询结果 市级
            sql=sql.replaceAll(":dwdmAndMc"," t.dwmc , t.dwdm ");
            sql=sql.replaceAll(":table"," s_dm_dwxx_cz ");
            sql=sql.replaceAll(":sdwdm"," substr(t3.zgkg_dm, 2, 4)  ");
            sql=sql.replaceAll(":dwdm"," dwdm ");
            sql=sql.replaceAll(":dwjb"," and t.dwjb = 0 ");
        }else if(id.length()==4){
            //由市级查询区县
            sql=sql.replaceAll(":dwdmAndMc"," t.dwmc , t.dwdm ");
            sql=sql.replaceAll(":table"," s_dm_dwxx_cz ");
            sql=sql.replaceAll(":sdwdm"," substr(t3.zgkg_dm, 2, 6)  ");
            sql=sql.replaceAll(":dwdm"," dwdm ");
            sql=sql.replaceAll(":dwjb"," and t.dwjb = 1 order by t.dwdm");
        }else{
            //查询土地级别
            sql=sql.replaceAll(":dwdmAndMc"," t.mc as dwmc, t.dm as dwdm, t.sl ");
            sql=sql.replaceAll(":table"," s_zd_tdjb ");
            sql=sql.replaceAll(":sdwdm"," t1.tddj  ");
            sql=sql.replaceAll(":dwdm"," dm ");
            sql=sql.replaceAll(":dwjb"," and t.dm like '"+id+"%' order by t.dm");
        }

        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();

        //树是否可以展开
        if(id==null||id.length()==4){
            for (HashMap<String,Object> mapTemp:list){
                mapTemp.put("state","closed");
            }
        }
        return list;
    };
}
