package cn.gtmap.landtax.service.impl;

import cn.gtmap.landtax.model.query.TddjydQuery;
import cn.gtmap.landtax.service.TddjydcxService;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import org.apache.commons.lang.StringUtils;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.Query;
import java.util.List;
import java.util.Map;

@Service
public class TddjydcxServiceImpl implements TddjydcxService{
    @Autowired
    private BaseRepository baseRepository;

    @Override
    public Page<TddjydQuery> selectAll(Pageable pageable) {
        return null;
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public Page<TddjydQuery> selectByCondition(TddjydQuery tddjydQuery, Pageable pageable) {
        StringBuffer sql = new StringBuffer("select * from s_yd_tddj where 1=1 ");
        String countsql = "select count(*) from s_yd_tddj";
        Query query = null;
        Query countQuery = null;
        String sqlWithCond = addConditions(sql,tddjydQuery);
        query = baseRepository.getEntityManager().createNativeQuery(sqlWithCond);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        countQuery = baseRepository.getEntityManager().createNativeQuery(countsql);

        if (pageable==null||pageable.getPageNumber()==0) {
            pageable = new PageRequest(1, 15);
        }
        Page page =  baseRepository.find(query, countQuery, pageable);
        return page;
    }

    @Override
    public List getTdjbZd() {
        String sql = " select dm,mc from S_ZD_TDJB ";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List list = query.getResultList();
        for(Object obj:list){
            Map map = (Map)obj;
            String syuuid = map.get("MC").toString();
        }
        return list;
    }

    @Override
    public List getHistoryBySyuuId(String syuuid) {
        String sql = "select * from s_yd_tddj_his where syuuid = '"+syuuid+"' order by bgsj  ";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List list = query.getResultList();
        return list;
    }

    private String addConditions(StringBuffer sb,TddjydQuery tddjydQuery){
        if(StringUtils.isNotBlank(tddjydQuery.getShxydm())){
            sb.append(" and SHXYDM = '"+tddjydQuery.getShxydm()+"'");
        }
        if(StringUtils.isNotBlank(tddjydQuery.getNsrmc())){
            sb.append(" and NSRMC = '"+tddjydQuery.getNsrmc()+"'");
        }
        if(StringUtils.isNotBlank(tddjydQuery.getTdzldz())){
            sb.append(" and TDZLDZ = '"+tddjydQuery.getTdzldz()+"'");
        }
        if(StringUtils.isNotBlank(tddjydQuery.getZgswjdm())){
            sb.append(" and ZGSWJDM = '"+tddjydQuery.getZgswjdm()+"'");
        }
        if(StringUtils.isNotBlank(tddjydQuery.getTddj_q())){
            sb.append(" and TDDJ_Q = '"+tddjydQuery.getTddj_q()+"'");
        }
        if(StringUtils.isNotBlank(tddjydQuery.getTddj_z())){
            sb.append(" and TDDJ_Z = '"+tddjydQuery.getTddj_z()+"'");
        }
        if(StringUtils.isNotBlank(tddjydQuery.getTddj_zd())){
            sb.append(" and TDDJ_ZD = '"+tddjydQuery.getTddj_zd()+"'");
        }
        if(StringUtils.isNotBlank(tddjydQuery.getZt())){
            sb.append(" and ZT = '"+tddjydQuery.getZt()+"'");
        }
        if(StringUtils.isNotBlank(tddjydQuery.getScsj()) || StringUtils.isNotBlank(tddjydQuery.getScsj_h())){
            sb.append(" and to_date('"+tddjydQuery.getScsj()+"','yyyy-MM-dd')<= scsj and scsj<= to_date('"+tddjydQuery.getScsj_h()+"','yyyy-MM-dd')");
        }
        if(StringUtils.isNotBlank(tddjydQuery.getXcsj()) || StringUtils.isNotBlank(tddjydQuery.getXcsj_h())){
            sb.append(" and to_date('"+tddjydQuery.getXcsj()+"','yyyy-MM-dd')<= scsj and scsj<= to_date('"+tddjydQuery.getXcsj_h()+"','yyyy-MM-dd')");
        }
        return  sb.toString();
    }
}
