package cn.gtmap.landtax.service.impl;

import cn.gtmap.landtax.entity.*;
import cn.gtmap.landtax.model.dictionary.Hcxmlx;
import cn.gtmap.landtax.model.dictionary.Isxf;
import cn.gtmap.landtax.model.dictionary.Sjly;
import cn.gtmap.landtax.model.query.GtSwTzQuery;
import cn.gtmap.landtax.service.DwxxService;
import cn.gtmap.landtax.service.TddjtzService;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.IPlatUtil;
import cn.gtmap.landtax.util.QueryCondition;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.vo.UserInfo;
import com.gtis.spring.Container;
import com.gtis.web.SessionUtil;
import com.mysema.query.jpa.JPASubQuery;
import com.mysema.query.jpa.JPQLQuery;
import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.support.Expressions;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Projections;
import com.mysema.query.types.QBean;
import org.apache.commons.lang.StringUtils;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.Query;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

/**
 * .
 * <p/>
 * 不再使用，请使用ZdhcService
 * @author yang
 * @version V1.0, 14-7-7
 */
@Service
public class TddjtzServiceImpl implements TddjtzService {
    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
    @Autowired
    BaseRepository baseRepository;
    @Autowired
    DwxxService dwxxService;
    @Autowired
    HashMap hcjdConfigMap;

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public Page findGtppxxMap(String xzqbh, String lx, Pageable pageable, GtSwTzQuery gtSwTzQuery,String sidx,String sord) {
        String regionCode = SessionUtil.getCurrentUser().getRegionCode();
        if (xzqbh!=null) {
            regionCode = xzqbh;
        }
        if(StringUtils.isEmpty(regionCode)){
            regionCode="";
        }

        String sql ="SELECT t1.*,t_dm.ISYS, TO_CHAR(t4.USER_NAME) AS USER_NAME, " +
                    "       DECODE(t2.BLZT, '1', 'ybj', NVL(t4.ACTIVITY_DEFINITION_ID, 'wxf')) AS STATUE " +
                    "FROM (SELECT * FROM S_SJ_GTBD WHERE DJH IN (SELECT DJH FROM ZD WHERE SGQDM LIKE :regionCode||'%') and (ppzt  not in('1','2') or ppzt is null)) t1 " +
                    "     LEFT JOIN (SELECT * FROM SW_HC_XM_RW_REL WHERE HCXM_ID IN (SELECT ID FROM SW_HC_XM WHERE XMLX= :hclx)) t2 on t1.GTBD_ID = t2.BD_ID " +
                    "     LEFT JOIN (SELECT * FROM S_ZD_DLDM ) t_dm ON t1.TDYT_DM=t_dm.DM"+
                    "     LEFT JOIN ( " +
                    "         SELECT t4.WORKFLOW_INSTANCE_ID, t4.ACTIVITY_DEFINITION_ID, t6.USER_NAME " +
                    "         FROM ( " +
                    "             SELECT * " +
                    "             FROM PF_ACTIVITY t " +
                    "             WHERE t.ACTIVITY_STATE='1' " +
                    "             ) t4 " +
                    "             LEFT JOIN PF_ASSIGNMENT t5 ON t5.ACTIVITY_ID=t4.ACTIVITY_ID " +
                    "             LEFT JOIN PF_USER t6 ON t5.USER_ID=t6.USER_ID " +
                    "     ) t4 ON t4.WORKFLOW_INSTANCE_ID=t2.RW_ID " +
                    "WHERE 1=1 and t_dm.isys='1'";
        sql = addWhclbWhere(gtSwTzQuery, sql, lx, true);

        String statue = gtSwTzQuery.getStatue();
        if(StringUtils.isNotBlank(statue)) {
            if (statue.equals("ybj")) {
                sql = sql + " and t2.BLZT = '1' ";
            } else if (statue.equals("wxf")) {
                sql = sql + " and NVL(t2.BLZT, '0')='0' and t4.ACTIVITY_DEFINITION_ID IS NULL ";
            } else{
                sql = sql + " and NVL(t2.BLZT, '0')='0' and t4.ACTIVITY_DEFINITION_ID = '"+statue+"' ";
            }
        }

        //排序
        if(sidx.equals("djh")){
            sql = sql  + "ORDER BY t1.djh "+sord;
        }else if(sidx.equals("tdmj")){
            sql = sql  + "ORDER BY t1.scmj "+sord;
        }else if(sidx.equals("tdytMc")){
            sql = sql  + "ORDER BY t1.TDYT_MC "+sord;
        }else if(sidx.equals("tdzl")){
            sql = sql  + "ORDER BY t1.TDZL "+sord;
        }else if(sidx.equals("qlrmc")){
            sql = sql  + "ORDER BY t1.qlrmc "+sord;
        }else if(sidx.equals("jdmc")){
            sql = sql  + "ORDER BY STATUE "+sord;
        }else if(sidx.equals("userName")){
            sql = sql  + "ORDER BY t4.USER_NAME "+sord;
        }

        Query query = baseRepository.getEntityManager().createNativeQuery(sql)
                .setParameter("regionCode", regionCode)
                .setParameter("hclx", Hcxmlx.ZDHC.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        StringBuffer countSql = new StringBuffer("SELECT COUNT(*) FROM (").append(sql).append(")");
        Query countQuery = baseRepository.getEntityManager().createNativeQuery(countSql.toString())
                .setParameter("regionCode", regionCode)
                .setParameter("hclx", Hcxmlx.ZDHC.toString());

        if (pageable==null||pageable.getPageNumber()==0) {
            pageable = new PageRequest(1, 15);
        }
        Page page =  baseRepository.find(query, countQuery, pageable);
        return page;
    }

    //导出Excel用
    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public List findGtppxxList(String xzqbh, String lx, GtSwTzQuery gtSwTzQuery,String ids) {
        String regionCode = SessionUtil.getCurrentUser().getRegionCode();
        if (xzqbh!=null) {
            regionCode = xzqbh;
        }
        String[] configArr = (String[]) hcjdConfigMap.get(Hcxmlx.ZDHC.toString());
        String sql = "SELECT  t1.*,t_dm.ISYS, TO_CHAR(t4.USER_NAME) AS USER_NAME, " +
                "       DECODE(t2.BLZT, '1', 'ybj', NVL(t4.ACTIVITY_DEFINITION_ID, 'wxf')) AS STATUE " +
                "FROM (SELECT * FROM S_SJ_GTBD WHERE DJH IN (SELECT DJH FROM ZD WHERE SGQDM LIKE :regionCode||'%') and (ppzt  not in('1','2') or ppzt is null)) t1 " +
                "     LEFT JOIN (SELECT * FROM SW_HC_XM_RW_REL WHERE HCXM_ID IN (SELECT ID FROM SW_HC_XM WHERE XMLX= :hclx)) t2 on t1.GTBD_ID = t2.BD_ID " +
                "     LEFT JOIN (SELECT * FROM S_ZD_DLDM ) t_dm ON t1.TDYT_DM=t_dm.DM"+
                "     LEFT JOIN ( " +
                "         SELECT t4.WORKFLOW_INSTANCE_ID, t4.ACTIVITY_DEFINITION_ID, t6.USER_NAME " +
                "         FROM ( " +
                "             SELECT * " +
                "             FROM PF_ACTIVITY t " +
                "             WHERE t.ACTIVITY_STATE='1' " +
                "             ) t4 " +
                "             LEFT JOIN PF_ASSIGNMENT t5 ON t5.ACTIVITY_ID=t4.ACTIVITY_ID " +
                "             LEFT JOIN PF_USER t6 ON t5.USER_ID=t6.USER_ID " +
                "     ) t4 ON t4.WORKFLOW_INSTANCE_ID=t2.RW_ID " +
                "WHERE 1=1 and t_dm.isys='1'";
        sql = addWhclbWhere(gtSwTzQuery, sql, lx, true);

        String statue = gtSwTzQuery.getStatue();
        if(StringUtils.isNotBlank(statue)) {
            if (statue.equals("ybj")) {
                sql = sql + " and t2.BLZT = '1' ";
            } else if (statue.equals("wxf")) {
                sql = sql + " and NVL(t2.BLZT, '0')='0' and t4.ACTIVITY_DEFINITION_ID IS NULL ";
            } else{
                sql = sql + " and NVL(t2.BLZT, '0')='0' and t4.ACTIVITY_DEFINITION_ID = '"+statue+"' ";
            }
        }
        sql = sql  + "ORDER BY t1.scmj DESC";
        if(StringUtils.isNotBlank(ids)){
            String[] idArr=ids.split(",");
            ids="";
            for(String id:idArr){
                ids=ids+",'"+id+"'";
            }
            sql="SELECT * FROM("+sql+") tt WHERE tt.GTBD_ID IN("+ids.substring(1)+")";
        }

        Query query = baseRepository.getEntityManager().createNativeQuery(sql)
                .setParameter("regionCode", regionCode)
                .setParameter("hclx", Hcxmlx.ZDHC.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        return list;
    }

    private String addWhclbWhere(GtSwTzQuery gtSwTzQuery, String sql, String lx, Boolean isOrderBY){
        String where = "";

        if (lx.equals("1"))
            where = where + "and t1.ppzt in ('"+Sjly.ZDPP.toString()+"','"+Sjly.RGPP.toString()+"','"+Sjly.SYHC.toString()+"') ";
        if(StringUtils.isNotBlank(gtSwTzQuery.getDjh()))
            where = where + "and t1.djh like '%"+gtSwTzQuery.getDjh()+"%' ";
        if(StringUtils.isNotBlank(gtSwTzQuery.getQlrmc()))
            where = where + "and t1.qlrmc like '%"+gtSwTzQuery.getQlrmc()+"%' ";
        if(StringUtils.isNotBlank(gtSwTzQuery.getTdzl()))
            where = where + "and t1.tdzl like '%"+gtSwTzQuery.getTdzl()+"%' ";
        if(StringUtils.isNotBlank(gtSwTzQuery.getTdytDm()))
            where = where + "and t1.tdyt_Dm = '"+gtSwTzQuery.getTdytDm()+"' ";
        if(StringUtils.isNotBlank(gtSwTzQuery.getJdDm()))
            where = where + "and t1.djh like '%"+gtSwTzQuery.getJdDm()+"%' ";
        if(StringUtils.isNotBlank(gtSwTzQuery.getIsxf())){
            if (Isxf.YXF.toString().equals(gtSwTzQuery.getIsxf())) {
                where = where + "and t1.blzt is not null ";
            } else if (Isxf.WXF.toString().equals(gtSwTzQuery.getIsxf())) {
                where = where + "and t1.blzt is null ";
            } else if (Isxf.ZDLR.toString().equals(gtSwTzQuery.getIsxf())) {
                where = where + "and t1.blzt is null and t1.ppzt='3' ";
            }
        }

        sql = sql + where;
        return sql;
    }

    private void applyQueryPredicates(GtSwTzQuery gtSwTzQuery,EntityPath entityPath,JPQLQuery jpaQuery,String lx){
        if (lx.equals("1"))
            jpaQuery.where(Expressions.stringPath(entityPath, "ppzt").in(Sjly.ZDPP.toString(), Sjly.RGPP.toString(), Sjly.SYHC.toString()));
        //else
            //jpaQuery.where(Expressions.stringPath(entityPath, "ppzt").isNull().or(Expressions.stringPath(entityPath, "ppzt").notIn(Sjly.ZDPP.toString(), Sjly.RGPP.toString(), Sjly.SYHC.toString())));
        if(StringUtils.isNotBlank(gtSwTzQuery.getDjh()))
            jpaQuery.where(Expressions.stringPath(entityPath,"djh").like(QueryCondition.WILDCARDS + gtSwTzQuery.getDjh()+ QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(gtSwTzQuery.getQlrmc()))
            jpaQuery.where(Expressions.stringPath(entityPath,"qlrmc").like(QueryCondition.WILDCARDS + gtSwTzQuery.getQlrmc()+ QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(gtSwTzQuery.getTdzl()))
            jpaQuery.where(Expressions.stringPath(entityPath,"tdzl").like(QueryCondition.WILDCARDS + gtSwTzQuery.getTdzl()+ QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(gtSwTzQuery.getTdytDm()))
            jpaQuery.where(Expressions.stringPath(entityPath,"tdytDm").eq(gtSwTzQuery.getTdytDm()));
        if(StringUtils.isNotBlank(gtSwTzQuery.getIsxf()) && Isxf.YXF.toString().equals(gtSwTzQuery.getIsxf()))
            jpaQuery.where(Expressions.stringPath(entityPath,"blzt").isNotNull());
        if(StringUtils.isNotBlank(gtSwTzQuery.getIsxf()) && Isxf.WXF.toString().equals(gtSwTzQuery.getIsxf()))
            jpaQuery.where(Expressions.stringPath(entityPath,"blzt").isNull());
        if(StringUtils.isNotBlank(gtSwTzQuery.getIsxf()) && Isxf.ZDLR.toString().equals(gtSwTzQuery.getIsxf()))
            jpaQuery.where(Expressions.stringPath(entityPath,"blzt").isNull()).where(Expressions.stringPath(entityPath,"ppzt").eq("3"));


    }

    @Override
    public String getTddjtzJson(String xzq,StringBuffer listToJson) {
        Boolean firstQuery = false;
        if (xzq == null) {
            xzq = dwxxService.getUserRegionCode();
            if (xzq.length() > 6) {
                xzq = xzq.substring(0, 6);
            }
            firstQuery = true;
        }
        int dmLength = xzq.length();
        int groupLength = dmLength;
        Boolean canSearchChildren = true;
        if (dmLength == 0 || dmLength == 2 || dmLength == 4) {
            groupLength = groupLength + 2;
        }
        else if (dmLength == 6) {
            groupLength = groupLength + 3;
        }
        else if (dmLength == 9) {
            groupLength = groupLength + 3;
            canSearchChildren = false;
        }
        if (firstQuery) {
            groupLength = dmLength;
        }

        String filter = " a.DWDM LIKE '" + xzq + "%' ";
        String tzSql = "SELECT a.DWDM, ZDHJ, (ZDPP + RGPP) AS YPPHJ, ZDPP, RGPP, (ZDHJ - ZDPP - RGPP - HCPP) AS WPP, " +
                        "ROUND((ZDPP + RGPP + HCPP)/ZDHJ*100, 2) AS PPL, DECODE(b.DWMC, NULL, a.DWDM, b.DWMC) AS DWMC, HCPP " +
                        "FROM ( " +
                        "  SELECT SUBSTR(DJH, 1, " + String.valueOf(groupLength) + ") AS DWDM, " +
                        "  COUNT(DJH) AS ZDHJ, SUM(DECODE(PPZT, '1', 1, 0)) AS ZDPP, " +
                        "  SUM(DECODE(PPZT, '2', 1, 0)) AS RGPP, " +
                        "  SUM(DECODE(PPZT, '3', 1, 0)) AS HCPP " +
                        "  FROM (SELECT a.DJH, DECODE(a.PPZT, NULL, b.SJLY, DECODE(b.SJLY, '3', b.SJLY, a.PPZT)) AS PPZT FROM S_SJ_GTBD a " +
                        "    LEFT JOIN (SELECT a.DJH, MAX(b.SJLY) AS SJLY FROM SW_DJ_SY a LEFT JOIN SW_DJ_TD b ON a.SY_ID=b.SY_ID GROUP BY a.DJH) b ON a.DJH=b.DJH) " +
                        "  GROUP BY SUBSTR(DJH, 1, " + String.valueOf(groupLength) + ") " +
                        ") a LEFT JOIN S_DM_DWXX_CZ b ON a.DWDM=b.DWDM " +
                        "WHERE " + filter + " " +
                        "ORDER BY a.DWDM";

        List list =  baseRepository.sql(tzSql);
        return  listToJson(list, listToJson, canSearchChildren);
    }


    public String listToJson(List list, StringBuffer listToJson, Boolean canSearchChildren){
        if (listToJson==null) listToJson = new StringBuffer();
        listToJson.append("[") ;
        UserInfo userInfo = SessionUtil.getCurrentUser();
        String regionCode = userInfo.getRegionCode();

        for(int i=0;i<list.size();i++){
            Object[] object = (Object[]) list.get(i);
            String xzqcode = (String)object[0];
//            if (!xzqcode.startsWith(regionCode))
//                continue;
            if (i>0&&!listToJson.toString().equals("["))
                listToJson.append(",");

            listToJson.append("{");
            String xzqname = (String)object[7];
            if (xzqname!=null && !xzqname.equals("null")){
                listToJson.append("\"name\":\""+object[7]+"\",");
            } else{
                listToJson.append("\"name\":\"\",");
            }
            listToJson.append("\"counts\":\""+object[1]+"\",");
            listToJson.append("\"ppcount\":\""+object[2]+"\",");
            listToJson.append("\"zzpp\":\""+object[3]+"\",");
            listToJson.append("\"rgpp\":\""+object[4]+"\",");
            listToJson.append("\"syhc\":\""+object[8]+"\",");
            listToJson.append("\"wpp\":\""+object[5]+"\",");
            listToJson.append("\"ppl\":\""+object[6]+"\",");
            listToJson.append("\"xzqdm\":\""+object[0]+"\"");

            if (canSearchChildren) {
                listToJson.append(",")  ;
                listToJson.append("\"children\":");
                getTddjtzJson(xzqcode,listToJson);
                listToJson.append("");
            }
            listToJson.append("}");

        }
        listToJson.append("]") ;
        //  System.out.println(listToJson.toString());
        return listToJson.toString() ;
    }

    @Override
    public List<SSjGtbd> findWppxxJsonProject(Pageable pageable,String proid) {
        UserInfo userInfo = SessionUtil.getCurrentUser();
        String regionCode = userInfo.getRegionCode();
        int xzqws=userInfo.getRegionCode().length();
        StringBuffer szbuffer =  new StringBuffer();
        szbuffer.append(" SUBSTR(djh,1,"+xzqws+")='"+regionCode+"'" ) ;
        if (proid!=null && !proid.equals(""))
            szbuffer.append(" and  proid = '"+proid+"'") ;
        QueryCondition queryCondition =   new  QueryCondition(szbuffer.toString());
        List<QueryCondition> queryConditionList = new ArrayList<QueryCondition>();
        queryConditionList.add(queryCondition);
        List<SSjGtbd>  sSjGtbdTempList =   baseRepository.list(SSjGtbd.class,queryConditionList);
        // Page<SSjSwbdTemp> page = baseRepository.find(SSjSwbdTemp.class,queryConditionList,"order by glbm",pageable);
        return sSjGtbdTempList;
    }


    private String createWfInstance(Project project) {
        String userId = SessionUtil.getCurrentUserId();
        IPlatUtil platUtil = (IPlatUtil) Container.getBean("platUtil");
        String taskId = platUtil.createWorkFlowInstance(project, userId,"");
        return taskId;
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public String getProjectGttzJson(String xzq,StringBuffer listToJson) {
        int xzqws=7;   //行政区位数 默认7
        StringBuffer sqlTj = new StringBuffer();
        if (xzq==null){
            UserInfo userInfo = SessionUtil.getCurrentUser();
            String regionCode = userInfo.getRegionCode();
            xzqws=userInfo.getRegionCode().length();
            if (regionCode!=null)
                xzq=regionCode.substring(0,regionCode.length()-2);
        }else{
            xzqws = xzq.length()+2;
        }
        StringBuffer tzBuffer = new StringBuffer();
        tzBuffer.append("select k.djh,(k.wpp+k.ypp) counts,k.ypp,k.wpp,round(k.ypp/(case when  (k.wpp+k.ypp)=0 then 1 else (k.wpp+k.ypp) end)*100,3) ppl,k.xzqname,k.dwjb from(") ;
        tzBuffer.append("select d.djh,(select count(*) from S_SJ_GTBD where SUBSTR(djh,1,"+xzqws+")=d.djh and  BLZT is not null and istx is null) as wpp ,");
        tzBuffer.append("(select count(*) from S_SJ_GTBD where SUBSTR(djh,1,"+xzqws+")=d.djh and  BLZT is not null and istx is not null) as ypp,");
        tzBuffer.append("(select dwmc from S_DM_SWDWXX where trim(0 from dwdm)=d.djh ) as xzqname,")  ;
        tzBuffer.append("(select dwjb from S_DM_SWDWXX where trim(0 from dwdm)=d.djh ) as dwjb")  ;
        tzBuffer.append(" from (select SUBSTR(t.djh,1,"+xzqws+") djh from S_SJ_GTBD t group by SUBSTR(t.djh,1,"+xzqws+") order by SUBSTR(t.djh,1,"+xzqws+")) d)k");
        if (xzq!=null){
            tzBuffer.append(" where SUBSTR(k.djh,1,"+(xzqws-2)+") = "+xzq) ;
        }
        List list =  baseRepository.sql(tzBuffer.toString());
        return          listProjectToJson(list,listToJson);
    }



    public String listProjectToJson(List list,StringBuffer listToJson){
        if (listToJson==null) listToJson = new StringBuffer();
        listToJson.append("[") ;
        UserInfo userInfo = SessionUtil.getCurrentUser();
        String regionCode = userInfo.getRegionCode();

        for(int i=0;i<list.size();i++){
            Object[] object = (Object[]) list.get(i);
            String xzqcode = (String)object[0];
            if (!xzqcode.startsWith(regionCode))
                continue;
            if (i>0&&!listToJson.toString().equals("["))
                listToJson.append(",");
            listToJson.append("{");
            String xzqname = (String)object[5];
            if (xzqname!=null && !xzqname.equals("null")){
                listToJson.append("\"name\":\""+object[5]+"\",");
            } else{
                listToJson.append("\"name\":\"\",");
            }
            listToJson.append("\"counts\":\""+object[1]+"\",");
            listToJson.append("\"ypp\":\""+object[2]+"\",");
            listToJson.append("\"wpp\":\""+object[3]+"\",");
            listToJson.append("\"ppl\":\""+object[4]+"\",");
            listToJson.append("\"xzqdm\":\""+object[0]+"\"");
            if (xzqcode.length()<10) {
                listToJson.append(",")  ;
                listToJson.append("\"children\":");
                getProjectGttzJson(xzqcode,listToJson);
                listToJson.append("");
            }
            listToJson.append("}");
        }
        listToJson.append("]") ;
        return listToJson.toString() ;

    }


    @Override
        public Project getProjectInform() {
        String wwid =AppConfig.getProperty("sszd");
        SysWorkFlowDefineService sysWorkFlowDefineService = (SysWorkFlowDefineService) Container.getBean("SysWorkFlowDefineService");
        PfWorkFlowDefineVo wfDefineVo = sysWorkFlowDefineService.getWorkFlowDefine(wwid);
        Project project = new Project();
        project.setYwlb(wfDefineVo.getBusinessVo().getBusinessName());
        project.setLcmc(wfDefineVo.getWorkflowName());
        project.setProity(wfDefineVo.getPriority());
        project.setDay(wfDefineVo.getTimeLimit() + "");
        UserInfo userInfo = SessionUtil.getCurrentUser();
        project.setJsr(userInfo.getUsername());
        project.setOrgan(userInfo.getLstOragn().get(0).getOrganName());
        project.setCreateTime(simpleDateFormat.format(new Date()));
        return project;
    }


    @Override
    @Transactional(value="oracle_common")
    public void delGtbdProject(String proid) {
        String jpql = "update SSjGtbd set proid=null,istx=null,blzt=null where proid=?0";
        baseRepository.executeJpql(jpql,proid);
    }

}