package cn.gtmap.landtax.service.impl;

import cn.gtmap.landtax.entity.*;
import cn.gtmap.landtax.model.dictionary.*;
import cn.gtmap.landtax.model.query.SbZsQuery;
import cn.gtmap.landtax.model.query.SwDjJbbQuery;
import cn.gtmap.landtax.model.query.SwDjSyQuery;
import cn.gtmap.landtax.model.query.ZdQuery;
import cn.gtmap.landtax.model.query.MjydQuery;
import cn.gtmap.landtax.service.*;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.*;
import cn.gtmap.landtax.util.CommonUtil;
import cn.gtmap.landtax.util.ObjectToBigDecimalUtil;
import cn.gtmap.landtax.util.QueryCondition;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.web.SessionUtil;
import com.mysema.query.jpa.JPASubQuery;
import com.mysema.query.jpa.JPQLQuery;
import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.support.Expressions;
import com.mysema.query.types.*;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import java.lang.reflect.Field;

import com.gtis.config.AppConfig;
import javax.persistence.Query;
import java.math.BigDecimal;
import java.util.*;
import java.text.SimpleDateFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2014/6/27
 */
@Service
public class TaxServiceImpl implements TaxService {


    @Autowired
    BaseRepository baseRepository;
    @Autowired
    private ZdService zdService;
    @Autowired
    private HcxmService hcxmService;
    @Autowired
    private SsjGtbdService ssjGtbdService;
    @Autowired
    DicService dicService;
    @Autowired
    GdzysService gdzysService;
    @Autowired
    SwDjQsService swDjQsService;
    @Autowired
    DwxxService dwxxService;

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public List<SwDjJbb> findAllSwDjJbb() {
        return baseRepository.dslList(QSwDjJbb.swDjJbb);
    }
    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public String getZdmjByDjh(String djh){
        //宗地面积
        String sqlScmj = " select scmj from zd where djh ='"+djh+"'";
        Query zdmjSql = baseRepository.getEntityManager().createNativeQuery(sqlScmj);
        String zdmj ="";
        if(zdmjSql.getResultList().isEmpty()){
        }else{
            zdmj = String.valueOf(zdmjSql.getSingleResult());
        }
        if(zdmj==""){
            zdmj ="0";
        }
        return zdmj;
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public String getScmjByDjh(String djh){
        //税源面积
        String sqlSyzmj = " select sum(scmj) from sw_dj_td t1 left join sw_dj_sy t2 on t1.sy_id = t2.sy_id where t2.djh ='"+djh+"' group by t2.djh ";
        Query syzmjSql =baseRepository.getEntityManager().createNativeQuery(sqlSyzmj);
        String syzmj ="";
        if(syzmjSql.getResultList().isEmpty()){
        }else{
            syzmj = String.valueOf(syzmjSql.getSingleResult());
        }
        if(syzmj==""){
            syzmj ="0";
        }
        return syzmj;
    }


    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public Page<Map<String,Object>> findSwdjSyMap(Pageable pageable) {
        String sql = "select count(*) from view_sw_dj_sy";
        Query countQuery = baseRepository.getEntityManager().createNativeQuery(sql);
        sql = "select t.djh as djh,t.dbh as dbh,t.nsrsbh as nsrsbh,t.nsrmc as nsrmc,t.jbb_id as jbb_id from view_sw_dj_sy t";
        Query query = baseRepository.getEntityManager().createNamedQuery(sql);
        return baseRepository.find(query,countQuery,pageable);
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public Page<SwDjSyQuery> findSwdjTdMap(SwDjSyQuery swDjSyQuery,Pageable pageable) {
        QSwDjGdzys qSwDjGdzys = QSwDjGdzys.swDjGdzys;
        QSwDjQs qSwDjQs = QSwDjQs.swDjQs;
        QSwDjSy qSwDjSy = QSwDjSy.swDjSy;
        QSwDjTd qSwDjTd = QSwDjTd.swDjTd;
        QSwDjFc qSwDjFc = QSwDjFc.swDjFc;
        QSwDjJbb qSwDjJbb = QSwDjJbb.swDjJbb;
        QSwDjXmxx qSwDjXmxx = QSwDjXmxx.swDjXmxx;
            QZd qZd = QZd.zd;

            String regionCode = "";
            try{
                regionCode = SessionUtil.getCurrentUser().getRegionCode();

            }catch (Exception e){}

            JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
            QBean qBean = Projections.bean(SwDjSyQuery.class,qSwDjSy.syId,qSwDjSy.dbh,qSwDjTd.tdId,qSwDjSy.zd.djh,qSwDjJbb.nsrmc,
                    qSwDjFc.fczl,qSwDjFc.fwxzDm,qSwDjTd.tddj,qZd.tdzl,qSwDjTd.scmj,qSwDjTd.msmj,qSwDjTd.ynmj,qSwDjTd.dwse,qSwDjTd.sgztDm,qSwDjTd.sgztMc,qSwDjTd.sjly,qSwDjTd.nynseTd,qSwDjTd.msse,qSwDjTd.typebyzyy,qSwDjTd.confirmhc,qSwDjTd.gtzdbyzyy, qSwDjJbb.nsrsbh,qSwDjJbb.glbm,qSwDjJbb.zgkgMc,qSwDjJbb.sgyMc,qSwDjFc.fcId,qSwDjTd.zdsybz,qSwDjTd.tdsyytDm,qZd.qlrmc,qZd.tdyt,qZd.scmjZd,
                    qSwDjGdzys.gdzysId,qSwDjGdzys.gdzysYnse,qSwDjGdzys.gdzysDwse,qSwDjGdzys.gdzysJmxz,qSwDjGdzys.gdzysJmse,qSwDjGdzys.gdzysJspz,qSwDjGdzys.gdzysYjne,qSwDjGdzys.gdzysXbjse,qSwDjGdzys.gdzysBz,qSwDjGdzys.gdzysLrrq,qSwDjGdzys.gdzysHclx,
                    qSwDjQs.qsId,qSwDjQs.qsSzly,qSwDjQs.qsYnse,qSwDjQs.qsYjne,qSwDjQs.qsJmxz,qSwDjQs.qsJmse,qSwDjQs.qsJspz,qSwDjQs.qsXbjse,qSwDjQs.qsBz,qSwDjQs.qsLrrq,qSwDjQs.qsHclx,qSwDjXmxx.xmId);
            jpaQuery.from(qSwDjTd).leftJoin(qSwDjTd.swDjSy,qSwDjSy).leftJoin(qSwDjTd.swDjJbb,qSwDjJbb).leftJoin(qSwDjSy.swDjFc, qSwDjFc)
                    .leftJoin(qSwDjSy.zd, qZd).leftJoin(qSwDjSy.swDjGdzys,qSwDjGdzys).leftJoin(qSwDjSy.swDjQs, qSwDjQs)
                    .leftJoin(qSwDjSy.swDjXmxx, qSwDjXmxx);
            if(StringUtils.isNotBlank(swDjSyQuery.getDjh()))
                jpaQuery.where(qSwDjSy.zd.djh.like(QueryCondition.WILDCARDS + swDjSyQuery.getDjh() + QueryCondition.WILDCARDS));
            if(StringUtils.isNotBlank(swDjSyQuery.getSyjf()))
                jpaQuery.where(qSwDjSy.zd.djh.like(QueryCondition.WILDCARDS + swDjSyQuery.getSyjf() + QueryCondition.WILDCARDS));
            if(StringUtils.isNotBlank(swDjSyQuery.getSyjd()))
                jpaQuery.where(qSwDjSy.zd.djh.like(QueryCondition.WILDCARDS + swDjSyQuery.getSyjd() + QueryCondition.WILDCARDS));
            if(StringUtils.isNotBlank(swDjSyQuery.getSyqx()))
                jpaQuery.where(qSwDjSy.zd.djh.like(QueryCondition.WILDCARDS + swDjSyQuery.getSyqx() + QueryCondition.WILDCARDS));
            //if(StringUtils.isNotBlank(swDjSyQuery.getXzqdm()))
            //    jpaQuery.where(qSwDjSy.zd.djh.like(swDjSyQuery.getXzqdm() + QueryCondition.WILDCARDS));
            if(StringUtils.isBlank(swDjSyQuery.getSyzt())){
                jpaQuery.where(qSwDjSy.syzt.eq(Syzt.ZC.toString()).or(qSwDjSy.syzt.isNull()).or(qSwDjSy.syzt.eq("")));
            }else{
                jpaQuery.where(qSwDjSy.syzt.eq(swDjSyQuery.getSyzt()).or(qSwDjSy.syzt.eq("")).or(qSwDjSy.syzt.isNull()));
            }
            jpaQuery.where(qSwDjTd.tdId.isNotNull());
            if(swDjSyQuery!=null){
            if(swDjSyQuery.getIsMsTz()!=null && swDjSyQuery.getIsMsTz()){
                jpaQuery.where(qSwDjTd.msmj.isNotNull().and(qSwDjTd.msmj.gt(new BigDecimal(0))));
                jpaQuery.orderBy(qSwDjTd.msmj.desc().nullsLast());
            }else{
                jpaQuery.orderBy(qSwDjTd.nynseTd.desc().nullsLast());
            }
            //是否确认核查无问题
            if(StringUtils.isNotBlank(swDjSyQuery.getConfirmhc())){
                jpaQuery.where(qSwDjTd.confirmhc.eq(swDjSyQuery.getConfirmhc()));
            }
            //数据不一致原因
            if(StringUtils.isNotBlank(swDjSyQuery.getTypebyzyy())){
                jpaQuery.where(qSwDjTd.typebyzyy.eq(swDjSyQuery.getTypebyzyy()));
            }
            //免税性质
            if(StringUtils.isNotBlank(swDjSyQuery.getTdjmxzdm())){
                jpaQuery.where(qSwDjTd.tdjmxzdm.eq(swDjSyQuery.getTdjmxzdm()));
            }
        }
        if("1".equals(swDjSyQuery.getMsbz())){
            jpaQuery.where(qSwDjTd.msbz.eq("1"));
        }else if("2".equals(swDjSyQuery.getMsbz())){
            jpaQuery.where(qSwDjTd.msbz.isNull().or(qSwDjTd.msbz.eq("")));
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getTddj())){
            //String tddj = CommonUtil.reSetTddj(swDjSyQuery.getTddj());
            jpaQuery.where(qSwDjTd.tddj.eq(swDjSyQuery.getTddj()));
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getSgztDm())){
            jpaQuery.where(qSwDjTd.sgztDm.eq(swDjSyQuery.getSgztDm()));
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getSjly())){
            jpaQuery.where(qSwDjTd.sjly.eq(swDjSyQuery.getSjly()));
        }

        if(StringUtils.isNotBlank(swDjSyQuery.getZdsybz())){

            jpaQuery.where(Expressions.stringPath(qSwDjTd,"zdsybz").eq(swDjSyQuery.getZdsybz()));
        }

        if(StringUtils.isNotBlank(regionCode)){
            if (regionCode.length() > 6)
                regionCode = regionCode.substring(0, 6);
            jpaQuery.where(qSwDjJbb.zgkgDm.like("2" + regionCode + QueryCondition.WILDCARDS));
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getGjzt()) && "2".equals(swDjSyQuery.getGjzt())){
            //jpaQuery.where(qZd.djh.notIn(new JPASubQuery().from(qSwDjXmxx).where(qSwDjXmxx.zd.djh.isNotNull()).list(qSwDjXmxx.zd.djh)));
            jpaQuery.where(qZd.djh.isNotNull());
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getNsrsbh())){
            jpaQuery.where(Expressions.stringPath(qSwDjJbb,"nsrsbh").like(QueryCondition.WILDCARDS + swDjSyQuery.getNsrsbh() + QueryCondition.WILDCARDS));}
        applySwDjSyQueryPredicates(swDjSyQuery,qSwDjSy,qSwDjJbb, qSwDjTd,qSwDjFc,qZd,qSwDjXmxx,jpaQuery);
        //jpaQuery.where(qSwDjSy.sysjly.eq(Gtlx.ZD.toString()));

        return baseRepository.find(jpaQuery,qBean,pageable);
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public Page<SwDjSyQuery> findSwdjTdMapInfo(SwDjSyQuery swDjSyQuery,Pageable pageable) {
        QSwDjGdzys qSwDjGdzys = QSwDjGdzys.swDjGdzys;
        QSwDjQs qSwDjQs = QSwDjQs.swDjQs;
        QSwDjSy qSwDjSy = QSwDjSy.swDjSy;
        QSwDjTd qSwDjTd = QSwDjTd.swDjTd;
        QSwDjFc qSwDjFc = QSwDjFc.swDjFc;
        QSwDjJbb qSwDjJbb = QSwDjJbb.swDjJbb;
        QSwDjXmxx qSwDjXmxx = QSwDjXmxx.swDjXmxx;
        QZd qZd = QZd.zd;

        String regionCode = "";
        try{
            regionCode = SessionUtil.getCurrentUser().getRegionCode();

        }catch (Exception e){}

        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        QBean qBean = Projections.bean(SwDjSyQuery.class,qSwDjSy.syId,qSwDjSy.dbh,qSwDjTd.tdId,qSwDjSy.zd.djh,qSwDjJbb.nsrmc,
                qSwDjFc.fczl,qSwDjFc.fwxzDm,qSwDjTd.tddj,qZd.tdzl,qSwDjTd.scmj,qSwDjTd.msmj,qSwDjTd.ynmj,qSwDjTd.dwse,qSwDjTd.sgztDm,qSwDjTd.sgztMc,qSwDjTd.sjly,qSwDjTd.nynseTd,qSwDjTd.msse,qSwDjTd.typebyzyy,qSwDjTd.confirmhc,qSwDjTd.gtzdbyzyy, qSwDjJbb.nsrsbh,qSwDjJbb.glbm,qSwDjJbb.zgkgMc,qSwDjJbb.sgyMc,qSwDjFc.fcId,qSwDjTd.zdsybz,qSwDjTd.tdsyytDm,qZd.qlrmc,qZd.tdyt,qZd.scmjZd,
                qSwDjGdzys.gdzysId,qSwDjGdzys.gdzysYnse,qSwDjGdzys.gdzysDwse,qSwDjGdzys.gdzysJmxz,qSwDjGdzys.gdzysJmse,qSwDjGdzys.gdzysJspz,qSwDjGdzys.gdzysYjne,qSwDjGdzys.gdzysXbjse,qSwDjGdzys.gdzysBz,qSwDjGdzys.gdzysLrrq,qSwDjGdzys.gdzysHclx,
                qSwDjQs.qsId,qSwDjQs.qsSzly,qSwDjQs.qsYnse,qSwDjQs.qsYjne,qSwDjQs.qsJmxz,qSwDjQs.qsJmse,qSwDjQs.qsJspz,qSwDjQs.qsXbjse,qSwDjQs.qsBz,qSwDjQs.qsLrrq,qSwDjQs.qsHclx,qSwDjXmxx.xmId);
        jpaQuery.from(qSwDjTd).leftJoin(qSwDjTd.swDjSy,qSwDjSy).leftJoin(qSwDjTd.swDjJbb,qSwDjJbb).leftJoin(qSwDjSy.swDjFc, qSwDjFc)
                .leftJoin(qSwDjSy.zd, qZd).leftJoin(qSwDjSy.swDjGdzys,qSwDjGdzys).leftJoin(qSwDjSy.swDjQs, qSwDjQs)
                .leftJoin(qSwDjSy.swDjXmxx, qSwDjXmxx);
        if(StringUtils.isNotBlank(swDjSyQuery.getDjh()))
            jpaQuery.where(qSwDjSy.zd.djh.like(QueryCondition.WILDCARDS + swDjSyQuery.getDjh() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(swDjSyQuery.getSyjf()))
            jpaQuery.where(qSwDjSy.zd.djh.like(QueryCondition.WILDCARDS + swDjSyQuery.getSyjf() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(swDjSyQuery.getSyjd()))
            jpaQuery.where(qSwDjSy.zd.djh.like(QueryCondition.WILDCARDS + swDjSyQuery.getSyjd() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(swDjSyQuery.getSyqx()))
            jpaQuery.where(qSwDjSy.zd.djh.like(QueryCondition.WILDCARDS + swDjSyQuery.getSyqx() + QueryCondition.WILDCARDS));
        //if(StringUtils.isNotBlank(swDjSyQuery.getXzqdm()))
        //    jpaQuery.where(qSwDjSy.zd.djh.like(swDjSyQuery.getXzqdm() + QueryCondition.WILDCARDS));
        if(StringUtils.isBlank(swDjSyQuery.getSyzt())){
            jpaQuery.where(qSwDjSy.syzt.eq(Syzt.ZC.toString()).or(qSwDjSy.syzt.isNull()).or(qSwDjSy.syzt.eq("")));
        }else{
            jpaQuery.where(qSwDjSy.syzt.eq(swDjSyQuery.getSyzt()).or(qSwDjSy.syzt.eq("")).or(qSwDjSy.syzt.isNull()));
        }
        jpaQuery.where(qSwDjTd.tdId.isNotNull());
        if(swDjSyQuery!=null){
            if(swDjSyQuery.getIsMsTz()!=null && swDjSyQuery.getIsMsTz()){
                jpaQuery.where(qSwDjTd.msmj.isNotNull().and(qSwDjTd.msmj.gt(new BigDecimal(0))));
                jpaQuery.orderBy(qSwDjTd.msmj.desc().nullsLast());
            }else{
                jpaQuery.orderBy(qSwDjTd.nynseTd.desc().nullsLast());
            }
            //是否确认核查无问题
            if(StringUtils.isNotBlank(swDjSyQuery.getConfirmhc())){
                jpaQuery.where(qSwDjTd.confirmhc.eq(swDjSyQuery.getConfirmhc()));
            }
            //数据不一致原因
            if(StringUtils.isNotBlank(swDjSyQuery.getTypebyzyy())){
                jpaQuery.where(qSwDjTd.typebyzyy.eq(swDjSyQuery.getTypebyzyy()));
            }
            //免税性质
            if(StringUtils.isNotBlank(swDjSyQuery.getTdjmxzdm())){
                jpaQuery.where(qSwDjTd.tdjmxzdm.eq(swDjSyQuery.getTdjmxzdm()));
            }
        }
        if("1".equals(swDjSyQuery.getMsbz())){
            jpaQuery.where(qSwDjTd.msbz.eq("1"));
        }else if("2".equals(swDjSyQuery.getMsbz())){
            jpaQuery.where(qSwDjTd.msbz.isNull().or(qSwDjTd.msbz.eq("")));
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getTddj())){
            //String tddj = CommonUtil.reSetTddj(swDjSyQuery.getTddj());
            jpaQuery.where(qSwDjTd.tddj.eq(swDjSyQuery.getTddj()));
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getSgztDm())){
            jpaQuery.where(qSwDjTd.sgztDm.eq(swDjSyQuery.getSgztDm()));
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getSjly())){
            jpaQuery.where(qSwDjTd.sjly.eq(swDjSyQuery.getSjly()));
        }

        if(StringUtils.isNotBlank(swDjSyQuery.getZdsybz())){

            jpaQuery.where(Expressions.stringPath(qSwDjTd,"zdsybz").eq(swDjSyQuery.getZdsybz()));
        }

        if(StringUtils.isNotBlank(regionCode)){
            if (regionCode.length() > 6)
                regionCode = regionCode.substring(0, 6);
            jpaQuery.where(qSwDjJbb.zgkgDm.like("2" + regionCode + QueryCondition.WILDCARDS));
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getGjzt()) && "2".equals(swDjSyQuery.getGjzt())){
            //jpaQuery.where(qZd.djh.notIn(new JPASubQuery().from(qSwDjXmxx).where(qSwDjXmxx.zd.djh.isNotNull()).list(qSwDjXmxx.zd.djh)));
            jpaQuery.where(qZd.djh.isNotNull());
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getNsrsbh())){
            String str =swDjSyQuery.getNsrsbh();
            Pattern p = Pattern.compile("[\u4e00-\u9fa5]");   //中文字符范围
            Matcher flag = p.matcher(str);
            if(flag.find()){
                jpaQuery.where(Expressions.stringPath(qSwDjJbb,"nsrmc").like(QueryCondition.WILDCARDS + swDjSyQuery.getNsrsbh() + QueryCondition.WILDCARDS));
            }else{
                jpaQuery.where(Expressions.stringPath(qSwDjJbb,"nsrsbh").like(QueryCondition.WILDCARDS + swDjSyQuery.getNsrsbh() + QueryCondition.WILDCARDS));
            }
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getTdzlSy())){
            jpaQuery.where(Expressions.stringPath(qSwDjTd,"tdzl").like(QueryCondition.WILDCARDS + swDjSyQuery.getTdzlSy() + QueryCondition.WILDCARDS));
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getNsrmcSy())){
            jpaQuery.where(Expressions.stringPath(qSwDjJbb,"nsrmc").like(QueryCondition.WILDCARDS + swDjSyQuery.getNsrmcSy() + QueryCondition.WILDCARDS));
        }
        applySwDjSyQueryPredicates(swDjSyQuery,qSwDjSy,qSwDjJbb, qSwDjTd,qSwDjFc,qZd,qSwDjXmxx,jpaQuery);
        //jpaQuery.where(qSwDjSy.sysjly.eq(Gtlx.ZD.toString()));

        return baseRepository.find(jpaQuery,qBean,pageable);
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public Page<SwDjSyQuery> findSwdjFcMap(SwDjSyQuery swDjSyQuery,Pageable pageable) {
        QSwDjGdzys qSwDjGdzys = QSwDjGdzys.swDjGdzys;
        QSwDjQs qSwDjQs = QSwDjQs.swDjQs;
        QSwDjSy qSwDjSy = QSwDjSy.swDjSy;
        QSwDjTd qSwDjTd = QSwDjTd.swDjTd;
        QSwDjFc qSwDjFc = QSwDjFc.swDjFc;
        QSwDjXmxx qSwDjXmxx = QSwDjXmxx.swDjXmxx;
        QZd qZd = QZd.zd;
        QSwDjJbb qSwDjJbb = QSwDjJbb.swDjJbb;


        String regionCode = "";
        try{
            regionCode = SessionUtil.getCurrentUser().getRegionCode();
        }catch (Exception e){}

        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        QBean qBean = Projections.bean(SwDjSyQuery.class,qSwDjSy.syId,qSwDjSy.dbh,qSwDjTd.tdId,qSwDjSy.zd.djh,qSwDjJbb.nsrmc,
                qSwDjFc.fczl,qSwDjFc.fcyz,qSwDjFc.fcyzYs,qSwDjFc.fcyzMs,qSwDjFc.ynseZy,qSwDjFc.nzj,qSwDjFc.sl,qSwDjFc.ynseCz,qSwDjFc.nynseFc,qSwDjFc.fwxzDm,qSwDjTd.tddj,qSwDjTd.tdzl,qSwDjTd.scmj,qSwDjJbb.glbm,qSwDjJbb.nsrsbh,qSwDjJbb.zgkgMc,qSwDjJbb.sgyMc,qSwDjFc.sgztDm,qSwDjFc.sgztMc,qSwDjFc.sjly,qSwDjFc.fcId,qSwDjFc.zdsybz,qZd.qlrmc,qZd.tdyt,
                qSwDjGdzys.gdzysId,qSwDjGdzys.gdzysYnse,qSwDjGdzys.gdzysDwse,qSwDjGdzys.gdzysJmxz,qSwDjGdzys.gdzysJmse,qSwDjGdzys.gdzysJspz,qSwDjGdzys.gdzysYjne,qSwDjGdzys.gdzysXbjse,qSwDjGdzys.gdzysBz,qSwDjGdzys.gdzysLrrq,qSwDjGdzys.gdzysHclx,
                qSwDjQs.qsId,qSwDjQs.qsSzly,qSwDjQs.qsYnse,qSwDjQs.qsYjne,qSwDjQs.qsJmxz,qSwDjQs.qsJmse,qSwDjQs.qsJspz,qSwDjQs.qsXbjse,qSwDjQs.qsBz,qSwDjQs.qsLrrq,qSwDjQs.qsHclx,qSwDjXmxx.xmId);
        jpaQuery.from(qSwDjFc).leftJoin(qSwDjFc.swDjSy,qSwDjSy).leftJoin(qSwDjFc.swDjJbb,qSwDjJbb).leftJoin(qSwDjSy.swDjTd,qSwDjTd).leftJoin(qSwDjSy.zd,qZd).leftJoin(qSwDjSy.swDjGdzys,qSwDjGdzys).leftJoin(qSwDjSy.swDjQs, qSwDjQs).leftJoin(qSwDjSy.swDjXmxx, qSwDjXmxx);
        if(StringUtils.isNotBlank(swDjSyQuery.getDjh()))
            jpaQuery.where(qSwDjSy.zd.djh.like(QueryCondition.WILDCARDS + swDjSyQuery.getDjh() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(swDjSyQuery.getXzqdm()))
            jpaQuery.where(qSwDjSy.zd.djh.like(swDjSyQuery.getXzqdm() + QueryCondition.WILDCARDS));
        if(StringUtils.isBlank(swDjSyQuery.getSyzt())){
            jpaQuery.where(qSwDjSy.syzt.eq(Syzt.ZC.toString()).or(qSwDjSy.syzt.isNull()).or(qSwDjSy.syzt.eq("")));
        }else{
            jpaQuery.where(qSwDjSy.syzt.eq(swDjSyQuery.getSyzt()).or(qSwDjSy.syzt.eq("")).or(qSwDjSy.syzt.isNull()));
        }
        jpaQuery.where(qSwDjFc.fcId.isNotNull());
        if(swDjSyQuery!=null){
            if(swDjSyQuery.getIsMsTz()!=null && swDjSyQuery.getIsMsTz()){
                jpaQuery.where(qSwDjFc.fcyzMs.isNotNull().and(qSwDjFc.fcyzMs.gt(new BigDecimal(0))));
                jpaQuery.orderBy(qSwDjFc.fcyzMs.desc().nullsLast());
            }else{
                jpaQuery.orderBy(qSwDjFc.nynseFc.desc().nullsLast());
            }
        }
        if("1".equals(swDjSyQuery.getMsbz())){
            jpaQuery.where(qSwDjFc.msbz.eq("1"));
        }else if("2".equals(swDjSyQuery.getMsbz())){
            jpaQuery.where(qSwDjFc.msbz.isNull().or(qSwDjFc.msbz.eq("")));
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getSgztDm())){
            jpaQuery.where(qSwDjFc.sgztDm.eq(swDjSyQuery.getSgztDm()));
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getSjly())){
            jpaQuery.where(qSwDjFc.sjly.eq(swDjSyQuery.getSjly()));
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getZdsybz())){
            jpaQuery.where(Expressions.stringPath(qSwDjFc,"zdsybz").eq(swDjSyQuery.getZdsybz()));
        }
        if(StringUtils.isNotBlank(regionCode)){
            jpaQuery.where(qSwDjJbb.zgkgDm.like("2" + regionCode + QueryCondition.WILDCARDS));
        }

        applySwDjSyQueryPredicates(swDjSyQuery,qSwDjSy,qSwDjJbb, qSwDjTd,qSwDjFc,qZd,qSwDjXmxx,jpaQuery);
        //jpaQuery.where(qSwDjSy.sysjly.eq(Gtlx.ZD.toString()));

        Page page = baseRepository.find(jpaQuery,qBean,pageable);

        return page;
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public Page<SwDjSyQuery> findLzlghTd(SwDjSyQuery swDjSyQuery,Sgzt sgzt, Pageable pageable) {
        QSwDjSy qSwDjSy = QSwDjSy.swDjSy;
        QSwDjTd qSwDjTd = QSwDjTd.swDjTd;
        QSwDjJbb qSwDjJbb = QSwDjJbb.swDjJbb;
        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        QBean qBean = Projections.bean(SwDjSyQuery.class,qSwDjSy.zd.djh,qSwDjSy.dbh,qSwDjJbb.glbm,qSwDjJbb.nsrsbh,qSwDjJbb.nsrmc, qSwDjTd.tdzl,
                qSwDjTd.czrmc,qSwDjTd.czrzjhm,qSwDjTd.tdsyztDm,qSwDjTd.fzmj,qSwDjTd.scmj,qSwDjTd.tddj,qSwDjTd.msmj,
                qSwDjTd.ynmj,qSwDjTd.dwse,qSwDjTd.nynseTd);
        jpaQuery.from(qSwDjTd).leftJoin(qSwDjTd.swDjSy,qSwDjSy).leftJoin(qSwDjTd.swDjJbb,qSwDjJbb);
        Predicate djhPredicate = StringUtils.isNotBlank(swDjSyQuery.getDjh())?qSwDjSy.zd.djh.like(QueryCondition.WILDCARDS + swDjSyQuery.getDjh() + QueryCondition.WILDCARDS):null;
        Predicate glbmPredicate = StringUtils.isNotBlank(swDjSyQuery.getGlbm())?qSwDjJbb.glbm.like(QueryCondition.WILDCARDS + swDjSyQuery.getGlbm() + QueryCondition.WILDCARDS):null;
        Predicate nsrsbhPredicate = StringUtils.isNotBlank(swDjSyQuery.getNsrsbh())?qSwDjJbb.nsrsbh.like(QueryCondition.WILDCARDS + swDjSyQuery.getNsrsbh() + QueryCondition.WILDCARDS):null;
        Predicate dbhPredicate = StringUtils.isNotBlank(swDjSyQuery.getDbh())?qSwDjSy.dbh.like(QueryCondition.WILDCARDS + swDjSyQuery.getDbh() + QueryCondition.WILDCARDS):null;
        Predicate nsrmcPredicate = StringUtils.isNotBlank(swDjSyQuery.getNsrmc())?qSwDjJbb.nsrmc.like(QueryCondition.WILDCARDS + swDjSyQuery.getNsrmc() + QueryCondition.WILDCARDS):null;
        Predicate czrmcPredicate = StringUtils.isNotBlank(swDjSyQuery.getCzrmc())?qSwDjTd.czrmc.like(QueryCondition.WILDCARDS + swDjSyQuery.getCzrmc() + QueryCondition.WILDCARDS):null;
        jpaQuery.where(djhPredicate,glbmPredicate,nsrsbhPredicate,dbhPredicate,nsrmcPredicate,czrmcPredicate);
        jpaQuery.where(qSwDjTd.sgztDm.eq(sgzt.toString()));
        return baseRepository.find(jpaQuery,qBean,pageable);
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public Page<SwDjSyQuery> findLzlghFc(SwDjSyQuery swDjSyQuery, Sgzt sgzt, Pageable pageable) {
        QSwDjSy qSwDjSy = QSwDjSy.swDjSy;
        QSwDjFc qSwDjFc = QSwDjFc.swDjFc;
        QSwDjJbb qSwDjJbb = QSwDjJbb.swDjJbb;
        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        QBean qBean = Projections.bean(SwDjSyQuery.class,qSwDjSy.zd.djh,qSwDjSy.dbh,qSwDjJbb.glbm,qSwDjJbb.nsrsbh,qSwDjJbb.nsrmc,
                qSwDjFc.czrmcFc,qSwDjFc.czrzjhmFc,qSwDjFc.fczh,qSwDjFc.fcmj,qSwDjFc.fwxzDm,qSwDjFc.zyhczDm,qSwDjFc.fwjz,
                qSwDjFc.tdjz,qSwDjFc.fssbjz,qSwDjFc.fcyz,qSwDjFc.fcyzYs,qSwDjFc.fcyzMs,qSwDjFc.ynseZy,qSwDjFc.ynseCz,
                qSwDjFc.nzj,qSwDjFc.nynseFc);
        jpaQuery.from(qSwDjFc).leftJoin(qSwDjFc.swDjSy,qSwDjSy).leftJoin(qSwDjFc.swDjJbb,qSwDjJbb);
        Predicate djhPredicate = StringUtils.isNotBlank(swDjSyQuery.getDjh())?qSwDjSy.zd.djh.like(QueryCondition.WILDCARDS + swDjSyQuery.getDjh() + QueryCondition.WILDCARDS):null;
        Predicate glbmPredicate = StringUtils.isNotBlank(swDjSyQuery.getGlbm())?qSwDjJbb.glbm.like(QueryCondition.WILDCARDS + swDjSyQuery.getGlbm() + QueryCondition.WILDCARDS):null;
        Predicate nsrsbhPredicate = StringUtils.isNotBlank(swDjSyQuery.getNsrsbh())?qSwDjJbb.nsrsbh.like(QueryCondition.WILDCARDS + swDjSyQuery.getNsrsbh() + QueryCondition.WILDCARDS):null;
        Predicate dbhPredicate = StringUtils.isNotBlank(swDjSyQuery.getDbh())?qSwDjSy.dbh.like(QueryCondition.WILDCARDS + swDjSyQuery.getDbh() + QueryCondition.WILDCARDS):null;
        Predicate nsrmcPredicate = StringUtils.isNotBlank(swDjSyQuery.getNsrmc())?qSwDjJbb.nsrmc.like(QueryCondition.WILDCARDS + swDjSyQuery.getNsrmc() + QueryCondition.WILDCARDS):null;
        Predicate czrmcPredicate = StringUtils.isNotBlank(swDjSyQuery.getCzrmc())?qSwDjFc.czrmcFc.like(QueryCondition.WILDCARDS + swDjSyQuery.getCzrmc() + QueryCondition.WILDCARDS):null;
        Predicate fczhPredicate = StringUtils.isNotBlank(swDjSyQuery.getFczh())?qSwDjFc.fczh.like(QueryCondition.WILDCARDS + swDjSyQuery.getFczh() + QueryCondition.WILDCARDS):null;
        jpaQuery.where(djhPredicate,glbmPredicate,nsrsbhPredicate,dbhPredicate,nsrmcPredicate,czrmcPredicate,fczhPredicate);
        jpaQuery.where(qSwDjFc.sgztDm.eq(sgzt.toString()));
        return baseRepository.find(jpaQuery,qBean,pageable);
    }

    @Override
     @Transactional(value="oracle_common",readOnly = true)
     public Page findZdsyTd(SwDjSyQuery swDjSyQuery, Pageable pageable,String sort,String dir,String beginPm,String endPm) {

        String sql ="select t.*,rownum as pm from( " +
                "select t2.djh,t2.dbh,t3.nsrsbh,t3.nsrmc,t3.zgkg_mc,t3.zgkg_dm,t3.sgy_mc, to_char(t4.tdzl)tdzl,t1.scmj, t1.ynmj,t1.msmj,t1.nynse, t1.td_id,t1.zdsybz ,t3.hy_dm,t3.zclx_dm,rank() over(order by nvl(t1.nynse, 0) desc) as spm " +
                "from sw_dj_td t1 join sw_dj_sy t2 on t1.sy_id=t2.sy_id  " +
                "left join sw_dj_jbb t3 on t1.jbb_id=t3.jbb_id   " +
                "left join zd t4 on t4.djh=t2.djh "+
                "where ( t3.zgkg_dm like '2"+SessionUtil.getCurrentUser().getRegionCode()+"%' and "+"(t2.syzt is null or t2.syzt='1') ))t where  1=1 ";
        sql = addParameter(swDjSyQuery,sql,beginPm,endPm,"1");
        if(StringUtils.isNotBlank(sort) && StringUtils.isNotBlank(dir)){
            sql += " order by nvl("+sort+",0) "+dir;
        }
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        String countSql = "select count(*) from (";
        countSql += sql;
        countSql +=")";
        Query countQuery = baseRepository.getEntityManager().createNativeQuery(countSql);
        Page page =  baseRepository.find(query, countQuery, pageable);
        return page;
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public Page findMjydTd(MjydQuery mjydQuery, Pageable pageable) {

        String sql ="select djh,nsrsbh,nsrmc,tdzl,mj_zd,mjce_q,mjce_z,mj_q,mj_z,scsj,xcsj,bgsj,zgswjmc,zt,sy_id,td_id from s_yd_mj where 1=1 ";
               // "where ( t4.sgqdm like '"+SessionUtil.getCurrentUser().getRegionCode()+"%' and "+"t2.syzt is null or t2.syzt='1' ))t where  1=1 ";
        sql = addParameterMjyd(mjydQuery, sql);
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        String countSql = "select count(*) from (";
        countSql += sql;
        countSql +=")";
        Query countQuery = baseRepository.getEntityManager().createNativeQuery(countSql);
        Page page =  baseRepository.find(query, countQuery, pageable);
        return page;
    }

    @Override
    @Transactional(readOnly = true)
    public List findMjydTdForExp(HashMap param) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        Object obj = param.get("ids");
        MjydQuery mjydQuery = (MjydQuery) param.get("mjydQuery");
        String sql=getMjydSql(param);

        if(obj==null) {//导出全部
            //筛选税源
            sql = addParameterMjyd(mjydQuery,sql);
        }else{//checkbox导出
            String resultIds = "";
            String ids = String.valueOf(obj);
            String[] idsArr = ids.split(",");
            for(int i=0;i<idsArr.length;i++){
                if(i==idsArr.length-1){
                    resultIds = resultIds+"'"+idsArr[i]+"'";
                }else{
                    resultIds = resultIds+"'"+idsArr[i]+"'"+",";
                }
            }
            sql = sql + " and td_id in("+resultIds+")";
        }
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        return list;
    }
    private String getMjydSql(HashMap param){
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        String sql=" select djh,nsrsbh,nsrmc,tdzl,mj_zd,mjce_q,mjce_z,mj_q,mj_z,scsj,xcsj,bgsj,zgswjmc, ( CASE zt WHEN '01' THEN '未消除' ELSE '已消除' END ) as zt,sy_id,td_id from s_yd_mj where 1=1 ";
        return sql;
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public Page findZdsyGdzys(SwDjSyQuery swDjSyQuery, Pageable pageable,String sort,String dir,String beginPm,String endPm) {

        String sql ="select t.*,rownum as pm from( " +
                "select t3.nsrsbh,t3.nsrmc,t3.zgkg_mc,t3.zgkg_dm,t3.sgy_mc,t3.hy_dm,t3.zclx_dm," +
                "t1.zdsybz ,rank() over(order by nvl(t1.ynse, 0) desc) as spm, " +
                "t1.gdzys_id,t1.ynse,t1.dwse,t1.jmse," +
                "t4.pcmc " +
                "from sw_dj_gdzys t1 join sw_dj_sy t2 on t1.sy_id=t2.sy_id  " +
                "left join sw_dj_jbb t3 on t1.jbb_id=t3.jbb_id   " +
                "left join sw_dj_pcxx t4 on t4.pc_id=t2.bp_id "+
                "where ( t4.pc_id is not null and "+"t2.syzt is null or t2.syzt='1' ))t where  1=1 ";
        sql = addParameter(swDjSyQuery,sql,beginPm,endPm,"3");
        if(StringUtils.isNotBlank(sort) && StringUtils.isNotBlank(dir)){
            sql += " order by nvl("+sort+",0) "+dir;
        }
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        String countSql = "select count(*) from (";
        countSql += sql;
        countSql +=")";
        Query countQuery = baseRepository.getEntityManager().createNativeQuery(countSql);
        Page page =  baseRepository.find(query, countQuery, pageable);
        return page;
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public Page findZdsyQs(SwDjSyQuery swDjSyQuery, Pageable pageable,String sort,String dir,String beginPm,String endPm) {

        String sql ="select t.*,rownum as pm from( " +
                "select t3.nsrsbh,t3.nsrmc,t3.zgkg_mc,t3.zgkg_dm,t3.sgy_mc,t3.hy_dm,t3.zclx_dm," +
                "t1.zdsybz ,rank() over(order by nvl(t1.ynse, 0) desc) as spm, " +
                "t1.qs_id,t1.ynse,t1.yjne,t1.xbjse," +
                "t4.xmmc,t4.tdzl,t4.gdmj,t4.qdjg " +
                "from sw_dj_qs t1 join sw_dj_sy t2 on t1.sy_id=t2.sy_id  " +
                "left join sw_dj_jbb t3 on t1.jbb_id=t3.jbb_id   " +
                "left join sw_dj_xmxx t4 on t4.xm_id=t2.gd_id "+
                "where ( t4.xm_id is not null and "+"t2.syzt is null or t2.syzt='1' ))t where  1=1 ";
        sql = addParameter(swDjSyQuery,sql,beginPm,endPm,"4");
        if(StringUtils.isNotBlank(sort) && StringUtils.isNotBlank(dir)){
            sql += " order by nvl("+sort+",0) "+dir;
        }
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        String countSql = "select count(*) from (";
        countSql += sql;
        countSql +=")";
        Query countQuery = baseRepository.getEntityManager().createNativeQuery(countSql);
        Page page =  baseRepository.find(query, countQuery, pageable);
        return page;
    }

    private String addParameter(SwDjSyQuery swDjSyQuery,String sql,String beginPm,String endPm,String sylx){

        if(StringUtils.isNotBlank(swDjSyQuery.getDjh())){
            sql += " and t.djh like '"+swDjSyQuery.getDjh()+"%'";
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getNsrmc())){
            sql += " and t.nsrmc like '%"+swDjSyQuery.getNsrmc()+"%'";
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getQx())){
            sql += " and t.zgkg_dm like '2"+swDjSyQuery.getQx()+"%'";
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getZgkgDm())){
            sql += " and t.zgkg_dm ='"+swDjSyQuery.getZgkgDm()+"'";
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getZclxDm())){
            sql += " and t.zclx_dm ='"+swDjSyQuery.getZclxDm()+"'";
        }
        //添加行业类型支持小类的查询条件
        if(StringUtils.isNotBlank(swDjSyQuery.getHyDm())){
            sql += " and t.hy_dm like'"+swDjSyQuery.getHyDm()+"%'";
        }
        if(swDjSyQuery.getNynseTdBegin()!=null){
            if(Sylx.TDSY.toString().equals(sylx)||Sylx.FCSY.toString().equals(sylx)){
                sql += " and t.nynse >="+swDjSyQuery.getNynseTdBegin();
            }else if(Sylx.GDZYS.toString().equals(sylx)||Sylx.QS.toString().equals(sylx)){
                sql += " and t.ynse >="+swDjSyQuery.getNynseTdBegin();
            }
        }
        if(swDjSyQuery.getNynseTdEnd()!=null){
            if(Sylx.TDSY.toString().equals(sylx)||Sylx.FCSY.toString().equals(sylx)){
                sql += " and t.nynse <="+swDjSyQuery.getNynseTdEnd();
            }else if(Sylx.GDZYS.toString().equals(sylx)||Sylx.QS.toString().equals(sylx)){
                sql += " and t.ynse <="+swDjSyQuery.getNynseTdBegin();
            }
        }
        if(swDjSyQuery.getNynseFcBegin()!=null){
            sql += " and t.nynse >="+swDjSyQuery.getNynseFcBegin();
        }
        if(swDjSyQuery.getNynseFcEnd()!=null){
            sql += " and t.nynse <="+swDjSyQuery.getNynseFcEnd();
        }
        if(StringUtils.isNotBlank(beginPm)){
            sql += " and t.spm >="+beginPm;
        }
        if(StringUtils.isNotBlank(endPm)){
            sql += " and t.spm <="+endPm;
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getZdsybz())){
            if("1".equals(swDjSyQuery.getZdsybz())){
                sql += " and t.zdsybz='1'";
            }else if("2".equals(swDjSyQuery.getZdsybz())){
                sql += " and t.zdsybz is null";
            }
        }
        String regionCode = "";
//        try{
//            regionCode = SessionUtil.getCurrentUser().getRegionCode();
//        }catch (Exception e){}
//        if(StringUtils.isNotBlank(regionCode)){
//            sql += " and t.zgkg_dm like '2"+regionCode+"%' ";
//        }
        if(StringUtils.isNotBlank(swDjSyQuery.getExcelBegin()) && StringUtils.isNotBlank(swDjSyQuery.getExcelEnd())){
            Integer begin = Integer.parseInt(swDjSyQuery.getExcelBegin());
            Integer end = Integer.parseInt(swDjSyQuery.getExcelEnd());
            sql +=" and rownum>="+begin+" and rownum<="+end+" ";
        }

        if(StringUtils.isNotBlank(swDjSyQuery.getNsrsbh())){
            sql += " and t.nsrsbh like '%"+swDjSyQuery.getNsrsbh()+"%' ";
        }

        return sql;
    }

    private String addParameterMjyd(MjydQuery mjydQuery,String sql){

        if(StringUtils.isNotBlank(mjydQuery.getDjh())){
            sql += " and djh like '"+mjydQuery.getDjh()+"%'";
        }
        if(StringUtils.isNotBlank(mjydQuery.getNsrmc())){
            sql += " and nsrmc like '%"+mjydQuery.getNsrmc()+"%'";
        }
        if(StringUtils.isNotBlank(mjydQuery.getZgswjdm())){
            sql += " and zgswjdm like '2"+mjydQuery.getZgswjdm()+"%'";
        }
        if(StringUtils.isNotBlank(mjydQuery.getNsrsbh())){
            sql += " and nsrsbh ='"+mjydQuery.getNsrsbh()+"'";
        }
        if(StringUtils.isNotBlank(mjydQuery.getTdzl())){
            sql += " and tdzl like'%"+mjydQuery.getTdzl()+"%'";
        }
        if(StringUtils.isNotBlank(mjydQuery.getZt())){
            sql += " and zt like'"+mjydQuery.getZt()+"'";
        }

        if(StringUtils.isNotBlank(mjydQuery.getScsj_q()) || StringUtils.isNotBlank(mjydQuery.getBgsj_z())){
            sql += " and to_date('"+mjydQuery.getScsj_q()+"','yyyy-MM-dd')<= scsj and scsj<= to_date('"+mjydQuery.getBgsj_z()+"','yyyy-MM-dd')";
        }
        if(StringUtils.isNotBlank(mjydQuery.getXcsj_q()) || StringUtils.isNotBlank(mjydQuery.getXcsj_q())){
            sql += " and to_date('"+mjydQuery.getXcsj_q()+"','yyyy-MM-dd')<= scsj and scsj<= to_date('"+mjydQuery.getXcsj_z()+"','yyyy-MM-dd')";
        }

        if((StringUtils.isNotBlank(mjydQuery.getMjce_q_min()))&&(StringUtils.isNotBlank(mjydQuery.getMjce_q_max()))){
            sql = sql + " and mjce_q between "+mjydQuery.getMjce_q_min()+" and "+mjydQuery.getMjce_q_max();
        }
        if((StringUtils.isBlank(mjydQuery.getMjce_q_min()))&&(StringUtils.isNotBlank(mjydQuery.getMjce_q_max()))){
            sql = sql + " and mjce_q  between 0 and "+mjydQuery.getMjce_q_max();
        }
        if((StringUtils.isNotBlank(mjydQuery.getMjce_q_min()))&&(StringUtils.isBlank(mjydQuery.getMjce_q_max()))){
            sql = sql + " and  "+mjydQuery.getMjce_q_min()+" <= mjce_q";
        }

        if((StringUtils.isNotBlank(mjydQuery.getMjce_z_min()))&&(StringUtils.isNotBlank(mjydQuery.getMjce_z_max()))){
            sql = sql + " and mjce_z between "+mjydQuery.getMjce_z_min()+" and "+mjydQuery.getMjce_z_max();
        }
        if((StringUtils.isBlank(mjydQuery.getMjce_z_min()))&&(StringUtils.isNotBlank(mjydQuery.getMjce_z_max()))){
            sql = sql + " and mjce_z  between 0 and "+mjydQuery.getMjce_z_max();
        }
        if((StringUtils.isNotBlank(mjydQuery.getMjce_z_min()))&&(StringUtils.isBlank(mjydQuery.getMjce_z_max()))){
            sql = sql + " and "+mjydQuery.getMjce_z_min()+" <= mjce_z";
        }



        if((StringUtils.isNotBlank(mjydQuery.getMj_q_min()))&&(StringUtils.isNotBlank(mjydQuery.getMj_q_max()))){
            sql = sql + " and mj_q between "+mjydQuery.getMj_q_min()+" and "+mjydQuery.getMj_q_max();
        }
        if((StringUtils.isBlank(mjydQuery.getMj_q_min()))&&(StringUtils.isNotBlank(mjydQuery.getMj_q_max()))){
            sql = sql + " and mj_q  between 0 and "+mjydQuery.getMj_q_max();
        }
        if((StringUtils.isNotBlank(mjydQuery.getMj_q_min()))&&(StringUtils.isBlank(mjydQuery.getMj_q_max()))){
            sql = sql + " and  "+mjydQuery.getMj_q_min()+" <= mj_q";
        }

        if((StringUtils.isNotBlank(mjydQuery.getMj_z_min()))&&(StringUtils.isNotBlank(mjydQuery.getMj_z_max()))){
            sql = sql + " and mj_z between "+mjydQuery.getMj_z_min()+" and "+mjydQuery.getMj_z_max();
        }
        if((StringUtils.isBlank(mjydQuery.getMj_z_min()))&&(StringUtils.isNotBlank(mjydQuery.getMj_z_max()))){
            sql = sql + " and mj_z  between 0 and "+mjydQuery.getMj_z_max();
        }
        if((StringUtils.isNotBlank(mjydQuery.getMj_z_min()))&&(StringUtils.isBlank(mjydQuery.getMj_z_max()))){
            sql = sql + " and  "+mjydQuery.getMj_z_min()+" <= mj_z";
        }

//        if(StringUtils.isNotBlank(swDjSyQuery.getExcelBegin()) && StringUtils.isNotBlank(swDjSyQuery.getExcelEnd())){
//            Integer begin = Integer.parseInt(swDjSyQuery.getExcelBegin());
//            Integer end = Integer.parseInt(swDjSyQuery.getExcelEnd());
//            sql +=" and rownum>="+begin+" and rownum<="+end+" ";
//        }

        return sql;
    } 
    
    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public Page<SwDjSyQuery> findZdsyFc(SwDjSyQuery swDjSyQuery, Pageable pageable,String sort,String dir,String beginPm,String endPm) {
//        QSwDjSy qSwDjSy = QSwDjSy.swDjSy;
//        QSwDjFc qSwDjFc = QSwDjFc.swDjFc;
//        QSwDjJbb qSwDjJbb = QSwDjJbb.swDjJbb;
//        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
//        QBean qBean = Projections.bean(SwDjFc.class,qSwDjSy.zd.djh,qSwDjSy.dbh,qSwDjJbb.glbm,qSwDjJbb.nsrmc,
//                qSwDjFc.czrmc,qSwDjFc.czrzjhm,qSwDjFc.fczh,qSwDjFc.fcmj,qSwDjFc.fwxzDm,qSwDjFc.zyhczDm,qSwDjFc.fwjz,
//                qSwDjFc.tdjz,qSwDjFc.fssbjz,qSwDjFc.fcyz,qSwDjFc.fcyzYs,qSwDjFc.fcyzMs,qSwDjFc.ynseZy,qSwDjFc.ynseCz,
//                qSwDjFc.nzj,qSwDjFc.nynseFc);
//        Predicate djhPredicate = StringUtils.isNotBlank(swDjSyQuery.getDjh())?qSwDjFc.swDjSy.zd.djh.like(QueryCondition.WILDCARDS + swDjSyQuery.getDjh() + QueryCondition.WILDCARDS):null;
//        Predicate glbmPredicate = StringUtils.isNotBlank(swDjSyQuery.getGlbm())?qSwDjFc.swDjJbb.glbm.like(QueryCondition.WILDCARDS + swDjSyQuery.getGlbm() + QueryCondition.WILDCARDS):null;
//        Predicate dbhPredicate = StringUtils.isNotBlank(swDjSyQuery.getDbh())?qSwDjFc.swDjSy.dbh.like(QueryCondition.WILDCARDS + swDjSyQuery.getDbh() + QueryCondition.WILDCARDS):null;
//        Predicate nsrmcPredicate = StringUtils.isNotBlank(swDjSyQuery.getNsrmc())?qSwDjFc.swDjJbb.nsrmc.like(QueryCondition.WILDCARDS + swDjSyQuery.getNsrmc() + QueryCondition.WILDCARDS):null;
//        Predicate czrmcPredicate = StringUtils.isNotBlank(swDjSyQuery.getCzrmc())?qSwDjFc.czrmc.like(QueryCondition.WILDCARDS + swDjSyQuery.getCzrmc() + QueryCondition.WILDCARDS):null;
//        Predicate fczhPredicate = StringUtils.isNotBlank(swDjSyQuery.getFczh())?qSwDjFc.fczh.like(QueryCondition.WILDCARDS + swDjSyQuery.getFczh() + QueryCondition.WILDCARDS):null;
//        jpaQuery.where(djhPredicate,glbmPredicate,dbhPredicate,nsrmcPredicate,czrmcPredicate,fczhPredicate);
//        jpaQuery.where(qSwDjFc.zdsybz.eq("1"));
//        return baseRepository.find(jpaQuery,qBean,pageable);
        String sql ="select t.*,rownum as pm from ("+
                "select t2.djh,t2.dbh,t3.nsrsbh,t3.nsrmc,t3.zgkg_mc,t3.zgkg_dm,t3.sgy_mc,t1.fczl,t1.fcmj,t1.fcyz_ys,t1.fcyz_ms,t1.nzj,t1.nynse,t1.fc_id,t1.zdsybz,t3.hy_dm,t3.zclx_dm,rank() over(order by nvl(t1.nynse,0) desc) as spm " +
                " from sw_dj_fc t1" +
                " left join sw_dj_sy t2" +
                " on t1.sy_id=t2.sy_id" +
                " left join  sw_dj_jbb t3" +
                " on t1.jbb_id=t3.jbb_id "+
                " where (t2.syzt is null or t2.syzt='1'))t "+
                " where 1=1 ";
        sql = addParameter(swDjSyQuery,sql,beginPm,endPm,"2");
        if(StringUtils.isNotBlank(sort) && StringUtils.isNotBlank(dir)){
            sql += " order by nvl("+sort+",0) "+dir;
        }
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        String countSql = "select count(*) from (";
        countSql += sql;
        countSql +=")";
        Query countQuery = baseRepository.getEntityManager().createNativeQuery(countSql);
        Page page =  baseRepository.find(query, countQuery, pageable);
        return page;
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public SwDjSyQuery getSwDjSyById(String tdId, String fcId) {
        QSwDjSy qSwDjSy = QSwDjSy.swDjSy;
        QSwDjTd qSwDjTd = QSwDjTd.swDjTd;
        QSwDjFc qSwDjFc = QSwDjFc.swDjFc;
        QSwDjGdzys qSwDjGdzys = QSwDjGdzys.swDjGdzys;
        QSwDjQs qSwDjQs = QSwDjQs.swDjQs;
        QSwDjPcxx qSwDjPcxx = QSwDjPcxx.swDjPcxx;
        QSwDjXmxx qSwDjXmxx = QSwDjXmxx.swDjXmxx;


        QSwHcXmRwRel qSwHcXmRwRel = QSwHcXmRwRel.swHcXmRwRel;
        QZd qZd = QZd.zd;
        QSwDjJbb qSwDjJbb = QSwDjJbb.swDjJbb;

        JPQLQuery query = new JPAQuery(baseRepository.getEntityManager());
        SwDjSyQuery swDjSyQuery = new SwDjSyQuery();
        if(StringUtils.isNotBlank(tdId)) {
            QBean qBean = Projections.bean(SwDjSyQuery.class,qSwDjSy.syId,qSwDjTd.tdId,qSwDjFc.fcId,qSwDjSy.zd.djh,qSwDjSy.dbh,qSwDjJbb.nsrsbh,qSwDjJbb.glbm,qSwDjJbb.nsrmc,qSwDjTd.czrmc,qSwDjTd.czrzjhm,qSwDjTd.czmj,qSwDjTd.tdzl,qSwDjTd.typebyzyy,qSwDjTd.confirmhc,
                    qZd.tdyt,qZd.qlrmc,qZd.scmjZd,qSwDjJbb.zgkgDm,qSwDjJbb.zgkgMc,qSwDjJbb.sgyMc,qSwDjJbb.fddbr,qSwDjJbb.lxdh,qSwDjJbb.zclxDm,qSwDjJbb.hyDm,qSwDjJbb.hyMc,qSwDjJbb.zcdz,
                    qSwDjTd.tdsyzh,qSwDjTd.tdsyztDm,qSwDjTd.tdqdfsDm,qSwDjTd.tdsyytDm,qSwDjTd.dj,qSwDjTd.qdsyqzfje,qSwDjTd.tdkfcb,qSwDjTd.csqdsj,qSwDjTd.syqzzsj,qSwDjTd.tdjmxzdm,qSwDjTd.fzmj,qSwDjTd.scmj,qSwDjTd.tddj,qSwDjTd.msmj,qSwDjTd.ynmj,qSwDjTd.dwse,qSwDjTd.nynseTd,qSwDjTd.dnynseTd,qSwDjTd.msse,
                    qSwDjFc.fczh,qSwDjFc.fcmj,qSwDjFc.fwxzDm,qSwDjFc.zyhczDm,qSwDjFc.fwjz,qSwDjFc.tdjz,qSwDjFc.fssbjz,qSwDjFc.fcyz,
                    qSwDjFc.htzlqBegin, qSwDjFc.htzlqEnd, qSwDjFc.htzj, qSwDjFc.czrmcFc, qSwDjFc.czrzjhmFc,
                    qSwDjFc.czfcyz,qSwDjFc.jsbl,qSwDjFc.fcjmxzdm,qSwDjFc.fcyzYs,qSwDjFc.fcyzMs,qSwDjFc.ynseZy,qSwDjFc.ynseCz,qSwDjFc.nzj,qSwDjFc.nynseFc,qSwDjFc.fczl,qSwDjFc.qzczfcmj,qZd.tdzh,qSwDjTd.sgztDm,qSwDjSy.bz,qSwDjTd.tdsyqlx,qSwHcXmRwRel.shxrId,qSwDjTd.tdMssjBegin,qSwDjTd.tdMssjEnd,qSwDjTd.tdMsyy,
                    qSwDjFc.fcMssjBegin,qSwDjFc.fcMssjEnd,qSwDjFc.fcMsyy,qSwDjFc.sl,qSwDjSy.ishc,qSwDjTd.gtzdbyzyy,
                    qSwDjFc.fczlXian,qSwDjFc.fczlZhen,qSwDjFc.fczlLu,qSwDjFc.fczlHao,qSwDjFc.fczlDong,qSwDjFc.fczlDy,qSwDjFc.fczlLou,qSwDjFc.fczlShi,
                    qSwDjGdzys.gdzysId,qSwDjGdzys.gdzysSzly,qSwDjGdzys.gdzysYnse,qSwDjGdzys.gdzysDwse,qSwDjGdzys.gdzysJmxz,qSwDjGdzys.gdzysJmse,qSwDjGdzys.gdzysJspz,qSwDjGdzys.gdzysYjne,qSwDjGdzys.gdzysXbjse,qSwDjGdzys.gdzysBz,qSwDjGdzys.gdzysLrrq,
                    qSwDjQs.qsId,qSwDjQs.qsSzly,qSwDjQs.qsYnse,qSwDjQs.qsJmxz,qSwDjQs.qsJmse,qSwDjQs.qsJspz,qSwDjQs.qsXbjse,qSwDjQs.qsBz,qSwDjQs.qsLrrq,qSwDjQs.qsYjne);
            query.from(qSwDjSy).leftJoin(qSwDjSy.swDjTd, qSwDjTd).leftJoin(qSwDjSy.swDjFc,qSwDjFc).leftJoin(qSwDjSy.swDjGdzys,qSwDjGdzys).leftJoin(qSwDjSy.swDjQs,qSwDjQs).leftJoin(qSwDjTd.swDjJbb,qSwDjJbb).leftJoin(qSwDjSy.zd, qZd).leftJoin(qSwDjSy.swHcXmRwRel,qSwHcXmRwRel).where(qSwDjTd.tdId.eq(tdId));
            swDjSyQuery = (SwDjSyQuery)baseRepository.get(query,qBean);
        }
        else if(StringUtils.isNotBlank(fcId)) {
            QBean qBean = Projections.bean(SwDjSyQuery.class,qSwDjSy.syId,qSwDjTd.tdId,qSwDjFc.fcId,qSwDjSy.zd.djh,qSwDjSy.dbh,qSwDjJbb.nsrsbh,qSwDjJbb.glbm,qSwDjJbb.nsrmc,qSwDjTd.czrmc,qSwDjTd.czrzjhm,qSwDjTd.czmj,qSwDjTd.tdzl,
                    qZd.tdyt,qZd.qlrmc,qZd.scmjZd,qSwDjJbb.zgkgDm,qSwDjJbb.zgkgMc,qSwDjJbb.sgyMc,qSwDjJbb.fddbr,qSwDjJbb.lxdh,qSwDjJbb.zclxDm,qSwDjJbb.hyDm,qSwDjJbb.zcdz,
                    qSwDjTd.tdsyzh,qSwDjTd.tdsyztDm,qSwDjTd.tdqdfsDm,qSwDjTd.tdsyytDm,qSwDjTd.dj,qSwDjTd.qdsyqzfje,qSwDjTd.tdkfcb,qSwDjTd.csqdsj,qSwDjTd.syqzzsj,qSwDjTd.tdjmxzdm,qSwDjTd.fzmj,qSwDjTd.scmj,qSwDjTd.tddj,qSwDjTd.msmj,qSwDjTd.ynmj,qSwDjTd.dwse,qSwDjTd.nynseTd,qSwDjTd.dnynseTd,
                    qSwDjFc.fczh,qSwDjFc.fcmj,qSwDjFc.fwxzDm,qSwDjFc.zyhczDm,qSwDjFc.fwjz,qSwDjFc.tdjz,qSwDjFc.fssbjz,qSwDjFc.fcyz,
                    qSwDjFc.htzlqBegin, qSwDjFc.htzlqEnd, qSwDjFc.htzj, qSwDjFc.czrmcFc, qSwDjFc.czrzjhmFc,
                    qSwDjFc.fcyzYs,qSwDjFc.fcyzMs,qSwDjFc.ynseZy,qSwDjFc.qzczfcmj,qSwDjFc.ynseCz,qSwDjFc.nzj,qSwDjFc.nynseFc,qSwDjFc.fczl,qZd.tdzh,qSwDjTd.sgztDm,qSwDjSy.bz,qSwDjTd.tdsyqlx,qSwHcXmRwRel.shxrId,qSwDjTd.tdMssjBegin,qSwDjTd.tdMssjEnd,qSwDjTd.tdMsyy,qSwDjFc.fcMssjBegin,qSwDjFc.fcMssjEnd,qSwDjFc.fcMsyy,qSwDjFc.sl,qSwDjSy.ishc,qSwDjTd.gtzdbyzyy,
                    qSwDjFc.fczlXian,qSwDjFc.fczlZhen,qSwDjFc.fczlLu,qSwDjFc.fczlHao,qSwDjFc.fczlDong,qSwDjFc.fczlDy,qSwDjFc.fczlLou,qSwDjFc.fczlShi,
                    qSwDjGdzys.gdzysId,qSwDjGdzys.gdzysSzly,qSwDjGdzys.gdzysYnse,qSwDjGdzys.gdzysDwse,qSwDjGdzys.gdzysJmxz,qSwDjGdzys.gdzysJmse,qSwDjGdzys.gdzysJspz,qSwDjGdzys.gdzysYjne,qSwDjGdzys.gdzysXbjse,qSwDjGdzys.gdzysBz,qSwDjGdzys.gdzysLrrq,
                    qSwDjQs.qsId,qSwDjQs.qsSzly,qSwDjQs.qsYnse,qSwDjQs.qsJmxz,qSwDjQs.qsJmse,qSwDjQs.qsJspz,qSwDjQs.qsXbjse,qSwDjQs.qsBz,qSwDjQs.qsLrrq,qSwDjQs.qsYjne);
            query.from(qSwDjSy).leftJoin(qSwDjSy.swDjFc, qSwDjFc).leftJoin(qSwDjSy.swDjTd,qSwDjTd).leftJoin(qSwDjSy.swDjGdzys,qSwDjGdzys).leftJoin(qSwDjSy.swDjQs,qSwDjQs).leftJoin(qSwDjFc.swDjJbb,qSwDjJbb).leftJoin(qSwDjSy.zd, qZd).leftJoin(qSwDjSy.swHcXmRwRel,qSwHcXmRwRel).where(qSwDjFc.fcId.eq(fcId));
            swDjSyQuery = (SwDjSyQuery)baseRepository.get(query,qBean);
        }



        //征管系统已缴纳税额
        //swDjSyQuery = setZgxtSet(swDjSyQuery.getGlbm(),swDjSyQuery);
        return swDjSyQuery;

    }

    @Override
    public SwDjSyQuery getSwDjSyBySyId(String syId) {
        QSwDjSy qSwDjSy = QSwDjSy.swDjSy;
        QSwDjTd qSwDjTd = QSwDjTd.swDjTd;
        QSwDjFc qSwDjFc = QSwDjFc.swDjFc;
        QSwDjGdzys qSwDjGdzys = QSwDjGdzys.swDjGdzys;
        QSwDjQs qSwDjQs = QSwDjQs.swDjQs;

        QSwHcXmRwRel qSwHcXmRwRel = QSwHcXmRwRel.swHcXmRwRel;
        QZd qZd = QZd.zd;
        QSwDjJbb qSwDjJbb = QSwDjJbb.swDjJbb;

        JPQLQuery query = new JPAQuery(baseRepository.getEntityManager());
        SwDjSyQuery swDjSyQuery = new SwDjSyQuery();
        QBean qBean = Projections.bean(SwDjSyQuery.class,qSwDjSy.syId,qSwDjTd.tdId,qSwDjFc.fcId,qSwDjSy.zd.djh,qSwDjSy.dbh,qSwDjJbb.glbm,qSwDjJbb.nsrsbh,qSwDjJbb.nsrmc,qSwDjTd.czrmc,qSwDjTd.czrzjhm,qSwDjTd.tdzl,
                qZd.tdyt,qZd.qlrmc,qZd.scmjZd,qSwDjJbb.zgkgDm,qSwDjJbb.zgkgMc,qSwDjJbb.sgyMc,qSwDjJbb.fddbr,qSwDjJbb.lxdh,qSwDjJbb.zclxDm,qSwDjJbb.hyDm,qSwDjJbb.zcdz,
                qSwDjTd.tdsyzh,qSwDjTd.tdsyztDm,qSwDjTd.tdqdfsDm,qSwDjTd.tdsyytDm,qSwDjTd.dj,qSwDjTd.qdsyqzfje,qSwDjTd.tdkfcb,qSwDjTd.csqdsj,qSwDjTd.syqzzsj,qSwDjTd.tdjmxzdm,qSwDjTd.fzmj,qSwDjTd.scmj,qSwDjTd.tddj,qSwDjTd.msmj,qSwDjTd.ynmj,qSwDjTd.dwse,qSwDjTd.nynseTd,qSwDjTd.msse,
                qSwDjFc.fczh,qSwDjFc.fcmj,qSwDjFc.fwxzDm,qSwDjFc.zyhczDm,qSwDjFc.fwjz,qSwDjFc.tdjz,qSwDjFc.fssbjz,qSwDjFc.fcyz,
                qSwDjFc.czfcyz,qSwDjFc.jsbl,qSwDjFc.fcjmxzdm,qSwDjFc.fcyzYs,qSwDjFc.fcyzMs,qSwDjFc.ynseZy,qSwDjFc.ynseCz,qSwDjFc.nzj,qSwDjFc.nynseFc,qSwDjFc.fczl,qSwDjFc.qzczfcmj,qZd.tdzh,qSwDjTd.sgztDm,qSwDjSy.bz,qSwDjTd.tdsyqlx,qSwHcXmRwRel.shxrId,qSwDjTd.tdMssjBegin,qSwDjTd.tdMssjEnd,qSwDjTd.tdMsyy,qSwDjFc.fcMssjBegin,qSwDjFc.fcMssjEnd,qSwDjFc.fcMsyy,qSwDjFc.sl,qSwDjSy.ishc,qSwDjTd.gtzdbyzyy,
                qSwDjFc.fczlXian,qSwDjFc.fczlZhen,qSwDjFc.fczlLu,qSwDjFc.fczlHao,qSwDjFc.fczlDong,qSwDjFc.fczlDy,qSwDjFc.fczlLou,qSwDjFc.fczlShi,
                qSwDjGdzys.gdzysId,qSwDjGdzys.gdzysSzly,qSwDjGdzys.gdzysYnse,qSwDjGdzys.gdzysDwse,qSwDjGdzys.gdzysJmxz,qSwDjGdzys.gdzysJmse,qSwDjGdzys.gdzysJspz,qSwDjGdzys.gdzysYjne,qSwDjGdzys.gdzysXbjse,qSwDjGdzys.gdzysBz,qSwDjGdzys.gdzysLrrq,
                qSwDjQs.qsId,qSwDjQs.qsSzly,qSwDjQs.qsYnse,qSwDjQs.qsJmxz,qSwDjQs.qsJmse,qSwDjQs.qsJspz,qSwDjQs.qsXbjse,qSwDjQs.qsBz,qSwDjQs.qsLrrq,qSwDjQs.qsYjne);
        query.from(qSwDjSy).leftJoin(qSwDjSy.swDjTd, qSwDjTd).leftJoin(qSwDjSy.swDjFc,qSwDjFc).leftJoin(qSwDjSy.swDjGdzys,qSwDjGdzys).leftJoin(qSwDjSy.swDjQs,qSwDjQs).leftJoin(qSwDjTd.swDjJbb,qSwDjJbb).leftJoin(qSwDjSy.zd, qZd).leftJoin(qSwDjSy.swHcXmRwRel,qSwHcXmRwRel).where(qSwDjSy.syId.eq(syId));
        swDjSyQuery = (SwDjSyQuery)baseRepository.get(query,qBean);

        return swDjSyQuery;
    }

    @Override
    public SwDjSyQuery setZgxtSet(String nsrsbh,SwDjSyQuery swDjSyQuery){
        //征管系统已缴纳税额
        if(StringUtils.isNotBlank(nsrsbh)) {
            String jpqlTd = "select nvl(sum(nse),0) nse from local_sb_rkss t where t.nsrsbh='" + nsrsbh + "' and t.szdm='" + Szdm.CZTDSYS.toString() + "' and to_char(t.fsrq,'yyyy')=to_char(sysdate,'yyyy')";
            Query jpqlQueryTd = baseRepository.getEntityManager().createNativeQuery(jpqlTd);
            BigDecimal tdyjne = (BigDecimal) jpqlQueryTd.getSingleResult();
            swDjSyQuery.setTdyjne(tdyjne);
            BigDecimal nynseTd = swDjSyQuery.getNynseTd();
            if (nynseTd != null) {
                BigDecimal tdqje = nynseTd.subtract(tdyjne);
                swDjSyQuery.setTdqje(tdqje);
                if(!nynseTd.equals(BigDecimal.ZERO)){
                    BigDecimal tdqjbl = tdqje.divide(nynseTd, 4, BigDecimal.ROUND_HALF_UP);
                    swDjSyQuery.setTdqjbl(tdqjbl.multiply(new BigDecimal(100)));
                }
            }

            String jpqlFc = "select nvl(sum(nse),0) nse from local_sb_rkss t where t.nsrsbh='" + nsrsbh + "' and t.szdm='" + Szdm.FCS.toString() + "' and to_char(t.fsrq,'yyyy')=to_char(sysdate,'yyyy')";
            Query jpqlQueryFc = baseRepository.getEntityManager().createNativeQuery(jpqlFc);
            BigDecimal fcyjne = (BigDecimal) jpqlQueryFc.getSingleResult();
            swDjSyQuery.setFcyjne(fcyjne);
            BigDecimal nynseFc = swDjSyQuery.getNynseFc() == null ? new BigDecimal(0) : swDjSyQuery.getNynseFc();
            if (nynseFc != null) {
                BigDecimal fcqje = nynseFc.subtract(fcyjne);
                swDjSyQuery.setFcqje(fcqje);
                if(!nynseFc.equals(BigDecimal.ZERO)){
                    BigDecimal fcqjbl = fcqje.divide(nynseFc, 4, BigDecimal.ROUND_HALF_UP);
                    swDjSyQuery.setFcqjbl(fcqjbl.multiply(new BigDecimal(100)));
                }
            }
        }
        return swDjSyQuery;
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public Object getSwjgByQx(String qx) {

        StringBuffer sql = new StringBuffer()
                .append("select swbmbm,mc from dm_swbm ");
        StringBuffer whereClause = new StringBuffer()
                .append("where swbmbm like '2").append(qx).append("%' ").append(" and substr(swbmbm,8,2)<>'00'");
        sql.append(whereClause);
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        return query.getResultList();
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public List<HashMap<String, Object>> getZsSyxxListByGlbm(SbZsQuery sbZsQuery, String szdm) {
        int tdsqs = new Integer(AppConfig.getProperty("tdsqs"));
        int fcsqs = new Integer(AppConfig.getProperty("fcsqs"));
        int sqTotal = 4;
        if(szdm.equals(Szdm.CZTDSYS.toString())){
            sqTotal = tdsqs;
        }else if(szdm.equals(Szdm.FCS.toString())){
            sqTotal = fcsqs;
        }

        String year = sbZsQuery.getYear();
        int sssq = Integer.valueOf(sbZsQuery.getSssq());
        int sqBegin, sqEnd;
        sqBegin = (sssq - 1) / sqTotal + 1;
        sqEnd = (sssq - 1) % sqTotal + 1;
            String startRq = year + StringUtils.right("0" + String.valueOf((sqBegin - 1) * (12 / sqTotal) + 1), 2);
        String endRq = year + StringUtils.right("0" + String.valueOf(sqEnd * (12 / sqTotal)), 2);

        // 一年分几个属期的变量
        String sqCount = String.valueOf(sqTotal);
        // 预征期数
        String yzqs = "0";
//        if(szdm.equals(Szdm.CZTDSYS.toString())){
//            yzqs = "1";
//        }else if(szdm.equals(Szdm.FCS.toString())){
//            yzqs = "0";
//        }
        // 本期所属税款表到式的分变量表达式
        String zsEndNfsq = "(TO_NUMBER(TO_CHAR(t.TAXTERMEND, 'YYYY')) * :sqCount + TRUNC((TO_NUMBER(TO_CHAR(t.TAXTERMEND, 'MM')) - 1) / 12 * :sqCount) + 1 + :yzqs)";
        String zsStartNfsq = "(TO_NUMBER(TO_CHAR(t.TAXTERMBEGIN, 'YYYY')) * :sqCount + TRUNC((TO_NUMBER(TO_CHAR(t.TAXTERMBEGIN, 'MM')) - 1) / 12 * :sqCount) + 1 + :yzqs)";
        String ydEndNfsq = "(:ssnf * :sqCount + (MOD((TO_NUMBER(:sssq) - 1), :sqCount) + 1))";
        String ydStartNfsq = "(:ssnf * :sqCount + (TRUNC((TO_NUMBER(:sssq) - 1) / :sqCount, 0) + 1))";
        // 本期所属税款的计算表达式
        String bqSkExp = "t.NSE / (:zsEndNfsq - :zsStartNfsq + 1) * DECODE(SIGN(LEAST(:zsEndNfsq, :ydEndNfsq) - GREATEST(:zsStartNfsq, :ydStartNfsq)), -1, 0,  LEAST(:zsEndNfsq, :ydEndNfsq) - GREATEST(:zsStartNfsq, :ydStartNfsq) + 1)";
        // 将变量表达式替换成变量值
        bqSkExp = bqSkExp.replaceAll(":zsEndNfsq", zsEndNfsq);
        bqSkExp = bqSkExp.replaceAll(":zsStartNfsq", zsStartNfsq);
        bqSkExp = bqSkExp.replaceAll(":ydEndNfsq", ydEndNfsq);
        bqSkExp = bqSkExp.replaceAll(":ydStartNfsq", ydStartNfsq);
        bqSkExp = bqSkExp.replaceAll(":sqCount", sqCount);
        bqSkExp = bqSkExp.replaceAll(":sssq", sbZsQuery.getSssq());
        bqSkExp = bqSkExp.replaceAll(":ssnf", year);
        bqSkExp = bqSkExp.replaceAll(":yzqs", yzqs);

        String sql = "";
        sql =   "select sb_num, fsrq, szdm, NSRSBH, nse, ROUND(" + bqSkExp + ", 2) as bqnse, " +
                "t.taxtermend as lastDate, t.taxtermbegin as firstDate " +
                "from local_sb_rkss t " +
                "where t.szdm=':szdm' and nsrsbh=':nsrsbh' " +
                "and ((TO_CHAR(TAXTERMBEGIN, 'YYYYMM') >= ':startRq' AND TO_CHAR(TAXTERMBEGIN, 'YYYYMM') <= ':endRq') " +
                "OR (TO_CHAR(TAXTERMEND, 'YYYYMM') >= ':startRq' AND TO_CHAR(TAXTERMEND, 'YYYYMM') <= ':endRq') " +
                "OR (TO_CHAR(TAXTERMBEGIN, 'YYYYMM') >= ':startRq' AND TO_CHAR(TAXTERMEND, 'YYYYMM') <= ':endRq')) " +
                "order by TAXTERMBEGIN, TAXTERMEND ";
        sql = sql.replaceAll(":szdm", szdm);
        sql = sql.replaceAll(":startRq", startRq);
        sql = sql.replaceAll(":endRq", endRq);
        sql = sql.replaceAll(":nsrsbh", sbZsQuery.getNsrsbh());

        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        return query.getResultList();
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public BigDecimal getSumScmjByDjh(String djh) {
        String sql = "select nvl(sum(nvl(t2.scmj,0)),0)  " +
                "from sw_dj_sy t1  " +
                "left join sw_dj_td t2 on t2.sy_id=t1.sy_id  " +
                "left join zd t3 on t3.djh=t1.djh " +
                "where t2.sgzt_dm='01' and (t1.syzt='1' or t1.syzt is null) and t3.djh='"+djh+"'";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        return (BigDecimal)query.getSingleResult();
    }




    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public SwDjTd getSwDjTdById(String tdId) {
        return baseRepository.get(SwDjTd.class,tdId);
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public SwDjFc getSwDjFcById(String fcId) {
        return baseRepository.get(SwDjFc.class,fcId);
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public List<SwDjSyQuery> getSwDjSyByDjh(String djh) {
        QSwDjSy qSwDjSy = QSwDjSy.swDjSy;
        QSwDjTd qSwDjTd = QSwDjTd.swDjTd;
        QSwDjFc qSwDjFc = QSwDjFc.swDjFc;

        QZd qZd = QZd.zd;
        QSwDjJbb qSwDjJbb = QSwDjJbb.swDjJbb;
        JPQLQuery query = new JPAQuery(baseRepository.getEntityManager());

        QBean qBean = Projections.bean(SwDjSyQuery.class,qSwDjSy.zd.djh,qSwDjSy.dbh,qSwDjJbb.glbm,qSwDjJbb.nsrsbh,qSwDjJbb.nsrmc,qSwDjTd.czrmc,qSwDjTd.czrzjhm,qSwDjTd.tdzl,
                qZd.tdyt,qZd.qlrmc,qZd.scmjZd,qSwDjJbb.zgkgDm,qSwDjJbb.sgyMc,qSwDjJbb.fddbr,qSwDjJbb.lxdh,qSwDjJbb.zclxDm,qSwDjJbb.hyDm,qSwDjJbb.zcdz,
                qSwDjTd.tdsyztDm,qSwDjTd.fzmj,qSwDjTd.scmj,qSwDjTd.tddj,qSwDjTd.msmj,qSwDjTd.ynmj,qSwDjTd.dwse,qSwDjTd.nynseTd,qSwDjTd.czmj,
                qSwDjFc.fczh,qSwDjFc.fcmj,qSwDjFc.fwxzDm,qSwDjFc.zyhczDm,qSwDjFc.fwjz,qSwDjFc.tdjz,qSwDjFc.fssbjz,qSwDjFc.fcyz,qSwDjFc.htzj,qSwDjFc.htzlqBegin,qSwDjFc.htzlqEnd,
                qSwDjFc.fcyzYs,qSwDjFc.fcyzMs,qSwDjFc.ynseZy,qSwDjFc.ynseCz,qSwDjFc.nzj,qSwDjFc.nynseFc,qSwDjFc.fcId,qSwDjTd.tdId,qSwDjSy.syId);
        query.from(qSwDjSy).leftJoin(qSwDjSy.swDjTd, qSwDjTd).leftJoin(qSwDjSy.swDjFc,qSwDjFc).leftJoin(qSwDjTd.swDjJbb,qSwDjJbb).leftJoin(qSwDjSy.zd, qZd).where(qSwDjSy.zd.djh.eq(djh));
        query.where(qSwDjSy.syzt.eq(Syzt.ZC.toString()).or(qSwDjSy.syzt.isNull()));
        query.orderBy(new OrderSpecifier(Order.ASC, Expressions.stringPath(qSwDjSy,"dbh")));
        return (List)baseRepository.dslList(query,qBean);

    }

    @Override
    public SwDjSy getSwDjSyById(String syId) {
        return baseRepository.get(SwDjSy.class,syId);
    }


    @Override
    @Transactional(value="oracle_common")
    public void saveSwDjSy(SwDjSy swDjSy) {
        baseRepository.save(swDjSy);
    }

    @Override
    @Transactional(value="oracle_common")
    public void deleteSwDjSy(String syId) {
        SwDjSy swDjSy = baseRepository.get(SwDjSy.class,syId);
        if(swDjSy.getSwDjTd()!=null)
            baseRepository.delete(swDjSy.getSwDjTd());
        if(swDjSy.getSwDjFc()!=null)
            baseRepository.delete(swDjSy.getSwDjFc());
        if(swDjSy.getSwDjQs()!=null)
            baseRepository.delete(swDjSy.getSwDjQs());
        baseRepository.delete(swDjSy);
    }


    private void applySwDjSyQueryPredicates(SwDjSyQuery swDjSyQuery,QSwDjSy qSwDjSy,QSwDjJbb qSwDjJbb,QSwDjTd qSwDjTd,QSwDjFc qSwDjFc,QZd qZd,QSwDjXmxx qSwDjXmxx,JPQLQuery jpaQuery){
        if(StringUtils.isNotBlank(swDjSyQuery.getDbh()))
            jpaQuery.where(Expressions.stringPath(qSwDjSy,"dbh").like(QueryCondition.WILDCARDS + swDjSyQuery.getDbh() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(swDjSyQuery.getNsrmc()))
            jpaQuery.where(Expressions.stringPath(qSwDjJbb,"nsrmc").like(QueryCondition.WILDCARDS + swDjSyQuery.getNsrmc() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(swDjSyQuery.getTdzh()))
            jpaQuery.where(Expressions.stringPath(qZd, "tdzh").like(QueryCondition.WILDCARDS + swDjSyQuery.getTdzh() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(swDjSyQuery.getQlrmc()))
            jpaQuery.where(Expressions.stringPath(qZd,"qlrmc").like(QueryCondition.WILDCARDS + swDjSyQuery.getQlrmc() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(swDjSyQuery.getTdzl()))
            jpaQuery.where(Expressions.stringPath(qZd,"tdzl").like(QueryCondition.WILDCARDS + swDjSyQuery.getTdzl() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(swDjSyQuery.getTdyt()))
            jpaQuery.where(Expressions.stringPath(qSwDjTd, "tdsyytDm").eq(swDjSyQuery.getTdyt()));
        if(StringUtils.isNotBlank(swDjSyQuery.getJf()))
            jpaQuery.where(Expressions.stringPath(qZd, "djh").like(swDjSyQuery.getJf() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(swDjSyQuery.getJd()))
            jpaQuery.where(Expressions.stringPath(qZd, "djh").like(swDjSyQuery.getJd() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(swDjSyQuery.getQx()))
            jpaQuery.where(Expressions.stringPath(qZd, "sgqdm").like(swDjSyQuery.getQx() + QueryCondition.WILDCARDS).or(qZd.sgqdm.isNull().and(qSwDjXmxx.xmXzqdm.eq(swDjSyQuery.getQx()))));
        if(StringUtils.isNotBlank(swDjSyQuery.getZclxDm()))
            jpaQuery.where(Expressions.stringPath(qSwDjJbb,"zclxDm").eq(swDjSyQuery.getZclxDm()));
        //行业类型添加模糊查询，小类
        if(StringUtils.isNotBlank(swDjSyQuery.getHyDm()))
            jpaQuery.where(Expressions.stringPath(qSwDjJbb,"hyDm").like(swDjSyQuery.getHyDm() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(swDjSyQuery.getSgyMc()))
            jpaQuery.where(Expressions.stringPath(qSwDjJbb,"sgyMc").like(QueryCondition.WILDCARDS + swDjSyQuery.getSgyMc() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(swDjSyQuery.getZgkgDm()))
            jpaQuery.where(Expressions.stringPath(qSwDjJbb,"zgkgDm").eq(swDjSyQuery.getZgkgDm()));
        if(StringUtils.isNotBlank(swDjSyQuery.getHclx())){
            if("1".equals(swDjSyQuery.getHclx())){
                jpaQuery.where(qZd.djh.isNotNull());
                jpaQuery.where(qZd.djh.notLike(QueryCondition.WILDCARDS + "999999"+ QueryCondition.WILDCARDS));
            }else if("2".equals(swDjSyQuery.getHclx())){
                jpaQuery.where(qZd.djh.like(QueryCondition.WILDCARDS + "999999"+ QueryCondition.WILDCARDS));
            }else if("3".equals(swDjSyQuery.getHclx())){
                jpaQuery.where(qSwDjXmxx.xmId.isNotNull());
            }
        }

        //过滤工矿区
        if(StringUtils.isNotEmpty(swDjSyQuery.getIsGkq())){
            String tdjb_gkq_sql = "SELECT DM FROM S_ZD_TDJB WHERE MC LIKE '%工矿区%'";
            Query query = baseRepository.getEntityManager().createNativeQuery(tdjb_gkq_sql);
            List tdjb_gkq = query.getResultList();

            if("1".equals(swDjSyQuery.getIsGkq())){
                jpaQuery.where(qSwDjTd.tddj.in(tdjb_gkq));
            }else if("0".equals(swDjSyQuery.getIsGkq())){
                jpaQuery.where(qSwDjTd.tddj.notIn(tdjb_gkq).or(qSwDjTd.tddj.isNull()));
            }
        }
        //税额统计过滤税额(大于等于最小单位税额，小于等于最大单位税额)
        if(StringUtils.isNotEmpty(swDjSyQuery.getMinDwse())){
            jpaQuery.where(qSwDjTd.dwse.goe(new BigDecimal(swDjSyQuery.getMinDwse())));
        }
        if(StringUtils.isNotEmpty(swDjSyQuery.getMaxDwse())){
            jpaQuery.where(qSwDjTd.dwse.loe(new BigDecimal(swDjSyQuery.getMaxDwse())));
        }

        if(StringUtils.isNotBlank(swDjSyQuery.getExcelBegin()) && StringUtils.isNotBlank(swDjSyQuery.getExcelEnd())){
            Integer offset = Integer.parseInt(swDjSyQuery.getExcelBegin())-1;
            Integer limit = Integer.parseInt(swDjSyQuery.getExcelEnd())-offset;
            jpaQuery.offset(offset).limit(limit);
        }

    }

    @Override
    public SwDjJbb findSwDjJbbByGlbm(String nsrsbh) {
        String jpql = "from SwDjJbb where nsrsbh=?0";
        List list = baseRepository.getByJpql(jpql,nsrsbh);
        if(CollectionUtils.isNotEmpty(list)){
            return (SwDjJbb)(list.get(0));
        }
        return null;

    }

    @Override
    @Transactional(value="oracle_common")
    public void saveSwDjSyQuery(SwDjSyQuery swDjSyQuery,String syzt) throws Exception {
        String syId = swDjSyQuery.getSyId();
        String jbbId = swDjSyQuery.getJbbId();
        String tdId = swDjSyQuery.getTdId();
        String fcId = swDjSyQuery.getFcId();
        String shxrId = swDjSyQuery.getShxrId();

        //基本表操作
        SwDjJbb swDjJbb = null;
        String sgztDm = swDjSyQuery.getSgztDm();
        String nsrsbh = swDjSyQuery.getNsrsbh();
        //if("01".equals(sgztDm)) {
            //根据纳税人识别号查询是否存在基本表信息
        if(StringUtils.isNotBlank(nsrsbh)){
            swDjJbb = findSwDjJbbByGlbm(nsrsbh);
        }

        //}
        if(swDjJbb==null){
            swDjJbb = new SwDjJbb();
            BeanUtils.copyProperties(swDjSyQuery, swDjJbb);
            swDjJbb.setJbbId(UUIDGenerator.generate());
            //保存主管税务机关名称
            String zgkgDm = swDjSyQuery.getZgkgDm();
            String zgkgMc = dicService.findZgkgMcByZgkgDm(zgkgDm);
            swDjJbb.setZgkgMc(zgkgMc);
            baseRepository.save(swDjJbb);//先保存基本表
        }else{
            BeanUtils.copyProperties(swDjSyQuery,swDjJbb,new String[]{"jbbId"});
            //保存主管税务机关名称
            String zgkgDm = swDjSyQuery.getZgkgDm();
            String zgkgMc = dicService.findZgkgMcByZgkgDm(zgkgDm);
            swDjJbb.setZgkgMc(zgkgMc);
        }
        //税源主表操作
        SwDjSy swDjSy = new SwDjSy();
        BeanUtils.copyProperties(swDjSyQuery, swDjSy);
        //根据djh获取zd
        Zd zd = zdService.findZdByDjh(swDjSyQuery.getDjh());
        swDjSy.setZd(zd);
        swDjSy.setSyzt(syzt);

        //根据ShxrId获取
        if(StringUtils.isNotBlank(shxrId)){
            SwHcXmRwRel swHcXmRwRel = hcxmService.getSwHcXmRwRelByShxrId(shxrId);
            swDjSy.setSwHcXmRwRel(swHcXmRwRel);
        }


        if(StringUtils.isBlank(syId)){
            swDjSy.setSyId(UUIDGenerator.generate());
            //判断填写的地编号是否在数据库中已经存在
            String dbh = swDjSyQuery.getDbh();
            SwDjSy tempSy = findSwDjSyByDjhAndDbh(zd.getDjh(),dbh);
            if(tempSy!=null){
                dbh = createDbhByDjh(zd.getDjh());
            }
            swDjSy.setDbh(dbh);
            swDjSy.setSysjly(Gtlx.ZD.toString());
            baseRepository.save(swDjSy);
        }else{
            swDjSy.setSyId(syId);
            //判断填写的地编号是否在数据库中已经存在,并且不是自己本身
            String dbh = swDjSyQuery.getDbh();
            SwDjSy tempSy = findSwDjSyByDjhAndDbh(zd.getDjh(),dbh);

            if(tempSy!=null && !tempSy.getSyId().equals(syId)){//查出来的税源对象与当前对象不一致，说明填写的地编号不符合
                dbh = createDbhByDjh(zd.getDjh());
            }
            swDjSy.setSysjly(Gtlx.ZD.toString());
            swDjSy.setDbh(dbh);
            baseRepository.update(swDjSy);
        }

        //土地税源操作
        SwDjTd swDjTd = new SwDjTd();
        BeanUtils.copyProperties(swDjSyQuery,swDjTd);
        swDjTd.setSwDjJbb(swDjJbb);
        swDjTd.setSwDjSy(swDjSy);
        if(StringUtils.isBlank(tdId)){
            swDjTd.setTdId(UUIDGenerator.generate());
            String fczl = CommonUtil.getFczl(swDjSyQuery.getFczlXian(), swDjSyQuery.getFczlZhen(), swDjSyQuery.getFczlLu(), swDjSyQuery.getFczlHao(), swDjSyQuery.getFczlDong(), swDjSyQuery.getFczlDy(), swDjSyQuery.getFczlLou(), swDjSyQuery.getFczlShi());

            swDjTd.setTdzl(fczl);
            swDjTd.setSjly(Sjly.SYHC.toString());
            swDjTd.setLrrq(new Date());
            swDjTd.setUpdateDate(new Date());
            baseRepository.save(swDjTd);
        }else{
            swDjTd.setTdId(tdId);
            String fczl = CommonUtil.getFczl(swDjSyQuery.getFczlXian(), swDjSyQuery.getFczlZhen(), swDjSyQuery.getFczlLu(), swDjSyQuery.getFczlHao(), swDjSyQuery.getFczlDong(), swDjSyQuery.getFczlDy(), swDjSyQuery.getFczlLou(), swDjSyQuery.getFczlShi());
            swDjTd.setTdzl(fczl);
            swDjTd.setSjly(Sjly.SYHC.toString());
            swDjTd.setUpdateDate(new Date());
            baseRepository.update(swDjTd);
        }

        //房产税源操作
        SwDjFc swDjFc = new SwDjFc();
        BeanUtils.copyProperties(swDjSyQuery, swDjFc);
        swDjFc.setSwDjJbb(swDjJbb);
        swDjFc.setSwDjSy(swDjSy);
        swDjFc.setLrrq(new Date());
        String fczl = CommonUtil.getFczl(swDjSyQuery.getFczlXian(), swDjSyQuery.getFczlZhen(), swDjSyQuery.getFczlLu(), swDjSyQuery.getFczlHao(), swDjSyQuery.getFczlDong(), swDjSyQuery.getFczlDy(), swDjSyQuery.getFczlLou(), swDjSyQuery.getFczlShi());
        swDjFc.setFczl(fczl);
        swDjFc.setCzrmcFc(swDjSyQuery.getCzrmcFc());
        swDjFc.setCzrzjhmFc(swDjSyQuery.getCzrzjhmFc());
        if(StringUtils.isBlank(fcId)){
            swDjFc.setFcId(UUIDGenerator.generate());
            swDjFc.setSjly(Sjly.SYHC.toString());
            baseRepository.save(swDjFc);
        }else{
            swDjFc.setFcId(fcId);
            swDjFc.setSjly(Sjly.SYHC.toString());
            baseRepository.update(swDjFc);
        }

        String xmmc = swDjSyQuery.getXmmc();
        if(StringUtils.isNotBlank(xmmc)){

        }

        //查询s_sj_gtbd该地籍号上的记录的ppzt是否是空，如果是空设置成3（税源核查）
        String djh = zd.getDjh();
        SSjGtbd sSjGtbd = ssjGtbdService.findByDjh(djh);
        if(sSjGtbd!=null && StringUtils.isBlank(sSjGtbd.getPpzt())){
            sSjGtbd.setPpzt("3");
            ssjGtbdService.updateSsjGtbd(sSjGtbd);
        }

        //****************************************************************保存msrdTd,msrdFc


    }

    @Override
    public String createDbhByDjh(String djh) {
        QSwDjSy qSwDjSy = QSwDjSy.swDjSy;
        JPQLQuery query = new JPAQuery(baseRepository.getEntityManager());
        QBean qBean = Projections.bean(SwDjSyQuery.class,qSwDjSy.dbh);
        query.from(qSwDjSy).where(qSwDjSy.zd.djh.eq(djh));
        query.where(qSwDjSy.dbh.isNotNull());
        query.orderBy(new OrderSpecifier(Order.ASC, Expressions.stringPath(qSwDjSy,"dbh")));

        List<SwDjSyQuery> swDjSyQueryList =  (List)baseRepository.dslList(query,qBean);
        //获取所有地编号
        List<Long> dbhList = new ArrayList<Long>();
        for(SwDjSyQuery vo : swDjSyQueryList){
            dbhList.add(Long.parseLong(vo.getDbh()));
        }
        //根据地编号获取最大值
        Long temp = 0L;
        for(Long dbh : dbhList){
            temp = Math.max(temp,dbh);

        }
        temp = temp/10 + 1;
        String resultDbh = String.valueOf(temp);
        int length = resultDbh.length();
        for(int i=0;i<9-length;i++){
            resultDbh = "0" + resultDbh;
        }
        return resultDbh+"0";
    }

    @Override
    public List<SwDjJbbQuery> findJbbByGlbm(String nsrsbh) {
        QSwDjJbb qSwDjJbb = QSwDjJbb.swDjJbb;
        JPQLQuery query = new JPAQuery(baseRepository.getEntityManager());
        query.from(qSwDjJbb).where(qSwDjJbb.nsrsbh.like(nsrsbh + QueryCondition.WILDCARDS));
        QBean qBean = Projections.bean(SwDjJbbQuery.class,qSwDjJbb.nsrsbh,qSwDjJbb.nsrmc);
        return (List)baseRepository.dslList(query,qBean);
    }



    @Override
    @Transactional(value="oracle_common")
    public void updateSwDjTd(SwDjTd swDjTd) {
       baseRepository.update(swDjTd);
    }

    @Override
    @Transactional(value="oracle_common")
    public void updateSwDjFc(SwDjFc swDjFc) {
        baseRepository.update(swDjFc);
    }

    @Override
    @Transactional(value="oracle_common")
    public void createSwDjFc(SwDjFc swDjFc) {
        baseRepository.save(swDjFc);
    }

    @Override
    @Transactional(value="oracle_common")
    public void softDelSyDjSy(String syId, String syzt) {
        String jpql = "update SwDjSy set syzt=?0 where syId=?1";
        baseRepository.executeJpql(jpql,syzt,syId);
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public SwDjSy findSwDjSyByDjhAndDbh(String djh, String dbh) {
        String jpql = "from SwDjSy o where o.zd.djh=?0 and o.dbh=?1";
        List<SwDjSy> swDjSyList =  baseRepository.getByJpql(jpql,djh,dbh);
        if(CollectionUtils.isNotEmpty(swDjSyList)){
            return swDjSyList.get(0);
        }
        return null;
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public List<Object> getZdsyTdList(HashMap param) {
        String beginPm = String.valueOf(param.get("beginPm")==null?"":param.get("beginPm"));
        String endPm = String.valueOf(param.get("endPm")==null?"":param.get("endPm"));
        Object obj = param.get("ids");
        SwDjSyQuery swDjSyQuery = (SwDjSyQuery) param.get("swDjSyQuery");
        String sql ="select rank() over(order by nvl(t.nynse,0) desc) as pm,t.djh,t.dbh,t.nsrsbh,t.nsrmc,t.zgkg_mc,t.sgy_mc,t.tdzl,t.scmj,t.ynmj,t.msmj,t.nynse,t2.spm from ("+
                "select t2.djh,t2.dbh,t3.nsrsbh,t3.nsrmc,t3.zgkg_mc,t3.sgy_mc,t1.tdzl,t1.scmj,t1.ynmj,t1.msmj,t1.nynse,t1.td_id,t1.zdsybz,t3.zgkg_dm,t3.zclx_dm" +
                " from sw_dj_td t1" +
                " left join sw_dj_sy t2" +
                " on t1.sy_id=t2.sy_id" +
                " left join  sw_dj_jbb t3" +
                " on t1.jbb_id=t3.jbb_id "+
                " where (t2.syzt is null or t2.syzt='1'))t "+
                " right join(select  td_id,rank() over(order by nvl(nynse,0) desc) as spm from sw_dj_td)t2 on t.td_id =t2.td_id where 1=1 ";

        if(obj==null) {//导出全部
            //筛选重点税源，只导出重点税源
            sql += " and t.Zdsybz = '1' ";
            sql = addParameter(swDjSyQuery,sql,beginPm,endPm,"1");
        }else{//checkbox导出
            String resultIds = "";
            String ids = String.valueOf(obj);
            String[] idsArr = ids.split(",");
            for(int i=0;i<idsArr.length;i++){
                if(i==idsArr.length-1){
                    resultIds = resultIds+"'"+idsArr[i]+"'";
                }else{
                    resultIds = resultIds+"'"+idsArr[i]+"'"+",";
                }
            }
            sql = sql + " and t.td_id in("+resultIds+")";
        }
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        List<Object> list =  query.getResultList();
        return list;
    }

    @Override
    public List<Object> getZdsyFcList(HashMap param) {
        String beginPm = String.valueOf(param.get("beginPm")==null?"":param.get("beginPm"));
        String endPm = String.valueOf(param.get("endPm")==null?"":param.get("endPm"));

        Object obj = param.get("ids");
        SwDjSyQuery swDjSyQuery = (SwDjSyQuery) param.get("swDjSyQuery");
        String sql ="select rank() over(order by nvl(t.nynse,0) desc) as pm,t.djh,t.dbh,t.nsrsbh,t.nsrmc,t.zgkg_mc,t.sgy_mc,t.fczl,t.fcmj,t.fcyz_ys,fcyz_ms,t.nzj,t.nynse,t2.spm from ("+
                "select t2.djh,t2.dbh,t3.nsrsbh,t3.nsrmc,t3.zgkg_mc,t3.sgy_mc,t1.fczl,t1.fcmj,t1.fcyz_ys,t1.fcyz_ms,t1.nzj,t1.nynse,t1.fc_id,t1.zdsybz,t3.zgkg_dm,t3.zclx_dm" +
                " from sw_dj_fc t1" +
                " left join sw_dj_sy t2" +
                " on t1.sy_id=t2.sy_id" +
                " left join  sw_dj_jbb t3" +
                " on t1.jbb_id=t3.jbb_id "+
                " where (t2.syzt is null or t2.syzt='1'))t "+
                " right join(select  fc_id,rank() over(order by nvl(nynse,0) desc) as spm from sw_dj_fc)t2 on t.fc_id =t2.fc_id where 1=1 ";

        if(obj==null) {//导出全部
            sql = addParameter(swDjSyQuery,sql,beginPm,endPm,"2");
        }else{//checkbox导出
            String resultIds = "";
            String ids = String.valueOf(obj);
            String[] idsArr = ids.split(",");
            for(int i=0;i<idsArr.length;i++){
                if(i==idsArr.length-1){
                    resultIds = resultIds+"'"+idsArr[i]+"'";
                }else{
                    resultIds = resultIds+"'"+idsArr[i]+"'"+",";
                }
            }
            sql = sql + " and t.fc_id in("+resultIds+")";
        }
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        List<Object> list =  query.getResultList();
        return list;
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public List<Object> getZdsyGdzysList(HashMap param) {
        String beginPm = String.valueOf(param.get("beginPm")==null?"":param.get("beginPm"));
        String endPm = String.valueOf(param.get("endPm")==null?"":param.get("endPm"));
        Object obj = param.get("ids");
        SwDjSyQuery swDjSyQuery = (SwDjSyQuery) param.get("swDjSyQuery");
        String sql ="select rownum as pm,t.* from( " +
                "select t3.nsrsbh,t3.nsrmc,t3.zgkg_mc,t3.sgy_mc," +
                "t4.pcmc, " +
                "t1.ynse,t1.dwse,t1.jmse," +
                "rank() over(order by nvl(t1.ynse, 0) desc) as spm," +
                "t1.gdzys_id,t3.zgkg_dm,t1.zdsybz " +
                "from sw_dj_gdzys t1 join sw_dj_sy t2 on t1.sy_id=t2.sy_id  " +
                "left join sw_dj_jbb t3 on t1.jbb_id=t3.jbb_id   " +
                "left join sw_dj_pcxx t4 on t4.pc_id=t2.bp_id "+
                "where ( t4.pc_id is not null and "+"t2.syzt is null or t2.syzt='1' ))t where  1=1 ";

        if(obj==null) {//导出全部
            //筛选重点税源，只导出重点税源
            sql += " and t.Zdsybz = '1' ";
            sql = addParameter(swDjSyQuery,sql,beginPm,endPm,"3");
        }else{//checkbox导出
            String resultIds = "";
            String ids = String.valueOf(obj);
            String[] idsArr = ids.split(",");
            for(int i=0;i<idsArr.length;i++){
                if(i==idsArr.length-1){
                    resultIds = resultIds+"'"+idsArr[i]+"'";
                }else{
                    resultIds = resultIds+"'"+idsArr[i]+"'"+",";
                }
            }
            sql = sql + " and t.gdzys_id in("+resultIds+")";
        }
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        List<Object> list =  query.getResultList();
        return list;
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public List<Object> getZdsyQsList(HashMap param) {
        String beginPm = String.valueOf(param.get("beginPm")==null?"":param.get("beginPm"));
        String endPm = String.valueOf(param.get("endPm")==null?"":param.get("endPm"));
        Object obj = param.get("ids");
        SwDjSyQuery swDjSyQuery = (SwDjSyQuery) param.get("swDjSyQuery");
        String sql ="select rownum as pm,t.* from( " +
                "select t3.nsrsbh,t3.nsrmc,t3.zgkg_mc,t3.sgy_mc, " +
                "t4.tdzl,t1.ynse,t4.xmmc,t4.gdmj,t4.qdjg,t1.yjne,t1.xbjse, " +
                "rank() over(order by nvl(t1.ynse, 0) desc) as spm, " +
                "t1.qs_id,t3.zgkg_dm,t1.zdsybz  "+
                "from sw_dj_qs t1 join sw_dj_sy t2 on t1.sy_id=t2.sy_id  " +
                "left join sw_dj_jbb t3 on t1.jbb_id=t3.jbb_id   " +
                "left join sw_dj_xmxx t4 on t4.xm_id=t2.gd_id "+
                "where ( t4.xm_id is not null and "+"t2.syzt is null or t2.syzt='1' ))t where  1=1 ";

        if(obj==null) {//导出全部
            //筛选重点税源，只导出重点税源
            sql += " and t.Zdsybz = '1' ";
            sql = addParameter(swDjSyQuery,sql,beginPm,endPm,"4");
        }else{//checkbox导出
            String resultIds = "";
            String ids = String.valueOf(obj);
            String[] idsArr = ids.split(",");
            for(int i=0;i<idsArr.length;i++){
                if(i==idsArr.length-1){
                    resultIds = resultIds+"'"+idsArr[i]+"'";
                }else{
                    resultIds = resultIds+"'"+idsArr[i]+"'"+",";
                }
            }
            sql = sql + " and t.qs_id in("+resultIds+")";
        }
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        List<Object> list =  query.getResultList();
        return list;
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public List<SwDjSyQuery> getSwdjTzList(HashMap param) {
        Object idsObj = param.get("ids");
        String sylx = String.valueOf(param.get("sylx"));
        SwDjSyQuery swDjSyQuery = (SwDjSyQuery) param.get("swDjSyQuery");
        String regionCode = "";
        try{
            regionCode = SessionUtil.getCurrentUser().getRegionCode();
        }catch (Exception e){}
        QSwDjSy qSwDjSy = QSwDjSy.swDjSy;
        QSwDjTd qSwDjTd = QSwDjTd.swDjTd;
        QSwDjFc qSwDjFc = QSwDjFc.swDjFc;
        QSwDjGdzys qSwDjGdzys = QSwDjGdzys.swDjGdzys;
        QSwDjQs qSwDjQs = QSwDjQs.swDjQs;
        QSwDjXmxx qSwDjXmxx = QSwDjXmxx.swDjXmxx;
        QSwDjJbb qSwDjJbb = QSwDjJbb.swDjJbb;
        QZd qZd = QZd.zd;
        QSwDjPcxx qSwDjPcxx = QSwDjPcxx.swDjPcxx;
        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        QBean qBean = null;

        if(sylx.equals(Sylx.TDSY.toString())){
            qBean = Projections.bean(SwDjSyQuery.class,qSwDjSy.syId,qSwDjSy.dbh,qSwDjTd.tdId,qSwDjSy.zd.djh,
                    qSwDjJbb.nsrmc,qSwDjJbb.nsrsbh,qSwDjJbb.glbm,qSwDjJbb.zgkgMc,qSwDjJbb.sgyMc,qZd.qlrmc,qZd.tdyt,qZd.scmjZd,qSwDjFc.fczl,
                    qSwDjTd.tddj,qZd.tdzl,qSwDjTd.scmj,qSwDjTd.tdsyytDm,qSwDjTd.msmj,qSwDjTd.ynmj,qSwDjTd.dwse,qSwDjTd.sgztDm,qSwDjTd.sgztMc,qSwDjTd.sjly,qSwDjTd.nynseTd,qSwDjTd.msse,qSwDjTd.zdsybz);

            jpaQuery.from(qSwDjTd).leftJoin(qSwDjTd.swDjSy,qSwDjSy).leftJoin(qSwDjTd.swDjJbb,qSwDjJbb).leftJoin(qSwDjSy.swDjFc, qSwDjFc).leftJoin(qSwDjSy.zd, qZd).leftJoin(qSwDjSy.swDjXmxx,qSwDjXmxx);
            jpaQuery.where(qSwDjTd.tdId.isNotNull());
            if(swDjSyQuery!=null){
                if(swDjSyQuery.getIsMsTz()!=null && swDjSyQuery.getIsMsTz()){
                    jpaQuery.where(qSwDjTd.msmj.isNotNull().and(qSwDjTd.msmj.gt(new BigDecimal(0))));
                    jpaQuery.orderBy(qSwDjTd.msmj.desc().nullsLast());
                }else{
                    jpaQuery.orderBy(qSwDjTd.nynseTd.desc().nullsLast());
                }
            }

        }else if(sylx.equals(Sylx.FCSY.toString())){
            qBean = Projections.bean(SwDjSyQuery.class,qSwDjSy.syId,qSwDjSy.dbh,qSwDjTd.tdId,qSwDjSy.zd.djh,qSwDjJbb.nsrmc,
                    qSwDjJbb.glbm,qSwDjJbb.nsrsbh,qSwDjJbb.zgkgMc,qSwDjJbb.sgyMc,qZd.qlrmc,qZd.tdyt,qZd.scmjZd,qSwDjTd.tdzl,qSwDjTd.scmj,
                    qSwDjFc.fczl,qSwDjFc.fcyz,qSwDjFc.fcyzYs,qSwDjFc.fcyzMs,qSwDjFc.ynseZy,qSwDjFc.nzj,qSwDjFc.sl,qSwDjFc.ynseCz,qSwDjFc.nynseFc,qSwDjFc.sgztDm,qSwDjFc.sgztMc,qSwDjFc.sjly,qSwDjFc.fcId,qSwDjFc.zdsybz,qSwDjFc.fwxzDm);

            jpaQuery.from(qSwDjFc).leftJoin(qSwDjFc.swDjSy,qSwDjSy).leftJoin(qSwDjFc.swDjJbb,qSwDjJbb).leftJoin(qSwDjSy.swDjTd,qSwDjTd).leftJoin(qSwDjSy.zd,qZd).leftJoin(qSwDjSy.swDjXmxx,qSwDjXmxx);
            jpaQuery.where(qSwDjFc.fcId.isNotNull());
            if(swDjSyQuery!=null){
                if(swDjSyQuery.getIsMsTz()!=null && swDjSyQuery.getIsMsTz()){
                    jpaQuery.where(qSwDjFc.fcyzMs.isNotNull().and(qSwDjFc.fcyzMs.gt(new BigDecimal(0))));
                    jpaQuery.orderBy(qSwDjFc.fcyzMs.desc().nullsLast());
                }else{
                    jpaQuery.orderBy(qSwDjFc.nynseFc.desc().nullsLast());
                }
            }

        }else if(sylx.equals(Sylx.GDZYS.toString())){
            qBean = Projections.bean(SwDjSyQuery.class, qSwDjSy.syId, qSwDjPcxx.pcId, qSwDjPcxx.pcmc, qSwDjPcxx.pwh, qSwDjPcxx.pzmj, qSwDjPcxx.nydmj,qSwDjPcxx.jbntmj,qSwDjPcxx.fgdnydmj,qSwDjPcxx.gdmj,
                    qSwDjPcxx.pzsj, qSwDjPcxx.pcYddw, qSwDjPcxx.pcXzqdm, qSwDjGdzys.gdzysId, qSwDjGdzys.gdzysYnse, qSwDjGdzys.gdzysDwse, qSwDjGdzys.gdzysJmxz, qSwDjGdzys.gdzysJmse, qSwDjGdzys.gdzysJspz,
                    qSwDjGdzys.gdzysYjne, qSwDjGdzys.gdzysXbjse, qSwDjGdzys.gdzysBz, qSwDjGdzys.gdzysLrrq, qSwDjGdzys.gdzysHclx,
                    qSwDjJbb.glbm, qSwDjJbb.nsrmc, qSwDjJbb.zgkgDm, qSwDjJbb.zgkgMc);

            jpaQuery.from(qSwDjSy).leftJoin(qSwDjSy.swDjGdzys, qSwDjGdzys).leftJoin(qSwDjSy.swDjPcxx, qSwDjPcxx).leftJoin(qSwDjGdzys.swDjJbb, qSwDjJbb).where(qSwDjPcxx.pcId.isNotNull());
            jpaQuery.where(qSwDjGdzys.gdzysId.isNotNull()).where(qSwDjSy.syId.isNotNull());
        }else if(sylx.equals(Sylx.QS.toString())){
            qBean = Projections.bean(SwDjSyQuery.class,qSwDjSy.syId,qSwDjSy.dbh,qSwDjJbb.nsrmc,
                    qSwDjJbb.glbm,qSwDjJbb.nsrsbh,qSwDjJbb.zgkgMc,qSwDjJbb.sgyMc,
                    qSwDjQs.qsId,qSwDjQs.qsSzly,qSwDjQs.qsYnse,qSwDjQs.qsYjne,qSwDjQs.qsJmxz,qSwDjQs.qsJspz,qSwDjQs.qsXbjse,qSwDjQs.qsBz,qSwDjQs.qsLrrq,qSwDjQs.qsHclx,
                    qSwDjXmxx.xmmc,qSwDjXmxx.xmYddw,qSwDjXmxx.gdmj,qSwDjXmxx.qdfs,qSwDjXmxx.qdjg,qSwDjXmxx.gdsj);

            jpaQuery.from(qSwDjQs).leftJoin(qSwDjQs.swDjSy,qSwDjSy).leftJoin(qSwDjQs.swDjJbb,qSwDjJbb).leftJoin(qSwDjSy.swDjXmxx,qSwDjXmxx);
            jpaQuery.where(qSwDjQs.qsId.isNotNull()).where(qSwDjSy.syId.isNotNull());
        }
        jpaQuery.where(qSwDjSy.syzt.eq(Syzt.ZC.toString()).or(qSwDjSy.syzt.isNull()).or(qSwDjSy.syzt.eq("")));

        if(idsObj!=null){
            String ids = String.valueOf(idsObj);
            List idsList = Arrays.asList(ids.split(","));
            jpaQuery.where(qSwDjSy.syId.in(idsList));
        }else{
            if(StringUtils.isNotBlank(swDjSyQuery.getDjh()))
                jpaQuery.where(qSwDjSy.zd.djh.like(QueryCondition.WILDCARDS + swDjSyQuery.getDjh() + QueryCondition.WILDCARDS));
            if(StringUtils.isNotBlank(swDjSyQuery.getXzqdm()))
                jpaQuery.where(qSwDjSy.zd.djh.like(swDjSyQuery.getXzqdm() + QueryCondition.WILDCARDS));

            if(sylx.equals(Sylx.TDSY.toString())){
                if(swDjSyQuery.getIsMsTz()!=null && swDjSyQuery.getIsMsTz()){
                    jpaQuery.where(qSwDjTd.msmj.isNotNull().and(qSwDjTd.msmj.gt(new BigDecimal(0))));
                }
                if("1".equals(swDjSyQuery.getMsbz())){
                    jpaQuery.where(qSwDjTd.msbz.eq("1"));
                }
                if("2".equals(swDjSyQuery.getMsbz())){
                    jpaQuery.where(qSwDjTd.msbz.isNull().or(qSwDjTd.msbz.eq("")));
                }
                if(StringUtils.isNotBlank(swDjSyQuery.getSgztDm())){
                    jpaQuery.where(qSwDjTd.sgztDm.eq(swDjSyQuery.getSgztDm()));
                }
            }else if(sylx.equals(Sylx.FCSY.toString())){
                if(swDjSyQuery.getIsMsTz()!=null && swDjSyQuery.getIsMsTz()){
                    jpaQuery.where(qSwDjFc.fcyzMs.isNotNull().and(qSwDjFc.fcyzMs.gt(new BigDecimal(0))));
                }
                if("1".equals(swDjSyQuery.getMsbz())){
                    jpaQuery.where(qSwDjFc.msbz.eq("1"));
                }
                if("2".equals(swDjSyQuery.getMsbz())){
                    jpaQuery.where(qSwDjFc.msbz.isNull().or(qSwDjFc.msbz.eq("")));
                }
                if(StringUtils.isNotBlank(swDjSyQuery.getSgztDm())){
                    jpaQuery.where(qSwDjFc.sgztDm.eq(swDjSyQuery.getSgztDm()));
                }
            }else if(sylx.equals(Sylx.GDZYS.toString())){
                if(StringUtils.isNotBlank(swDjSyQuery.getPcXzqdm()))
                    jpaQuery.where(Expressions.stringPath(qSwDjPcxx, "pcXzqdm").eq(swDjSyQuery.getPcXzqdm()));
                if(StringUtils.isNotBlank(swDjSyQuery.getPcmc()))
                    jpaQuery.where(Expressions.stringPath(qSwDjPcxx, "pcmc").like(QueryCondition.WILDCARDS + swDjSyQuery.getPcmc() + QueryCondition.WILDCARDS));
                if(StringUtils.isNotBlank(swDjSyQuery.getZdsybz())){
                    jpaQuery.where(Expressions.stringPath(qSwDjGdzys, "zdsybz").eq(swDjSyQuery.getZdsybz()));
                }
            }else if(sylx.equals(Sylx.QS.toString())){
                if(StringUtils.isNotBlank(swDjSyQuery.getXmXzqdm()))
                    jpaQuery.where(Expressions.stringPath(qSwDjXmxx, "xmXzqdm").eq(swDjSyQuery.getXmXzqdm()));
                if(StringUtils.isNotBlank(swDjSyQuery.getXmmc()))
                    jpaQuery.where(Expressions.stringPath(qSwDjXmxx, "xmmc").like(QueryCondition.WILDCARDS + swDjSyQuery.getXmmc() + QueryCondition.WILDCARDS));
                if(StringUtils.isNotBlank(swDjSyQuery.getQdfs()))
                    jpaQuery.where(Expressions.stringPath(qSwDjXmxx, "qdfs").eq(swDjSyQuery.getQdfs()));
                if(StringUtils.isNotBlank(swDjSyQuery.getXmTdyt()))
                    jpaQuery.where(Expressions.stringPath(qSwDjXmxx, "xmTdyt").eq(swDjSyQuery.getXmTdyt()));
                if(StringUtils.isNotBlank(swDjSyQuery.getXmYddw()))
                    jpaQuery.where(Expressions.stringPath(qSwDjXmxx, "xmYddw").like(QueryCondition.WILDCARDS + swDjSyQuery.getXmYddw() + QueryCondition.WILDCARDS));
                if(StringUtils.isNotBlank(swDjSyQuery.getZdsybz())){
                    jpaQuery.where(Expressions.stringPath(qSwDjQs, "zdsybz").eq(swDjSyQuery.getZdsybz()));
                }
            }
            if(StringUtils.isNotBlank(regionCode)){
                if (regionCode.length() > 6)
                    regionCode = regionCode.substring(0, 6);
                jpaQuery.where(qSwDjJbb.zgkgDm.like("2" + regionCode + QueryCondition.WILDCARDS));
            }
            applySwDjSyQueryPredicates(swDjSyQuery,qSwDjSy,qSwDjJbb, qSwDjTd,qSwDjFc,qZd,qSwDjXmxx,jpaQuery);
        }

        baseRepository.addEntityPath(qSwDjSy);
        return (List)baseRepository.dslList(jpaQuery,qBean);
    }


    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public String getIsYsdlByDm(String dm) {
        String whereClause = " where DM='"+dm+"'";
        String sql = "select ISYS from S_ZD_DLDM "+whereClause;
        String isys = String.valueOf(baseRepository.getEntityManager().createNativeQuery(sql).getSingleResult());
        if("1".equals(isys)){
            return "是";
        }
        return "否";
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public String getDwseByTddj(String tddj) {
        String whereClause = " where DM='"+tddj+"'";
        String sql = "select sl from s_zd_tdjb "+whereClause;
        String sl = "";
        try {
            sl= String.valueOf(baseRepository.getEntityManager().createNativeQuery(sql).getSingleResult());
        }catch (Exception e){}

        return sl;
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public List<SwDjSyQuery> getSwDjSyByGlbm(String nsrsbh,String szdm) {
        QSwDjSy qSwDjSy = QSwDjSy.swDjSy;
        QSwDjTd qSwDjTd = QSwDjTd.swDjTd;
        QSwDjFc qSwDjFc = QSwDjFc.swDjFc;
        QSwDjXmxx qSwDjXmxx = QSwDjXmxx.swDjXmxx;
        QSwDjPcxx qSwDjPcxx = QSwDjPcxx.swDjPcxx;
        QZd qZd = QZd.zd;
        QSwDjJbb qSwDjJbb = QSwDjJbb.swDjJbb;
        JPQLQuery query = new JPAQuery(baseRepository.getEntityManager());
        QBean qBean = null;
        if(szdm.equals(Szdm.CZTDSYS.toString())){
            qBean = Projections.bean(SwDjSyQuery.class,qSwDjSy.zd.djh,qSwDjSy.dbh,qSwDjJbb.nsrsbh,qSwDjJbb.glbm,qSwDjJbb.djxh,qSwDjJbb.nsrmc,qSwDjTd.czrmc,qSwDjTd.czrzjhm,qZd.tdzl,
                    qZd.tdyt,qZd.qlrmc,qZd.scmjZd,qSwDjJbb.zgkgDm,qSwDjJbb.sgyMc,qSwDjJbb.fddbr,qSwDjJbb.lxdh,qSwDjJbb.zclxDm,qSwDjJbb.hyDm,qSwDjJbb.zcdz,
                    qSwDjTd.tdsyztDm,qSwDjTd.fzmj,qSwDjTd.scmj,qSwDjTd.tddj,qSwDjTd.msmj,qSwDjTd.ynmj,qSwDjTd.dwse,qSwDjTd.nynseTd,
                    qSwDjTd.tdId,qSwDjSy.syId, qSwDjSy.sysjly, qSwDjXmxx.xmId, qSwDjPcxx.pcId);
            query.from(qSwDjSy).leftJoin(qSwDjSy.swDjTd, qSwDjTd).leftJoin(qSwDjTd.swDjJbb,qSwDjJbb).leftJoin(qSwDjSy.zd, qZd)
                    .leftJoin(qSwDjSy.swDjXmxx, qSwDjXmxx).leftJoin(qSwDjSy.swDjPcxx, qSwDjPcxx).where(qSwDjJbb.nsrsbh.eq(nsrsbh));
            query.where(qSwDjSy.syzt.eq(Syzt.ZC.toString()).or(qSwDjSy.syzt.isNull()));
        }else if(szdm.equals(Szdm.FCS.toString())){
            qBean = Projections.bean(SwDjSyQuery.class,qSwDjSy.zd.djh,qSwDjSy.dbh,qSwDjJbb.nsrsbh,qSwDjJbb.glbm,qSwDjJbb.nsrmc,
                    qZd.tdyt,qZd.qlrmc,qZd.scmjZd,qSwDjJbb.zgkgDm,qSwDjJbb.sgyMc,qSwDjJbb.fddbr,qSwDjJbb.lxdh,qSwDjJbb.zclxDm,qSwDjJbb.hyDm,qSwDjJbb.zcdz,
                    qSwDjFc.fczh,qSwDjFc.fcmj,qSwDjFc.fwxzDm,qSwDjFc.zyhczDm,qSwDjFc.fwjz,qSwDjFc.tdjz,qSwDjFc.fssbjz,qSwDjFc.fcyz,
                    qSwDjFc.fcyzYs,qSwDjFc.fcyzMs,qSwDjFc.ynseZy,qSwDjFc.ynseCz,qSwDjFc.nzj,qSwDjFc.nynseFc,qSwDjFc.fcId,
                    qSwDjSy.syId, qSwDjSy.sysjly, qSwDjXmxx.xmId, qSwDjPcxx.pcId);
            query.from(qSwDjSy).rightJoin(qSwDjSy.swDjFc,qSwDjFc).leftJoin(qSwDjFc.swDjJbb,qSwDjJbb).leftJoin(qSwDjSy.zd, qZd)
                    .leftJoin(qSwDjSy.swDjXmxx, qSwDjXmxx).leftJoin(qSwDjSy.swDjPcxx, qSwDjPcxx).where(qSwDjJbb.nsrsbh.eq(nsrsbh));
            query.where(qSwDjSy.syzt.eq(Syzt.ZC.toString()).or(qSwDjSy.syzt.isNull()));
        }
        return (List)baseRepository.dslList(query,qBean);
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public List<SwDjSyQuery> getSwDjSyByDjxh(String djxh,String szdm) {
        QSwDjSy qSwDjSy = QSwDjSy.swDjSy;
        QSwDjTd qSwDjTd = QSwDjTd.swDjTd;
        QSwDjFc qSwDjFc = QSwDjFc.swDjFc;
        QSwDjXmxx qSwDjXmxx = QSwDjXmxx.swDjXmxx;
        QSwDjPcxx qSwDjPcxx = QSwDjPcxx.swDjPcxx;
        QZd qZd = QZd.zd;
        QSwDjJbb qSwDjJbb = QSwDjJbb.swDjJbb;
        JPQLQuery query = new JPAQuery(baseRepository.getEntityManager());
        QBean qBean = null;
        if(szdm.equals(Szdm.CZTDSYS.toString())){
            qBean = Projections.bean(SwDjSyQuery.class,qSwDjSy.zd.djh,qSwDjSy.dbh,qSwDjJbb.nsrsbh,qSwDjJbb.glbm,qSwDjJbb.djxh,qSwDjJbb.nsrmc,qSwDjTd.czrmc,qSwDjTd.czrzjhm,qZd.tdzl,
                    qZd.tdyt,qZd.qlrmc,qZd.scmjZd,qSwDjJbb.zgkgDm,qSwDjJbb.sgyMc,qSwDjJbb.fddbr,qSwDjJbb.lxdh,qSwDjJbb.zclxDm,qSwDjJbb.hyDm,qSwDjJbb.zcdz,
                    qSwDjTd.tdsyztDm,qSwDjTd.fzmj,qSwDjTd.scmj,qSwDjTd.tddj,qSwDjTd.msmj,qSwDjTd.ynmj,qSwDjTd.dwse,qSwDjTd.nynseTd,
                    qSwDjTd.tdId,qSwDjSy.syId, qSwDjSy.sysjly, qSwDjXmxx.xmId, qSwDjPcxx.pcId);
            query.from(qSwDjSy).leftJoin(qSwDjSy.swDjTd, qSwDjTd).leftJoin(qSwDjTd.swDjJbb,qSwDjJbb).leftJoin(qSwDjSy.zd, qZd)
                    .leftJoin(qSwDjSy.swDjXmxx, qSwDjXmxx).leftJoin(qSwDjSy.swDjPcxx, qSwDjPcxx).where(qSwDjJbb.djxh.eq(djxh));
            query.where(qSwDjSy.syzt.eq(Syzt.ZC.toString()).or(qSwDjSy.syzt.isNull()));
        }else if(szdm.equals(Szdm.FCS.toString())){
            qBean = Projections.bean(SwDjSyQuery.class,qSwDjSy.zd.djh,qSwDjSy.dbh,qSwDjJbb.nsrsbh,qSwDjJbb.glbm,qSwDjJbb.nsrmc,
                    qZd.tdyt,qZd.qlrmc,qZd.scmjZd,qSwDjJbb.zgkgDm,qSwDjJbb.sgyMc,qSwDjJbb.fddbr,qSwDjJbb.lxdh,qSwDjJbb.zclxDm,qSwDjJbb.hyDm,qSwDjJbb.zcdz,
                    qSwDjFc.fczh,qSwDjFc.fcmj,qSwDjFc.fwxzDm,qSwDjFc.zyhczDm,qSwDjFc.fwjz,qSwDjFc.tdjz,qSwDjFc.fssbjz,qSwDjFc.fcyz,
                    qSwDjFc.fcyzYs,qSwDjFc.fcyzMs,qSwDjFc.ynseZy,qSwDjFc.ynseCz,qSwDjFc.nzj,qSwDjFc.nynseFc,qSwDjFc.fcId,
                    qSwDjSy.syId, qSwDjSy.sysjly, qSwDjXmxx.xmId, qSwDjPcxx.pcId);
            query.from(qSwDjSy).rightJoin(qSwDjSy.swDjFc,qSwDjFc).leftJoin(qSwDjFc.swDjJbb,qSwDjJbb).leftJoin(qSwDjSy.zd, qZd)
                    .leftJoin(qSwDjSy.swDjXmxx, qSwDjXmxx).leftJoin(qSwDjSy.swDjPcxx, qSwDjPcxx).where(qSwDjJbb.nsrsbh.eq(djxh));
            query.where(qSwDjSy.syzt.eq(Syzt.ZC.toString()).or(qSwDjSy.syzt.isNull()));
        }
        return (List)baseRepository.dslList(query,qBean);
    }

    /**
     * 诚征土地使用税税源列表，根据税种代码（szdm）区分
     * @param sbZsQuery
     * @return
     */
    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public List<HashMap<String,Object>> getSbSyxxListByGlbm(SbZsQuery sbZsQuery,String szdm) {
        int sqTotal = 4;
        if(szdm.equals(Szdm.CZTDSYS.toString())){
            sqTotal = 4;
        }else if(szdm.equals(Szdm.FCS.toString())){
            sqTotal = 2;
        }

        String year = sbZsQuery.getYear();
        int jdlx = Integer.valueOf(sbZsQuery.getJdlx());
        int sqBegin, sqEnd;
        sqBegin = (jdlx - 1) / sqTotal + 1;
        sqEnd = (jdlx - 1) % sqTotal + 1;
        String startRq = year + StringUtils.right("0" + String.valueOf((sqBegin - 1) * (12 / sqTotal) + 1), 2);
        String endRq = year + StringUtils.right("0" + String.valueOf(sqEnd * (12 / sqTotal)), 2);

        String sql = "";
        sql =   "select sb_num, fsrq, szdm, nsrsbh, nse " +
                "from local_sb_yzss t " +
                "where t.szdm='%s' and (TO_CHAR(fsrq, 'YYYYMM') >= '%s' AND TO_CHAR(fsrq, 'YYYYMM') <= '%s') and nsrsbh='%s' " +
                "order by fsrq";
        sql = String.format(sql, szdm, startRq, endRq, sbZsQuery.getNsrsbh());

        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        return query.getResultList();
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public List<SwDjSyQuery> getFcSwDjSyByGlbm(String nsrsbh) {
        QSwDjSy qSwDjSy = QSwDjSy.swDjSy;
        QSwDjFc qSwDjFc = QSwDjFc.swDjFc;
        QZd qZd = QZd.zd;
        QSwDjJbb qSwDjJbb = QSwDjJbb.swDjJbb;
        JPQLQuery query = new JPAQuery(baseRepository.getEntityManager());

        QBean qBean = Projections.bean(SwDjSyQuery.class,qSwDjSy.zd.djh,qSwDjSy.dbh,qSwDjJbb.glbm,qSwDjJbb.nsrsbh,qSwDjJbb.nsrmc,
                qZd.tdyt,qZd.qlrmc,qZd.scmjZd,qSwDjJbb.zgkgDm,qSwDjJbb.sgyMc,qSwDjJbb.fddbr,qSwDjJbb.lxdh,qSwDjJbb.zclxDm,qSwDjJbb.hyDm,qSwDjJbb.zcdz,
                qSwDjFc.fczh,qSwDjFc.fcmj,qSwDjFc.fwxzDm,qSwDjFc.zyhczDm,qSwDjFc.fwjz,qSwDjFc.tdjz,qSwDjFc.fssbjz,qSwDjFc.fcyz,
                qSwDjFc.fcyzYs,qSwDjFc.fcyzMs,qSwDjFc.ynseZy,qSwDjFc.ynseCz,qSwDjFc.nzj,qSwDjFc.nynseFc,qSwDjFc.fcId,qSwDjSy.syId);
        query.from(qSwDjSy).rightJoin(qSwDjSy.swDjFc,qSwDjFc).leftJoin(qSwDjFc.swDjJbb,qSwDjJbb).leftJoin(qSwDjSy.zd, qZd).where(qSwDjJbb.nsrsbh.eq(nsrsbh));
        query.where(qSwDjSy.syzt.eq(Syzt.ZC.toString()).or(qSwDjSy.syzt.isNull()));
        return (List)baseRepository.dslList(query,qBean);
    }

    @Override
    public List<SwDjSyQuery> getFcSbSyxxListByGlbm(String nsrsbh) {
        QSbYzss qSbYzss = QSbYzss.sbYzss;
        JPQLQuery query =  new JPAQuery(baseRepository.getEntityManager());
        QBean qBean = Projections.bean(SwDjSyQuery.class,qSbYzss.sbNum,qSbYzss.fsrq,qSbYzss.glbm,qSbYzss.nse);
        query.from(qSbYzss);
        query.where(qSbYzss.glbm.eq(nsrsbh)).where(qSbYzss.szdm.eq(Szdm.FCS.toString()));
        return (List)baseRepository.dslList(query,qBean);
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public HashMap getHj(String sylx,SwDjSyQuery swDjSyQuery) {
        if(StringUtils.isBlank(sylx)){
            sylx=Sylx.TDSY.toString();
        }

        HashMap result = new HashMap();
        //计算税源数据宗地数
        Object zdCount = getSyZdCount(sylx,swDjSyQuery);
        result.put("zdCount",zdCount);
        //计算税源户数
        Object syhsCount = getSyhsCount(sylx, swDjSyQuery);
        result.put("syhsCount",syhsCount);


        if(StringUtils.isBlank(sylx) || Sylx.TDSY.toString().equals(sylx) || Sylx.FCSY.toString().equals(sylx)) {
            //计算控管户户数
            Object kghCount = getKghCount(sylx, swDjSyQuery);
            result.put("kghCount", kghCount);
            //计算漏征漏管户数
            Object lzlghCount = getLzlghCount(sylx, swDjSyQuery);
            result.put("lzlghCount", lzlghCount);
            //计算可转化税源户数
            Object kzhsyCount = getKzhsyCount(sylx, swDjSyQuery);
            result.put("kzhsyCount", kzhsyCount);
            //计算机关单位户数
            Object jgdwCount = getJgdwCount(sylx, swDjSyQuery);
            result.put("jgdwCount", jgdwCount);
            //计算个人户数
            Object grCount = getGrCount(sylx, swDjSyQuery);
            result.put("grCount", grCount);
        }

        //计算合计

        HashMap resultMap = (HashMap)getHjmjAndFcyz(sylx, swDjSyQuery);
        Object scmj = resultMap.get("SCMJ");
        if(scmj==null){
            scmj=0;
        }
        result.put("scmj",scmj);

        Object msmj = resultMap.get("MSMJ");
        if(msmj==null){
            msmj=0;
        }
        result.put("msmj",msmj);
        Object ynmj = resultMap.get("YNMJ");
        if(ynmj==null){
            ynmj=0;
        }
        result.put("ynmj",ynmj);
        Object nynse = resultMap.get("NYNSE");
        if(nynse==null){
            nynse=0;
        }
        result.put("nynse",nynse);
        Object fcyz = resultMap.get("FCYZ");
        if(fcyz==null){
            fcyz=0;
        }
        result.put("fcyz",fcyz);
        Object fcyz_ys = resultMap.get("FCYZ_YS");
        if(fcyz_ys==null){
            fcyz_ys=0;
        }
        result.put("fcyz_ys",fcyz_ys);
        Object fcyz_ms = resultMap.get("FCYZ_MS");
        if(fcyz_ms==null){
            fcyz_ms=0;
        }
        result.put("fcyz_ms",fcyz_ms);
        Object ynse_zy = resultMap.get("YNSE_ZY");
        if(ynse_zy==null){
            ynse_zy=0;
        }
        result.put("ynse_zy",ynse_zy);
        Object ynse_cz = resultMap.get("YNSE_CZ");
        if(ynse_cz==null){
            ynse_cz=0;
        }
        result.put("ynse_cz",ynse_cz);
        Object nzj = resultMap.get("NZJ");
        if(nzj==null){
            nzj=0;
        }
        result.put("nzj",nzj);


        Object gdzysYnse = resultMap.get("GDZYSYNSE");
        if(gdzysYnse==null){
            gdzysYnse=0;
        }
        result.put("gdzys_ynse",gdzysYnse);
        Object gdzysYjne = resultMap.get("GDZYSYJNE");
        if(gdzysYjne==null){
            gdzysYjne=0;
        }
        result.put("gdzys_yjne",gdzysYjne);
        Object gdzysXbjse = resultMap.get("GDZYSXBJSE");
        if(gdzysXbjse==null){
            gdzysXbjse=0;
        }
        result.put("gdzys_xbjse",gdzysXbjse);
        Object qsYnse = resultMap.get("QSYNSE");
        if(qsYnse==null){
            qsYnse=0;
        }
        result.put("qs_ynse",qsYnse);
        Object qsYjne = resultMap.get("QSYJNE");
        if(qsYjne==null){
            qsYjne=0;
        }
        result.put("qs_yjne",qsYjne);
        Object qsXbjse = resultMap.get("QSXBJSE");
        if(qsXbjse==null){
            qsXbjse=0;
        }
        result.put("qs_xbjse",qsXbjse);

        //以下是免税税源查询统计的逻辑
        if(swDjSyQuery != null) {
            if ( swDjSyQuery.getIsMsTz() != null && swDjSyQuery.getIsMsTz() == true) {
                HashMap resultmap = (HashMap) getTdfcsy(sylx, swDjSyQuery);
                if(resultMap != null){
                    if (StringUtils.isBlank(sylx) || Sylx.TDSY.toString().equals(sylx)) {
                        //计算免税税源数
                        Object mssys = getSyhsCount(sylx, swDjSyQuery);
                        result.put("mssys", mssys);
                        Object mstdmj = resultmap.get("MSMJ");
                        if (mstdmj == null) {
                            mstdmj = 0;
                        }
                        result.put("mstdmj", mstdmj);
                        Object msse = resultmap.get("MSSE");
                        if (msse == null) {
                            msse = 0;
                        }
                        result.put("msse", msse);
                    } else if (Sylx.FCSY.toString().equals(sylx)) {
                        Object msfcyz = resultmap.get("FCYZ");
                        if (msfcyz == null) {
                            msfcyz = 0;
                        }
                        result.put("msfcyz", msfcyz);
                        Object mssefc = resultmap.get("FCYZ_MS");
                        if (mssefc == null) {
                            mssefc = 0;
                        }
                        result.put("mssefc", mssefc);
                    }
                }

            }
        }


        return result;
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public HashMap getMjHj(String sylx,SwDjSyQuery swDjSyQuery) {
        if(StringUtils.isBlank(sylx)){
            sylx=Sylx.TDSY.toString();
        }
        HashMap result = new HashMap();
        //计算疑点总数
        Object ydCount = getMjYdCount(sylx, swDjSyQuery,"");
        result.put("ydCount",ydCount);
        //计算疑点未处理
        Object wydCount = getMjYdCount(sylx, swDjSyQuery,"01");
        result.put("wydCount",wydCount);
        //计算疑点已处理
        Object yydCount = getMjYdCount(sylx, swDjSyQuery,"02");
        result.put("yydCount",yydCount);
        return result;
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public Object getHjmjAndFcyz(String sylx, SwDjSyQuery swDjSyQuery) {
        String sql = "";
        if(StringUtils.isBlank(sylx) || Sylx.TDSY.toString().equals(sylx)){
            sql = "select sum(nvl(t1.scmj,0))scmj,sum(nvl(t1.msmj,0))msmj,sum(nvl(t1.ynmj,0))ynmj,sum(nvl(t1.nynse,0))nynse from sw_dj_td t1  " +
                    "left join sw_dj_sy t2 on t1.sy_id=t2.sy_id " +
                    "left join zd t3 on t3.djh=t2.djh " +
                    "left join sw_dj_jbb t4 on t4.jbb_id=t1.jbb_id "+
                    "left join sw_dj_xmxx t7 on t7.xm_id=t2.gd_id "+
                    "where (t2.syzt='1' or t2.syzt is null)  and t4.zgkg_dm like '2" + dwxxService.getUserRegionCode() + "%' ";
        }else if(Sylx.FCSY.toString().equals(sylx)){
            sql = "select sum(nvl(t1.fcyz,0))fcyz,sum(nvl(t1.fcyz_ys,0))fcyz_ys,sum(nvl(t1.fcyz_ms,0))fcyz_ms,sum(nvl(t1.ynse_zy,0))ynse_zy,sum(nvl(t1.ynse_cz,0))ynse_cz,sum(nvl(t1.nynse,0))nynse,sum(nvl(t1.nzj,0))nzj from sw_dj_fc t1  " +
                    "left join sw_dj_sy t2 on t1.sy_id=t2.sy_id " +
                    "left join zd t3 on t3.djh=t2.djh " +
                    "left join sw_dj_td t5 on t5.sy_id=t2.sy_id "+
                    "left join sw_dj_jbb t4 on t4.jbb_id=t5.jbb_id "+
                    "left join sw_dj_xmxx t7 on t7.xm_id=t2.gd_id "+
                    "where (t2.syzt='1' or t2.syzt is null)  and t4.zgkg_dm like '2" + dwxxService.getUserRegionCode() + "%'";
        }else if(Sylx.GDZYS.toString().equals(sylx)){
            sql = "select nvl(sum(ynse),0)gdzysYnse,nvl(sum(yjne),0)gdzysYjne,nvl(sum(xbjse),0)gdzysXbjse from sw_dj_gdzys t1 " +
                    "join sw_dj_sy t2 on t1.sy_id=t2.sy_id " +
                    "left join zd t3 on t3.djh=t2.djh " +
                    "left join sw_dj_td t5 on t5.sy_id=t2.sy_id "+
                    "left join sw_dj_jbb t4 on t4.jbb_id=t1.jbb_id "+
                    "left join sw_dj_pcxx t6  on t6.pc_id=t2.bp_id "+
                    "where (t2.syzt='1' or t2.syzt is null)  and t4.zgkg_dm like '2" + dwxxService.getUserRegionCode() + "%' ";
        }else if(Sylx.QS.toString().equals(sylx)){
            sql = "select nvl(sum(t1.ynse),0)qsYnse,nvl(sum(t1.yjne),0)qsYjne,nvl(sum(t1.xbjse),0)qsXbjse FROM SW_DJ_QS t1 " +
                    "join sw_dj_sy t2 on t1.sy_id=t2.sy_id " +
                    "left join zd t3 on t3.djh=t2.djh " +
                    "left join sw_dj_td t5 on t5.sy_id=t2.sy_id "+
                    "left join sw_dj_jbb t4 on t4.jbb_id=t1.jbb_id "+
                    "left join sw_dj_xmxx t7  on t7.xm_id=t2.gd_id "+
                    "where  (t2.syzt='1' or t2.syzt is null)  and t4.zgkg_dm like '2" + dwxxService.getUserRegionCode() + "%' ";
        }
        sql = sql +addSyxxParameter(swDjSyQuery,sylx,false);
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        Object resultMap = query.getSingleResult();
        return resultMap;
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public Object getSgjgByQx(String qx) {
        String sql = "select substr(t.swbmbm,2,8) as SWBMBM,t.mc  from DM_SWBM t where t.swbmbm like '2"+qx+"%' "+"and SUBSTR(SWBMBM, 10, 2)='00' and SUBSTR(SWBMBM, 8, 2)<>'00'";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        return list;
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public List<Map<String, Object>> tjNynseByQx(String sylx,String[] queryDwdm,String nf) {
        String regionCode = SessionUtil.getCurrentUser().getRegionCode();
        String sql = "";
        String dwdmStr = "";
        for(int i=0;i<queryDwdm.length;i++){
            if(StringUtils.isNotBlank(queryDwdm[i])){
                if(i==queryDwdm.length-1){
                    dwdmStr+="'"+queryDwdm[i]+"'";
                }else{
                    dwdmStr+="'"+queryDwdm[i]+"',";
                }

            }
        }
        if(regionCode.length()==4){//市
            if(Sylx.TDSY.toString().equals(sylx)){
                sql="select t1.dwdm,t1.dwmc,round(t1.sumNynse,2)sumNynse,round(nvl(t2.sumtaxfinal,0),2)sumtaxfinal,round((t1.sumnynse-nvl(t2.sumtaxfinal,0)),2)qjse from (select t1.dwdm,t1.dwmc,t2.sumNynse from (select t.dwdm,t.dwmc from s_dm_dwxx_cz t where length(t.dwdm)=6)t1  " +
                        "left join (select sum(nvl(t1.nynse,0))sumNynse,substr(t3.zgkg_dm,2,6)qx from sw_dj_td t1  " +
                        "left join sw_dj_sy t2 on t1.sy_id=t2.sy_id " +
                        "left join sw_dj_jbb t3 on t3.jbb_id=t1.jbb_id " +
                        "where t2.syzt is null or t2.syzt='1' " +
                        "group by substr(t3.zgkg_dm,2,6))t2 on t1.dwdm=t2.qx)t1 " +
                        "left join  " +
                        "(select sum(nvl(t1.taxfinal,0))sumtaxfinal,substr(t2.zgkg_dm,2,6)dwdm " +
                        "from tb_lvy_levydata t1 " +
                        "join sw_dj_jbb t2 on t1.TaxRegCode=t2.nsrsbh " +
                        "where t1.TaxTypeCode='13' and to_char(t1.declaredate,'yyyy')= " +nf+
                        "group by substr(t2.zgkg_dm,2,6))t2 " +
                        "on t1.dwdm=t2.dwdm " ;

            } else if(Sylx.FCSY.toString().equals(sylx)){
                sql="select t1.dwdm,t1.dwmc,round(t1.sumNynse,2)sumNynse,round(nvl(t2.sumtaxfinal,0),2)sumtaxfinal,round((t1.sumnynse-nvl(t2.sumtaxfinal,0)),2)qjse from (select t1.dwdm,t1.dwmc,t2.sumNynse from (select t.dwdm,t.dwmc from s_dm_dwxx_cz t where length(t.dwdm)=6)t1  " +
                        "left join (select sum(nvl(t1.nynse,0))sumNynse,substr(t3.zgkg_dm,2,6)qx from sw_dj_fc t1  " +
                        "left join sw_dj_sy t2 on t1.sy_id=t2.sy_id " +
                        "left join sw_dj_jbb t3 on t3.jbb_id=t1.jbb_id " +
                        "where t2.syzt is null or t2.syzt='1' " +
                        "group by substr(t3.zgkg_dm,2,6))t2 on t1.dwdm=t2.qx)t1 " +
                        "left join  " +
                        "(select sum(nvl(t1.taxfinal,0))sumtaxfinal,substr(t2.zgkg_dm,2,6)dwdm " +
                        "from tb_lvy_levydata t1 " +
                        "join sw_dj_jbb t2 on t1.TaxRegCode=t2.nsrsbh " +
                        "where t1.TaxTypeCode='11' and to_char(t1.declaredate,'yyyy')= " +nf+
                        "group by substr(t2.zgkg_dm,2,6))t2 " +
                        "on t1.dwdm=t2.dwdm " ;
            }
        }else if(regionCode.length()==6){//县
            if(Sylx.TDSY.toString().equals(sylx)){
                sql="select round(t1.sumNynse,2)sumNynse,t1.dwmc,round(t2.taxfinal,2) taxfinal,round(t1.sumNynse-t2.taxfinal,2)qjse from (select sum(nvl(t1.nynse,0))sumNynse,t4.dwdm dwdm,t4.dwmc dwmc,t4.swdm swdm from sw_dj_td t1 " +
                        "left join sw_dj_sy t2 on t1.sy_id=t2.sy_id " +
                        "left join sw_dj_jbb t3 on t3.jbb_id=t1.jbb_id " +
                        "left join S_DM_SWDWXX t4 on t3.zgkg_dm=t4.swdm " +
                        "where t2.syzt is null or t2.syzt='1'  " +
                        "group by t4.dwdm,t4.dwmc,t4.swdm)t1 " +
                        "left join  " +
                        "(select sum(t1.taxfinal)taxfinal,t2.zgkg_mc,t2.zgkg_dm " +
                        "from tb_lvy_levydata t1 " +
                        "join sw_dj_jbb t2 on t1.TaxRegCode=t2.nsrsbh " +
                        "where t1.TaxTypeCode='13' and to_char(t1.declaredate,'yyyy')= " + nf+" "+
                        "group by  t2.zgkg_dm,t2.zgkg_mc)t2 " +
                        "on t1.swdm=t2.zgkg_dm ";

            } else if(Sylx.FCSY.toString().equals(sylx)){
                sql= "select round(t1.sumNynse,2)sumNynse,t1.dwmc,round(t2.taxfinal,2)taxfinal,round(t1.sumNynse-t2.taxfinal,2) from (select sum(nvl(t1.nynse,0))sumNynse,t4.dwdm dwdm,t4.dwmc dwmc,t4.swdm from sw_dj_fc t1 " +
                        "left join sw_dj_sy t2 on t1.sy_id=t2.sy_id " +
                        "left join sw_dj_jbb t3 on t3.jbb_id=t1.jbb_id " +
                        "left join S_DM_SWDWXX t4 on t3.zgkg_dm=t4.branchcode " +
                        "where t2.syzt is null or t2.syzt='1'  " +
                        "group by t4.dwdm,t4.dwmc,t4.swdm)t1 " +
                        "left join  " +
                        "(select sum(t1.taxfinal)taxfinal,t2.zgkg_mc,t2.zgkg_dm " +" "+
                        "from tb_lvy_levydata t1 " +
                        "join sw_dj_jbb t2 on t1.TaxRegCode=t2.nsrsbh " +
                        "where t1.TaxTypeCode='11' and to_char(t1.declaredate,'yyyy')= " +nf+
                        "group by  t2.zgkg_dm,t2.zgkg_mc)t2 " +
                        "on t1.swdm=t2.zgkg_dm " ;
            }
        }
        if(!dwdmStr.equals("'null'")){
            sql=sql+"where t1.dwdm in ("+dwdmStr+") ";
        }
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<Map<String,Object>> list = query.getResultList();
        return list;
    }




    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public Object getSyZdCount(String sylx,SwDjSyQuery swDjSyQuery) {
        String sql = "select count(*) from (";
        sql = sql + getSyhsSqlBySylx(sylx);
        sql = sql + addSyxxParameter(swDjSyQuery,sylx,true);

        if(StringUtils.isBlank(sylx) || Sylx.TDSY.toString().equals(sylx) || Sylx.FCSY.toString().equals(sylx)){
            sql = sql +" group by t3.djh";
        }else if(Sylx.GDZYS.toString().equals(sylx)){
            sql = sql +" group by t6.pc_id";
        }else if(Sylx.QS.toString().equals(sylx)){
            sql = sql +" group by t7.xm_id";
        }

        sql = sql+")";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        Object count = query.getSingleResult();
        return count;
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public Object getMjYdCount(String sylx,SwDjSyQuery swDjSyQuery,String ydzt) {
        String sql = "select count(*) from s_yd_mj where 1=1 ";
        sql = sql + addSyxxParameter(swDjSyQuery,sylx,true);

//        if(StringUtils.isBlank(sylx) || Sylx.TDSY.toString().equals(sylx) || Sylx.FCSY.toString().equals(sylx)){
//            sql = sql +" group by t3.djh";
//        }else if(Sylx.GDZYS.toString().equals(sylx)){
//            sql = sql +" group by t6.pc_id";
//        }else if(Sylx.QS.toString().equals(sylx)){
//            sql = sql +" group by t7.xm_id";
//        }
        if(("01").equals(ydzt)){
        sql =sql+" and zt = '01'";
        }
        if(("02".equals(ydzt))){
        sql =sql+" and zt = '02'";
        }
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        Object count = query.getSingleResult();
        return count;
    } 
    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public Object getSyhsCount(String sylx,SwDjSyQuery swDjSyQuery) {
        String sql =  getSyhsSqlBySylx(sylx);
        sql = sql + addSyxxParameter(swDjSyQuery,sylx,false);
        if(swDjSyQuery != null && (Sylx.TDSY.toString().equals(sylx) || StringUtils.isBlank(sylx))){
            if(swDjSyQuery.getIsMsTz() != null && true == swDjSyQuery.getIsMsTz()){
                sql = sql + "and t1.msmj is not null and t1.msmj > 0 ";
            }
        };

        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        Object count = query.getSingleResult();
        return count;
    }

    public String addSyxxParameter(SwDjSyQuery swDjSyQuery,String sylx,boolean isZds){
        String sql = "";
        if(StringUtils.isNotBlank(swDjSyQuery.getSgztDm())){
            sql = sql+" and t1.sgzt_dm = '"+swDjSyQuery.getSgztDm()+"' ";
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getDjh())){
            sql = sql+" and t3.djh like '%"+swDjSyQuery.getDjh()+"%' ";
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getGlbm())){
            sql = sql+" and t4.glbm like '%"+swDjSyQuery.getGlbm()+"%' ";
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getNsrsbh())){
            sql = sql+" and t4.nsrsbh like '%"+swDjSyQuery.getNsrsbh()+"%' ";
        }

        if(StringUtils.isNotBlank(swDjSyQuery.getDbh())){
            sql = sql+" and t2.dbh like '%"+swDjSyQuery.getDbh()+"%' ";
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getNsrmc())){
            sql = sql+" and t4.nsrmc like '%"+swDjSyQuery.getNsrmc()+"%' ";
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getTdzh())){
            sql = sql+" and t3.tdzh like '%"+swDjSyQuery.getTdzh()+"%' ";
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getQlrmc())){
            sql = sql+" and t3.qlrmc like '%"+swDjSyQuery.getQlrmc()+"%' ";
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getTdzl())){
            sql = sql+" and t1.tdzl like '%"+swDjSyQuery.getTdzl()+"%' ";
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getTdyt())){
            sql = sql+" and t3.tdyt ='"+swDjSyQuery.getTdyt()+"' ";
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getJf())){
            sql = sql+" and t3.djh like '"+swDjSyQuery.getJf()+"%' ";
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getJd())){
            sql = sql+" and t3.djh like '"+swDjSyQuery.getJd()+"%' ";
        }

        if(StringUtils.isNotBlank(swDjSyQuery.getQx())){
            if(isZds){
                sql = sql+" and t3.sgqdm like '"+swDjSyQuery.getQx()+"%' ";
            }else{
                sql = sql+" and (t3.sgqdm like '"+swDjSyQuery.getQx()+"%' or t7.xzqdm like '"+ swDjSyQuery.getQx() + "%') ";
            }

        }
        if(StringUtils.isNotBlank(swDjSyQuery.getSgyMc())){
            sql = sql+" and t4.sgyMc like '%"+swDjSyQuery.getSgyMc()+"%' ";
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getZgkgDm())){
            sql = sql+" and t4.zgkg_dm ='"+swDjSyQuery.getZgkgDm()+"' ";
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getZdsybz())){
            sql = sql+" and t1.zdsybz ='1' ";
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getZclxDm())){
            sql = sql+" and t4.zclx_dm='"+swDjSyQuery.getZclxDm()+"' ";
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getHyDm())){
            sql = sql + " and t4.hy_dm like '%"+swDjSyQuery.getHyDm()+"%' ";
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getHclx())){
            if("1".equals(swDjSyQuery.getHclx())){
                sql = sql + " and t3.djh is not null";
            }else if("2".equals(swDjSyQuery.getHclx())){
                sql = sql + " and t3.djh like '%999999%' ";
            }else if("3".equals(swDjSyQuery.getHclx())){
                sql = sql + " and t2.gd_id is not null ";
            }
        }
        if(sylx != null && Sylx.TDSY.toString().equals(sylx)){
            if(StringUtils.isNotBlank(swDjSyQuery.getTddj())){
                sql = sql + " and t1.tddj = '"+swDjSyQuery.getTddj()+"'";
            }

            if(StringUtils.isNotEmpty(swDjSyQuery.getIsGkq())){
                if("1".equals(swDjSyQuery.getIsGkq())){
                    sql = sql + " and t1.tddj IN (SELECT DM FROM S_ZD_TDJB WHERE MC LIKE '%工矿区%') ";
                }else  if("0".equals(swDjSyQuery.getIsGkq())){
                    sql = sql + " and (t1.tddj NOT IN (SELECT DM FROM S_ZD_TDJB WHERE MC LIKE '%工矿区%') OR t1.tddj IS NULL)";
                }
            }

            if(StringUtils.isNotEmpty(swDjSyQuery.getMinDwse())){
                sql = sql + " and t1.dwse >= " + swDjSyQuery.getMinDwse() + " ";
            }

            if(StringUtils.isNotEmpty(swDjSyQuery.getMaxDwse())){
                sql = sql + " and t1.dwse <= " + swDjSyQuery.getMaxDwse() + " ";
            }
        }else if(sylx != null && Sylx.FCSY.toString().equals(sylx)){
            if(StringUtils.isNotBlank(swDjSyQuery.getTddj())){
                sql = sql + " and t5.tddj = '"+swDjSyQuery.getTddj()+"'";
            }

            if(StringUtils.isNotEmpty(swDjSyQuery.getIsGkq())){
                if("1".equals(swDjSyQuery.getIsGkq())){
                    sql = sql + " and t5.tddj IN (SELECT DM FROM S_ZD_TDJB WHERE MC LIKE '%工矿区%') ";
                }else  if("0".equals(swDjSyQuery.getIsGkq())){
                    sql = sql + " and (t5.tddj NOT IN (SELECT DM FROM S_ZD_TDJB WHERE MC LIKE '%工矿区%') OR t1.tddj IS NULL)";
                }
            }

            if(StringUtils.isNotEmpty(swDjSyQuery.getMinDwse())){
                sql = sql + " and t5.dwse >= " + swDjSyQuery.getMinDwse() + " ";
            }

            if(StringUtils.isNotEmpty(swDjSyQuery.getMaxDwse())){
                sql = sql + " and t5.dwse <= " + swDjSyQuery.getMaxDwse() + " ";
            }
        }else if(sylx != null && Sylx.GDZYS.toString().equals(sylx)){
            if(StringUtils.isNotBlank(swDjSyQuery.getPcmc())){
                sql = sql +" and t6.pcmc like '%"+swDjSyQuery.getPcmc()+"%' ";
            }
            if(StringUtils.isNotBlank(swDjSyQuery.getPcXzqdm())){
                sql = sql +" and t6.xzqdm like '%"+swDjSyQuery.getPcXzqdm()+"%' ";
            }
        }else if(sylx != null && Sylx.QS.toString().equals(sylx)){
            if(StringUtils.isNotBlank(swDjSyQuery.getXmmc())){
                sql = sql +" and t7.xmmc like '%"+swDjSyQuery.getXmmc()+"%' ";
            }
            if(StringUtils.isNotBlank(swDjSyQuery.getXmTdyt())){
                sql = sql +" and t7.tdyt like '"+swDjSyQuery.getXmTdyt()+"' ";
            }
            if(StringUtils.isNotBlank(swDjSyQuery.getXmYddw())){
                sql = sql +" and t7.yddw like '%"+swDjSyQuery.getXmYddw()+"%' ";
            }
        }

        if(swDjSyQuery.getIsZdsy() !=null && swDjSyQuery.getIsZdsy() == true){
            sql = sql + " and t1.zdsybz='1' ";
        }

        return sql;
    }


    private String getSyhsSqlBySylx(String sylx){
        String sql = "";

        String regionCode = dwxxService.getUserRegionCode();
        String xzqdm = regionCode;
        if (xzqdm.length() > 6) {
            xzqdm = dwxxService.getUserRegionCode().substring(0, 6);
        }
        String swTable = "sw_dj_td";
        String userFilter = "";
        if(StringUtils.isBlank(sylx) || Sylx.TDSY.toString().equals(sylx)){
            swTable = "sw_dj_td";
            userFilter = "(t4.zgkg_dm like '2"+xzqdm+"%' ) ";
        }else if(Sylx.FCSY.toString().equals(sylx)){
            swTable = "sw_dj_fc";
            userFilter = "(t4.zgkg_dm like '2"+xzqdm+"%' )";
        }else if(Sylx.GDZYS.toString().equals(sylx)){
            swTable = "sw_dj_gdzys";
            userFilter = "t4.zgkg_dm like '2" + xzqdm + "%'";
        }else if(Sylx.QS.toString().equals(sylx)){
            swTable = "sw_dj_qs";
            userFilter = "t4.zgkg_dm like '2" + xzqdm + "%'";
        }

        sql = "select count(distinct t1.sy_id) from " + swTable + " t1 " +
                "left join sw_dj_sy t2 on t1.sy_id=t2.sy_id ";
        if(StringUtils.isBlank(sylx) || Sylx.TDSY.toString().equals(sylx)){
           sql = sql + "left join zd t3 on t3.djh=t2.djh ";
           sql = sql + "left join sw_dj_xmxx t7 on t7.xm_id=t2.gd_id ";
           sql = sql +" and t3.djh is not null and t3.djh not like '%999999%'";
        }else if(Sylx.FCSY.toString().equals(sylx)){
            sql = sql + "left join zd t3 on t3.djh=t2.djh ";
            sql = sql + "left join sw_dj_td t5 on t5.sy_id=t2.sy_id ";
            sql = sql + "left join sw_dj_xmxx t7 on t7.xm_id=t2.gd_id ";
            sql = sql +" and t3.djh is not null and t3.djh not like '%999999%'";
        }else if(Sylx.GDZYS.toString().equals(sylx)){
           sql = sql +  "left join sw_dj_pcxx t6 on t6.pc_id=t2.bp_id ";
           //sql = sql +" and t3.djh is not null and t3.djh not like '%999999%'";
        }else if(Sylx.QS.toString().equals(sylx)){
           sql = sql + "left join sw_dj_xmxx t7 on t7.xm_id=t2.gd_id ";
        }

        sql = sql +"　left join sw_dj_jbb t4 on t4.jbb_id=t1.jbb_id "+
                    "where (t2.syzt='1' or t2.syzt is null)  and " + userFilter;

        return sql;
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public Object getKghCount(String sylx, SwDjSyQuery swDjSyQuery) {
        String sql = getSyhsSqlBySylx(sylx);
        sql = sql + " and t1.sgzt_dm='01' ";
        sql = sql + addSyxxParameter(swDjSyQuery,sylx,false);
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        Object count = query.getSingleResult();
        return count;
    }
    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public Object getLzlghCount(String sylx, SwDjSyQuery swDjSyQuery) {
        String sql = getSyhsSqlBySylx(sylx);
        sql = sql + " and t1.sgzt_dm='02' ";
        sql = sql + addSyxxParameter(swDjSyQuery,sylx,false);
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        Object count = query.getSingleResult();
        return count;
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public Object getKzhsyCount(String sylx, SwDjSyQuery swDjSyQuery) {
        String sql = getSyhsSqlBySylx(sylx);
        sql = sql + " and t1.sgzt_dm='03' ";
        sql = sql + addSyxxParameter(swDjSyQuery,sylx,false);
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        Object count = query.getSingleResult();
        return count;
    }

    @Override
    public List getHistoryByTd_Id(String TD_ID) {
        String sql = "select * from s_yd_mj_his where TD_ID = '"+TD_ID+"' order by bgsj  ";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List list = query.getResultList();
        return list;
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public Object getJgdwCount(String sylx, SwDjSyQuery swDjSyQuery) {
        String sql = getSyhsSqlBySylx(sylx);
        sql = sql + " and t1.sgzt_dm='05' ";
        sql = sql + addSyxxParameter(swDjSyQuery,sylx,false);
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        Object count = query.getSingleResult();
        return count;
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public Object getGrCount(String sylx, SwDjSyQuery swDjSyQuery) {
        String sql = getSyhsSqlBySylx(sylx);
        sql = sql + " and t1.sgzt_dm='04' ";
        sql = sql + addSyxxParameter(swDjSyQuery,sylx,false);
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        Object count = query.getSingleResult();
        return count;
    }



    /**
     * 标记重点税源
     * 1：是重点税源
     * @param tdId
     * @param fcId
     */
    @Override
    @Transactional(value="oracle_common")
    public void setZdsy(String sylx,String tdId, String fcId,String gdzysId,String qsId,SwDjSyQuery swDjSyQuery,String beginPm,String endPm) {
        if(Sylx.TDSY.toString().equals(sylx)){
            if(StringUtils.isNotBlank(tdId)){
                String[] tdIds = tdId.split(",");
                for(String tmpTdId:tdIds){
                    SwDjTd swDjTd = baseRepository.get(SwDjTd.class,tmpTdId);
                    if(swDjTd!=null){
                        swDjTd.setZdsybz(swDjSyQuery.getZdsybz());
                        baseRepository.update(swDjTd);
                    }
                }
            }else{//说明是条件认定重点税源
                String zdsybz = swDjSyQuery.getZdsybz();
                //移除查询条件中的zdsybz
                swDjSyQuery.setZdsybz(null);

                String sql ="select t.*,rownum as pm from( " +
                        "select t2.djh,t2.dbh,t3.nsrsbh,t3.nsrmc,t3.zgkg_mc,t3.zgkg_dm,t3.sgy_mc, to_char(t4.tdzl)tdzl,t1.scmj, t1.ynmj,t1.msmj,t1.nynse, t1.td_id,t1.zdsybz ,t3.hy_dm,t3.zclx_dm,rank() over(order by nvl(t1.nynse, 0) desc) as spm " +
                        "from sw_dj_td t1 join sw_dj_sy t2 on t1.sy_id=t2.sy_id  " +
                        "left join sw_dj_jbb t3 on t1.jbb_id=t3.jbb_id   " +
                        "left join zd t4 on t4.djh=t2.djh "+
                        "where ( t4.sgqdm like '"+SessionUtil.getCurrentUser().getRegionCode()+"%' and "+"t2.syzt is null or t2.syzt='1' ))t where  1=1 ";
                sql = addParameter(swDjSyQuery,sql,beginPm,endPm,sylx);
                Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
                query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
                List<HashMap<String,Object>> list = query.getResultList();
                if(CollectionUtils.isNotEmpty(list)){
                    for(HashMap<String,Object> tempTdId : list){
                        SwDjTd swDjTd = baseRepository.get(SwDjTd.class,String.valueOf(tempTdId.get("TD_ID")));
                        swDjTd.setZdsybz(zdsybz);
                        baseRepository.update(swDjTd);
                    }

                }
            }
        }else if(Sylx.FCSY.toString().equals(sylx)){
            if(StringUtils.isNotBlank(fcId)){
                String[] fcIds = fcId.split(",");
                for(String tmpFcId:fcIds){
                    SwDjFc swDjFc = baseRepository.get(SwDjFc.class,tmpFcId);
                    if(swDjFc!=null){
                        swDjFc.setZdsybz(swDjSyQuery.getZdsybz());
                        baseRepository.update(swDjFc);
                    }
                }

            }else{
                String zdsybz = swDjSyQuery.getZdsybz();
                //移除查询条件中的zdsybz
                swDjSyQuery.setZdsybz(null);

                String sql ="select t.*,t2.spm,rownum as pm from ("+
                        "select t2.djh,t2.dbh,t3.nsrsbh,t3.nsrmc,t3.zgkg_mc,t3.zgkg_dm,t3.sgy_mc,t1.fczl,t1.fcmj,t1.fcyz_ys,t1.fcyz_ms,t1.nzj,t1.nynse,t1.fc_id,t1.zdsybz,t3.zclx_dm" +
                        " from sw_dj_fc t1" +
                        " left join sw_dj_sy t2" +
                        " on t1.sy_id=t2.sy_id" +
                        " left join  sw_dj_jbb t3" +
                        " on t1.jbb_id=t3.jbb_id "+
                        " where (t2.syzt is null or t2.syzt='1'))t "+
                        " LEFT join(select  fc_id,rank() over(order by nvl(nynse,0) desc) as spm from sw_dj_fc)t2 on t.fc_id =t2.fc_id where 1=1 ";
                sql = addParameter(swDjSyQuery,sql,beginPm,endPm,sylx);
                Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
                query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
                List<HashMap<String,Object>> list = query.getResultList();
                if(CollectionUtils.isNotEmpty(list)){
                    for(HashMap<String,Object> tempFcId :list){
                        SwDjFc swDjFc = baseRepository.get(SwDjFc.class,String.valueOf(tempFcId.get("FC_ID")));
                        swDjFc.setZdsybz(zdsybz);
                        baseRepository.update(swDjFc);
                    }

                }
            }
        }else if(Sylx.GDZYS.toString().equals(sylx)){
            if(StringUtils.isNotBlank(gdzysId)){
                String[] gdzysIds = gdzysId.split(",");
                for(String tmpGdzysId:gdzysIds){
                    SwDjGdzys swDjGdzys = baseRepository.get(SwDjGdzys.class,tmpGdzysId);
                    if(swDjGdzys!=null){
                        swDjGdzys.setZdsybz(swDjSyQuery.getZdsybz());
                        baseRepository.update(swDjGdzys);
                    }
                }

            }else{
                String zdsybz = swDjSyQuery.getZdsybz();
                //移除查询条件中的zdsybz
                swDjSyQuery.setZdsybz(null);

                String sql ="select t.*,rownum as pm from( " +
                        "select t3.nsrsbh,t3.nsrmc,t3.zgkg_mc,t3.zgkg_dm,t3.sgy_mc,t3.hy_dm,t3.zclx_dm," +
                        "t1.zdsybz ,rank() over(order by nvl(t1.ynse, 0) desc) as spm, " +
                        "t1.gdzys_id,t1.ynse,t1.dwse,t1.jmse," +
                        "t4.pcmc " +
                        "from sw_dj_gdzys t1 join sw_dj_sy t2 on t1.sy_id=t2.sy_id  " +
                        "left join sw_dj_jbb t3 on t1.jbb_id=t3.jbb_id   " +
                        "left join sw_dj_pcxx t4 on t4.pc_id=t2.bp_id "+
                        "where ( t4.pc_id is not null and "+"t2.syzt is null or t2.syzt='1' ))t where  1=1 ";
                sql = addParameter(swDjSyQuery,sql,beginPm,endPm,sylx);
                Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
                query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
                List<HashMap<String,Object>> list = query.getResultList();
                if(CollectionUtils.isNotEmpty(list)){
                    for(HashMap<String,Object> tempGdzys :list){
                        SwDjGdzys swDjGdzys = baseRepository.get(SwDjGdzys.class,String.valueOf(tempGdzys.get("GDZYS_ID")));
                        swDjGdzys.setZdsybz(zdsybz);
                        baseRepository.update(swDjGdzys);
                    }

                }
            }
        }else if(Sylx.QS.toString().equals(sylx)){
            if(StringUtils.isNotBlank(qsId)){
                String[] qsIds = qsId.split(",");
                for(String tmpQsId:qsIds){
                    SwDjQs swDjQs = baseRepository.get(SwDjQs.class,tmpQsId);
                    if(swDjQs!=null){
                        swDjQs.setZdsybz(swDjSyQuery.getZdsybz());
                        baseRepository.update(swDjQs);
                    }
                }

            }else{
                String zdsybz = swDjSyQuery.getZdsybz();
                //移除查询条件中的zdsybz
                swDjSyQuery.setZdsybz(null);

                String sql ="select t.*,rownum as pm from( " +
                        "select t3.nsrsbh,t3.nsrmc,t3.zgkg_mc,t3.zgkg_dm,t3.sgy_mc,t3.hy_dm,t3.zclx_dm," +
                        "t1.zdsybz ,rank() over(order by nvl(t1.ynse, 0) desc) as spm, " +
                        "t1.qs_id,t1.ynse,t1.yjne,t1.xbjse," +
                        "t4.xmmc,t4.tdzl,t4.gdmj,t4.qdjg " +
                        "from sw_dj_qs t1 join sw_dj_sy t2 on t1.sy_id=t2.sy_id  " +
                        "left join sw_dj_jbb t3 on t1.jbb_id=t3.jbb_id   " +
                        "left join sw_dj_xmxx t4 on t4.xm_id=t2.gd_id "+
                        "where ( t4.xm_id is not null and "+"t2.syzt is null or t2.syzt='1' ))t where  1=1 ";
                sql = addParameter(swDjSyQuery,sql,beginPm,endPm,sylx);
                Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
                query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
                List<HashMap<String,Object>> list = query.getResultList();
                if(CollectionUtils.isNotEmpty(list)){
                    for(HashMap<String,Object> tempQsId :list){
                        SwDjQs swDjQs = baseRepository.get(SwDjQs.class,String.valueOf(tempQsId.get("QS_ID")));
                        swDjQs.setZdsybz(zdsybz);
                        baseRepository.update(swDjQs);
                    }

                }
            }
        }
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public Object tjNynseByHylx(String[] queryHydm, String sylx,String nf) {
        String hydmStr = "";
        String sql = "";
        for(int i=0;i<queryHydm.length;i++){
            if(StringUtils.isNotBlank(queryHydm[i])){
                if(i==queryHydm.length-1){
                    hydmStr+="'"+queryHydm[i]+"'";
                }else{
                    hydmStr+="'"+queryHydm[i]+"',";
                }

            }
        }
        if(Sylx.TDSY.toString().equals(sylx)){
            sql = "select round(t1.sumNynse,2)sumNynse,t1.hy_dm,round(nvl(t2.sumtaxfinal,0),2)sumtaxfinal,round((t1.sumNynse-nvl(t2.sumtaxfinal,0)),2)as qjse from  " +
                    "(select sum(nvl(t1.nynse,0))sumNynse,substr(t3.hy_dm,0,1) hy_dm from sw_dj_td t1 " +
                    "join sw_dj_sy t2 on t1.sy_id=t2.sy_id " +
                    "join sw_dj_jbb t3 on t1.jbb_id=t3.jbb_id " +
                    "where t2.syzt is null or t2.syzt='1' " +
                    "group by  substr(t3.hy_dm,0,1))t1 " +
                    "left join " +
                    "(select sum(nvl(t1.nse,0))sumtaxfinal,substr(t2.hy_dm,0,1) hy_dm from LOCAL_SB_RKSS t1 " +
                    "join sw_dj_jbb t2 on t1.nsrsbh=t2.nsrsbh " +
                    "where t1.szdm ='13' "+
                    "and to_char(t1.fsrq,'yyyy')= " + nf +
                    "group by  substr(t2.hy_dm,0,1))t2 " +
                    "on t1.hy_dm=t2.hy_dm " ;



        } else if(Sylx.FCSY.toString().equals(sylx)){
            sql = "select round(t1.sumNynse,2)sumNynse,t1.hy_dm,round(nvl(t2.sumtaxfinal,0),2)sumtaxfinal,round((t1.sumNynse-nvl(t2.sumtaxfinal,0)),2)as qjse from  " +
                    "(select sum(nvl(t1.nynse,0))sumNynse,t3.hy_dm from sw_dj_fc t1 " +
                    "join sw_dj_sy t2 on t1.sy_id=t2.sy_id " +
                    "join sw_dj_jbb t3 on t1.jbb_id=t3.jbb_id " +
                    "where t2.syzt is null or t2.syzt='1' " +
                    "group by t3.hy_dm)t1 " +
                    "left join " +
                    "(select sum(nvl(t1.nse,0))sumtaxfinal,t2.hy_dm from LOCAL_SB_RKSS t1 " +
                    "join sw_dj_jbb t2 on t1.nsrsbh=t2.nsrsbh " +
                    "where t1.szdm ='11' "+
                    "and to_char(t1.FSRQ,'yyyy')= " + nf +
                    "group by t2.hy_dm)t2 " +
                    "on t1.hy_dm=t2.hy_dm ";
        }
        if(!hydmStr.equals("'null'")){
            sql=sql+"where t1.hy_dm in("+hydmStr+")";

        }
        sql = "select t1.*, t2.mc as hy_mc from (" + sql + ") t1 left join dm_hydm t2 on t1.hy_dm=t2.dm";

        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        return list;
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public List<Map<String, Object>> tjSybhfx(String sylx, String nf) {
        String sql = "";
        if(Sylx.TDSY.toString().equals(sylx)){
            sql = "select t1.yf ,round(t1.sumtaxfinal,2)sumtaxfinal,round(t2.sumynse,2)sumynse,round((t2.sumynse-t1.sumtaxfinal),2)qjse from  " +
                    "(select to_char(t1.fsrq,'mm')yf,sum(t1.nse) sumtaxfinal " +
                    "from (select t.fsrq,t.nse  from LOCAL_SB_RKSS t where to_char(t.fsrq,'yyyy')="+nf+" and t.szdm='13')t1 group by to_char(t1.fsrq,'mm') order by to_char(t1.fsrq,'mm') " +
                    ")t1, " +
                    "(select (sum(t1.nynse)/12)sumynse " +
                    "from sw_dj_td t1 " +
                    "left join sw_dj_sy t2 on t1.sy_id=t2.sy_id  " +
                    "where t2.syzt is null or t2.syzt='1')t2 ";
        }else if (Sylx.FCSY.toString().equals(sylx)){
            sql = "select t1.yf ,round(t1.sumtaxfinal,2)sumtaxfinal,round(t2.sumynse,2)sumynse,round((t2.sumynse-t1.sumtaxfinal),2)qjse from  " +
                    "(select to_char(t1.FSRQ,'mm')yf,sum(t1.nse) sumtaxfinal " +
                    "from (select t.FSRQ,t.nse  from LOCAL_SB_RKSS t where to_char(t.FSRQ,'yyyy')="+nf+" and t.szdm='11')t1 group by to_char(t1.FSRQ,'mm') order by to_char(t1.FSRQ,'mm') " +
                    ")t1, " +
                    "(select (sum(t1.nynse)/12)sumynse " +
                    "from sw_dj_fc t1 " +
                    "left join sw_dj_sy t2 on t1.sy_id=t2.sy_id  " +
                    "where t2.syzt is null or t2.syzt='1' or t2.syzt='' )t2 ";
        }
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<Map<String,Object>> list = query.getResultList();
        return list;
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public Object findSwDjGdzysMap(SwDjSyQuery swDjSyQuery, Pageable pageable) {
        QSwDjGdzys qSwDjGdzys = QSwDjGdzys.swDjGdzys;
        QSwDjQs qSwDjQs = QSwDjQs.swDjQs;
        QSwDjSy qSwDjSy = QSwDjSy.swDjSy;
        QSwDjTd qSwDjTd = QSwDjTd.swDjTd;
        QSwDjFc qSwDjFc = QSwDjFc.swDjFc;
        QSwDjJbb qSwDjJbb = QSwDjJbb.swDjJbb;
        QSwDjXmxx qSwDjXmxx = QSwDjXmxx.swDjXmxx;
        QZd qZd = QZd.zd;
        String regionCode = "";
        try{
            regionCode = SessionUtil.getCurrentUser().getRegionCode();
        }catch (Exception e){}

        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        QBean qBean = Projections.bean(SwDjSyQuery.class,qSwDjSy.syId,qSwDjSy.dbh,qSwDjTd.tdId,qSwDjSy.zd.djh,qSwDjJbb.nsrmc,
                qSwDjFc.fczl,qSwDjTd.tddj,qSwDjTd.tdzl,qSwDjTd.scmj,qSwDjTd.msmj,qSwDjTd.ynmj,qSwDjTd.dwse,qSwDjTd.sgztDm,qSwDjTd.sgztMc,qSwDjTd.sjly,qSwDjTd.nynseTd,qSwDjTd.msse,qSwDjJbb.glbm,qSwDjJbb.nsrsbh,qSwDjJbb.zgkgMc,qSwDjJbb.sgyMc,qSwDjFc.fcId,qSwDjTd.zdsybz,qZd.qlrmc,qZd.tdyt,qZd.scmjZd,
                qSwDjGdzys.gdzysId,qSwDjGdzys.gdzysYnse,qSwDjGdzys.gdzysDwse,qSwDjGdzys.gdzysJmxz,qSwDjGdzys.gdzysJmse,qSwDjGdzys.gdzysJspz,qSwDjGdzys.gdzysYjne,qSwDjGdzys.gdzysXbjse,qSwDjGdzys.gdzysBz,qSwDjGdzys.gdzysLrrq,qSwDjGdzys.gdzysHclx,
                qSwDjQs.qsId,qSwDjQs.qsSzly,qSwDjQs.qsYnse,qSwDjQs.qsYjne,qSwDjQs.qsJmxz,qSwDjQs.qsJmse,qSwDjQs.qsJspz,qSwDjQs.qsXbjse,qSwDjQs.qsBz,qSwDjQs.qsLrrq,qSwDjQs.qsHclx);
        jpaQuery.from(qSwDjGdzys).leftJoin(qSwDjGdzys.swDjSy,qSwDjSy).leftJoin(qSwDjSy.swDjTd,qSwDjTd).leftJoin(qSwDjTd.swDjJbb,qSwDjJbb).leftJoin(qSwDjSy.swDjFc, qSwDjFc).leftJoin(qSwDjSy.zd, qZd).leftJoin(qSwDjSy.swDjQs,qSwDjQs).leftJoin(qSwDjSy.swDjXmxx,qSwDjXmxx);
        if(StringUtils.isNotBlank(swDjSyQuery.getDjh()))
            jpaQuery.where(qSwDjSy.zd.djh.like(QueryCondition.WILDCARDS + swDjSyQuery.getDjh() + QueryCondition.WILDCARDS));
        //if(StringUtils.isNotBlank(swDjSyQuery.getXzqdm()))
        //    jpaQuery.where(qSwDjSy.zd.djh.like(swDjSyQuery.getXzqdm() + QueryCondition.WILDCARDS));
        if(StringUtils.isBlank(swDjSyQuery.getSyzt())){
            jpaQuery.where(qSwDjSy.syzt.eq(Syzt.ZC.toString()).or(qSwDjSy.syzt.isNull()).or(qSwDjSy.syzt.eq("")));
        }else{
            jpaQuery.where(qSwDjSy.syzt.eq(swDjSyQuery.getSyzt()).or(qSwDjSy.syzt.eq("")).or(qSwDjSy.syzt.isNull()));
        }
        jpaQuery.where(qSwDjTd.tdId.isNotNull());
        if(swDjSyQuery.getIsMsTz()!=null && swDjSyQuery.getIsMsTz()){
            jpaQuery.where(qSwDjTd.msmj.isNotNull().and(qSwDjTd.msmj.gt(new BigDecimal(0))));
            jpaQuery.orderBy(qSwDjTd.msmj.desc().nullsLast());
        }else{
            jpaQuery.orderBy(qSwDjTd.nynseTd.desc().nullsLast());
        }
        if("1".equals(swDjSyQuery.getMsbz())){
            jpaQuery.where(qSwDjTd.msbz.eq("1"));
        }else if("2".equals(swDjSyQuery.getMsbz())){
            jpaQuery.where(qSwDjTd.msbz.isNull().or(qSwDjTd.msbz.eq("")));
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getTddj())){
            String tddj = CommonUtil.reSetTddj(swDjSyQuery.getTddj());
            jpaQuery.where(qSwDjTd.tddj.eq(tddj));
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getSgztDm())){
            jpaQuery.where(qSwDjTd.sgztDm.eq(swDjSyQuery.getSgztDm()));
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getSjly())){
            jpaQuery.where(qSwDjTd.sjly.eq(swDjSyQuery.getSjly()));
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getZdsybz())){
            jpaQuery.where(Expressions.stringPath(qSwDjTd,"zdsybz").eq(swDjSyQuery.getZdsybz()));
        }

        if(StringUtils.isNotBlank(regionCode)){
            jpaQuery.where(qSwDjJbb.zgkgDm.like("2" + regionCode + QueryCondition.WILDCARDS));
        }
        applySwDjSyQueryPredicates(swDjSyQuery,qSwDjSy,qSwDjJbb, qSwDjTd,qSwDjFc,qZd,qSwDjXmxx,jpaQuery);

        return baseRepository.find(jpaQuery,qBean,pageable);
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public Object findSwDjQsMap(SwDjSyQuery swDjSyQuery, Pageable pageable) {
        QSwDjGdzys qSwDjGdzys = QSwDjGdzys.swDjGdzys;
        QSwDjQs qSwDjQs = QSwDjQs.swDjQs;
        QSwDjSy qSwDjSy = QSwDjSy.swDjSy;
        QSwDjTd qSwDjTd = QSwDjTd.swDjTd;
        QSwDjFc qSwDjFc = QSwDjFc.swDjFc;
        QSwDjJbb qSwDjJbb = QSwDjJbb.swDjJbb;
        QSwDjXmxx qSwDjXmxx = QSwDjXmxx.swDjXmxx;
        QZd qZd = QZd.zd;

        String regionCode = "";
        try{
            regionCode = SessionUtil.getCurrentUser().getRegionCode();
        }catch (Exception e){}

        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        QBean qBean = Projections.bean(SwDjSyQuery.class,qSwDjSy.syId,qSwDjSy.dbh,qSwDjTd.tdId,qSwDjSy.zd.djh,qSwDjJbb.nsrmc,
                qSwDjFc.fczl,qSwDjTd.tddj,qSwDjTd.tdzl,qSwDjTd.scmj,qSwDjTd.msmj,qSwDjTd.ynmj,qSwDjTd.dwse,qSwDjTd.sgztDm,qSwDjTd.sgztMc,qSwDjTd.sjly,qSwDjTd.nynseTd,qSwDjTd.msse,qSwDjJbb.glbm,qSwDjJbb.nsrsbh,qSwDjJbb.zgkgMc,qSwDjJbb.sgyMc,qSwDjFc.fcId,qSwDjTd.zdsybz,qZd.qlrmc,qZd.tdyt,qZd.scmjZd,
                qSwDjGdzys.gdzysId,qSwDjGdzys.gdzysYnse,qSwDjGdzys.gdzysDwse,qSwDjGdzys.gdzysJmxz,qSwDjGdzys.gdzysJmse,qSwDjGdzys.gdzysJspz,qSwDjGdzys.gdzysYjne,qSwDjGdzys.gdzysXbjse,qSwDjGdzys.gdzysBz,qSwDjGdzys.gdzysLrrq,qSwDjGdzys.gdzysHclx,
                qSwDjQs.qsId,qSwDjQs.qsSzly,qSwDjQs.qsYnse,qSwDjQs.qsYjne,qSwDjQs.qsJmxz,qSwDjQs.qsJmse,qSwDjQs.qsJspz,qSwDjQs.qsXbjse,qSwDjQs.qsBz,qSwDjQs.qsLrrq,qSwDjQs.qsHclx);
        jpaQuery.from(qSwDjQs).leftJoin(qSwDjQs.swDjSy,qSwDjSy).leftJoin(qSwDjSy.swDjTd,qSwDjTd).leftJoin(qSwDjTd.swDjJbb,qSwDjJbb).leftJoin(qSwDjSy.swDjFc, qSwDjFc).leftJoin(qSwDjSy.zd, qZd).leftJoin(qSwDjSy.swDjGdzys,qSwDjGdzys).leftJoin(qSwDjSy.swDjXmxx,qSwDjXmxx);
        if(StringUtils.isNotBlank(swDjSyQuery.getDjh()))
            jpaQuery.where(qSwDjSy.zd.djh.like(QueryCondition.WILDCARDS + swDjSyQuery.getDjh() + QueryCondition.WILDCARDS));
        //if(StringUtils.isNotBlank(swDjSyQuery.getXzqdm()))
        //    jpaQuery.where(qSwDjSy.zd.djh.like(swDjSyQuery.getXzqdm() + QueryCondition.WILDCARDS));
        if(StringUtils.isBlank(swDjSyQuery.getSyzt())){
            jpaQuery.where(qSwDjSy.syzt.eq(Syzt.ZC.toString()).or(qSwDjSy.syzt.isNull()).or(qSwDjSy.syzt.eq("")));
        }else{
            jpaQuery.where(qSwDjSy.syzt.eq(swDjSyQuery.getSyzt()).or(qSwDjSy.syzt.eq("")).or(qSwDjSy.syzt.isNull()));
        }
        jpaQuery.where(qSwDjTd.tdId.isNotNull());
        if(swDjSyQuery.getIsMsTz()!=null && swDjSyQuery.getIsMsTz()){
            jpaQuery.where(qSwDjTd.msmj.isNotNull().and(qSwDjTd.msmj.gt(new BigDecimal(0))));
            jpaQuery.orderBy(qSwDjTd.msmj.desc().nullsLast());
        }else{
            jpaQuery.orderBy(qSwDjTd.nynseTd.desc().nullsLast());
        }
        if("1".equals(swDjSyQuery.getMsbz())){
            jpaQuery.where(qSwDjTd.msbz.eq("1"));
        }else if("2".equals(swDjSyQuery.getMsbz())){
            jpaQuery.where(qSwDjTd.msbz.isNull().or(qSwDjTd.msbz.eq("")));
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getTddj())){
            String tddj = CommonUtil.reSetTddj(swDjSyQuery.getTddj());
            jpaQuery.where(qSwDjTd.tddj.eq(tddj));
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getSgztDm())){
            jpaQuery.where(qSwDjTd.sgztDm.eq(swDjSyQuery.getSgztDm()));
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getSjly())){
            jpaQuery.where(qSwDjTd.sjly.eq(swDjSyQuery.getSjly()));
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getZdsybz())){
            jpaQuery.where(Expressions.stringPath(qSwDjTd,"zdsybz").eq(swDjSyQuery.getZdsybz()));
        }

        if(StringUtils.isNotBlank(regionCode)){
            jpaQuery.where(qSwDjJbb.zgkgDm.like("2" + regionCode + QueryCondition.WILDCARDS));
        }
        applySwDjSyQueryPredicates(swDjSyQuery,qSwDjSy,qSwDjJbb, qSwDjTd,qSwDjFc,qZd,qSwDjXmxx,jpaQuery);


        return baseRepository.find(jpaQuery,qBean,pageable);
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public String findZgkgDmByRegionCode(String regionCode) {
        String whereClause = " where swbmbm = '2"+regionCode+"00'";
        String sql = "select swbmbm,mc from dm_swbm " + whereClause;
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        if(CollectionUtils.isNotEmpty(list)){
            Object obj = list.get(0);
            HashMap map = (HashMap)obj;
            String value = String.valueOf(map.get("SWBMBM"));
            return value;
        }
        return null;

    }

    @Override
    @Transactional(value="oracle_common",readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public List getTddjByDjhLike(String djh) {
        Zd zd = zdService.findZdByDjh(djh);
        String sgqdm = zd.getSgqdm();
        int tddj_level =Integer.parseInt(AppConfig.getProperty("TDDJ_LEVEL"));
        if(StringUtils.isBlank(sgqdm)){
            sgqdm = djh.substring(0,tddj_level);//+djh.substring(djh.length()-4,djh.length())
        }
        if(sgqdm.length()>=tddj_level){
            sgqdm = sgqdm.substring(0,tddj_level);
        }
        if (sgqdm.equals("610790")) {
            sgqdm = "610702";
        }
        String sql = "select t.* from S_ZD_TDJB t ";
        if(StringUtils.isNotBlank(djh)){
            sql = sql + "where t.dm like '"+ sgqdm +"%' ";
        }
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        return list;
    }
    @Override
    @Transactional(value="oracle_common",readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public List getTddjByQx(String qx) {

        String sql = "select t.* from S_ZD_TDJB t ";
        if(StringUtils.isNotBlank(qx)){
            sql = sql + "where t.dm like '"+ qx +"%' ";
        }
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        return list;
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public List getTdytByQx(String qx) {

        String sql = "select t.* from S_ZD_DLDM t ";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        return list;
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public Object getTddjByDm(String dm) {
        String sql = "select t.* from S_ZD_TDJB t ";
        if(StringUtils.isNotBlank(dm)){
            sql = sql + "where t.dm ='"+dm+"'";
        }
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        try {
            return query.getSingleResult();
        } catch (Exception e) {
            return null;
        }
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public Zd getTddjByDjh(String djh) {
        Zd zd = zdService.findZdByDjh(djh);
        return zd;
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public List getTddjByXzqdm(String xmXzqdm) {
        String sql = "select t.* from S_ZD_TDJB t ";
        int tddj_level =Integer.parseInt( AppConfig.getProperty("TDDJ_LEVEL"));
        if(xmXzqdm.length()>=tddj_level){
            xmXzqdm = xmXzqdm.substring(0,tddj_level);
        }
        if(StringUtils.isNotBlank(xmXzqdm)){
            sql = sql + "where t.dm like '"+xmXzqdm+"%' ";
        }
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        return list;
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public List<SwDjSyQuery> getSwDjSyByXmId(String xmId) {
        QSwDjSy qSwDjSy = QSwDjSy.swDjSy;
        QSwDjTd qSwDjTd = QSwDjTd.swDjTd;
        QSwDjFc qSwDjFc = QSwDjFc.swDjFc;

        QSwDjXmxx qSwDjXmxx = QSwDjXmxx.swDjXmxx;
        QSwDjJbb qSwDjJbb = QSwDjJbb.swDjJbb;
        JPQLQuery query = new JPAQuery(baseRepository.getEntityManager());

        QBean qBean = Projections.bean(SwDjSyQuery.class,qSwDjSy.zd.djh,qSwDjSy.dbh,qSwDjJbb.glbm,qSwDjJbb.nsrsbh,qSwDjJbb.nsrmc,qSwDjTd.czrmc,qSwDjTd.czrzjhm,qSwDjTd.tdzl,
                qSwDjXmxx.xmId,qSwDjXmxx.xmmc,qSwDjXmxx.gdmj,qSwDjXmxx.qdfs,qSwDjXmxx.xmTdyt,qSwDjXmxx.xmYddw,qSwDjXmxx.xmXzqdm,qSwDjXmxx.qdjg,qSwDjXmxx.gdsj,qSwDjJbb.zgkgDm,qSwDjJbb.sgyMc,qSwDjJbb.fddbr,qSwDjJbb.lxdh,qSwDjJbb.zclxDm,qSwDjJbb.hyDm,qSwDjJbb.zcdz,
                qSwDjTd.tdsyztDm,qSwDjTd.fzmj,qSwDjTd.scmj,qSwDjTd.tddj,qSwDjTd.msmj,qSwDjTd.ynmj,qSwDjTd.dwse,qSwDjTd.nynseTd,
                qSwDjFc.fczh,qSwDjFc.fcmj,qSwDjFc.fwxzDm,qSwDjFc.zyhczDm,qSwDjFc.fwjz,qSwDjFc.tdjz,qSwDjFc.fssbjz,qSwDjFc.fcyz,
                qSwDjFc.fcyzYs,qSwDjFc.fcyzMs,qSwDjFc.ynseZy,qSwDjFc.ynseCz,qSwDjFc.nzj,qSwDjFc.nynseFc,qSwDjFc.fcId,qSwDjTd.tdId,qSwDjSy.syId);
        query.from(qSwDjSy).leftJoin(qSwDjSy.swDjTd, qSwDjTd).leftJoin(qSwDjSy.swDjFc,qSwDjFc).leftJoin(qSwDjTd.swDjJbb,qSwDjJbb).leftJoin(qSwDjSy.swDjXmxx, qSwDjXmxx).where(qSwDjXmxx.xmId.eq(xmId));
        query.where(qSwDjSy.syzt.eq(Syzt.ZC.toString()).or(qSwDjSy.syzt.isNull()));
        query.orderBy(new OrderSpecifier(Order.ASC, Expressions.stringPath(qSwDjSy,"dbh")));
        return (List)baseRepository.dslList(query,qBean);
    }

    @Override
    public List<SwDjSyQuery> getSwDjSyByPcId(String pcId) {
        QSwDjSy qSwDjSy = QSwDjSy.swDjSy;
        QSwDjTd qSwDjTd = QSwDjTd.swDjTd;
        QSwDjFc qSwDjFc = QSwDjFc.swDjFc;

        QSwDjPcxx qSwDjPcxx = QSwDjPcxx.swDjPcxx;
        QSwDjJbb qSwDjJbb = QSwDjJbb.swDjJbb;
        JPQLQuery query = new JPAQuery(baseRepository.getEntityManager());

        QBean qBean = Projections.bean(SwDjSyQuery.class,qSwDjSy.zd.djh,qSwDjSy.dbh,qSwDjJbb.glbm,qSwDjJbb.nsrsbh,qSwDjJbb.nsrmc,qSwDjTd.czrmc,qSwDjTd.czrzjhm,qSwDjTd.tdzl,
                qSwDjPcxx.pcId,qSwDjPcxx.pcmc,qSwDjPcxx.fgdnydmj,qSwDjPcxx.gdmj,qSwDjPcxx.jbntmj,qSwDjPcxx.nydmj,qSwDjPcxx.pcXzqdm,qSwDjPcxx.pcYddw,qSwDjPcxx.pwh,qSwDjPcxx.pzmj,qSwDjPcxx.pzsj,
                qSwDjJbb.zgkgDm,qSwDjJbb.sgyMc,qSwDjJbb.fddbr,qSwDjJbb.lxdh,qSwDjJbb.zclxDm,qSwDjJbb.hyDm,qSwDjJbb.zcdz,
                qSwDjTd.tdsyztDm,qSwDjTd.fzmj,qSwDjTd.scmj,qSwDjTd.tddj,qSwDjTd.msmj,qSwDjTd.ynmj,qSwDjTd.dwse,qSwDjTd.nynseTd,
                qSwDjFc.fczh,qSwDjFc.fcmj,qSwDjFc.fwxzDm,qSwDjFc.zyhczDm,qSwDjFc.fwjz,qSwDjFc.tdjz,qSwDjFc.fssbjz,qSwDjFc.fcyz,
                qSwDjFc.fcyzYs,qSwDjFc.fcyzMs,qSwDjFc.ynseZy,qSwDjFc.ynseCz,qSwDjFc.nzj,qSwDjFc.nynseFc,qSwDjFc.fcId,qSwDjTd.tdId,qSwDjSy.syId);
        query.from(qSwDjSy).leftJoin(qSwDjSy.swDjTd, qSwDjTd).leftJoin(qSwDjSy.swDjFc,qSwDjFc).leftJoin(qSwDjTd.swDjJbb,qSwDjJbb).leftJoin(qSwDjSy.swDjPcxx, qSwDjPcxx).where(qSwDjPcxx.pcId.eq(pcId));
        query.where(qSwDjSy.syzt.eq(Syzt.ZC.toString()).or(qSwDjSy.syzt.isNull()));
        query.orderBy(new OrderSpecifier(Order.ASC, Expressions.stringPath(qSwDjSy,"dbh")));
        return (List)baseRepository.dslList(query,qBean);
    }

    @Override
    @Transactional(value="oracle_common",readOnly =true,propagation = Propagation.NOT_SUPPORTED)
    public Object parseTddjByDm(String dm) {
        String[] dms = dm.split(",");
        String sql = "";
        List<String> result = new ArrayList();
        for(int i=0;i<dms.length;i++){
            sql = "select t.mc from S_ZD_TDJB t where t.dm='"+dms[i]+"' ";
            Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
            List list = query.getResultList();
            if(CollectionUtils.isNotEmpty(list)){
                result.add(String.valueOf(list.get(0)));
            }else{
                result.add("");
            }

        }
        return result;

    }

    @Override
    public List getzdsyfcList(HashMap param){
        Object idsObj = param.get("ids");
        String sylx = String.valueOf(param.get("sylx"));
        SwDjSyQuery swDjSyQuery = (SwDjSyQuery) param.get("swDjSyQuery");
        QSwDjGdzys qSwDjGdzys = QSwDjGdzys.swDjGdzys;
        QSwDjQs qSwDjQs = QSwDjQs.swDjQs;
        QSwDjSy qSwDjSy = QSwDjSy.swDjSy;
        QSwDjTd qSwDjTd = QSwDjTd.swDjTd;
        QSwDjFc qSwDjFc = QSwDjFc.swDjFc;
        QZd qZd = QZd.zd;
        QSwDjJbb qSwDjJbb = QSwDjJbb.swDjJbb;
        QSwDjXmxx qSwDjXmxx = QSwDjXmxx.swDjXmxx;
        String regionCode = "";
        try{
            regionCode = SessionUtil.getCurrentUser().getRegionCode();
        }catch (Exception e){}

        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        QBean qBean = Projections.bean(SwDjSyQuery.class,qSwDjSy.syId,qSwDjSy.dbh,qSwDjTd.tdId,qSwDjSy.zd.djh,qSwDjJbb.nsrmc,
                qSwDjFc.fczl,qSwDjFc.fcyz,qSwDjFc.fcyzYs,qSwDjFc.fcyzMs,qSwDjFc.ynseZy,qSwDjFc.nzj,qSwDjFc.sl,qSwDjFc.ynseCz,qSwDjFc.nynseFc,qSwDjTd.tddj,qSwDjTd.tdzl,qSwDjTd.scmj,qSwDjJbb.glbm,qSwDjJbb.nsrsbh,qSwDjJbb.zgkgMc,qSwDjJbb.sgyMc,qSwDjFc.sgztDm,qSwDjFc.sgztMc,qSwDjFc.sjly,qSwDjFc.fcId,qSwDjFc.zdsybz,qZd.qlrmc,qZd.tdyt,
                qSwDjGdzys.gdzysId,qSwDjGdzys.gdzysYnse,qSwDjGdzys.gdzysDwse,qSwDjGdzys.gdzysJmxz,qSwDjGdzys.gdzysJmse,qSwDjGdzys.gdzysJspz,qSwDjGdzys.gdzysYjne,qSwDjGdzys.gdzysXbjse,qSwDjGdzys.gdzysBz,qSwDjGdzys.gdzysLrrq,qSwDjGdzys.gdzysHclx,
                qSwDjQs.qsId,qSwDjQs.qsSzly,qSwDjQs.qsYnse,qSwDjQs.qsYjne,qSwDjQs.qsJmxz,qSwDjQs.qsJmse,qSwDjQs.qsJspz,qSwDjQs.qsXbjse,qSwDjQs.qsBz,qSwDjQs.qsLrrq,qSwDjQs.qsHclx);
        jpaQuery.from(qSwDjFc).leftJoin(qSwDjFc.swDjSy,qSwDjSy).leftJoin(qSwDjFc.swDjJbb,qSwDjJbb).leftJoin(qSwDjSy.swDjTd,qSwDjTd).leftJoin(qSwDjSy.zd,qZd).leftJoin(qSwDjSy.swDjGdzys,qSwDjGdzys).leftJoin(qSwDjSy.swDjQs,qSwDjQs).leftJoin(qSwDjSy.swDjXmxx,qSwDjXmxx);
        if(idsObj!=null){
            String ids = String.valueOf(idsObj);
            List idsList = Arrays.asList(ids.split(","));
            jpaQuery.where(qSwDjSy.syId.in(idsList));

        }else{
            if(StringUtils.isNotBlank(swDjSyQuery.getDjh()))
                jpaQuery.where(qSwDjSy.zd.djh.like(QueryCondition.WILDCARDS + swDjSyQuery.getDjh() + QueryCondition.WILDCARDS));
            if(StringUtils.isNotBlank(swDjSyQuery.getXzqdm()))
                jpaQuery.where(qSwDjSy.zd.djh.like(swDjSyQuery.getXzqdm() + QueryCondition.WILDCARDS));
            if(StringUtils.isBlank(swDjSyQuery.getSyzt())){
                jpaQuery.where(qSwDjSy.syzt.eq(Syzt.ZC.toString()).or(qSwDjSy.syzt.isNull()).or(qSwDjSy.syzt.eq("")));
            }else{
                jpaQuery.where(qSwDjSy.syzt.eq(swDjSyQuery.getSyzt()).or(qSwDjSy.syzt.eq("")).or(qSwDjSy.syzt.isNull()));
            }
            jpaQuery.where(qSwDjFc.fcId.isNotNull());
            if(swDjSyQuery.getIsMsTz()!=null && swDjSyQuery.getIsMsTz()){
                jpaQuery.where(qSwDjFc.fcyzMs.isNotNull().and(qSwDjFc.fcyzMs.gt(new BigDecimal(0))));
                jpaQuery.orderBy(qSwDjFc.fcyzMs.desc().nullsLast());
            }else{
                jpaQuery.orderBy(qSwDjFc.nynseFc.desc().nullsLast());
            }
            if("1".equals(swDjSyQuery.getMsbz())){
                jpaQuery.where(qSwDjFc.msbz.eq("1"));
            }else if("2".equals(swDjSyQuery.getMsbz())){
                jpaQuery.where(qSwDjFc.msbz.isNull().or(qSwDjFc.msbz.eq("")));
            }
            if(StringUtils.isNotBlank(swDjSyQuery.getSgztDm())){
                jpaQuery.where(qSwDjFc.sgztDm.eq(swDjSyQuery.getSgztDm()));
            }
            if(StringUtils.isNotBlank(swDjSyQuery.getSjly())){
                jpaQuery.where(qSwDjFc.sjly.eq(swDjSyQuery.getSjly()));
            }
            jpaQuery.where(Expressions.stringPath(qSwDjFc,"zdsybz").eq("1"));
            if(StringUtils.isNotBlank(regionCode)){
                jpaQuery.where(qSwDjJbb.zgkgDm.like("2" + regionCode + QueryCondition.WILDCARDS));
            }
        }
        applySwDjSyQueryPredicates(swDjSyQuery,qSwDjSy,qSwDjJbb, qSwDjTd,qSwDjFc,qZd,qSwDjXmxx,jpaQuery);
        return baseRepository.dslList(jpaQuery,qBean);
    }

    @Override
    public  List getzdsytdList(HashMap param){
        Object idsObj = param.get("ids");
        String sylx = String.valueOf(param.get("sylx"));
        SwDjSyQuery swDjSyQuery = (SwDjSyQuery) param.get("swDjSyQuery");

        QSwDjGdzys qSwDjGdzys = QSwDjGdzys.swDjGdzys;
        QSwDjQs qSwDjQs = QSwDjQs.swDjQs;
        QSwDjSy qSwDjSy = QSwDjSy.swDjSy;
        QSwDjTd qSwDjTd = QSwDjTd.swDjTd;
        QSwDjFc qSwDjFc = QSwDjFc.swDjFc;
        QSwDjJbb qSwDjJbb = QSwDjJbb.swDjJbb;
        QSwDjXmxx qSwDjXmxx = QSwDjXmxx.swDjXmxx;
        QZd qZd = QZd.zd;

        String regionCode = "";
        try{
            regionCode = SessionUtil.getCurrentUser().getRegionCode();
        }catch (Exception e){}
        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        QBean qBean = Projections.bean(SwDjSyQuery.class,qSwDjSy.syId,qSwDjSy.dbh,qSwDjTd.tdId,qSwDjSy.zd.djh,qSwDjJbb.nsrmc,
                qSwDjFc.fczl,qSwDjTd.tddj,qZd.tdzl,qSwDjTd.scmj,qSwDjTd.msmj,qSwDjTd.ynmj,qSwDjTd.dwse,qSwDjTd.sgztDm,qSwDjTd.sgztMc,qSwDjTd.sjly,qSwDjTd.nynseTd,qSwDjTd.msse,qSwDjJbb.nsrsbh,qSwDjJbb.glbm,qSwDjJbb.zgkgMc,qSwDjJbb.sgyMc,qSwDjFc.fcId,qSwDjTd.zdsybz,qZd.qlrmc,qZd.tdyt,qZd.scmjZd,
                qSwDjGdzys.gdzysId,qSwDjGdzys.gdzysYnse,qSwDjGdzys.gdzysDwse,qSwDjGdzys.gdzysJmxz,qSwDjGdzys.gdzysJmse,qSwDjGdzys.gdzysJspz,qSwDjGdzys.gdzysYjne,qSwDjGdzys.gdzysXbjse,qSwDjGdzys.gdzysBz,qSwDjGdzys.gdzysLrrq,qSwDjGdzys.gdzysHclx,
                qSwDjQs.qsId,qSwDjQs.qsSzly,qSwDjQs.qsYnse,qSwDjQs.qsYjne,qSwDjQs.qsJmxz,qSwDjQs.qsJmse,qSwDjQs.qsJspz,qSwDjQs.qsXbjse,qSwDjQs.qsBz,qSwDjQs.qsLrrq,qSwDjQs.qsHclx);
        jpaQuery.from(qSwDjTd).leftJoin(qSwDjTd.swDjSy,qSwDjSy).leftJoin(qSwDjTd.swDjJbb,qSwDjJbb).leftJoin(qSwDjSy.swDjFc, qSwDjFc).leftJoin(qSwDjSy.zd, qZd).leftJoin(qSwDjSy.swDjGdzys,qSwDjGdzys).leftJoin(qSwDjSy.swDjQs,qSwDjQs).leftJoin(qSwDjSy.swDjXmxx,qSwDjXmxx);
        if(idsObj!=null){
            String ids = String.valueOf(idsObj);
            List idsList = Arrays.asList(ids.split(","));
            jpaQuery.where(qSwDjSy.syId.in(idsList));

        }else{
            if(StringUtils.isNotBlank(swDjSyQuery.getDjh()))
                jpaQuery.where(qSwDjSy.zd.djh.like(QueryCondition.WILDCARDS + swDjSyQuery.getDjh() + QueryCondition.WILDCARDS));
            //if(StringUtils.isNotBlank(swDjSyQuery.getXzqdm()))
            //    jpaQuery.where(qSwDjSy.zd.djh.like(swDjSyQuery.getXzqdm() + QueryCondition.WILDCARDS));
            if(StringUtils.isBlank(swDjSyQuery.getSyzt())){
                jpaQuery.where(qSwDjSy.syzt.eq(Syzt.ZC.toString()).or(qSwDjSy.syzt.isNull()).or(qSwDjSy.syzt.eq("")));
            }else{
                jpaQuery.where(qSwDjSy.syzt.eq(swDjSyQuery.getSyzt()).or(qSwDjSy.syzt.eq("")).or(qSwDjSy.syzt.isNull()));
            }
            jpaQuery.where(qSwDjTd.tdId.isNotNull());
            if(swDjSyQuery.getIsMsTz()!=null && swDjSyQuery.getIsMsTz()){
                jpaQuery.where(qSwDjTd.msmj.isNotNull().and(qSwDjTd.msmj.gt(new BigDecimal(0))));
                jpaQuery.orderBy(qSwDjTd.msmj.desc().nullsLast());
            }else{
                jpaQuery.orderBy(qSwDjTd.nynseTd.desc().nullsLast());
            }
            if("1".equals(swDjSyQuery.getMsbz())){
                jpaQuery.where(qSwDjTd.msbz.eq("1"));
            }else if("2".equals(swDjSyQuery.getMsbz())){
                jpaQuery.where(qSwDjTd.msbz.isNull().or(qSwDjTd.msbz.eq("")));
            }
            if(StringUtils.isNotBlank(swDjSyQuery.getTddj())){
                //String tddj = CommonUtil.reSetTddj(swDjSyQuery.getTddj());
                jpaQuery.where(qSwDjTd.tddj.eq(swDjSyQuery.getTddj()));
            }

            //过滤工矿区
            if(StringUtils.isNotBlank(swDjSyQuery.getIsGkq())){
                String tdjb_gkq_sql = "SELECT DM FROM S_ZD_TDJB WHERE MC LIKE '%工矿区%'";
                Query query = baseRepository.getEntityManager().createNativeQuery(tdjb_gkq_sql);
                List tdjb_gkq = query.getResultList();

                if("1".equals(swDjSyQuery.getIsGkq())){
                    jpaQuery.where(qSwDjTd.tddj.in(tdjb_gkq));
                }else if("0".equals(swDjSyQuery.getIsGkq())){
                    jpaQuery.where(qSwDjTd.tddj.notIn(tdjb_gkq).or(qSwDjTd.tddj.isNull()));
                }
            }

            if(StringUtils.isNotBlank(swDjSyQuery.getSgztDm())){
                jpaQuery.where(qSwDjTd.sgztDm.eq(swDjSyQuery.getSgztDm()));
            }
            if(StringUtils.isNotBlank(swDjSyQuery.getSjly())){
                jpaQuery.where(qSwDjTd.sjly.eq(swDjSyQuery.getSjly()));
            }
            jpaQuery.where(Expressions.stringPath(qSwDjTd,"zdsybz").eq("1"));
            if(StringUtils.isNotBlank(regionCode)){
                if (regionCode.length() > 6)
                    regionCode = regionCode.substring(0, 6);
                jpaQuery.where(qSwDjJbb.zgkgDm.like("2" + regionCode + QueryCondition.WILDCARDS));
            }
        }
        applySwDjSyQueryPredicates(swDjSyQuery,qSwDjSy,qSwDjJbb, qSwDjTd,qSwDjFc,qZd,qSwDjXmxx,jpaQuery);
        List list = baseRepository.dslList(jpaQuery,qBean);
       return  list;
    }

    @Override
    @Transactional(value="oracle_common")
    public void deletSwDjTdByTdId(String tdId) {

        String jpql = "delete from SwDjTd t where t.tdId=?0";
        baseRepository.executeJpql(jpql,tdId);
    }

    @Override
    @Transactional(value="oracle_common")
    public void deletSwDjFcByFcId(String fcId) {
        String jpql = "delete from SwDjFc t where t.fcId=?0";
        baseRepository.executeJpql(jpql,fcId);
    }

    @Override
    @Transactional(value="oracle_common")
    public String fandTdzl(String syId) {
        String tdzl = "";
        String sql = "select t1.tdzl from zd t1 inner join sw_dj_sy t2 on t1.djh=t2.djh " +
                     "where t2.sy_id='"+syId+"'";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        List list = query.getResultList();
        if(list != null && list.size() > 0) {
            tdzl = (String)list.get(0);
        }else{
            sql = "select t1.tdzl from SW_DJ_XMXX t1 inner join sw_dj_sy t2 on t1.xm_id=t2.gd_id " +
                    "where t2.sy_id='"+syId+"'";
            query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
            list = query.getResultList();
            if(list != null && list.size() > 0) {
                tdzl = (String)list.get(0);
            }
        }
        return tdzl;
    }

    public Object getTdfcsy(String sylx,SwDjSyQuery swDjSyQuery){
        String sql = "";
        if(StringUtils.isBlank(sylx) || Sylx.TDSY.toString().equals(sylx)) {
            sql = "select sum(nvl(t1.scmj,0))scmj,sum(nvl(t1.msmj,0))msmj,sum(nvl(t1.ynmj,0))ynmj,sum(nvl(t1.nynse,0))nynse,sum(nvl(t1.msse,0))msse from sw_dj_td t1  " +
                    "left join sw_dj_sy t2 on t1.sy_id=t2.sy_id " +
                    "left join zd t3 on t3.djh=t2.djh " +
                    "left join sw_dj_jbb t4 on t4.jbb_id=t1.jbb_id " +
                    "left join sw_dj_xmxx t7 on t7.xm_id=t2.gd_id " +
                    "where (t2.syzt='1' or t2.syzt is null)  and t4.zgkg_dm like '2" + dwxxService.getUserRegionCode() + "%' and t1.msmj is not null and t1.msmj >0 ";
        }else if(Sylx.FCSY.toString().equals(sylx)){
            sql = "select sum(nvl(t1.fcyz,0))fcyz,sum(nvl(t1.fcyz_ys,0))fcyz_ys,sum(nvl(t1.fcyz_ms,0))fcyz_ms,sum(nvl(t1.ynse_zy,0))ynse_zy,sum(nvl(t1.ynse_cz,0))ynse_cz,sum(nvl(t1.nynse,0))nynse from sw_dj_fc t1  " +
                    "left join sw_dj_sy t2 on t1.sy_id=t2.sy_id " +
                    "left join zd t3 on t3.djh=t2.djh " +
                    "left join sw_dj_td t5 on t5.sy_id=t2.sy_id "+
                    "left join sw_dj_jbb t4 on t4.jbb_id=t5.jbb_id "+
                    "left join sw_dj_xmxx t7 on t7.xm_id=t2.gd_id "+
                    "where (t2.syzt='1' or t2.syzt is null)  and t4.zgkg_dm like '2" + dwxxService.getUserRegionCode() + "%'and t1.fcyz_ms is not null and t1.fcyz_ms >0";
        }
            sql = sql +addSyxxParameter(swDjSyQuery,sylx,false);
            Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
            query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
            Object resultmap = query.getSingleResult();
            return resultmap;

    }

    @Override
    public List getHylxNext(String hydm) {
        int hydmlength=hydm.length()+2;
        String sql = "select dm as hydm,mc as hymc from dm_hydm where dm like '" + hydm + "%'" + " and length(dm)="+hydmlength;

        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        List list = query.getResultList();
        return list;
    }



    @Override
    @Transactional(value="oracle_common",readOnly =true,propagation = Propagation.NOT_SUPPORTED)
    public List getMapTdZdsy(String nsrsbh,String djh) {
        String sql = "";
        String regionCode = "";
        try{
            regionCode = SessionUtil.getCurrentUser().getRegionCode();
        }catch (Exception e){}
        //glbm是否为null。不同sql
        if(djh==null){
            djh="";
        }
        if(nsrsbh !=null&&nsrsbh!=""){
            sql = "select t1.djh,NVL(t2.tdzl,' ') as tdzl ,t2.ynmj,t2.nynse,t3.nsrmc from SW_DJ_SY t1 , SW_DJ_TD t2,SW_DJ_JBB t3 where t1.sy_id=t2.sy_id  and  t2.zdsybz  = '1' and t2.jbb_id=t3.jbb_id and t3.zgkg_dm like '2'||'"+regionCode+"%' and t1.djh like '%"+djh+"%' and t3.nsrsbh like '%"+nsrsbh+"%'";
        }else{
            sql = "select t1.djh,NVL(t2.tdzl,' ') as tdzl ,t2.ynmj,t2.nynse,t3.nsrmc from SW_DJ_SY t1 , SW_DJ_TD t2,SW_DJ_JBB t3 where t1.sy_id=t2.sy_id  and  t2.zdsybz  = '1' and t2.jbb_id=t3.jbb_id and t3.zgkg_dm like '2'||'"+regionCode+"%' and t1.djh like '%"+djh+"%' ";
        }
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        List list = query.getResultList();
        return list;

    }

    @Override
    @Transactional(value="oracle_common",readOnly =true,propagation = Propagation.NOT_SUPPORTED)
    public List getXJTdZdsy(String nsrsbh,String djh) {
        String sql = "";
        String regionCode = "";
        try{
            regionCode = SessionUtil.getCurrentUser().getRegionCode();
        }catch (Exception e){}
        //glbm是否为null。不同sql
        if(djh==null){
            djh="";
        }
        if(nsrsbh !=null&&nsrsbh!=""){
            sql = "select count(0) as sl,SUBSTR(t1.djh, 1, 6) as xzqdm from SW_DJ_SY t1 , SW_DJ_TD t2,SW_DJ_JBB t3 where t1.sy_id=t2.sy_id  and  t2.zdsybz  = '1' and t2.jbb_id=t3.jbb_id and t3.zgkg_dm like '2'||'"+regionCode+"%' and t1.djh like '%"+djh+"%' and t3.nsrsbh like '%"+nsrsbh+"%' group by SUBSTR(t1.djh, 1, 6)";
        }else{
            sql = "select count(0) as sl,SUBSTR(t1.djh, 1, 6) as xzqdm from SW_DJ_SY t1 , SW_DJ_TD t2,SW_DJ_JBB t3 where t1.sy_id=t2.sy_id  and  t2.zdsybz  = '1' and t2.jbb_id=t3.jbb_id and t3.zgkg_dm like '2'||'"+regionCode+"%' and t1.djh like '%"+djh+"%' group by SUBSTR(t1.djh, 1, 6)";
        }
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        List list = query.getResultList();
        return list;

    }


    @Override
    @Transactional(value="oracle_common",readOnly =true,propagation = Propagation.NOT_SUPPORTED)
    public List getZJTdZdsy(String nsrsbh,String djh) {
        String sql = "";
        String regionCode = "";
        try{
            regionCode = SessionUtil.getCurrentUser().getRegionCode();
        }catch (Exception e){}
        //glbm是否为null。不同sql
        if(djh==null){
            djh="";
        }
        if(nsrsbh !=null&&nsrsbh!=""){
            sql = "select count(0) as sl,SUBSTR(t1.djh, 1, 9) as xzqdm from SW_DJ_SY t1 , SW_DJ_TD t2,SW_DJ_JBB t3 where t1.sy_id=t2.sy_id  and  t2.zdsybz  = '1' and t2.jbb_id=t3.jbb_id and t3.zgkg_dm like '2'||'"+regionCode+"%' and t1.djh like '%"+djh+"%' and t3.nsrsbh like '%"+nsrsbh+"%' group by SUBSTR(t1.djh, 1, 9)";
        }else{
            sql = "select count(0) as sl,SUBSTR(t1.djh, 1, 9) as xzqdm from SW_DJ_SY t1 , SW_DJ_TD t2,SW_DJ_JBB t3 where t1.sy_id=t2.sy_id  and  t2.zdsybz  = '1' and t2.jbb_id=t3.jbb_id and t3.zgkg_dm like '2'||'"+regionCode+"%' and t1.djh like '%"+djh+"%' group by SUBSTR(t1.djh, 1, 9)";
        }
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        List list = query.getResultList();
        return list;

    }


    @Override
    @Transactional(value="oracle_common",readOnly =true,propagation = Propagation.NOT_SUPPORTED)
    public List getMapFcZdsy(String nsrsbh,String djh) {
        String sql = "";
        String regionCode = "";
        try{
            regionCode = SessionUtil.getCurrentUser().getRegionCode();
        }catch (Exception e){}

        //glbm是否为null。不同sql
        if(nsrsbh!=null&&nsrsbh!=""){
            sql = "select t1.djh,NVL(t2.fczl,' ') as fczl,NVL(t2.fcmj,0) as fcmj,t2.nynse,t3.nsrmc from SW_DJ_SY t1 , SW_DJ_FC t2,SW_DJ_JBB t3 where t1.sy_id=t2.sy_id  and  t2.zdsybz  = '1' and t2.jbb_id=t3.jbb_id and t3.zgkg_dm like '2'||'"+regionCode+"%' and t1.djh like '%"+djh+"%' and t3.nsrsbh like '%"+nsrsbh+"%' ";
        }else{
            sql = "select t1.djh,NVL(t2.fczl,' ') as fczl,NVL(t2.fcmj,0) as fcmj,t2.nynse,t3.nsrmc from SW_DJ_SY t1 , SW_DJ_FC t2,SW_DJ_JBB t3 where t1.sy_id=t2.sy_id  and  t2.zdsybz  = '1' and t2.jbb_id=t3.jbb_id and t3.zgkg_dm like '2'||'"+regionCode+"%' and t1.djh like '%"+djh+"%' ";
        }
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        List list = query.getResultList();
        return list;

    }

    @Override
    @Transactional(value="oracle_common",readOnly =true,propagation = Propagation.NOT_SUPPORTED)
    public List getHyzl(String hydm) {
        String sql = "";
        sql = "select * from DM_HYDM t where t.dm=substr('"+hydm+"',0,3) ";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        List list = query.getResultList();
        return list;

    }
    @Override
    @Transactional(value="oracle_common",readOnly =true,propagation = Propagation.NOT_SUPPORTED)
    public List getHydl(String hydm) {
        String sql = "";
        sql = "select * from DM_HYDM t where t.dm=substr('"+hydm+"',0,1) ";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        List list = query.getResultList();
        return list;

    }
    @Override
    @Transactional(value="oracle_common")
    public String getCreateUser(String userId) {
        String xgr = "";
        String sql = "select t1.user_name from pf_user t1  " +
                "where t1.user_id='"+userId+"'";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        List list = query.getResultList();
        if(list != null && list.size() > 0) {
            xgr = (String)list.get(0);
        }
        return xgr;
    }

    @Override
    @Transactional(readOnly = true)
    public List findCzrBySyId(String syId, String cz_type){
        String sql = "SELECT * FROM SW_DJ_CZ T1 WHERE T1.SY_ID = '" + syId + "' AND T1.CZ_TYPE = '" + cz_type + "'" ;
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<Map<String,Object>> list = query.getResultList();
        return list;
    }

    @Override
    @Transactional(readOnly = true)
    public String addCzrxx(String nsrsbh, String nsrmc, String syId, String cz_type){
        try{
            String sql = "SELECT COUNT(1) FROM SW_DJ_CZ T1 WHERE T1.SY_ID = '" + syId + "' AND T1.CZ_TYPE = '" + cz_type + "' AND T1.NSRSBH = '" + nsrsbh + "'" ;
            Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
            Object obj = query.getSingleResult();
            int count = ((BigDecimal)obj).intValue();
            if(count > 0){
                return "exist";
            }
            sql = "insert into SW_DJ_CZ(NSRSBH, NSRMC, SY_ID, CZ_TYPE) values ('"+nsrsbh+"', '"+nsrmc+"', '"+syId+"', '"+cz_type+"')";
            query = baseRepository.getEntityManager().createNativeQuery(sql);
            query.executeUpdate();
            return "true";
        }catch (Exception e){
            e.printStackTrace();
        }
        return "false";
    }

    @Override
    @Transactional(readOnly = true)
    public String deleteCzrxx(String nsrsbh, String syId, String cz_type){
        try{
            String sql = "DELETE FROM SW_DJ_CZ T1 WHERE T1.SY_ID = '" + syId + "' AND T1.CZ_TYPE = '" + cz_type + "' AND T1.NSRSBH = '" + nsrsbh + "'" ;
            Query query = baseRepository.getEntityManager().createNativeQuery(sql);
            query.executeUpdate();
            return "true";
        }catch (Exception e){
            e.printStackTrace();
        }
        return "false";
    }
    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public Object findSyByNsrsbh(String nsrsbh) {

        StringBuffer sql = new StringBuffer()
                .append("select t1.td_id,t2.fc_id,t3.sy_id,t3.djh,t1.ynmj,t1.dwse,t5.tdzl from sw_dj_td t1  left join sw_dj_fc t2 on t1.sy_id=t2.sy_id left join sw_dj_sy t3 on t1.sy_id=t3.sy_id left join sw_dj_jbb t4 on t1.jbb_id=t4.jbb_id left join zd t5 on t3.djh=t5.djh");
        StringBuffer whereClause = new StringBuffer()
                .append(" where  t4.nsrsbh = '").append(nsrsbh).append("' ").append(" and t3.djh like '%999999%'");
        sql.append(whereClause);
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        return query.getResultList();
    }


    @Override
    @Transactional(value="oracle_common",readOnly =true,propagation = Propagation.NOT_SUPPORTED)
    public List getZdbysy() {
        String sql = "select t1.djh, t2.sgzt_dm from SW_DJ_SY t1, SW_DJ_TD t2 where t1.sy_id=t2.sy_id";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List list = query.getResultList();
        return list;
    }


    /*金三总管户--------------------------开始*/
    //统计金三系统总管数
    @Override
    @Transactional(readOnly = true)
    public Page findJsZgh(SwDjSyQuery swDjSyQuery, Pageable pageable) {
        String regionCode = "";
        try{
            regionCode = SessionUtil.getCurrentUser().getRegionCode();
        }catch (Exception e){}
        String dwdm = "";
        if(regionCode.length()==2){
            dwdm= "4";
        }
        String sql ="select dwdm, dwmc, zgh  from sw_js_zgh where dwdm like '" +regionCode+"%' and dwdm != " +regionCode+" and length(dwdm) = "+dwdm+" order by SERIALNUMBER ";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        String countSql = "select count(*) from (";
        countSql += sql;
        countSql +=")";
        Query countQuery = baseRepository.getEntityManager().createNativeQuery(countSql);
        Page page =  baseRepository.find(query, countQuery, pageable);
        return page;
    }
    //统计金三系统总管数(市级)
    @Override
    @Transactional(readOnly = true)
    public Page findJsZghSj(SwDjSyQuery swDjSyQuery, Pageable pageable) {
        String regionCode = "";
        try{
            regionCode = SessionUtil.getCurrentUser().getRegionCode();
        }catch (Exception e){}
        String dwdm = "";
        if(regionCode.length()==4){
            dwdm= "6";
        }
        String sql ="select dwdm, dwmc, zgh  from sw_js_zgh where dwdm like '" +regionCode+"%' and dwdm != " +regionCode+" and length (dwdm) ="+ dwdm +" order by dwdm ";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        String countSql = "select count(*) from (";
        countSql += sql;
        countSql +=")";
        Query countQuery = baseRepository.getEntityManager().createNativeQuery(countSql);
        Page page =  baseRepository.find(query, countQuery, pageable);
        return page;
    }
    @Override
    @Transactional(readOnly = true)
    public void updateZgh(String ZGH,String dwdm){
        String delAssignmentSql = "update SW_JS_ZGH set zgh = "+ZGH+" where dwdm = "+dwdm;
        Query delAssignmentQuery = baseRepository.getEntityManager().createNativeQuery(delAssignmentSql);
        delAssignmentQuery.executeUpdate();
    };



    @Override
    @Transactional(readOnly = true)
    public List findZghForExp(SwDjSyQuery swDjSyQuery) {
        // SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        String regionCode = "";
        try{
            regionCode = SessionUtil.getCurrentUser().getRegionCode();
        }catch (Exception e){}
        String dwdm = "";
        if(regionCode.length()==2){
            dwdm= "4";
        }
        if(regionCode.length()==4){
            dwdm= "6";
        }
        String sql ="select dwdm, dwmc, zgh  from sw_js_zgh where dwdm like '" +regionCode+"%' and dwdm != " +regionCode+" and length(dwdm) = "+dwdm+" order by SERIALNUMBER ";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        return list;
    }
    public List findZghSjForExp(SwDjSyQuery swDjSyQuery){
        String regionCode = "";
        try{
            regionCode = SessionUtil.getCurrentUser().getRegionCode();
        }catch (Exception e){}
        String dwdm = "";
        if(regionCode.length()==2){
            dwdm= "4";
        }
        if(regionCode.length()==4){
            dwdm= "6";
        }
        String sql ="select dwdm, dwmc, zgh  from sw_js_zgh where dwdm like '" +regionCode+"%' and dwdm != " +regionCode+" and length(dwdm) = "+dwdm+" order by dwdm ";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        return list;
    }

    /*金三总管户--------------------------结束*/

    @Override
    @Transactional(readOnly = true)
    public Page findSybhls(SwDjSyQuery swDjSyQuery, Pageable pageable) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        String sql=getSybhSql(swDjSyQuery);
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        String countSql = "select count(*) from (";
        countSql += sql;
        countSql +=")";
        Query countQuery = baseRepository.getEntityManager().createNativeQuery(countSql);
        Page page =  baseRepository.find(query, countQuery, pageable);
        return page;
    }

    @Override
    @Transactional(readOnly = true)
    public Object getQxByDs(String ds) {

        StringBuffer sql = new StringBuffer()
                .append("select dwmc,dwdm from S_DM_DWXX_CZ ");
        StringBuffer whereClause = new StringBuffer()
                .append("where dwdm like '").append(ds).append("%' ").append(" and dwjb='1' ");
        sql.append(whereClause);
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        return query.getResultList();
    }


    @Override
    @Transactional(readOnly = true)
    public List findSybhlsForExp(SwDjSyQuery swDjSyQuery) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        String sql=getSybhSql(swDjSyQuery);

        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        return list;
    }

    @Override
    @Transactional(readOnly = true)
    public List sjbhTj(SwDjSyQuery swDjSyQuery) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        String sql="select t1.rq,t1.scmjzj,t1.nynsezj,t1.fcyzzj,t1.nzjzj,t1.fcnynsezj,t2.syzj from(select "+df.format(swDjSyQuery.getSqUpdateDateBegin())+"||'至'||"+df.format(swDjSyQuery.getSqUpdateDateEnd())+" rq,(sum(scmj)-sum(sqscmj)) scmjzj,(sum(nynse)-sum(sqnynse)) nynsezj,(sum(fcyz)-sum(sqfcyz)) fcyzzj,(sum(nzj)-sum(sqnzj)) nzjzj,(sum(fcnynse)-sum(sqfcnynse)) fcnynsezj from("+getSybhSql(swDjSyQuery)+"))t1,"+
                "(select count(*) syzj from("+getSybhSql(swDjSyQuery)+"  and lx='add'))t2";

        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        return list;
    }
    private String getSybhSql(SwDjSyQuery swDjSyQuery){
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        String sql="select" +
                "        * " +
                "    from" +
                "        ( select" +
                "            * " +
                "        from" +
                "            (  select" +
                "                0 fcyzbh," +
                "                0 fcnynsebh," +
                "                0 nzjbh," +
                "                0 msfcyzbh," +
                "                0 ysfcyzbh," +
                "                0 czfcyzbh," +
                "                0 scmjbh," +
                "                0 ynmjbh," +
                "                0 msmjbh," +
                "                0 nynsebh," +
                "                t2.fcyz," +
                "                t2.nynse as fcnynse," +
                "                t2.nzj," +
                "                t2.fcyz_ms as msfcyz," +
                "                t2.fcyz_ys as ysfcyz," +
                "                t2.czfcyz," +
                "                t5.djh," +
                "                t3.nsrsbh," +
                "                t3.nsrmc," +
                "                t3.zgkg_mc," +
                "                t3.zgkg_dm," +
                "                t1.scmj," +
                "                t1.ynmj," +
                "                t1.msmj," +
                "                t1.nynse," +
                "                t1.sgzt_dm," +
                "                t1.sy_id," +
                "                0 sqscmj," +
                "                0 sqnynse," +
                "                0 sqfcyz," +
                "                0 sqnzj," +
                "                0 sqfcnynse," +
                "                '' bqsyhisId," +
                "                '' sqsyhisId," +
                "                'add' as lx                 " +
                "            from" +
                "                sw_dj_td t1                  " +
                "            join" +
                "                sw_dj_fc t2 " +
                "                    on t1.sy_id=t2.sy_id                  " +
                "            join" +
                "                sw_dj_sy t5 " +
                "                    on t1.sy_id=t5.sy_id                  " +
                "            left join" +
                "                sw_dj_jbb t3 " +
                "                    on t1.jbb_id=t3.jbb_id                   " +
                "            where" +
                "                (" +
                "                    t5.syzt is null " +
                "                    or t5.syzt='1' " +
                "                ) " +
                "                and  to_char(t1.lrrq,'yyyymmdd')>='"+df.format(swDjSyQuery.getSqUpdateDateBegin())+"' " +
                "                and  to_char(t1.lrrq,'yyyymmdd')<'"+df.format(swDjSyQuery.getSqUpdateDateEnd())+"' " +
                "                and t1.lrrq=t1.update_date                 " +
                "            union" +
                "            select" +
                "                decode(t2.fcyz-t6.fc_fcyz,0,0,1) fcyzbh," +
                "                decode(t2.nynse-t6.fc_nynse,0,0,1) fcnynsebh," +
                "                decode(t2.nzj-t6.fc_nzj,0,0,1) nzjbh," +
                "                decode(t2.fcyz_ms-t6.fc_fcyz_ms,0,0,1) msfcyzbh," +
                "                decode(t2.fcyz_ys-t6.fc_fcyz_ys,0,0,1) ysfcyzbh," +
                "                decode(t2.czfcyz-t6.fc_fcyz_cz,0,0,1) czfcyzbh," +
                "                decode(t1.scmj-t6.td_scmj,0,0,1) scmjbh," +
                "                decode(t1.ynmj-t6.td_ynmj,0,0,1) ynmjbh," +
                "                decode(t1.msmj-t6.td_msmj,0,0,1) msmjbh," +
                "                decode(t1.nynse-t6.td_nynse,0,0,1) nynsebh," +
                "                t2.fcyz," +
                "                t2.nynse as fcnynse," +
                "                t2.nzj," +
                "                t2.fcyz_ms as msfcyz," +
                "                t2.fcyz_ys as ysfcyz," +
                "                t2.czfcyz," +
                "                t5.djh," +
                "                t3.nsrsbh," +
                "                t3.nsrmc," +
                "                t3.zgkg_mc," +
                "                t3.zgkg_dm," +
                "                t1.scmj," +
                "                t1.ynmj," +
                "                t1.msmj," +
                "                t1.nynse," +
                "                t1.sgzt_dm," +
                "                t1.sy_id," +
                "                t6.td_scmj sqscmj," +
                "                t6.td_nynse sqnynse," +
                "                t6.fc_fcyz sqfcyz," +
                "                t6.fc_nzj sqnzj," +
                "                t6.fc_nynse sqfcnynse," +
                "                '' bqsyhisId," +
                "                t6. sqsyhisId," +
                "                'xg' as lx                 " +
                "            from" +
                "                sw_dj_td t1 " +
                "                                " +
                "            join" +
                "                sw_dj_fc t2 " +
                "                    on t1.sy_id=t2.sy_id                  " +
                "            join" +
                "                sw_dj_sy t5 " +
                "                    on t1.sy_id=t5.sy_id                  " +
                "            left join" +
                "                sw_dj_jbb t3 " +
                "                    on t1.jbb_id=t3.jbb_id                   " +
                "            left join (" +
                "              select * from(" +
                "                 select t.syhis_id sqsyhisId,t.xgrq,t.td_sgzt_dm,RANK() OVER(PARTITION BY t.sy_id ORDER BY t.xgrq DESC) AS PM,t.sy_id,t.jbb_zgkg_mc,t.jbb_zgkg_dm,t.td_nynse,t.fc_nynse,t.td_msmj,t.td_scmj,t.td_ynmj,t.fc_fcyz_ms,t.fc_fcyz_ys,t.fc_fcyz,t.fc_nzj,(t.fc_fcyz-t.fc_fcyz_ys-t.fc_fcyz_ms) fc_fcyz_cz from SW_DJ_SY_HIS t " +
                "                 ) where pm=1" +
                "            )t6 on t1.sy_id=t6.sy_id                  " +
                "            where" +
                "                (" +
                "                    t5.syzt is null " +
                "                    or t5.syzt='1' " +
                "                ) " +
                "                and  to_char(t1.update_date,'yyyymmdd')>='"+df.format(swDjSyQuery.getSqUpdateDateBegin())+"' " +
                "                and  to_char(t1.update_date,'yyyymmdd')<'" + df.format(swDjSyQuery.getSqUpdateDateEnd())+"' " +
                "                and t1.lrrq is null " +
                "                and to_char(t6.xgrq,'yyyymmdd')<to_char(t1.update_date,'yyyymmdd')" +
                "                and t1.sgzt_dm=t6.td_sgzt_dm  " +
                "            union" +
                "            select" +
                "                0 fcyzbh," +
                "                0 fcnynsebh," +
                "                0 nzjbh," +
                "                0 msfcyzbh," +
                "                0 ysfcyzbh," +
                "                0 czfcyzbh," +
                "                0 scmjbh," +
                "                0 ynmjbh," +
                "                0 msmjbh," +
                "                0 nynsebh," +
                "                t2.fcyz," +
                "                t2.nynse as fcnynse," +
                "                t2.nzj," +
                "                t2.fcyz_ms as msfcyz," +
                "                t2.fcyz_ys as ysfcyz," +
                "                t2.czfcyz," +
                "                t5.djh," +
                "                t3.nsrsbh," +
                "                t3.nsrmc," +
                "                t3.zgkg_mc," +
                "                t3.zgkg_dm," +
                "                t1.scmj," +
                "                t1.ynmj," +
                "                t1.msmj," +
                "                t1.nynse," +
                "                t1.sgzt_dm," +
                "                t1.sy_id," +
                "                0 sqscmj," +
                "                0 sqnynse," +
                "                0 sqfcyz," +
                "                0 sqnzj," +
                "                0 sqfcnynse," +
                "                '' bqsyhisId," +
                "                t6. sqsyhisId," +
                "                'add' as lx                 " +
                "            from" +
                "                sw_dj_td t1 " +
                "                                " +
                "            join" +
                "                sw_dj_fc t2 " +
                "                    on t1.sy_id=t2.sy_id                  " +
                "            join" +
                "                sw_dj_sy t5 " +
                "                    on t1.sy_id=t5.sy_id                  " +
                "            left join" +
                "                sw_dj_jbb t3 " +
                "                    on t1.jbb_id=t3.jbb_id                   " +
//                "            left join" +
//                "                zd t4 " +
//                "                    on t4.djh=t5.djh" +
                "            left join (" +
                "              select * from(" +
                "                 select t.syhis_id sqsyhisId,t.xgrq,t.td_sgzt_dm,RANK() OVER(PARTITION BY t.sy_id ORDER BY t.xgrq DESC) AS PM,t.sy_id,t.jbb_zgkg_mc,t.jbb_zgkg_dm,t.td_nynse,t.fc_nynse,t.td_msmj,t.td_scmj,t.td_ynmj,t.fc_fcyz_ms,t.fc_fcyz_ys,t.fc_fcyz,t.fc_nzj,(t.fc_fcyz-t.fc_fcyz_ys-t.fc_fcyz_ms) fc_fcyz_cz from SW_DJ_SY_HIS t " +
                "                 ) where pm=1" +
                "            )t6 on t1.sy_id=t6.sy_id                  " +
                "            where" +
                "                (" +
                "                    t5.syzt is null " +
                "                    or t5.syzt='1' " +
                "                ) " +
                "                and  to_char(t1.update_date,'yyyymmdd')>='"+df.format(swDjSyQuery.getSqUpdateDateBegin())+"' " +
                "                and  to_char(t1.update_date,'yyyymmdd')<'"+df.format(swDjSyQuery.getSqUpdateDateEnd())+"' " +
                "                and t1.lrrq is null " +
                "                and to_char(t6.xgrq,'yyyymmdd')<to_char(t1.update_date,'yyyymmdd')" +
                "                and t1.sgzt_dm<>t6.td_sgzt_dm  " +
                "            union" +
                "            select " +
                "                decode(t1.fc_fcyz-t2.fc_fcyz,0,0,1) fcyzbh," +
                "                decode(t1.fc_nynse-t2.fc_nynse,0,0,1) fcnynsebh," +
                "                decode(t1.fc_nzj-t2.fc_nzj,0,0,1) nzjbh," +
                "                decode(t1.fc_fcyz_ms-t2.fc_fcyz_ms,0,0,1) msfcyzbh," +
                "                decode(t1.fc_fcyz_ys-t2.fc_fcyz_ys,0,0,1) ysfcyzbh," +
                "                decode(t1.fc_fcyz_cz-t2.fc_fcyz_cz,0,0,1) czfcyzbh," +
                "                decode(t1.td_scmj-t2.td_scmj,0,0,1) scmjbh," +
                "                decode(t1.td_ynmj-t2.td_ynmj,0,0,1) ynmjbh," +
                "                decode(t1.td_msmj-t2.td_msmj,0,0,1) msmjbh," +
                "                decode(t1.td_nynse-t2.td_nynse,0,0,1) nynsebh," +
                "                t1.fc_fcyz fcyz," +
                "                t1.fc_nynse as fcnynse," +
                "                t1.fc_nzj nzj," +
                "                t1.fc_fcyz_ms as msfcyz," +
                "                t1.fc_fcyz_ys as ysfcyz," +
                "                (t1.fc_fcyz-t1.fc_fcyz_ms-t1.fc_fcyz_ys)czfcyz," +
                "                t1.djh," +
                "                t1.nsrsbh," +
                "                t1.jbb_nsrmc nsrmc," +
                "                t1.jbb_zgkg_mc zgkg_mc," +
                "                t1.jbb_zgkg_dm zgkg_dm," +
                "                t1.td_scmj scmj," +
                "                t1.td_ynmj ynmj," +
                "                t1.td_msmj msmj," +
                "                t1.td_nynse nynse," +
                "                t1.td_sgzt_dm sgzt_dm," +
                "                t1.sy_id," +
                "                t2.td_scmj sqscmj," +
                "                t2.td_nynse sqnynse," +
                "                t2.fc_fcyz sqfcyz," +
                "                t2.fc_nzj sqnzj," +
                "                t2.fc_nynse sqfcnynse," +
                "                t1.syhis_id bqsyhisId," +
                "                t2.syhis_id sqsyhisId," +

                "                'xg' as lx   " +
                " from (select * from" +
                "     (select RANK() OVER(PARTITION BY t.sy_id ORDER BY t.xgrq DESC) AS PM,t.* ,(t.fc_fcyz-t.fc_fcyz_ys-t.fc_fcyz_ms) fc_fcyz_cz from sw_dj_sy_his t where t.sy_id in (" +
                "     select t.sy_id from sw_dj_sy_his t where t.sy_id in (" +
                "       select" +
                "               " +
                "                t.sy_id                " +
                "            from" +
                "                sw_dj_td t                  " +
                "            " +
                "                where  to_char(t.update_date,'yyyymmdd')>='"+df.format(swDjSyQuery.getSqUpdateDateEnd())+"'  " +
                "                and t.lrrq is null ) and to_char(t.update_date,'yyyymmdd')>='"+df.format(swDjSyQuery.getSqUpdateDateBegin())+"' and to_char(t.update_date,'yyyymmdd')<='"+df.format(swDjSyQuery.getSqUpdateDateEnd())+"' group by t.sy_id having count(*)>2) ) where pm=1)t1" +
                "                left join" +
                "                (select * from" +
                "     (select RANK() OVER(PARTITION BY t.sy_id ORDER BY t.xgrq DESC) AS PM,t.*,(t.fc_fcyz-t.fc_fcyz_ys-t.fc_fcyz_ms) fc_fcyz_cz from sw_dj_sy_his t where t.sy_id in (" +
                "     select t.sy_id from sw_dj_sy_his t where t.sy_id in (" +
                "       select" +
                "               " +
                "                t.sy_id                " +
                "            from" +
                "                sw_dj_td t                  " +
                "            " +
                "                where  to_char(t.update_date,'yyyymmdd')>='"+df.format(swDjSyQuery.getSqUpdateDateEnd())+"'  " +
                "                and t.lrrq is null ) and to_char(t.update_date,'yyyymmdd')>='"+df.format(swDjSyQuery.getSqUpdateDateBegin())+"' and to_char(t.update_date,'yyyymmdd')<='"+df.format(swDjSyQuery.getSqUpdateDateEnd())+"' group by t.sy_id having count(*)>2) ) where pm=2)t2 on t1.sy_id=t2.sy_id where t1.td_sgzt_dm=t2.td_sgzt_dm" +
                "                union" +
                "                select 0 fcyzbh," +
                "                0 fcnynsebh," +
                "                0 nzjbh," +
                "                0 msfcyzbh," +
                "                0 ysfcyzbh," +
                "                0 czfcyzbh," +
                "                0 scmjbh," +
                "                0 ynmjbh," +
                "                0 msmjbh," +
                "                0 nynsebh," +
                "                t1.fc_fcyz fcyz," +
                "                t1.fc_nynse as fcnynse," +
                "                t1.fc_nzj nzj," +
                "                t1.fc_fcyz_ms as msfcyz," +
                "                t1.fc_fcyz_ys as ysfcyz," +
                "                (t1.fc_fcyz-t1.fc_fcyz_ms-t1.fc_fcyz_ys)czfcyz," +
                "                t1.djh," +
                "                t1.nsrsbh," +
                "                t1.jbb_nsrmc nsrmc," +
                "                t1.jbb_zgkg_mc zgkg_mc," +
                "                t1.jbb_zgkg_dm zgkg_dm," +
                "                t1.td_scmj scmj," +
                "                t1.td_ynmj ynmj," +
                "                t1.td_msmj msmj," +
                "                t1.td_nynse nynse," +
                "                t1.td_sgzt_dm sgzt_dm," +
                "                t1.sy_id," +
                "                0 sqscmj," +
                "                0 sqnynse," +
                "                0 sqfcyz," +
                "                0 sqnzj," +
                "                0 sqfcnynse," +
                "                t1.syhis_id bqsyhisId," +
                "                '' sqsyhisId," +
                "                'add' as lx   " +
                " from (select * from" +
                "     (select RANK() OVER(PARTITION BY t.sy_id ORDER BY t.xgrq DESC) AS PM,t.* from sw_dj_sy_his t where t.sy_id in (" +
                "     select t.sy_id from sw_dj_sy_his t where t.sy_id in (" +
                "       select" +
                "               " +
                "                t.sy_id                " +
                "            from" +
                "                sw_dj_td t                  " +
                "            " +
                "                where  to_char(t.update_date,'yyyymmdd')>='"+df.format(swDjSyQuery.getSqUpdateDateEnd())+"'  " +
                "                and t.lrrq is null ) and to_char(t.update_date,'yyyymmdd')>='"+df.format(swDjSyQuery.getSqUpdateDateBegin())+"' and to_char(t.update_date,'yyyymmdd')<='"+df.format(swDjSyQuery.getSqUpdateDateEnd())+"' group by t.sy_id having count(*)>2) ) where pm=1)t1" +
                "                left join" +
                "                (select * from" +
                "     (select RANK() OVER(PARTITION BY t.sy_id ORDER BY t.xgrq DESC) AS PM,t.* from sw_dj_sy_his t where t.sy_id in (" +
                "     select t.sy_id from sw_dj_sy_his t where t.sy_id in (" +
                "       select" +
                "               " +
                "                t.sy_id                " +
                "            from" +
                "                sw_dj_td t                  " +
                "            " +
                "                where  to_char(t.update_date,'yyyymmdd')>='"+df.format(swDjSyQuery.getSqUpdateDateEnd())+"'  " +
                "                and t.lrrq is null ) and to_char(t.update_date,'yyyymmdd')>='"+df.format(swDjSyQuery.getSqUpdateDateBegin())+"' and to_char(t.update_date,'yyyymmdd')<='"+df.format(swDjSyQuery.getSqUpdateDateEnd())+"' group by t.sy_id having count(*)>2) ) where pm=2)t2 on t1.sy_id=t2.sy_id where t1.td_sgzt_dm<>t2.td_sgzt_dm     " +
                "            " +
                "                           " +
                "        )t ）where 1=1 ";
        if(StringUtils.isNotBlank(swDjSyQuery.getDs())){
            sql+=" and zgkg_dm like '2"+swDjSyQuery.getDs()+"%'";
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getQx())){
            sql+=" and zgkg_dm like '2"+swDjSyQuery.getQx()+"%'";
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getZgkgDm())){
            sql+=" and zgkg_dm='"+swDjSyQuery.getZgkgDm()+"'";
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getSgztDm())){
            sql+=" and sgzt_dm='"+swDjSyQuery.getSgztDm()+"'";
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getSgztDm())){
            sql+=" and sgzt_dm='"+swDjSyQuery.getSgztDm()+"'";
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getBhlx())){
            sql+=" and lx='"+swDjSyQuery.getBhlx()+"'";
        }
        return sql;
    }
    @Override
    @Transactional(readOnly = true)
    public SwDjSyHis getSwDjSyHis(String syhisId) {


        return baseRepository.get(SwDjSyHis.class,syhisId);

    }
    @Override
    @Transactional(readOnly = true)
    public SwDjSyQuery getSwDjSy(String syId) {
        QSwDjSy qSwDjSy = QSwDjSy.swDjSy;
        QSwDjTd qSwDjTd = QSwDjTd.swDjTd;
        QSwDjFc qSwDjFc = QSwDjFc.swDjFc;
        QSwDjGdzys qSwDjGdzys = QSwDjGdzys.swDjGdzys;
        QSwDjQs qSwDjQs = QSwDjQs.swDjQs;
        QSwDjPcxx qSwDjPcxx = QSwDjPcxx.swDjPcxx;
        QSwDjXmxx qSwDjXmxx = QSwDjXmxx.swDjXmxx;


        QSwHcXmRwRel qSwHcXmRwRel = QSwHcXmRwRel.swHcXmRwRel;
        QZd qZd = QZd.zd;
        QSwDjJbb qSwDjJbb = QSwDjJbb.swDjJbb;

        JPQLQuery query = new JPAQuery(baseRepository.getEntityManager());
        SwDjSyQuery swDjSyQuery = new SwDjSyQuery();

        QBean qBean = Projections.bean(SwDjSyQuery.class,qSwDjSy.syId,qSwDjTd.tdId,qSwDjFc.fcId,qSwDjSy.zd.djh,qSwDjSy.dbh,qSwDjJbb.glbm,qSwDjJbb.nsrsbh,qSwDjJbb.nsrmc,qSwDjTd.czrmc,qSwDjTd.czrzjhm,qSwDjTd.tdzl,
                qZd.tdyt,qZd.qlrmc,qZd.scmjZd,qSwDjJbb.zgkgDm,qSwDjJbb.zgkgMc,qSwDjJbb.sgyMc,qSwDjJbb.fddbr,qSwDjJbb.lxdh,qSwDjJbb.zclxDm,qSwDjJbb.hyDm,qSwDjJbb.zcdz,qSwDjJbb.nsrsbh,
                qSwDjTd.tdsyzh,qSwDjTd.tdsyztDm,qSwDjTd.tdqdfsDm,qSwDjTd.tdsyytDm,qSwDjTd.dj,qSwDjTd.qdsyqzfje,qSwDjTd.tdkfcb,qSwDjTd.csqdsj,qSwDjTd.syqzzsj,qSwDjTd.tdjmxzdm,qSwDjTd.fzmj,qSwDjTd.scmj,qSwDjTd.tddj,qSwDjTd.msmj,qSwDjTd.ynmj,qSwDjTd.dwse,qSwDjTd.nynseTd,qSwDjTd.msse,
                qSwDjFc.fczh,qSwDjFc.fcmj,qSwDjFc.fwxzDm,qSwDjFc.zyhczDm,qSwDjFc.fwjz,qSwDjFc.tdjz,qSwDjFc.fssbjz,qSwDjFc.fcyz,
                qSwDjFc.czfcyz,qSwDjFc.jsbl,qSwDjFc.fcjmxzdm,qSwDjFc.fcyzYs,qSwDjFc.fcyzMs,qSwDjFc.ynseZy,qSwDjFc.ynseCz,qSwDjFc.nzj,qSwDjFc.nynseFc,qSwDjFc.fczl,qSwDjFc.qzczfcmj,qZd.tdzh,qSwDjTd.sgztDm,qSwDjSy.bz,qSwDjTd.tdsyqlx,qSwHcXmRwRel.shxrId,qSwDjTd.tdMssjBegin,qSwDjTd.tdMssjEnd,qSwDjTd.tdMsyy,qSwDjFc.fcMssjBegin,qSwDjFc.fcMssjEnd,qSwDjFc.fcMsyy,qSwDjFc.sl,qSwDjSy.ishc,qSwDjTd.gtzdbyzyy,
                qSwDjFc.fczlXian,qSwDjFc.fczlZhen,qSwDjFc.fczlLu,qSwDjFc.fczlHao,qSwDjFc.fczlDong,qSwDjFc.fczlDy,qSwDjFc.fczlLou,qSwDjFc.fczlShi,
                qSwDjGdzys.gdzysId,qSwDjGdzys.gdzysSzly,qSwDjGdzys.gdzysYnse,qSwDjGdzys.gdzysDwse,qSwDjGdzys.gdzysJmxz,qSwDjGdzys.gdzysJmse,qSwDjGdzys.gdzysJspz,qSwDjGdzys.gdzysYjne,qSwDjGdzys.gdzysXbjse,qSwDjGdzys.gdzysBz,qSwDjGdzys.gdzysLrrq,
                qSwDjQs.qsId,qSwDjQs.qsSzly,qSwDjQs.qsYnse,qSwDjQs.qsJmxz,qSwDjQs.qsJmse,qSwDjQs.qsJspz,qSwDjQs.qsXbjse,qSwDjQs.qsBz,qSwDjQs.qsLrrq,qSwDjQs.qsYjne);
        query.from(qSwDjSy).leftJoin(qSwDjSy.swDjTd, qSwDjTd).leftJoin(qSwDjSy.swDjFc,qSwDjFc).leftJoin(qSwDjSy.swDjGdzys,qSwDjGdzys).leftJoin(qSwDjSy.swDjQs,qSwDjQs).leftJoin(qSwDjTd.swDjJbb,qSwDjJbb).leftJoin(qSwDjSy.zd, qZd).leftJoin(qSwDjSy.swHcXmRwRel,qSwHcXmRwRel).where(qSwDjSy.syId.eq(syId));
        swDjSyQuery = (SwDjSyQuery)baseRepository.get(query,qBean);



        return swDjSyQuery;

    }
    @Override
    @Transactional(value="oracle_common",readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public List getUserSign(String proid) {

        String sql = "select * from pf_usersign t where t.user_id =(select t1.user_id from pf_assignment t1 left join pf_activity t2 on t1.activity_id =t2.activity_id left join pf_workflow_instance t3 on t2.workflow_instance_id=t3.workflow_instance_id where t2.activity_state='1' and  t3.workflow_instance_id='"+proid+"' ) and  t.pro_id='"+proid+"' ";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        return list;
    }
    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public Page<SwDjSyQuery> findSwdjTdWbdMap(SwDjSyQuery swDjSyQuery,Pageable pageable) {

        QSwDjTd qSwDjTd = QSwDjTd.swDjTd;
        QSwDjTdWbd qSwDjTdWbd=QSwDjTdWbd.swDjTdWbd;
        QSwDjJbbWbd qSwDjJbbWbd = QSwDjJbbWbd.swDjJbbWbd;
        QZd qZd = QZd.zd;

        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        QBean qBean = Projections.bean(SwDjSyQuery.class,qSwDjTdWbd.tdId,qSwDjTdWbd.zd.djh,qSwDjJbbWbd.nsrmc,
                qSwDjTdWbd.tddj,qZd.tdzl,qSwDjTdWbd.scmj,qSwDjTdWbd.msmj,qSwDjTdWbd.ynmj,qSwDjTdWbd.dwse,qSwDjTdWbd.sgztDm,qSwDjTdWbd.sgztMc,qSwDjTdWbd.sjly,qSwDjTdWbd.nynseTd,qSwDjTdWbd.msse,qSwDjTdWbd.typebyzyy,qSwDjTdWbd.confirmhc,qSwDjTdWbd.gtzdbyzyy, qSwDjJbbWbd.nsrsbh,qSwDjJbbWbd.glbm,qSwDjJbbWbd.zgkgMc,qSwDjJbbWbd.sgyMc,qSwDjTdWbd.zdsybz,qZd.qlrmc,qZd.tdyt,qZd.tdytmc,qZd.scmjZd
                );
        jpaQuery.from(qSwDjTdWbd).leftJoin(qSwDjTdWbd.swDjJbbWbd, qSwDjJbbWbd).leftJoin(qSwDjTdWbd.zd, qZd);
        if(StringUtils.isNotBlank(swDjSyQuery.getDjh()))
            jpaQuery.where(qSwDjTdWbd.zd.djh.like(QueryCondition.WILDCARDS + swDjSyQuery.getDjh() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(swDjSyQuery.getSyjf()))
            jpaQuery.where(qSwDjTdWbd.zd.djh.like(QueryCondition.WILDCARDS + swDjSyQuery.getSyjf() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(swDjSyQuery.getSyjd()))
            jpaQuery.where(qSwDjTdWbd.zd.djh.like(QueryCondition.WILDCARDS + swDjSyQuery.getSyjd() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(swDjSyQuery.getSyqx()))
            jpaQuery.where(qSwDjTdWbd.zd.djh.like(QueryCondition.WILDCARDS + swDjSyQuery.getSyqx() + QueryCondition.WILDCARDS));


        jpaQuery.where(qSwDjTdWbd.tdId.isNotNull());
        if(swDjSyQuery!=null){
            if(swDjSyQuery.getIsMsTz()!=null && swDjSyQuery.getIsMsTz()){
                jpaQuery.where(qSwDjTdWbd.msmj.isNotNull().and(qSwDjTd.msmj.gt(new BigDecimal(0))));
                jpaQuery.orderBy(qSwDjTdWbd.msmj.desc().nullsLast());
            }else{
                jpaQuery.orderBy(qSwDjTdWbd.nynseTd.desc().nullsLast());
            }
            //是否确认核查无问题
            if(StringUtils.isNotBlank(swDjSyQuery.getConfirmhc())){
                jpaQuery.where(qSwDjTdWbd.confirmhc.eq(swDjSyQuery.getConfirmhc()));
            }
            //数据不一致原因
            if(StringUtils.isNotBlank(swDjSyQuery.getTypebyzyy())){
                jpaQuery.where(qSwDjTdWbd.typebyzyy.eq(swDjSyQuery.getTypebyzyy()));
            }

        }
        if("1".equals(swDjSyQuery.getMsbz())){
            jpaQuery.where(qSwDjTdWbd.msbz.eq("1"));
        }else if("2".equals(swDjSyQuery.getMsbz())){
            jpaQuery.where(qSwDjTdWbd.msbz.isNull().or(qSwDjTd.msbz.eq("")));
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getTddj())){
            //String tddj = CommonUtil.reSetTddj(swDjSyQuery.getTddj());
            jpaQuery.where(qSwDjTdWbd.tddj.eq(swDjSyQuery.getTddj()));
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getSgztDm())){
            jpaQuery.where(qSwDjTdWbd.sgztDm.eq(swDjSyQuery.getSgztDm()));
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getSjly())){
            jpaQuery.where(qSwDjTdWbd.sjly.eq(swDjSyQuery.getSjly()));
        }

        if(StringUtils.isNotBlank(swDjSyQuery.getZdsybz())){

            jpaQuery.where(Expressions.stringPath(qSwDjTdWbd,"zdsybz").eq(swDjSyQuery.getZdsybz()));
        }

        if(StringUtils.isNotBlank(swDjSyQuery.getDwdm())){
            jpaQuery.where(qSwDjJbbWbd.zgkgDm.like("2" + swDjSyQuery.getDwdm() + QueryCondition.WILDCARDS));
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getGjzt()) && "2".equals(swDjSyQuery.getGjzt())){
            //jpaQuery.where(qZd.djh.notIn(new JPASubQuery().from(qSwDjXmxx).where(qSwDjXmxx.zd.djh.isNotNull()).list(qSwDjXmxx.zd.djh)));
            jpaQuery.where(qZd.djh.isNotNull());
        }
        applySwDjSyQueryPredicates1(swDjSyQuery, qZd, qSwDjTdWbd, qSwDjJbbWbd, jpaQuery);
        //jpaQuery.where(qSwDjSy.sysjly.eq(Gtlx.ZD.toString()));

        return baseRepository.find(jpaQuery,qBean,pageable);
    }
    private void applySwDjSyQueryPredicates1(SwDjSyQuery swDjSyQuery,QZd qZd,QSwDjTdWbd qSwDjTdWbd,QSwDjJbbWbd qSwDjJbbWbd,JPQLQuery jpaQuery){
        if(StringUtils.isNotBlank(swDjSyQuery.getGlbm()))
            jpaQuery.where(Expressions.stringPath(qSwDjJbbWbd,"glbm").like(QueryCondition.WILDCARDS + swDjSyQuery.getGlbm() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(swDjSyQuery.getNsrsbh()))
            jpaQuery.where(Expressions.stringPath(qSwDjJbbWbd,"nsrsbh").like(QueryCondition.WILDCARDS + swDjSyQuery.getNsrsbh() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(swDjSyQuery.getNsrmc()))
            jpaQuery.where(Expressions.stringPath(qSwDjJbbWbd,"nsrmc").like(QueryCondition.WILDCARDS + swDjSyQuery.getNsrmc() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(swDjSyQuery.getTdzh()))
            jpaQuery.where(Expressions.stringPath(qZd, "tdzh").like(QueryCondition.WILDCARDS + swDjSyQuery.getTdzh() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(swDjSyQuery.getQlrmc()))
            jpaQuery.where(Expressions.stringPath(qZd,"qlrmc").like(QueryCondition.WILDCARDS + swDjSyQuery.getQlrmc() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(swDjSyQuery.getTdzl()))
            jpaQuery.where(Expressions.stringPath(qZd,"tdzl").like(QueryCondition.WILDCARDS + swDjSyQuery.getTdzl() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(swDjSyQuery.getTdyt()))
            jpaQuery.where(Expressions.stringPath(qSwDjTdWbd, "tdsyytDm").eq(swDjSyQuery.getTdyt()));
        if(StringUtils.isNotBlank(swDjSyQuery.getJf()))
            jpaQuery.where(Expressions.stringPath(qZd, "djh").like(swDjSyQuery.getJf() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(swDjSyQuery.getJd()))
            jpaQuery.where(Expressions.stringPath(qZd, "djh").like(swDjSyQuery.getJd() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(swDjSyQuery.getQx()))
            jpaQuery.where(Expressions.stringPath(qZd, "sgqdm").like(swDjSyQuery.getQx() + QueryCondition.WILDCARDS).or(qZd.sgqdm.isNull()));
        if(StringUtils.isNotBlank(swDjSyQuery.getZclxDm()))
            jpaQuery.where(Expressions.stringPath(qSwDjJbbWbd,"zclxDm").eq(swDjSyQuery.getZclxDm()));
        //行业类型添加模糊查询，小类
        if(StringUtils.isNotBlank(swDjSyQuery.getHyDm()))
            jpaQuery.where(Expressions.stringPath(qSwDjJbbWbd,"hyDm").like(swDjSyQuery.getHyDm() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(swDjSyQuery.getSgyMc()))
            jpaQuery.where(Expressions.stringPath(qSwDjJbbWbd,"sgyMc").like(QueryCondition.WILDCARDS + swDjSyQuery.getSgyMc() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(swDjSyQuery.getZgkgDm()))
            jpaQuery.where(Expressions.stringPath(qSwDjJbbWbd,"zgkgDm").eq(swDjSyQuery.getZgkgDm()));
        if(StringUtils.isNotBlank(swDjSyQuery.getTag())){
            if("gjsl".equals(swDjSyQuery.getTag())){
                jpaQuery.where(qZd.djh.isNotNull());
                jpaQuery.where(qZd.djh.notLike(QueryCondition.WILDCARDS + "999999" + QueryCondition.WILDCARDS).and(qSwDjTdWbd.sjly.eq("1")));
            }else if("xlgjsl".equals(swDjSyQuery.getTag())){
                jpaQuery.where(qSwDjTdWbd.zd.djh.like(QueryCondition.WILDCARDS + "999999" + QueryCondition.WILDCARDS));
            }
        }

        //过滤工矿区
        if(StringUtils.isNotEmpty(swDjSyQuery.getIsGkq())){
            String tdjb_gkq_sql = "SELECT DM FROM S_ZD_TDJB WHERE MC LIKE '%工矿区%'";
            Query query = baseRepository.getEntityManager().createNativeQuery(tdjb_gkq_sql);
            List tdjb_gkq = query.getResultList();

            if("1".equals(swDjSyQuery.getIsGkq())){
                jpaQuery.where(qSwDjTdWbd.tddj.in(tdjb_gkq));
            }else if("0".equals(swDjSyQuery.getIsGkq())){
                jpaQuery.where(qSwDjTdWbd.tddj.notIn(tdjb_gkq).or(qSwDjTdWbd.tddj.isNull()));
            }
        }
        //税额统计过滤税额(大于等于最小单位税额，小于等于最大单位税额)
        if(StringUtils.isNotEmpty(swDjSyQuery.getMinDwse())){
            jpaQuery.where(qSwDjTdWbd.dwse.goe(new BigDecimal(swDjSyQuery.getMinDwse())));
        }
        if(StringUtils.isNotEmpty(swDjSyQuery.getMaxDwse())){
            jpaQuery.where(qSwDjTdWbd.dwse.loe(new BigDecimal(swDjSyQuery.getMaxDwse())));
        }

        if(StringUtils.isNotBlank(swDjSyQuery.getExcelBegin()) && StringUtils.isNotBlank(swDjSyQuery.getExcelEnd())){
            Integer offset = Integer.parseInt(swDjSyQuery.getExcelBegin())-1;
            Integer limit = Integer.parseInt(swDjSyQuery.getExcelEnd())-offset;
            jpaQuery.offset(offset).limit(limit);
        }

    }
    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public Page findZdList(ZdQuery zdQuery, Pageable pageable) {

        String sql = "select * from zd where djh in(SELECT t5.djh" +
                "                              FROM SW_DJ_TD t1" +
                "                              LEFT JOIN SW_DJ_SY t2 ON t1.sy_id = t2.sy_id" +
                "                              LEFT JOIN SW_DJ_JBB t3 ON t1.JBB_ID=t3.JBB_ID" +
                "                              right JOIN ZD t5 ON T2.DJH=T5.DJH" +
                "                              LEFT JOIN S_DM_DWXX_CZ t4 ON T5.XZQDM LIKE (T4.DWDM||'%')" +
                "                              WHERE  t4.dwjb=2 and t4.zgswj_dm like '2"+zdQuery.getDwdm()+"%' and t5.djh not like'%99999%'";
        if(StringUtils.isNotBlank(zdQuery.getTag())){
            if("zdsl".equals(zdQuery.getTag())){
                sql=sql+")";
            }else if("zdgjsl".equals(zdQuery.getTag())){
                sql=sql+" and t1.td_id is not  null)";
            }else if("zdwgjsl".equals(zdQuery.getTag())){
                sql=sql+" and t1.td_id is null)";
            }
        }
        sql = addParameter(zdQuery,sql);



        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        String countSql = "select count(*) from ("+sql+")";
        Query countQuery = baseRepository.getEntityManager().createNativeQuery(countSql);
        Page page =  baseRepository.find(query, countQuery, pageable);
        return page;
    }
    private String addParameter(ZdQuery zdQuery,String sql){
        if(StringUtils.isNotBlank(zdQuery.getDjh())){
            sql = sql + " and djh like '"+zdQuery.getDjh().trim()+"%'";
        }
        if(StringUtils.isNotBlank(zdQuery.getQlrmc())){
            sql = sql + " and qlrmc like '%"+zdQuery.getQlrmc()+"%'";
        }
        if(StringUtils.isNotBlank(zdQuery.getTdzlzd())){
            sql = sql + " and tdzl like '%"+zdQuery.getTdzlzd()+"%'";
        }
        if(StringUtils.isNotBlank(zdQuery.getTdyt())){
            sql = sql + " and tdyt = '"+zdQuery.getTdyt()+"'";
        }
        if(StringUtils.isNotBlank(zdQuery.getIsqlrmc())){
            if(zdQuery.getIsqlrmc().equals("0")){
                sql = sql + " and ltrim(qlrmc) is not null ";
            }else {
                sql = sql + " and ltrim(qlrmc) is null ";
            }
        }
        
        return sql;
    }
    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public List<Object> getZdList(HashMap param) {
        Object obj = param.get("ids");
        ZdQuery zdQuery = (ZdQuery) param.get("zdQuery");
        String sql = "select djh,qlrmc,tdzl,tdytmc,scmj from zd where djh in(SELECT t5.djh" +
                "                              FROM SW_DJ_TD t1" +
                "                              LEFT JOIN SW_DJ_SY t2 ON t1.sy_id = t2.sy_id" +
                "                              LEFT JOIN SW_DJ_JBB t3 ON t1.JBB_ID=t3.JBB_ID" +
                "                              right JOIN ZD t5 ON T2.DJH=T5.DJH" +
                "                              LEFT JOIN S_DM_DWXX_CZ t4 ON T5.XZQDM LIKE (T4.DWDM||'%')" +
                "                              WHERE  t4.dwjb=2 and t4.zgswj_dm like '2"+zdQuery.getDwdm()+"%' and t5.djh not like'%99999%'";
        if(StringUtils.isNotBlank(zdQuery.getTag())){
            if("zdsl".equals(zdQuery.getTag())){
                sql=sql+")";
            }else if("zdgjsl".equals(zdQuery.getTag())){
                sql=sql+" and t1.td_id is not  null)";
            }else if("zdwgjsl".equals(zdQuery.getTag())){
                sql=sql+" and t1.td_id is null)";
            }
        }
        sql = addParameter(zdQuery,sql);

        if(obj==null) {//导出全部
            sql = addParameter(zdQuery,sql);
        }else{//checkbox导出
            String resultIds = "";
            String ids = String.valueOf(obj);
            String[] idsArr = ids.split(",");
            for(int i=0;i<idsArr.length;i++){
                if(i==idsArr.length-1){
                    resultIds = resultIds+"'"+idsArr[i]+"'";
                }else{
                    resultIds = resultIds+"'"+idsArr[i]+"'"+",";
                }
            }
            sql = sql + " and djh in("+resultIds+")";
        }
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        List<Object> list =  query.getResultList();
        return list;
    }
    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public List<SwDjSyQuery> getTdSyTzList(HashMap param) {
        Object idsObj = param.get("ids");
        String sylx = String.valueOf(param.get("sylx"));
        SwDjSyQuery swDjSyQuery = (SwDjSyQuery) param.get("swDjSyQuery");
        QSwDjTd qSwDjTd = QSwDjTd.swDjTd;
        QSwDjTdWbd qSwDjTdWbd=QSwDjTdWbd.swDjTdWbd;
        QSwDjJbbWbd qSwDjJbbWbd = QSwDjJbbWbd.swDjJbbWbd;
        QZd qZd = QZd.zd;

        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        QBean qBean = Projections.bean(SwDjSyQuery.class,qSwDjTdWbd.tdId,qSwDjTdWbd.zd.djh,qSwDjJbbWbd.nsrmc,
                qSwDjTdWbd.tddj,qZd.tdzl,qSwDjTdWbd.scmj,qSwDjTdWbd.msmj,qSwDjTdWbd.ynmj,qSwDjTdWbd.dwse,qSwDjTdWbd.sgztDm,qSwDjTdWbd.sgztMc,qSwDjTdWbd.sjly,qSwDjTdWbd.nynseTd,qSwDjTdWbd.msse,qSwDjTdWbd.typebyzyy,qSwDjTdWbd.confirmhc,qSwDjTdWbd.gtzdbyzyy, qSwDjJbbWbd.nsrsbh,qSwDjJbbWbd.glbm,qSwDjJbbWbd.zgkgMc,qSwDjJbbWbd.sgyMc,qSwDjTdWbd.zdsybz,qZd.qlrmc,qZd.tdyt,qZd.tdytmc,qZd.scmjZd
        );
        jpaQuery.from(qSwDjTdWbd).leftJoin(qSwDjTdWbd.swDjJbbWbd, qSwDjJbbWbd).leftJoin(qSwDjTdWbd.zd, qZd);

        if(idsObj!=null){
            String ids = String.valueOf(idsObj);
            List idsList = Arrays.asList(ids.split(","));
            jpaQuery.where(qSwDjTdWbd.tdId.in(idsList));
        }else{
            if(StringUtils.isNotBlank(swDjSyQuery.getDjh()))
                jpaQuery.where(qSwDjTdWbd.zd.djh.like(QueryCondition.WILDCARDS + swDjSyQuery.getDjh() + QueryCondition.WILDCARDS));
            if(StringUtils.isNotBlank(swDjSyQuery.getSyjf()))
                jpaQuery.where(qSwDjTdWbd.zd.djh.like(QueryCondition.WILDCARDS + swDjSyQuery.getSyjf() + QueryCondition.WILDCARDS));
            if(StringUtils.isNotBlank(swDjSyQuery.getSyjd()))
                jpaQuery.where(qSwDjTdWbd.zd.djh.like(QueryCondition.WILDCARDS + swDjSyQuery.getSyjd() + QueryCondition.WILDCARDS));
            if(StringUtils.isNotBlank(swDjSyQuery.getSyqx()))
                jpaQuery.where(qSwDjTdWbd.zd.djh.like(QueryCondition.WILDCARDS + swDjSyQuery.getSyqx() + QueryCondition.WILDCARDS));


            jpaQuery.where(qSwDjTdWbd.tdId.isNotNull());
            if(swDjSyQuery!=null){
                if(swDjSyQuery.getIsMsTz()!=null && swDjSyQuery.getIsMsTz()){
                    jpaQuery.where(qSwDjTdWbd.msmj.isNotNull().and(qSwDjTd.msmj.gt(new BigDecimal(0))));
                    jpaQuery.orderBy(qSwDjTdWbd.msmj.desc().nullsLast());
                }else{
                    jpaQuery.orderBy(qSwDjTdWbd.nynseTd.desc().nullsLast());
                }
                //是否确认核查无问题
                if(StringUtils.isNotBlank(swDjSyQuery.getConfirmhc())){
                    jpaQuery.where(qSwDjTdWbd.confirmhc.eq(swDjSyQuery.getConfirmhc()));
                }
                //数据不一致原因
                if(StringUtils.isNotBlank(swDjSyQuery.getTypebyzyy())){
                    jpaQuery.where(qSwDjTdWbd.typebyzyy.eq(swDjSyQuery.getTypebyzyy()));
                }

            }
            if("1".equals(swDjSyQuery.getMsbz())){
                jpaQuery.where(qSwDjTdWbd.msbz.eq("1"));
            }else if("2".equals(swDjSyQuery.getMsbz())){
                jpaQuery.where(qSwDjTdWbd.msbz.isNull().or(qSwDjTd.msbz.eq("")));
            }
            if(StringUtils.isNotBlank(swDjSyQuery.getTddj())){
                //String tddj = CommonUtil.reSetTddj(swDjSyQuery.getTddj());
                jpaQuery.where(qSwDjTdWbd.tddj.eq(swDjSyQuery.getTddj()));
            }
            if(StringUtils.isNotBlank(swDjSyQuery.getSgztDm())){
                jpaQuery.where(qSwDjTdWbd.sgztDm.eq(swDjSyQuery.getSgztDm()));
            }
            if(StringUtils.isNotBlank(swDjSyQuery.getSjly())){
                jpaQuery.where(qSwDjTdWbd.sjly.eq(swDjSyQuery.getSjly()));
            }

            if(StringUtils.isNotBlank(swDjSyQuery.getZdsybz())){

                jpaQuery.where(Expressions.stringPath(qSwDjTdWbd,"zdsybz").eq(swDjSyQuery.getZdsybz()));
            }

            if(StringUtils.isNotBlank(swDjSyQuery.getDwdm())){
                jpaQuery.where(qSwDjJbbWbd.zgkgDm.like("2" + swDjSyQuery.getDwdm() + QueryCondition.WILDCARDS));
            }
            if(StringUtils.isNotBlank(swDjSyQuery.getGjzt()) && "2".equals(swDjSyQuery.getGjzt())){
                //jpaQuery.where(qZd.djh.notIn(new JPASubQuery().from(qSwDjXmxx).where(qSwDjXmxx.zd.djh.isNotNull()).list(qSwDjXmxx.zd.djh)));
                jpaQuery.where(qZd.djh.isNotNull());
            }
            applySwDjSyQueryPredicates1(swDjSyQuery, qZd, qSwDjTdWbd, qSwDjJbbWbd, jpaQuery);
        }

        baseRepository.addEntityPath(qSwDjTdWbd);
        return (List)baseRepository.dslList(jpaQuery,qBean);
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public Page<SwDjSyQuery> findDhcxSy(SwDjSyQuery swDjSyQuery,Pageable pageable){
        String nsrsbh = swDjSyQuery.getNsrsbh()!=null?swDjSyQuery.getNsrsbh():"";
        String nsrmc = swDjSyQuery.getNsrmc()!=null?swDjSyQuery.getNsrmc():"";
        String sql = "SELECT  '1'AS FLAG,t3.nsrsbh,t3.nsrmc,t1.SYBH,t1.tdzl,t1.tdsyzh,t1.tddj,t1.dwse,t1.ynmj,t1.msmj,t1.nynse,t3.zgkg_mc,'宗地'AS ZDTYPE,t2.djh " +
                "FROM SW_DJ_TD t1 LEFT JOIN SW_DJ_SY t2 ON t1.SY_ID = t2.SY_ID LEFT JOIN SW_DJ_JBB t3 ON t1.JBB_ID = t3.JBB_ID " +
                "WHERE t3.nsrsbh like '%"+ nsrsbh +"%' AND t3.nsrmc like '%"+nsrmc +"%' ORDER BY t1.nynse desc" ;
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        String countSql = "select count(*) from (";
        countSql += sql;
        countSql +=")";
        Query countQuery = baseRepository.getEntityManager().createNativeQuery(countSql);
        Page page =  baseRepository.find(query, countQuery, pageable);
        return page;
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public Page<SwDjSyQuery> findDhcxZd(SwDjSyQuery swDjSyQuery,Pageable pageable){
        String nsrsbh = swDjSyQuery.getNsrsbh()!=null?swDjSyQuery.getNsrsbh():"";
        String nsrmc = swDjSyQuery.getNsrmc()!=null?swDjSyQuery.getNsrmc() :"";
        String sql ="SELECT  distinct '1'AS FLAG,t1.djh,t1.QLRMC,t1.TDZL,t1.TDZH,t1.TDYTMC,t1.SCMJ,t1.FZMJ,t3.dwmc " +
                "FROM ZD t1 " +
                "LEFT JOIN SW_DJ_SY t2 ON t1.djh = t2.djh " +
                "LEFT JOIN S_DM_DWXX_CZ t3 ON SUBSTR(t2.DJH, 0, 6)  = t3.dwdm " +
                "LEFT JOIN SW_DJ_TD t4 ON t2.SY_ID = t4.SY_ID  " +
                "LEFT JOIN SW_DJ_JBB t5 ON t4.JBB_ID = t5.JBB_ID " +
                "WHERE t5.nsrsbh like '%"+nsrsbh +"%' AND t5.nsrmc like '%"+nsrmc +"%'";

        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        String countSql = "select count(*) from (";
        countSql += sql;
        countSql +=")";
        Query countQuery = baseRepository.getEntityManager().createNativeQuery(countSql);
        Page page =  baseRepository.find(query, countQuery, pageable);
        return page;
    }
    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public Page<SwDjSyQuery> findSwdjTdFcMap(SwDjSyQuery swDjSyQuery,Pageable pageable) {
        QSwDjGdzys qSwDjGdzys = QSwDjGdzys.swDjGdzys;
        QSwDjQs qSwDjQs = QSwDjQs.swDjQs;
        QSwDjSy qSwDjSy = QSwDjSy.swDjSy;
        QSwDjTd qSwDjTd = QSwDjTd.swDjTd;
        QSwDjFc qSwDjFc = QSwDjFc.swDjFc;
        QSwDjJbb qSwDjJbb = QSwDjJbb.swDjJbb;
        QSwDjXmxx qSwDjXmxx = QSwDjXmxx.swDjXmxx;
        QZd qZd = QZd.zd;

        String regionCode = "";
        try{
            regionCode = SessionUtil.getCurrentUser().getRegionCode();
        }catch (Exception e){}


        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        QBean qBean = Projections.bean(SwDjSyQuery.class,qSwDjSy.syId,qSwDjSy.dbh,qSwDjTd.tdId,qSwDjSy.zd.djh,qSwDjJbb.nsrmc,
                qSwDjFc.fczl,qSwDjFc.fcyz,qSwDjFc.fcyzYs,qSwDjFc.fcyzMs,qSwDjFc.ynseZy,qSwDjFc.nzj,qSwDjFc.sl,qSwDjFc.ynseCz,qSwDjFc.nynseFc,qSwDjFc.fwxzDm,qSwDjTd.tddj,qZd.tdzl,qSwDjTd.scmj,qSwDjTd.msmj,qSwDjTd.ynmj,qSwDjTd.dwse,qSwDjTd.sgztDm,qSwDjTd.sgztMc,qSwDjTd.sjly,qSwDjTd.nynseTd,qSwDjTd.msse,qSwDjTd.typebyzyy,qSwDjTd.confirmhc,qSwDjTd.gtzdbyzyy, qSwDjJbb.nsrsbh,qSwDjJbb.glbm,qSwDjJbb.zgkgMc,qSwDjJbb.sgyMc,qSwDjFc.fcId,qSwDjTd.zdsybz,qSwDjTd.tdsyytDm,qZd.qlrmc,qZd.tdyt,qZd.scmjZd,
                qSwDjGdzys.gdzysId,qSwDjGdzys.gdzysYnse,qSwDjGdzys.gdzysDwse,qSwDjGdzys.gdzysJmxz,qSwDjGdzys.gdzysJmse,qSwDjGdzys.gdzysJspz,qSwDjGdzys.gdzysYjne,qSwDjGdzys.gdzysXbjse,qSwDjGdzys.gdzysBz,qSwDjGdzys.gdzysLrrq,qSwDjGdzys.gdzysHclx,
                qSwDjQs.qsId,qSwDjQs.qsSzly,qSwDjQs.qsYnse,qSwDjQs.qsYjne,qSwDjQs.qsJmxz,qSwDjQs.qsJmse,qSwDjQs.qsJspz,qSwDjQs.qsXbjse,qSwDjQs.qsBz,qSwDjQs.qsLrrq,qSwDjQs.qsHclx,qSwDjXmxx.xmId);
        jpaQuery.from(qSwDjTd).leftJoin(qSwDjTd.swDjSy,qSwDjSy).leftJoin(qSwDjTd.swDjJbb,qSwDjJbb).leftJoin(qSwDjSy.swDjFc, qSwDjFc)
                .leftJoin(qSwDjSy.zd, qZd).leftJoin(qSwDjSy.swDjGdzys,qSwDjGdzys).leftJoin(qSwDjSy.swDjQs, qSwDjQs)
                .leftJoin(qSwDjSy.swDjXmxx, qSwDjXmxx);
        if(StringUtils.isNotBlank(swDjSyQuery.getDjh()))
            jpaQuery.where(qSwDjSy.zd.djh.like(QueryCondition.WILDCARDS + swDjSyQuery.getDjh() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(swDjSyQuery.getSyjf()))
            jpaQuery.where(qSwDjSy.zd.djh.like(QueryCondition.WILDCARDS + swDjSyQuery.getSyjf() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(swDjSyQuery.getSyjd()))
            jpaQuery.where(qSwDjSy.zd.djh.like(QueryCondition.WILDCARDS + swDjSyQuery.getSyjd() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(swDjSyQuery.getSyqx()))
            jpaQuery.where(qSwDjSy.zd.djh.like(QueryCondition.WILDCARDS + swDjSyQuery.getSyqx() + QueryCondition.WILDCARDS));
        //if(StringUtils.isNotBlank(swDjSyQuery.getXzqdm()))
        //    jpaQuery.where(qSwDjSy.zd.djh.like(swDjSyQuery.getXzqdm() + QueryCondition.WILDCARDS));
        if(StringUtils.isBlank(swDjSyQuery.getSyzt())){
            jpaQuery.where(qSwDjSy.syzt.eq(Syzt.ZC.toString()).or(qSwDjSy.syzt.isNull()).or(qSwDjSy.syzt.eq("")));
        }else{
            jpaQuery.where(qSwDjSy.syzt.eq(swDjSyQuery.getSyzt()).or(qSwDjSy.syzt.eq("")).or(qSwDjSy.syzt.isNull()));
        }
        jpaQuery.where(qSwDjTd.tdId.isNotNull());
        if(swDjSyQuery!=null){
            if(swDjSyQuery.getIsMsTz()!=null && swDjSyQuery.getIsMsTz()){
                jpaQuery.where(qSwDjTd.msmj.isNotNull().and(qSwDjTd.msmj.gt(new BigDecimal(0))));
                jpaQuery.orderBy(qSwDjTd.msmj.desc().nullsLast());
            }else{
                jpaQuery.orderBy(qSwDjTd.nynseTd.desc().nullsLast());
            }
            //是否确认核查无问题
            if(StringUtils.isNotBlank(swDjSyQuery.getConfirmhc())){
                jpaQuery.where(qSwDjTd.confirmhc.eq(swDjSyQuery.getConfirmhc()));
            }
            //数据不一致原因
            if(StringUtils.isNotBlank(swDjSyQuery.getTypebyzyy())){
                jpaQuery.where(qSwDjTd.typebyzyy.eq(swDjSyQuery.getTypebyzyy()));
            }
            //免税性质
            if(StringUtils.isNotBlank(swDjSyQuery.getTdjmxzdm())){
                jpaQuery.where(qSwDjTd.tdjmxzdm.eq(swDjSyQuery.getTdjmxzdm()));
            }
        }
        if("1".equals(swDjSyQuery.getMsbz())){
            jpaQuery.where(qSwDjTd.msbz.eq("1"));
        }else if("2".equals(swDjSyQuery.getMsbz())){
            jpaQuery.where(qSwDjTd.msbz.isNull().or(qSwDjTd.msbz.eq("")));
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getTddj())){
            //String tddj = CommonUtil.reSetTddj(swDjSyQuery.getTddj());
            jpaQuery.where(qSwDjTd.tddj.eq(swDjSyQuery.getTddj()));
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getSgztDm())){
            jpaQuery.where(qSwDjTd.sgztDm.eq(swDjSyQuery.getSgztDm()));
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getSjly())){
            jpaQuery.where(qSwDjTd.sjly.eq(swDjSyQuery.getSjly()));
        }

        if(StringUtils.isNotBlank(swDjSyQuery.getZdsybz())){

            jpaQuery.where(Expressions.stringPath(qSwDjTd,"zdsybz").eq(swDjSyQuery.getZdsybz()));
        }

        if(StringUtils.isNotBlank(regionCode)){
            if (regionCode.length() > 6)
                regionCode = regionCode.substring(0, 6);
            jpaQuery.where(qSwDjJbb.zgkgDm.like("2" + regionCode + QueryCondition.WILDCARDS));
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getGjzt()) && "2".equals(swDjSyQuery.getGjzt())){
            //jpaQuery.where(qZd.djh.notIn(new JPASubQuery().from(qSwDjXmxx).where(qSwDjXmxx.zd.djh.isNotNull()).list(qSwDjXmxx.zd.djh)));
            jpaQuery.where(qZd.djh.isNotNull());
        }
        applySwDjSyQueryPredicates(swDjSyQuery,qSwDjSy,qSwDjJbb, qSwDjTd,qSwDjFc,qZd,qSwDjXmxx,jpaQuery);
        //jpaQuery.where(qSwDjSy.sysjly.eq(Gtlx.ZD.toString()));

        return baseRepository.find(jpaQuery,qBean,pageable);
    }
    @Transactional(value="oracle_common",readOnly = true)
    @Override
    public Page<SwDjJbbQuery> findSh(SwDjJbbQuery swDjJbbQuery, Pageable pageable) {
        String nsrsbh = swDjJbbQuery.getNsrsbh()!=null?swDjJbbQuery.getNsrsbh():"";
        String nsrmc = swDjJbbQuery.getNsrmc()!=null?swDjJbbQuery.getNsrmc() :"";
        String zcdz=swDjJbbQuery.getZcdz()!=null?swDjJbbQuery.getZcdz() :"";
        String zgkgDm=swDjJbbQuery.getZgkgDm()!=null?swDjJbbQuery.getZgkgDm() :"";
        String sql ="select * from sw_dj_jbb t where t.jbb_id in (select jbb_id from sw_dj_td)";
      //  sql +=" and (t.nsrsbh like '%"+nsrsbh+"%' or t.nsrmc like '%"+nsrmc+"%'"+") and t.nsrmc like '%"+nsrmc+"%'"+" and t.zcdz like '%"+zcdz+"%'"+" and t.zgkg_dm like '%"+zgkgDm+"%'";
        if(StringUtils.isNotBlank(swDjJbbQuery.getNsrsbh()) ){
            sql+=" and (t.nsrsbh like '%"+nsrsbh+"%' or t.nsrmc like '%"+nsrsbh+"%'"+")";
        }
        if(StringUtils.isNotBlank(swDjJbbQuery.getNsrmc()) ){
            sql+=" and t.nsrmc like '%"+nsrmc+"%'";        }
        if(StringUtils.isNotBlank(swDjJbbQuery.getZcdz()) ){
            sql+=" and t.zcdz like '%"+zcdz+"%'";
        }
        if(StringUtils.isNotBlank(swDjJbbQuery.getZgkgDm()) ){
            sql+=" and t.zgkg_dm like '%"+zgkgDm+"%'";
        }
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        String countSql = "select count(*) from (";
        countSql += sql;
        countSql +=")";
        Query countQuery = baseRepository.getEntityManager().createNativeQuery(countSql);
        Page page =  baseRepository.find(query, countQuery, pageable);
        return page;


    }
    /**
     * 标记重点税源
     * 1：是重点税源
     */
    @Override
    @Transactional(value="oracle_common")
    public void setZdsyByNsrsbh(String nsrsbh) {


                String sql ="select t1.* from sw_dj_td t1 left join sw_dj_jbb t2 on t1.jbb_id=t2.jbb_id where t2.nsrsbh='"+nsrsbh+"'";
                Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
                query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
                List<HashMap<String,Object>> list = query.getResultList();
                if(CollectionUtils.isNotEmpty(list)){
                    for(HashMap<String,Object> tempTdId : list){
                        SwDjTd swDjTd = baseRepository.get(SwDjTd.class,String.valueOf(tempTdId.get("TD_ID")));
                        swDjTd.setZdsybz("1");
                        baseRepository.update(swDjTd);
                    }
                }
    }

    @Override
    @Transactional(value="oracle_common")
    public List getDjhsByNsrsbh(String nsrsbh){
        String sql ="select t3.djh from sw_dj_td t1 left join sw_dj_jbb t2 on t1.jbb_id=t2.jbb_id left join sw_dj_sy t3 on t1.sy_id=t3.sy_id where t2.nsrsbh='"+nsrsbh+"'";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        List<HashMap<String,Object>> list = query.getResultList();
        return list;
    }
}
