package cn.gtmap.landtax.service.impl;

import cn.gtmap.landtax.entity.*;
import cn.gtmap.landtax.entity.SSjGtbd;
import cn.gtmap.landtax.entity.SwDjSy;
import cn.gtmap.landtax.entity.SwDjSyHis;
import cn.gtmap.landtax.model.dictionary.Czlx;
import cn.gtmap.landtax.model.dictionary.Syzt;
import cn.gtmap.landtax.service.*;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.PlatUtil;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.web.SessionUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import javax.persistence.Query;
import javax.swing.*;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

import java.util.List;

import java.util.Calendar;
import cn.gtmap.landtax.model.dictionary.Hcxmlx;

/**
 * Created by xuchao on 2014/8/22.
 */
@Service
public class SyscServiceImpl implements SyscService{
    private static final String SYSC_PREFIX="税源删除";
    private static final String SYBJ_PREFIX_QS="契税删除";
    private static final String SYBJ_PREFIX_GDZYS="耕地占用税删除";
    private static final String SYSC_WORKFLOW_CONFIG="sysc";
    private static final String SYSC_WORKFLOW_CONFIG_QS="qssc";
    private static final String SYSC_WORKFLOW_CONFIG_GDZYS="gdzyssc";
    @Autowired
    PlatUtil platUtil;
    @Autowired
    TaxService taxService;
    @Autowired
    BaseRepository baseRepository;
    @Autowired
    SwdjSyHisService swdjSyHisService;
    @Autowired
    SsjGtbdService ssjGtbdService;
    @Autowired
    SyxgService syxgService;
    @Autowired
    BphcService bphcService;


    @Override
    @Transactional(value="oracle_common")
    public String createSyscWorkflow(String syId) {
        SwDjSy swDjSy = taxService.getSwDjSyById(syId);
        String wdid = AppConfig.getProperty(SYSC_WORKFLOW_CONFIG);
        BigDecimal str =null;
        String msg = "1";
        //流程的定义ID
        Set set = swDjSy.getSwDjSyHisSet();
        Iterator i = set.iterator();//先迭代出来
        while(i.hasNext()){//遍历
            SwDjSyHis swDjSyHis = (SwDjSyHis)i.next();
            String rwid =swDjSyHis.getRwid();
            String sqlSyxg = "select workflow_state from PF_WORKFLOW_INSTANCE  where workflow_instance_id ='"+rwid+"'and WORKFLOW_DEFINITION_ID='"+wdid+"'";
            Query query = baseRepository.getEntityManager().createNativeQuery(sqlSyxg);
            query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
            List<HashMap<String, Object>> listSyxg = null;
            listSyxg = query.getResultList();
            if(listSyxg.isEmpty()){
                continue;
            }
            else{
                HashMap<String ,Object> hashMap =(HashMap)listSyxg.get(0);
                str= (BigDecimal)hashMap.get("WORKFLOW_STATE");
                String str1 =str.toString();
                if("2".equals(str1)){
                    continue;
                }else{
                    msg ="2";
                    break;
                }
            }
        }
        Project project = new Project();
        String proId = UUIDGenerator.generate();
        project.setProjectId(proId);
        project.setWdid(wdid);
        String userId = SessionUtil.getCurrentUserId();
        String proName = SYSC_PREFIX+swDjSy.getSwDjTd().getSwDjJbb().getNsrmc();
        //保存工作流
        String taskId = "";
//        try {
//            taskId = platUtil.createWorkFlowInstance(project, userId, proName);
//        } catch (Exception e) {
//            if (((RuntimeException)e).getMessage().equals("该用户不允许创建该流程")) {
//                String result = "java.lang:" + ((RuntimeException) e).getMessage();
//                return result;
//            } else {
//                throw new RuntimeException();
//            }
//        }
       // if(StringUtils.isNotBlank(taskId)){
         //   swdjSyHisService.saveSwDjHis(swDjSy,proId,userId, Czlx.DELETE.toString());
     //   }
      //  return taskId;
        if(("1").equals(msg)){
            try {
                taskId = platUtil.createWorkFlowInstance(project, userId, proName);
            } catch (Exception e) {
                if (((RuntimeException)e).getMessage().equals("该用户不允许创建该流程")) {
                    String result = "java.lang:" + ((RuntimeException) e).getMessage();
                    return result;
                } else {
                    throw new RuntimeException();
                }
            }
        }
        if(StringUtils.isNotBlank(taskId)&&("1").equals(msg)){
            swdjSyHisService.saveSwDjHis(swDjSy,proId,userId, Czlx.DELETE.toString());
        }
        if( msg.equals("2")){
            return "aaaaaa";
        }else{
            return taskId;}
    }

    @Override
    @Transactional(value="oracle_common")
    public void delSwdjSyByHisId(String proid) {
        //根据proid 获取syId
        List<SwDjSyHis> list = syxgService.getSwDjSyHisListByRwid(proid);
        SwDjSyHis swDjSyHis = list.get(0);
        String syId = swDjSyHis.getSwDjSy().getSyId();
        //将税源主表税源状态设置为 删除标记
        taxService.softDelSyDjSy(syId, Syzt.SC.toString());

        //看该宗地是否还有税源,如果没有税源了，修改s_sj_gtbd 表中ppzt和blzt
        String jpql = "from SwDjSy t where t.zd.djh=?0 and t.syzt='1'";
        List<SwDjSy> swDjSyList = baseRepository.getByJpql(jpql,swDjSyHis.getDjh());
        if(CollectionUtils.isEmpty(swDjSyList)){//说明没有税源，此时设置s_sj_gtbd表中ppzt为空，办理状态为空
            SSjGtbd sSjGtbd = ssjGtbdService.findByDjh(swDjSyHis.getDjh());
            sSjGtbd.setPpzt("");
            ssjGtbdService.updateSsjGtbd(sSjGtbd);
        }
    }

    @Override
    @Transactional(value="oracle_common")
    public String createQsSyscWorkflow(String syId) {
        SwDjSy swDjSy = taxService.getSwDjSyById(syId);
        String wdid = AppConfig.getProperty(SYSC_WORKFLOW_CONFIG_QS);
        Project project = new Project();
        String proId = UUIDGenerator.generate();
        project.setProjectId(proId);
        project.setWdid(wdid);
        String userId = SessionUtil.getCurrentUserId();
        String proName = SYBJ_PREFIX_QS + swDjSy.getSwDjXmxx().getXmmc();

        String taskId = "";
        try {
            taskId = platUtil.createWorkFlowInstance(project, userId, proName);
            if(StringUtils.isNotBlank(taskId)){
                swdjSyHisService.saveSwDjHis(swDjSy,proId,userId, Czlx.DELETE.toString());
            }
        } catch (Exception e) {
            if (((RuntimeException)e).getMessage().equals("该用户不允许创建该流程")) {
                String result = "java.lang:" + ((RuntimeException) e).getMessage();
                return result;
            } else {
                throw new RuntimeException();
            }
        }

        return taskId;
    }

    @Override
    @Transactional(value="oracle_common")
    public String createGdzysSyscWorkflow(String syId,String pcId) {
        SwDjSy swDjSy = taxService.getSwDjSyById(syId);
        String wdid = AppConfig.getProperty(SYSC_WORKFLOW_CONFIG_GDZYS);
        Project project = new Project();
        String proId = UUIDGenerator.generate();
        project.setProjectId(proId);
        project.setWdid(wdid);
        String userId = SessionUtil.getCurrentUserId();
        String proName = SYBJ_PREFIX_GDZYS + swDjSy.getSwDjPcxx().getPcmc();

        String taskId = "";
        try {
            taskId = platUtil.createWorkFlowInstance(project, userId, proName);
            if(StringUtils.isNotBlank(taskId)){
                swdjSyHisService.saveSwDjHis(swDjSy,proId,userId, Czlx.DELETE.toString());
            }
        } catch (Exception e) {
            if (((RuntimeException)e).getMessage().equals("该用户不允许创建该流程")) {
                String result = "java.lang:" + ((RuntimeException) e).getMessage();
                return result;
            } else {
                throw new RuntimeException();
            }
        }

        //查询pcxx
        SwDjPcxx swDjPcxx=new SwDjPcxx();
        if(StringUtils.isNotBlank(pcId)){
            String[] pcIdArray = pcId.split(",");
            List<SwDjPcxx> swDjPcxxList = bphcService.getBpxmListByIds(pcIdArray);
            if (swDjPcxxList.size() > 0)
                swDjPcxx = swDjPcxxList.get(0);
        }
        //存储项目 sw_hc_xm
        SwHcXm swHcXm = new SwHcXm();
        swHcXm.setMc(SYBJ_PREFIX_GDZYS+ swDjPcxx.getPcmc());
        swHcXm.setXmId(UUIDGenerator.generate());
        swHcXm.setCjrq(Calendar.getInstance().getTime());
        swHcXm.setCjrId(SessionUtil.getCurrentUserId());
        swHcXm.setXmlx(Hcxmlx.GDZYSSC.toString());
        swHcXm.setXmybj("0");
        baseRepository.save(swHcXm);
        //存储sw_hc_xm_rw_rel
        SwHcXmRwRel swHcXmRwRel = new SwHcXmRwRel();
        swHcXmRwRel.setShxrId(UUIDGenerator.generate());
        swHcXmRwRel.setRwId(proId);
        swHcXmRwRel.setSwHcXm(swHcXm);
        swHcXmRwRel.setBdId(pcId);
        swHcXmRwRel.setBlzt("0");
        baseRepository.save(swHcXmRwRel);

        return taskId;
    }

    @Override
    @Transactional(value="oracle_common")
    public void delSwdjSyByHisIdGqs(String proid) {
        //根据proid 获取syId
        List<SwDjSyHis> list = syxgService.getSwDjSyHisListByRwid(proid);
        SwDjSyHis swDjSyHis = list.get(0);
        String syId = swDjSyHis.getSwDjSy().getSyId();
        //将税源主表税源状态设置为 删除标记
        taxService.softDelSyDjSy(syId, Syzt.SC.toString());
    }
}
