package cn.gtmap.landtax.service.impl;

import cn.gtmap.landtax.entity.SwDjSyTemp;
import cn.gtmap.landtax.service.DicService;
import cn.gtmap.landtax.service.SwdjSyTempService;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import com.gtis.common.util.UUIDGenerator;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * Created by Administrator on 2014/8/26.
 */
@Service
public class SwdjSyTempServiceImpl implements SwdjSyTempService{

    @Autowired
    BaseRepository baseRepository;
    @Autowired
    DicService dicService;

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public SwDjSyTemp getSwDjSyTempByProid(String proid) {
        return  baseRepository.get(SwDjSyTemp.class, proid);
    }

    @Override
    @Transactional(value="oracle_common")
    public void saveSwDjSyTemp(SwDjSyTemp swDjSyTemp) {
        String rwid = swDjSyTemp.getProid();
        List<SwDjSyTemp> list = getSwDjSyTempListByRwid(rwid);

        if(CollectionUtils.isEmpty(list)){
            swDjSyTemp.setRwid(rwid);
            swDjSyTemp.setProid(UUIDGenerator.generate());
            baseRepository.save(swDjSyTemp);
        }else{
            swDjSyTemp.setProid(list.get(0).getProid());
            swDjSyTemp.setRwid(list.get(0).getRwid());
            baseRepository.update(swDjSyTemp);
        }
    }

    @Override
    public SwDjSyTemp getswDjSyTempBySyIdAndRwid(String syId, String rwid) {
        String jpql = "from SwDjSyTemp o where o.syId=?0 and o.rwid=?1";
        return (SwDjSyTemp) baseRepository.getUniqueResultByJpql(jpql,syId,rwid);
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public List<SwDjSyTemp> getSwDjSyTempListByRwid(String rwid) {
        String jpql = "from SwDjSyTemp o where o.rwid=?0";
        return baseRepository.getByJpql(jpql,rwid);
    }

    @Override
    @Transactional(value="oracle_common")
    public void updateSwDjSyTemp(SwDjSyTemp swDjSyTemp) {
        String zgkgDm = swDjSyTemp.getZgkgDm();
        String zgkgMc = dicService.findZgkgMcByZgkgDm(zgkgDm);
        swDjSyTemp.setZgkgMc(zgkgMc);
        String fczl = swDjSyTemp.getFczl();
        swDjSyTemp.setTdzl(fczl);

        baseRepository.update(swDjSyTemp);
    }
}
