package cn.gtmap.landtax.service.impl;

import cn.gtmap.landtax.entity.*;
import cn.gtmap.landtax.model.dictionary.Czlx;
import cn.gtmap.landtax.model.dictionary.Sgzt;
import cn.gtmap.landtax.service.SwdjSyHisService;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.web.SessionUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.Calendar;
import java.util.List;

/**
 * Created with IntelliJ IDEA.
 * User: Administrator
 * Date: 14-8-23
 * Time: 下午3:38
 * To change this template use File | Settings | File Templates.
 */
@Service
public class SwdjSyHisServiceImpl implements SwdjSyHisService{
    @Autowired
    BaseRepository baseRepository;

    @Override
    @Transactional(value="oracle_common")
    public void saveSwDjHis(SwDjSy swDjSy,String proId,String userId,String czlx) {
        SwDjSyHis swDjSyHis = setSwDjSyHisBySwDjSy(swDjSy,proId, userId, czlx);
        baseRepository.save(swDjSyHis);
    }
    @Override
    @Transactional(value="oracle_common")
    public SwDjSyHis setSwDjSyHisBySwDjSy(SwDjSy swDjSy,String proId,String userId,String czlx){
        SwDjSyHis swDjSyHis = new SwDjSyHis();
        swDjSyHis.setSjly(swDjSy.getSysjly());
        swDjSyHis.setSyhisId(UUIDGenerator.generate());
        swDjSyHis.setRwid(proId);
        if (swDjSy.getZd()!=null) {
            swDjSyHis.setDjh(swDjSy.getZd().getDjh());
        }
        if (swDjSy.getSwDjXmxx()!=null) {
            swDjSyHis.setGdId(swDjSy.getSwDjXmxx().getXmId());
        }
        if (swDjSy.getSwDjGdzys()!=null) {
            swDjSyHis.setBpId(swDjSy.getSwDjGdzys().getGdzysId());
        }
        swDjSyHis.setDbh(swDjSy.getDbh());
        swDjSyHis.setUserid(userId);
        swDjSyHis.setXgrq(Calendar.getInstance().getTime());
        swDjSyHis.setCzlx(czlx);
        swDjSyHis.setXgr(SessionUtil.getCurrentUser().getUsername());
        swDjSyHis.setSwDjSy(swDjSy);
        if(swDjSy.getSwDjTd()!=null){
            SwDjTd swDjTd = swDjSy.getSwDjTd();
            swDjSyHis.setTdTdzl(swDjTd.getTdzl());
            swDjSyHis.setTdZdmj(swDjTd.getZdmj());
            swDjSyHis.setTdYnmj(swDjTd.getYnmj());
            swDjSyHis.setTdDwse(swDjTd.getDwse());
            swDjSyHis.setTdNynse(swDjTd.getNynseTd());
            swDjSyHis.setTdTddj(swDjTd.getTddj());
            swDjSyHis.setTdTdsyzh(swDjTd.getTdsyzh());
            swDjSyHis.setTdBz(swDjTd.getBz());
            swDjSyHis.setTdCzrmc(swDjTd.getCzrmc());
            swDjSyHis.setTdCzrzjhm(swDjTd.getCzrzjhm());
            swDjSyHis.setTdLrrq(swDjTd.getLrrq());
            swDjSyHis.setTdMsmj(swDjTd.getMsmj());
            swDjSyHis.setTdMsse(swDjTd.getMsse());
            swDjSyHis.setTdDwseMs(swDjTd.getDwseMs());
            swDjSyHis.setTdFzmj(swDjTd.getFzmj());
            swDjSyHis.setTdScmj(swDjTd.getScmj());
            swDjSyHis.setTdTdsyztDm(swDjTd.getTdsyztDm());
            swDjSyHis.setTdTdsyztMc(swDjTd.getTdsyztMc());
            swDjSyHis.setGtzdbyzyy(swDjTd.getGtzdbyzyy());
            swDjSyHis.setTdSgztDm(swDjTd.getSgztDm());
            swDjSyHis.setTdSgztMc(Sgzt.getMcByDm(swDjTd.getSgztDm()));
            swDjSyHis.setTdSjly(swDjTd.getSjly());
            swDjSyHis.setTdZdsybz(swDjTd.getZdsybz());
            swDjSyHis.setTdMsbz(swDjTd.getMsbz());
        }

        if(swDjSy.getSwDjFc()!=null){
            SwDjFc swDjFc = swDjSy.getSwDjFc();
            swDjSyHis.setFcFcyz(swDjFc.getFcyz());
            swDjSyHis.setFcSl(swDjFc.getSl());
            swDjSyHis.setFcNzj(swDjFc.getNzj());
            swDjSyHis.setFcZjSl(swDjFc.getZjSl());
            swDjSyHis.setFcYnse(swDjFc.getYnse());
            swDjSyHis.setFcFcyzMs(swDjFc.getFcyzMs());
            swDjSyHis.setFcNynse(swDjFc.getNynseFc());
            swDjSyHis.setFcFczh(swDjFc.getFczh());
            swDjSyHis.setFcCzrmc(swDjFc.getCzrmcFc());
            swDjSyHis.setFcLrrq(swDjFc.getLrrq());
            swDjSyHis.setFcCzrzjhm(swDjFc.getCzrzjhmFc());
            swDjSyHis.setFcFcyzYs(swDjFc.getFcyzYs());
            swDjSyHis.setFcFczl(swDjFc.getFczl());
            swDjSyHis.setFcBz(swDjFc.getBz());
            swDjSyHis.setFcFwjz(swDjFc.getFwjz());
            swDjSyHis.setFcTdjz(swDjFc.getTdjz());
            swDjSyHis.setFcFssbjz(swDjFc.getFssbjz());
            swDjSyHis.setFcFcmj(swDjFc.getFcmj());
            swDjSyHis.setFcYnseZy(swDjFc.getYnseZy());
            swDjSyHis.setFcYnseCz(swDjFc.getYnseCz());
            swDjSyHis.setFcFwxzDm(swDjFc.getFwxzDm());
            swDjSyHis.setFcFwxzMc(swDjFc.getFwxzMc());
            swDjSyHis.setFcZyhczDm(swDjFc.getZyhczDm());
            swDjSyHis.setFcZyhczMc(swDjFc.getZyhczMc());
            swDjSyHis.setFcSgztDm(swDjFc.getSgztDm());
            swDjSyHis.setFcSgztMc(Sgzt.getMcByDm(swDjFc.getSgztDm()));
            swDjSyHis.setFcSjly(swDjFc.getSjly());
            swDjSyHis.setFcZdsybz(swDjFc.getZdsybz());
            swDjSyHis.setFcMsbz(swDjFc.getMsbz());
        }

        if(swDjSy.getSwDjGdzys()!=null){
            SwDjGdzys swDjGdzys = swDjSy.getSwDjGdzys();
            swDjSyHis.setGdzysId(swDjGdzys.getGdzysId());
            swDjSyHis.setGdzysSzly(swDjGdzys.getGdzysSzly());
            swDjSyHis.setGdzysYnse(swDjGdzys.getGdzysYnse());
            swDjSyHis.setGdzysDwse(swDjGdzys.getGdzysDwse());
            swDjSyHis.setGdzysJmxz(swDjGdzys.getGdzysJmxz());
            swDjSyHis.setGdzysJspz(swDjGdzys.getGdzysJspz());
            swDjSyHis.setGdzysJmse(swDjGdzys.getGdzysJmse());
            swDjSyHis.setGdzysYjne(swDjGdzys.getGdzysYjne());
            swDjSyHis.setGdzysXbjse(swDjGdzys.getGdzysXbjse());
            swDjSyHis.setGdzysBz(swDjGdzys.getGdzysBz());
            swDjSyHis.setGdzysLrrq(swDjGdzys.getGdzysLrrq());
            swDjSyHis.setGdzysHclx(swDjGdzys.getGdzysHclx());
        }

        if(swDjSy.getSwDjQs()!=null){
            SwDjQs swDjQs = swDjSy.getSwDjQs();
            swDjSyHis.setQsId(swDjQs.getQsId());
            swDjSyHis.setQsSzly(swDjQs.getQsSzly());
            swDjSyHis.setQsYnse(swDjQs.getQsYnse());
            swDjSyHis.setQsYjne(swDjQs.getQsYjne());
            swDjSyHis.setQsJmxz(swDjQs.getQsJmxz());
            swDjSyHis.setQsJmse(swDjQs.getQsJmse());
            swDjSyHis.setQsJspz(swDjQs.getQsJspz());
            swDjSyHis.setQsXbjse(swDjQs.getQsXbjse());
            swDjSyHis.setQsBz(swDjQs.getQsBz());
            swDjSyHis.setQsLrrq(swDjQs.getQsLrrq());
            swDjSyHis.setQsHclx(swDjQs.getQsHclx());

        }

        SwDjJbb swDjJbb = null;
        if(swDjSy.getSwDjTd()!=null){
            SwDjTd swDjTd = swDjSy.getSwDjTd();
            swDjJbb = swDjTd.getSwDjJbb();
        }else if(swDjSy.getSwDjFc()!=null){
            SwDjFc swDjFc = swDjSy.getSwDjFc();
            swDjJbb = swDjFc.getSwDjJbb();
        }else if (swDjSy.getSwDjGdzys()!=null) {
            SwDjGdzys swDjGdzys = swDjSy.getSwDjGdzys();
            swDjJbb = swDjGdzys.getSwDjJbb();
        }else if (swDjSy.getSwDjQs()!=null) {
            SwDjQs swDjQs = swDjSy.getSwDjQs();
            swDjJbb = swDjQs.getSwDjJbb();
        }

        if (swDjJbb != null) {
            swDjSyHis.setGlbm(swDjJbb.getNsrsbh());
            swDjSyHis.setJbbNsrmc(swDjJbb.getNsrmc());
            swDjSyHis.setJbbZgkgDm(swDjJbb.getZgkgDm());
            swDjSyHis.setJbbSgyDm(swDjJbb.getSgyDm());
            swDjSyHis.setJbbFddbr(swDjJbb.getFddbr());
            swDjSyHis.setJbbLxdh(swDjJbb.getLxdh());
            swDjSyHis.setJbbZclxDm(swDjJbb.getZclxDm());
            swDjSyHis.setJbbHyDm(swDjJbb.getHyDm());
            swDjSyHis.setJbbZcdz(swDjJbb.getZcdz());
        }

        return swDjSyHis;
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public List<SwDjSyHis> getSwDjSyHisByRwid(String rwid) {
        String jpql = "from SwDjSyHis o where o.rwid=?0";
        return baseRepository.getByJpql(jpql,rwid);
    }
    @Override
    @Transactional
    public void saveSwDjHis(SwDjSyHis swDjSyHis) {
        baseRepository.save(swDjSyHis);
    }
}
