package cn.gtmap.landtax.service.impl;

import cn.gtmap.landtax.entity.*;
import cn.gtmap.landtax.model.dictionary.Gqszly;
import cn.gtmap.landtax.model.dictionary.Gtlx;
import cn.gtmap.landtax.model.dictionary.Sjly;
import cn.gtmap.landtax.model.dictionary.Syzt;
import cn.gtmap.landtax.model.query.SwDjQsQuery;
import cn.gtmap.landtax.model.query.SwDjSyQuery;
import cn.gtmap.landtax.service.*;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.CommonUtil;
import cn.gtmap.landtax.util.QueryCondition;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.mysema.query.jpa.JPASubQuery;
import com.mysema.query.jpa.JPQLQuery;
import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.support.Expressions;
import com.mysema.query.types.Projections;
import com.mysema.query.types.QBean;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import com.gtis.web.SessionUtil;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

/**
 */
@Service
public class SwDjQsServiceImpl implements SwDjQsService {
    @Autowired
    BaseRepository baseRepository;
    @Autowired
    TaxService taxService;
    @Autowired
    SwdjSyHisService swdjSyHisService;
    @Autowired
    HcxmService hcxmService;
    @Autowired
    DwxxService dwxxService;
    @Autowired
    DicService dicService;


    @Override
    @Transactional(value="oracle_common",readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public Page<QSwDjXmxx> findXmtz(SwDjQsQuery swDjQsQuery, Pageable pageable) {
        QSwDjXmxx qSwDjXmxx = QSwDjXmxx.swDjXmxx;
        QBean qBean = Projections.bean(SwDjQsQuery.class, qSwDjXmxx);
        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        jpaQuery.from(qSwDjXmxx);
        if(StringUtils.isNotBlank(swDjQsQuery.getGjzt()) && "2".equals(swDjQsQuery.getGjzt())){
            jpaQuery.where(qSwDjXmxx.zd.djh.isNull());
        }
        applySwDjQsQueryPredicates(swDjQsQuery, jpaQuery,qSwDjXmxx);
        return baseRepository.find(jpaQuery,qSwDjXmxx,pageable);
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public Page<SwDjQsQuery> findQstz(SwDjQsQuery swDjQsQuery, Pageable pageable) {
        QSwDjXmxx qSwDjXmxx = QSwDjXmxx.swDjXmxx;
        QSwDjSy qSwDjSy = QSwDjSy.swDjSy;
        QSwDjQs qSwDjQs = QSwDjQs.swDjQs;
        QSwDjJbb qSwDjJbb = QSwDjJbb.swDjJbb;

        QBean qBean = Projections.bean(SwDjQsQuery.class, qSwDjSy.syId, qSwDjXmxx.xmId,qSwDjXmxx.xmmc,qSwDjXmxx.gdmj,qSwDjXmxx.qdfs,qSwDjXmxx.xmTdyt,qSwDjXmxx.xmTdzl,qSwDjXmxx.xmYddw,qSwDjXmxx.xmXzqdm,qSwDjXmxx.qdjg,qSwDjXmxx.gdsj,
                qSwDjQs.qsId,qSwDjQs.qsSzly,qSwDjQs.qsYnse,qSwDjQs.qsYjne,qSwDjQs.qsJmxz,qSwDjQs.qsJmse,qSwDjQs.qsJspz,qSwDjQs.qsXbjse,qSwDjQs.qsBz,qSwDjQs.qsLrrq,qSwDjQs.qsHclx,
                qSwDjJbb.glbm,qSwDjJbb.nsrsbh, qSwDjJbb.nsrmc, qSwDjJbb.zgkgDm, qSwDjJbb.zgkgMc);

        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        jpaQuery.from(qSwDjQs).leftJoin(qSwDjQs.swDjSy, qSwDjSy).leftJoin(qSwDjSy.swDjXmxx, qSwDjXmxx).leftJoin(qSwDjQs.swDjJbb, qSwDjJbb);
        jpaQuery.where(qSwDjXmxx.xmId.isNotNull());
        jpaQuery.where(qSwDjSy.sysjly.eq(Gtlx.GD.toString()).or(qSwDjSy.sysjly.isNull()));
        jpaQuery.where(qSwDjSy.syzt.eq(Syzt.ZC.toString()).or(qSwDjSy.syzt.isNull()).or(qSwDjSy.syzt.eq("")));

        String regionCode = "";
        try{
            regionCode = SessionUtil.getCurrentUser().getRegionCode();
        }catch (Exception e){}
        if(StringUtils.isNotBlank(regionCode)){
            /*if (regionCode.length() > 6)
                regionCode = regionCode.substring(0, 6);*/
            jpaQuery.where(qSwDjJbb.zgkgDm.like("2" + regionCode + QueryCondition.WILDCARDS));
        }

        applySwDjQsQueryPredicates(swDjQsQuery, qSwDjJbb, jpaQuery, qSwDjXmxx);

        if(StringUtils.isNotBlank(swDjQsQuery.getZdsybz())){
            jpaQuery.where(Expressions.stringPath(qSwDjQs,"zdsybz").eq(swDjQsQuery.getZdsybz()));
        }

        return baseRepository.find(jpaQuery,qBean,pageable);
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public SwDjSyQuery getQsBySyId(String syId) {
        QSwDjXmxx qSwDjXmxx = QSwDjXmxx.swDjXmxx;
        QSwDjQs qSwDjQs = QSwDjQs.swDjQs;
        QSwDjSy qSwDjSy = QSwDjSy.swDjSy;
        QSwDjJbb qSwDjJbb = QSwDjJbb.swDjJbb;
        QSwDjTd qSwDjTd = QSwDjTd.swDjTd;
        QSwDjFc qSwDjFc = QSwDjFc.swDjFc;
        QSwHcXmRwRel qSwHcXmRwRel = QSwHcXmRwRel.swHcXmRwRel;

        QBean qBean = Projections.bean(SwDjSyQuery.class, qSwDjXmxx.xmId,qSwDjXmxx.xmmc,qSwDjXmxx.gdmj,qSwDjXmxx.qdfs,qSwDjXmxx.xmTdyt,qSwDjXmxx.xmYddw,qSwDjXmxx.xmXzqdm,qSwDjXmxx.qdjg,qSwDjXmxx.gdsj,qSwDjXmxx.xmTdzl,
                qSwDjQs.qsId,qSwDjQs.qsSzly,qSwDjQs.qsYnse,qSwDjQs.qsYjne,qSwDjQs.qsJmxz,qSwDjQs.qsJmse,qSwDjQs.qsJspz,qSwDjQs.qsXbjse,qSwDjQs.qsBz,qSwDjQs.qsLrrq,qSwDjQs.qsHclx,
                qSwDjJbb.jbbId,qSwDjJbb.glbm,qSwDjJbb.nsrsbh,qSwDjJbb.nsrmc,qSwDjJbb.zgkgMc,qSwDjJbb.zgkgDm,qSwDjJbb.sgyMc,qSwDjJbb.fddbr,qSwDjJbb.zclxDm,qSwDjJbb.zclxMc,qSwDjJbb.hyDm,qSwDjJbb.hyMc,qSwDjJbb.lxdh,qSwDjJbb.zcdz,
                qSwDjSy.syId,qSwDjTd.tdId,qSwDjFc.fcId,qSwDjSy.zd.djh,qSwDjSy.dbh,qSwDjTd.czrmc,qSwDjTd.czrzjhm,qSwDjTd.tdzl,
                qSwDjTd.tdsyzh,qSwDjTd.tdsyztDm,qSwDjTd.tdqdfsDm,qSwDjTd.tdsyytDm,qSwDjTd.dj,qSwDjTd.qdsyqzfje,qSwDjTd.tdkfcb,qSwDjTd.csqdsj,qSwDjTd.syqzzsj,qSwDjTd.tdjmxzdm,qSwDjTd.fzmj,qSwDjTd.scmj,qSwDjTd.tddj,qSwDjTd.msmj,qSwDjTd.ynmj,qSwDjTd.dwse,qSwDjTd.nynseTd,qSwDjTd.msse,
                qSwDjFc.fczh,qSwDjFc.fcmj,qSwDjFc.fwxzDm,qSwDjFc.zyhczDm,qSwDjFc.fwjz,qSwDjFc.tdjz,qSwDjFc.fssbjz,qSwDjFc.fcyz,
                qSwDjFc.czfcyz,qSwDjFc.jsbl,qSwDjFc.fcjmxzdm,qSwDjFc.fcyzYs,qSwDjFc.fcyzMs,qSwDjFc.ynseZy,qSwDjFc.ynseCz,qSwDjFc.nzj,qSwDjFc.nynseFc,qSwDjFc.fczl,qSwDjTd.sgztDm,qSwDjSy.bz,qSwDjTd.tdsyqlx,qSwDjTd.tdMssjBegin,qSwDjTd.tdMssjEnd,qSwDjTd.tdMsyy,qSwDjFc.fcMssjBegin,qSwDjFc.fcMssjEnd,qSwDjFc.fcMsyy,qSwDjFc.sl,qSwDjSy.ishc,qSwDjTd.gtzdbyzyy,
                qSwDjFc.fczlXian,qSwDjFc.fczlZhen,qSwDjFc.fczlLu,qSwDjFc.fczlHao,qSwDjFc.fczlDong,qSwDjFc.fczlDy,qSwDjFc.fczlLou,qSwDjFc.fczlShi,
                qSwHcXmRwRel.shxrId);
        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        jpaQuery.from(qSwDjSy).leftJoin(qSwDjSy.swDjQs, qSwDjQs).leftJoin(qSwDjQs.swDjJbb, qSwDjJbb).leftJoin(qSwDjSy.swDjTd, qSwDjTd).leftJoin(qSwDjSy.swDjFc, qSwDjFc).leftJoin(qSwDjSy.swDjXmxx, qSwDjXmxx).leftJoin(qSwDjSy.swHcXmRwRel,qSwHcXmRwRel);
        jpaQuery.where(qSwDjSy.syId.eq(syId));
        jpaQuery.where(qSwDjSy.sysjly.eq(Gtlx.GD.toString()).or(qSwDjSy.sysjly.isNull()));
        //jpaQuery.where(qSwDjSy.syzt.eq(Syzt.ZC.toString()).or(qSwDjSy.syzt.isNull()).or(qSwDjSy.syzt.eq("")));
        SwDjSyQuery swDjSyQuery = (SwDjSyQuery)baseRepository.get(jpaQuery, qBean);
        return swDjSyQuery;
    }

    @Override
    public SwDjSyQuery getNewQsXX(String xmId) {
        QSwDjXmxx qSwDjXmxx = QSwDjXmxx.swDjXmxx;
        QZd qZd = QZd.zd;
        QBean qBean = Projections.bean(SwDjSyQuery.class, qSwDjXmxx.xmId,qSwDjXmxx.xmmc,qSwDjXmxx.gdmj,qSwDjXmxx.qdfs,qSwDjXmxx.xmTdyt,qSwDjXmxx.xmYddw,qSwDjXmxx.xmXzqdm,qSwDjXmxx.qdjg,qSwDjXmxx.gdsj,qSwDjXmxx.xmTdzl,qSwDjXmxx,qZd.djh);

        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        jpaQuery.from(qSwDjXmxx).leftJoin(qSwDjXmxx.zd,qZd);
        jpaQuery.where(qSwDjXmxx.xmId.eq(xmId));
        SwDjSyQuery swDjSyQuery = (SwDjSyQuery)baseRepository.get(jpaQuery, qBean);

        BigDecimal jsbl = new BigDecimal(AppConfig.getProperty("jsbl"));
        swDjSyQuery.setJsbl(jsbl);

        String xmXzqdm = swDjSyQuery.getXmXzqdm();
        if(StringUtils.isNotBlank(xmXzqdm)){
            String xian = dwxxService.getDwxxByDwdm(xmXzqdm).getDwmc();
            swDjSyQuery.setFczlXian(xian);
        }

        return swDjSyQuery;
    }

    @Override
    public List<SwDjSyQuery> getSwDjSyByGdId(String gdId) {
        QSwDjXmxx qSwDjXmxx = QSwDjXmxx.swDjXmxx;
        QSwDjQs qSwDjQs = QSwDjQs.swDjQs;
        QSwDjSy qSwDjSy = QSwDjSy.swDjSy;
        QSwDjJbb qSwDjJbb = QSwDjJbb.swDjJbb;
        QSwDjTd qSwDjTd = QSwDjTd.swDjTd;
        QSwDjFc qSwDjFc = QSwDjFc.swDjFc;

        QBean qBean = Projections.bean(SwDjSyQuery.class, qSwDjXmxx.xmId,qSwDjXmxx.xmmc,qSwDjXmxx.gdmj,qSwDjXmxx.qdfs,qSwDjXmxx.xmTdyt,qSwDjXmxx.xmYddw,qSwDjXmxx.xmXzqdm,qSwDjXmxx.qdjg,qSwDjXmxx.gdsj,
                qSwDjQs.qsId,qSwDjQs.qsSzly,qSwDjQs.qsYnse,qSwDjQs.qsYjne,qSwDjQs.qsJmxz,qSwDjQs.qsJmse,qSwDjQs.qsJspz,qSwDjQs.qsXbjse,qSwDjQs.qsBz,qSwDjQs.qsLrrq,qSwDjQs.qsHclx,
                qSwDjJbb.jbbId,qSwDjJbb.glbm,qSwDjJbb.nsrsbh,qSwDjJbb.nsrmc,qSwDjJbb.zgkgMc,qSwDjJbb.zgkgDm,qSwDjJbb.sgyMc,qSwDjJbb.fddbr,qSwDjJbb.zclxDm,qSwDjJbb.zclxMc,qSwDjJbb.hyDm,qSwDjJbb.hyMc,qSwDjJbb.lxdh,qSwDjJbb.zcdz,
                qSwDjSy.syId,qSwDjTd.tdId,qSwDjFc.fcId,qSwDjSy.zd.djh,qSwDjSy.dbh,qSwDjTd.czrmc,qSwDjTd.czrzjhm,qSwDjTd.tdzl,
                qSwDjTd.tdsyzh,qSwDjTd.tdsyztDm,qSwDjTd.tdqdfsDm,qSwDjTd.tdsyytDm,qSwDjTd.dj,qSwDjTd.qdsyqzfje,qSwDjTd.tdkfcb,qSwDjTd.csqdsj,qSwDjTd.syqzzsj,qSwDjTd.tdjmxzdm,qSwDjTd.fzmj,qSwDjTd.scmj,qSwDjTd.tddj,qSwDjTd.msmj,qSwDjTd.ynmj,qSwDjTd.dwse,qSwDjTd.nynseTd,qSwDjTd.msse,
                qSwDjFc.fczh,qSwDjFc.fcmj,qSwDjFc.fwxzDm,qSwDjFc.zyhczDm,qSwDjFc.fwjz,qSwDjFc.tdjz,qSwDjFc.fssbjz,qSwDjFc.fcyz,
                qSwDjFc.czfcyz,qSwDjFc.jsbl,qSwDjFc.fcjmxzdm,qSwDjFc.fcyzYs,qSwDjFc.fcyzMs,qSwDjFc.ynseZy,qSwDjFc.ynseCz,qSwDjFc.nzj,qSwDjFc.nynseFc,qSwDjFc.fczl,qSwDjTd.sgztDm,qSwDjSy.bz,qSwDjTd.tdsyqlx,qSwDjTd.tdMssjBegin,qSwDjTd.tdMssjEnd,qSwDjTd.tdMsyy,qSwDjFc.fcMssjBegin,qSwDjFc.fcMssjEnd,qSwDjFc.fcMsyy,qSwDjFc.sl,qSwDjSy.ishc,qSwDjTd.gtzdbyzyy
        );
        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        jpaQuery.from(qSwDjSy).leftJoin(qSwDjSy.swDjQs, qSwDjQs).leftJoin(qSwDjQs.swDjJbb, qSwDjJbb).leftJoin(qSwDjSy.swDjTd, qSwDjTd).leftJoin(qSwDjSy.swDjFc, qSwDjFc).leftJoin(qSwDjSy.swDjXmxx, qSwDjXmxx);
        jpaQuery.where(qSwDjXmxx.xmId.eq(gdId));
        jpaQuery.where(qSwDjSy.sysjly.eq(Gtlx.GD.toString()).or(qSwDjSy.sysjly.isNull()));
        jpaQuery.where(qSwDjSy.syzt.eq(Syzt.ZC.toString()).or(qSwDjSy.syzt.isNull()).or(qSwDjSy.syzt.eq("")));
        List<SwDjSyQuery> swDjSyQuerylist = (List)baseRepository.dslList(jpaQuery, qBean);
        return swDjSyQuerylist;
    }

    @Override
    @Transactional(value="oracle_common")
    public void SaveQs(SwDjSyQuery swDjSyQuery) {
        String xmId = swDjSyQuery.getXmId();
        String qsId = swDjSyQuery.getQsId();
        String syId = swDjSyQuery.getSyId();
        String tdId = swDjSyQuery.getTdId();
        String fcId = swDjSyQuery.getFcId();
        String shxrId = swDjSyQuery.getShxrId();

        SwDjXmxx swDjXmxx = baseRepository.get(SwDjXmxx.class,xmId);
        swDjXmxx.setXmTdzl(swDjSyQuery.getXmTdzl());
        /*
        if(StringUtils.isNotBlank(syId)){
            // 保存历史记录
            SwDjSy swDjSy = taxService.getSwDjSyById(syId);
            swdjSyHisService.saveSwDjHis(swDjSy, "", SessionUtil.getCurrentUserId(), Czlx.UPDATE.toString());
        }
        */

        // 税源主表
        SwDjSy swDjSy = new SwDjSy();
        BeanUtils.copyProperties(swDjSyQuery, swDjSy);
        swDjSy.setSwDjXmxx(swDjXmxx);
        if(StringUtils.isBlank(swDjSyQuery.getSyzt())){
            swDjSy.setSyzt(Syzt.ZC.toString());
        }

        swDjSy.setSysjly(Gtlx.GD.toString());
        //根据ShxrId获取
        if(StringUtils.isNotBlank(shxrId)){
            SwHcXmRwRel swHcXmRwRel = hcxmService.getSwHcXmRwRelByShxrId(shxrId);
            swDjSy.setSwHcXmRwRel(swHcXmRwRel);
        }
        if (StringUtils.isBlank(syId)) {
            swDjSy.setSyId(UUIDGenerator.generate());
            baseRepository.save(swDjSy);
        }else
        {
            baseRepository.update(swDjSy);
        }

        SwDjJbb swDjJbb = null;
        String nsrsbh = swDjSyQuery.getNsrsbh();
        // 根据管理编码查询是否存在基本表信息
        if(StringUtils.isNotBlank(nsrsbh)){
            swDjJbb = taxService.findSwDjJbbByGlbm(nsrsbh);
        }
        if(swDjJbb==null){
            swDjJbb = new SwDjJbb();
            BeanUtils.copyProperties(swDjSyQuery, swDjJbb);
            swDjJbb.setJbbId(UUIDGenerator.generate());
            //保存主管税务机关名称
            String zgkgDm = swDjSyQuery.getZgkgDm();
            String zgkgMc = dicService.findZgkgMcByZgkgDm(zgkgDm);
            swDjJbb.setZgkgMc(zgkgMc);

            baseRepository.save(swDjJbb);//先保存基本表
        }else{
            BeanUtils.copyProperties(swDjSyQuery, swDjJbb, new String[]{"jbbId"});
            baseRepository.update(swDjJbb);
        }

        // 保存土地税源数据
        if (swDjSyQuery.getScmj() != null) {
            SwDjTd swDjTd = new SwDjTd();
            BeanUtils.copyProperties(swDjSyQuery, swDjTd);
            swDjTd.setSjly(Sjly.SYHC.toString());
            swDjTd.setSwDjSy(swDjSy);
            swDjTd.setSwDjJbb(swDjJbb);
            String fczl = CommonUtil.getFczl(swDjSyQuery.getFczlXian(), swDjSyQuery.getFczlZhen(), swDjSyQuery.getFczlLu(), swDjSyQuery.getFczlHao(), swDjSyQuery.getFczlDong(), swDjSyQuery.getFczlDy(), swDjSyQuery.getFczlLou(), swDjSyQuery.getFczlShi());
            swDjTd.setTdzl(fczl);
            if (StringUtils.isBlank(tdId)) {//save
                swDjTd.setTdId(UUIDGenerator.generate());
                baseRepository.save(swDjTd);
            } else {//update
                baseRepository.update(swDjTd);
            }
        }

        // 保存房产税源数据
        if (swDjSyQuery.getFcyz() != null) {
            SwDjFc swDjFc = new SwDjFc();
            BeanUtils.copyProperties(swDjSyQuery, swDjFc);
            swDjFc.setSjly(Sjly.SYHC.toString());
            swDjFc.setSwDjSy(swDjSy);
            swDjFc.setSwDjJbb(swDjJbb);
            String fczl = CommonUtil.getFczl(swDjSyQuery.getFczlXian(),swDjSyQuery.getFczlZhen(),swDjSyQuery.getFczlLu(),swDjSyQuery.getFczlHao(),swDjSyQuery.getFczlDong(),swDjSyQuery.getFczlDy(),swDjSyQuery.getFczlLou(),swDjSyQuery.getFczlShi());
            swDjFc.setFczl(fczl);
            if (StringUtils.isBlank(fcId)) {//save
                swDjFc.setFcId(UUIDGenerator.generate());
                baseRepository.save(swDjFc);
            } else {//update
                baseRepository.update(swDjFc);
            }
        }

        // 保存契税数据
        SwDjQs swDjQs = new SwDjQs();
        BeanUtils.copyProperties(swDjSyQuery, swDjQs);
        swDjQs.setQsSzly(Gqszly.XMLR.toString());
        swDjQs.setSwDjSy(swDjSy);
        swDjQs.setSwDjJbb(swDjJbb);
        if(StringUtils.isBlank(qsId)){//save
            swDjQs.setQsId(UUIDGenerator.generate());
            swDjQs.setQsLrrq(new Date());
            baseRepository.save(swDjQs);
        }else{//update
            baseRepository.update(swDjQs);
        }




    }

    @Override
    @Transactional(value="oracle_common")
    public void DelQS(String syId) {

        /*
        // 保存历史记录
        swdjSyHisService.saveSwDjHis(swDjSy, "", SessionUtil.getCurrentUserId(), Czlx.DELETE.toString());
        */
        // 删除
        taxService.deleteSwDjSy(syId);
    }

    private void applySwDjQsQueryPredicates(SwDjQsQuery swDjQsQuery,QSwDjJbb qSwDjJbb,JPQLQuery jpaQuery,QSwDjXmxx qSwDjXmxx){
        if(StringUtils.isNotBlank(swDjQsQuery.getGlbm()))
            jpaQuery.where(Expressions.stringPath(qSwDjJbb,"glbm").like(QueryCondition.WILDCARDS + swDjQsQuery.getGlbm() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(swDjQsQuery.getNsrsbh()))
            jpaQuery.where(Expressions.stringPath(qSwDjJbb,"nsrsbh").like(QueryCondition.WILDCARDS + swDjQsQuery.getNsrsbh() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(swDjQsQuery.getNsrmc()))
            jpaQuery.where(Expressions.stringPath(qSwDjJbb,"nsrmc").like(QueryCondition.WILDCARDS + swDjQsQuery.getNsrmc() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(swDjQsQuery.getZclxDm()))
            jpaQuery.where(Expressions.stringPath(qSwDjJbb,"zclxDm").eq(swDjQsQuery.getZclxDm()));
        if(StringUtils.isNotBlank(swDjQsQuery.getHyDm()))
            jpaQuery.where(Expressions.stringPath(qSwDjJbb,"hyDm").eq(swDjQsQuery.getHyDm()));
        if(StringUtils.isNotBlank(swDjQsQuery.getSgyMc()))
            jpaQuery.where(Expressions.stringPath(qSwDjJbb,"sgyMc").like(QueryCondition.WILDCARDS + swDjQsQuery.getSgyMc() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(swDjQsQuery.getZgkgDm()))
            jpaQuery.where(Expressions.stringPath(qSwDjJbb,"zgkgDm").eq(swDjQsQuery.getZgkgDm()));
        if(StringUtils.isNotBlank(swDjQsQuery.getXmXzqdm()))
            jpaQuery.where(Expressions.stringPath(qSwDjXmxx, "xmXzqdm").eq(swDjQsQuery.getXmXzqdm()));
        if(StringUtils.isNotBlank(swDjQsQuery.getXmmc()))
            jpaQuery.where(Expressions.stringPath(qSwDjXmxx, "xmmc").like(QueryCondition.WILDCARDS + swDjQsQuery.getXmmc() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(swDjQsQuery.getQdfs()))
            jpaQuery.where(Expressions.stringPath(qSwDjXmxx, "qdfs").eq(swDjQsQuery.getQdfs()));
        if(StringUtils.isNotBlank(swDjQsQuery.getXmTdyt()))
            jpaQuery.where(Expressions.stringPath(qSwDjXmxx, "xmTdyt").eq(swDjQsQuery.getXmTdyt()));
        if(StringUtils.isNotBlank(swDjQsQuery.getXmYddw()))
            jpaQuery.where(Expressions.stringPath(qSwDjXmxx, "xmYddw").like(QueryCondition.WILDCARDS + swDjQsQuery.getXmYddw() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(swDjQsQuery.getIds())){
            jpaQuery.where(qSwDjXmxx.xmId.in(Arrays.asList(swDjQsQuery.getIds().split(","))));
        }
        if(StringUtils.isNotBlank(swDjQsQuery.getExcelBegin()) && StringUtils.isNotBlank(swDjQsQuery.getExcelEnd())){
            Integer offset = Integer.parseInt(swDjQsQuery.getExcelBegin())-1;
            Integer limit = Integer.parseInt(swDjQsQuery.getExcelEnd())-offset;
            jpaQuery.offset(offset).limit(limit);
        }
    }

    private void applySwDjQsQueryPredicates(SwDjQsQuery swDjQsQuery,JPQLQuery jpaQuery,QSwDjXmxx qSwDjXmxx){
        if(StringUtils.isNotBlank(swDjQsQuery.getXmXzqdm()))
            jpaQuery.where(Expressions.stringPath(qSwDjXmxx, "xmXzqdm").eq(swDjQsQuery.getXmXzqdm()));
        if(StringUtils.isNotBlank(swDjQsQuery.getXmmc()))
            jpaQuery.where(Expressions.stringPath(qSwDjXmxx, "xmmc").like(QueryCondition.WILDCARDS + swDjQsQuery.getXmmc() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(swDjQsQuery.getQdfs()))
            jpaQuery.where(Expressions.stringPath(qSwDjXmxx, "qdfs").eq(swDjQsQuery.getQdfs()));
        if(StringUtils.isNotBlank(swDjQsQuery.getXmTdyt()))
            jpaQuery.where(Expressions.stringPath(qSwDjXmxx, "xmTdyt").eq(swDjQsQuery.getXmTdyt()));
        if(StringUtils.isNotBlank(swDjQsQuery.getXmYddw()))
            jpaQuery.where(Expressions.stringPath(qSwDjXmxx, "xmYddw").like(QueryCondition.WILDCARDS + swDjQsQuery.getXmYddw() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(swDjQsQuery.getIds())){
            jpaQuery.where(qSwDjXmxx.xmId.in(Arrays.asList(swDjQsQuery.getIds().split(","))));
        }
        if(StringUtils.isNotBlank(swDjQsQuery.getXmTdzl())){
            jpaQuery.where(Expressions.stringPath(qSwDjXmxx, "xmTdzl").like(QueryCondition.WILDCARDS + swDjQsQuery.getXmTdzl() + QueryCondition.WILDCARDS));
        }
        if(StringUtils.isNotBlank(swDjQsQuery.getExcelBegin()) && StringUtils.isNotBlank(swDjQsQuery.getExcelEnd())){
            Integer offset = Integer.parseInt(swDjQsQuery.getExcelBegin())-1;
            Integer limit = Integer.parseInt(swDjQsQuery.getExcelEnd())-offset;
            jpaQuery.offset(offset).limit(limit);
        }
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public SwDjXmxx getXmxxByXmcm(String xmmc) {
        String jpql = "from SwDjXmxx o where o.xmmc=?0";
        List list = baseRepository.getByJpql(jpql,xmmc);
        if(CollectionUtils.isNotEmpty(list)){
            return (SwDjXmxx)list.get(0);
        }
        return null;
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public String parseXzqByDm(String dm) {
        String jpql = "from SDmDwxxCz t where t.dwdm=?0";
        if(StringUtils.isNotBlank(dm)){
            List<SDmDwxxCz> sDmDwxxCzList = baseRepository.getByJpql(jpql,dm);
            if(CollectionUtils.isNotEmpty(sDmDwxxCzList)){
                return sDmDwxxCzList.get(0).getDwmc();
            }
        }

        return "";
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public List<SwDjQsQuery> getXmxxList(SwDjQsQuery swDjQsQuery) {
        QSwDjXmxx qSwDjXmxx = QSwDjXmxx.swDjXmxx;
        QBean qBean = Projections.bean(SwDjQsQuery.class, qSwDjXmxx.xmTdzl,qSwDjXmxx.xmmc,qSwDjXmxx.xmId,qSwDjXmxx.xmYddw,qSwDjXmxx.gdmj,qSwDjXmxx.gdsj,qSwDjXmxx.qdfs,qSwDjXmxx.qdjg,qSwDjXmxx.xmTdyt);
        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        jpaQuery.from(qSwDjXmxx);
        applySwDjQsQueryPredicates(swDjQsQuery, jpaQuery,qSwDjXmxx);
        return (List)baseRepository.dslList(jpaQuery,qBean);
    }
}
