package cn.gtmap.landtax.service.impl;

import cn.gtmap.landtax.entity.SSjGtbd;
import cn.gtmap.landtax.service.SsjGtbdService;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


/**
 * Created by Administrator on 2014/8/29.
 */
@Service
public class SsjGtbdServiceImpl implements SsjGtbdService{
    @Autowired
    BaseRepository baseRepository;


    @Override
    public void updateSsjGtbd(SSjGtbd sSjGtbd) {
        baseRepository.update(sSjGtbd);
    }

    @Override
    public SSjGtbd findByDjh(String djh) {
        String jpql = "from SSjGtbd where djh=?0";
        return (SSjGtbd)baseRepository.getUniqueResultByJpql(jpql,djh);
    }

    @Override
    public SSjGtbd findByBdId(String bdId) {
        return baseRepository.get(SSjGtbd.class,bdId);
    }


}
