package cn.gtmap.landtax.service.impl;

import cn.gtmap.landtax.entity.SDmDwxxCz;
import cn.gtmap.landtax.model.query.SyxxtjbQuery;
import cn.gtmap.landtax.service.SjjkService;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.IPlatUtil;
import com.gtis.plat.service.SysUserService;
import com.gtis.web.SessionUtil;
import org.apache.commons.collections.CollectionUtils;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.Query;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by zenglihuan on 2017-4-17.
 */
@Service
public class SjjkServiceImpl implements SjjkService {
    @Autowired
    BaseRepository baseRepository;
    @Autowired
    SysUserService sysUserService;
    @Autowired
    IPlatUtil platUtil;

    @Autowired
    DwxxServiceImpl dwxxServiceImpl;

    @Override
    @Transactional(readOnly = true)
    public List<Map<String, Object>> workProceedTbtjJson(String year, String beginQ, String endQ) {
        String regionCode = SessionUtil.getCurrentUser().getRegionCode();
        int dwdm_length;
        String orderField = "";
        if(regionCode.length() == 2){
            dwdm_length = 4;
            orderField = "SERIALNUMBER";
        }else if(regionCode.length() == 4){
            dwdm_length = 6;
            orderField = "DWDM";
        }else {
            return null;
        }
        String beginYearQ = year + beginQ;
        String endYearQ = year + endQ;
        String sql =
                "SELECT " +
                "DWMC, SERIALNUMBER, TO_CHAR(ZGH,'FM9,999,999,999') AS ZGH, " +
                "TO_CHAR(TD_NSH,'FM9,999,999,999') AS TD_NSH, TO_CHAR(TD_DWNSH,'FM9,999,999,999') AS TD_DWNSH, " +
                "DECODE(SUBSTR(TD_ZHZB, 1, 1), '.', '0'||TD_ZHZB, TD_ZHZB) AS TD_ZHZB, TO_CHAR(TD_YS,'FM9,999,999,999') AS TD_YS, " +
                "TO_CHAR(FC_NSH,'FM9,999,999,999') AS FC_NSH, TO_CHAR(FC_ZJH,'FM9,999,999,999') AS FC_ZJH, " +
                "DECODE(SUBSTR(FC_ZHZB, 1, 1), '.', '0'||FC_ZHZB, FC_ZHZB) AS FC_ZHZB, TO_CHAR(FC_YS,'FM9,999,999,999') AS FC_YS, " +
                "TO_CHAR(TD_BJGX,'FM9,999,999,999') AS TD_BJGX, TO_CHAR(TD_LJGX,'FM9,999,999,999') AS TD_LJGX, " +
                "DECODE(SUBSTR(TD_BJZB, 1, 1), '.', '0'||TD_BJZB, TD_BJZB) AS TD_BJZB, DECODE(SUBSTR(TD_LJZB, 1, 1), '.', '0'||TD_LJZB, TD_LJZB) AS TD_LJZB, " +
                "TO_CHAR(FC_BJGX,'FM9,999,999,999') AS FC_BJGX, TO_CHAR(FC_LJGX,'FM9,999,999,999') AS FC_LJGX, " +
                "TO_CHAR(FC_ZJNS,'FM9,999,999,999') AS FC_ZJNS, TO_CHAR(FC_ZS,'FM9,999,999,999') AS FC_ZS, " +
                "DECODE(SUBSTR(FC_BJZB, 1, 1), '.', '0'||FC_BJZB, FC_BJZB) AS FC_BJZB, DECODE(SUBSTR(FC_LJZB, 1, 1), '.', '0'||FC_LJZB, FC_LJZB) AS FC_LJZB " +
                "FROM " +
                "(" +
                "SELECT DECODE(DWMC, NULL, '合计', DWMC) AS DWMC, DECODE(DWMC, NULL, '0000', MAX("+orderField+")) AS SERIALNUMBER, " +
                "SUM(ZGH) AS ZGH, SUM(TD_NSH) AS TD_NSH, SUM(TD_DWNSH) AS TD_DWNSH, ROUND(DECODE(SUM(ZGH), 0, 0, SUM(TD_NSH)/SUM(ZGH)), 4)*100||'%' AS TD_ZHZB, " +
                "SUM(TD_YS) AS TD_YS, SUM(FC_NSH) AS FC_NSH, SUM(FC_ZJH) AS FC_ZJH, ROUND(DECODE(SUM(ZGH), 0, 0, SUM(FC_NSH)/SUM(ZGH)), 4)*100||'%' AS FC_ZHZB, " +
                "SUM(FC_YS) AS FC_YS, SUM(TD_BJGX) AS TD_BJGX, SUM(TD_LJGX) AS TD_LJGX, SUM(TD_ZS) AS TD_ZS, " +
                "DECODE(SUM(TD_ZS), 0, 0, ROUND(SUM(TD_BJGX)/SUM(TD_ZS), 4))*100||'%' AS TD_BJZB, " +
                "DECODE(SUM(TD_ZS), 0, 0, ROUND(SUM(TD_LJGX)/SUM(TD_ZS), 4))*100||'%' AS TD_LJZB, " +
                "SUM(FC_BJGX) AS FC_BJGX, SUM(FC_LJGX) AS FC_LJGX, SUM(FC_ZJNS) AS FC_ZJNS, SUM(FC_ZS) AS FC_ZS, " +
                "DECODE(SUM(FC_ZS), 0, 0, ROUND(SUM(FC_BJGX)/SUM(FC_ZS), 4))*100||'%' AS FC_BJZB, " +
                "DECODE(SUM(FC_ZS), 0, 0, ROUND(SUM(FC_LJGX)/SUM(FC_ZS), 4))*100||'%' AS FC_LJZB  " +
                "FROM " +
                "(" +
                "SELECT T1.DWDM, T1.DWMC, T1.SERIALNUMBER, NVL(T1.ZGH, 0) AS ZGH, NVL(T2.TD_NSH, 0) AS TD_NSH, NVL((T2.TD_KGH + T2.TD_JGDWH), 0) AS TD_DWNSH,  " +
                        "NVL(T2.TD_YS, 0) AS TD_YS, NVL(T3.FC_NSH, 0) AS FC_NSH, NVL(T3.FC_ZJH, 0) AS FC_ZJH, NVL(T3.FC_YS, 0) AS FC_YS, NVL(T4.BJGX, 0) + NVL(T5.TD_BJXZ, 0) AS TD_BJGX, NVL(T4.LJGX, 0) + NVL(T5.TD_LJXZ, 0) AS TD_LJGX, " +
                        "NVL(T5.TD_ZS, 0) AS TD_ZS, NVL(T4.BJGX, 0) + NVL(T6.FC_BJXZ, 0) AS FC_BJGX, NVL(T4.LJGX, 0) + NVL(T6.FC_LJXZ, 0) AS FC_LJGX, NVL(T6.FC_ZJNS, 0) AS FC_ZJNS, NVL(T6.FC_ZS, 0) AS FC_ZS " +
                "FROM ( " +
                "    SELECT * FROM SW_JS_ZGH WHERE LENGTH(DWDM)="+dwdm_length+") T1  " +
                "    LEFT JOIN (" +
                "    SELECT SUBSTR(T2.ZGKG_DM, 2, "+dwdm_length+") AS DWDM,  " +
                "    COUNT(DISTINCT(DECODE(T1.SGZT_DM, '01', T2.NSRSBH, T2.NSRMC))) AS TD_NSH,  " +
                "    COUNT(DISTINCT(CASE WHEN T1.SGZT_DM = '01' AND T2.ZCLX_DM NOT IN('720', '710') " +
                "                        THEN T2.NSRSBH  " +
                "                        ELSE NULL  " +
                "                        END)) AS TD_KGH,  " +
                "    COUNT(DISTINCT(DECODE(T1.SGZT_DM, '05', T2.NSRMC, NULL))) AS TD_JGDWH,  " +
                "    COUNT(DISTINCT(CASE WHEN T1.NYNSE > 0  " +
                "                        THEN T1.TD_ID  " +
                "                        ELSE NULL  " +
                "                        END)) AS TD_YS  " +
                "    FROM SW_DJ_TD T1  " +
                "    LEFT JOIN SW_DJ_JBB T2 ON T1.JBB_ID = T2.JBB_ID  " +
                "    WHERE T2.ZGKG_DM IS NOT NULL " +
                "    GROUP BY SUBSTR(T2.ZGKG_DM, 2, "+dwdm_length+") " +
                ") T2 ON T1.DWDM = T2.DWDM " +
                "LEFT JOIN ( " +
                "    SELECT SUBSTR(T2.ZGKG_DM, 2, "+dwdm_length+") AS DWDM,  " +
                "    COUNT(DISTINCT(DECODE(T1.SGZT_DM, '01', T2.NSRSBH, T2.NSRMC))) AS FC_NSH,  " +
                "    COUNT(DISTINCT(CASE WHEN T1.NZJ > 0  " +
                "                        THEN T2.NSRSBH  " +
                "                        ELSE NULL  " +
                "                        END)) AS FC_ZJH,  " +
                "    COUNT(DISTINCT(CASE WHEN T1.NYNSE > 0  " +
                "                        THEN T1.FC_ID  " +
                "                        ELSE NULL  " +
                "                        END)) AS FC_YS  " +
                "    FROM SW_DJ_FC T1  " +
                "    LEFT JOIN SW_DJ_JBB T2 ON T1.JBB_ID = T2.JBB_ID  " +
                "    WHERE T2.ZGKG_DM IS NOT NULL  " +
                "    GROUP BY SUBSTR(T2.ZGKG_DM, 2, "+dwdm_length+") " +
                ") T3 ON T1.DWDM = T3.DWDM  " +
                "LEFT JOIN ( " +
                "    SELECT SUBSTR(JBB_ZGKG_DM, 2, "+dwdm_length+") AS DWDM,  " +
                "    COUNT(DISTINCT(CASE WHEN TO_CHAR(UPDATE_DATE, 'YYYYQ') >= '"+beginYearQ+"' AND TO_CHAR(UPDATE_DATE, 'YYYYQ') <= '"+endYearQ+"'  " +
                "                        THEN SY_ID  " +
                "                        ELSE NULL  " +
                "                        END)) AS BJGX,  " +
                "    COUNT(DISTINCT(CASE WHEN TO_CHAR(UPDATE_DATE, 'YYYYQ') <= '"+endYearQ+"'  " +
                "                        THEN SY_ID  " +
                "                        ELSE NULL  " +
                "                        END)) AS LJGX,  " +
                "    COUNT(DISTINCT(CASE WHEN FC_NZJ > 0 AND TO_CHAR(UPDATE_DATE, 'YYYYQ') >= '"+beginYearQ+"' AND TO_CHAR(UPDATE_DATE, 'YYYYQ') <= '"+endYearQ+"'  " +
                "                        THEN SY_ID  " +
                "                        ELSE NULL  " +
                "                        END)) AS ZJNS  " +
                "    FROM SW_DJ_SY_HIS  " +
                "    WHERE JBB_ZGKG_DM IS NOT NULL  " +
                "    GROUP BY SUBSTR(JBB_ZGKG_DM, 2, "+dwdm_length+") " +
                ") T4 ON T1.DWDM = T4.DWDM  " +
                "LEFT JOIN ( " +
                "    SELECT SUBSTR(T3.ZGKG_DM, 2, "+dwdm_length+") AS DWDM,  " +
                "    COUNT(DISTINCT T2.TD_ID) AS TD_ZS,  " +
                "    COUNT(DISTINCT(CASE WHEN TO_CHAR(T2.LRRQ, 'YYYYQ') >= '"+beginYearQ+"' AND TO_CHAR(T2.LRRQ, 'YYYYQ') <= '"+endYearQ+"' AND T2.LRRQ = T2.UPDATE_DATE " +
                "                        THEN T2.TD_ID  " +
                "                        ELSE NULL  " +
                "                        END)) AS TD_BJXZ,  " +
                "    COUNT(DISTINCT(CASE WHEN TO_CHAR(T2.LRRQ, 'YYYYQ') <= '"+endYearQ+"' AND T2.LRRQ = T2.UPDATE_DATE " +
                "                        THEN T2.TD_ID  " +
                "                        ELSE NULL  " +
                "                        END)) AS TD_LJXZ  " +
                "    FROM SW_DJ_SY T1  " +
                "    INNER JOIN SW_DJ_TD T2 ON T1.SY_ID = T2.SY_ID  " +
                "    INNER JOIN SW_DJ_JBB T3 ON T2.JBB_ID = T3.JBB_ID  " +
                "    WHERE T1.SYZT <> '2' AND T3.ZGKG_DM IS NOT NULL  " +
                "    GROUP BY SUBSTR(T3.ZGKG_DM, 2, "+dwdm_length+") " +
                ") T5 ON T1.DWDM = T5.DWDM " +
                "LEFT JOIN ( " +
                "    SELECT SUBSTR(T3.ZGKG_DM, 2, "+dwdm_length+") AS DWDM,  " +
                "    COUNT(DISTINCT FC_ID) AS FC_ZS,  " +
                "    COUNT(DISTINCT(CASE WHEN TO_CHAR(T4.LRRQ, 'YYYYQ') >= '"+beginYearQ+"' AND TO_CHAR(T4.LRRQ, 'YYYYQ') <= '"+endYearQ+"' AND T4.LRRQ = T4.UPDATE_DATE " +
                "                        THEN T2.FC_ID  " +
                "                        ELSE NULL  " +
                "                        END)) AS FC_BJXZ,  " +
                "    COUNT(DISTINCT(CASE WHEN TO_CHAR(T4.LRRQ, 'YYYYQ') <= '"+endYearQ+"'  " +
                "                        THEN T2.FC_ID  " +
                "                        ELSE NULL  " +
                "                        END)) AS FC_LJXZ,  " +
                "    COUNT(DISTINCT(CASE WHEN NZJ > 0 AND TO_CHAR(T4.LRRQ, 'YYYYQ') >= '"+beginYearQ+"' AND TO_CHAR(T4.LRRQ, 'YYYYQ') <= '"+endYearQ+"' AND T4.LRRQ = T4.UPDATE_DATE " +
                "                        THEN T2.FC_ID   " +
                "                        ELSE NULL  " +
                "                        END)) AS FC_ZJNS  " +
                "    FROM SW_DJ_SY T1  " +
                "    INNER JOIN SW_DJ_FC T2 ON T1.SY_ID = T2.SY_ID  " +
                "    INNER JOIN SW_DJ_JBB T3 ON T2.JBB_ID = T3.JBB_ID  " +
                "    INNER JOIN SW_DJ_TD T4 ON T1.SY_ID = T4.SY_ID " +
                "    WHERE T1.SYZT <> '2' AND T3.ZGKG_DM IS NOT NULL  " +
                "    GROUP BY SUBSTR(T3.ZGKG_DM, 2, "+dwdm_length+") " +
                ") T6 ON T1.DWDM = T6.DWDM " +
                ")" +
                "GROUP BY ROLLUP(DWMC) " +
                ")" +
                "ORDER BY SERIALNUMBER ";

        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        return query.getResultList();
    }
        @Override
        @Transactional(readOnly = true)
        public List<Map<String, Object>> jzqktjJson(String year, String beginQ, String endQ) {
                String regionCode = SessionUtil.getCurrentUser().getRegionCode();
                int regionlength=regionCode.length()+2;
                String orderSql = "";
                if(regionCode.length() == 2){
                        orderSql = " ORDER BY T2.SERIALNUMBER";
                }else if(regionCode.length() == 4){
                        orderSql = " ORDER BY T2.DWDM";
                }
                String beginYearQ = year + beginQ;
                String endYearQ = year + endQ;
                String sql ="SELECT  T1.DWMC, TO_CHAR(T1.ZGH,'FM9,999,999,999')ZGH, TO_CHAR(TDSTS,'FM9,999,999,999')TDSTS,TO_CHAR(TDNYNSE,'FM9,999,999,990.00')TDNYNSE,TO_CHAR(TD_DWTS,'FM9,999,999,999')TD_DWTS,TO_CHAR(TD_DWHS,'FM9,999,999,999')TD_DWHS," +
                        "                                                TO_CHAR(TD_DWNYNSE,'FM9,999,999,990.00')TD_DWNYNSE,TO_CHAR(TD_GTTS,'FM9,999,999,999')TD_GTTS,TO_CHAR(TD_GTHNYNSE,'FM9,999,999,990.00')TD_GTHNYNSE,TO_CHAR(TD_GRTS,'FM9,999,999,999')TD_GRTS,TO_CHAR(TD_GRNYNSE,'FM9,999,999,990.00')TD_GRNYNSE," +
                        "                                                TO_CHAR(FCSTS,'FM9,999,999,999')FCSTS,TO_CHAR(FCNYNSE,'FM9,999,999,990.00')FCNYNSE,TO_CHAR(FC_DWTS,'FM9,999,999,999')FC_DWTS,TO_CHAR(FC_DWHS,'FM9,999,999,999')FC_DWHS," +
                        "                                                TO_CHAR(FC_DWNYNSE,'FM9,999,999,990.00')FC_DWNYNSE,TO_CHAR(FC_GTTS,'FM9,999,999,999')FC_GTTS,TO_CHAR(FC_GTHNYNSE,'FM9,999,999,990.00')FC_GTHNYNSE,TO_CHAR(FC_GRTS,'FM9,999,999,999')FC_GRTS,TO_CHAR(FC_GRNYNSE,'FM9,999,999,990.00')FC_GRNYNSE," +
                        "                                                TO_CHAR(CZFCSTS,'FM9,999,999,999')CZFCSTS,TO_CHAR(CZFCNYNSE,'FM9,999,999,990.00')CZFCNYNSE,TO_CHAR(CZFC_DWTS,'FM9,999,999,999')CZFC_DWTS,TO_CHAR(CZFC_DWHS,'FM9,999,999,999')CZFC_DWHS," +
                        "                                                TO_CHAR(CZFC_DWNYNSE,'FM9,999,999,990.00')CZFC_DWNYNSE,TO_CHAR(CZFC_GTTS,'FM9,999,999,999')CZFC_GTTS,TO_CHAR(CZFC_GTHNYNSE,'FM9,999,999,990.00')CZFC_GTHNYNSE,TO_CHAR(CZFC_GRTS,'FM9,999,999,999')CZFC_GRTS,TO_CHAR(CZFC_GRNYNSE,'FM9,999,999,990.00')CZFC_GRNYNSE," +
                        "                                                TO_CHAR(TD_BJGXTS,'FM9,999,999,999')TD_BJGXTS,TO_CHAR(TD_BJKGHGXTS,'FM9,999,999,999')TD_BJKGHGXTS,DECODE(SUBSTR(TD_BJGXZB, 1, 1), '.', '0'||TD_BJGXZB, TD_BJGXZB)TD_BJGXZB,TO_CHAR(TD_BJMJGX,'FM9,999,999,990.00')TD_BJMJGX," +
                        "                                                TO_CHAR(TD_BJNYNSEGX,'FM9,999,999,990.00')TD_BJNYNSEGX,TO_CHAR(TD_LJGXTS,'FM9,999,999,999')TD_LJGXTS,TO_CHAR(TD_LJKGHGXTS,'FM9,999,999,999')TD_LJKGHGXTS,DECODE(SUBSTR(TD_LJGXZB, 1, 1), '.', '0'||TD_LJGXZB, TD_LJGXZB)TD_LJGXZB," +
                        "                                                TO_CHAR(TD_LJMJGX,'FM9,999,999,990.00')TD_LJMJGX,TO_CHAR(TD_LJNYNSEGX,'FM9,999,999,990.00')TD_LJNYNSEGX," +
                        "                                                TO_CHAR(FC_BJGXTS,'FM9,999,999,999')FC_BJGXTS,TO_CHAR(FC_BJKGHGXTS,'FM9,999,999,999')FC_BJKGHGXTS,TO_CHAR(FC_BJGXCZTS,'FM9,999,999,999')FC_BJGXCZTS,TO_CHAR(FC_BJFCYZGX,'FM9,999,999,990.00')FC_BJFCYZGX," +
                        "                                                TO_CHAR(FC_BJNZJGX,'FM9,999,999,990.00')FC_BJNZJGX,TO_CHAR(FC_BJNYNSEGX,'FM9,999,999,990.00')FC_BJNYNSEGX,TO_CHAR(FC_LJGXTS,'FM9,999,999,999')FC_LJGXTS,TO_CHAR(FC_LJKGHGXTS,'FM9,999,999,999')FC_LJKGHGXTS,TO_CHAR(FC_LJGXCZTS,'FM9,999,999,999')FC_LJGXCZTS," +
                        "                                                TO_CHAR(FC_LJFCYZGX,'FM9,999,999,990.00')FC_LJFCYZGX,TO_CHAR(FC_LJNZJGX,'FM9,999,999,990.00')FC_LJNZJGX,TO_CHAR(FC_LJNYNSEGX,'FM9,999,999,990.00')FC_LJNYNSEGX,DECODE(SUBSTR(FC_LJGXZB, 1, 1), '.', '0'||FC_LJGXZB, FC_LJGXZB)FC_LJGXZB," +
                        "                        NVL(TO_CHAR(T2.QBRQ,'yyyy-mm'),'')QBRQ " +
                        "                        FROM(" +
                        "                        SELECT DECODE(DWMC, NULL, '合计', DWMC) AS DWMC, SUM(ZGH) AS ZGH,SUM(TDSTS) TDSTS,ROUND(SUM(TDNYNSE),2)TDNYNSE,SUM(TD_DWTS)TD_DWTS,SUM(TD_DWHS)TD_DWHS," +
                        "                        ROUND(SUM(TD_DWNYNSE),2)TD_DWNYNSE,SUM(TD_GTTS)TD_GTTS,ROUND(SUM(TD_GTHNYNSE),2)TD_GTHNYNSE,SUM(TD_GRTS)TD_GRTS,ROUND(SUM(TD_GRNYNSE),2)TD_GRNYNSE," +
                        "                        SUM(FCSTS)FCSTS,ROUND(SUM(FCNYNSE),2)FCNYNSE,SUM(FC_DWTS)FC_DWTS,SUM(FC_DWHS)FC_DWHS," +
                        "                        ROUND(SUM(FC_DWNYNSE),2)FC_DWNYNSE,SUM(FC_GTTS)FC_GTTS,ROUND(SUM(FC_GTHNYNSE),2)FC_GTHNYNSE,SUM(FC_GRTS)FC_GRTS,ROUND(SUM(FC_GRNYNSE),2)FC_GRNYNSE," +
                        "                        SUM(CZFCSTS)CZFCSTS,ROUND(SUM(CZFCNYNSE),2)CZFCNYNSE,SUM(CZFC_DWTS)CZFC_DWTS,SUM(CZFC_DWHS)CZFC_DWHS," +
                        "                        ROUND(SUM(CZFC_DWNYNSE),2)CZFC_DWNYNSE,SUM(CZFC_GTTS)CZFC_GTTS,ROUND(SUM(CZFC_GTHNYNSE),2)CZFC_GTHNYNSE,SUM(CZFC_GRTS)CZFC_GRTS,ROUND(SUM(CZFC_GRNYNSE),2)CZFC_GRNYNSE," +
                        "                        SUM(TD_BJGXTS)TD_BJGXTS,SUM(TD_BJKGHGXTS)TD_BJKGHGXTS,ROUND(DECODE(SUM(TDSTS), 0, 0, SUM(BJGXS)/SUM(TDSTS)), 4)*100||'%' AS TD_BJGXZB,ROUND(SUM(TD_BJMJGX),2)TD_BJMJGX," +
                        "                        ROUND(SUM(TD_BJNYNSEGX),2)TD_BJNYNSEGX,SUM(TD_LJGXTS)TD_LJGXTS,SUM(TD_LJKGHGXTS)TD_LJKGHGXTS,ROUND(DECODE(SUM(TDSTS), 0, 0, SUM(LJGXS)/SUM(TDSTS)), 4)*100||'%' TD_LJGXZB," +
                        "                        ROUND(SUM(TD_LJMJGX),2)TD_LJMJGX,ROUND(SUM(TD_LJNYNSEGX),2)TD_LJNYNSEGX," +
                        "                        SUM(FC_BJGXTS)FC_BJGXTS,SUM(FC_BJKGHGXTS)FC_BJKGHGXTS,SUM(FC_BJGXCZTS)FC_BJGXCZTS,ROUND(SUM(FC_BJFCYZGX),2)FC_BJFCYZGX," +
                        "                        ROUND(SUM(FC_BJNZJGX),2)FC_BJNZJGX,ROUND(SUM(FC_BJNYNSEGX),2)FC_BJNYNSEGX,SUM(FC_LJGXTS)FC_LJGXTS,SUM(FC_LJKGHGXTS)FC_LJKGHGXTS,SUM(FC_LJGXCZTS)FC_LJGXCZTS," +
                        "                        ROUND(SUM(FC_LJFCYZGX),2)FC_LJFCYZGX,ROUND(SUM(FC_LJNZJGX),2)FC_LJNZJGX,ROUND(SUM(FC_LJNYNSEGX),2)FC_LJNYNSEGX,ROUND(DECODE(SUM(FCSTS), 0, 0, SUM(FCLJGXS)/SUM(FCSTS)), 4)*100||'%' FC_LJGXZB" +
                        "        FROM" +
                        "            (SELECT" +
                        "                T1.DWDM,T1.DWMC,NVL(T1.ZGH,0)ZGH,NVL(T2.TDSTS,0)TDSTS,NVL(T2.TDNYNSE/10000,0) TDNYNSE,NVL((T2.TD_KGHTS+T2.TD_JGDWH),0) AS TD_DWTS," +
                        "                NVL((T2.TD_KGH+T2.TD_JGDWH),0) AS TD_DWHS,NVL((T2.TD_KGHNYNSE+T2.TD_JGNYNSE)/10000, 0) AS TD_DWNYNSE,NVL(T2.TD_GTTS,0)TD_GTTS," +
                        "                NVL(T2.TD_GTHNYNSE/10000,0) TD_GTHNYNSE,NVL(T2.TD_GRTS,0)TD_GRTS,NVL(T2.TD_GRNYNSE/10000,0) TD_GRNYNSE,NVL(T3.FCSTS,0)FCSTS," +
                        "                NVL(T3.FCNYNSE/10000,0) FCNYNSE,NVL((T3.FC_KGHTS+T3.FC_JGDWH),0) AS FC_DWTS,NVL((T3.FC_KGH+T3.FC_JGDWH),0) AS FC_DWHS,NVL((T3.FC_KGHNYNSE+T3.FC_JGNYNSE)/10000,0) AS FC_DWNYNSE," +
                        "                NVL(T3.FC_GTTS,0)FC_GTTS,NVL(T3.FC_GTHNYNSE/10000,0) FC_GTHNYNSE,NVL(T3.FC_GRTS,0)FC_GRTS,NVL(T3.FC_GRNYNSE/10000,0) FC_GRNYNSE," +
                        "                NVL(T4.CZFCSTS,0)CZFCSTS,NVL(T4.CZFCNYNSE/10000,0) CZFCNYNSE,NVL((T4.CZFC_KGHTS+T4.CZFC_JGDWH),0) AS CZFC_DWTS," +
                        "                NVL((T4.CZFC_KGH+T4.CZFC_JGDWH),0) AS CZFC_DWHS,NVL((T4.CZFC_KGHNYNSE+T4.CZFC_JGNYNSE)/10000,0) AS CZFC_DWNYNSE," +
                        "                NVL(T4.CZFC_GTTS,0)CZFC_GTTS,NVL(T4.CZFC_GTHNYNSE/10000,0) CZFC_GTHNYNSE,NVL(T4.CZFC_GRTS,0)CZFC_GRTS,NVL(T4.CZFC_GRNYNSE/10000,0) CZFC_GRNYNSE," +
                        "                NVL((T6.TD_BJXZ+T5.BJGX),0) AS TD_BJGXTS,NVL((T6.TD_BJXZKGH+T5.KGHBJGX),0) AS TD_BJKGHGXTS,NVL(ROUND(DECODE(T2.TDSTS,0,0,(T6.TD_BJXZ+T5.BJGX)/T2.TDSTS),4),0) AS TD_BJGXZB," +
                        "                NVL((T6.TD_BJSCMJXZ+NVL(T10.BJSCMJBH,0))/10000,0) TD_BJMJGX,NVL((T6.TD_BJNYNSEXZ+NVL(T10.BJNYNSEBH,0))/10000,0) AS TD_BJNYNSEGX," +
                        "                NVL((T5.LJGX+T7.TD_LJXZ),0) AS TD_LJGXTS,NVL((T7.TD_LJXZKHG+T5.KGHLJGX),0) AS TD_LJKGHGXTS,NVL(ROUND(DECODE(T2.TDSTS,0,0,(T5.LJGX+T7.TD_LJXZ)/T2.TDSTS),4),0) AS TD_LJGXZB," +
                        "                NVL((T7.TD_LJSCMJXZ+NVL(T11.LJSCMJBH,0))/10000,0) AS TD_LJMJGX,NVL((T7.TD_LJNYNSEXZ+NVL(T11.LJNYNSEBH,0))/10000,0) AS TD_LJNYNSEGX," +
                        "                NVL((T8.FC_BJXZ+T5.BJGX),0) AS FC_BJGXTS,NVL((T8.FC_BJXZKGH+T5.KGHBJGX),0) AS FC_BJKGHGXTS,NVL((T8.FC_BJXZCZ+T5.NJZJNS),0) AS FC_BJGXCZTS," +
                        "                NVL((T8.FC_BJFCYZXZ+NVL(T10.BJFCYZBH,0))/10000, 0) AS FC_BJFCYZGX,NVL((T8.FC_BJFCYZXZ+NVL(T10.BJFCNZJBH,0))/10000,0) AS FC_BJNZJGX," +
                        "                NVL((T8.FC_BJNYNSEXZ+NVL(T10.BJFCNYNSEBH,0))/10000,0) AS FC_BJNYNSEGX,NVL((T5.LJGX+T9.FC_LJXZ),0) AS FC_LJGXTS,NVL((T9.FC_LJXZKGH+T5.KGHLJGX),0) AS FC_LJKGHGXTS," +
                        "                NVL((T9.FC_LJXZCZ+T5.NJZJNS),0) AS FC_LJGXCZTS,NVL((T9.FC_LJFCYZXZ+NVL(T11.LJFCYZBH,0))/10000,0) AS FC_LJFCYZGX,NVL((T9.FC_LJNZJXZ+NVL(T11.LJFCNZJBH,0))/10000,0) AS FC_LJNZJGX," +
                        "                NVL((T9.FC_LJNYNSEXZ+NVL(T11.LJFCNYNSEBH,0))/10000,0) AS FC_LJNYNSEGX,NVL(ROUND(DECODE(T3.FCSTS,0,0,(T5.LJGX+T9.FC_LJXZ)/T3.FCSTS),4),0) AS FC_LJGXZB," +
                        "                NVL((T6.TD_BJXZ+T5.BJGX),0)BJGXS,NVL((T5.LJGX+T7.TD_LJXZ),0)LJGXS,NVL((T5.LJGX+T9.FC_LJXZ),0)FCLJGXS               " +
                        "            FROM" +
                        "                (SELECT" +
                        "                    * " +
                        "                FROM" +
                        "                    SW_JS_ZGH " +
                        "                WHERE" +
                        "                    LENGTH(DWDM)=6) T1 " +
                        "            LEFT JOIN" +
                        "                (" +
                        "                    SELECT" +
                        "                        SUBSTR(T2.ZGKG_DM," +
                        "                        2," +
                        "                        6) AS DWDM," +
                        "                        COUNT(*) AS TDSTS," +
                        "                        SUM(T1.NYNSE) AS TDNYNSE," +
                        "                        COUNT(CASE " +
                        "                            WHEN T1.SGZT_DM = '01' " +
                        "                            AND T2.ZCLX_DM NOT IN('720'," +
                        "                            '710')                           THEN T2.GLBM                            " +
                        "                            ELSE NULL                            " +
                        "                        END) AS TD_KGHTS," +
                        "                        COUNT(DECODE(T1.SGZT_DM," +
                        "                        '05'," +
                        "                        T2.NSRMC," +
                        "                        NULL)) AS TD_JGDWHTS," +
                        "                        COUNT(DISTINCT(CASE " +
                        "                            WHEN T1.SGZT_DM = '01' " +
                        "                            AND T2.ZCLX_DM NOT IN('720'," +
                        "                            '710')                           THEN T2.GLBM                            " +
                        "                            ELSE NULL                            " +
                        "                        END)) AS TD_KGH," +
                        "                        COUNT(DISTINCT(DECODE(T1.SGZT_DM," +
                        "                        '05'," +
                        "                        T2.NSRMC," +
                        "                        NULL))) AS TD_JGDWH," +
                        "                        SUM(CASE " +
                        "                            WHEN T1.SGZT_DM = '01' " +
                        "                            AND T2.ZCLX_DM NOT IN('720'," +
                        "                            '710')                           THEN T1.NYNSE                            " +
                        "                            ELSE 0                            " +
                        "                        END) AS TD_KGHNYNSE," +
                        "                        SUM(DECODE(T1.SGZT_DM," +
                        "                        '05'," +
                        "                        T1.NYNSE," +
                        "                        0)) AS TD_JGNYNSE," +
                        "                        COUNT(CASE " +
                        "                            WHEN T1.SGZT_DM = '01' " +
                        "                            AND T2.ZCLX_DM IN('720'," +
                        "                            '710')                           THEN T2.GLBM                            " +
                        "                            ELSE NULL                            " +
                        "                        END) AS TD_GTTS," +
                        "                        SUM(CASE " +
                        "                            WHEN T1.SGZT_DM = '01' " +
                        "                            AND T2.ZCLX_DM IN('720'," +
                        "                            '710')                           THEN T1.NYNSE                            " +
                        "                            ELSE 0                            " +
                        "                        END) AS TD_GTHNYNSE," +
                        "                        COUNT(DECODE(T1.SGZT_DM," +
                        "                        '04'," +
                        "                        T2.NSRMC," +
                        "                        NULL)) AS TD_GRTS," +
                        "                        SUM(DECODE(T1.SGZT_DM," +
                        "                        '04'," +
                        "                        T1.NYNSE," +
                        "                        0)) AS TD_GRNYNSE       " +
                        "                    FROM" +
                        "                        SW_DJ_TD T1        " +
                        "                    LEFT JOIN" +
                        "                        SW_DJ_JBB T2 " +
                        "                            ON T1.JBB_ID = T2.JBB_ID        " +
                        "                    LEFT JOIN" +
                        "                        SW_DJ_SY T3 " +
                        "                            ON T1.SY_ID=T3.SY_ID       " +
                        "                    WHERE" +
                        "                        T2.ZGKG_DM IS NOT NULL " +
                        "                        AND T3.SYZT<>'2' " +
                        "                        OR T3.SYZT IS NULL       " +
                        "                    GROUP BY" +
                        "                        SUBSTR(T2.ZGKG_DM," +
                        "                        2," +
                        "                        6)  " +
                        "                )T2 " +
                        "                    ON T1.DWDM = T2.DWDM " +
                        "            LEFT JOIN" +
                        "                (" +
                        "                    SELECT" +
                        "                        SUBSTR(T2.ZGKG_DM," +
                        "                        2," +
                        "                        6) AS DWDM," +
                        "                        COUNT(*) AS FCSTS," +
                        "                        SUM(T1.NYNSE) AS FCNYNSE," +
                        "                        COUNT(CASE " +
                        "                            WHEN T1.SGZT_DM = '01' " +
                        "                            AND T2.ZCLX_DM NOT IN('720'," +
                        "                            '710')                           THEN T2.GLBM                            " +
                        "                            ELSE NULL                            " +
                        "                        END) AS FC_KGHTS," +
                        "                        COUNT(DECODE(T1.SGZT_DM," +
                        "                        '05'," +
                        "                        T2.NSRMC," +
                        "                        NULL)) AS FC_JGDWHTS," +
                        "                        COUNT(DISTINCT(CASE " +
                        "                            WHEN T1.SGZT_DM = '01' " +
                        "                            AND T2.ZCLX_DM NOT IN('720'," +
                        "                            '710')                           THEN T2.GLBM                            " +
                        "                            ELSE NULL                            " +
                        "                        END)) AS FC_KGH," +
                        "                        COUNT(DISTINCT(DECODE(T1.SGZT_DM," +
                        "                        '05'," +
                        "                        T2.NSRMC," +
                        "                        NULL))) AS FC_JGDWH," +
                        "                        SUM(CASE " +
                        "                            WHEN T1.SGZT_DM = '01' " +
                        "                            AND T2.ZCLX_DM NOT IN('720'," +
                        "                            '710')                           THEN T1.NYNSE                            " +
                        "                            ELSE 0                            " +
                        "                        END) AS FC_KGHNYNSE," +
                        "                        SUM(DECODE(T1.SGZT_DM," +
                        "                        '05'," +
                        "                        T1.NYNSE," +
                        "                        0)) AS FC_JGNYNSE," +
                        "                        COUNT(CASE " +
                        "                            WHEN T1.SGZT_DM = '01' " +
                        "                            AND T2.ZCLX_DM IN('720'," +
                        "                            '710')                           THEN T2.GLBM                            " +
                        "                            ELSE NULL                            " +
                        "                        END) AS FC_GTTS," +
                        "                        SUM(CASE " +
                        "                            WHEN T1.SGZT_DM = '01' " +
                        "                            AND T2.ZCLX_DM IN('720'," +
                        "                            '710')                           THEN T1.NYNSE                            " +
                        "                            ELSE 0                            " +
                        "                        END) AS FC_GTHNYNSE," +
                        "                        COUNT(DECODE(T1.SGZT_DM," +
                        "                        '04'," +
                        "                        T2.NSRMC," +
                        "                        NULL)) AS FC_GRTS," +
                        "                        SUM(DECODE(T1.SGZT_DM," +
                        "                        '04'," +
                        "                        T1.NYNSE," +
                        "                        0)) AS FC_GRNYNSE       " +
                        "                    FROM" +
                        "                        SW_DJ_FC T1        " +
                        "                    LEFT JOIN" +
                        "                        SW_DJ_JBB T2 " +
                        "                            ON T1.JBB_ID = T2.JBB_ID        " +
                        "                    LEFT JOIN" +
                        "                        SW_DJ_SY T3 " +
                        "                            ON T1.SY_ID=T3.SY_ID       " +
                        "                    WHERE" +
                        "                        T2.ZGKG_DM IS NOT NULL " +
                        "                        AND T3.SYZT<>'2' " +
                        "                        OR T3.SYZT IS NULL       " +
                        "                    GROUP BY" +
                        "                        SUBSTR(T2.ZGKG_DM," +
                        "                        2," +
                        "                        6)  " +
                        "                )T3 " +
                        "                    ON T1.DWDM = T3.DWDM  " +
                        "            LEFT JOIN" +
                        "                (" +
                        "                    SELECT" +
                        "                        SUBSTR(T2.ZGKG_DM," +
                        "                        2," +
                        "                        6) AS DWDM," +
                        "                        COUNT(CASE " +
                        "                            WHEN  T1.NZJ>0                           THEN T1.SY_ID                            " +
                        "                            ELSE NULL                            " +
                        "                        END) AS CZFCSTS," +
                        "                        SUM(CASE " +
                        "                            WHEN  T1.NZJ>0                           THEN T1.NYNSE                            " +
                        "                            ELSE 0                            " +
                        "                        END) AS CZFCNYNSE," +
                        "                        COUNT(CASE " +
                        "                            WHEN T1.SGZT_DM = '01' " +
                        "                            AND T2.ZCLX_DM NOT IN('720'," +
                        "                            '710') " +
                        "                            AND T1.NZJ>0                           THEN T2.GLBM                            " +
                        "                            ELSE NULL                            " +
                        "                        END) AS CZFC_KGHTS," +
                        "                        COUNT(CASE " +
                        "                            WHEN T1.SGZT_DM = '05'  " +
                        "                            AND T1.NZJ>0                           THEN T2.NSRMC                            " +
                        "                            ELSE NULL                            " +
                        "                        END) AS CZFC_JGDWHTS," +
                        "                        COUNT(DISTINCT(CASE " +
                        "                            WHEN T1.SGZT_DM = '01' " +
                        "                            AND T2.ZCLX_DM NOT IN('720'," +
                        "                            '710') " +
                        "                            AND T1.NZJ>0                           THEN T2.GLBM                            " +
                        "                            ELSE NULL                            " +
                        "                        END)) AS CZFC_KGH," +
                        "                        COUNT(DISTINCT(CASE " +
                        "                            WHEN T1.SGZT_DM = '05'  " +
                        "                            AND T1.NZJ>0                           THEN T2.NSRMC                            " +
                        "                            ELSE NULL                            " +
                        "                        END)) AS CZFC_JGDWH," +
                        "                        SUM(CASE " +
                        "                            WHEN T1.SGZT_DM = '01' " +
                        "                            AND T2.ZCLX_DM NOT IN('720'," +
                        "                            '710')                           THEN T1.NYNSE                            " +
                        "                            ELSE 0                            " +
                        "                        END) AS CZFC_KGHNYNSE," +
                        "                        SUM(CASE " +
                        "                            WHEN T1.SGZT_DM = '05'  " +
                        "                            AND T1.NZJ>0                           THEN T1.NYNSE                           " +
                        "                            ELSE 0                            " +
                        "                        END) AS CZFC_JGNYNSE," +
                        "                        COUNT(CASE " +
                        "                            WHEN T1.SGZT_DM = '01' " +
                        "                            AND T2.ZCLX_DM IN('720'," +
                        "                            '710') " +
                        "                            AND T1.NZJ>0                           THEN T2.GLBM                            " +
                        "                            ELSE NULL                            " +
                        "                        END) AS CZFC_GTTS," +
                        "                        SUM(CASE " +
                        "                            WHEN T1.SGZT_DM = '01' " +
                        "                            AND T2.ZCLX_DM IN('720'," +
                        "                            '710') " +
                        "                            AND T1.NZJ>0                           THEN T1.NYNSE                            " +
                        "                            ELSE 0                            " +
                        "                        END) AS CZFC_GTHNYNSE," +
                        "                        COUNT(CASE " +
                        "                            WHEN T1.SGZT_DM = '04'  " +
                        "                            AND T1.NZJ>0                           THEN T2.NSRMC                            " +
                        "                            ELSE NULL                            " +
                        "                        END) AS CZFC_GRTS," +
                        "                        SUM(CASE " +
                        "                            WHEN T1.SGZT_DM = '04'  " +
                        "                            AND T1.NZJ>0                           THEN T1.NYNSE                            " +
                        "                            ELSE NULL                            " +
                        "                        END) AS CZFC_GRNYNSE       " +
                        "                    FROM" +
                        "                        SW_DJ_FC T1        " +
                        "                    LEFT JOIN" +
                        "                        SW_DJ_JBB T2 " +
                        "                            ON T1.JBB_ID = T2.JBB_ID        " +
                        "                    LEFT JOIN" +
                        "                        SW_DJ_SY T3 " +
                        "                            ON T1.SY_ID=T3.SY_ID       " +
                        "                    WHERE" +
                        "                        T2.ZGKG_DM IS NOT NULL " +
                        "                        AND T3.SYZT<>'2' " +
                        "                        OR T3.SYZT IS NULL       " +
                        "                    GROUP BY" +
                        "                        SUBSTR(T2.ZGKG_DM," +
                        "                        2," +
                        "                        6) " +
                        "                ) T4 " +
                        "                    ON T1.DWDM = T4.DWDM  " +
                        "            LEFT JOIN" +
                        "                (" +
                        "                    SELECT" +
                        "                        SUBSTR(JBB_ZGKG_DM," +
                        "                        2," +
                        "                        6) AS DWDM," +
                        "                        COUNT(DISTINCT(CASE " +
                        "                            WHEN TO_CHAR(UPDATE_DATE," +
                        "                            'YYYYQ') >='"+beginYearQ+"' " +
                        "                            AND TO_CHAR(UPDATE_DATE," +
                        "                            'YYYYQ') <='"+endYearQ+"'                        THEN SY_ID                          " +
                        "                            ELSE NULL                          " +
                        "                        END)) AS BJGX," +
                        "                        COUNT(DISTINCT(CASE " +
                        "                            WHEN TO_CHAR(UPDATE_DATE," +
                        "                            'YYYYQ') >='"+beginYearQ+"' " +
                        "                            AND TO_CHAR(UPDATE_DATE," +
                        "                            'YYYYQ') <='"+endYearQ+"' " +
                        "                            AND TD_SGZT_DM='01'                         THEN SY_ID                          " +
                        "                            ELSE NULL                          " +
                        "                        END)) AS KGHBJGX," +
                        "                        COUNT(DISTINCT(CASE " +
                        "                            WHEN TO_CHAR(UPDATE_DATE," +
                        "                            'YYYYQ') <='"+endYearQ+"'                          THEN SY_ID                          " +
                        "                            ELSE NULL                          " +
                        "                        END)) AS LJGX," +
                        "                        COUNT(DISTINCT(CASE " +
                        "                            WHEN TO_CHAR(UPDATE_DATE," +
                        "                            'YYYYQ') <='"+endYearQ+"'                          THEN SY_ID                          " +
                        "                            ELSE NULL                          " +
                        "                        END)) AS KGHLJGX," +
                        "                        COUNT(DISTINCT(CASE " +
                        "                            WHEN FC_NZJ > 0 " +
                        "                            AND TO_CHAR(UPDATE_DATE," +
                        "                            'YYYYQ') >='"+beginYearQ+"' " +
                        "                            AND TO_CHAR(UPDATE_DATE," +
                        "                            'YYYYQ') <='"+endYearQ+"'                          THEN SY_ID                          " +
                        "                            ELSE NULL                          " +
                        "                        END)) AS NJZJNS," +
                        "                        COUNT(DISTINCT(CASE " +
                        "                            WHEN FC_NZJ > 0  " +
                        "                            AND TO_CHAR(UPDATE_DATE," +
                        "                            'YYYYQ') <='"+endYearQ+"'                          THEN SY_ID                          " +
                        "                            ELSE NULL                          " +
                        "                        END)) AS LJZJNS          " +
                        "                    FROM" +
                        "                        SW_DJ_SY_HIS      " +
                        "                    WHERE" +
                        "                        JBB_ZGKG_DM IS NOT NULL      " +
                        "                    GROUP BY" +
                        "                        SUBSTR(JBB_ZGKG_DM," +
                        "                        2," +
                        "                        6)  " +
                        "                )T5 " +
                        "                    ON  T1.DWDM = T5.DWDM  " +
                        "            LEFT JOIN" +
                        "                (" +
                        "                    SELECT" +
                        "                        SUBSTR(T3.ZGKG_DM," +
                        "                        2," +
                        "                        6) AS DWDM," +
                        "                        COUNT(DISTINCT(T2.TD_ID)) AS TD_BJXZ," +
                        "                        COUNT(DISTINCT(CASE " +
                        "                            WHEN T2.SGZT_DM='01'                         THEN T2.TD_ID                          " +
                        "                            ELSE NULL                          " +
                        "                        END)) AS TD_BJXZKGH," +
                        "                        " +
                        "                        " +
                        "                        SUM(T2.SCMJ) AS  TD_BJSCMJXZ," +
                        "                       " +
                        "                        SUM(T2.NYNSE) AS  TD_BJNYNSEXZ" +
                        "                                                                                    " +
                        "                    FROM" +
                        "                        SW_DJ_SY T1      " +
                        "                    INNER JOIN" +
                        "                        SW_DJ_TD T2 " +
                        "                            ON T1.SY_ID = T2.SY_ID      " +
                        "                    INNER JOIN" +
                        "                        SW_DJ_JBB T3 " +
                        "                            ON T2.JBB_ID = T3.JBB_ID      " +
                        "                    WHERE" +
                        "                        " +
                        "                        T1.SYZT <> '2' " +
                        "                        AND T3.ZGKG_DM IS NOT NULL " +
                        "                        AND  T2.LRRQ IS NOT NULL  " +
                        "                        AND T3.ZGKG_DM IS NOT NULL   " +
                        "                        AND T1.SY_ID NOT IN (SELECT SY_ID FROM SW_DJ_SY_HIS WHERE TO_CHAR(UPDATE_DATE," +
                        "                            'YYYYQ') <='"+endYearQ+"' AND TO_CHAR(UPDATE_DATE," +
                        "                            'YYYYQ') >='"+beginYearQ+"')  " +
                        "                        AND TO_CHAR(T2.LRRQ," +
                        "                            'YYYYQ') <='"+endYearQ+"' AND TO_CHAR(T2.LRRQ," +
                        "                            'YYYYQ') >='"+beginYearQ+"'   " +
                        "                    GROUP BY" +
                        "                        SUBSTR(T3.ZGKG_DM," +
                        "                        2," +
                        "                        6)  " +
                        "                )T6 " +
                        "                    ON  T1.DWDM = T6.DWDM  " +
                        "            LEFT JOIN" +
                        "                (" +
                        "                    SELECT" +
                        "                        SUBSTR(T3.ZGKG_DM," +
                        "                        2," +
                        "                        6) AS DWDM," +
                        "                        " +
                        "                        " +
                        "                        COUNT(DISTINCT(T2.TD_ID)) AS TD_LJXZ," +
                        "                        COUNT(DISTINCT(CASE WHEN T2.SGZT_DM='01'                         THEN T2.TD_ID                          " +
                        "                            ELSE NULL                          " +
                        "                        END)) AS TD_LJXZKHG," +
                        "                        " +
                        "                        SUM(T2.SCMJ) AS  TD_LJSCMJXZ," +
                        "                        " +
                        "                        SUM(T2.NYNSE) AS  TD_LJNYNSEXZ                                                                " +
                        "                    FROM" +
                        "                        SW_DJ_SY T1      " +
                        "                    INNER JOIN" +
                        "                        SW_DJ_TD T2 " +
                        "                            ON T1.SY_ID = T2.SY_ID      " +
                        "                    INNER JOIN" +
                        "                        SW_DJ_JBB T3 " +
                        "                            ON T2.JBB_ID = T3.JBB_ID      " +
                        "                    WHERE" +
                        "                        T1.SYZT <> '2' " +
                        "                        AND T3.ZGKG_DM IS NOT NULL " +
                        "                        AND  T2.LRRQ IS NOT NULL " +
                        "                        AND T1.SY_ID NOT IN (SELECT SY_ID FROM SW_DJ_SY_HIS WHERE TO_CHAR(UPDATE_DATE," +
                        "                            'YYYYQ') <='"+endYearQ+"' ) " +
                        "                        AND TO_CHAR(T2.LRRQ," +
                        "                            'YYYYQ') <='"+endYearQ+"'      " +
                        "                    GROUP BY" +
                        "                        SUBSTR(T3.ZGKG_DM," +
                        "                        2," +
                        "                        6)  " +
                        "                )T7 " +
                        "                    ON  T1.DWDM = T7.DWDM         " +
                        "            LEFT JOIN" +
                        "                (" +
                        "                    SELECT" +
                        "                        SUBSTR(T3.ZGKG_DM," +
                        "                        2," +
                        "                        6) AS DWDM," +
                        "                        COUNT(DISTINCT(T2.FC_ID)) AS FC_BJXZ," +
                        "                        COUNT(DISTINCT(CASE " +
                        "                            WHEN T4.SGZT_DM='01'                         THEN T2.FC_ID                          " +
                        "                            ELSE NULL                          " +
                        "                        END)) AS FC_BJXZKGH," +
                        "                        COUNT(DISTINCT(CASE " +
                        "                            WHEN T2.NZJ>0                         THEN T2.FC_ID                          " +
                        "                            ELSE NULL                          " +
                        "                        END)) AS FC_BJXZCZ," +
                        "                        " +
                        "                        SUM(T2.FCYZ) AS  FC_BJFCYZXZ," +
                        "                        SUM(T2.NYNSE) AS  FC_BJNYNSEXZ," +
                        "                       " +
                        "                        SUM(T2.NZJ) AS  FC_BJNZJXZ" +
                        "                                                                                                              " +
                        "                    FROM" +
                        "                        SW_DJ_SY T1      " +
                        "                    INNER JOIN" +
                        "                        SW_DJ_FC T2 " +
                        "                            ON T1.SY_ID = T2.SY_ID      " +
                        "                    INNER JOIN" +
                        "                        SW_DJ_TD T4 " +
                        "                            ON T1.SY_ID = T4.SY_ID      " +
                        "                    INNER JOIN" +
                        "                        SW_DJ_JBB T3 " +
                        "                            ON T2.JBB_ID = T3.JBB_ID      " +
                        "                    WHERE" +
                        "                        T1.SYZT <> '2' " +
                        "                        AND T3.ZGKG_DM IS NOT NULL   " +
                        "                        AND T1.SY_ID NOT IN (SELECT SY_ID FROM SW_DJ_SY_HIS WHERE TO_CHAR(UPDATE_DATE," +
                        "                            'YYYYQ') <='"+endYearQ+"' AND TO_CHAR(UPDATE_DATE," +
                        "                            'YYYYQ') >='"+beginYearQ+"')" +
                        "                        AND TO_CHAR(T2.LRRQ," +
                        "                            'YYYYQ') <='"+endYearQ+"' AND TO_CHAR(T2.LRRQ," +
                        "                            'YYYYQ') >='"+beginYearQ+"'           " +
                        "                    GROUP BY" +
                        "                        SUBSTR(T3.ZGKG_DM," +
                        "                        2," +
                        "                        6) " +
                        "                )T8 " +
                        "                    ON T1.DWDM=T8.DWDM " +
                        "              LEFT JOIN" +
                        "                (" +
                        "                    SELECT" +
                        "                        SUBSTR(T3.ZGKG_DM," +
                        "                        2," +
                        "                        6) AS DWDM," +
                        "                        COUNT(DISTINCT(T2.FC_ID)) AS FC_LJXZ," +
                        "                        COUNT(DISTINCT(CASE " +
                        "                            WHEN T4.SGZT_DM='01'                         THEN T2.FC_ID                          " +
                        "                            ELSE NULL                          " +
                        "                        END)) AS FC_LJXZKGH," +
                        "                        COUNT(DISTINCT(CASE " +
                        "                            WHEN  T2.NZJ>0                         THEN T2.FC_ID                          " +
                        "                            ELSE NULL                          " +
                        "                        END)) AS FC_LJXZCZ," +
                        "                       " +
                        "                        SUM(T2.FCYZ) AS  FC_LJFCYZXZ," +
                        "                        " +
                        "                        SUM(T2.NYNSE) AS  FC_LJNYNSEXZ ," +
                        "                        " +
                        "                        SUM( T2.NZJ                          " +
                        "                           ) AS  FC_LJNZJXZ                                                                                       " +
                        "                    FROM" +
                        "                        SW_DJ_SY T1      " +
                        "                    INNER JOIN" +
                        "                        SW_DJ_FC T2 " +
                        "                            ON T1.SY_ID = T2.SY_ID      " +
                        "                    INNER JOIN" +
                        "                        SW_DJ_TD T4 " +
                        "                            ON T1.SY_ID = T4.SY_ID      " +
                        "                    INNER JOIN" +
                        "                        SW_DJ_JBB T3 " +
                        "                            ON T2.JBB_ID = T3.JBB_ID      " +
                        "                    WHERE" +
                        "                        T1.SYZT <> '2' " +
                        "                        AND T3.ZGKG_DM IS NOT NULL   " +
                        "                         AND T3.ZGKG_DM IS NOT NULL   " +
                        "                        AND T1.SY_ID NOT IN (SELECT SY_ID FROM SW_DJ_SY_HIS WHERE TO_CHAR(UPDATE_DATE," +
                        "                            'YYYYQ') <='"+endYearQ+"' )" +
                        "                        AND TO_CHAR(T2.LRRQ," +
                        "                            'YYYYQ') <='"+endYearQ+"'  " +
                        "                    GROUP BY" +
                        "                        SUBSTR(T3.ZGKG_DM," +
                        "                        2," +
                        "                        6) " +
                        "                )T9 " +
                        "                    ON T1.DWDM=T9.DWDM " +
                        "            LEFT JOIN" +
                        "                (" +
                        "                    SELECT" +
                        "                        SUBSTR(T1.JBB_ZGKG_DM," +
                        "                        2," +
                        "                        6) AS DWDM," +
                        "                        SUM(T1.TD_SCMJ-NVL(T2.TD_SCMJ," +
                        "                            0)) AS BJSCMJBH," +
                        "                        SUM(T1.TD_NYNSE-NVL(T2.TD_NYNSE," +
                        "                            0)) AS BJNYNSEBH," +
                        "                        SUM(T1.FC_FCYZ-NVL(T2.FC_FCYZ," +
                        "                            0)) AS BJFCYZBH," +
                        "                        SUM(T1.FC_NYNSE-NVL(T2.FC_NYNSE," +
                        "                            0)) AS BJFCNYNSEBH," +
                        "                        SUM(T1.FC_NZJ-NVL(T2.FC_NZJ," +
                        "                            0)) AS BJFCNZJBH" +
                        "                        " +
                        "                    FROM" +
                        "                        (SELECT" +
                        "                            * " +
                        "                        FROM" +
                        "                            (select" +
                        "                                RANK() OVER(PARTITION " +
                        "                            BY" +
                        "                                SY_ID " +
                        "                            ORDER BY" +
                        "                                T.UPDATE_DATE DESC) AS PM," +
                        "                                T.* " +
                        "                            FROM" +
                        "                                SW_DJ_SY_HIS T WHERE TO_CHAR(UPDATE_DATE," +
                        "                            'YYYYQ') <='"+endYearQ+"' AND TO_CHAR(UPDATE_DATE," +
                        "                            'YYYYQ') >='"+beginYearQ+"') " +
                        "                        WHERE" +
                        "                            PM=1 " +
                        "                        )T1      " +
                        "                    LEFT JOIN" +
                        "                        (" +
                        "                            SELECT" +
                        "                                * " +
                        "                            FROM" +
                        "                                (select" +
                        "                                    RANK() OVER(PARTITION " +
                        "                                BY" +
                        "                                    SY_ID " +
                        "                                ORDER BY" +
                        "                                    T.XGRQ ASC) AS PM," +
                        "                                    T.* " +
                        "                                FROM" +
                        "                                    SW_DJ_SY_HIS T where TO_CHAR(XGRQ," +
                        "                            'YYYYQ') <='"+endYearQ+"' AND TO_CHAR(XGRQ," +
                        "                            'YYYYQ') >='"+beginYearQ+"') " +
                        "                            WHERE" +
                        "                                PM=1 ）T2 " +
                        "                                    ON T2.SY_ID=T1.SY_ID        " +
                        "                            WHERE" +
                        "                                T1.JBB_ZGKG_DM IS NOT NULL        " +
                        "                            GROUP BY" +
                        "                                SUBSTR(T1.JBB_ZGKG_DM," +
                        "                                2," +
                        "                                6))T10 " +
                        "                                    ON T1.DWDM=T10.DWDM" +
                        "                LEFT JOIN" +
                        "                (" +
                        "                    SELECT" +
                        "                        SUBSTR(T1.JBB_ZGKG_DM," +
                        "                        2," +
                        "                        6) AS DWDM," +
                        "                        SUM(T1.TD_SCMJ-NVL(T2.TD_SCMJ," +
                        "                            0)) AS LJSCMJBH," +
                        "                        SUM(T1.TD_NYNSE-NVL(T2.TD_NYNSE," +
                        "                            0)) AS LJNYNSEBH," +
                        "                        SUM(T1.FC_FCYZ-NVL(T2.FC_FCYZ," +
                        "                            0)) AS LJFCYZBH," +
                        "                        SUM(T1.FC_NYNSE-NVL(T2.FC_NYNSE," +
                        "                            0)) AS LJFCNYNSEBH," +
                        "                        SUM(T1.FC_NZJ-NVL(T2.FC_NZJ," +
                        "                            0)) AS LJFCNZJBH       " +
                        "                    FROM" +
                        "                        (SELECT" +
                        "                            * " +
                        "                        FROM" +
                        "                            (select" +
                        "                                RANK() OVER(PARTITION " +
                        "                            BY" +
                        "                                SY_ID " +
                        "                            ORDER BY" +
                        "                                T.UPDATE_DATE DESC) AS PM," +
                        "                                T.* " +
                        "                            FROM" +
                        "                                SW_DJ_SY_HIS T where TO_CHAR(UPDATE_DATE," +
                        "                            'YYYYQ') <='"+endYearQ+"') " +
                        "                        WHERE" +
                        "                            PM=1 " +
                        "                        )T1      " +
                        "                    LEFT JOIN" +
                        "                        (" +
                        "                            SELECT" +
                        "                                * " +
                        "                            FROM" +
                        "                                (select" +
                        "                                    RANK() OVER(PARTITION " +
                        "                                BY" +
                        "                                    SY_ID " +
                        "                                ORDER BY" +
                        "                                    T.XGRQ ASC) AS PM," +
                        "                                    T.* " +
                        "                                FROM" +
                        "                                    SW_DJ_SY_HIS T where TO_CHAR(XGRQ," +
                        "                            'YYYYQ') <='"+endYearQ+"') " +
                        "                            WHERE" +
                        "                                PM=1 ）T2 " +
                        "                                    ON T2.SY_ID=T1.SY_ID        " +
                        "                            WHERE" +
                        "                                T1.JBB_ZGKG_DM IS NOT NULL        " +
                        "                            GROUP BY" +
                        "                                SUBSTR(T1.JBB_ZGKG_DM," +
                        "                                2," +
                        "                                6))T11 " +
                        "                                    ON T1.DWDM=T11.DWDM                " +
                        "                           )        " +
                        "                            " +
                        "                    GROUP BY" +
                        "                        ROLLUP(DWMC)) T1 " +
                        "                    LEFT JOIN" +
                        "                        SW_JS_ZGH T2 " +
                        "                            ON T1.DWMC=T2.DWMC  " +orderSql;


                Query query = baseRepository.getEntityManager().createNativeQuery(sql);
                query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
                return query.getResultList();
        }



    @Override
    public List<SyxxtjbQuery> syxxTjbJson(String id){
        String regionCode = "";
        int length = 0;//sql中substr  zgkg_dm 截取的长度
        try {
            regionCode = SessionUtil.getCurrentUser().getRegionCode();
        }catch (Exception e){}
        String openTree;//用于返回结果中判断是否展开
        if(id ==null){//第一次展示树
            openTree = "closed";
            length = regionCode.length();

        }else{//展开树

            //id长度小于等于2时为省级单位，有孙子节点
            if(id.length()<=2){
                openTree = "closed";
            }else{//id长度大于4时树没有子节点
                openTree = "open";
            }

            //由传入id查找其子节点信息
            regionCode = id+"__";//sql中 where条件  查询dwdm子节点
            length = id.length()+2;
        }

        List<SyxxtjbQuery> result = syxxtjbResult(regionCode, openTree, length);
        return  result;
    }

    private List<SyxxtjbQuery> syxxtjbResult(String regionCode,String openTree,int length){
        List<SyxxtjbQuery> result = new ArrayList<SyxxtjbQuery>();
        String sql = "select * from syxxtjb t where t.dwdm like '"+regionCode+"'  order by t.serialnumber,t.dwdm";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();

        if(CollectionUtils.isNotEmpty(list)) {
                for (HashMap tempMap : list) {
                SyxxtjbQuery syxxtjbQuery = new SyxxtjbQuery();
                syxxtjbQuery.setDwdm(String.valueOf(tempMap.get("DWDM")));
                syxxtjbQuery.setDwmc(String.valueOf(tempMap.get("DWMC")));
                syxxtjbQuery.setGtzdxx(String.valueOf(tempMap.get("GTZDXX")));
                syxxtjbQuery.setSyzs(String.valueOf(tempMap.get("SYZS")));
                syxxtjbQuery.setKghsys(String.valueOf(tempMap.get("KGHSYS")));
                syxxtjbQuery.setLzlghsys(String.valueOf(tempMap.get("LZLGHSYS")));
                syxxtjbQuery.setKzhsyhsys(String.valueOf(tempMap.get("KZHSYHSYS")));
                syxxtjbQuery.setJgdwsys(String.valueOf(tempMap.get("JGDWSYS")));
                syxxtjbQuery.setGrsys(String.valueOf(tempMap.get("GRSYS")));
                syxxtjbQuery.setSyhcmj(String.valueOf(tempMap.get("SYHCMJ")));
                syxxtjbQuery.setMsmj(String.valueOf(tempMap.get("MSMJ")));
                syxxtjbQuery.setYsmj(String.valueOf(tempMap.get("YSMJ")));
                syxxtjbQuery.setTdnynse(String.valueOf(tempMap.get("TDNYNSE")));
                syxxtjbQuery.setFcyz(String.valueOf(tempMap.get("FCYZ")));
                syxxtjbQuery.setFcyz_ys(String.valueOf(tempMap.get("FCYZ_YS")));
                syxxtjbQuery.setFcyz_ms(String.valueOf(tempMap.get("FCYZ_MS")));
                syxxtjbQuery.setYnse_zy(String.valueOf(tempMap.get("YNSE_ZY")));
                syxxtjbQuery.setYnse_cz(String.valueOf(tempMap.get("YNSE_CZ")));
                syxxtjbQuery.setFcnynse(String.valueOf(tempMap.get("FCNYNSE")));
                syxxtjbQuery.setState(openTree);
                result.add(syxxtjbQuery);
            }
        }
        return result;
    }

    //税源信息统计表-之前查sql用的逻辑
    /*public List<SyxxtjbQuery> syxxtjbQueryResult(String regionCode, String openTree, int length){
        List<SyxxtjbQuery> result = new ArrayList<SyxxtjbQuery>();
        //单位代码，单位名称
        String sql = "select " +
                "dwxx.dwdm,dwxx.dwmc,nvl(gtzdxx.gtzdxx,0)as gtzdxx,nvl(syzs.syzs,0)as syzs,nvl(kghsys.kghsys,0)as kghsys,nvl(lzlghsys.lzlghsys,0)as lzlghsys,nvl(kzhsyhsys.kzhsyhsys,0)as kzhsyhsys,nvl(jgdwsys,0)as jgdwsys,nvl(grsys,0)as grsys," +
                "nvl(td.syhcmj,0)as syhcmj,nvl(td.msmj,0)as msmj,nvl(td.ysmj,0)as ysmj,nvl(td.tdnynse,0)as tdnynse," +
                "nvl(fc.fcyz,0)as fcyz,nvl(fc.fcyz_ys,0)as fcyz_ys,nvl(fc.fcyz_ms,0)as fcyz_ms,nvl(fc.ynse_zy,0)as ynse_zy,nvl(fc.ynse_cz,0)as ynse_cz,nvl(fc.fcnynse,0)as fcnynse " +
                " from " +
                " SW_JS_ZGH dwxx ";

        //国土宗地信息
        sql += " left join (select dwdm, " +
                "        count(*) as gtzdxx" +
                "    from" +
                "        (select" +
                "            count(*),substr( t4.zgkg_dm,2,"+length+") dwdm " +
                "        from" +
                "            sw_dj_td t1 " +
                "        left join" +
                "            sw_dj_sy t2 " +
                "                on t1.sy_id=t2.sy_id " +
                "        left join" +
                "            zd t3 " +
                "                on t3.djh=t2.djh " +
                "        left join" +
                "            sw_dj_xmxx t7 " +
                "                on t7.xm_id=t2.gd_id  " +
                "                and t3.djh is not null " +
                "                and t3.djh not like '%999999%'　left " +
                "        join" +
                "            sw_dj_jbb t4 " +
                "                on t4.jbb_id=t1.jbb_id " +
                "        where" +
                "            (" +
                "                t2.syzt='1' " +
                "                or t2.syzt is null" +
                "            )  " +
                "            and (" +
                "                t4.zgkg_dm like '2"+regionCode+"%' " +
                "            )  " +
                "        group by" +
                "            t3.djh,substr( t4.zgkg_dm,2,"+length+"))" +
                "        group by dwdm " +
                "            ) gtzdxx    " +
                "on gtzdxx.dwdm =  dwxx.Dwdm";

        //税源总数
        sql += " left join (select  substr(t4.zgkg_dm,2,"+length+") dwdm," +
                "        count(*) as syzs " +
                "    from" +
                "        sw_dj_td t1 " +
                "    left join" +
                "        sw_dj_sy t2 " +
                "            on t1.sy_id=t2.sy_id " +
                "    left join" +
                "        zd t3 " +
                "            on t3.djh=t2.djh " +
                "    left join" +
                "        sw_dj_xmxx t7 " +
                "            on t7.xm_id=t2.gd_id  " +
                "            and t3.djh is not null " +
                "            and t3.djh not like '%999999%'　left " +
                "    join" +
                "        sw_dj_jbb t4 " +
                "            on t4.jbb_id=t1.jbb_id " +
                "    where" +
                "        (" +
                "            t2.syzt='1' " +
                "            or t2.syzt is null" +
                "        )  " +
                "        and (" +
                "            t4.zgkg_dm like '2"+regionCode+"%' " +
                "        ) group by substr(t4.zgkg_dm,2,"+length+") " +
                " )syzs " +
                "on syzs.dwdm =  dwxx.Dwdm";
        //控管户税源数
        sql+=" left join (" +
                "  select substr(t4.zgkg_dm,2,"+length+") as dwdm, " +
                "  count(*) kghsys" +
                "  from" +
                "  sw_dj_td t1 " +
                "  left join" +
                "  sw_dj_sy t2 " +
                "  on t1.sy_id=t2.sy_id " +
                "  left join" +
                "  zd t3 " +
                "  on t3.djh=t2.djh " +
                "  left join" +
                "  sw_dj_xmxx t7 " +
                "  on t7.xm_id=t2.gd_id  " +
                "  and t3.djh is not null " +
                "  and t3.djh not like '%999999%'　" +
                "  left  join" +
                "  sw_dj_jbb t4 " +
                "  on t4.jbb_id=t1.jbb_id " +
                "    where" +
                "        (" +
                "            t2.syzt='1' " +
                "            or t2.syzt is null" +
                "        )  " +
                "        and (" +
                "            t4.zgkg_dm like '2"+regionCode+"%' " +
                "        )  " +
                "        and t1.sgzt_dm='01'  group by substr(t4.zgkg_dm,2,"+length+") )kghsys " +
                " on kghsys.dwdm =  dwxx.Dwdm ";

        //漏征漏管户税源数
        sql+=" left join (" +
                "  select substr(t4.zgkg_dm,2,"+length+") as dwdm," +
                "  count(*) lzlghsys" +
                "  from" +
                "  sw_dj_td t1 " +
                "  left join" +
                "  sw_dj_sy t2 " +
                "  on t1.sy_id=t2.sy_id " +
                "  left join" +
                "  zd t3 " +
                "  on t3.djh=t2.djh " +
                "  left join" +
                "  sw_dj_xmxx t7 " +
                "  on t7.xm_id=t2.gd_id  " +
                "  and t3.djh is not null " +
                "  and t3.djh not like '%999999%'　" +
                "  left  join" +
                "  sw_dj_jbb t4 " +
                "  on t4.jbb_id=t1.jbb_id " +
                "    where" +
                "        (" +
                "            t2.syzt='1' " +
                "            or t2.syzt is null" +
                "        )  " +
                "        and (" +
                "            t4.zgkg_dm like '2"+regionCode+"%' " +
                "        )  " +
                "        and t1.sgzt_dm='02' group by substr(t4.zgkg_dm,2,"+length+") )lzlghsys " +
                " on lzlghsys.dwdm =  dwxx.Dwdm ";
        //可转化税源户税源数
        sql+=" left join (" +
                "  select substr(t4.zgkg_dm,2,"+length+") as dwdm," +
                "  count(*) kzhsyhsys" +
                "  from" +
                "  sw_dj_td t1 " +
                "  left join" +
                "  sw_dj_sy t2 " +
                "  on t1.sy_id=t2.sy_id " +
                "  left join" +
                "  zd t3 " +
                "  on t3.djh=t2.djh " +
                "  left join" +
                "  sw_dj_xmxx t7 " +
                "  on t7.xm_id=t2.gd_id  " +
                "  and t3.djh is not null " +
                "  and t3.djh not like '%999999%'　" +
                "  left  join" +
                "  sw_dj_jbb t4 " +
                "  on t4.jbb_id=t1.jbb_id " +
                "    where" +
                "        (" +
                "            t2.syzt='1' " +
                "            or t2.syzt is null" +
                "        )  " +
                "        and (" +
                "            t4.zgkg_dm like '2"+regionCode+"%' " +
                "        )  " +
                "        and t1.sgzt_dm='03' group by substr(t4.zgkg_dm,2,"+length+"))kzhsyhsys " +
                " on kzhsyhsys.dwdm =  dwxx.Dwdm ";
        //机关单位税源数
        sql+=" left join (" +
                "  select substr(t4.zgkg_dm,2,"+length+") as dwdm," +
                "  count(*) jgdwsys" +
                "  from" +
                "  sw_dj_td t1 " +
                "  left join" +
                "  sw_dj_sy t2 " +
                "  on t1.sy_id=t2.sy_id " +
                "  left join" +
                "  zd t3 " +
                "  on t3.djh=t2.djh " +
                "  left join" +
                "  sw_dj_xmxx t7 " +
                "  on t7.xm_id=t2.gd_id  " +
                "  and t3.djh is not null " +
                "  and t3.djh not like '%999999%'　" +
                "  left  join" +
                "  sw_dj_jbb t4 " +
                "  on t4.jbb_id=t1.jbb_id " +
                "    where" +
                "        (" +
                "            t2.syzt='1' " +
                "            or t2.syzt is null" +
                "        )  " +
                "        and (" +
                "            t4.zgkg_dm like '2"+regionCode+"%' " +
                "        )  " +
                "        and t1.sgzt_dm='05' group by substr(t4.zgkg_dm,2,"+length+") )jgdwsys " +
                " on jgdwsys.dwdm =  dwxx.Dwdm ";

        //个人税源数
        sql+=" left join (" +
                "  select substr(t4.zgkg_dm,2,"+length+") as dwdm," +
                "  count(*) grsys" +
                "  from" +
                "  sw_dj_td t1 " +
                "  left join" +
                "  sw_dj_sy t2 " +
                "  on t1.sy_id=t2.sy_id " +
                "  left join" +
                "  zd t3 " +
                "  on t3.djh=t2.djh " +
                "  left join" +
                "  sw_dj_xmxx t7 " +
                "  on t7.xm_id=t2.gd_id  " +
                "  and t3.djh is not null " +
                "  and t3.djh not like '%999999%'　" +
                "  left  join" +
                "  sw_dj_jbb t4 " +
                "  on t4.jbb_id=t1.jbb_id " +
                "    where" +
                "        (" +
                "            t2.syzt='1' " +
                "            or t2.syzt is null" +
                "        )  " +
                "        and (" +
                "            t4.zgkg_dm like '2"+regionCode+"%' " +
                "        )  " +
                "        and t1.sgzt_dm='04' group by substr(t4.zgkg_dm,2,"+length+"))grsys " +
                " on grsys.dwdm =  dwxx.Dwdm ";
        //城镇土地使用税信息
        sql+="        left join (select substr(t4.zgkg_dm,2,"+length+")as dwdm," +
                "        sum(nvl(t1.scmj," +
                "        0))syhcmj," +
                "        sum(nvl(t1.msmj," +
                "        0))msmj," +
                "        sum(nvl(t1.ynmj," +
                "        0))ysmj," +
                "        sum(nvl(t1.nynse," +
                "        0))tdnynse " +
                "    from" +
                "        sw_dj_td t1  " +
                "    left join" +
                "        sw_dj_sy t2 " +
                "            on t1.sy_id=t2.sy_id " +
                "    left join" +
                "        zd t3 " +
                "            on t3.djh=t2.djh " +
                "    left join" +
                "        sw_dj_jbb t4 " +
                "            on t4.jbb_id=t1.jbb_id " +
                "    left join" +
                "        sw_dj_xmxx t7 " +
                "            on t7.xm_id=t2.gd_id " +
                "    where" +
                "        (" +
                "            t2.syzt='1' " +
                "            or t2.syzt is null" +
                "        )  " +
                "        and t4.zgkg_dm like '2"+regionCode+"%' group by substr(t4.zgkg_dm,2,"+length+")) td " +
                "        on td.dwdm = dwxx.dwdm ";
        //房产税
        sql+="left join (select" +
                "         substr(t4.zgkg_dm,2,"+length+") as dwdm," +
                "        sum(nvl(t1.fcyz," +
                "        0))fcyz," +
                "        sum(nvl(t1.fcyz_ys," +
                "        0))fcyz_ys," +
                "        sum(nvl(t1.fcyz_ms," +
                "        0))fcyz_ms," +
                "        sum(nvl(t1.ynse_zy," +
                "        0))ynse_zy," +
                "        sum(nvl(t1.ynse_cz," +
                "        0))ynse_cz," +
                "        sum(nvl(t1.nynse," +
                "        0))fcnynse " +
                "    from" +
                "        sw_dj_fc t1  " +
                "    left join" +
                "        sw_dj_sy t2 " +
                "            on t1.sy_id=t2.sy_id " +
                "    left join" +
                "        zd t3 " +
                "            on t3.djh=t2.djh " +
                "    left join" +
                "        sw_dj_td t5 " +
                "            on t5.sy_id=t2.sy_id " +
                "    left join" +
                "        sw_dj_jbb t4 " +
                "            on t4.jbb_id=t5.jbb_id " +
                "    left join" +
                "        sw_dj_xmxx t7 " +
                "            on t7.xm_id=t2.gd_id " +
                "    where" +
                "        (" +
                "            t2.syzt='1' " +
                "            or t2.syzt is null" +
                "        )  " +
                "        and t4.zgkg_dm like '2"+regionCode+"%' group by substr(t4.zgkg_dm,2,"+length+") )fc" +
                "        on fc.dwdm = dwxx.dwdm";

        //where条件
        sql += " where dwxx.dwdm like '"+regionCode+"' order by serialnumber,dwdm";

        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();

        if(CollectionUtils.isNotEmpty(list)) {
            for (HashMap tempMap : list) {
                SyxxtjbQuery syxxtjbQuery = new SyxxtjbQuery();
                syxxtjbQuery.setDwdm(String.valueOf(tempMap.get("DWDM")));
                syxxtjbQuery.setDwmc(String.valueOf(tempMap.get("DWMC")));
                syxxtjbQuery.setGtzdxx(String.valueOf(tempMap.get("GTZDXX")));
                syxxtjbQuery.setSyzs(String.valueOf(tempMap.get("SYZS")));
                syxxtjbQuery.setKghsys(String.valueOf(tempMap.get("KGHSYS")));
                syxxtjbQuery.setLzlghsys(String.valueOf(tempMap.get("LZLGHSYS")));
                syxxtjbQuery.setKzhsyhsys(String.valueOf(tempMap.get("KZHSYHSYS")));
                syxxtjbQuery.setJgdwsys(String.valueOf(tempMap.get("JGDWSYS")));
                syxxtjbQuery.setGrsys(String.valueOf(tempMap.get("GRSYS")));
                syxxtjbQuery.setSyhcmj(String.valueOf(tempMap.get("SYHCMJ")));
                syxxtjbQuery.setMsmj(String.valueOf(tempMap.get("MSMJ")));
                syxxtjbQuery.setYsmj(String.valueOf(tempMap.get("YSMJ")));
                syxxtjbQuery.setTdnynse(String.valueOf(tempMap.get("TDNYNSE")));
                syxxtjbQuery.setFcyz(String.valueOf(tempMap.get("FCYZ")));
                syxxtjbQuery.setFcyz_ys(String.valueOf(tempMap.get("FCYZ_YS")));
                syxxtjbQuery.setFcyz_ms(String.valueOf(tempMap.get("FCYZ_MS")));
                syxxtjbQuery.setYnse_zy(String.valueOf(tempMap.get("YNSE_ZY")));
                syxxtjbQuery.setYnse_cz(String.valueOf(tempMap.get("YNSE_CZ")));
                syxxtjbQuery.setFcnynse(String.valueOf(tempMap.get("FCNYNSE")));
                syxxtjbQuery.setState(openTree);
                result.add(syxxtjbQuery);
            }
        }
        return result;
    }*/

    @Override
    @Transactional(readOnly = true)
    public List<HashMap<String, Object>> tdsFxList(String regionCode){
        int regionCodeLength = regionCode.length();
        int regionLen = 0;
        if(regionCodeLength==2){
            regionLen = 4;
        }else if(regionCodeLength==4){
            regionLen = 6;
        }
        String sql = "SELECT * FROM symap WHERE REGION_CODE LIKE '"+ regionCode +"%' AND LENGTH(REGION_CODE) = " + regionLen ;
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        return list;
    }

    @Override
    public List<SDmDwxxCz> getCityList() {
        List<SDmDwxxCz> allDwxxList =  dwxxServiceImpl.getAllDwxx();
        List<SDmDwxxCz> qxDwxxList = new ArrayList<SDmDwxxCz>();
        for(SDmDwxxCz tempVo : allDwxxList){
            if(tempVo.getDwdm().length()==4){
                qxDwxxList.add(tempVo);
            }
        }
        return qxDwxxList;
    }





    private List getSumseByRegionCode(int regionCodeLength){
        int zgkgLen = 0;
        Number sumTds = 0;
        Number sumFcs = 0;
        if(regionCodeLength==2){
            zgkgLen = 2;
        }else if(regionCodeLength==4){
            zgkgLen = 4;
        }
        String sql =
                "SELECT" +
                        "               B.DM," +
                        "               round(NVL(B.NYNSE, 0), 2) AS SUMTDS," +
                        "               round(NVL(C.NYNSE, 0),2) AS SUMFCS" +
                        "          FROM" +
                        "                  (SELECT SUBSTR(t3.ZGKG_DM, 2, "+zgkgLen+") AS DM,  SUM(NVL(t1.NYNSE, 0)) AS NYNSE" +
                        "                    FROM SW_DJ_TD t1" +
                        "                      LEFT JOIN SW_DJ_SY t2 ON t1.SY_ID = t2.SY_ID" +
                        "                      LEFT JOIN SW_DJ_JBB t3 ON t1.JBB_ID = t3.JBB_ID" +
                        "                    WHERE t2.SYZT IS NULL" +
                        "                      OR t2.SYZT = '1'" +
                        "                    GROUP BY SUBSTR(t3.ZGKG_DM, 2, "+zgkgLen+"))" +
                        "            B" +
                        "             LEFT JOIN" +
                        "                  (SELECT SUBSTR(t3.ZGKG_DM, 2, "+zgkgLen+") AS DM,  SUM(NVL(t1.NYNSE, 0)) AS NYNSE" +
                        "                    FROM SW_DJ_FC t1" +
                        "                      LEFT JOIN SW_DJ_SY t2 ON t1.SY_ID = t2.SY_ID" +
                        "                      LEFT JOIN SW_DJ_JBB t3 ON t1.JBB_ID = t3.JBB_ID" +
                        "                    WHERE t2.SYZT IS NULL" +
                        "                      OR t2.SYZT = '1'" +
                        "                    GROUP BY SUBSTR(t3.ZGKG_DM, 2, "+zgkgLen+"))" +
                        "             C" +
                        "                    ON B.DM = C.DM" +
                        "             WHERE  B.DM IS NOT NULL";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        return list;
    }
}
