package cn.gtmap.landtax.service.impl;

import cn.gtmap.landtax.entity.*;
import cn.gtmap.landtax.model.dictionary.Czlx;
import cn.gtmap.landtax.model.dictionary.Sylx;
import cn.gtmap.landtax.model.query.SwDjSyQuery;
import cn.gtmap.landtax.service.MsrdService;
import cn.gtmap.landtax.service.SwdjSyHisService;
import cn.gtmap.landtax.service.TaxService;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.PlatUtil;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.web.SessionUtil;
import com.mysema.query.jpa.JPQLQuery;
import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.types.Projections;
import com.mysema.query.types.QBean;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;

import javax.persistence.Query;
import javax.swing.*;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.*;

/**
 * Created by xuchao on 2014/9/25.
 */
@Service
public class MsrdServiceImpl implements MsrdService{
    private static final String MSRD_TD_PREFIX="土地税免税认定";
    private static final String MSRD_TD_WORKFLOW_CONFIG="msrd_td";
    private static final String MSRD_FC_PREFIX="房产税免税认定";
    private static final String MSRD_FC_WORKFLOW_CONFIG="msrd_fc";
    private final BigDecimal lv = new BigDecimal(0.0084);
    @Autowired
    BaseRepository baseRepository;
    @Autowired
    PlatUtil platUtil;
    @Autowired
    TaxService taxService;
    @Autowired
    SwdjSyHisService swdjSyHisService;

    //创建免税认定工作流
    @Override
    @Transactional(value="oracle_common")
    public String createMsrdWorkflow(String sylx, String tdId, String fcId,String syId ) {
        String msg = "1";
        String taskId = "";
        BigDecimal str =null;
        SwDjSy swDjSy = taxService.getSwDjSyById(syId);
        if(StringUtils.isNotBlank(sylx) && sylx.trim().equals(Sylx.TDSY.toString()) && StringUtils.isNotBlank(tdId)){//土地税免税认定
            SwDjTd swDjTd = baseRepository.get(SwDjTd.class,tdId);

            //创建工作流
            String wdid = AppConfig.getProperty(MSRD_TD_WORKFLOW_CONFIG);
            String proId = UUIDGenerator.generate();
            Project project = new Project();
            project.setProjectId(proId);
            project.setWdid(wdid);
            String userId = SessionUtil.getCurrentUserId();
            String proName = MSRD_TD_PREFIX+"_"+swDjTd.getSwDjJbb().getNsrmc();
            //
            Set set = swDjSy.getSwDjSyHisSet();
            Iterator i = set.iterator();//先迭代出来
            while(i.hasNext()){//遍历
                SwDjSyHis swDjSyHis = (SwDjSyHis)i.next();
                String rwid =swDjSyHis.getRwid();
                String sqlSyxg = "select workflow_state from PF_WORKFLOW_INSTANCE  where workflow_instance_id ='"+rwid+"'";
                Query query = baseRepository.getEntityManager().createNativeQuery(sqlSyxg);
                query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
                List<HashMap<String, Object>> listSyxg = null;
                listSyxg = query.getResultList();
                if(listSyxg.isEmpty()){
                    continue;
                }
                else{
                    HashMap<String ,Object> hashMap =(HashMap)listSyxg.get(0);
                    str= (BigDecimal)hashMap.get("WORKFLOW_STATE");
                    String str1 =str.toString();
                    if("2".equals(str1)){
                        continue;
                    }else{
                        msg ="2";
                        break;
                    }
                }
            }

            //往sw_msrd_td表插入数据
            //    if(StringUtils.isNotBlank(taskId)){
            //根据td_msrd_id 从sw_msrd_td表中来获取到td_id 办理状态是0的(0是办理中，1是已经办结的)
//                String td_msrd_id =UUIDGenerator.generate();
//                String sqlSyxg = "select TD_ID from sw_msrd_td  where TD_MSRD_ID ='"+td_msrd_id+"'and TD_BLZT='0'";
//                Query query = baseRepository.getEntityManager().createNativeQuery(sqlSyxg);
//                query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
//                List  listSyxg = query.getResultList();
//                HashMap<String ,Object> hashMap =(HashMap)listSyxg.get(0);
//                String  td_id= (String)hashMap.get("TD_ID");
//                String sql = "select TD_ID from sw_msrd_td  where TD_ID ='"+tdId+"'and TD_BLZT='0'";
//                Query queryInfo = baseRepository.getEntityManager().createNativeQuery(sql);
//                queryInfo.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
//                List  listTdId = queryInfo.getResultList();
//                if(listTdId.size()>0){
//                   msg ="2";
//                }else{
//                   msg ="1";
//                }
            if(("1").equals(msg)){
                try {
                    taskId = platUtil.createWorkFlowInstance(project, userId, proName);
                } catch (Exception e) {
                    if (((RuntimeException)e).getMessage().equals("该用户不允许创建该流程")) {
                        String result = "java.lang:" + ((RuntimeException) e).getMessage();
                        return result;
                    } else {
                        throw new RuntimeException();
                    }
                }

                SwMsrdTd swMsrdTd = new SwMsrdTd();
                swMsrdTd.setTdMsrdId(UUIDGenerator.generate());
                swMsrdTd.setSwDjTd(swDjTd);
                swMsrdTd.setTdBlzt("0");
                swMsrdTd.setTdRwId(proId);
                baseRepository.save(swMsrdTd);
            }

            // }
            //保存历史表
            if(StringUtils.isNotBlank(taskId)&&("1").equals(msg)) {
                swdjSyHisService.saveSwDjHis(swDjSy, proId, userId, Czlx.UPDATE.toString());
            }

        }else if(StringUtils.isNotBlank(sylx) && sylx.trim().equals(Sylx.FCSY.toString()) && StringUtils.isNotBlank(fcId)){//房产税免税认定
            SwDjFc swDjFc = baseRepository.get(SwDjFc.class,fcId);
            //创建工作流
            String wdid = AppConfig.getProperty(MSRD_FC_WORKFLOW_CONFIG);
            String proId = UUIDGenerator.generate();
            Project project = new Project();
            project.setProjectId(proId);
            project.setWdid(wdid);
            String userId = SessionUtil.getCurrentUserId();
            String proName = MSRD_FC_PREFIX+"_"+swDjFc.getSwDjJbb().getNsrmc();
            //
            Set set = swDjSy.getSwDjSyHisSet();
            Iterator i = set.iterator();//先迭代出来
            while(i.hasNext()){//遍历
                SwDjSyHis swDjSyHis = (SwDjSyHis)i.next();
                String rwid =swDjSyHis.getRwid();
                String sqlSyxg = "select workflow_state from PF_WORKFLOW_INSTANCE  where workflow_instance_id ='"+rwid+"'";
                Query query = baseRepository.getEntityManager().createNativeQuery(sqlSyxg);
                query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
                List<HashMap<String, Object>> listSyxg = null;
                listSyxg = query.getResultList();
                if(listSyxg.isEmpty()){
                    continue;
                }
                else{
                    HashMap<String ,Object> hashMap =(HashMap)listSyxg.get(0);
                    str= (BigDecimal)hashMap.get("WORKFLOW_STATE");
                    String str1 =str.toString();
                    if("2".equals(str1)){
                        continue;
                    }else{
                        msg ="2";
                        break;
                    }
                }
            }

            //往sw_msrd_td表插入数据
            //     if(StringUtils.isNotBlank(taskId)){

            //根据fc_msrd_id 从sw_msrd_fc表中来获取到fc_id 办理状态是0的(0是办理中，1是已经办结的)
//                String fc_msrd_id =UUIDGenerator.generate();
//                String sqlSyxg = "select FC_ID from sw_msrd_fc  where FC_MSRD_ID ='"+fc_msrd_id+"'and FC_BLZT='0'";
//                Query query = baseRepository.getEntityManager().createNativeQuery(sqlSyxg);
//                query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
//                List  listSyxg = query.getResultList();
//                HashMap<String ,Object> hashMap =(HashMap)listSyxg.get(0);
//                String  fc_id= (String)hashMap.get("FC_ID");
//                String sql = "select FC_ID from sw_msrd_fc  where FC_ID ='"+fcId+"'and FC_BLZT='0'";
//                Query queryInfo = baseRepository.getEntityManager().createNativeQuery(sql);
//                queryInfo.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
//                List  listFcId = queryInfo.getResultList();
//                if(listFcId.size()>0){
//                    msg ="2";
//                }else{
//                    msg ="1";
//                }
            if(("1").equals(msg)){
                try {
                    taskId = platUtil.createWorkFlowInstance(project, userId, proName);
                } catch (Exception e) {
                    if (((RuntimeException)e).getMessage().equals("该用户不允许创建该流程")) {
                        String result = "java.lang:" + ((RuntimeException) e).getMessage();
                        return result;
                    } else {
                        throw new RuntimeException();
                    }
                }
                //sw_msrd_fc表插入数据
                SwMsrdFc swMsrdFc = new SwMsrdFc();
                swMsrdFc.setFcMsrdId(UUIDGenerator.generate());
                swMsrdFc.setSwDjFc(swDjFc);
                swMsrdFc.setFcBlzt("0");
                swMsrdFc.setFcRwId(proId);
                baseRepository.save(swMsrdFc);
            }
            //    }
            //保存历史表
            if(StringUtils.isNotBlank(taskId)&&("1").equals(msg)) {
                swdjSyHisService.saveSwDjHis(swDjSy, proId, userId, Czlx.UPDATE.toString());
            }
        }

        if( msg.equals("2")){
            return "aaaaaa";
        }else{
            return taskId;}
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public SwDjSyQuery getTdMsrd(String proid) {
        QSwDjTd qSwDjTd = QSwDjTd.swDjTd;
        QSwMsrdTd qSwMsrdTd = QSwMsrdTd.swMsrdTd;
        QSwDjSy qSwDjSy = QSwDjSy.swDjSy;
        QZd qZd = QZd.zd;
        QSwDjJbb qSwDjJbb = QSwDjJbb.swDjJbb;
        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        QBean qBean = Projections.bean(SwDjSyQuery.class, qZd.djh, qSwDjSy.dbh, qZd.qlrmc, qSwDjTd.tdzl, qZd.scmjZd, qSwDjTd.msmj, qSwDjTd.ynmj, qSwDjTd.nynseTd, qSwDjJbb.glbm,qSwDjJbb.nsrsbh, qSwDjJbb.nsrmc, qSwDjJbb.zgkgDm, qSwDjJbb.zgkgMc, qSwMsrdTd.tdSqMsmj, qSwMsrdTd.tdRdhSyysmj, qSwMsrdTd.tdRdhNynse, qSwMsrdTd.tdMsyy, qSwMsrdTd.tdMssjBegin, qSwMsrdTd.tdMssjEnd,qSwMsrdTd.tdMsrdId,qSwMsrdTd.tdRwId,qSwDjTd.dwse);
        jpaQuery.from(qSwMsrdTd).leftJoin(qSwMsrdTd.swDjTd,qSwDjTd).leftJoin(qSwDjTd.swDjSy,qSwDjSy).leftJoin(qSwDjSy.zd,qZd).leftJoin(qSwDjTd.swDjJbb, qSwDjJbb);
        jpaQuery.where(qSwMsrdTd.tdRwId.eq(proid));
        baseRepository.addEntityPath(qSwMsrdTd);
        SwDjSyQuery swDjSyQuery = (SwDjSyQuery)baseRepository.get(jpaQuery,qBean);
        return swDjSyQuery;
    }

    @Override
    @Transactional(value="oracle_common")
    public void tdCbdSave(SwDjSyQuery swDjSyQuery) throws  Exception{
        BigDecimal sqMsmj = swDjSyQuery.getTdSqMsmj();
        BigDecimal rdhSyysmj = swDjSyQuery.getTdRdhSyysmj();
        BigDecimal rdhNynse = swDjSyQuery.getTdRdhNynse();
        Date tdMssjBegin = swDjSyQuery.getTdMssjBegin();
        Date tdMssjEnd = swDjSyQuery.getTdMssjEnd();
        String msyy = swDjSyQuery.getTdMsyy();

        String msrdId = swDjSyQuery.getTdMsrdId();
        SwMsrdTd swMsrdTd = baseRepository.get(SwMsrdTd.class,msrdId);
        swMsrdTd.setTdSqMsmj(sqMsmj);
        swMsrdTd.setTdRdhSyysmj(rdhSyysmj);
        swMsrdTd.setTdRdhNynse(rdhNynse);
        swMsrdTd.setTdMssjBegin(tdMssjBegin);
        swMsrdTd.setTdMssjEnd(tdMssjEnd);
        swMsrdTd.setTdMsyy(msyy);
        baseRepository.update(swMsrdTd);
    }

    @Override
    @Transactional(value="oracle_common")
    public void delMsrdTdByRwId(String proid) {
        String jpql = "delete from SwMsrdTd t where t.tdRwId=?0";
        baseRepository.executeJpql(jpql,proid);
    }

    @Override
    @Transactional(value="oracle_common")
    public void endMsrdTdByRwId(String proid) {
        //根据proid获取swMsrdTd对象

        String jpql = "from SwMsrdTd t where t.tdRwId=?0";
        SwMsrdTd swMsrdTd = (SwMsrdTd) baseRepository.getUniqueResultByJpql(jpql,proid);
        BigDecimal sqMsmj = swMsrdTd.getTdSqMsmj();
        BigDecimal rdhSyysmj = swMsrdTd.getTdRdhSyysmj();
        BigDecimal rdhNynse = swMsrdTd.getTdRdhNynse();
        Date tdMssjBegin = swMsrdTd.getTdMssjBegin();
        Date tdMssjEnd = swMsrdTd.getTdMssjEnd();
        String tdMsyy = swMsrdTd.getTdMsyy();
        swMsrdTd.setTdBlzt("1");
        swMsrdTd.setTdBjTime(new Date());
        SwDjTd swDjTd = swMsrdTd.getSwDjTd();
        //更新swMsrdTd表
        baseRepository.update(swMsrdTd);
        if (sqMsmj==null) {
            sqMsmj=new BigDecimal(0);
        }
        swDjTd.setMsmj((swDjTd.getMsmj() == null ? new BigDecimal(0) : swDjTd.getMsmj()).add(sqMsmj));
        swDjTd.setYnmj(rdhSyysmj);
        swDjTd.setNynseTd(rdhNynse);
        swDjTd.setTdMssjBegin(tdMssjBegin);
        swDjTd.setTdMssjEnd(tdMssjEnd);
        swDjTd.setMsbz("1");
        swDjTd.setTdMsyy(tdMsyy);
        //更新swDjTd表
        baseRepository.update(swDjTd);

    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public SwDjSyQuery getfcMsrd(String proid) {
        QSwDjFc qSwDjFc = QSwDjFc.swDjFc;
        QSwMsrdFc qSwMsrdFc = QSwMsrdFc.swMsrdFc;
        QSwDjSy qSwDjSy = QSwDjSy.swDjSy;
        QZd qZd = QZd.zd;
        QSwDjJbb qSwDjJbb = QSwDjJbb.swDjJbb;
        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        QBean qBean = Projections.bean(SwDjSyQuery.class, qZd.djh, qSwDjSy.dbh, qZd.qlrmc, qSwDjFc.fczl, qZd.scmjZd, qSwDjFc.fcyzMs, qSwDjFc.fcyzYs, qSwDjFc.ynseZy,qSwDjFc.ynseCz,qSwDjFc.nynseFc, qSwDjJbb.glbm,qSwDjJbb.nsrsbh, qSwDjJbb.nsrmc, qSwDjJbb.zgkgDm, qSwDjJbb.zgkgMc, qSwMsrdFc.fcSqMsyz, qSwMsrdFc.fcRdhSyysyz, qSwMsrdFc.fcRdhNynse, qSwMsrdFc.fcMsyy, qSwMsrdFc.fcMssjBegin, qSwMsrdFc.fcMssjEnd,qSwMsrdFc.fcMsrdId);
        jpaQuery.from(qSwMsrdFc).leftJoin(qSwMsrdFc.swDjFc,qSwDjFc).leftJoin(qSwDjFc.swDjSy,qSwDjSy).leftJoin(qSwDjSy.zd,qZd).leftJoin(qSwDjFc.swDjJbb, qSwDjJbb);
        jpaQuery.where(qSwMsrdFc.fcRwId.eq(proid));
        baseRepository.addEntityPath(qSwMsrdFc);
        SwDjSyQuery swDjSyQuery = (SwDjSyQuery)baseRepository.get(jpaQuery,qBean);
        return swDjSyQuery;
    }

    @Override
    @Transactional(value="oracle_common")
    public void delMsrdFcByRwId(String proid) {
        String jpql = "delete from SwMsrdFc t where t.fcRwId=?0";
        baseRepository.executeJpql(jpql,proid);
    }

    @Override
    @Transactional(value="oracle_common")
    public void endMsrdFcByRwId(String proid) {
        //根据proid获取swMsrdFc对象

        String jpql = "from SwMsrdFc t where t.fcRwId=?0";
        SwMsrdFc swMsrdFc = (SwMsrdFc) baseRepository.getUniqueResultByJpql(jpql,proid);
        BigDecimal fcSqMsyz = swMsrdFc.getFcSqMsyz();
        BigDecimal fcRdhSyysyz = swMsrdFc.getFcRdhSyysyz();
        BigDecimal fcRdhNynse = swMsrdFc.getFcRdhNynse();
        Date fcMssjBegin = swMsrdFc.getFcMssjBegin();
        Date fcMssjEnd = swMsrdFc.getFcMssjEnd();
        String fcMsyy = swMsrdFc.getFcMsyy();
        swMsrdFc.setFcBlzt("1");
        swMsrdFc.setFcBjTime(new Date());
        SwDjFc swDjFc = swMsrdFc.getSwDjFc();
        //更新swMsrdTd表
        baseRepository.update(swMsrdFc);

        swDjFc.setFcyzMs((swDjFc.getFcyzMs() == null ? new BigDecimal(0) : swDjFc.getFcyzMs()).add(fcSqMsyz));
        swDjFc.setFcyzYs(fcRdhSyysyz);
        swDjFc.setNynseFc(fcRdhNynse);
        swDjFc.setYnseZy(lv.multiply(fcRdhSyysyz));
        swDjFc.setFcMssjBegin(fcMssjBegin);
        swDjFc.setFcMssjEnd(fcMssjEnd);
        swDjFc.setMsbz("1");
        swDjFc.setFcMsyy(fcMsyy);
        //更新swDjTd表
        baseRepository.update(swDjFc);
    }

    @Override
    @Transactional(value="oracle_common")
    public void fcCbdSave(SwDjSyQuery swDjSyQuery) {
        BigDecimal fcSqMsyz = swDjSyQuery.getFcSqMsyz();
        BigDecimal fcRdhSyysyz = swDjSyQuery.getFcRdhSyysyz();
        BigDecimal fcRdhNynse = swDjSyQuery.getFcRdhNynse();
        Date fcMssjBegin = swDjSyQuery.getFcMssjBegin();
        Date fcMssjEnd = swDjSyQuery.getFcMssjEnd();
        String fcMsyy = swDjSyQuery.getFcMsyy();

        String fcMsrdId = swDjSyQuery.getFcMsrdId();
        SwMsrdFc swMsrdFc = baseRepository.get(SwMsrdFc.class,fcMsrdId);
        swMsrdFc.setFcSqMsyz(fcSqMsyz);
        swMsrdFc.setFcRdhSyysyz(fcRdhSyysyz);
        swMsrdFc.setFcRdhNynse(fcRdhNynse);
        swMsrdFc.setFcMssjBegin(fcMssjBegin);
        swMsrdFc.setFcMssjEnd(fcMssjEnd);
        swMsrdFc.setFcMsyy(fcMsyy);
        baseRepository.update(swMsrdFc);
    }

}
