package cn.gtmap.landtax.service.impl;

import cn.gtmap.landtax.entity.SwDjQs;
import cn.gtmap.landtax.model.query.DictTreeGrid;
import cn.gtmap.landtax.model.query.MjydQuery;
import cn.gtmap.landtax.model.query.MjydSyQuery;
import cn.gtmap.landtax.model.query.MjydSyList;
import cn.gtmap.landtax.service.MjydcxService;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.Query;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by XiongWen on 2018/5/5.
 */

@Service
public class MjydcxServiceImpl implements MjydcxService{
    @Autowired
    private BaseRepository baseRepository;

    @Override
    public Page<MjydSyQuery> selectAll(Pageable pageable) {
        return null;
    }
    @Override
    public List getDjhByNsrsbh(String djxh){
        String queryJstdSql="select nsrmc,jsmj,zytdmj,mjce from s_yd_mjyd where djxh = '"+djxh+"'";
        Query queryJstdList = baseRepository.getEntityManager().createNativeQuery(queryJstdSql);
        List<Object[]> listJstd =  queryJstdList.getResultList();
        return listJstd;
    }


    @Override
    public List getJsByDjxh(String djxh){
        String queryJstdSql=" select t1.nsrsbh ,t1.tdzldz as tdzl ,t1.zytdmj1  as zytdmj ,t5.ystdmj,t6.nsrmc  from sb_cxs_tdsyxxcjb t1  left join (select *  from (select t.*, RANK() OVER(PARTITION BY syuuid ORDER BY yxqz DESC) RK    from sb_cxs_tdsyysxx t    where bgbm = '1'  and yxbz = 'Y') t5     where t5.rk = 1) t5   on t5.syuuid = t1.syuuid left join dj_nsrxx t6 on t1.djxh =t6.djxh where  t5.yxbz = 'Y' and rtrim(t1.djxh) ='"+djxh+"'";
        Query queryJstdList = baseRepository.getEntityManager().createNativeQuery(queryJstdSql);
        queryJstdList.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> listJstd = queryJstdList.getResultList();
        List<MjydSyList> resultList = new ArrayList<MjydSyList>();
        if (CollectionUtils.isNotEmpty(listJstd)) {
            for (HashMap tempMap : listJstd) {
                MjydSyList tempList = new MjydSyList();
                tempList.setNsrsbh(String.valueOf(tempMap.get("NSRSBH")==null?"":tempMap.get("NSRSBH")));
                tempList.setTdzl(String.valueOf(tempMap.get("TDZL")==null?"":tempMap.get("TDZL")));
                tempList.setZytdmj(String.valueOf(tempMap.get("ZYTDMJ")==null?"":tempMap.get("ZYTDMJ")));
                tempList.setYstdmj(String.valueOf(tempMap.get("YSTDMJ")==null?"":tempMap.get("YSTDMJ")));
                tempList.setNsrmc(String.valueOf(tempMap.get("NSRMC")==null?"":tempMap.get("NSRMC")));
                resultList.add(tempList);
            }
        }
        return resultList;
    }


    @Override
    @Transactional(readOnly = true)
    public List findMjydTdForExp(HashMap param) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        Object obj = param.get("ids");
        MjydSyQuery mjydSyQuery = (MjydSyQuery) param.get("mjydSyQuery");
        String sql=getMjydSql(param);

        if(obj==null) {//导出全部
            //筛选税源
            sql = addConditions(sql,mjydSyQuery);
        }else{//checkbox导出
            String resultIds = "";
            String ids = String.valueOf(obj);
            String[] idsArr = ids.split(",");
            for(int i=0;i<idsArr.length;i++){
                if(i==idsArr.length-1){
                    resultIds = resultIds+"'"+idsArr[i]+"'";
                }else{
                    resultIds = resultIds+"'"+idsArr[i]+"'"+",";
                }
            }
            sql = sql + " and mjyd_id in("+resultIds+")";
        }
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        return list;
    }

    private String getMjydSql(HashMap param){
        String sql=" select nsrsbh,nsrmc,zgkg_mc,jsmj,zytdmj,mjce,( CASE ydzt WHEN '01' THEN '未消除' ELSE '已消除' END ) as ydzt from s_yd_mjyd where 1=1 ";
        return sql;
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public Page<MjydSyQuery> selectByCondition(MjydSyQuery mjydydQuery, Pageable pageable) {
        String sql = "select * from s_yd_mjyd where 1=1 ";
        String countsql = "select count(*) from s_yd_mjyd where 1=1 ";
        Query query = null;
        Query countQuery = null;
        String sqlWithCond = addConditions(sql,mjydydQuery);
        countsql =addConditions(countsql,mjydydQuery);
        query = baseRepository.getEntityManager().createNativeQuery(sqlWithCond);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        countQuery = baseRepository.getEntityManager().createNativeQuery(countsql);

        if (pageable==null||pageable.getPageNumber()==0) {
            pageable = new PageRequest(1, 15);
        }
        Page page =  baseRepository.find(query, countQuery, pageable);
        return page;
    }

    @Override
    public List getTdjbZd() {
        String sql = " select dm,mc from S_ZD_TDJB ";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List list = query.getResultList();
        for(Object obj:list){
            Map map = (Map)obj;
            String syuuid = map.get("MC").toString();
        }
        return list;
    }

    @Override
    public List getHistoryBySyuuId(String syuuid) {
        String sql = "select * from s_yd_tddj_his where syuuid = '"+syuuid+"' order by bgsj  ";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List list = query.getResultList();
        return list;
    }

    private String addConditions(String sql,MjydSyQuery mjydSyQuery){
        UserInfo userInfo = SessionUtil.getCurrentUser();
        String regionCode ="";
        if(userInfo!=null){
             regionCode = userInfo.getRegionCode();
        }
        if(StringUtils.isNotBlank(regionCode)){
            sql += " and ZGKG_DM like '2"+regionCode+"%'";
        }
        if(StringUtils.isNotBlank(mjydSyQuery.getQx())){
            sql += " and ZGKG_DM like '2"+mjydSyQuery.getQx()+"%'";
        }
        if(StringUtils.isNotBlank(mjydSyQuery.getNsrsbh())){
            sql+=" and NSRSBH = '"+mjydSyQuery.getNsrsbh()+"'";
        }
        if(StringUtils.isNotBlank(mjydSyQuery.getNsrmc())){
            sql += " and NSRMC like '%"+mjydSyQuery.getNsrmc()+"%'";
        }
        if(StringUtils.isNotBlank(mjydSyQuery.getYdzt())){
            sql += " and YDZT = '"+mjydSyQuery.getYdzt()+"'";
        }
        if(StringUtils.isNotBlank(mjydSyQuery.getZgkgDm())){
            sql += " and ZGKG_DM like '"+mjydSyQuery.getZgkgDm()+"%'";
        }
//        if(StringUtils.isNotBlank(mjydSyQuery.getCjsj_q()) || StringUtils.isNotBlank(mjydSyQuery.getCjsj_q())){
//            sql += " and to_date('"+mjydSyQuery.getCjsj_q()+"','yyyy-MM-dd')<= cjsj and cjsj<= to_date('"+mjydSyQuery.getCjsj_q()+"','yyyy-MM-dd')";
//        }
//        if(StringUtils.isNotBlank(mjydSyQuery.getCjsj_z()) || StringUtils.isNotBlank(mjydSyQuery.getCjsj_z())){
//            sql += " and to_date('"+mjydSyQuery.getCjsj_z()+"','yyyy-MM-dd')<= cjsj and cjsj<= to_date('"+mjydSyQuery.getCjsj_z()+"','yyyy-MM-dd')";
//        }
//        if(StringUtils.isNotBlank(mjydSyQuery.getXgsj_q()) || StringUtils.isNotBlank(mjydSyQuery.getXgsj_q())){
//            sql += " and to_date('"+mjydSyQuery.getXgsj_q()+"','yyyy-MM-dd')<= xgsj and xgsj<= to_date('"+mjydSyQuery.getXgsj_q()+"','yyyy-MM-dd')";
//        }
//        if(StringUtils.isNotBlank(mjydSyQuery.getXgsj_z()) || StringUtils.isNotBlank(mjydSyQuery.getXgsj_z())){
//            sql += " and to_date('"+mjydSyQuery.getXgsj_z()+"','yyyy-MM-dd')<= xgsj and xgsj<= to_date('"+mjydSyQuery.getXgsj_z()+"','yyyy-MM-dd')";
//        }

        if((StringUtils.isNotBlank(mjydSyQuery.getMjce_q()))&&(StringUtils.isNotBlank(mjydSyQuery.getMjce_z()))){
            sql +=  " and mjce between "+mjydSyQuery.getMjce_q()+" and "+mjydSyQuery.getMjce_z();
        }
        if((StringUtils.isBlank(mjydSyQuery.getMjce_q()))&&(StringUtils.isNotBlank(mjydSyQuery.getMjce_z()))){
            sql +=  " and   between 0 and "+mjydSyQuery.getMjce_z();
        }
        if((StringUtils.isNotBlank(mjydSyQuery.getMjce_q()))&&(StringUtils.isBlank(mjydSyQuery.getMjce_z()))){
            sql +=  " and  "+mjydSyQuery.getMjce_q()+" <= mjce";
        }

//        if((StringUtils.isNotBlank(mjydSyQuery.getMjce_q()))&&(StringUtils.isNotBlank(mjydSyQuery.getMjce_q()))){
//            sql +=   " and mjce_z between "+mjydSyQuery.getMjce_q()+" and "+mjydSyQuery.getMjce_q();
//        }
//        if((StringUtils.isBlank(mjydSyQuery.getMjce_z()))&&(StringUtils.isNotBlank(mjydSyQuery.getMjce_z()))){
//            sql +=   " and mjce_z  between 0 and "+mjydSyQuery.getMjce_z();
//        }
//        if((StringUtils.isNotBlank(mjydSyQuery.getMjce_q()))&&(StringUtils.isBlank(mjydSyQuery.getMjce_z()))){
//            sql +=    " and "+mjydSyQuery.getMjce_q()+" <= mjce_z";
//        }

        return   sql ;
    }
}
