package cn.gtmap.landtax.service.impl;

import cn.gtmap.landtax.model.dictionary.Hcxmlx;
import cn.gtmap.landtax.model.dictionary.Jdlx;
import cn.gtmap.landtax.model.query.DictTreeGrid;
import cn.gtmap.landtax.model.query.GtSwTzQuery;
import cn.gtmap.landtax.service.HcjdServiceTaiZhou;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.CommonUtil;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.web.SessionUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import com.gtis.plat.service.SysUserService;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.Query;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

/**
 * Created by wgy on 2017/10/23.
 */
@Service
public class HcjdServiceImplTaiZhou implements HcjdServiceTaiZhou {
    @Autowired
    SysUserService sysUserService;
    @Autowired
    BaseRepository baseRepository;

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public Object hcjdTreeJson(String id,String hcxmlx,String minMj,String maxMj){
        if(minMj==null){
            minMj="";
        }
        if(maxMj==null){
            maxMj="";
        }
        String organ_id = "";
        String idRemovedZero = "";
        int idRemovedZeroLength = 0;
        boolean isHasSonOrgan = true;
        if(id==null){
            //第一次查询本机构数据
            String userId = SessionUtil.getCurrentUserId();
            String organId = sysUserService.getOrganListByUser(userId).get(0).getOrganId();

            idRemovedZero = organId.replaceAll("00+$","");//正则，去除字符串中最后2位0
            idRemovedZeroLength = idRemovedZero.length();//长度减2，所有用户都看到其上一级的数据

        if(idRemovedZero.length()>7&&idRemovedZero.substring(5,7).equals("00")){
                idRemovedZeroLength-=4;
                //organId也改为当前用户上一级的用户(去两位补零)
                organId = organId.substring(0,idRemovedZeroLength);
                for (int i = organId.length();i<11;i++){
                    organId += "0";
                }
            }
            if(idRemovedZeroLength>7){//对于区县级的用户
                idRemovedZeroLength-=2;
                //organId也改为当前用户上一级的用户(去两位补零)
                organId = organId.substring(0,idRemovedZeroLength);
                for (int i = organId.length();i<11;i++){
                    organId += "0";
                }
            }

            organ_id = "t1.ORGAN_ID = '"+organId+"'";
        }else{
            //查询子机构
            idRemovedZero = id.replaceAll("00+$","");//正则，去除字符串中最后2位0
            idRemovedZeroLength = idRemovedZero.length()+2;
            organ_id = "t1.SUPER_ORGAN_ID = '"+id+"'";

            isHasSonOrgan = this.querySonOrganByOrganId(id);
        }
        String sql="";
        if(isHasSonOrgan){
            //tree下面还有分节点
            sql = "SELECT k.DWMC " +
                    " ,k.ORGAN_ID " +
                    " ,(k.ZS - k.YCL) AS WCL " +
                    " ,k.YCL " +
                    " ,k.ZS " +
                    " ,ROUND(DECODE(k.ZS, 0, 1, k.YCL / k.ZS) * 100, 2) AS CLL " +
                    "FROM ( " +
                    " SELECT d.ORGAN_NAME AS DWMC " +
                    "  ,d.ORGAN_ID " +
                    "  ,NVL(t1.ZS, 0) AS ZS " +
                    "  ,NVL(t2.YCL, 0) AS YCL " +
                    " FROM ( " +
                    "  SELECT t1.ORGAN_NAME " +
                    "   ,t1.ORGAN_ID " +
                    "  FROM PF_ORGAN t1 " +
                    "  WHERE :ORGAN_ID  " +
                    "   AND t1.REMARK LIKE '%tj%' " +
                    "  ) d " +
                    " LEFT JOIN ( " +
                    "  SELECT :SUBSTR_ORGAN_ID AS ORGAN_ID " +
                    "   ,COUNT(DISTINCT t.RW_ID) AS ZS " +
                    "  FROM SW_HC_XM_RW_REL t " +
                    "  INNER JOIN PF_WORKFLOW_INSTANCE t1 ON t.RW_ID = t1.WORKFLOW_INSTANCE_ID " +
                    "  INNER JOIN PF_ACTIVITY t2 ON t1.WORKFLOW_INSTANCE_ID = t2.WORKFLOW_INSTANCE_ID " ;
            if(Hcxmlx.ZDHC.toString().equals(hcxmlx)){
                sql= sql+" INNER JOIN  S_SJ_GTBD t10 on t10.gtbd_id = t.bd_id";  //关联S_SJ_GTBD
            }
            sql= sql+
                    "  INNER JOIN ( " +
                    "    SELECT * " +
                    "    FROM ( " +
                    "      SELECT t.* " +
                    "        ,RANK() OVER ( " +
                    "          PARTITION BY t.ACTIVITY_ID " +
                    "          ORDER BY t.FINISH_TIME DESC " +
                    "          ) AS PM " +
                    "      FROM ( " +
                    "        SELECT t.USER_ID " +
                    "          ,t.ACTIVITY_ID " +
                    "          ,t.FINISH_TIME " +
                    "        FROM PF_ASSIGNMENTHISTORY t" +
                    "         " +
                    "        UNION ALL " +
                    "         " +
                    "        SELECT USER_ID " +
                    "          ,ACTIVITY_ID " +
                    "          ,NULL " +
                    "        FROM PF_ASSIGNMENT " +
                    "        ) t " +
                    "      ) t " +
                    "    WHERE PM = 1 " +
                    "   ) t3 ON t2.ACTIVITY_ID = t3.ACTIVITY_ID " +
                    "  INNER JOIN SW_HC_XM t4 ON t.HCXM_ID = t4.ID " +
                    "  INNER JOIN PF_USER_ORGAN_REL t5 ON t3.USER_ID = t5.USER_ID " +
                    "  INNER JOIN PF_ORGAN t6 ON t5.ORGAN_ID = t6.ORGAN_ID " +
                    "  join " +
                    "     (SELECT * " +
                    "     FROM ( " +
                    "      SELECT t.* " +
                    "       ,RANK() OVER ( " +
                    "        PARTITION BY t.workflow_instance_id ORDER BY t.FINISH_TIME DESC " +
                    "        ) AS PM " +
                    "      FROM ( " +
                    "       SELECT t.USER_ID " +
                    "        ,t.FINISH_TIME " +
                    "        ,t2.workflow_instance_id " +
                    "        ,substr(t3.organ_id,0,7) as organ_id " +
                    "       FROM PF_ASSIGNMENTHISTORY t " +
                    "       join pf_activity t2 on t2.activity_id = t.activity_id " +
                    "       join pf_user_organ_rel t3 on t3.user_id = t.user_id " +
                    "       ) t " +
                    "      ) t " +
                    "     WHERE PM = 1) t7 " +
                    "     on t7.workflow_instance_id = t2.workflow_instance_id"+/*去除一个流程中由于退回，属于不同分局的节点*/
                    "  WHERE t4.xmlx = '"+hcxmlx+"'  " +
                    "  and t7.organ_id = SUBSTR(t6.ORGAN_ID,0,7) "+
                    "  and t2.ACTIVITY_STATE !='5'/*不统计已退回*/ " ;
            if(minMj.length()!=0&&maxMj.length()!=0){
                sql= sql+"  AND t10.scmj between '"+minMj+"' AND '"+maxMj+"'";
            }
            if(minMj.length()==0&&maxMj.length()!=0){
                sql= sql+"  AND t10.scmj <'"+maxMj+"'";
            }
            if(minMj.length()!=0&&maxMj.length()==0){
                sql= sql+"  AND t10.scmj >'"+minMj+"'";//拼接过滤的面积条件
            }
            sql= sql+
            "  GROUP BY SUBSTR(t6.ORGAN_ID, 0, :length) " +
                    "  ) t1 ON d.ORGAN_ID = t1.ORGAN_ID " +
                    " LEFT JOIN ( " +
                    "  SELECT :SUBSTR_ORGAN_ID AS ORGAN_ID " +
                    "   ,COUNT(DISTINCT t.RW_ID) AS YCL " +
                    "  FROM SW_HC_XM_RW_REL t " +
                    "  INNER JOIN PF_WORKFLOW_INSTANCE t1 ON t.RW_ID = t1.WORKFLOW_INSTANCE_ID " +
                    "  INNER JOIN PF_ACTIVITY t2 ON t1.WORKFLOW_INSTANCE_ID = t2.WORKFLOW_INSTANCE_ID " ;
            if(Hcxmlx.ZDHC.toString().equals(hcxmlx)){
                sql= sql+" INNER JOIN  S_SJ_GTBD t10 on t10.gtbd_id = t.bd_id";  //关联S_SJ_GTBD
            }
            sql= sql+
                    "  INNER JOIN ( " +
                    "    SELECT * " +
                    "    FROM ( " +
                    "      SELECT t.* " +
                    "        ,RANK() OVER ( " +
                    "          PARTITION BY t.ACTIVITY_ID " +
                    "          ORDER BY t.FINISH_TIME DESC " +
                    "          ) AS PM " +
                    "       FROM ( " +
                    "        SELECT t.USER_ID " +
                    "          ,t.ACTIVITY_ID " +
                    "          ,t.FINISH_TIME " +
                    "        FROM PF_ASSIGNMENTHISTORY t" +
                    "         " +
                    "        UNION ALL " +
                    "         " +
                    "        SELECT USER_ID " +
                    "          ,ACTIVITY_ID " +
                    "          ,NULL " +
                    "        FROM PF_ASSIGNMENT " +
                    "        ) t " +
                    "      ) t " +
                    "    WHERE PM = 1 " +
                    "   ) t3 ON t2.ACTIVITY_ID = t3.ACTIVITY_ID " +
                    "  INNER JOIN SW_HC_XM t4 ON t.HCXM_ID = t4.ID " +
                    "  INNER JOIN PF_USER_ORGAN_REL t5 ON t3.USER_ID = t5.USER_ID " +
                    "  INNER JOIN PF_ORGAN t6 ON t5.ORGAN_ID = t6.ORGAN_ID " +
                    "  join " +
                    "     (SELECT * " +
                    "     FROM ( " +
                    "      SELECT t.* " +
                    "       ,RANK() OVER ( " +
                    "        PARTITION BY t.workflow_instance_id ORDER BY t.FINISH_TIME DESC " +
                    "        ) AS PM " +
                    "      FROM ( " +
                    "       SELECT t.USER_ID " +
                    "        ,t.FINISH_TIME " +
                    "        ,t2.workflow_instance_id " +
                    "        ,substr(t3.organ_id,0,7) as organ_id " +
                    "       FROM PF_ASSIGNMENTHISTORY t " +
                    "       join pf_activity t2 on t2.activity_id = t.activity_id " +
                    "       join pf_user_organ_rel t3 on t3.user_id = t.user_id " +
                    "       ) t " +
                    "      ) t " +
                    "     WHERE PM = 1) t7 " +
                    "     on t7.workflow_instance_id = t2.workflow_instance_id"+/*去除一个流程中由于退回，属于不同分局的节点*/
                    "  WHERE t4.xmlx = '"+hcxmlx+"' " +
                    "  and t7.organ_id = SUBSTR(t6.ORGAN_ID,0,7) "+
                    "   AND t2.ACTIVITY_STATE = '2' " +
                    "   AND t1.WORKFLOW_STATE = '2' " ;
            if(minMj.length()!=0&&maxMj.length()!=0){
                sql= sql+"  AND t10.scmj between '"+minMj+"' AND '"+maxMj+"'";
            }
            if(minMj.length()==0&&maxMj.length()!=0){
                sql= sql+"  AND t10.scmj <'"+maxMj+"'";
            }
            if(minMj.length()!=0&&maxMj.length()==0){
                sql= sql+"  AND t10.scmj >'"+minMj+"'";//拼接过滤的面积条件
            }
            sql= sql+
                    "  GROUP BY SUBSTR(t6.ORGAN_ID, 0, :length) " +
                    "  ) t2 ON d.ORGAN_ID = t2.ORGAN_ID " +
                    " ) k " +
                    "ORDER BY k.ORGAN_ID";
            sql = sql.replaceAll(":ORGAN_ID",organ_id);
            sql = sql.replaceAll(":length",""+idRemovedZeroLength);

            String SUBSTR_ORGAN_ID = "";
            if(idRemovedZeroLength==5){
                SUBSTR_ORGAN_ID = "SUBSTR(t6.ORGAN_ID, 0, "+idRemovedZeroLength+")||'000000'";
            }else if(idRemovedZeroLength==7){
                SUBSTR_ORGAN_ID = "SUBSTR(t6.ORGAN_ID, 0, "+idRemovedZeroLength+")||'0000'";
            }else if(idRemovedZeroLength==9){
                SUBSTR_ORGAN_ID = "SUBSTR(t6.ORGAN_ID, 0, "+idRemovedZeroLength+")||'00'";
            }else {
                SUBSTR_ORGAN_ID = "SUBSTR(t6.ORGAN_ID, 0, "+idRemovedZeroLength+")";
            }
            sql = sql.replaceAll(":SUBSTR_ORGAN_ID",SUBSTR_ORGAN_ID);

        }else{
            //叶子节点
            sql="SELECT k.DWMC " +
                    " ,k.ORGAN_ID " +
                    " ,(k.ZS - k.YCL) AS WCL " +
                    " ,k.YCL " +
                    " ,k.ZS " +
                    " ,ROUND(DECODE(k.ZS, 0, 1, k.YCL / k.ZS) * 100, 2) AS CLL " +
                    "FROM ( " +
                    " SELECT d.USER_ID " +
                    "  ,d.USER_NAME " +
                    "  ,d.USER_ID AS ORGAN_ID " +
                    "  ,d.USER_NAME AS DWMC " +
                    "  ,NVL(t1.YCL, 0) AS ZS " +
                    "  ,NVL(t2.YCL, 0) AS YCL " +
                    " FROM ( " +
                    "  SELECT TO_CHAR(t1.USER_ID) AS USER_ID " +
                    "   ,TO_CHAR(t1.USER_NAME) AS USER_NAME " +
                    "   ,t3.REGION_CODE " +
                    "   ,t3.ORGAN_NAME " +
                    "   ,t1.REMARK " +
                    "  FROM PF_USER t1 " +
                    "  LEFT JOIN PF_USER_ORGAN_REL t2 ON t1.USER_ID = t2.USER_ID " +
                    "  LEFT JOIN PF_ORGAN t3 ON t2.ORGAN_ID = t3.ORGAN_ID " +
                    "  WHERE t3.ORGAN_ID IS NOT NULL " +
                    "   AND t3.REGION_CODE IS NOT NULL " +
                    "   AND t3.organ_id = '"+id+"' " +
                    "   AND t3.REMARK LIKE '%tj%' " +
                    "  ) d " +
                    " LEFT JOIN ( " +
                    "  SELECT t3.USER_ID AS DM " +
                    "   ,COUNT(DISTINCT t.RW_ID) AS YCL " +
                    "  FROM SW_HC_XM_RW_REL t " +
                    "  INNER JOIN PF_WORKFLOW_INSTANCE t1 ON t.RW_ID = t1.WORKFLOW_INSTANCE_ID " +
                    "  INNER JOIN PF_ACTIVITY t2 ON t1.WORKFLOW_INSTANCE_ID = t2.WORKFLOW_INSTANCE_ID " ;
            if(Hcxmlx.ZDHC.toString().equals(hcxmlx)){
                sql= sql+" INNER JOIN  S_SJ_GTBD t10 on t10.gtbd_id = t.bd_id";  //关联S_SJ_GTBD
            }
            sql= sql+
                    "  INNER JOIN ( " +
                    "    SELECT * " +
                    "    FROM ( " +
                    "      SELECT t.* " +
                    "        ,RANK() OVER ( " +
                    "          PARTITION BY t.ACTIVITY_ID " +
                    "          ORDER BY t.FINISH_TIME DESC " +
                    "          ) AS PM " +
                    "      FROM ( " +
                    "        SELECT t.USER_ID " +
                    "          ,t.ACTIVITY_ID " +
                    "          ,t.FINISH_TIME " +
                    "        FROM PF_ASSIGNMENTHISTORY t" +
                    "         " +
                    "        UNION ALL " +
                    "         " +
                    "        SELECT USER_ID " +
                    "          ,ACTIVITY_ID " +
                    "          ,NULL " +
                    "        FROM PF_ASSIGNMENT " +
                    "        ) t " +
                    "      ) t " +
                    "    WHERE PM = 1 " +
                    "   ) t3 ON t2.ACTIVITY_ID = t3.ACTIVITY_ID " +
                    "  INNER JOIN SW_HC_XM t4 ON t.HCXM_ID = t4.ID " +
                    "  join " +
                    "     (SELECT * " +
                    "     FROM ( " +
                    "      SELECT t.* " +
                    "       ,RANK() OVER ( " +
                    "        PARTITION BY t.workflow_instance_id ORDER BY t.FINISH_TIME DESC " +
                    "        ) AS PM " +
                    "      FROM ( " +
                    "       SELECT t.USER_ID " +
                    "        ,t.FINISH_TIME " +
                    "        ,t2.workflow_instance_id " +
                    "        ,substr(t3.organ_id,0,7) as organ_id " +
                    "       FROM PF_ASSIGNMENTHISTORY t " +
                    "       join pf_activity t2 on t2.activity_id = t.activity_id " +
                    "       join pf_user_organ_rel t3 on t3.user_id = t.user_id " +
                    "       ) t " +
                    "      ) t " +
                    "     WHERE PM = 1) t7 " +
                    "     on t7.workflow_instance_id = t2.workflow_instance_id"+/*去除一个流程中由于退回，属于不同分局的节点*/
                    "  WHERE t4.xmlx = '"+hcxmlx+"' " +
                    "  and t7.organ_id = SUBSTR("+id+",0,7) "+
                    "  and t2.ACTIVITY_STATE !='5'/*不统计已退回*/ ";
            if(minMj.length()!=0&&maxMj.length()!=0){
                sql= sql+"  AND t10.scmj between '"+minMj+"' AND '"+maxMj+"'";
            }
            if(minMj.length()==0&&maxMj.length()!=0){
                sql= sql+"  AND t10.scmj <'"+maxMj+"'";
            }
            if(minMj.length()!=0&&maxMj.length()==0){
                sql= sql+"  AND t10.scmj >'"+minMj+"'";//拼接过滤的面积条件
            }
            sql= sql+
                    "  GROUP BY t3.USER_ID " +
                    "  ) t1 ON d.USER_ID = t1.DM " +
                    " LEFT JOIN ( " +
                    "  SELECT t3.USER_ID AS DM " +
                    "   ,COUNT(DISTINCT t.RW_ID) AS YCL " +
                    "  FROM SW_HC_XM_RW_REL t " +
                    "  INNER JOIN PF_WORKFLOW_INSTANCE t1 ON t.RW_ID = t1.WORKFLOW_INSTANCE_ID " +
                    "  INNER JOIN PF_ACTIVITY t2 ON t1.WORKFLOW_INSTANCE_ID = t2.WORKFLOW_INSTANCE_ID " ;
            if(Hcxmlx.ZDHC.toString().equals(hcxmlx)){
                sql= sql+" INNER JOIN  S_SJ_GTBD t10 on t10.gtbd_id = t.bd_id";  //关联S_SJ_GTBD
            }
            sql= sql+
                    "  INNER JOIN ( " +
                    "    SELECT * " +
                    "    FROM ( " +
                    "      SELECT t.* " +
                    "        ,RANK() OVER ( " +
                    "          PARTITION BY t.ACTIVITY_ID " +
                    "          ORDER BY t.FINISH_TIME DESC " +
                    "          ) AS PM " +
                    "      FROM ( " +
                    "        SELECT t.USER_ID " +
                    "          ,t.ACTIVITY_ID " +
                    "          ,t.FINISH_TIME " +
                    "        FROM PF_ASSIGNMENTHISTORY t" +
                    "         " +
                    "        UNION ALL " +
                    "         " +
                    "        SELECT USER_ID " +
                    "          ,ACTIVITY_ID " +
                    "          ,NULL " +
                    "        FROM PF_ASSIGNMENT " +
                    "        ) t " +
                    "      ) t " +
                    "    WHERE PM = 1 " +
                    "   ) t3 ON t2.ACTIVITY_ID = t3.ACTIVITY_ID " +
                    "  INNER JOIN SW_HC_XM t4 ON t.HCXM_ID = t4.ID " +
                    "  join " +
                    "     (SELECT * " +
                    "     FROM ( " +
                    "      SELECT t.* " +
                    "       ,RANK() OVER ( " +
                    "        PARTITION BY t.workflow_instance_id ORDER BY t.FINISH_TIME DESC " +
                    "        ) AS PM " +
                    "      FROM ( " +
                    "       SELECT t.USER_ID " +
                    "        ,t.FINISH_TIME " +
                    "        ,t2.workflow_instance_id " +
                    "        ,substr(t3.organ_id,0,7) as organ_id " +
                    "       FROM PF_ASSIGNMENTHISTORY t " +
                    "       join pf_activity t2 on t2.activity_id = t.activity_id " +
                    "       join pf_user_organ_rel t3 on t3.user_id = t.user_id " +
                    "       ) t " +
                    "      ) t " +
                    "     WHERE PM = 1) t7 " +
                    "     on t7.workflow_instance_id = t2.workflow_instance_id"+/*去除一个流程中由于退回，属于不同分局的节点*/
                    "  WHERE t4.xmlx = '"+hcxmlx+"' " +
                    "  and t7.organ_id = SUBSTR("+id+",0,7) "+
                    "   AND t2.ACTIVITY_STATE = '2' " +
                    "   AND t1.WORKFLOW_STATE = '2' "
                    ;
            if(minMj.length()!=0&&maxMj.length()!=0){
                sql= sql+"  AND t10.scmj between '"+minMj+"' AND '"+maxMj+"'";
            }
            if(minMj.length()==0&&maxMj.length()!=0){
                sql= sql+"  AND t10.scmj <'"+maxMj+"'";
            }
            if(minMj.length()!=0&&maxMj.length()==0){
                sql= sql+"  AND t10.scmj >'"+minMj+"'";//拼接过滤的面积条件
            }
                    sql= sql+
                    "  GROUP BY t3.USER_ID " +
                    "  ) t2 ON d.USER_ID = t2.DM " +
                    " ) k " +
                    "ORDER BY k.ORGAN_ID ";
        }


        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        List<DictTreeGrid> resultList = new ArrayList<DictTreeGrid>();
        if(CollectionUtils.isNotEmpty(list)){
            for(HashMap tempMap : list){
                DictTreeGrid tempGrid = new DictTreeGrid();
                tempGrid.setName(String.valueOf(tempMap.get("DWMC")));
                tempGrid.setZs(String.valueOf(tempMap.get("ZS")));
                tempGrid.setYcl(String.valueOf(tempMap.get("YCL")));
                tempGrid.setWcl(String.valueOf(tempMap.get("WCL")));
                tempGrid.setCll(String.valueOf(tempMap.get("CLL")));
                tempGrid.setOrganId(String.valueOf(tempMap.get("ORGAN_ID")));
                tempGrid.setYth(String.valueOf(tempMap.get("YTH")));
                //无子节点的情况
                if(!isHasSonOrgan){
                    tempGrid.setState("open");
                }
                tempGrid.setIconCls("empty");
                resultList.add(tempGrid);
            }
        }
        return resultList;
    }

    @Transactional(value="oracle_common",readOnly = true)
    private boolean querySonOrganByOrganId(String organId){
        String sql = "select  to_char(count(*))  num from pf_organ where super_organ_id = '"+organId+"' ";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        List<Object> list = query.getResultList();
        if(Integer.parseInt((String) list.get(0))>0){
            return true;//有子节点
        };
        return false;
    }

    @Transactional(value="oracle_common",readOnly = true)
    private boolean queryIsSgy(String organId){
        String sql = "select to_char(count(*)) from pf_user where user_id ='"+organId+"' ";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        List<Object> list = query.getResultList();
        if(Integer.parseInt((String) list.get(0))>0){
            return true;//是税管员
        };
        return false;
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public Object getHcjdDetail(String organId,String jdlx,String hcxmlx,Pageable pageable,GtSwTzQuery gtSwTzQuery,String minMj,String maxMj) {
        String organIdRemovedZero = organId.replaceAll("00+$", "");//正则，去除字符串中最后2位为0

        //判断是不是由税管员点击进来的
        boolean isSgy = false;
        isSgy = queryIsSgy(organId);

        String sql = "";
        if(Hcxmlx.ZDHC.toString().equals(hcxmlx)){//国土宗地核查
            sql= getHcjdDetailZdhcSql(organIdRemovedZero, isSgy, jdlx,minMj,maxMj);
        }else {//税务登记核查
            sql= getHcjdDetailSwdjhcSql(organIdRemovedZero, isSgy, jdlx);
        }

        sql = addHcjdDetailSqlCondition(sql, gtSwTzQuery);

        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        StringBuffer countSql = new StringBuffer("select count(*) from (").append(sql).append(")");
        Query countQuery = baseRepository.getEntityManager().createNativeQuery(countSql.toString());
        Page page =  baseRepository.find(query, countQuery, pageable);
        return page;
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public List<HashMap> getHcjdDetailZdhcList(String organId,String jdlx,GtSwTzQuery sSjGtbd,String minMj,String maxMj) {
        //判断是不是由税管员点击进来的
        boolean isSgy = false;
        isSgy = queryIsSgy(organId);

        String sql = getHcjdDetailZdhcSql(organId,isSgy,jdlx,minMj,maxMj);
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        if(StringUtils.isNotBlank(sSjGtbd.getExcelBegin()) && StringUtils.isNotBlank(sSjGtbd.getExcelEnd())){
            Integer offset = Integer.parseInt(sSjGtbd.getExcelBegin())-1;
            Integer limit = Integer.parseInt(sSjGtbd.getExcelEnd())-offset;
            query.setFirstResult(offset).setMaxResults(limit);
        }
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        return query.getResultList();
    }


    private String getHcjdDetailZdhcSql(String organIdRemovedZero,Boolean isSgy,String jdlx,String minMj,String maxMj){
        organIdRemovedZero= organIdRemovedZero.replaceAll("00+$", "");//正则，去除字符串中最后2位为0

        String blztSql = "";
        String wclSql="";
        String sql = "";
        if(minMj==null){
            minMj = "";
        }
        if(maxMj==null){
            maxMj = "";
        }
        if(Jdlx.ZS.toString().equals(jdlx)){

        }else if(Jdlx.YCL.toString().equals(jdlx)){
            blztSql = "  and t.blzt='1' ";

        }else if(Jdlx.WCL.toString().equals(jdlx)){
            blztSql = "  and t.blzt='0' ";
            /*wclSql="      AND T.RW_ID NOT IN(select distinct t.rw_id " +
                    "      from sw_hc_xm_rw_rel t " +
                    "      join pf_workflow_instance t1 on t.rw_id= t1.workflow_instance_id " +
                    "      join pf_activity t2 on t1.workflow_instance_id= t2.workflow_instance_id " +
                    "      join " +
                    "      ( " +
                    "          SELECT *  " +
                    "                                  FROM  " +
                    "                                      ( " +
                    "                                          SELECT t.*, RANK() OVER(PARTITION BY t.ACTIVITY_ID, t.USER_ID ORDER BY t.FINISH_TIME DESC) AS PM  " +
                    "                                          FROM " +
                    "                                              ( " +
                    "SELECT *  " +
                    "                                                FROM PF_ASSIGNMENTHISTORY " +
                    "                                                WHERE ASSIGNMENT_ID IN " +
                    "                                                      ( " +
                    "                                                        SELECT TASK_BEFORE " +
                    "                                                        FROM PF_ASSIGNMENTHISTORY  " +
                    "                                                        WHERE ISBACK = '1' " +
                    "                                                       UNION ALL " +
                    "                                                        SELECT TASK_BEFORE " +
                    "                                                        FROM PF_ASSIGNMENT  " +
                    "                                                        WHERE ISBACK = '1' " +
                    "                                                      ) "+
                    "                                              ) t " +
                    "                                      ) " +
                    "                                  WHERE PM = 1 " +
                    "      ) t5 on t5.activity_id=t2.activity_id " +
                    "      join sw_hc_xm t6 on t.hcxm_id=t6.id " ;

            if(isSgy){
                wclSql=wclSql+ "where t6.xmlx='"+ Hcxmlx.ZDHC.toString()+"' and t5.user_id='"+organIdRemovedZero+"' )" ;
            }else{
                wclSql=wclSql+"      join pf_user_organ_rel t7 on t5.user_id=t7.user_id " +
                        "      join pf_organ t8 on t8.organ_id=t7.organ_id " +
                        "      where " +
                        "          t6.xmlx='"+Hcxmlx.ZDHC.toString()+"'  " +
                        "          and t8.organ_id like '"+organIdRemovedZero+"%' "+" AND T.BLZT='0')";
            }*/
        }

        if(isSgy){
            sql = "select to_char(t4.djh)djh,t4.scmj,to_char(t4.tdytmc)tdytmc,to_char(t4.tdzl)tdzl,to_char(t4.qlrmc)qlrmc,t3.gtbd_id,t2.rw_id " +
                    "from " +
                    "    ( " +
                    "        select distinct t.rw_id from sw_hc_xm_rw_rel t " +
                    "        join pf_workflow_instance t1 on t.rw_id= t1.workflow_instance_id " +
                    "        join pf_activity t2 on t1.workflow_instance_id= t2.workflow_instance_id " +
                    "        join ( " +
                    "    SELECT * " +
                    "    FROM ( " +
                    "      SELECT t.* " +
                    "        ,RANK() OVER ( " +
                    "          PARTITION BY t.ACTIVITY_ID " +
                    "          ORDER BY t.FINISH_TIME DESC " +
                    "          ) AS PM " +
                    "      FROM ( " +
                    "        SELECT t.USER_ID " +
                    "          ,t.ACTIVITY_ID " +
                    "          ,t.FINISH_TIME " +
                    "        FROM PF_ASSIGNMENTHISTORY t" +
                    "         " +
                    "        UNION ALL " +
                    "         " +
                    "        SELECT USER_ID " +
                    "          ,ACTIVITY_ID " +
                    "          ,NULL " +
                    "        FROM PF_ASSIGNMENT " +
                    "        ) t " +
                    "      ) t " +
                    "    WHERE PM = 1 " +
                    "        )t5 on t5.activity_id=t2.activity_id " +
                    "  INNER JOIN PF_USER_ORGAN_REL t3 ON t3.USER_ID = t5.USER_ID " +
                    "  INNER JOIN PF_ORGAN t4 ON t3.ORGAN_ID = t4.ORGAN_ID " +
                    "        left join sw_hc_xm t6 on t.hcxm_id=t6.id " +
                    "  join " +
                    "     (SELECT * " +
                    "     FROM ( " +
                    "      SELECT t.* " +
                    "       ,RANK() OVER ( " +
                    "        PARTITION BY t.workflow_instance_id ORDER BY t.FINISH_TIME DESC " +
                    "        ) AS PM " +
                    "      FROM ( " +
                    "       SELECT t.USER_ID " +
                    "        ,t.FINISH_TIME " +
                    "        ,t2.workflow_instance_id " +
                    "        ,substr(t3.organ_id,0,7) as organ_id " +
                    "       FROM PF_ASSIGNMENTHISTORY t " +
                    "       join pf_activity t2 on t2.activity_id = t.activity_id " +
                    "       join pf_user_organ_rel t3 on t3.user_id = t.user_id " +
                    "       ) t " +
                    "      ) t " +
                    "     WHERE PM = 1) t7 " +
                    "     on t7.workflow_instance_id = t2.workflow_instance_id"+/*去除一个流程中由于退回，属于不同分局的节点*/
                    "        where t6.xmlx='"+Hcxmlx.ZDHC.toString()+
                    "'        and t2.ACTIVITY_STATE !='5'/*不统计已退回*/"+
                    "  and t7.organ_id = SUBSTR(t4.ORGAN_ID,0,7) "+
                    "       and t5.user_id='"+organIdRemovedZero+"' " +
                    "         "+blztSql+wclSql+")t1 "+
                    "left join sw_hc_xm_rw_rel t2 on t1.rw_id=t2.rw_id " +
                    "left join s_sj_gtbd t3 on t3.gtbd_id=t2.bd_id " +
                    "left join zd t4 on t4.djh=t3.djh " ;
            sql = sql + " where 1=1 ";
            if(minMj.length()!=0&&maxMj.length()!=0){
                sql= sql+"  AND t3.scmj between '"+minMj+"' AND '"+maxMj+"'";
            }
            if(minMj.length()==0&&maxMj.length()!=0){
                sql= sql+"  AND t3.scmj <'"+maxMj+"'";
            }
            if(minMj.length()!=0&&maxMj.length()==0){
                sql= sql+"  AND t3.scmj >'"+minMj+"'";//拼接过滤的面积条件
            }
        }else{
            sql = "select to_char(t4.djh)djh, t4.scmj, to_char(t4.tdytmc)tdytmc, to_char(t4.tdzl)tdzl, to_char(t4.qlrmc)qlrmc, t3.gtbd_id, t2.rw_id " +
                    "from " +
                    "(  " +
                    "      select distinct t.rw_id " +
                    "      from sw_hc_xm_rw_rel t " +
                    "      join pf_workflow_instance t1 on t.rw_id= t1.workflow_instance_id " +
                    "      join pf_activity t2 on t1.workflow_instance_id= t2.workflow_instance_id " +
                    "      join " +
                    "      ( " +
                    "    SELECT * " +
                    "    FROM ( " +
                    "      SELECT t.* " +
                    "        ,RANK() OVER ( " +
                    "          PARTITION BY t.ACTIVITY_ID " +
                    "          ORDER BY t.FINISH_TIME DESC " +
                    "          ) AS PM " +
                    "      FROM ( " +
                    "        SELECT t.USER_ID " +
                    "          ,t.ACTIVITY_ID " +
                    "          ,t.FINISH_TIME " +
                    "        FROM PF_ASSIGNMENTHISTORY t" +
                    "         " +
                    "        UNION ALL " +
                    "         " +
                    "        SELECT USER_ID " +
                    "          ,ACTIVITY_ID " +
                    "          ,NULL " +
                    "        FROM PF_ASSIGNMENT " +
                    "        ) t " +
                    "      ) t " +
                    "    WHERE PM = 1 " +
                    "      ) t5 on t5.activity_id=t2.activity_id " +
                    "      join sw_hc_xm t6 on t.hcxm_id=t6.id " +
                    "      join pf_user_organ_rel t7 on t5.user_id=t7.user_id " +
                    "      join pf_organ t8 on t8.organ_id=t7.organ_id " +
                    "  join " +
                    "     (SELECT * " +
                    "     FROM ( " +
                    "      SELECT t.* " +
                    "       ,RANK() OVER ( " +
                    "        PARTITION BY t.workflow_instance_id ORDER BY t.FINISH_TIME DESC " +
                    "        ) AS PM " +
                    "      FROM ( " +
                    "       SELECT t.USER_ID " +
                    "        ,t.FINISH_TIME " +
                    "        ,t2.workflow_instance_id " +
                    "        ,substr(t3.organ_id,0,7) as organ_id " +
                    "       FROM PF_ASSIGNMENTHISTORY t " +
                    "       join pf_activity t2 on t2.activity_id = t.activity_id " +
                    "       join pf_user_organ_rel t3 on t3.user_id = t.user_id " +
                    "       ) t " +
                    "      ) t " +
                    "     WHERE PM = 1) t9 " +
                    "     on t9.workflow_instance_id = t2.workflow_instance_id"+/*去除一个流程中由于退回，属于不同分局的节点*/
                    "      where " +
                    "          t6.xmlx='"+Hcxmlx.ZDHC.toString()+"'  " +
                    "          and t2.ACTIVITY_STATE !='5'/*不统计已退回*/"+
                    "  and t9.organ_id = SUBSTR(t8.ORGAN_ID,0,7) "+
                    "          and t8.organ_id like '"+organIdRemovedZero+"%' "+blztSql+wclSql+
                    ")t1 " +
                    "left join sw_hc_xm_rw_rel t2 on t1.rw_id=t2.rw_id " +
                    "left join s_sj_gtbd t3 on t3.gtbd_id=t2.bd_id " +
                    "left join zd t4 on t4.djh=t3.djh ";
            sql = sql + " where 1=1 ";
            if(minMj.length()!=0&&maxMj.length()!=0){
                sql= sql+"  AND t3.scmj between '"+minMj+"' AND '"+maxMj+"'";
            }
            if(minMj.length()==0&&maxMj.length()!=0){
                sql= sql+"  AND t3.scmj <'"+maxMj+"'";
            }
            if(minMj.length()!=0&&maxMj.length()==0){
                sql= sql+"  AND t3.scmj >'"+minMj+"'";//拼接过滤的面积条件
            }
        }
        return sql;
    }


    private String getHcjdDetailSwdjhcSql(String organIdRemovedZero,Boolean isSgy,String jdlx){
        String blztSql = "";
        String wclSql="";
        String sql = "";
        if(Jdlx.ZS.toString().equals(jdlx)){

        }
        if(Jdlx.YCL.toString().equals(jdlx)){
            blztSql = "  and t.blzt='1' ";

        }else if(Jdlx.WCL.toString().equals(jdlx)){
            blztSql = "  and t.blzt='0' ";
            /*wclSql="      AND T.RW_ID NOT IN(select distinct t.rw_id " +
                    "      from sw_hc_xm_rw_rel t " +
                    "      join pf_workflow_instance t1 on t.rw_id= t1.workflow_instance_id " +
                    "      join pf_activity t2 on t1.workflow_instance_id= t2.workflow_instance_id " +
                    "      join " +
                    "      ( " +
                    "          SELECT *  " +
                    "                                  FROM  " +
                    "                                      ( " +
                    "                                          SELECT t.*, RANK() OVER(PARTITION BY t.ACTIVITY_ID, t.USER_ID ORDER BY t.FINISH_TIME DESC) AS PM  " +
                    "                                          FROM " +
                    "                                              ( " +
                    "SELECT *  " +
                    "                                                FROM PF_ASSIGNMENTHISTORY " +
                    "                                                WHERE ASSIGNMENT_ID IN " +
                    "                                                      ( " +
                    "                                                        SELECT TASK_BEFORE " +
                    "                                                        FROM PF_ASSIGNMENTHISTORY  " +
                    "                                                        WHERE ISBACK = '1' " +
                    "                                                       UNION ALL " +
                    "                                                        SELECT TASK_BEFORE " +
                    "                                                        FROM PF_ASSIGNMENT  " +
                    "                                                        WHERE ISBACK = '1' " +
                    "                                                      ) "+
                    "                                              ) t " +
                    "                                      ) " +
                    "                                  WHERE PM = 1 " +
                    "      ) t5 on t5.activity_id=t2.activity_id " +
                    "      join sw_hc_xm t6 on t.hcxm_id=t6.id " ;

            if(isSgy){
                wclSql=wclSql+ "where t6.xmlx='"+ Hcxmlx.TDSYHC.toString()+"' and t5.user_id='"+organIdRemovedZero+"' )" ;
            }else{
                wclSql=wclSql+"      join pf_user_organ_rel t7 on t5.user_id=t7.user_id " +
                        "      join pf_organ t8 on t8.organ_id=t7.organ_id " +
                        "      where " +
                        "          t6.xmlx='"+Hcxmlx.TDSYHC.toString()+"'  " +
                        "          and t8.organ_id like '"+organIdRemovedZero+"%' "+" AND T.BLZT='0')";
            }*/
        }

        if(isSgy){
            sql = "select t3.nsrsbh " +
                    "  ,t3.nsrmc " +
                    "  ,t3.ynmj " +
                    "  ,to_char(t4.djh) djh " +
                    "  ,to_char(t4.qlrmc) qlrmc " +
                    "  ,t4.tdzh " +
                    "  ,t4.scmj " +
                    "  ,t3.td_id " +
                    "  ,t2.rw_id " +
                    "from " +
                    "    ( " +
                    "        select distinct t.rw_id from sw_hc_xm_rw_rel t " +
                    "        join pf_workflow_instance t1 on t.rw_id= t1.workflow_instance_id " +
                    "        join pf_activity t2 on t1.workflow_instance_id= t2.workflow_instance_id " +
                    "        join ( " +
                    "    SELECT * " +
                    "    FROM ( " +
                    "      SELECT t.* " +
                    "        ,RANK() OVER ( " +
                    "          PARTITION BY t.ACTIVITY_ID " +
                    "          ORDER BY t.FINISH_TIME DESC " +
                    "          ) AS PM " +
                    "      FROM ( " +
                    "        SELECT t.USER_ID " +
                    "          ,t.ACTIVITY_ID " +
                    "          ,t.FINISH_TIME " +
                    "        FROM PF_ASSIGNMENTHISTORY t" +
                    "         " +
                    "        UNION ALL " +
                    "         " +
                    "        SELECT USER_ID " +
                    "          ,ACTIVITY_ID " +
                    "          ,NULL " +
                    "        FROM PF_ASSIGNMENT " +
                    "        ) t " +
                    "      ) t " +
                    "    WHERE PM = 1 " +
                    "        )t5 on t5.activity_id=t2.activity_id " +
                    "  INNER JOIN PF_USER_ORGAN_REL t3 ON t3.USER_ID = t5.USER_ID " +
                    "  INNER JOIN PF_ORGAN t4 ON t3.ORGAN_ID = t4.ORGAN_ID " +
                    "        left join sw_hc_xm t6 on t.hcxm_id=t6.id " +
                    "  join " +
                    "     (SELECT * " +
                    "     FROM ( " +
                    "      SELECT t.* " +
                    "       ,RANK() OVER ( " +
                    "        PARTITION BY t.workflow_instance_id ORDER BY t.FINISH_TIME DESC " +
                    "        ) AS PM " +
                    "      FROM ( " +
                    "       SELECT t.USER_ID " +
                    "        ,t.FINISH_TIME " +
                    "        ,t2.workflow_instance_id " +
                    "        ,substr(t3.organ_id,0,7) as organ_id " +
                    "       FROM PF_ASSIGNMENTHISTORY t " +
                    "       join pf_activity t2 on t2.activity_id = t.activity_id " +
                    "       join pf_user_organ_rel t3 on t3.user_id = t.user_id " +
                    "       ) t " +
                    "      ) t " +
                    "     WHERE PM = 1) t7 " +
                    "     on t7.workflow_instance_id = t2.workflow_instance_id"+/*去除一个流程中由于退回，属于不同分局的节点*/
                    "        where t6.xmlx='"+Hcxmlx.TDSYHC.toString()+
                    "'          and t2.ACTIVITY_STATE !='5'/*不统计已退回*/"+
                    "  and t7.organ_id = SUBSTR(t4.ORGAN_ID,0,7) "+
                    " and t5.user_id='"+organIdRemovedZero+"' " +
                    "         "+blztSql+wclSql+")t1 "+
                    "left join sw_hc_xm_rw_rel t2 on t1.rw_id=t2.rw_id " +
                    "left join SW_DJ_TD_WBD t3 on t3.td_id=t2.bd_id " +
                    "left join zd t4 on t4.djh=t3.djh ";
        }else{
            sql = "select t3.nsrsbh " +
                    "  ,t3.nsrmc " +
                    "  ,t3.ynmj " +
                    "  ,to_char(t4.djh) djh " +
                    "  ,to_char(t4.qlrmc) qlrmc " +
                    "  ,t4.tdzh " +
                    "  ,t4.scmj " +
                    "  ,t3.td_id " +
                    "  ,t2.rw_id " +
                    "from " +
                    "(  " +
                    "      select distinct t.rw_id " +
                    "      from sw_hc_xm_rw_rel t " +
                    "      join pf_workflow_instance t1 on t.rw_id= t1.workflow_instance_id " +
                    "      join pf_activity t2 on t1.workflow_instance_id= t2.workflow_instance_id " +
                    "      join " +
                    "      ( " +
                    "    SELECT * " +
                    "    FROM ( " +
                    "      SELECT t.* " +
                    "        ,RANK() OVER ( " +
                    "          PARTITION BY t.ACTIVITY_ID " +
                    "          ORDER BY t.FINISH_TIME DESC " +
                    "          ) AS PM " +
                    "      FROM ( " +
                    "        SELECT t.USER_ID " +
                    "          ,t.ACTIVITY_ID " +
                    "          ,t.FINISH_TIME " +
                    "        FROM PF_ASSIGNMENTHISTORY t" +
                    "         " +
                    "        UNION ALL " +
                    "         " +
                    "        SELECT USER_ID " +
                    "          ,ACTIVITY_ID " +
                    "          ,NULL " +
                    "        FROM PF_ASSIGNMENT " +
                    "        ) t " +
                    "      ) t " +
                    "    WHERE PM = 1 " +
                    "      ) t5 on t5.activity_id=t2.activity_id " +
                    "      join sw_hc_xm t6 on t.hcxm_id=t6.id " +
                    "      join pf_user_organ_rel t7 on t5.user_id=t7.user_id " +
                    "      join pf_organ t8 on t8.organ_id=t7.organ_id " +
                    "  join " +
                    "     (SELECT * " +
                    "     FROM ( " +
                    "      SELECT t.* " +
                    "       ,RANK() OVER ( " +
                    "        PARTITION BY t.workflow_instance_id ORDER BY t.FINISH_TIME DESC " +
                    "        ) AS PM " +
                    "      FROM ( " +
                    "       SELECT t.USER_ID " +
                    "        ,t.FINISH_TIME " +
                    "        ,t2.workflow_instance_id " +
                    "        ,substr(t3.organ_id,0,7) as organ_id " +
                    "       FROM PF_ASSIGNMENTHISTORY t " +
                    "       join pf_activity t2 on t2.activity_id = t.activity_id " +
                    "       join pf_user_organ_rel t3 on t3.user_id = t.user_id " +
                    "       ) t " +
                    "      ) t " +
                    "     WHERE PM = 1) t9 " +
                    "     on t9.workflow_instance_id = t2.workflow_instance_id"+/*去除一个流程中由于退回，属于不同分局的节点*/
                    "      where " +
                    "          t6.xmlx='"+Hcxmlx.TDSYHC.toString()+"'  " +
                    "          and t2.ACTIVITY_STATE !='5'/*不统计已退回*/"+
                    "  and t9.organ_id = SUBSTR(t8.ORGAN_ID,0,7) "+
                    "          and t8.organ_id like '"+organIdRemovedZero+"%' "+blztSql+wclSql+
                    ")t1 " +
                    "left join sw_hc_xm_rw_rel t2 on t1.rw_id=t2.rw_id " +
                    "left join SW_DJ_TD_WBD t3 on t3.td_id=t2.bd_id " +
                    "left join zd t4 on t4.djh=t3.djh ";
            sql = sql + " where 1=1 ";
        }
        return sql;
    }

    private String addHcjdDetailSqlCondition(String sql,GtSwTzQuery gtSwTzQuery){
        if(StringUtils.isNotBlank(gtSwTzQuery.getDjh())){
            sql = sql + " and t3.djh like '%"+gtSwTzQuery.getDjh()+"%' ";
        }
        if(StringUtils.isNotBlank(gtSwTzQuery.getQlrmc())){
            sql = sql + " and t4.qlrmc like '%"+gtSwTzQuery.getQlrmc()+"%' ";
        }
        if(StringUtils.isNotBlank(gtSwTzQuery.getTdytDm())){
            sql = sql + " and t4.tdyt = '"+gtSwTzQuery.getTdytDm()+"' ";
        }
        if(StringUtils.isNotBlank(gtSwTzQuery.getTdzl())){
            sql = sql + " and t4.tdzl like '%"+gtSwTzQuery.getTdzl()+"%' ";
        }
        if(StringUtils.isNotBlank(gtSwTzQuery.getStatue())){
            sql= sql+" and t5.activity_definition_id='"+gtSwTzQuery.getStatue()+"'";
        }
        if(StringUtils.isNotBlank(gtSwTzQuery.getIds())){
            String ids = gtSwTzQuery.getIds();
            String[] idsArr = ids.split(",");
            String idsWhere = CommonUtil.getOracleSQLIn(Arrays.asList(idsArr), 500, "t3.gtbd_id ");
            sql = sql + "and "+idsWhere;
        }

        return sql;
    }

}
