package cn.gtmap.landtax.service.impl;

import cn.gtmap.landtax.entity.*;
import cn.gtmap.landtax.model.dictionary.Dwjb;
import cn.gtmap.landtax.service.DwxxService;
import cn.gtmap.landtax.service.ZdService;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.QueryCondition;
import com.gtis.web.SessionUtil;
import com.mysema.query.jpa.JPQLQuery;
import com.mysema.query.jpa.impl.JPAQuery;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

/**
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2014/7/22
 */
@Service
public class DwxxServiceImpl implements DwxxService {
    @Autowired
    BaseRepository baseRepository;
    @Autowired
    ZdService zdService;

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public List<SDmDwxxCz> getAllDwxx() {
        QSDmDwxxCz qDmDwxxCz = QSDmDwxxCz.sDmDwxxCz;
        return baseRepository.dslList(qDmDwxxCz);
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public SDmDwxxCz getDwxxByDwdm(String dwdm) {
        return baseRepository.get(SDmDwxxCz.class, dwdm);
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public SDmDwxxCz getCityByDwdm(String dwdm) {
        QSDmDwxxCz qDmDwxxCz = QSDmDwxxCz.sDmDwxxCz;
        JPQLQuery jpqlQuery = new JPAQuery(baseRepository.getEntityManager());
        return jpqlQuery.from(qDmDwxxCz).where(qDmDwxxCz.dwdm.eq(dwdm).and(qDmDwxxCz.dwjb.eq(Dwjb.DS.toString()))).uniqueResult(qDmDwxxCz);
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public List<SDmDwxxCz> getCountiesByDwdm(String dwdm) {
        QSDmDwxxCz qDmDwxxCz = QSDmDwxxCz.sDmDwxxCz;
        JPQLQuery jpqlQuery = new JPAQuery(baseRepository.getEntityManager());
        return jpqlQuery.from(qDmDwxxCz).where(qDmDwxxCz.dwdm.like(dwdm+ QueryCondition.WILDCARDS).and(qDmDwxxCz.dwjb.eq(Dwjb.QX.toString()))).list(qDmDwxxCz);
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public List<SDmDwxxCz> getAllQxList() {
        List<SDmDwxxCz> allDwxxList =  getAllDwxx();
        List<SDmDwxxCz> qxDwxxList = new ArrayList<SDmDwxxCz>();
        for(SDmDwxxCz tempVo : allDwxxList){
            if(tempVo.getDwdm().length()==6){
                qxDwxxList.add(tempVo);
            }
        }
        return qxDwxxList;
    }

    public Map<String, String> getAllQxMap(){
        List<SDmDwxxCz> allDwxxList =  getAllDwxx();
        Map<String, String> map = new HashMap<String, String>();
        for(SDmDwxxCz tempVo : allDwxxList){
            if(tempVo.getDwdm().length()==6){
                map.put(tempVo.getDwdm(), tempVo.getDwmc());
            }
        }
        return map;
    }

    public Map<String, String> getAllQxMapByMc(){
        List<SDmDwxxCz> allDwxxList =  getAllDwxx();
        Map<String, String> map = new HashMap<String, String>();
        for(SDmDwxxCz tempVo : allDwxxList){
            if(tempVo.getDwdm().length()==6){
                map.put(tempVo.getDwmc(), tempVo.getDwdm());
            }
        }
        return map;
    }

    @Override
    public List<SDmDwxxCz> getUserQxList() {
        List<SDmDwxxCz> allDwxxList =  getAllDwxx();
        List<SDmDwxxCz> qxDwxxList = new ArrayList<SDmDwxxCz>();

        String swdwdm = getUserQxDm();
        String dwdmStr = zdService.TransQueryXzq(swdwdm);
        List dwdmList= Arrays.asList(dwdmStr.split(","));

        for(SDmDwxxCz tempVo : allDwxxList){
            if(tempVo.getDwdm().length()==6){
                if (dwdmStr.isEmpty() || dwdmStr == "" || dwdmList.contains(tempVo.getDwdm())){
                    qxDwxxList.add(tempVo);
                }
            }
        }
        if (qxDwxxList.size() == 0)
            qxDwxxList = getAllQxList();
        return qxDwxxList;
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public List<SDmDwxxCz> getJdByQx(String qx) {
        if(StringUtils.isBlank(qx)){
            return new ArrayList();
        }
        QSDmDwxxCz qDmDwxxCz = QSDmDwxxCz.sDmDwxxCz;
        JPQLQuery jpqlQuery = new JPAQuery(baseRepository.getEntityManager());
        return jpqlQuery.from(qDmDwxxCz).where(qDmDwxxCz.dwdm.like(qx + QueryCondition.WILDCARDS).and(qDmDwxxCz.dwjb.eq(Dwjb.XZJD.toString()))).list(qDmDwxxCz);
    }

    @Override
    public List<SDmDwxxCz> getJfByJd(String jd) {
        if(StringUtils.isBlank(jd)){
            return new ArrayList();
        }
        QSDmDwxxCz qDmDwxxCz = QSDmDwxxCz.sDmDwxxCz;
        JPQLQuery jpqlQuery = new JPAQuery(baseRepository.getEntityManager());
        return jpqlQuery.from(qDmDwxxCz).where(qDmDwxxCz.dwdm.like(jd + QueryCondition.WILDCARDS).and(qDmDwxxCz.dwjb.eq(Dwjb.CJF.toString()))).list(qDmDwxxCz);
    }

    @Override
    public String getUserQxDm() {
        String swdwdm = "";
        if (SessionUtil.getCurrentUser()!=null) {
            swdwdm = SessionUtil.getCurrentUser().getRegionCode();
            if (swdwdm == null || swdwdm.length() < 6) {
                swdwdm = "";
            } else {
                swdwdm = swdwdm.substring(0, 6);
                if (swdwdm.substring(4, 6) == "00" || swdwdm.substring(4, 6).isEmpty()) {
                    swdwdm = "";
                }
            }
        }

        return swdwdm;
    }

    @Override
    public String getUserRegionCode() {
        String regionCode = "";
        try {
            if (SessionUtil.getCurrentUser() != null) {
                regionCode = SessionUtil.getCurrentUser().getRegionCode();
                if (regionCode == null) {
                    regionCode = "";
                }
            }
        } catch (Exception e) {}

        return regionCode;
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public List<Zgswjg> getZgkgByRegionCode(String regionCode) {
        QZgswjg qzgswjg = QZgswjg.zgswjg;
        JPQLQuery jpqlQuery = new JPAQuery(baseRepository.getEntityManager());
        return jpqlQuery.from(qzgswjg).where(qzgswjg.swbmbm.like("2"+regionCode+ QueryCondition.WILDCARDS)).list(qzgswjg);

    }
    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public List<SDmSwjdxz> getJdByRegion(String regionCode) {
        if(StringUtils.isBlank(regionCode)){
            return new ArrayList();
        }
        QSDmSwjdxz qSDmSwjdxz = QSDmSwjdxz.sDmSwjdxz;
        JPQLQuery jpqlQuery = new JPAQuery(baseRepository.getEntityManager());
        return jpqlQuery.from(qSDmSwjdxz).where(qSDmSwjdxz.dwdm.like(regionCode + QueryCondition.WILDCARDS)).list(qSDmSwjdxz);
    }
}
