package cn.gtmap.landtax.service.impl;

import cn.gtmap.landtax.entity.PublicVo;
import cn.gtmap.landtax.entity.Zgswjg;
import cn.gtmap.landtax.service.DicService;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import com.google.common.collect.Maps;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import com.gtis.config.AppConfig;

import javax.persistence.Query;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.*;

/**
 * 字典项服务
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2014/7/7
 */
@Service
public class DicServiceImpl implements DicService {
    @Autowired
    BaseRepository baseRepository;

    @Autowired
    ArrayList dicRelList;

    @Cacheable(value = "dictionary",key = "#name.concat('buildEnumMap')")
    @Override
    public Map buildEnumMap(String name) throws Exception {
        Map valueMap = Maps.newLinkedHashMap();

        String dicSql = findDicSql(name);

        if (dicSql != null) {
            Query query = baseRepository.getEntityManager().createNativeQuery(dicSql);
            query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
            List<HashMap<String, String>> dicList = query.getResultList();

            for (int i = 0; i < dicList.size(); i++){
                valueMap.put(((HashMap)dicList.get(i)).get("DM"), ((HashMap)dicList.get(i)).get("MC"));
            }
        } else {
            Class clazz = Class.forName("cn.gtmap.landtax.model.dictionary." + name);
            if (clazz.isEnum()) {
                Object[] objects = clazz.getEnumConstants();
                for (Object obj : objects) {
                    Method m = obj.getClass().getDeclaredMethod("values", null);
                    Object[] result = (Object[]) m.invoke(obj, null);
                    List list = Arrays.asList(result);
                    Iterator it = list.iterator();
                    while (it.hasNext()) {
                        Object objOne = it.next();
                        Field dm = objOne.getClass().getDeclaredField("dm");
                        Field mc = objOne.getClass().getDeclaredField("mc");
                        dm.setAccessible(true);
                        mc.setAccessible(true);
                        valueMap.put(dm.get(objOne), mc.get(objOne));
                    }
                    break;
                }
            }
        }
        return valueMap;
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public List findAllZgswjg() {
        String sql = "select swbmbm,mc from dm_swbm ";
        List list = baseRepository.getEntityManager().createNativeQuery(sql).getResultList();
        return list;
    }

    @Override
    @Transactional(value="oracle_common",readOnly = true)
    public String findZgkgMcByZgkgDm(String zgkgDm) {
        Zgswjg zgswjg = baseRepository.get(Zgswjg.class,zgkgDm);
        String zgkgMc = zgswjg.getMc();
        return zgkgMc;
    }

    private String findDicSql(String name) {
        String dicName;
        String dicValue = null;
        if (dicRelList != null) {
            for (int i = 0; i < dicRelList.size(); i++) {
                dicName = ((PublicVo)dicRelList.get(i)).getName();
                if (dicName.equals(name)) {
                    dicValue = ((PublicVo)dicRelList.get(i)).getValue();
                    break;
                }
            }
        }

        return dicValue;
    }
}
