package cn.gtmap.landtax.service;

import cn.gtmap.landtax.entity.*;
import cn.gtmap.landtax.model.query.SbZsQuery;
import cn.gtmap.landtax.model.query.SwDjSyQuery;
import cn.gtmap.landtax.model.query.ZdQuery;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;

/**
 * Created by Administrator on 2014/9/2.
 */
public interface YdqcServiceTaiZhou {
    //宗地疑点清册
    Page findZdList(ZdQuery zdQuery, Pageable pageable);
    public Page findZdListTaiZhou(ZdQuery zdQuery, Pageable pageable);
    List<SwDjSyTemp> findSytzByProid(String proid);
    void zdYdqcWfEnd(String proid)  throws  Exception;
    void zdYdqcWfDel(String proid);
    List<Object> getZdydqcTzListTaiZhou(HashMap param);

    //征收疑点清册
    List<SSjZsydqcTd> getTdZsByIds(List<String> hcxmBdIds);
    List<SSjZsydqcFc> getFcZsByIds(List<String> hcxmBdIds);
    List<String> getzsYearList(String szdm);
    Object findZsListJson(SbZsQuery sbZsQuery, String szdm, Pageable pageable, String sidx, String sord);
    void zsYdqcWfEnd(String proid, String szdm) throws  Exception;
    void zsYdqcWfDel(String proid, String szdm);

    //申报征收公用
    public List<HashMap<String, Object>> sumNynseByGlbm(String szdm, String nsrsbh);
    void saveOrUpdateTdSbXgsqb(TdSbXgsqb tdSbXgsqb) throws  Exception;
    Object getZtById(String id, String hcxmlx);

    public StringBuffer getZsListSql(String szdm, SbZsQuery sbZsQuery);

    BigDecimal getTotalTdNynseByProid(String proid);

    BigDecimal getTotalFcNynseByProid(String proid);

    public BigDecimal getRkseByProid(String proid, String szdm, String ssnf, String sssq);

    List<Zd> findZdListTz(ZdQuery zdQuery);
    /**
     * 国土宗地核查疑点数据
     * @return
     */
    public String getZdydTzListJson();
    public String getZdydTzListJsonTaiZhou();
    //宗地已下发疑点清册
    Page findZdYxfListTaiZhou(ZdQuery zdQuery, Pageable pageable);
    List<Object> getZdYxfTzListTaiZhou(HashMap param);
    //土地等级疑点
    public String getTddjydTzListJson();
    //土地等级疑点税源台账
    Page findSyList(SwDjSyQuery swDjSyQuery, Pageable pageable);
}
