package cn.gtmap.landtax.service;

import cn.gtmap.landtax.entity.TjBaseParamVo;
import cn.gtmap.landtax.model.query.SbZsQuery;
import cn.gtmap.landtax.model.query.SwDjSyQuery;
import cn.gtmap.landtax.util.QueryCondition;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import javax.persistence.Query;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by xuchao on 2014/9/27.
 */
public interface TjService {

    Page<SwDjSyQuery> lzlgTdListJson(SwDjSyQuery swDjSyQuery, Pageable request);

    Object[] lzlgTdHj(SwDjSyQuery swDjSyQuery);

    Object[] lzlgTdHjByTdIds(String ids);

    List<SwDjSyQuery> getLzlgTdList(HashMap param);

    List getTdSyhzF();

    List getTdSyhzS();

    List getFcSyhzF();

    List getFcSyhzS();

    Object tdExcKzhJson(Pageable request);

    Object tdExcKzhAndLzlgJson(Pageable request);

    Object fcExcKzhJson(Pageable request);

    Object fcExcKzhAndLzlgJson(Pageable request);

    Object dhbTjfxJson(SwDjSyQuery swDjSyQuery, StringBuffer listToJson, String regionCode);

    List<HashMap<String, Object>> dhbFxList(SwDjSyQuery swDjSyQuery, String regionCode);

    Object fcsDhbTjfxJson(SwDjSyQuery swDjSyQuery, StringBuffer listToJson, String regionCode);

    List<HashMap<String, Object>> fcsdhbFxList(SwDjSyQuery swDjSyQuery, String regionCode);

    Object tdsFxJson(StringBuffer listToJson, String regionCode);

    List<HashMap<String, Object>> tdsFxList(String regionCode);
    Object fcsFxJson(StringBuffer listToJson, String regionCode);
    List<HashMap<String, Object>> fcsFxList(String regionCode);
    Object tdExcZgNsrZsJson(Pageable request);
    Object fcExcZgNsrZsJson(Pageable request);

    Object tdfcHcjdTjJson(String id, String beginRq, String endRq);

    Object getTjJson(Pageable request, String sqlTag, HashMap queryFilter);
    Object getTjList(String sqlTag, HashMap queryFilter);

    TjBaseParamVo getTjBaseParam(String tag);

    public Page getTjJson(Pageable request, String sqlTag, List<QueryCondition> queryConditionList);
    public List getTjList(String sqlTag, List<QueryCondition> queryConditionList);
    public String getTjSql(String sqlTag);

    // 根据sql语句跟查询条件获取Query
    public Query createQuery(String sql, List<QueryCondition> queryConditions, String orderBy, boolean isQueryTotal);
    public Query createQuery(String sql, String resultExpression, List<QueryCondition> queryConditions, String orderBy, boolean isQueryTotal);

    public Page getSsgxlJson(Pageable request, String nsrsbh, String year);

    public List<HashMap<String, Object>> getAllSsgxl(String nsrsbh, String year);

    public List<HashMap<String, Object>> getSsgxlTjJson(String hyDm, String year);
    /**
     * 获取到绩效列表
     */
    public Page getJxJson(SwDjSyQuery swDjSyQuery,Pageable pageable);
    /*
    查询该税管员的任务列表
     */
    List<HashMap<String,Object>> getRwList(String userId,SwDjSyQuery swDjSyQuery);

     /*
    * 获取土地等级代码
    * */
    HashMap<String,String> getTdjbList();
    /*
    * 获取税源综合统计表json
    * */
    public List<HashMap<String,Object>> syzhtjbJson(String id);
}
