package cn.gtmap.landtax.service;/**
 * Created by janeshen on 2014/8/19.
 */

import cn.gtmap.landtax.entity.*;
import cn.gtmap.landtax.model.query.*;
import com.gtis.plat.wf.model.PerformerTaskModel;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

/**
 * .
 * <p/>
 * 核查项目服务
 * @author shenjian
 * @version V1.0, 2014/8/19
 */
public interface HcxmService {
    /**
     * 创建核查项目
     * @param swHcXm
     * @param gtbdList
     */
    public void createGtzdHcxm(SwHcXm swHcXm,List<SSjGtbd> gtbdList,String userId);

    /**
     * 创建税源补录项目
     * @param swHcXm
     * @param zd
     */
    public String createSyblHcxm(SwHcXm swHcXm,Zd zd,String userId);

    /**
     * 删除核查项目，包括核查项目本身信息，核查项目包含的任务等
     * @param hcxmId
     */
    public void deleteHcxm(String hcxmId) throws Exception;

    /**
     * 只删除项目，不考虑关联关系
     * @param xmId
     */
    void delHcXmByXmid(String xmId);
    /**
     * 获取用户待核查的项目
     * @param pageable
     * @return
     */
    Page<SwHcXm> findDhcxm(HcxmQuery hcxmQuery,Pageable pageable);

    /**
     * 获取核查项目所包含的任务列表
     * @param hcxmId
     * @return
     */
    List<SwHcXmRwRel> findHcxmRw(String hcxmId);

    /**
     * 获取核查项目所包含的任务列表的比对Id
     * @param hcxmId
     * @return
     */
    List<String> findAllHcxmBdId(String hcxmId);

    /**
     * 获取核查项目待下发的任务列表的比对Id
     * @param hcxmId
     * @return
     */
    List<String> findDxfHcxmBdId(String hcxmId);

    SwHcXm getHcxmById(String xmId);

    String getHcxmTaskId(String bdId);

    /**
     * 根据工作流Id获取核查项目对应的比对项目Id
     * @param wiid
     * @return
     */
    String getHcxmBdIdByWiid(String wiid);

    SwHcXmRwRel getSwHcXmRwRelByWiid(String wiid);

    SwHcXmRwRel getSwHcXmRwRelByBdId(String bdId);

    SwHcXmRwRel getSwHcXmRwRelByShxrId(String shxrId);

    void updateSwHcXmRwRel(SwHcXmRwRel swHcXmRwRel);

    void delHcXmRwRelByShxrId(String shxrId);

    void wfEnd(String proid);

    void wfDel(String proid);

    void wfEndSybl(String proid);

    void wfDelSybl(String proid);

    public void createGtzdYdqcHcxm(SwHcXm swHcXm,List<Zd> zdList);

    public SwHcXmRwRel getSwHcXmRwRelByRwid(String rwid);
    public void saveSwDjHisZdYdqc(SwDjSy swDjSy,String proId,String userId,String czlx);

    void createSbydqcHcxm(SwHcXm swHcXm, String[] ydqcIdArr,String szdm);
    /**
     *勾选创建征收疑点核查任务
     */
    void createZsydqcHcxmByGx(SwHcXm swHcXm, String[] ydqcIdArr, String szdm) throws Exception;

    /**
     * 自动下发创建征收疑点核查任务
     * @param swHcXm
     * @param ydqcIdArr
     * @param szdm
     * @throws Exception
     */
    void createZsydqcHcxm(SwHcXm swHcXm, String[] ydqcIdArr, String szdm) throws Exception;

    Page<SwHcXm> findAllHcxm(HcxmQuery hcxmQuery, Pageable request);

    Page findYxfxmlb(HcxmQuery hcxmQuery, Pageable pageable);

    /**
     * 获取核查进度的数据
     * @param hcxmlx 核查项目类型
     * @param regionCode 单位代码，查询该代码下的进度
     * @param ssnf 所属年份
     * @param sssq 所属属期
     * @return
     */
    public String getHcjd(String hcxmlx, String regionCode, String ssnf, String sssq);

    /**
     * 标准版通用 土地征收疑点处理进度统计
     * @param hcxmlx
     * @param id 上级行政区代码
     * @param ssnf
     * @param sssq
     * @return
     */
    public List<DictTreeGrid> getHcjd_common(String hcxmlx, String id, String ssnf, String sssq);

    /**
     * 获取处理进度的数据
     * @param hcxmlx 核查项目类型
     * @param regionCode 单位代码，查询该代码下的处理进度
     * @param ssnf 所属年份
     * @param sssq 所属属期
     * @return
     */
    public String getCljd(String hcxmlx, String regionCode, String ssnf, String sssq);

    /**
     * 获取征收疑点台账
     * @param pageable
     * @param hcxmlx
     * @param xflx
     * @param xzqdm 单位代码
     * @param cllx 处理类型
     * @return
     */
    public Object getWclYclTzJson(Pageable pageable, String hcxmlx, String xflx, String xzqdm, String cllx, String ssnf, String sssq);

    public Object getWclYclTzJson_common(Pageable pageable, String isSwy, String hcxmlx, String xzqdm, String cllx, String ssnf, String sssq);

    /**
     * 获取导出的征收疑点列表
     * @param hcxmlx
     * @param xzqdm 单位代码
     * @param cllx 处理类型
     * @return
     */
    public List<HashMap<String, Object>> getWclYclTzExportJson(String isSwy, String hcxmlx, String xzqdm, String cllx, String ssnf, String sssq);

    SwHcXmRwRel getSwHcXmRwRelByXmlxAndBdId(String xmlx,String bdId);

    Object findDhcrw(HcrwQuery hcrwQuery, Pageable request,HttpServletRequest httpServletRequest);

    List getRoleListByRwId(String workflowInstanceId);

    public List findDhcrwList(HcrwQuery hcrwQuery);

    Object syncHcjdRootJson(String hcxmlx,String id);

    Object syncHcjdRootJson_common(String hcxmlx,String id);

    /**
     * 征收疑点清册核查进度统计
     * @param hcxmlx 核查项目类型，这里只支持土地税征收疑点跟房产税征收疑点的核查项目类型代码
     * @param id 父节点的代码
     * @return 返回List<DictTreeGrid>数据
     */
    public Object zsydHcjdRootJson(String hcxmlx, String id);

    Object syncHctzZdRootJson(String id);
    Object syncHctzSwRootJson(String id);

    public void doSwHcXmRwRel(SwHcXmRwRel swHcXmRwRel);

    public void doUpSwHcXmRwRel(SwHcXmRwRel swHcXmRwRel);

    public void doSwHcXm(SwHcXmRwRel swHcXmRwRel);
    public void doUpSwHcXm(SwHcXmRwRel swHcXmRwRel);

    List getDxfrwList(HcrwQuery hcrwQuery);

    Object getHcjdDetailZdhc(String xzqdm,String jdlx,Pageable pageable,GtSwTzQuery sSjGtbd);

    Object getZdhcTJrws(String xzqdm, String jdlx, GtSwTzQuery sSjGtbd) throws  Exception;

    List<HashMap> getHcjdDetailZdhcList(String xzqdm,String jdlx,GtSwTzQuery sSjGtbd);

    Object getHcjdDetailGdhc(String xzqdm, String jdlx, Pageable pageable, SwDjQsQuery swDjQsQuery);

    Object getGdhcTJrws(String xzqdm, String jdlx, SwDjQsQuery swDjQsQuery)throws Exception;

    List<HashMap> getHcjdDetailGdhcList(String xzqdm, String jdlx, SwDjQsQuery swDjQsQuery);

    Object getHcjdDetailBphc(String xzqdm, String jdlx, Pageable pageable, GdzysQuery gdzysQuery);

    Object getBphcTJrws(String xzqdm, String jdlx, GdzysQuery gdzysQuery) throws  Exception;

    List<HashMap> getHcjdDetailBphcList(String xzqdm, String jdlx, GdzysQuery gdzysQuery);

    Boolean isYbjByProid(String proid);

    public PerformerTaskModel getTurnUserList(String userId,String proid) throws  Exception;

    public String initTurnTaskXml(String proid,String userId,String taskid)throws Exception;
    public List findThyj(String rwId, String xzqdm);
    public List findUsers(String rwId);
    /**
     * 创建不动产登记核查项目
     * @param swHcXm
     * @param gtbdList
     */
    public void createBdcHcxm(SwHcXm swHcXm,List<SSjGtbd> gtbdList,String userId);
    /**
     * 导出代办任务
     */
    List getDbRw();
    /**
     * 导出已办任务
     */
    List getYbRw();
}
