package cn.gtmap.landtax.quartz.quartzImpl;

import cn.gtmap.landtax.model.dictionary.Szdm;
import cn.gtmap.landtax.model.dictionary.Ydtype;
import cn.gtmap.landtax.quartz.TbSbSjQuartz;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.support.jpa.BaseRepository_hl;
import cn.gtmap.landtax.util.CommonUtil;
import com.gtis.config.AppConfig;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.Query;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

/**
 * 榆林专用定时器
 * Created by Zenglihuan on 20161114
 */
public class TbSbSjQuartz_yulin implements TbSbSjQuartz {
    protected final Logger logger = Logger.getLogger(getClass());

    @Autowired
    BaseRepository baseRepository;

    @Autowired
    BaseRepository_hl baseRepository_hl;

    /**
     * 更新宗地出租自用状态
     */
    @Transactional(value="oracle_common")
    public void updateZdzt_zycz(){
        logger.info("*******************************更新宗地状态开始");

        // 自用
        String zySql = "UPDATE DM_ZDZT_ZYCZ SET DM='01', MC='自用', UPDATETIME=sysdate WHERE DJH IN " +
                "(SELECT t1.DJH FROM ZD t1 " +
                "left join sw_dj_sy t2 on t1.djh=t2.djh " +
                "left join (select sy_id, COUNT(DISTINCT TDSYZT_DM) as count1 from sw_dj_td where TDSYZT_DM in ('01', '02') group by sy_id) t3 on t2.sy_id=t3.sy_id " +
                "left join (select sy_id, COUNT(DISTINCT TDSYZT_DM) as count2 from sw_dj_td where TDSYZT_DM not in ('01', '02') and TDSYZT_DM is not null group by sy_id) t4 on t2.sy_id=t4.sy_id " +
                "where t1.djh is not null and count1>=1 and count2 is null)";
        Query query = baseRepository.getEntityManager().createNativeQuery(zySql);
        query.executeUpdate();

        // 出租
        String czSql = "UPDATE DM_ZDZT_ZYCZ SET DM='02', MC='出租', UPDATETIME=sysdate WHERE DJH IN " +
                "(SELECT t1.DJH FROM ZD t1 " +
                "left join sw_dj_sy t2 on t1.djh=t2.djh " +
                "left join (select sy_id, COUNT(DISTINCT TDSYZT_DM) as count1 from sw_dj_td where TDSYZT_DM in ('03') group by sy_id) t3 on t2.sy_id=t3.sy_id " +
                "left join (select sy_id, COUNT(DISTINCT TDSYZT_DM) as count2 from sw_dj_td where TDSYZT_DM not in ('03') and TDSYZT_DM is not null group by sy_id) t4 on t2.sy_id=t4.sy_id " +
                "where t1.djh is not null and count1=1 and count2 is null)";
        query = baseRepository.getEntityManager().createNativeQuery(czSql);
        query.executeUpdate();


        // 部分自用部分出租
        String czzySql = "UPDATE DM_ZDZT_ZYCZ SET DM='03', MC='部分自用部分出租', UPDATETIME=sysdate WHERE DJH IN " +
                "(SELECT t1.DJH FROM ZD t1 " +
                "left join sw_dj_sy t2 on t1.djh=t2.djh " +
                "left join (select sy_id, COUNT(DISTINCT TDSYZT_DM) as count1 from sw_dj_td where TDSYZT_DM in ('05') group by sy_id) t3 on t2.sy_id=t3.sy_id " +
                "left join (select sy_id, COUNT(DISTINCT TDSYZT_DM) as count2 from sw_dj_td where TDSYZT_DM in ('01', '03') group by sy_id) t4 on t2.sy_id=t4.sy_id " +
                "left join (select sy_id, COUNT(DISTINCT TDSYZT_DM) as count3 from sw_dj_td where TDSYZT_DM in ('02', '03') group by sy_id) t5 on t2.sy_id=t5.sy_id " +
                "where t1.djh is not null and (count1=1 or count2=2 or count3=2))";
        query = baseRepository.getEntityManager().createNativeQuery(czzySql);
        query.executeUpdate();

        logger.info("*******************************更新宗地状态结束");
    }

    public void executeCopyJsData(){}

    public void execute(){}

    public void createYdqc(){}

    public String getTdZsYdqcSql(int year, int sqBegin, int sqEnd, String ydType){return null;}
    public String getFcZsYdqcSql(int year, int sqBegin, int sqEnd, String ydType){
        int fcsqs = new Integer(AppConfig.getProperty("fcsqs"));
        int sqTotal = fcsqs;
        int sqCount = sqEnd - sqBegin + 1;
        String startRq = String.valueOf(year) + StringUtils.right("0" + String.valueOf((sqBegin - 1) * (12 / sqTotal) + 1), 2);
        String endRq = String.valueOf(year) + StringUtils.right("0" + String.valueOf(sqEnd * (12 / sqTotal)), 2);
        String sssq = String.valueOf((sqBegin - 1) * sqTotal + sqEnd);
        String startNfSq = String.valueOf(year * sqTotal + sqBegin);
        String endNfSq = String.valueOf(year * sqTotal + sqEnd);

        String sql = "";

        sql = "INSERT INTO S_SJ_ZSYDQC_FC (FCZSYD_ID, JBB_ID, GLBM, NSRSBH, YSYZ, YJSE, RKSE, CYJE, CYBL, YSZJ, NSRMC, SGYDM, SSJG, QXDM, SSNF, SSSQ, YDTYPE) " +
                "SELECT SYS_GUID(), t2.JBB_ID, NULL, t2.NSRSBH, t2.YSYZ, t2.YJSE, t1.RKSE, t2.YJSE - NVL(t1.RKSE,0), DECODE(t2.YJSE, 0, 0, (t2.YJSE - NVL(t1.RKSE,0))/t2.YJSE),  " +
                "t2.YSZJ, t2.NSRMC, NULL, t2.SSJG, SUBSTR(t2.SSJG, 2, 6), ':year', ':sssq', ':ydType' " +
                "FROM  " +
                "  (SELECT NSRSBH, " +
                "          ROUND(SUM(SJJE / (ENDNFSQ - STARTNFSQ + 1) * DECODE(SIGN(LEAST(ENDNFSQ, " + endNfSq + ") - GREATEST(STARTNFSQ, " + startNfSq + ")), -1, 0,  LEAST(ENDNFSQ, " + endNfSq + ") - GREATEST(STARTNFSQ, " + startNfSq + ") + 1)), 2) AS RKSE " +
                "   FROM (SELECT t2.NSRSBH, t1.SJJE, t1.RKRQ, t1.SKSSQQ, t1.SKSSQZ, " +
                "            (TO_NUMBER(TO_CHAR(t1.SKSSQZ, 'YYYY')) * :sqTotal + TRUNC((TO_NUMBER(TO_CHAR(t1.SKSSQZ, 'MM')) - 1) / 12 * :sqTotal) + 1) AS ENDNFSQ,  " +
                "            (TO_NUMBER(TO_CHAR(t1.SKSSQQ, 'YYYY')) * :sqTotal + TRUNC((TO_NUMBER(TO_CHAR(t1.SKSSQQ, 'MM')) - 1) / 12 * :sqTotal) + 1) AS STARTNFSQ  " +
                "         FROM ZS_JKS t1, DJ_NSRXX t2 " +
                "         WHERE t1.DJXH=t2.DJXH AND t1.ZSXM_DM IN ('10111') AND t1.SJJE > 0 AND t1.RKRQ IS NOT NULL " +
                "         AND ((TO_CHAR(t1.SKSSQQ, 'YYYYMM') >= ':startRq' AND TO_CHAR(t1.SKSSQZ, 'YYYYMM') <= ':endRq') " +
                "             OR (TO_CHAR(t1.SKSSQQ, 'YYYYMM') >= ':startRq' AND TO_CHAR(t1.SKSSQQ, 'YYYYMM') <= ':endRq') " +
                "             OR (TO_CHAR(t1.SKSSQZ, 'YYYYMM') >= ':startRq' AND TO_CHAR(t1.SKSSQZ, 'YYYYMM') <= ':endRq'))) " +
                "   GROUP BY NSRSBH) t1 " +
                "RIGHT JOIN  " +
                "  (SELECT MAX(tt1.JBB_ID) AS JBB_ID, tt2.NSRSBH, MAX(tt2.NSRMC) AS NSRMC, SUM(tt1.FCYZ_YS) AS YSYZ, MAX(tt2.ZGKG_DM) AS SSJG,  " +
                "   SUM(tt1.YNSE_CZ) AS YSZJ, SUM(NYNSE) / :sqTotal * :sqCount AS YJSE " +
                "   FROM SW_DJ_FC tt1 INNER JOIN SW_DJ_JBB tt2 ON tt1.JBB_ID = tt2.JBB_ID  " +
                "   GROUP BY tt2.NSRSBH) t2 " +
                "ON t1.NSRSBH=t2.NSRSBH " +
                "WHERE t1.NSRSBH IN (SELECT NSRSBH FROM SW_DJ_JBB MINUS SELECT DISTINCT NSRSBH FROM S_SJ_ZSYDQC_TD WHERE SSNF = ':year' AND SSSQ = ':sssq')  " +
                "AND (NOT (NVL(t2.YJSE, 0) > 0 AND ABS(NVL((t2.YJSE - t1.RKSE)/t2.YJSE, 0)) < 0.01)) AND (NOT (NVL(t2.YJSE, 0) <= 0 AND NVL(t1.RKSE, 0) <= 0)) ";

        sql = sql.replaceAll(":year", String.valueOf(year));
        sql = sql.replaceAll(":sqBegin", String.valueOf(sqBegin));
        sql = sql.replaceAll(":sqEnd", String.valueOf(sqEnd));
        sql = sql.replaceAll(":ydType", Ydtype.HCH.toString());
        sql = sql.replaceAll(":sqTotal", String.valueOf(sqTotal));
        sql = sql.replaceAll(":sqCount", String.valueOf(sqCount));
        sql = sql.replaceAll(":startRq", startRq);
        sql = sql.replaceAll(":endRq", endRq);
        sql = sql.replaceAll(":endNfSq", endNfSq);
        sql = sql.replaceAll(":startNfSq", startNfSq);
        sql = sql.replaceAll(":sssq", sssq);

        return sql;
    }

}
