package cn.gtmap.landtax.quartz.quartzImpl;

import cn.gtmap.landtax.model.dictionary.Szdm;
import cn.gtmap.landtax.model.dictionary.Ydtype;
import cn.gtmap.landtax.quartz.TbSbSjQuartz;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.support.jpa.BaseRepository_hl;
import cn.gtmap.landtax.util.CommonUtil;
import java.math.BigDecimal;
import com.gtis.config.AppConfig;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.Query;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

/**
 * 江苏接口专用定时器
 * Created by Zenglihuan on 20160922
 */
public class TbSbSjQuartz_jiangsu implements TbSbSjQuartz {
    protected final Logger logger = Logger.getLogger(getClass());

    @Autowired
    BaseRepository baseRepository;

    @Autowired
    BaseRepository_hl baseRepository_hl;

    /**
     * 更新宗地出租自用状态
     */
    @Transactional(value="oracle_common")
    public void updateZdzt_zycz(){
        logger.info("*******************************更新宗地状态开始");

        logger.info("*******************************更新宗地状态结束");
    }

    /**
     * 将金三或征管的数据从回流库抽取到业务库中
     */
    @Transactional(value="oracle_common")
    public void executeCopyJsData(){
        logger.info("****************executeCopyZgData开始(抽取征管数据到业务库中)********************");

        //同步征收缴款税数据（先删除后新增）
        //删除
        String deleteSql_jks = "DELETE FROM ZS_JKS";
        Query query = baseRepository.getEntityManager().createNativeQuery(deleteSql_jks);
        query.executeUpdate();
        //新增
        String insertSql_jks =
                "INSERT INTO ZS_JKS(SPUUID, DJXH, SKSSQQ, SKSSQZ, ZSXM_DM, SJJE, RKRQ, LRRQ, XGRQ) " +
                "(SELECT SPUUID, DJXH, SKSSQQ, SKSSQZ, ZSXM_DM, SJJE, RKRQ, LRRQ, XGRQ FROM HLK_ZS_JKS) ";
        query = baseRepository.getEntityManager().createNativeQuery(insertSql_jks);
        query.executeUpdate();

        //同步纳税人信息数据（先删除后新增）
        //删除
        String deleteSql_nsrxx = "DELETE FROM DJ_NSRXX";
        query = baseRepository.getEntityManager().createNativeQuery(deleteSql_nsrxx);
        query.executeUpdate();
        //新增
        String insertSql_nsrxx =
                "INSERT INTO DJ_NSRXX(DJXH, NSRBM, NSRSBH, NSRMC, SHXYDM, DJZCLX_DM, FDDBRXM, HY_DM, ZCDZ, SSGLY_DM, ZGSWSKFJ_DM, LRRQ, XGRQ) " +
                "(SELECT DJXH, NSRBM, NSRSBH, NSRMC, SHXYDM, DJZCLX_DM, FDDBRXM, HY_DM, ZCDZ, SSGLY_DM, ZGSWSKFJ_DM, LRRQ, XGRQ FROM HLK_DJ_NSRXX " +
                "WHERE KZZTDJLX_DM IN ('1110', '1120', '1131', '1132', '1133', '1134', '1135', '1136', '1137') " +
                "AND NSRZT_DM IN ('03')) ";
        query = baseRepository.getEntityManager().createNativeQuery(insertSql_nsrxx);
        query.executeUpdate();

        //同步纳税人扩展信息数据（先删除后新增）
        //删除
        String deleteSql_nsrxx_kz = "DELETE FROM DJ_NSRXX_KZ";
        query = baseRepository.getEntityManager().createNativeQuery(deleteSql_nsrxx_kz);
        query.executeUpdate();
        //新增
        String insertSql_nsrxx_kz =
                "INSERT INTO DJ_NSRXX_KZ(DJXH, SCJYDLXDH, LRRQ, XGRQ) " +
                "(" +
                "  SELECT DJXH, SCJYDLXDH, LRRQ, XGRQ FROM HLK_DJ_NSRXX_KZ WHERE DJXH NOT IN " +
                "  (SELECT DJXH FROM HLK_DJ_NSRXX " +
                "  WHERE KZZTDJLX_DM IN ('1110', '1120', '1131', '1132', '1133', '1134', '1135', '1136', '1137') " +
                "  AND NSRZT_DM IN ('03')) " +
                ") ";
        query = baseRepository.getEntityManager().createNativeQuery(insertSql_nsrxx_kz);
        query.executeUpdate();

        String HYDM_LEVELS = AppConfig.getProperty("HYDM_LEVELS");
        String HYDM_SQL = "";
        if("2".equals(HYDM_LEVELS)){
            HYDM_SQL = "LENGTH(t6.DM)=3 AND SUBSTR(t1.HY_DM, 1, 2) = SUBSTR(t6.DM, 2, 2)";
        }else if("3".equals(HYDM_LEVELS)){
            HYDM_SQL = "LENGTH(t6.DM)=5 AND t1.HY_DM = SUBSTR(t6.DM, 2, 4)";
        }else{
            return;
        }

        //同步SW_DJ_JBB数据（先删除后新增）
        //删除
        String deleteSql_sw_dj_jbb = "DELETE FROM SW_DJ_JBB WHERE DJXH IS NOT NULL";
        query = baseRepository.getEntityManager().createNativeQuery(deleteSql_sw_dj_jbb);
        query.executeUpdate();
        //新增
        String insertSql_sw_dj_jbb =
                "INSERT INTO SW_DJ_JBB(NSRSBH, GLBM, NSRMC, SHXYDM, ZGKG_MC, SGY_MC, FDDBR, LXDH, ZCLX_DM, " +
                "ZCLX_MC, HY_DM, HY_MC, ZCDZ, ZGKG_DM, JBB_ID, SGY_DM, DJXH) " +
                "(" +
                "  SELECT t1.NSRSBH, t1.NSRBM, t1.NSRMC, t1.SHXYDM, t3.MC AS ZGKG_MC, t4.USER_NAME AS SGY_MC, t1.FDDBRXM AS FDDBR, t2.SCJYDLXDH AS LXDH, t1.DJZCLX_DM AS ZCLX_DM, " +
                "  t5.MC AS ZCLX_MC, t6.DM AS HY_DM, t6.MC AS HY_MC, t1.ZCDZ, t1.ZGSWSKFJ_DM AS ZGKG_DM, t1.DJXH, t1.SSGLY_DM AS SGY_DM, t1.DJXH" +
                "  FROM DJ_NSRXX t1" +
                "  LEFT JOIN DJ_NSRXX_KZ t2 ON t1.DJXH = t2.DJXH" +
                "  LEFT JOIN DM_SWBM t3 ON t1.ZGSWSKFJ_DM = t3.SWBMBM" +
                "  LEFT JOIN PF_USER t4 ON t1.SSGLY_DM = t4.USER_NO" +
                "  LEFT JOIN DM_ZCLX t5 ON t1.DJZCLX_DM = t5.DM" +
                "  LEFT JOIN DM_HYDM t6 ON " + HYDM_SQL +
                ") ";
        query = baseRepository.getEntityManager().createNativeQuery(insertSql_sw_dj_jbb);
        query.executeUpdate();
//增量更新税源数据
//        String querySql ="select t1.syuuid as jstd_id  , t3.td_id  as  td_id,rtrim(t1.djxh)as djxh ,t2.ysuuid from sb_cxs_tdsyxxcjb t1 left join sb_cxs_tdsyysxx t2 on t1.syuuid=t2.syuuid  left join  dsnj.sw_dj_td  t3 on t1.syuuid =t3.td_id  left join sb_cxs_ysjmxzxx_0112 t4 on t2.ysuuid = t4.ysuuid ";
//        Query queryList = baseRepository.getEntityManager().createNativeQuery(querySql);
//        List<Object[]> list =  queryList.getResultList();
//        for(Object[] obj:list){
//            String jstdId=obj[0].toString();
//            String tdId=obj[1].toString();
//            String djxh=obj[2].toString();
//            String ysuuid=obj[3].toString();
//            //金三的td_id为空，地税的td_id不为空,根据金三的的td_id删除地税的税源数据
//            if(jstdId==""){
//            String deleteSwdjtdSql ="delete from sw_dj_td where td_id='"+tdId+"'";
//            query = baseRepository.getEntityManager().createNativeQuery(deleteSwdjtdSql);
//            query.executeUpdate();
//            }
//            if(tdId==""){
//             //自动生成sy_id
//            String sqlSy_id = "select jbb_id from sw_dj_jbb where djxh= '"+djxh+"'";
//            String sy_id = String.valueOf(baseRepository.getEntityManager().createNativeQuery(sqlSy_id).getSingleResult());
//            //通过关联查询的djxh去土地表中查询jbb_id
//            String sqlJbb_id = "select sys_guid() from dual  ";
//            String jbb_id = String.valueOf(baseRepository.getEntityManager().createNativeQuery(sqlJbb_id).getSingleResult());
//            //通过ysuuid查询jmmj
//            String sqlYsuuid = "select sum(jmmj) from sb_cxs_tdsyysxx_0112 t1 left join sb_cxs_ysjmxzxx_0112 t2 on t1.ysuuid =t2.ysuuid where t1.syuuid = '"+ysuuid+"' group by jmmj ";
//            String jmmj = String.valueOf(baseRepository.getEntityManager().createNativeQuery(sqlYsuuid).getSingleResult());
//            //向sw_dj_td 添加数据
//            String InsertSwdjtdSql ="insert into dsnj.sw_dj_td (td_id,sy_id,jbb_id,tdzl,zdmj,ynmj,dwse,nynse,tddj,tdsyzh,lrrq,msmj,msse,scmj,sgzt_dm,sgzt_mc,sjly,sybh) (select t1.syuuid,'"+sy_id+"'"+",'"+jbb_id+""+"',t1.tdzldz,t2.ystdmj,t2.dwse,t2.ystdmj,t2.dwse*t2.ystdmj,(select dwdm from S_DM_DWXX_CZ t where dwjb ='0')||t2.tddj_dm,t1.tdsyzbh,t1.tbrq,'"+jmmj+"','"+jmmj+"*msse',t2.ystdmj,'01','控管户','1',rtrim(t1.djxh)from sb_cxs_tdsyxxcjb_0112 t1 left join sb_cxs_tdsyysxx_0112 t2 on t1.syuuid=t2.syuuid left join sb_cxs_ysjmxzxx_0112 t3 on t2.ysuuid = t3.ysuuid where t1.syuuid='"+jstdId+"')";
//            query = baseRepository.getEntityManager().createNativeQuery(InsertSwdjtdSql);
//            query.executeUpdate();
//            //向sw_dj_sy添加数据
//            String InsertSwdjsySql ="insert into dsnj.sw_dj_sy (sy_id,sjly,djh)(select '"+sy_id+"'"+",'1', replace((t1.jdxz_dm||'9999990'||t2.tddj_dm),' ','')  from sb_cxs_tdsyxxcjb_0112 t1 left join sb_cxs_tdsyysxx_0112 t2 on t1.syuuid=t2.syuuid  where t1.syuuid='"+jstdId+"')";
//            query = baseRepository.getEntityManager().createNativeQuery(InsertSwdjsySql);
//            query.executeUpdate();
//            }
//            if(jstdId!=""&&tdId!=""){
//
//                //根据金三的td_id更新sw_dj_td的数据
//                //通过ysuuid查询jmmj
//             String sqlYsuuid = "select sum(jmmj) from sb_cxs_tdsyysxx_0112 t1 left join sb_cxs_ysjmxzxx_0112 t2 on t1.ysuuid =t2.ysuuid where t1.syuuid = '"+ysuuid+"' group by jmmj ";
//             String jmmjInfo = String.valueOf(baseRepository.getEntityManager().createNativeQuery(sqlYsuuid).getSingleResult());
//             BigDecimal msmj=new BigDecimal(jmmjInfo);
//             String queryJstdSql ="select t2.ystdmj as ynmj,t2.dwse, trim((select dwdm from dsnj.S_DM_DWXX_CZ t where dwjb ='0')||t2.tddj_dm) as tddj ,t2.ystdmj*t2.dwse as nynse from sb_cxs_tdsyxxcjb_0112 t1 left join sb_cxs_tdsyysxx_0112 t2  on t1.syuuid = t2.syuuid  left join dsnj.sw_dj_td t3  on t1.syuuid = t3.td_id;";
//             Query queryJstdList = baseRepository.getEntityManager().createNativeQuery(queryJstdSql);
//             List<Object[]> listJstd =  queryJstdList.getResultList();
//                for(Object[] objJstd :listJstd){
//                    String ynmj =objJstd[0].toString();
//                    String dwseInfo =objJstd[1].toString();
//                    BigDecimal dwse=new BigDecimal(dwseInfo);
//                    String tddj =objJstd[2].toString();
//                    String nynse =objJstd[3].toString();
//                    BigDecimal msse =msmj.multiply(dwse);
//                    String updateSwdjtdSql ="update dsnj.sw_dj_td set ynmj ='"+ynmj+"',dwse='"+dwse+"',tddj='"+tddj+"',msmj='"+msmj+"',nynse='"+nynse+"',msse='"+msse+"' where td_id='"+tdId+"'";
//                    query = baseRepository.getEntityManager().createNativeQuery(updateSwdjtdSql);
//                    query.executeUpdate();
//                }
//            }
      //  }
        logger.info("*******************************executeCopyZgData结束");
    }

    @Transactional(value="oracle_common")
    public void execute(){
        /**
         * 从征管数据中的T_ZS_JKMX抽取到LOCAL_SB_RKSS表中
         */
        logger.info("*******************************executeStoreZs开始");
        executeStoreZs();
        logger.info("*******************************executeStoreZs结束");
        /**
         * 更新处理后入库税额和处理后差异比例
         */
        executeTdZsWfEnd();
    }

    private void executeTdZsWfEnd(){
        //土地征收
        Query query;
        String sql = "";

        //一年分几个属期的变量（土地征收按季度征收，一年分4期）
        String sqCount = "4";
        //本期加年份的所属属期分变量表达式（加年份的原因是：防止跨年情况发生）
        //加年份的结束属期
        String zsEndNfsq = "(TO_NUMBER(TO_CHAR(b.TAXTERMEND, 'YYYY')) * :sqCount + TRUNC((TO_NUMBER(TO_CHAR(b.TAXTERMEND, 'MM')) - 1) * :sqCount / 12) + 1)";
        //加年份的开始属期
        String zsStartNfsq = "(TO_NUMBER(TO_CHAR(b.TAXTERMBEGIN, 'YYYY')) * :sqCount + TRUNC((TO_NUMBER(TO_CHAR(b.TAXTERMBEGIN, 'MM')) - 1) * :sqCount / 12) + 1)";
        //加年份的结束疑点属期
        String ydEndNfsq = "(a.SSNF * :sqCount + (MOD((TO_NUMBER(a.SSSQ) - 1), 4) + 1))";
        //加年份的开始疑点属期
        String ydStartNfsq = "(a.SSNF * :sqCount + (TRUNC((TO_NUMBER(a.SSSQ) - 1) / 4, 0) + 1))";
        // 本期所属税款的计算表达式
        String bqSkExp = "b.NSE / (:zsEndNfsq - :zsStartNfsq + 1) * DECODE(SIGN(LEAST(:zsEndNfsq, :ydEndNfsq) - GREATEST(:zsStartNfsq, :ydStartNfsq)), -1, 0,  LEAST(:zsEndNfsq, :ydEndNfsq) - GREATEST(:zsStartNfsq, :ydStartNfsq) + 1)";
        // 将变量表达式替换成变量值
        bqSkExp = bqSkExp.replaceAll(":zsEndNfsq", zsEndNfsq);
        bqSkExp = bqSkExp.replaceAll(":zsStartNfsq", zsStartNfsq);
        bqSkExp = bqSkExp.replaceAll(":ydEndNfsq", ydEndNfsq);
        bqSkExp = bqSkExp.replaceAll(":ydStartNfsq", ydStartNfsq);

        /**
         * 结束属期：(MOD((TO_NUMBER(a.SSSQ) - 1), 4) + 1)
         * 开始属期：(TRUNC((TO_NUMBER(a.SSSQ) - 1) / 4, 0) + 1)
         */
        sql =   "UPDATE S_SJ_ZSYDQC_TD a " +
                "SET a.END_SBSE=( " +
                "    SELECT NVL(ROUND(SUM(" + bqSkExp + "), 2), 0) " +
                "    FROM LOCAL_SB_RKSS b " +
                "    WHERE " + ydEndNfsq + "<=" + zsEndNfsq + "AND " + ydStartNfsq + ">=" + zsStartNfsq +
                "           AND b.SZDM='13' AND a.NSRSBH=b.NSRSBH) " +
                "WHERE a.END_CYBL IS NULL AND EXISTS (SELECT 1 FROM SW_HC_XM_RW_REL c WHERE c.BLZT='1' AND a.RWID=c.RW_ID)";
        sql = sql.replaceAll(":sqCount", sqCount);

        query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.executeUpdate();

        // 更新处理后差异比例
        sql =   "UPDATE S_SJ_ZSYDQC_TD SET END_CYBL= DECODE(NVL(END_YJSE, 0), 0, 0, NVL(END_SBSE, 0) / END_YJSE) " +
                "WHERE END_CYBL IS NULL AND END_SBSE IS NOT NULL";
        query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.executeUpdate();
    }

    private void executeStoreZs(){
        /**
         * 读取征管系统数据，生成“征收入库税收”数据
         * SZDM为"13"是城镇土地使用税
         * T_ZS_JKMX中的SPUUID是唯一的
         * 其中ZSXM_DM为'10112'时是土地税
         */

        String sql = "";
        sql =   "INSERT INTO LOCAL_SB_RKSS (SB_NUM, GLBM, NSRSBH, FSRQ, NSE, SZDM, TAXTERMBEGIN, TAXTERMEND) " +
                "SELECT t1.SPUUID AS SB_NUM, NULL, t2.NSRSBH, t1.RKRQ AS FSRQ, t1.SJJE AS NSE, DECODE(t1.ZSXM_DM,'10112','13','11')SZDM, t1.SKSSQQ AS TAXTERMBEGIN, t1.SKSSQZ AS TAXTERMEND " +
                "FROM ZS_JKS t1 " +
                "INNER JOIN DJ_NSRXX t2 ON t1.DJXH=t2.DJXH " +
                "LEFT JOIN LOCAL_SB_RKSS t3 ON t1.SPUUID=t3.SB_NUM " +
                "WHERE t3.SB_NUM IS NULL  AND t1.SJJE > 0 AND t1.RKRQ IS NOT NULL ";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.executeUpdate();
    }

   //******************************************************************************************************************************************************************************************
    /**
     * 5月1日 至 10月31日每晚23点 执行该任务
     * 当前时间月份在 5-9之间生成上半年清册（期间只生成一次，多次执行是判断是否生成），
     * 当前时间月份是10生成下半年清册，
     * 任务：
     * 1，生成申报土地疑点清册
     * 2，生成申报房产疑点清册
     * 3，生成征收土地疑点清册
     * 4，生成征收房产疑点清册
     */

    @Transactional(value="oracle_common")
    public void createYdqc(){

        Calendar calendar = Calendar.getInstance();
        int month = calendar.get(Calendar.MONTH)+1;
        int year = calendar.get(Calendar.YEAR);
        //*************************************************创建土地征收疑点清册
        logger.info("*******************************createTdZsYdqc开始");
        createTdZsYdqc(year,month);
        logger.info("*******************************createTdZsYdqc结束");
        //*************************************************创建房产征收疑点清册
        logger.info("*******************************createFcZsYdqc开始");
        createFcZsYdqc(year, month);
        logger.info("*******************************createFcZsYdqc结束");
    }

    private void createTdZsYdqc(int year, int month){
        int tdsqs = new Integer(AppConfig.getProperty("tdsqs"));
        int sqEnd, sqBegin, sqYear;

        // 根据触发器的触发时间确定当前生成疑点数据的时间
        sqYear = year;
        sqEnd = Integer.parseInt(CommonUtil.getSssqByMonth(Szdm.CZTDSYS.toString(), month));
        if (sqEnd == 1) {
            sqEnd = tdsqs;
            sqYear = year - 1;
        }else{
            sqEnd = sqEnd - 1;
        }

        String sql;
        Query query;
        for (int i = 0; i < sqEnd; i++) {
            sqBegin = i + 1;

            sql = getTdZsYdqcSql(sqYear, sqBegin, sqEnd, Ydtype.HCH.toString());
            query = baseRepository.getEntityManager().createNativeQuery(sql);
            query.executeUpdate();
        }
    }
    private void createFcZsYdqc(int year, int month){
        int fcsqs = new Integer(AppConfig.getProperty("fcsqs"));
        int sqEnd, sqBegin, sqYear;

        // 根据触发器的触发时间确定当前生成疑点数据的时间
        sqYear = year;
        sqEnd = Integer.parseInt(CommonUtil.getSssqByMonth(Szdm.FCS.toString(), month));
        if (sqEnd == 1) {
            sqEnd = fcsqs;
            sqYear = year - 1;
        }else{
            sqEnd = sqEnd - 1;
        }

        String sql;
        Query query;
        for (int i = 0; i < sqEnd; i++) {
            sqBegin = i + 1;

            sql = getFcZsYdqcSql(sqYear, sqBegin, sqEnd, Ydtype.HCH.toString());
            query = baseRepository.getEntityManager().createNativeQuery(sql);
            query.executeUpdate();
        }
    }

    public String getTdZsYdqcSql(int year, int sqBegin, int sqEnd, String ydType){
        int tdsqs = new Integer(AppConfig.getProperty("tdsqs"));
        int sqTotal = tdsqs;
        int sqCount = sqEnd - sqBegin + 1;
        String startRq = String.valueOf(year) + StringUtils.right("0" + String.valueOf((sqBegin - 1) * (12 / sqTotal) + 1), 2);
        String endRq = String.valueOf(year) + StringUtils.right("0" + String.valueOf(sqEnd * (12 / sqTotal)), 2);
        String sssq = String.valueOf((sqBegin - 1) * sqTotal + sqEnd);
        String startNfSq = String.valueOf(year * sqTotal + sqBegin);
        String endNfSq = String.valueOf(year * sqTotal + sqEnd);

        String sql = "";

        sql = "INSERT INTO S_SJ_ZSYDQC_TD (TDZSYD_ID, JBB_ID, GLBM, NSRSBH, YNMJ, YJSE, RKSE, CYJE, CYBL, TDDJ, NSRMC, SGYDM, SSJG, QXDM, SSNF, SSSQ, YDTYPE) " +
                "SELECT SYS_GUID(), t2.JBB_ID, NULL, t2.NSRSBH, t2.YNMJ, t2.YJSE, t1.RKSE, t2.YJSE - t1.RKSE, DECODE(t2.YJSE, 0, 0, (t2.YJSE - t1.RKSE)/t2.YJSE),  " +
                "t2.TDDJ, t2.NSRMC, NULL, t2.SSJG, SUBSTR(t2.SSJG, 2, 6), ':year', ':sssq', ':ydType' " +
                "FROM  " +
                "  (SELECT NSRSBH, " +
                "          ROUND(SUM(SJJE / (ENDNFSQ - STARTNFSQ + 1) * DECODE(SIGN(LEAST(ENDNFSQ, " + endNfSq + ") - GREATEST(STARTNFSQ, " + startNfSq + ")), -1, 0,  LEAST(ENDNFSQ, " + endNfSq + ") - GREATEST(STARTNFSQ, " + startNfSq + ") + 1)), 2) AS RKSE " +
                "   FROM (SELECT t2.NSRSBH, t1.SJJE, t1.RKRQ, t1.SKSSQQ, t1.SKSSQZ, " +
                "            (TO_NUMBER(TO_CHAR(t1.SKSSQZ, 'YYYY')) * :sqTotal + TRUNC((TO_NUMBER(TO_CHAR(t1.SKSSQZ, 'MM')) - 1) / 12 * :sqTotal) + 1) AS ENDNFSQ,  " +
                "            (TO_NUMBER(TO_CHAR(t1.SKSSQQ, 'YYYY')) * :sqTotal + TRUNC((TO_NUMBER(TO_CHAR(t1.SKSSQQ, 'MM')) - 1) / 12 * :sqTotal) + 1) AS STARTNFSQ  " +
                "         FROM ZS_JKS t1, DJ_NSRXX t2 " +
                "         WHERE t1.DJXH=t2.DJXH AND t1.ZSXM_DM IN ('10112') AND t1.SJJE > 0 AND t1.RKRQ IS NOT NULL " +
                "         AND ((TO_CHAR(t1.SKSSQQ, 'YYYYMM') >= ':startRq' AND TO_CHAR(t1.SKSSQZ, 'YYYYMM') <= ':endRq') " +
                "             OR (TO_CHAR(t1.SKSSQQ, 'YYYYMM') >= ':startRq' AND TO_CHAR(t1.SKSSQQ, 'YYYYMM') <= ':endRq') " +
                "             OR (TO_CHAR(t1.SKSSQZ, 'YYYYMM') >= ':startRq' AND TO_CHAR(t1.SKSSQZ, 'YYYYMM') <= ':endRq'))) " +
                "   GROUP BY NSRSBH) t1 " +
                "INNER JOIN  " +
                "  (SELECT MAX(tt1.JBB_ID) AS JBB_ID, tt2.NSRSBH, MAX(tt2.NSRMC) AS NSRMC, MAX(tt1.TDDJ) AS TDDJ, MAX(tt2.ZGKG_DM) AS SSJG,  " +
                "   SUM(tt1.YNMJ) AS YNMJ, SUM(DECODE(TO_CHAR(CSQDSJ, 'YYYY'), :year, DNYNSE, NYNSE)) / :sqTotal * :sqCount AS YJSE " +
                "   FROM SW_DJ_TD tt1 INNER JOIN SW_DJ_JBB tt2 ON tt1.JBB_ID = tt2.JBB_ID  " +
                "   GROUP BY tt2.NSRSBH) t2 " +
                "ON t1.NSRSBH=t2.NSRSBH " +
                "WHERE t1.NSRSBH IN (SELECT NSRSBH FROM SW_DJ_JBB MINUS SELECT DISTINCT NSRSBH FROM S_SJ_ZSYDQC_TD WHERE SSNF = ':year' AND SSSQ = ':sssq')  " +
                "AND (NOT (NVL(t2.YJSE, 0) > 0 AND ABS(NVL((t2.YJSE - t1.RKSE)/t2.YJSE, 0)) < 0.01)) AND (NOT (NVL(t2.YJSE, 0) <= 0 AND NVL(t1.RKSE, 0) <= 0)) ";

        sql = sql.replaceAll(":year", String.valueOf(year));
        sql = sql.replaceAll(":sqBegin", String.valueOf(sqBegin));
        sql = sql.replaceAll(":sqEnd", String.valueOf(sqEnd));
        sql = sql.replaceAll(":ydType", Ydtype.HCH.toString());
        sql = sql.replaceAll(":sqTotal", String.valueOf(sqTotal));
        sql = sql.replaceAll(":sqCount", String.valueOf(sqCount));
        sql = sql.replaceAll(":startRq", startRq);
        sql = sql.replaceAll(":endRq", endRq);
        sql = sql.replaceAll(":endNfSq", endNfSq);
        sql = sql.replaceAll(":startNfSq", startNfSq);
        sql = sql.replaceAll(":sssq", sssq);

        return sql;
    }
    public String getFcZsYdqcSql(int year, int sqBegin, int sqEnd, String ydType){
        int fcsqs = new Integer(AppConfig.getProperty("fcsqs"));
        int sqTotal = fcsqs;
        int sqCount = sqEnd - sqBegin + 1;
        String startRq = String.valueOf(year) + StringUtils.right("0" + String.valueOf((sqBegin - 1) * (12 / sqTotal) + 1), 2);
        String endRq = String.valueOf(year) + StringUtils.right("0" + String.valueOf(sqEnd * (12 / sqTotal)), 2);
        String sssq = String.valueOf((sqBegin - 1) * sqTotal + sqEnd);
        String startNfSq = String.valueOf(year * sqTotal + sqBegin);
        String endNfSq = String.valueOf(year * sqTotal + sqEnd);

        String sql = "";

        sql = "INSERT INTO S_SJ_ZSYDQC_FC (FCZSYD_ID, JBB_ID, GLBM, NSRSBH, YSYZ, YJSE, RKSE, CYJE, CYBL, YSZJ, NSRMC, SGYDM, SSJG, QXDM, SSNF, SSSQ, YDTYPE) " +
                "SELECT SYS_GUID(), t2.JBB_ID, NULL, t2.NSRSBH, t2.YSYZ, t2.YJSE, t1.RKSE, t2.YJSE - NVL(t1.RKSE,0), DECODE(t2.YJSE, 0, 0, (t2.YJSE - NVL(t1.RKSE,0))/t2.YJSE),  " +
                "t2.YSZJ, t2.NSRMC, NULL, t2.SSJG, SUBSTR(t2.SSJG, 2, 6), ':year', ':sssq', ':ydType' " +
                "FROM  " +
                "  (SELECT NSRSBH, " +
                "          ROUND(SUM(SJJE / (ENDNFSQ - STARTNFSQ + 1) * DECODE(SIGN(LEAST(ENDNFSQ, " + endNfSq + ") - GREATEST(STARTNFSQ, " + startNfSq + ")), -1, 0,  LEAST(ENDNFSQ, " + endNfSq + ") - GREATEST(STARTNFSQ, " + startNfSq + ") + 1)), 2) AS RKSE " +
                "   FROM (SELECT t2.NSRSBH, t1.SJJE, t1.RKRQ, t1.SKSSQQ, t1.SKSSQZ, " +
                "            (TO_NUMBER(TO_CHAR(t1.SKSSQZ, 'YYYY')) * :sqTotal + TRUNC((TO_NUMBER(TO_CHAR(t1.SKSSQZ, 'MM')) - 1) / 12 * :sqTotal) + 1) AS ENDNFSQ,  " +
                "            (TO_NUMBER(TO_CHAR(t1.SKSSQQ, 'YYYY')) * :sqTotal + TRUNC((TO_NUMBER(TO_CHAR(t1.SKSSQQ, 'MM')) - 1) / 12 * :sqTotal) + 1) AS STARTNFSQ  " +
                "         FROM ZS_JKS t1, DJ_NSRXX t2 " +
                "         WHERE t1.DJXH=t2.DJXH AND t1.ZSXM_DM IN ('10111') AND t1.SJJE > 0 AND t1.RKRQ IS NOT NULL " +
                "         AND ((TO_CHAR(t1.SKSSQQ, 'YYYYMM') >= ':startRq' AND TO_CHAR(t1.SKSSQZ, 'YYYYMM') <= ':endRq') " +
                "             OR (TO_CHAR(t1.SKSSQQ, 'YYYYMM') >= ':startRq' AND TO_CHAR(t1.SKSSQQ, 'YYYYMM') <= ':endRq') " +
                "             OR (TO_CHAR(t1.SKSSQZ, 'YYYYMM') >= ':startRq' AND TO_CHAR(t1.SKSSQZ, 'YYYYMM') <= ':endRq'))) " +
                "   GROUP BY NSRSBH) t1 " +
                "RIGHT JOIN  " +
                "  (SELECT MAX(tt1.JBB_ID) AS JBB_ID, tt2.NSRSBH, MAX(tt2.NSRMC) AS NSRMC, SUM(tt1.FCYZ_YS) AS YSYZ, MAX(tt2.ZGKG_DM) AS SSJG,  " +
                "   SUM(tt1.YNSE_CZ) AS YSZJ, SUM(NYNSE) / :sqTotal * :sqCount AS YJSE " +
                "   FROM SW_DJ_FC tt1 INNER JOIN SW_DJ_JBB tt2 ON tt1.JBB_ID = tt2.JBB_ID  " +
                "   GROUP BY tt2.NSRSBH) t2 " +
                "ON t1.NSRSBH=t2.NSRSBH " +
                "WHERE t1.NSRSBH IN (SELECT NSRSBH FROM SW_DJ_JBB MINUS SELECT DISTINCT NSRSBH FROM S_SJ_ZSYDQC_TD WHERE SSNF = ':year' AND SSSQ = ':sssq')  " +
                "AND (NOT (NVL(t2.YJSE, 0) > 0 AND ABS(NVL((t2.YJSE - t1.RKSE)/t2.YJSE, 0)) < 0.01)) AND (NOT (NVL(t2.YJSE, 0) <= 0 AND NVL(t1.RKSE, 0) <= 0)) ";

        sql = sql.replaceAll(":year", String.valueOf(year));
        sql = sql.replaceAll(":sqBegin", String.valueOf(sqBegin));
        sql = sql.replaceAll(":sqEnd", String.valueOf(sqEnd));
        sql = sql.replaceAll(":ydType", Ydtype.HCH.toString());
        sql = sql.replaceAll(":sqTotal", String.valueOf(sqTotal));
        sql = sql.replaceAll(":sqCount", String.valueOf(sqCount));
        sql = sql.replaceAll(":startRq", startRq);
        sql = sql.replaceAll(":endRq", endRq);
        sql = sql.replaceAll(":endNfSq", endNfSq);
        sql = sql.replaceAll(":startNfSq", startNfSq);
        sql = sql.replaceAll(":sssq", sssq);

        return sql;
    }
}
