package cn.gtmap.landtax.quartz.quartzImpl;

import cn.gtmap.landtax.model.dictionary.Szdm;
import cn.gtmap.landtax.model.dictionary.Ydtype;
import cn.gtmap.landtax.quartz.TbSbSjQuartz;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.CommonUtil;
import com.gtis.config.AppConfig;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.Query;
import java.util.Calendar;

/**
 * 江苏接口专用定时器
 * Created by Zenglihuan on 20160922
 */
public class TbSbSjQuartz_default implements TbSbSjQuartz {
    protected final Logger logger = Logger.getLogger(getClass());

    @Autowired
    BaseRepository baseRepository;

    /**
     * 更新宗地出租自用状态
     */
    @Transactional(value="oracle_common")
    public void updateZdzt_zycz(){
        logger.info("*******************************更新宗地状态开始");

        logger.info("*******************************更新宗地状态结束");
    }

    public void executeCopyJsData(){
        logger.info("****************executeCopyZgData开始(抽取征管数据到业务库中)********************");
        logger.info("*******************************executeCopyZgData结束");
    }

    @Transactional(value="oracle_common")
    public void execute(){

        logger.info("*******************************未配置生成入库税收定时器");

    }

    private void executeTdZsWfEnd(){
        //土地征收
        Query query;
        String sql = "";

        //一年分几个属期的变量（土地征收按季度征收，一年分4期）
        String sqCount = "4";
        //本期加年份的所属属期分变量表达式（加年份的原因是：防止跨年情况发生）
        //加年份的结束属期
        String zsEndNfsq = "(TO_NUMBER(TO_CHAR(b.TAXTERMEND, 'YYYY')) * :sqCount + TRUNC((TO_NUMBER(TO_CHAR(b.TAXTERMEND, 'MM')) - 1) / 12 * :sqCount) + 1)";
        //加年份的开始属期
        String zsStartNfsq = "(TO_NUMBER(TO_CHAR(b.TAXTERMBEGIN, 'YYYY')) * :sqCount + TRUNC((TO_NUMBER(TO_CHAR(b.TAXTERMBEGIN, 'MM')) - 1) / 12 * :sqCount) + 1)";
        //加年份的结束疑点属期
        String ydEndNfsq = "(a.SSNF * :sqCount + (MOD((TO_NUMBER(a.SSSQ) - 1), 4) + 1))";
        //加年份的开始疑点属期
        String ydStartNfsq = "(a.SSNF * :sqCount + (TRUNC((TO_NUMBER(a.SSSQ) - 1) / 4, 0) + 1))";
        // 本期所属税款的计算表达式
        String bqSkExp = "b.NSE / (:zsEndNfsq - :zsStartNfsq + 1) * DECODE(SIGN(LEAST(:zsEndNfsq, :ydEndNfsq) - GREATEST(:zsStartNfsq, :ydStartNfsq)), -1, 0,  LEAST(:zsEndNfsq, :ydEndNfsq) - GREATEST(:zsStartNfsq, :ydStartNfsq) + 1)";
        // 将变量表达式替换成变量值
        bqSkExp = bqSkExp.replaceAll(":zsEndNfsq", zsEndNfsq);
        bqSkExp = bqSkExp.replaceAll(":zsStartNfsq", zsStartNfsq);
        bqSkExp = bqSkExp.replaceAll(":ydEndNfsq", ydEndNfsq);
        bqSkExp = bqSkExp.replaceAll(":ydStartNfsq", ydStartNfsq);

        /**
         * 结束属期：(MOD((TO_NUMBER(a.SSSQ) - 1), 4) + 1)
         * 开始属期：(TRUNC((TO_NUMBER(a.SSSQ) - 1) / 4, 0) + 1)
         */

        // 更新处理后入库税额(税收所属期包含属期即可)
        sql =   "UPDATE S_SJ_ZSYDQC_TD a " +
                "SET a.END_SBSE=( " +
                "    SELECT NVL(ROUND(SUM(" + bqSkExp + "), 2), 0) " +
                "    FROM LOCAL_SB_RKSS b " +
                "    WHERE " + ydEndNfsq + "<=" + zsEndNfsq + "AND " + ydStartNfsq + ">=" + zsStartNfsq +
                "           AND b.SZDM='13' AND a.GLBM=b.GLBM) " +
                "WHERE a.END_CYBL IS NULL AND EXISTS (SELECT 1 FROM SW_HC_XM_RW_REL c WHERE c.BLZT='1' AND a.RWID=c.RW_ID)";
        sql = sql.replaceAll(":sqCount", sqCount);
        query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.executeUpdate();

        // 更新处理后差异比例
        sql =   "UPDATE S_SJ_ZSYDQC_TD SET END_CYBL= DECODE(NVL(END_YJSE, 0), 0, 0, NVL(END_SBSE, 0) / END_YJSE) " +
                "WHERE END_CYBL IS NULL AND END_SBSE IS NOT NULL";
        query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.executeUpdate();
    }

    private void executeStoreZs(){
        /**
         * 读取征管系统数据，生成“征收入库税收”数据
         * SZDM为"13"是城镇土地使用税
         * T_ZS_JKMX中的JK_XH不是唯一的，缴款序号JK_XH+缴款流水序号明细号JKLSMXH_XH是唯一的
         * 其中ZSXM_DM为'15'时是土地税
         */
        String sql = "";
        sql =   "INSERT INTO LOCAL_SB_RKSS (SB_NUM, GLBM, FSRQ, NSE, SZDM, TAXTERMBEGIN, TAXTERMEND) " +
                "SELECT (JKLSMXH_XH || JK_XH) AS SB_NUM, SWGLM AS GLBM, RK_RQ AS FSRQ, SJ_JE AS NSE, '13' AS SZDM, SFSSQ_QSRQ AS TAXTERMBEGIN, SFSSQ_ZZRQ AS TAXTERMEND " +
                "FROM T_ZS_JKMX t1 " +
                "LEFT JOIN LOCAL_SB_RKSS t2 ON t1.JK_XH=t2.SB_NUM " +
                "WHERE t2.SB_NUM IS NULL AND t1.ZSXM_DM IN ('15') AND t1.SJ_JE > 0 AND t1.RK_RQ IS NOT NULL";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.executeUpdate();
    }

   //******************************************************************************************************************************************************************************************
    /**
     * 5月1日 至 10月31日每晚23点 执行该任务
     * 当前时间月份在 5-9之间生成上半年清册（期间只生成一次，多次执行是判断是否生成），
     * 当前时间月份是10生成下半年清册，
     * 任务：
     * 1，生成申报土地疑点清册
     * 2，生成申报房产疑点清册
     * 3，生成征收土地疑点清册
     * 4，生成征收房产疑点清册
     */

    @Transactional(value="oracle_common")
    public void createYdqc(){
        //*************************************************创建土地征收疑点清册
        logger.info("*******************************未配置生成疑点清册定时器");
    }

    private void createTdZsYdqc(int year, int month){
        int sqEnd, sqBegin, sqYear;

        // 根据触发器的触发时间确定当前生成疑点数据的时间
        sqYear = year;
        sqEnd = Integer.parseInt(CommonUtil.getSssqByMonth(Szdm.CZTDSYS.toString(), month));
        if (sqEnd == 1) {
            sqEnd = 4;
            sqYear = year - 1;
        }else{
            sqEnd = sqEnd - 1;
        }

        String sql;
        Query query;
        for (int i = 0; i < sqEnd; i++) {
            sqBegin = i + 1;

            sql = getTdZsYdqcSql(sqYear, sqBegin, sqEnd, Ydtype.HCH.toString());
            query = baseRepository.getEntityManager().createNativeQuery(sql);
            query.executeUpdate();
        }
    }


    public String getTdZsYdqcSql(int year, int sqBegin, int sqEnd, String ydType){
        int sqTotal = 4;
        int sqCount = sqEnd - sqBegin + 1;
        String startRq = String.valueOf(year) + StringUtils.right("0" + String.valueOf((sqBegin - 1) * (12 / sqTotal) + 1), 2);
        String endRq = String.valueOf(year) + StringUtils.right("0" + String.valueOf(sqEnd * (12 / sqTotal)), 2);
        String sssq = String.valueOf((sqBegin - 1) * sqTotal + sqEnd);
        String startNfSq = String.valueOf(year * sqTotal + sqBegin);
        String endNfSq = String.valueOf(year * sqTotal + sqEnd);

        String sql = "";

        sql = "INSERT INTO S_SJ_ZSYDQC_TD (TDZSYD_ID, JBB_ID, GLBM, YNMJ, YJSE, RKSE, CYJE, CYBL, TDDJ, NSRMC, SGYDM, SSJG, QXDM, SSNF, SSSQ, YDTYPE)" +
                "SELECT SYS_GUID(), t2.JBB_ID, t1.SWGLM, t2.YNMJ, t2.YJSE, t1.RKSE, t2.YJSE - t1.RKSE, DECODE(t2.YJSE, 0, 0, (t2.YJSE - t1.RKSE)/t2.YJSE), " +
                "t2.TDDJ, t2.NSRMC, NULL, t2.SSJG, SUBSTR(t2.SSJG, 2, 6), ':year', ':sssq', ':ydType' " +
                "FROM " +
                "  (SELECT SWGLM, " +
                "          ROUND(SUM(SJ_JE / (ENDNFSQ - STARTNFSQ + 1) * DECODE(SIGN(LEAST(ENDNFSQ, " + endNfSq + ") - GREATEST(STARTNFSQ, " + startNfSq + ")), -1, 0,  LEAST(ENDNFSQ, " + endNfSq + ") - GREATEST(STARTNFSQ, " + startNfSq + ") + 1)), 2) AS RKSE " +
                "   FROM (SELECT SWGLM, SJ_JE, RK_RQ, SFSSQ_QSRQ, SFSSQ_ZZRQ, " +
                "            (TO_NUMBER(TO_CHAR(t.SFSSQ_ZZRQ, 'YYYY')) * :sqTotal + TRUNC((TO_NUMBER(TO_CHAR(t.SFSSQ_ZZRQ, 'MM')) - 1) / 12 * :sqTotal) + 1) AS ENDNFSQ, " +
                "            (TO_NUMBER(TO_CHAR(t.SFSSQ_QSRQ, 'YYYY')) * :sqTotal + TRUNC((TO_NUMBER(TO_CHAR(t.SFSSQ_QSRQ, 'MM')) - 1) / 12 * :sqTotal) + 1) AS STARTNFSQ " +
                "         FROM T_ZS_JKMX t " +
                "         WHERE t.ZSXM_DM IN ('15') AND t.SJ_JE > 0 AND t.RK_RQ IS NOT NULL " +
                "         AND ((TO_CHAR(t.SFSSQ_QSRQ, 'YYYYMM') >= ':startRq' AND TO_CHAR(t.SFSSQ_ZZRQ, 'YYYYMM') <= ':endRq') " +
                "         OR (TO_CHAR(t.SFSSQ_QSRQ, 'YYYYMM') >= ':startRq' AND TO_CHAR(t.SFSSQ_QSRQ, 'YYYYMM') <= ':endRq')" +
                "         OR (TO_CHAR(t.SFSSQ_ZZRQ, 'YYYYMM') >= ':startRq' AND TO_CHAR(t.SFSSQ_ZZRQ, 'YYYYMM') <= ':endRq'))" +
                "         ) " +
                "   GROUP BY SWGLM) t1 " +
                "INNER JOIN " +
                "  (SELECT tt1.JBB_ID, tt2.GLBM, tt2.NSRMC, MAX(tt1.TDDJ) AS TDDJ, MAX(tt2.ZGKG_DM) AS SSJG, SUM(tt1.YNMJ) AS YNMJ, SUM(tt1.NYNSE) / :sqTotal * :sqCount AS YJSE " +
                "   FROM SW_DJ_TD tt1 LEFT JOIN SW_DJ_JBB tt2 ON tt1.JBB_ID = tt2.JBB_ID " +
                "   GROUP BY tt1.JBB_ID, tt2.GLBM, tt2.NSRMC) t2 " +
                "ON t1.SWGLM=t2.GLBM " +
                "WHERE t1.SWGLM IN (SELECT GLBM FROM SW_DJ_JBB MINUS SELECT GLBM FROM S_SJ_ZSYDQC_TD WHERE SSNF = ':year' AND SSSQ = ':sssq') " +
                "AND (NOT (NVL(t2.YJSE, 0) > 0 AND ABS(NVL((t2.YJSE - t1.RKSE)/t2.YJSE, 0)) < 0.01)) AND (NOT (NVL(t2.YJSE, 0) <= 0 AND NVL(t1.RKSE, 0) <= 0)) ";

        sql = sql.replaceAll(":year", String.valueOf(year));
        sql = sql.replaceAll(":sqBegin", String.valueOf(sqBegin));
        sql = sql.replaceAll(":sqEnd", String.valueOf(sqEnd));
        sql = sql.replaceAll(":ydType", Ydtype.HCH.toString());
        sql = sql.replaceAll(":sqTotal", String.valueOf(sqTotal));
        sql = sql.replaceAll(":sqCount", String.valueOf(sqCount));
        sql = sql.replaceAll(":startRq", startRq);
        sql = sql.replaceAll(":endRq", endRq);
        sql = sql.replaceAll(":endNfSq", endNfSq);
        sql = sql.replaceAll(":startNfSq", startNfSq);
        sql = sql.replaceAll(":sssq", sssq);

        return sql;
    }
    public String getFcZsYdqcSql(int year, int sqBegin, int sqEnd, String ydType){
        int fcsqs = new Integer(AppConfig.getProperty("fcsqs"));
        int sqTotal = fcsqs;
        int sqCount = sqEnd - sqBegin + 1;
        String startRq = String.valueOf(year) + StringUtils.right("0" + String.valueOf((sqBegin - 1) * (12 / sqTotal) + 1), 2);
        String endRq = String.valueOf(year) + StringUtils.right("0" + String.valueOf(sqEnd * (12 / sqTotal)), 2);
        String sssq = String.valueOf((sqBegin - 1) * sqTotal + sqEnd);
        String startNfSq = String.valueOf(year * sqTotal + sqBegin);
        String endNfSq = String.valueOf(year * sqTotal + sqEnd);

        String sql = "";

        sql = "INSERT INTO S_SJ_ZSYDQC_FC (FCZSYD_ID, JBB_ID, GLBM, NSRSBH, YSYZ, YJSE, RKSE, CYJE, CYBL, YSZJ, NSRMC, SGYDM, SSJG, QXDM, SSNF, SSSQ, YDTYPE) " +
                "SELECT SYS_GUID(), t2.JBB_ID, NULL, t2.NSRSBH, t2.YSYZ, t2.YJSE, t1.RKSE, t2.YJSE - NVL(t1.RKSE,0), DECODE(t2.YJSE, 0, 0, (t2.YJSE - NVL(t1.RKSE,0))/t2.YJSE),  " +
                "t2.YSZJ, t2.NSRMC, NULL, t2.SSJG, SUBSTR(t2.SSJG, 2, 6), ':year', ':sssq', ':ydType' " +
                "FROM  " +
                "  (SELECT NSRSBH, " +
                "          ROUND(SUM(SJJE / (ENDNFSQ - STARTNFSQ + 1) * DECODE(SIGN(LEAST(ENDNFSQ, " + endNfSq + ") - GREATEST(STARTNFSQ, " + startNfSq + ")), -1, 0,  LEAST(ENDNFSQ, " + endNfSq + ") - GREATEST(STARTNFSQ, " + startNfSq + ") + 1)), 2) AS RKSE " +
                "   FROM (SELECT t2.NSRSBH, t1.SJJE, t1.RKRQ, t1.SKSSQQ, t1.SKSSQZ, " +
                "            (TO_NUMBER(TO_CHAR(t1.SKSSQZ, 'YYYY')) * :sqTotal + TRUNC((TO_NUMBER(TO_CHAR(t1.SKSSQZ, 'MM')) - 1) / 12 * :sqTotal) + 1) AS ENDNFSQ,  " +
                "            (TO_NUMBER(TO_CHAR(t1.SKSSQQ, 'YYYY')) * :sqTotal + TRUNC((TO_NUMBER(TO_CHAR(t1.SKSSQQ, 'MM')) - 1) / 12 * :sqTotal) + 1) AS STARTNFSQ  " +
                "         FROM ZS_JKS t1, DJ_NSRXX t2 " +
                "         WHERE t1.DJXH=t2.DJXH AND t1.ZSXM_DM IN ('10111') AND t1.SJJE > 0 AND t1.RKRQ IS NOT NULL " +
                "         AND ((TO_CHAR(t1.SKSSQQ, 'YYYYMM') >= ':startRq' AND TO_CHAR(t1.SKSSQZ, 'YYYYMM') <= ':endRq') " +
                "             OR (TO_CHAR(t1.SKSSQQ, 'YYYYMM') >= ':startRq' AND TO_CHAR(t1.SKSSQQ, 'YYYYMM') <= ':endRq') " +
                "             OR (TO_CHAR(t1.SKSSQZ, 'YYYYMM') >= ':startRq' AND TO_CHAR(t1.SKSSQZ, 'YYYYMM') <= ':endRq'))) " +
                "   GROUP BY NSRSBH) t1 " +
                "RIGHT JOIN  " +
                "  (SELECT MAX(tt1.JBB_ID) AS JBB_ID, tt2.NSRSBH, MAX(tt2.NSRMC) AS NSRMC, SUM(tt1.FCYZ_YS) AS YSYZ, MAX(tt2.ZGKG_DM) AS SSJG,  " +
                "   SUM(tt1.YNSE_CZ) AS YSZJ, SUM(NYNSE) / :sqTotal * :sqCount AS YJSE " +
                "   FROM SW_DJ_FC tt1 INNER JOIN SW_DJ_JBB tt2 ON tt1.JBB_ID = tt2.JBB_ID  " +
                "   GROUP BY tt2.NSRSBH) t2 " +
                "ON t1.NSRSBH=t2.NSRSBH " +
                "WHERE t1.NSRSBH IN (SELECT NSRSBH FROM SW_DJ_JBB MINUS SELECT DISTINCT NSRSBH FROM S_SJ_ZSYDQC_TD WHERE SSNF = ':year' AND SSSQ = ':sssq')  " +
                "AND (NOT (NVL(t2.YJSE, 0) > 0 AND ABS(NVL((t2.YJSE - t1.RKSE)/t2.YJSE, 0)) < 0.01)) AND (NOT (NVL(t2.YJSE, 0) <= 0 AND NVL(t1.RKSE, 0) <= 0)) ";

        sql = sql.replaceAll(":year", String.valueOf(year));
        sql = sql.replaceAll(":sqBegin", String.valueOf(sqBegin));
        sql = sql.replaceAll(":sqEnd", String.valueOf(sqEnd));
        sql = sql.replaceAll(":ydType", Ydtype.HCH.toString());
        sql = sql.replaceAll(":sqTotal", String.valueOf(sqTotal));
        sql = sql.replaceAll(":sqCount", String.valueOf(sqCount));
        sql = sql.replaceAll(":startRq", startRq);
        sql = sql.replaceAll(":endRq", endRq);
        sql = sql.replaceAll(":endNfSq", endNfSq);
        sql = sql.replaceAll(":startNfSq", startNfSq);
        sql = sql.replaceAll(":sssq", sssq);

        return sql;
    }
}
