package cn.gtmap.landtax.quartz;

import cn.gtmap.landtax.model.query.SyxxtjbQuery;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import com.gtis.config.AppConfig;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.Query;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;


public class SyxxTjbQuartz {
    protected final Logger logger = Logger.getLogger(getClass());

    @Autowired
    BaseRepository baseRepository;

    /**
     *省级监控-首页-税源信息统计表
     *
     * 缓存
     *
     * 定时向SyxxTjb中插入统计信息
     *
     * 解决首页加载慢的问题
     */

    @Transactional
    public void execute() throws Exception{

        logger.info("*******************************开始删除税源信息统计表信息");
        deleteSyxxTjb();
        //首页图
        deleteTbxx();
        logger.info("*******************************完成删除税源信息统计表信息");

        logger.info("*******************************开始更新税源信息统计表信息");
        executeSyxxTjbInsert();
        //首页图
        executeTbxx();
        logger.info("*******************************结束更新税源信息统计表信息");

    }
    //删除表数据
    private void deleteSyxxTjb(){
        Query query;
        String sql =   "delete from syxxtjb";
        query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.executeUpdate();
    }

    private void executeSyxxTjbInsert() {

        List<SyxxtjbQuery> resultList = new ArrayList<SyxxtjbQuery>();

        //获取省级查询结果
        List<SyxxtjbQuery> syxxtjbQueryList = this.syxxTjbJson(null);
        //递归
        resultList = this.recursionToGetSon(syxxtjbQueryList,resultList);


        // 更新处理后入库税额
        Query query;
        String sql = "insert into syxxtjb(dwdm," +
                "                    dwmc," +
                "                    gtzdxx," +
                "                    syzs," +
                "                    kghsys," +
                "                    lzlghsys," +
                "                    kzhsyhsys," +
                "                    jgdwsys," +
                "                    grsys," +
                "                    syhcmj," +
                "                    msmj," +
                "                    ysmj," +
                "                    tdnynse," +
                "                    fcyz," +
                "                    fcyz_ys," +
                "                    fcyz_ms," +
                "                    ynse_zy," +
                "                    ynse_cz," +
                "                    fcnynse," +
                "                    serialnumber) ";
        for (int i = 0;i<resultList.size();i++){
            SyxxtjbQuery syxxtjbQueryTemp = resultList.get(i);
            
            String dwdm= syxxtjbQueryTemp.getDwdm();
            String dwmc= syxxtjbQueryTemp.getDwmc();
            String gtzdxx= syxxtjbQueryTemp.getGtzdxx();
            String syzs= syxxtjbQueryTemp.getSyzs();
            String kghsys= syxxtjbQueryTemp.getKghsys();
            String lzlghsys= syxxtjbQueryTemp.getLzlghsys();
            String kzhsyhsys= syxxtjbQueryTemp.getKzhsyhsys();
            String jgdwsys= syxxtjbQueryTemp.getJgdwsys();
            String grsys= syxxtjbQueryTemp.getGrsys();
            String syhcmj= syxxtjbQueryTemp.getSyhcmj();
            String msmj= syxxtjbQueryTemp.getMsmj();
            String ysmj= syxxtjbQueryTemp.getYsmj();
            String tdnynse= syxxtjbQueryTemp.getTdnynse();
            String fcyz= syxxtjbQueryTemp.getFcyz();
            String fcyz_ys= syxxtjbQueryTemp.getFcyz_ys();
            String fcyz_ms= syxxtjbQueryTemp.getFcyz_ms();
            String ynse_zy= syxxtjbQueryTemp.getYnse_zy();
            String ynse_cz= syxxtjbQueryTemp.getYnse_cz();
            String fcnynse= syxxtjbQueryTemp.getFcnynse();
            String serialnumber = syxxtjbQueryTemp.getSerialnumber();
            if(i==resultList.size()-1){
                sql += "select '"+dwdm+"', '"+dwmc+"','"+gtzdxx+"','"+syzs+"','"+kghsys+"','"+lzlghsys+"','"+kzhsyhsys+"','"+jgdwsys+"','"+grsys+"','"+syhcmj+"','"+msmj+"','"+ysmj+"','"+tdnynse+"','" +
                        ""+fcyz+"','"+fcyz_ys+"','"+fcyz_ms+"','"+ynse_zy+"','"+ynse_cz+"','"+fcnynse+"','"+serialnumber+"' from dual ";
            }else{
                sql += "select '"+dwdm+"', '"+dwmc+"','"+gtzdxx+"','"+syzs+"','"+kghsys+"','"+lzlghsys+"','"+kzhsyhsys+"','"+jgdwsys+"','"+grsys+"','"+syhcmj+"','"+msmj+"','"+ysmj+"','"+tdnynse+"','" +
                        ""+fcyz+"','"+fcyz_ys+"','"+fcyz_ms+"','"+ynse_zy+"','"+ynse_cz+"','"+fcnynse+"','"+serialnumber+"' from dual union ";
            }


        }
        query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.executeUpdate();

    }

    //首页图
    private void deleteTbxx(){
        Query query;
        String sql =   "delete from symap";
        query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.executeUpdate();
    }
    //首页图
    private void executeTbxx() {

        String syjgyhjb = AppConfig.getProperty("syjgyhjb");
        String current_city = AppConfig.getProperty("current_city");
        // 更新处理后入库税额
        Query query;
        int zgkgLen = 0;
        int dwjbLen = 0;

        Number sumTds = 0;
        Number sumFcs = 0;
        List<HashMap<String, Object>> queryList = getSumseByRegionCode(syjgyhjb, current_city);
        for(HashMap tempMap : queryList){
            sumTds = (Number) tempMap.get("SUMTDS");
            sumFcs = (Number) tempMap.get("SUMFCS");
        }

        String orderSql = "";
        String citySql = "";
        if(syjgyhjb.equals("shenji")){
            zgkgLen = 4;
            dwjbLen = 0;
            orderSql = "ORDER BY A.SERIALNUMBER";
            citySql = "t1.REGION_CODE LIKE '61%' ";
        }else if(syjgyhjb.equals("shiji")){
            zgkgLen = 6;
            dwjbLen = 1;
            orderSql = "ORDER BY A.REGION_CODE";
            citySql = "t1.REGION_CODE LIKE '"+current_city+"%' ";
        }
        String sql =
                "       insert into symap" +
                        " SELECT * FROM (SELECT A.REGION_CODE," +
                        "               A.ORGAN_NAME," +
                        "               round(NVL(B.NYNSE/10000, 0), 2) AS TDSNYNSE," +
                        "              round(NVL(C.NYNSE/10000, 0), 2) AS FCSNYNSE," +
                        "             round(NVL(B.NYNSE, 0)*100 /"+sumTds +", 3) AS TDSNYNSEZB," +
                        "             round(NVL(C.NYNSE, 0)*100/"+sumFcs +",3) AS FCSNYNSEZB" +
                        "          FROM " +
                        "                 (SELECT t1.REGION_CODE, t1.ORGAN_NAME,t1.SERIALNUMBER" +
                        "                  FROM (" +
                        "                     SELECT DWDM AS REGION_CODE, DWMC AS ORGAN_NAME,SERIALNUMBER" +
                        "                     FROM SW_JS_ZGH" +
                        "                       ) t1" +
                        "                   WHERE " + citySql +
                        "                   AND LENGTH(t1.REGION_CODE) = "+zgkgLen+")" +
                        "            A" +
                        "            LEFT JOIN " +
                        "                  (SELECT SUBSTR(t3.ZGKG_DM, 2, "+zgkgLen+") AS DM,  SUM(NVL(t1.NYNSE, 0)) AS NYNSE" +
                        "                    FROM SW_DJ_TD t1" +
                        "                      LEFT JOIN SW_DJ_SY t2 ON t1.SY_ID = t2.SY_ID" +
                        "                      LEFT JOIN SW_DJ_JBB t3 ON t1.JBB_ID = t3.JBB_ID" +
                        "                    WHERE t2.SYZT IS NULL" +
                        "                      OR t2.SYZT = '1'" +
                        "                    GROUP BY SUBSTR(t3.ZGKG_DM, 2, "+zgkgLen+"))" +
                        "            B" +
                        "                    ON A.REGION_CODE = B.DM" +
                        "             LEFT JOIN " +
                        "                  (SELECT SUBSTR(t3.ZGKG_DM, 2, "+zgkgLen+") AS XZDM,  SUM(NVL(t1.NYNSE, 0)) AS NYNSE" +
                        "                    FROM SW_DJ_FC t1" +
                        "                      LEFT JOIN SW_DJ_SY t2 ON t1.SY_ID = t2.SY_ID" +
                        "                      LEFT JOIN SW_DJ_JBB t3 ON t1.JBB_ID = t3.JBB_ID" +
                        "                    WHERE t2.SYZT IS NULL" +
                        "                      OR t2.SYZT = '1'" +
                        "                    GROUP BY SUBSTR(t3.ZGKG_DM, 2, "+zgkgLen+"))" +
                        "             C" +
                        "                    ON A.REGION_CODE = C.XZDM" +
                        "             WHERE  B.DM IS NOT NULL " + orderSql+" )";

        query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.executeUpdate();

    }

    private List getSumseByRegionCode(String syjgyhjb, String current_city){
        int zgkgLen = 0;
        Number sumTds = 0;
        Number sumFcs = 0;
        String citySql = "";
        if(syjgyhjb.equals("shenji")){
            zgkgLen = 2;
        }else if(syjgyhjb.equals("shiji")){
            zgkgLen = 4;
            citySql = "AND B.DM = '"+current_city+"' ";
        }
        String sql =
                "SELECT" +
                        "               B.DM," +
                        "               round(NVL(B.NYNSE, 0), 2) AS SUMTDS," +
                        "               round(NVL(C.NYNSE, 0),2) AS SUMFCS" +
                        "          FROM" +
                        "                  (SELECT SUBSTR(t3.ZGKG_DM, 2, "+zgkgLen+") AS DM,  SUM(NVL(t1.NYNSE, 0)) AS NYNSE" +
                        "                    FROM SW_DJ_TD t1" +
                        "                      LEFT JOIN SW_DJ_SY t2 ON t1.SY_ID = t2.SY_ID" +
                        "                      LEFT JOIN SW_DJ_JBB t3 ON t1.JBB_ID = t3.JBB_ID" +
                        "                    WHERE t2.SYZT IS NULL" +
                        "                      OR t2.SYZT = '1'" +
                        "                    GROUP BY SUBSTR(t3.ZGKG_DM, 2, "+zgkgLen+"))" +
                        "            B" +
                        "             LEFT JOIN" +
                        "                  (SELECT SUBSTR(t3.ZGKG_DM, 2, "+zgkgLen+") AS DM,  SUM(NVL(t1.NYNSE, 0)) AS NYNSE" +
                        "                    FROM SW_DJ_FC t1" +
                        "                      LEFT JOIN SW_DJ_SY t2 ON t1.SY_ID = t2.SY_ID" +
                        "                      LEFT JOIN SW_DJ_JBB t3 ON t1.JBB_ID = t3.JBB_ID" +
                        "                    WHERE t2.SYZT IS NULL" +
                        "                      OR t2.SYZT = '1'" +
                        "                    GROUP BY SUBSTR(t3.ZGKG_DM, 2, "+zgkgLen+"))" +
                        "             C" +
                        "                    ON B.DM = C.DM" +
                        "             WHERE  B.DM IS NOT NULL " + citySql;
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        return list;
    }

    private  List<SyxxtjbQuery> recursionToGetSon(List<SyxxtjbQuery> syxxtjbQueryList,List<SyxxtjbQuery> resultList){

        for(int i=0;i<syxxtjbQueryList.size();i++){
            SyxxtjbQuery syxxtjbQuery = syxxtjbQueryList.get(i);
            resultList.add(syxxtjbQuery);//查询结果插入返回值中
            if(syxxtjbQuery.getState().equals("closed")){//如果列的状态为“closed”，有子节点，再次查询
                List<SyxxtjbQuery> sonOfSyxxtjbQueryList = this.syxxTjbJson(syxxtjbQuery.getDwdm());
                recursionToGetSon(sonOfSyxxtjbQueryList,resultList);//对子节点递归
            }
        }
        return resultList;
    }



    public List<SyxxtjbQuery> syxxTjbJson(String id){
        String regionCode = "";
        if(AppConfig.getProperty("current_city")!=null){
            regionCode = AppConfig.getProperty("current_city");
        }else{
            regionCode = "61";  //若没配置current_city，用61省级
        }

        int length = 0;//sql中substr  zgkg_dm 截取的长度

        String openTree;//用于返回结果中判断是否展开
        if(id ==null){//第一次展示树
            openTree = "closed";
            length = regionCode.length();

        }else{//展开树

            //id长度小于等于2时为省级单位，有孙子节点
            if(id.length()<=2){
                openTree = "closed";
            }else{//id长度大于4时树没有子节点
                openTree = "open";
            }

            //由传入id查找其子节点信息
            regionCode = id+"__";//sql中 where条件  查询dwdm子节点
            length = id.length()+2;
        }

        List<SyxxtjbQuery> result = syxxtjbQueryResult(regionCode, openTree, length);
        return  result;
    }

    public List<SyxxtjbQuery> syxxtjbQueryResult(String regionCode, String openTree, int length){
        List<SyxxtjbQuery> result = new ArrayList<SyxxtjbQuery>();
        //单位代码，单位名称
        String sql  ="select * from ("; //外包一层用于order by 不然排序会出错
        sql += "select " +
                "dwxx.dwdm,dwxx.dwmc, zgh.serialnumber," +
                "nvl(gtzdxx.gtzdxx,0)as gtzdxx,nvl(syzs.syzs,0) as syzs,nvl(kghsys.kghsys,0)as kghsys,nvl(lzlghsys.lzlghsys,0)as lzlghsys,nvl(kzhsyhsys.kzhsyhsys,0)as kzhsyhsys,nvl(jgdwsys,0)as jgdwsys,nvl(grsys,0)as grsys," +
                "TO_CHAR(nvl(td.syhcmj,0), 'FM999,999,999,999,999,999,999,990.00')as syhcmj,TO_CHAR(nvl(td.msmj,0), 'FM999,999,999,999,999,999,999,990.00')as msmj,TO_CHAR(nvl(td.ysmj,0), 'FM999,999,999,999,999,999,999,990.00')as ysmj,TO_CHAR(nvl(td.tdnynse,0), 'FM999,999,999,999,999,999,999,990.00')as tdnynse," +
                "TO_CHAR(nvl(fc.fcyz,0), 'FM999,999,999,999,999,999,999,990.00')as fcyz,TO_CHAR(nvl(fc.fcyz_ys,0), 'FM999,999,999,999,999,999,999,990.00')as fcyz_ys,TO_CHAR(nvl(fc.fcyz_ms,0), 'FM999,999,999,999,999,999,999,990.00')as fcyz_ms,TO_CHAR(nvl(fc.ynse_zy,0), 'FM999,999,999,999,999,999,999,990.00')as ynse_zy,TO_CHAR(nvl(fc.ynse_cz,0), 'FM999,999,999,999,999,999,999,990.00')as ynse_cz,TO_CHAR(nvl(fc.fcnynse,0), 'FM999,999,999,999,999,999,999,990.00')as fcnynse " +
                " from " +
                " S_DM_DWXX_CZ dwxx ";
        sql +=  " left join SW_JS_ZGH zgh " +
                " on dwxx.dwdm = zgh.dwdm ";
        //国土宗地信息
        sql += " left join (select dwdm, " +
                "        count(*) as gtzdxx" +
                "    from" +
                "        (select" +
                "            count(*),substr( t4.zgkg_dm,2,"+length+") dwdm " +
                "        from" +
                "            sw_dj_td t1 " +
                "        left join" +
                "            sw_dj_sy t2 " +
                "                on t1.sy_id=t2.sy_id " +
                "        left join" +
                "            zd t3 " +
                "                on t3.djh=t2.djh " +
                "        left join" +
                "            sw_dj_xmxx t7 " +
                "                on t7.xm_id=t2.gd_id  " +
                "                and t3.djh is not null " +
                "                and t3.djh not like '%999999%'　left " +
                "        join" +
                "            sw_dj_jbb t4 " +
                "                on t4.jbb_id=t1.jbb_id " +
                "        where" +
                "            (" +
                "                t2.syzt='1' " +
                "                or t2.syzt is null" +
                "            )  " +
                "            and (" +
                "                t4.zgkg_dm like '2"+regionCode+"%' " +
                "            )  " +
                "        group by" +
                "            t3.djh,substr( t4.zgkg_dm,2,"+length+"))" +
                "        group by dwdm " +
                "            ) gtzdxx    " +
                "on gtzdxx.dwdm =  dwxx.Dwdm";

        //税源总数
        sql += " left join (select  substr(t4.zgkg_dm,2,"+length+") dwdm," +
                "        count(*) as syzs " +
                "    from" +
                "        sw_dj_td t1 " +
                "    left join" +
                "        sw_dj_sy t2 " +
                "            on t1.sy_id=t2.sy_id " +
                "    left join" +
                "        zd t3 " +
                "            on t3.djh=t2.djh " +
                "    left join" +
                "        sw_dj_xmxx t7 " +
                "            on t7.xm_id=t2.gd_id  " +
                "            and t3.djh is not null " +
                "            and t3.djh not like '%999999%'　left " +
                "    join" +
                "        sw_dj_jbb t4 " +
                "            on t4.jbb_id=t1.jbb_id " +
                "    where" +
                "        (" +
                "            t2.syzt='1' " +
                "            or t2.syzt is null" +
                "        )  " +
                "        and (" +
                "            t4.zgkg_dm like '2"+regionCode+"%' " +
                "        ) group by substr(t4.zgkg_dm,2,"+length+") " +
                " )syzs " +
                "on syzs.dwdm =  dwxx.Dwdm";
        //控管户税源数
        sql+=" left join (" +
                "  select substr(t4.zgkg_dm,2,"+length+") as dwdm, " +
                "  count(*) kghsys" +
                "  from" +
                "  sw_dj_td t1 " +
                "  left join" +
                "  sw_dj_sy t2 " +
                "  on t1.sy_id=t2.sy_id " +
                "  left join" +
                "  zd t3 " +
                "  on t3.djh=t2.djh " +
                "  left join" +
                "  sw_dj_xmxx t7 " +
                "  on t7.xm_id=t2.gd_id  " +
                "  and t3.djh is not null " +
                "  and t3.djh not like '%999999%'　" +
                "  left  join" +
                "  sw_dj_jbb t4 " +
                "  on t4.jbb_id=t1.jbb_id " +
                "    where" +
                "        (" +
                "            t2.syzt='1' " +
                "            or t2.syzt is null" +
                "        )  " +
                "        and (" +
                "            t4.zgkg_dm like '2"+regionCode+"%' " +
                "        )  " +
                "        and t1.sgzt_dm='01'  group by substr(t4.zgkg_dm,2,"+length+") )kghsys " +
                " on kghsys.dwdm =  dwxx.Dwdm ";

        //漏征漏管户税源数
        sql+=" left join (" +
                "  select substr(t4.zgkg_dm,2,"+length+") as dwdm," +
                "  count(*) lzlghsys" +
                "  from" +
                "  sw_dj_td t1 " +
                "  left join" +
                "  sw_dj_sy t2 " +
                "  on t1.sy_id=t2.sy_id " +
                "  left join" +
                "  zd t3 " +
                "  on t3.djh=t2.djh " +
                "  left join" +
                "  sw_dj_xmxx t7 " +
                "  on t7.xm_id=t2.gd_id  " +
                "  and t3.djh is not null " +
                "  and t3.djh not like '%999999%'　" +
                "  left  join" +
                "  sw_dj_jbb t4 " +
                "  on t4.jbb_id=t1.jbb_id " +
                "    where" +
                "        (" +
                "            t2.syzt='1' " +
                "            or t2.syzt is null" +
                "        )  " +
                "        and (" +
                "            t4.zgkg_dm like '2"+regionCode+"%' " +
                "        )  " +
                "        and t1.sgzt_dm='02' group by substr(t4.zgkg_dm,2,"+length+") )lzlghsys " +
                " on lzlghsys.dwdm =  dwxx.Dwdm ";
        //可转化税源户税源数
        sql+=" left join (" +
                "  select substr(t4.zgkg_dm,2,"+length+") as dwdm," +
                "  count(*) kzhsyhsys" +
                "  from" +
                "  sw_dj_td t1 " +
                "  left join" +
                "  sw_dj_sy t2 " +
                "  on t1.sy_id=t2.sy_id " +
                "  left join" +
                "  zd t3 " +
                "  on t3.djh=t2.djh " +
                "  left join" +
                "  sw_dj_xmxx t7 " +
                "  on t7.xm_id=t2.gd_id  " +
                "  and t3.djh is not null " +
                "  and t3.djh not like '%999999%'　" +
                "  left  join" +
                "  sw_dj_jbb t4 " +
                "  on t4.jbb_id=t1.jbb_id " +
                "    where" +
                "        (" +
                "            t2.syzt='1' " +
                "            or t2.syzt is null" +
                "        )  " +
                "        and (" +
                "            t4.zgkg_dm like '2"+regionCode+"%' " +
                "        )  " +
                "        and t1.sgzt_dm='03' group by substr(t4.zgkg_dm,2,"+length+"))kzhsyhsys " +
                " on kzhsyhsys.dwdm =  dwxx.Dwdm ";
        //机关单位税源数
        sql+=" left join (" +
                "  select substr(t4.zgkg_dm,2,"+length+") as dwdm," +
                "  count(*) jgdwsys" +
                "  from" +
                "  sw_dj_td t1 " +
                "  left join" +
                "  sw_dj_sy t2 " +
                "  on t1.sy_id=t2.sy_id " +
                "  left join" +
                "  zd t3 " +
                "  on t3.djh=t2.djh " +
                "  left join" +
                "  sw_dj_xmxx t7 " +
                "  on t7.xm_id=t2.gd_id  " +
                "  and t3.djh is not null " +
                "  and t3.djh not like '%999999%'　" +
                "  left  join" +
                "  sw_dj_jbb t4 " +
                "  on t4.jbb_id=t1.jbb_id " +
                "    where" +
                "        (" +
                "            t2.syzt='1' " +
                "            or t2.syzt is null" +
                "        )  " +
                "        and (" +
                "            t4.zgkg_dm like '2"+regionCode+"%' " +
                "        )  " +
                "        and t1.sgzt_dm='05' group by substr(t4.zgkg_dm,2,"+length+") )jgdwsys " +
                " on jgdwsys.dwdm =  dwxx.Dwdm ";

        //个人税源数
        sql+=" left join (" +
                "  select substr(t4.zgkg_dm,2,"+length+") as dwdm," +
                "  count(*) grsys" +
                "  from" +
                "  sw_dj_td t1 " +
                "  left join" +
                "  sw_dj_sy t2 " +
                "  on t1.sy_id=t2.sy_id " +
                "  left join" +
                "  zd t3 " +
                "  on t3.djh=t2.djh " +
                "  left join" +
                "  sw_dj_xmxx t7 " +
                "  on t7.xm_id=t2.gd_id  " +
                "  and t3.djh is not null " +
                "  and t3.djh not like '%999999%'　" +
                "  left  join" +
                "  sw_dj_jbb t4 " +
                "  on t4.jbb_id=t1.jbb_id " +
                "    where" +
                "        (" +
                "            t2.syzt='1' " +
                "            or t2.syzt is null" +
                "        )  " +
                "        and (" +
                "            t4.zgkg_dm like '2"+regionCode+"%' " +
                "        )  " +
                "        and t1.sgzt_dm='04' group by substr(t4.zgkg_dm,2,"+length+"))grsys " +
                " on grsys.dwdm =  dwxx.Dwdm ";
        //城镇土地使用税信息
        sql+="        left join (select substr(t4.zgkg_dm,2,"+length+")as dwdm," +
                "        sum(nvl(t1.scmj," +
                "        0))syhcmj," +
                "        sum(nvl(t1.msmj," +
                "        0))msmj," +
                "        sum(nvl(t1.ynmj," +
                "        0))ysmj," +
                "        sum(nvl(t1.nynse," +
                "        0))tdnynse " +
                "    from" +
                "        sw_dj_td t1  " +
                "    left join" +
                "        sw_dj_sy t2 " +
                "            on t1.sy_id=t2.sy_id " +
                "    left join" +
                "        zd t3 " +
                "            on t3.djh=t2.djh " +
                "    left join" +
                "        sw_dj_jbb t4 " +
                "            on t4.jbb_id=t1.jbb_id " +
                "    left join" +
                "        sw_dj_xmxx t7 " +
                "            on t7.xm_id=t2.gd_id " +
                "    where" +
                "        (" +
                "            t2.syzt='1' " +
                "            or t2.syzt is null" +
                "        )  " +
                "        and t4.zgkg_dm like '2"+regionCode+"%' group by substr(t4.zgkg_dm,2,"+length+")) td " +
                "        on td.dwdm = dwxx.dwdm ";
        //房产税
        sql+="left join (select" +
                "         substr(t4.zgkg_dm,2,"+length+") as dwdm," +
                "        sum(nvl(t1.fcyz," +
                "        0))fcyz," +
                "        sum(nvl(t1.fcyz_ys," +
                "        0))fcyz_ys," +
                "        sum(nvl(t1.fcyz_ms," +
                "        0))fcyz_ms," +
                "        sum(nvl(t1.ynse_zy," +
                "        0))ynse_zy," +
                "        sum(nvl(t1.ynse_cz," +
                "        0))ynse_cz," +
                "        sum(nvl(t1.nynse," +
                "        0))fcnynse " +
                "    from" +
                "        sw_dj_fc t1  " +
                "    left join" +
                "        sw_dj_sy t2 " +
                "            on t1.sy_id=t2.sy_id " +
                "    left join" +
                "        zd t3 " +
                "            on t3.djh=t2.djh " +
                "    left join" +
                "        sw_dj_td t5 " +
                "            on t5.sy_id=t2.sy_id " +
                "    left join" +
                "        sw_dj_jbb t4 " +
                "            on t4.jbb_id=t5.jbb_id " +
                "    left join" +
                "        sw_dj_xmxx t7 " +
                "            on t7.xm_id=t2.gd_id " +
                "    where" +
                "        (" +
                "            t2.syzt='1' " +
                "            or t2.syzt is null" +
                "        )  " +
                "        and t4.zgkg_dm like '2"+regionCode+"%' group by substr(t4.zgkg_dm,2,"+length+") )fc" +
                "        on fc.dwdm = dwxx.dwdm";

        //where条件
        sql += " where dwxx.dwdm like '"+regionCode+"' ）t order by serialnumber,dwdm";

        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();

        if(CollectionUtils.isNotEmpty(list)) {
            for (HashMap tempMap : list) {
                SyxxtjbQuery syxxtjbQuery = new SyxxtjbQuery();
                syxxtjbQuery.setDwdm(String.valueOf(tempMap.get("DWDM")));
                syxxtjbQuery.setDwmc(String.valueOf(tempMap.get("DWMC")));
                syxxtjbQuery.setSerialnumber(String.valueOf(tempMap.get("SERIALNUMBER")));
                syxxtjbQuery.setGtzdxx(String.valueOf(tempMap.get("GTZDXX")));
                syxxtjbQuery.setSyzs(String.valueOf(tempMap.get("SYZS")));
                syxxtjbQuery.setKghsys(String.valueOf(tempMap.get("KGHSYS")));
                syxxtjbQuery.setLzlghsys(String.valueOf(tempMap.get("LZLGHSYS")));
                syxxtjbQuery.setKzhsyhsys(String.valueOf(tempMap.get("KZHSYHSYS")));
                syxxtjbQuery.setJgdwsys(String.valueOf(tempMap.get("JGDWSYS")));
                syxxtjbQuery.setGrsys(String.valueOf(tempMap.get("GRSYS")));
                syxxtjbQuery.setSyhcmj(String.valueOf(tempMap.get("SYHCMJ")));
                syxxtjbQuery.setMsmj(String.valueOf(tempMap.get("MSMJ")));
                syxxtjbQuery.setYsmj(String.valueOf(tempMap.get("YSMJ")));
                syxxtjbQuery.setTdnynse(String.valueOf(tempMap.get("TDNYNSE")));
                syxxtjbQuery.setFcyz(String.valueOf(tempMap.get("FCYZ")));
                syxxtjbQuery.setFcyz_ys(String.valueOf(tempMap.get("FCYZ_YS")));
                syxxtjbQuery.setFcyz_ms(String.valueOf(tempMap.get("FCYZ_MS")));
                syxxtjbQuery.setYnse_zy(String.valueOf(tempMap.get("YNSE_ZY")));
                syxxtjbQuery.setYnse_cz(String.valueOf(tempMap.get("YNSE_CZ")));
                syxxtjbQuery.setFcnynse(String.valueOf(tempMap.get("FCNYNSE")));
                syxxtjbQuery.setState(openTree);
                
                result.add(syxxtjbQuery);
            }
        }
        return result;
    }

}
