package cn.gtmap.landtax.quartz;

import cn.gtmap.landtax.entity.*;
import cn.gtmap.landtax.model.dictionary.Hcxmlx;
import cn.gtmap.landtax.service.HcxmService;
import cn.gtmap.landtax.service.ZdService;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.*;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.service.WorkFlowCoreService;
import com.gtis.plat.vo.PfOrganVo;
import com.gtis.plat.vo.PfRoleVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.plat.wf.WorkFlowTransInfo;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.plat.wf.model.PerformerModel;
import com.gtis.plat.wf.model.PerformerTaskModel;
import com.gtis.plat.wf.model.TransitionModel;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

/**
 * Created by Administrator on 14-12-5.
 */

public class CreateWorkflowQuartz {
    protected final Logger logger = Logger.getLogger(getClass());

    @Autowired
    BaseRepository baseRepository;
    @Autowired
    HcxmService hcxmService;
    @Autowired
    ZdService zdService;
    @Autowired
    SysUserService sysUserService;
    @Autowired
    WorkFlowCoreService workFlowService;
    @Autowired
    IPlatUtil platUtil;

    private static final String CREATE_USER_NAME="create_user_name";
    private static final String WGLZDHC_DJH_INCLUDE="wglzdhc_djh_include";
    private static final String WGLZDHC_DJH_EXCLUDE="wglzdhc_djh_exclude";
    /**
     *
     * 每天晚上23：:5分执行
     * 1，市局定时创建 未关联应税国土宗地信息核查、未关联税务登记信息核查、国土宗地核查疑点
     * 2，市局自动转发到区县 未关联应税国土宗地信息核查、未关联税务登记信息核查、国土宗地核查疑点、城镇土地使用税申报入库疑点、房产税申报入库疑点
     */
    @Transactional(value="oracle_common")
    public void execute() throws  Exception{
        //创建未关联应税国土宗地信息核查
        createWglgtzd();
    }

    //建未关联应税国土宗地信息核查
    public void createWglgtzd() throws Exception{
        //获取自动下发djh
        String includeDjh = AppConfig.getProperty(WGLZDHC_DJH_INCLUDE).trim();
        String excludeDjh = AppConfig.getProperty(WGLZDHC_DJH_EXCLUDE).trim();

        //查出待下发的未关联国土宗地 条件：s_sj_gtbd blzt is null and ppzt is null
        String jpql = "from SSjGtbd t where t.ppzt is null and t.blzt is null";
        StringBuffer where = new StringBuffer("");
        if(StringUtils.isNotBlank(includeDjh)){
            where.append(" and(");
            String[] includeDjhArr = includeDjh.split(",");
            includeDjhArr = CommonUtil.filterNullString(includeDjhArr);
            for(int i=0;i<includeDjhArr.length;i++){
                if(i==0){
                    where.append(" t.djh like '").append(includeDjhArr[i]).append("%' ");
                }else{
                    where.append(" or t.djh like '").append(includeDjhArr[i]).append("%' ");
                }
            }
            where.append(")");
        }else if(StringUtils.isNotBlank(excludeDjh)){
            where.append(" and(");
            String[] excludeDjhArr = excludeDjh.split(",");
            excludeDjhArr = CommonUtil.filterNullString(excludeDjhArr);
            for(int i=0;i<excludeDjhArr.length;i++){
                if(i==0){
                    where.append(" t.djh not like '").append(excludeDjhArr[i]).append("%' ");
                }else{
                    where.append(" and t.djh not like '").append(excludeDjhArr[i]).append("%' ");
                }
            }
            where.append(")");
        }
        jpql = jpql+where.toString();
        List<SSjGtbd> list =  baseRepository.getByJpql(jpql);
        //创建任务
        if(CollectionUtils.isNotEmpty(list)){
            //获取市局用户id
            String loginName = AppConfig.getProperty(CREATE_USER_NAME);
            if(StringUtils.isBlank(loginName)){
                //默认自动创建的用户名是市局
                loginName = "070037";
            }
            //根据用户名获取用户
            PfUserVo userVo = sysUserService.getUserByloginName(loginName);

            if(userVo!=null){
                /**
                 *自动创建工作流
                */
                String userId = userVo.getUserId();
                SwHcXm swHcXm = new SwHcXm();
                swHcXm.setMc("国土宗地核查项目"+new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
                swHcXm.setXmId(UUIDGenerator.generate());
                swHcXm.setCjrq(Calendar.getInstance().getTime());
                swHcXm.setCjrId(userId);
                swHcXm.setXmlx(Hcxmlx.ZDHC.toString());
                swHcXm.setXmybj("0");
                baseRepository.save(swHcXm);
                for(SSjGtbd sSjGtbd:list){
                    Project project = new Project();
                    String wiid = UUIDGenerator.generate();
                    project.setProjectId(wiid);
                    String wwid = AppConfig.getProperty("sszd");
                    project.setWdid(wwid);
                    platUtil.createWorkFlowInstance(project, userId,sSjGtbd.getQlrmc());
                    SwHcXmRwRel swHcXmRwRel = new SwHcXmRwRel();
                    swHcXmRwRel.setShxrId(UUIDGenerator.generate());
                    swHcXmRwRel.setRwId(wiid);
                    swHcXmRwRel.setSwHcXm(swHcXm);
                    swHcXmRwRel.setBdId(sSjGtbd.getGtbdId());
                    swHcXmRwRel.setBlzt("0");
                    baseRepository.save(swHcXmRwRel);
                    sSjGtbd.setBlzt("0");
                    baseRepository.update(sSjGtbd);

                    //自动转发到区县
                    PerformerTaskModel result=getTurnUserList(userId,wiid);
                    List<PfUserVo> toUserList = result.getUserList();
                    String djh = sSjGtbd.getDjh();
                    String toUserId = "";

                    //根据djh过滤区县转发人
                    if(CollectionUtils.isNotEmpty(toUserList)){
                        for(PfUserVo pfUserVo : toUserList){
                            String regionCode = sysUserService.getRegionCodeByUserId(pfUserVo.getUserId());
                            if(djh.startsWith(regionCode)){
                                toUserId = pfUserVo.getUserId();
                                break;
                            }
                        }
                    }
                    //实现工作流转发
                    if(StringUtils.isNotBlank(toUserId)){
                        //任务自动转发
                        String taskid = PlatUtil.getTaskIdByProid(wiid);
                        String turnXml = initTurnTaskXml(wiid,toUserId,taskid);
                        //System.out.println(turnXml);
                        Document doc = DocumentHelper.parseText(turnXml);
                        workFlowService.turnTask(doc,taskid);

                        //转发给组长
                        PerformerTaskModel resultZz=getTurnUserList(toUserId,wiid);
                        List<PfUserVo> toUserListZz = resultZz.getUserList();

                        String toUserIdZz = "";

                        //根据sgqdm过滤区县转发人
                        if(CollectionUtils.isNotEmpty(toUserListZz)){
                            for(PfUserVo pfUserVo : toUserListZz){
                                String regionCode = sysUserService.getRegionCodeByUserId(pfUserVo.getUserId());
                                Zd zd = zdService.findZdByDjh(djh);
                                String sgqdm = zd.getSgqdm();
                                if(sgqdm.equals(regionCode)){
                                    toUserIdZz = pfUserVo.getUserId();
                                    break;
                                }
                            }
                        }
                        //实现工作流转发
                        if(StringUtils.isNotBlank(toUserIdZz)){
                            //任务自动转发
                            String taskidZz = PlatUtil.getTaskIdByProid(wiid);
                            String turnXmlZz = initTurnTaskXml(wiid,toUserIdZz,taskidZz);
                            //System.out.println(turnXml);
                            Document docZz = DocumentHelper.parseText(turnXmlZz);
                            workFlowService.turnTask(docZz,taskidZz);
                        }
                    }


                }


            }else{
                throw new RuntimeException("没有根据用户名"+loginName+"查出对应用户");
            }

        }
    }

    private PerformerTaskModel getTurnUserList(String userId,String proid) throws  Exception{
        PerformerTaskModel result=new PerformerTaskModel();
        try {
            //获取工作流转发信息
            String taskid = PlatUtil.getTaskIdByProid(proid);
            if (StringUtils.isNotBlank(taskid)){
                WorkFlowInfo info = workFlowService.getWorkFlowTurnInfo(userId, taskid);
                // 活动模型
                WorkFlowXml workXml = WorkFlowXmlUtil.getInstanceModel(info.getWorkFlowIntanceVo());
                String activityDefinitionId = info.getSourceActivity().getActivityDefinitionId();
                ActivityModel activityModel = workXml.getActivity(activityDefinitionId);
                // 定义转发列表
                List<TransitionModel> lstTrans = activityModel.getTransitionsList();
                List<ActivityModel> tranActivitys = new ArrayList<ActivityModel>();
                for (TransitionModel transModel : lstTrans) {
                    String nextActivityDefineId = transModel.getToId();
                    ActivityModel nextModel = workXml.getActivity(nextActivityDefineId);
                    List<PerformerModel> performerList = nextModel.getPerformerList();
                    for (PerformerModel performerModel : performerList) {
                        if (!performerModel.getUserId().equals("")) {// 参与者是人
                            String userid = performerModel.getUserId();
                            PfUserVo userVo = sysUserService.getUserVo(userid);
                            List<PfOrganVo> organs=sysUserService.getOrganListByUser(userVo.getUserId());
                            result.setName(organs.get(0).getOrganName());
                            result.setId("0");
                            result.getUserList().add(userVo);
                            result.setType("User");
                        } else if (!performerModel.getOrganId().equals("")) {// 参与者是部门
                            List<PfUserVo> users = sysUserService.getUserListByOragn(performerModel.getOrganId());
                            PfOrganVo organVo=sysUserService.getOrganVo(performerModel.getOrganId());
                            if (organVo!=null){
                                result.setName(organVo.getOrganName());
                                result.setId(organVo.getOrganId());
                                for(PfUserVo vo:users){
                                    result.getUserList().add(vo);
                                }
                            }
                            result.setType("Organ");
                        } else if (!performerModel.getRoleId().equals("")) {// 参与者是角色
                            List<PfUserVo> users = sysUserService.getUserListByRole(performerModel
                                    .getRoleId());
                            PfRoleVo roleVo = sysUserService.getRoleVo(performerModel
                                    .getRoleId());
                            result.setName(roleVo.getRoleName());
                            result.setId(roleVo.getRoleId());
                            for(PfUserVo vo:users){
                                result.getUserList().add(vo);
                            }
                            result.setType("Role");
                        }
                    }
                }
            }
        }catch (Exception e){
            e.printStackTrace();
        }
        return result;
    }

    private String initTurnTaskXml(String proid,String userId,String taskid)throws Exception{
        WorkFlowInfo info = workFlowService.getWorkFlowTurnInfo(userId, taskid);
        WorkFlowTransInfo transInfo=info.getTransInfo();
        List<ActivityModel> lstTrans = transInfo.getTranActivitys();
        if (lstTrans != null && lstTrans.size() > 0) {
            String nextActivityDefineId = lstTrans.get(0).getDefineId();
            WorkFlowXml workXml =WorkFlowXmlUtil.getInstanceModel(info.getWorkFlowIntanceVo());
            ActivityModel nextModel = workXml.getActivity(nextActivityDefineId);

            List<PerformerModel> performerList = nextModel.getPerformerList();
            if (performerList != null && performerList.size() > 0){
                String roleId = "";
                List<PfRoleVo> roleList = sysUserService.getRoleListByUser(userId);
                for (PerformerModel performerModel : performerList) {
                    if (StringUtils.isNotBlank(performerModel.getRoleId())){
                        boolean isok = false;
                        for (PfRoleVo roleVo : roleList){
                            if (StringUtils.equals(performerModel.getRoleId(),roleVo.getRoleId())){
                                roleId = performerModel.getRoleId();
                                isok = true;
                                break;
                            }
                        }
                        if (isok){
                            break;
                        }
                    }
                }

                String activityRelType = "";
                if (transInfo.getTransType().equalsIgnoreCase("and"))
                    activityRelType = "and";
                else
                    activityRelType = "or";

                String activitysElement = "<Activitys RelType=\"" + activityRelType + "\"";
                activitysElement += " SendSMS= \"false\"";
                activitysElement += ">";
                String activityElement = "<Activity ";
                activityElement += " Id=\"" + nextActivityDefineId + "\">";
                String userInfoElement = "<UserInfo ";
                userInfoElement += " RoleId=\"" + roleId + "\"";
                userInfoElement += " Id=\"" + userId + "\">";
                userInfoElement += "</UserInfo>";
                activityElement += userInfoElement;
                activityElement += "</Activity>";
                activitysElement += activityElement;

                String remarkElement = "<ReMark>";
                String remarkTextElement = "<text>";
                remarkTextElement += "</text>";
                remarkElement += remarkTextElement + "</ReMark>";
                activitysElement += remarkElement + "</Activitys>";
                return activitysElement;
            }
        }
        return null;
    }
}
