package cn.gtmap.landtax.printexcel.access;

import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


public class ReadSheet {
	Log log = LogFactory.getLog(getClass().getName());

	public ReadSheet() {
	}

    /**
     * 第一列必需是序号
     * @param file EXCEL文件内容
     * @param fieldNames 字段名
     * @return
     */
	public List<Map<String, String>> execute(MultipartFile file, String[] fieldNames) {
        List<Map<String, String>> list = new ArrayList<Map<String, String>>();
        Workbook book = null;
        try {
            book = Workbook.getWorkbook(file.getInputStream());
            // 获得第一个工作表对象
            Sheet sheet = book.getSheet(0);
            int rows = sheet.getRows();
            int columns = sheet.getColumns();
            // 第一个有效单元格所在的行
            int firstValidRow = 0;
            // 第一个有效单元格所在的列
            int firstValidColumn = 0;
            // 最后一个有效单元格所在的列
            int lastValidColumn = 0;
            // 是否找到最后一个有效列（1：是；0：否）
            int flag = 0;
            // 判断第一个有效单元格从哪里开始
            for(int i=0;i<rows;i++){
                for(int j=0;j<columns;j++){
                    Cell cell = sheet.getCell(j, i);
                    String result = cell.getContents();
                    //去除字符串前后空格
                    result = result.trim();

                    if(firstValidRow == 0 && StringUtils.isNotEmpty(result)){
                        // 找到了第一个有效单元格
                        firstValidRow = i+1;
                        firstValidColumn = j;
                    }else if(firstValidRow > 0 && StringUtils.isEmpty(result)){
                        // 找到了最后一个有效列
                        lastValidColumn = j;
                        flag = 1;
                        break;
                    }
                }
                if(flag == 1){
                    break;
                }
            }

            int columnCount = fieldNames.length;
            // 有效列序号
            int index = 0;
            // 遍历有效单元格数据(行从firstValidRow行开始；列从firstValidColumn到lastValidColumn)
            for(int i=firstValidRow;i<rows;i++){
                //根据序号列判断上一行是否是最后一行，如果是，则终止循环
                Cell xhCell = sheet.getCell(firstValidColumn, i);
                String xh = xhCell.getContents();
                //如果某行的第一个有效列的单元格为空，则认为是最后一行
                if(StringUtils.isEmpty(xh)){
                    break;
                }

                Map<String, String> map = new HashMap<String, String>();
                list.add(map);
                for(int j=firstValidColumn+1;j<=firstValidColumn+columnCount;j++){
                    Cell cell = sheet.getCell(j, i);
                    String result = cell.getContents();
                    //去除字符串前后空格
                    result = result.trim();
                    map.put(fieldNames[index], result);
                    index++;
                }
                index = 0;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }finally{
            if(book!=null){
                book.close();
            }
        }

        return list;
	}
}
