/**   
 * @{#} SignListXml.java Create on 2008-9-9 上午10:49:26   
 *   
 * Copyright(c) 2008 by Jiangsu E.G.A.Technology LTD.  
 *
 * All right reserved. 
 */   
package cn.gtmap.landtax.print.sign;

import java.io.*;
import java.text.SimpleDateFormat;
import java.util.*;

import javax.servlet.http.HttpServletRequest;

import cn.gtmap.landtax.util.CommonUtil;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.GetMethod;

import com.gtis.util.*;

/**   
 * @author HeGuobing  
 * @version 1.0   
 */
public class SignListXml { 
	
	
	private List list=null;
	public SignListXml(List list) {
		this.list=list;
	}
	
	public String getXMLDataWithAutoSign(HttpServletRequest request)throws Exception {
		StringBuffer sb = new StringBuffer();
		Iterator it = list.iterator();
		int num=-1;
		while (it.hasNext()) {
			SignVo sign = (SignVo) it.next();
			sb.append(getSignXmlBySignVo(request,sign));
		}
		return sb.toString();
	}
	
	private StringBuffer getSignXmlBySignVo(HttpServletRequest request,SignVo sign)throws Exception{
		StringBuffer sb = new StringBuffer();
		if (sign != null) {
			sign = (SignVo) CommonUtil.initObj(sign, true, true, false);

			SimpleDateFormat sdf = new SimpleDateFormat("yyyy年MM月dd日");
			String retvalue = "";
			if (sign.getSignDate() != null) {
				retvalue = String.valueOf(sdf.format(sign.getSignDate()));
			}
			sb.append("<data name=\"");
			sb.append(sign.getSignKey());
			sb.append("_NAME\"");
			sb.append(" type=\"String\">");
			sb.append(sign.getSignName());
			sb.append("</data>");
			
			sb.append("<data name=\"");
			sb.append(sign.getSignKey());
			sb.append("_OPINION\"");
			sb.append(" type=\"String\">");
			if(sign.getSignOpinion()==null||"".equals(sign.getSignOpinion())) {
				sb.append(" ");
			}else{
				sb.append(sign.getSignOpinion() );
			}
			sb.append("</data>");
			
			sb.append("<data name=\"");
			sb.append(sign.getSignKey());
			sb.append("_Date\"");
			sb.append(" type=\"String\">");
			sb.append(retvalue);
			sb.append("</data>");
			
			sb.append("<data name=\"");
			sb.append(sign.getSignKey());
			sb.append("_PIC\"");
			sb.append(" type=\"image\">");
			sb.append( getSignPic(request,sign) );
			sb.append("</data>");
		}
		return sb;
	}
	
	/**
	 * 判断签名图片是否有内容，如果没有，则返回空，否则返回原路径
	 * @param
	 * @return
	 */
	private String getSignPic(HttpServletRequest request,SignVo signVo) {
		if (signVo.getSignId() == null|| signVo.getSignId().trim().length()==0){
			return "";
		}
    	StringBuffer autoSignPicUrl = new StringBuffer();
    	autoSignPicUrl.append(request.getScheme());
    	autoSignPicUrl.append("://");
    	autoSignPicUrl.append(request.getServerName());
    	autoSignPicUrl.append(":");
    	autoSignPicUrl.append(request.getServerPort());
    	autoSignPicUrl.append("/platform/formprint.action?r="+Math.random()+"&amp;datatype=signature&amp;signid=");
    	autoSignPicUrl.append(signVo.getSignId());
    	String picUrl = signVo.getSignPicUrl();
		if (picUrl == null|| picUrl.trim().length()==0){
			//如果默认没有自定义签名URL，则取平台自动签名
			if(hasSignPic(autoSignPicUrl.toString())){
				return autoSignPicUrl.toString();
			}else{
				return "";
			}
						
		}else{
			if (hasSignPic(picUrl)){
				return picUrl; 
			}else{
				return "";
			}
		}
		
	}
	
	/**
	 * 判断签名图片是否存在
	 * @param url
	 * @return
	 */
	private boolean hasSignPic(String url){
		url = url.replace("&amp;", "&");
		HttpClient client = new HttpClient();
		GetMethod httpGet = new GetMethod(url);
		try {
			client.executeMethod(httpGet);
			InputStream in = httpGet.getResponseBodyAsStream();
			int num = in.read();
			if (num > -1) {
				return true;
			} else {
				return false;
			}
		} catch (Exception e) {
			e.printStackTrace();
			return false;
		} finally {
			httpGet.releaseConnection();
		}
	}
	
	
}
  