package cn.gtmap.landtax.print;

import cn.gtmap.landtax.util.CommonUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import jxl.write.Label;
import jxl.write.WritableCellFormat;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;

import javax.servlet.http.HttpServletResponse;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

/**
 * Created by xuchao on 2015-04-01.
 */
public class PrintTjtzExcelUtil {
    public static  void printTjtzExcel(List list,String listJson,WritableSheet ws,int flag,Integer hs,WritableCellFormat contentFormat,WritableCellFormat nameFormat,WritableWorkbook wwb,HttpServletResponse response,String filePath) throws  Exception{
        JSONArray jsonArray = JSONArray.parseArray(listJson);
        setExcelContent(list,jsonArray, ws, flag,hs,contentFormat,nameFormat);
        wwb.write();
        wwb.close();

        CommonUtil.download(response, filePath, String.valueOf(new SimpleDateFormat("yyyyMMddHHmmss").format(new Date())) + ".xls");
    }


    public static  int setExcelContent(List list,JSONArray jsonArray,WritableSheet ws,int flag,Integer hs,WritableCellFormat contentFormat,WritableCellFormat nameFormat) throws  Exception{

        for(int i=0;i<jsonArray.size();i++){
            hs = hs + 1;
            JSONObject jsonObject = (JSONObject) jsonArray.get(i);
            for(int j=0;j<list.size();j++){
                Label label = null;
                if(j==0){
                    label = new Label(j,hs+1,reSetName(flag,jsonObject.getString(String.valueOf(list.get(j)))),nameFormat);
                }else{
                    label = new Label(j,hs+1,jsonObject.getString(String.valueOf(list.get(j))),contentFormat);
                }
                ws.addCell(label);
            }

            Object object = jsonObject.get("children");
            if(object!=null){
                Integer tempFlag = flag + 1;
                JSONArray childJsonArray = (JSONArray)object;
                hs = setExcelContent(list,childJsonArray,ws,tempFlag,hs,contentFormat,nameFormat);
            }

        }
        return hs;
    }

    public static String reSetName(int flag,String name){
        for(int i=0;i<flag;i++) {
            name = "  " + name;
        }
        return name;
    }
}
