package cn.gtmap.landtax.model.dictionary;

import org.apache.commons.lang.StringUtils;

/**
 * 宗地自用出租状态
 *
 * @author zenglihuan
 * @version 1.0, 2016/11/14
 */
public enum ZdZyczzt {
    ZY("01", "自用"),
    CZ("02", "出租"),
    ZYCZ("03", "部分自用部分出租"),
    K("04", "空"),
    XZ("05", "新增");
    private String dm;
    private String mc;

    private ZdZyczzt(String dm, String mc) {
        this.dm = dm;
        this.mc = mc;
    }

    @Override
    public String toString() {
        return dm;
    }

    public String getMc(){
        return this.mc;
    }

    public String getDm(){
        return this.dm;
    }


    public static String getMcByDm(String dm){
        if(StringUtils.isNotBlank(dm)){
            ZdZyczzt[] Zdzts = ZdZyczzt.values();
            for(int i=0;i<Zdzts.length;i++){
                if(Zdzts[i].getDm().equals(StringUtils.trim(dm))){
                    return Zdzts[i].getMc();
                }
            }
        }
        return null;


    }
}
