package cn.gtmap.landtax.model.dictionary;

import org.apache.commons.lang.StringUtils;

/**
 * 城镇土地用途
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2014/12/5
 */
public enum TdytZd {
    DM01("01","耕地"),
    DM011("011","水田"),
    DM012("012","水浇地"),
    DM013("013","旱地"),
    DM02("02","园地"),
    DM021("021","果园"),
    DM022("022","茶园"),
    DM023("023","其他园地"),
    DM03("03","林地"),
    DM031("031","有林地"),
    DM032("032","灌木林地"),
    DM033("033","其他林地"),
    DM04("04","草地"),
    DM041("041","天然牧草地"),
    DM042("042","人工牧草地"),
    DM043("043","其他草地"),
    DM05("05","商服用地"),
    DM051("051","批发零售用地"),
    DM052("052","住宿餐饮用地"),
    DM053("053","商务金融用地"),
    DM054("054","其他商服用地"),
    DM06("06","工矿仓储用地"),
    DM061("061","工业用地"),
    DM062("062","采矿用地"),
    DM063("063","仓储用地"),
    DM07("07","住宅用地"),
    DM071("071","城镇住宅用地"),
    DM072("072","农村宅基地"),
    DM08("08","公共管理与公共服务用地"),
    DM081("081","机关团体用地"),
    DM082("082","新闻出版用地"),
    DM083("083","科教用地"),
    DM084("084","医卫慈善用地"),
    DM085("085","文体娱乐用地"),
    DM086("086","公共设施用地"),
    DM087("087","公园与绿地"),
    DM088("088","风景名胜设施用地"),
    DM09("09","特殊用地"),
    DM091("091","军事设施用地"),
    DM092("092","使领馆用地"),
    DM093("093","监教场所用地"),
    DM094("094","宗教用地"),
    DM095("095","殡葬用地"),
    DM10("10","交通运输用地"),
    DM101("101","铁路用地"),
    DM102("102","公路用地"),
    DM103("103","街巷用地"),
    DM104("104","农村道路"),
    DM105("105","机场用地"),
    DM106("106","港口码头用地"),
    DM107("107","管道运输用地"),
    DM11("11","水域及水利设施用地"),
    DM111("111","河流水面"),
    DM112("112","湖泊水面"),
    DM113("113","水库水面"),
    DM114("114","坑塘水面"),
    DM115("115","沿海滩涂"),
    DM116("116","内陆滩涂"),
    DM117("117","沟渠"),
    DM118("118","水工建筑用地"),
    DM119("119","冰川及永久积雪"),
    DM12("12","其他土地"),
    DM121("121","空闲地"),
    DM122("122","设施农用地"),
    DM123("123","田坎"),
    DM124("124","盐碱地"),
    DM125("125","沼泽地"),
    DM126("126","沙地"),
    DM127("127","裸地"),
    DM20("20","城镇村及工矿用地"),
    DM201("201","城市"),
    DM202("202","建制镇"),
    DM203("203","村庄"),
    DM204("204","采矿用地"),
    DM205("205","风景名胜及特殊用地");


    private String dm;
    private String mc;

    private TdytZd(String dm, String mc) {
        this.dm = dm;
        this.mc = mc;
    }


    public String getMc(){
        return this.mc;
    }

    public String getDm(){
        return this.dm;
    }

    @Override
    public String toString() {
        return dm;
    }
    public static String getMcByDm(String dm){
        if(StringUtils.isNotBlank(dm)){
            TdytZd[] tdyts = TdytZd.values();
            for(int i=0;i<tdyts.length;i++){
                if(tdyts[i].getDm().equals(StringUtils.trim(dm))){
                    return tdyts[i].getMc();
                }
            }
        }
        return null;
    }
}
