package cn.gtmap.landtax.model.dictionary;

import org.apache.commons.lang.StringUtils;

/**
 * 土地取得方式
 * @author <a href="mailto:zhouzhiwei@gtmap.cn">zhouzhiwei</a>
 * @version 1.0, 2015/3/10
 */
public enum Tdqdfs {
    HB("01", "划拨"),
    CR("02", "出让"),
    ZL("03", "租赁"),
    QT("04", "其他");

    private String dm;
    private String mc;

    private Tdqdfs(String dm, String mc) {
        this.dm = dm;
        this.mc = mc;
    }


    public String getMc(){
        return this.mc;
    }

    public String getDm(){
        return this.dm;
    }

    @Override
    public String toString() {
        return dm;
    }
    public static String getMcByDm(String dm){
        if(StringUtils.isNotBlank(dm)){
            Tdqdfs[] tdyts = Tdqdfs.values();
            for(int i=0;i<tdyts.length;i++){
                if(tdyts[i].getDm().equals(StringUtils.trim(dm))){
                    return tdyts[i].getMc();
                }
            }
        }
        return null;
    }

    public static String getDmByMc(String mc){
        if(StringUtils.isNotBlank(mc)){
            Tdqdfs[] tdqdfs = Tdqdfs.values();
            for(int i=0;i<tdqdfs.length;i++){
                if(tdqdfs[i].getMc().equals(StringUtils.trim(mc))){
                    return tdqdfs[i].getDm();
                }
            }
        }
        return null;
    }
}
