package cn.gtmap.landtax.model.dictionary;

import org.apache.commons.lang.StringUtils;

/**
 * 税管状态
 *
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2014/6/26
 */
public enum Sssq {
    SBN("1", "上半年"),
    XBN("2", "下半年");

    private String dm;
    private String mc;

    private Sssq(String dm, String mc) {
        this.dm = dm;
        this.mc = mc;
    }

    @Override
    public String toString() {
        return dm;
    }

    public String getMc(){
        return this.mc;
    }

    public String getDm(){
        return this.dm;
    }


    public static String getMcByDm(String dm){
        if(StringUtils.isNotBlank(dm)){
            Sssq[] Sssqs = Sssq.values();
            for(int i=0;i<Sssqs.length;i++){
                if(Sssqs[i].getDm().equals(StringUtils.trim(dm))){
                    return Sssqs[i].getMc();
                }
            }
        }
        return null;


    }
}
