package cn.gtmap.landtax.model.dictionary;

import org.apache.commons.lang.StringUtils;

/**
 * 税管状态
 *
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2014/6/26
 */
public enum Sgzt {
    KGD("01", "控管户"),
    LZLGD("02", "漏征漏管户"),
    KZHSYD("03", "可转化税源户"),
    GR("04", "个人"),
    JGDW("05", "机关单位");
    private String dm;
    private String mc;

    private Sgzt(String dm, String mc) {
        this.dm = dm;
        this.mc = mc;
    }

    @Override
    public String toString() {
        return dm;
    }

    public String getMc(){
        return this.mc;
    }

    public String getDm(){
        return this.dm;
    }


    public static String getMcByDm(String dm){
        if(StringUtils.isNotBlank(dm)){
            Sgzt[] Sgzts = Sgzt.values();
            for(int i=0;i<Sgzts.length;i++){
                if(Sgzts[i].getDm().equals(StringUtils.trim(dm))){
                    return Sgzts[i].getMc();
                }
            }
        }
        return null;


    }
}
